_me = obj_list_load_chatgpt.prototype;
function obj_list_load_chatgpt(){};

_me.__constructor = async function() {
	this.__options.preload = 5;
	this.__options.active = false;
	this.__pendingConversations = [];

	gui._obeyEvent('ChatGPTConversationCreate', [this, '__ChatGPTConversationCreate']);
	gui._obeyEvent('ChatGPTConversationMessageCreate', [this, '__ChatGPTConversationMessageCreate']);
	gui._obeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
	gui._obeyEvent('ChatGPTConversationDelete', [this, '__ChatGPTConversationDelete']);
};

_me._active = function(b){
	if (Is.Boolean(b)){

		if (this.__updTime)
			clearInterval(this.__updTime);

		if (b){
			this.__updTime = setInterval(this.__updateTime.bind(this), 10000);
			this.__updateTime();
		}

		this.__options.active = b;
	}
	else
		return this.__options.active;
};

_me.__updateTime = function () {
	this._getChildObjects().forEach(function(obj) {
		obj.__updateTime && obj.__updateTime();
	});
};

_me._serverSort = function() {
	this.__skeletons = true;
	this.__render_skeletons();
	this.__loading = 0;
	this.__aRequestData.offset = 0;

	this._fetch();
};

_me._request = function() {
	this.__loading = 1;

	ChatGPT.conversationsList(this.__options.preload, this.__aRequestData.offset, async function(bOK, response) {
		if (bOK) {
			this._response(response);
		} else {
			if (this.__skeletons) {
				await this._clean();
				[].slice.call(this.__body.childNodes).reverse().forEach(function(elm){
					elm.parentNode.removeChild(elm);
				});
				this.__skeletons = false;
				this._oncount(0);
				setTimeout(function() {
					this._request();
				}.bind(this), 5000);
			}
		}
	}.bind(this));
};

_me._response = async function(aData, bUpdate) {

	if (this._destructed) return;

	if (this.__skeletons) {
		await this._clean();
		[].slice.call(this.__body.childNodes).reverse().forEach(function(elm){
			elm.parentNode.removeChild(elm);
		});
		this.__skeletons = false;
	}

	for (var data of aData) {
		this.__aRequestData.offset++;

		if (!this.__aData[data.id]) {
			await this.__item(data);
		}
	}

	if (this._oncount) {
		this._oncount(!Is.Empty(this.__aData));
	}

	if (aData.length === this.__options.preload) {
		this.__loading = 0;
	}

	if (!bUpdate) {
		this._fetch();
	}
};

_me.__render_skeletons = function() {
	while (this._getAnchor('main').scrollHeight < this._getAnchor('main').clientHeight) {
		this._create('item', 'obj_threads_item', this._row().anchor, 'skeleton', {skeleton: true, gpt: true});
	}
};

_me.__item = async function(aData, bTop){
	if (!(aData.messages || []).length) {
		return;
	}
	var row = this._row('', '', aData.id, bTop);

	aData.gpt = true;
	this.__aData[aData.id] = {
		data: aData,
		anchor: row.anchor
	}

	this.__aData[aData.id].obj = await this._create('item', 'obj_threads_item', row.anchor,'', aData);

	//Bind Top animation
	if (bTop){
		addcss(row.elm,'anim-top');
		setTimeout(function(){
			removecss(row.elm, 'anim-top');
		}, 400);
	}

	if (this._oncount) {
		this._oncount(!Is.Empty(this.__aData));
	}
};

_me.__ChatGPTConversationCreate = function(conversation) {
	this.__pendingConversations.push(conversation);
};

_me.__ChatGPTConversationMessageCreate = function(message) {
	this.__pendingConversations = this.__pendingConversations.filter(async function(conversation) {
		if (conversation === message.conversation && conversation.messages.length >= 2) {
			if (!this.__aData[conversation.id]) {
				await this.__item(conversation, true);
			}
			return false;
		}

		return true;
	}, this);
};

_me.__ChatGPTConversationUpdate = async function(conversation) {
	if (this.__aData[conversation.id]) {
		this.__moveConversation(conversation.id);
	} else {
		await this.__item(conversation, true);
	}
};

_me.__ChatGPTConversationDelete = function(conversation) {
	if (!this.__aData[conversation.id]) {
		return;
	}

	this.__aData[conversation.id].obj._destruct();
	var anchor = this._getAnchor(this.__aData[conversation.id].anchor);
	anchor && anchor.parentElement.removeChild(anchor);
	delete this.__aData[conversation.id];

	for (var i in Gui.__detachedWindows) {
		if (Gui.__detachedWindows[i].component.__aData === conversation) {
			Gui.__detachedWindows[i].close();
			break;
		}
	}

	if (this._oncount) {
		this._oncount(!Is.Empty(this.__aData));
	}
	this._fetch();
}

_me.__moveConversation = function(id){
	//Move in DOM with animation
	var elm = (this.__aData[id].obj._main || {}).parentElement;
	if (elm && this._getAnchor('main').children[0] !== elm){
		//clone original
		var eClone = elm.cloneNode(true);
		//animate clone
		addcss(eClone,'anim-move');
		//switch clone with original
		this.__body.replaceChild(eClone, elm);
		//animate node
		addcss(elm,'anim-top');
		//insert node to the top
		this.__body.insertBefore(elm, this.__body.firstChild);

		//remove animations from node & remove clone
		setTimeout(function(){
			try{removecss(elm, 'anim-top');}catch{
				//
			}
			try{eClone.parentNode.removeChild(eClone);}catch{
				//
			}
		}, 1400);
	}
};

_me._oncontext = async function(e) {
	var elm = e.target;
	var section = elm.closest('section');
	if (section) {
		section.classList.add('active');
		e.preventDefault();

		var cmenu = await this._gui._create("cmenu", "obj_context", '', '', this);

		await cmenu._fill([
			{
				title: 'CHATGPT::DELETE_CONVERSATION',
				arg: [this, '__deleteConversation', [section.getAttribute('rel')]]
			}
		]);
		cmenu._place(e.clientX, e.clientY);
		cmenu._onclose = function() {
			section.classList.remove('active');
		};
	}
};

_me.__deleteConversation = function(id) {
	ChatGPT.getConversation(id, function(bOK, conversation) {
		bOK && conversation.delete();
	});
}
