_me = obj_input_calendar.prototype;
function obj_input_calendar() {};

_me.__constructor = async function (empty, bNoEmpty, opt) {
	await initPRO.prototype._setupCalendar();

	this.__defaultEmptyLabel = ' ';

	var me = this;
	await this._create('input', 'obj_input','main','fit');

	this.__opt = opt || {};
	if (this.__opt.week)
		addcss(this._main, 'week');

	if (empty) {
		this.__value = this.__defaultEmptyLabel;
		this.__empty = true;
	} else {
		this.__bNoEmpty = bNoEmpty;
		this.__value = new IcewarpDate();
		this.__empty = false;
		this._value(this.__value, true);
	}

	// set listener to input, to update calendar when new date is valid YYYY-MM-DD
	this.input.__eIN.addEventListener('input', function(evt) {
		var newValue = evt.target.value;
		
		if (newValue.length > 10) {
			evt.target.value = newValue.substring(0, 10);
		}

		if (newValue.match(/^\d{4}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])$/)) {
			me._value(
				new IcewarpDate(newValue, { format: 'YYYY-MM-DD' }), 
				true, 
				'YYYY-MM-DD'
			);
		}
	});

	this.input._onkeydown = function (e) {
		// hide calendar pop-up when Enter, Tab or Escape is pressed
		if ((e.keyCode === 27 || e.keyCode === 9 || e.keyCode === 13) && me.block) {
			me.__hideCal();
			e.stopPropagation();
		}
	};

	this.input._main.onclick = function (e) {
		if (me.block && me.block._destructed == false) {
			if (e.target == this)
				return true;
		} else
		if (e.target == this)
			me.input._onclick();

		e.stopPropagation();
		e.preventDefault();
	};

	this.input._onclick = function () {
		if (!this._disabled()) {
			if (me.block && me.block._destructed == false)
				me.__hideCal();
			else
				me.__showCal();
		}

		return true;
	};

	//Inherit noborder css prop
	if (hascss(this._main,'noborder')){
		addcss(this.input._main,'noborder');
	}
	if (hascss(this._main,'bold')){
		addcss(this.input._main,'bold');
	}
};

_me._defaultEmptyLabel = function(v) {
	if (v) {
		this.__defaultEmptyLabel = v;
		if (this.__empty) {
			this.input._value(v);
		}
		return this;
	}

	return v;
};

_me._weekMode = function(b){
	this.__opt.week = b;
	if (b){
		addcss(this._main, 'week');
		this.input._value(getLang('DATES::WEEK2')  +' '+ this.__value.week() +', '+ this.__value.format('L'));
	}
	else{
		removecss(this._main, 'week');
		this.input._value(this.__value.format('L'));
	}
};

_me.__showCal = async function () {
	// set date format to YYYY-MM-DD
	var date = this.__value;
	this.__value && this.__value !== ' ' && this.input._value(this.__value.format('YYYY-MM-DD'), true);

	var me = this,
		pos = getSize(this.input._main);

	if (!this.block || this.block._destructed) {
		this.block = await gui._create('calendar_block', 'obj_block_ext_uni','','',this._main);
		await this.block._create('calendar', 'obj_calendar','','bubble2 small', this.__opt);
		this.block.calendar._value(this._value(), true);
		this.block._componentWillUnmount = function(){ 
			if (me._destructed) {
				return;
			}
			// set date format back, unfocus the input node
			if (me.__value && me.__value !== ' ') {
				if (me.__opt.week){
					me.input._value(getLang('DATES::WEEK2')  +' '+ me.__value.week() +', '+ me.__value.format('L'), true);
				} else {
					me.input._value(me.__value.format('L'), true);
				}
			}

			me.input.__eIN.blur();
		};

		if (!this.__bNoEmpty) {
			this.block.calendar.empty._main.classList.add('show');
			this.block.calendar.empty._onclick = function () {
				me._value('empty', true);
				me.__hideCal();
				me._focus();

				if (me._ondateselect)
					me._ondateselect();
				me.__exeEvent('_ondateselect', null, {"owner": me});
			};
		}

		this.block.calendar._onchange = async function () {
				var dDate = await this._value();

				me.__empty = false;
				// save DATE
				me.__value = dDate;

				me.input._value(dDate.format('L'), true);

				me.__hideCal();
				me._focus();

				if (me.__restrictions)
					me.__check();

				if (me._ondateselect)
					me._ondateselect(dDate);
				me.__exeEvent('_ondateselect', null, {"date": dDate, "owner": me});
		};
	}

	date && date !== ' ' && this.block.calendar._setDate(date.year(), date.month());

	//HEIGHT
	var h = 0;
	if (window.innerHeight)
		h = window.innerHeight;
	else
	if (window.document.body)
		h = window.document.body.clientHeight;

	var width = this.__opt.week ? 450 : 415;
	var posh = Math.max(this.block.calendar._main.scrollHeight, 256);
	var w = document.body.offsetWidth;
	var x = pos.x;
	if (gui._rtl){
		x = (pos.x + pos.w) - width;
		if (x<0) x = 0;
	}
	else
	if (pos.x + width > w)
		x = w - width;

	if (h < (pos.y + posh))
		this.block._place(x, pos.y - posh + 1, '', posh, 'bottom');
	else
		this.block._place(x, pos.y + pos.h + 4, '', posh, 'top');
};

_me.__hideCal = function () {
	setTimeout(function(){
		if (this.block) {
			this.block._destruct();
			this.block = null;
			delete this.block;
		}
	}.bind(this), 0);
};

_me._value = function (aData, bNoUpdate, sFormat) {

	if (aData) {
		this.__empty = false;

		if (aData instanceof IcewarpDate) {
			this.__value = aData;
		} else if (Is.Number(aData) || Is.String(aData) && !isNaN(parseInt(aData, 10))) {
			aData = parseInt(aData, 10);
			if (aData == 0) {
				this.__value = '';
				this.__empty = true;
			} else {
				if (sFormat === false) {
					this.__value = IcewarpDate.unix(aData);
				} else {
					this.__value = new IcewarpDate(aData, {format: IcewarpDate.JULIAN});
				}
			}
		} else if (aData == 'empty') {
			this.__value = '';
			this.__empty = true;
		} else {
			this.__value = new IcewarpDate(aData).startOf('day');
		}

		// set new date to calendar
		if (this.block && this.block.calendar) {
			if (this.__empty) {
				var oDate = new IcewarpDate().startOf('day');
				this.block.calendar._value(oDate, true);
			} else
				this.block.calendar._value(this.__value, bNoUpdate);
		}

		// set the proper value into the visible input box
		if (this.__empty || +this.__value === 0) {
			this.input._value(this.__defaultEmptyLabel, bNoUpdate);

		}
		else
		if (this.__opt.week){
			this.input._value(getLang('DATES::WEEK2')  + ' ' + this.__value.week() +', '+ this.__value.format('L'), bNoUpdate);
		} else {
			this.input._value(this.__value.format(sFormat ? sFormat : 'L'), bNoUpdate);
		}

		// If restricted, check for changes
		if (this.__restrictions) {
			this.__check();
		}

		if (!bNoUpdate){
			if (this._ondateselect) {
				this._ondateselect();
			}
			this.__exeEvent('_ondateselect', null, {"owner": this});
		}

	} else {
		if (this.__empty) {
			return '';
		}
		return this.__value ? sFormat === false ? this.__value.unix() : this.__value.format(sFormat || IcewarpDate.JULIAN) : '';
	}
};

_me._getObjectDate = function () {
	if (this.__empty)
		return '';
	return this.__value;
};

/**
 * @brief: User definable date input parse function
 **/
_me._parseDate = function (y, m, d) {
	var tmpDate = new IcewarpDate([y, m - 1, d, 12, 0, 0]);

	if (d != tmpDate.getDate())
		tmpDate.hour(25);

	return tmpDate.format('L');
};

_me._disabled = function (b) {
	if (typeof b == 'undefined')
		return this.input._disabled();
	else
		this.input._disabled(b);
};


/**
 * @brief: Date picker implements it's own restrictions and test
 **/
_me._restrict = function () {
	this.__restrictions = true;
	this.__check();
};
_me.__check = function () {
	// Currently only checking if empty, could be improved to check if date exists
	if (this.__empty)
		addcss(this._main, 'error');
	else
		removecss(this._main, 'error');
};

//FOCUS
_me._tabIndex = function (sContainer, i, oDock) {
	this.input._tabIndex(sContainer, i, oDock);
};
_me._focus = function (b) {
	return this.input._focus(b);
};
