/*****************************************************
 * Extension script: Input form object
 *
 * INHERITS FROM obj_form_generic
 *    _me._value
 *    _me._disabled
 *    _me.__update
 *
 * EVN: _onblur
 *      _onfocus
 *      _onsubmit
 *      _onclose
 *      _onerror
 *
 *****************************************************/

_me = obj_input.prototype;
function obj_input(){};

/**
 * @brief: CONSTRUCTOR, create input form object to __eIN variable
 * @date : 20.4.2006 17:24:21
 **/
_me.__constructor = async function(){
    var me = this;

	/* creates ELM directly, because simlicity of object */
	this.__eIN = mkElement('input',{
				"type":'search',
				// "name":this._pathName+'#main',
				"id":this._pathName+'#main',
				"className":this._type!='obj_input'?'obj_input '+this._type:'obj_input'
				});

	if (this._type == 'obj_password'){
		this.__eIN.setAttribute('type','password');
		AttachEvent(this.__eIN, 'onkeydown', function(e){
			var is_alpha = /^[A-Za-z]$/.test(e.key);
			var is_lowercase = /^[a-z]$/.test(e.key);

			if(is_alpha && is_lowercase === e.shiftKey && e.key.length === 1)
				addcss(this,'caps');
			else
				removecss(this,'caps');
		});
	} else if (this._type === 'obj_input') {
		this.__eIN.setAttribute('data-1p-ignore', '');
	}
	this.__eIN.setAttribute('autocomplete', "off");
	this._main.setAttribute('autocomplete', "off");

	this._main.appendChild(this.__eIN);

	this.__eLBL = mkElement('label', {className:'unselectable'});
	this._main.appendChild(this.__eLBL);

	// ONKEYUP
	this.__eIN.onkeyup = function(e){
		me._main.classList.toggle('empty', !me.__eIN.value);
		if (me._onkeyup && me._onkeyup(e) == false) return false;
		me.__exeEvent('onkeyup',e,{"owner":me});
	};

	// KEY DOWN
	this.__eIN.onkeydown = function(e){
		switch (e.keyCode) {
			// Enter
			case 13:
				//stop FFox download dialog
				if (e.ctrlKey || e.metaKey){
					e.stopPropagation();
				}
				break;
			// Esc
			case 27:
				if (me._onclose && me._onclose(e) == false) return false;
				break;
			// Tab
			case 9 : break;
		}
		
		me._main.classList.toggle('empty', !me.__eIN.value);

		if (me._onkeydown && me._onkeydown(e) === false) return false;
        me.__exeEvent('onkeydown',e,{"owner":me});

		// Enter
		if (e.keyCode == 13 && me._onsubmit)
			setTimeout(function () {
				try {
					me._onsubmit({
						ctrlKey: e.ctrlKey || e.metaKey
					});
				} catch (r) {
					 console.log(this._name || false, r);
				}
			}, 0);

		if (e.keyCode === 13) {
			e.preventDefault();
		}
	};

	AttachEvent(this.__eIN, 'onkeyup', function(e){
		if (e.getModifierState && this.getAttribute('type') === 'password') {
			this.setCustomValidity(e.getModifierState('CapsLock') ? getLang('ERROR::CAPSLOCK') : '');
			this.reportValidity();
		}
		if (me._onchange) me._onchange();
		me.__exeEvent('change',null,{"owner":me});
	});
	AttachEvent(this.__eIN, 'onpaste', function(e){
		if (me._onpaste) {
			me._onpaste(e);
		} else {
			var start = me.__eIN.selectionStart;
			var toPaste = (e.clipboardData.getData('text/plain') || e.clipboardData.getData('text')).replace(/[\u200B-\u200D\uFEFF]/g, '').trim();
			me.__eIN.ownerDocument.execCommand("insertText", false, toPaste);
			me.__eIN.selectionStart = me.__eIN.selectionEnd = start + toPaste.length;
			e.preventDefault();
		}
		if (me._onchange) me._onchange();
		me.__exeEvent('change',null,{"owner":me});
	});
	AttachEvent(this.__eIN, 'oninput', function(){
		if (me._onchange) me._onchange();
		me.__exeEvent('change',null,{"owner":me});
	});
	

	// ONFOCUS
	this.__eIN.onfocus = function(e){
		me.__hasFocus = true;

		if (me._onfocus) me._onfocus(e);
		me.__exeEvent('onfocus',e,{"owner":me});

		addcss(me._main, 'focus');

		return true;
	};

	// ONBLUR
	this.__eIN.onblur = function(e){
        me.__hasFocus = false;

        if (me._type == 'obj_password')
			removecss(this,'caps');

		if (me._onblur && me._onblur(e) === false) return false;
		me.__exeEvent('onblur',e,{"owner":me});

		removecss(me._main, 'focus');

		return true;
	};

	this.__eIN.onclick = function(e){
		if (me._onclick && me._onclick(e) === false)
			return false;

		me.__exeEvent('click',e,{"owner":me});
		return true;
	};

	this._main.onfocus = function(){
		me._focus(true);
	};

	// Drag & Drop
	if (window.FormData){
		this.__eIN.addEventListener("drag", function(){
			gui.frm_main.__filedrag = false;
		}, false);
		this.__eIN.addEventListener("dragstart", function(){
			gui.frm_main.__filedrag = false;
		}, false);
		this.__eIN.addEventListener("dragend", function(){
            gui.frm_main.__filedrag = true;
		}, true);
	}

	me._main.classList.toggle('empty', !me.__eIN.value);
};

_me._maxlength = function(i){
	if (Is.Defined(i)){
		if (i>0)
			this.__eIN.setAttribute('maxlength', i);
		else
			this.__eIN.removeAttribute('maxlength');
	}
	else
		return this.__eIN.getAttribute('maxlength') || 0;
};

_me._value = function(v,bSkipPH){
	if (Is.Defined(v)){

		this.__eLBL.innerText = (this.__eIN.value = v) || this.__eIN.placeholder;

		if (this.__restrictions && this.__restrictions.length)
			this.__check();

		this.__showMaskHelper();
		this._main.classList.toggle('empty', !this.__eIN.value);

		if (!bSkipPH){
			if (this._onchange) this._onchange();
			this.__exeEvent('change',null,{"owner":this});
		}

		return this;
	}
	else
		return this.__eIN.value;
};

_me._readonly = function(b){
	if (Is.Defined(b)){
		if (b){
			this.__eIN.setAttribute('readonly', 'readonly');
			addcss(this._main,'readonly');
		}
		else{
			this.__eIN.removeAttribute('readonly');
			removecss(this._main,'readonly');
		}
	}
	else
		return this.__eIN.hasAttribute('readonly');
};

_me._hasFocus = function(){
	return this.__eIN.__hasFocus;
};

_me._getCartPos = function(){
	return this.__eIN.selectionStart;
};

_me._setRange = function(pos1,pos2){
	pos1 = pos1 || 0;

	try{
		this.__eIN.setSelectionRange(pos1, pos2 || pos1);
	}
	catch(r){ console.log(this._name||false,r) }

	this._focus(true);
};

_me._select = function() {
	this._setRange(0,this.__eIN.value.length);
};

_me._placeholder = function(str){
	if (Is.Defined(str)){
		this.__eIN.placeholder = str.replace(/Name/, 'N​ame');
		if (this.__eIN.value === '')
			this.__eLBL.innerText = this.__eIN.placeholder;
	}
	else
		return this.__eIN.placeholder;
};

/**
 * Mouse over MASK images
 *
 * aButtons param
 *      ID:[<ico url>,<title>,<show state>]
 *          <show state>	0 = onShow
 *                          1 = onHide
 *                          2 = always
 **/

_me.__setMask = function(aButtons,aHandler,bMouseDown){
	if (aButtons){

		this.__mask_size = [0,0]; //[<show width>,<hide width>]

		if (!this.__mask){
			this._main.appendChild((this.__mask = mkElement('div',{'className':'mask_container'})));
			this._obeyEvent('change',[this,'__showMaskHelper']);
			this._obeyEvent('onkeyup',[this,'__showMaskHelper']);
		}
		else
			this.__mask.innerHTML = '';

		var elm;
		for (var i in aButtons){
			elm = mkElement('a',{'href':'',rel:i,title:aButtons[i][1] || ''});
			elm.innerHTML = aButtons[i][0];

			switch (parseInt(aButtons[i][2] || 0)){
				case 1:
					elm.className = 'hide';
					this.__mask_size[1] += 20;
					break;
				case 2:
					elm.className = 'always';
					this.__mask_size[1] += 20;
				default:
					this.__mask_size[0] += 20;
					break;
			}

			this.__mask.appendChild(elm);
		}

		if (this.__mask_size[0])
			this.__mask_size[0] += 5;
		if (this.__mask_size[1])
			this.__mask_size[1] += 5;

		if (aHandler){
			var me = this;
			var mouse_down = false;
			var timeout;

			var event_handler = function(e){
				var elm = e.target;

				if (timeout)
					clearTimeout(timeout);

				e.preventDefault();
				e.stopPropagation();

				if (!me._destructed){
					if (elm.tagName === 'A' && elm.rel)
						executeCallbackFunction(aHandler,elm.rel,me);

					timeout = setTimeout(function() {
						!me._destructed && mouse_down && event_handler(e);
					}, 175);
				}
			};

			if (bMouseDown) {
				this.__mask.onmousedown = function(e) {
					mouse_down = true;
					event_handler(e);
				};
				this.__mask.onmouseup = function() {
					mouse_down = false;
				};
				this.__mask.onmouseout = function() {
					mouse_down = false;
				};

			} else {
				this.__mask.onclick = event_handler;
			}
		}
	}
	else
	if (this.__mask){
		this.__mask.removeChild(this.__mask);
		this.__eIN.style[gui._rtl?'paddingLeft':'paddingRight'] = '';
		this.__eLBL.style[gui._rtl?'paddingLeft':'paddingRight'] = '';
		this._disobeyEvent('change',[this,'__showMaskHelper']);
		this._disobeyEvent('onkeyup',[this,'__showMaskHelper']);
	}

	return this;
};
_me.__showMask = function(){
	if (this.__mask){
		addcss(this.__mask,'show');

		this.__mask.style.width = this.__mask_size[0] + 'px';
		this.__eIN.style[gui._rtl?'paddingLeft':'paddingRight'] = this.__mask_size[0] + 'px';
		this.__eLBL.style[gui._rtl?'paddingLeft':'paddingRight'] = this.__mask_size[0] + 10 + 'px';
	}
};
_me.__hideMask = function(){
	if (this.__mask){
		removecss(this.__mask,'show');

		this.__mask.style.width = this.__mask_size[1] + 'px';
		this.__eIN.style[gui._rtl?'paddingLeft':'paddingRight'] = this.__mask_size[1] + 10 + 'px';
		this.__eLBL.style[gui._rtl?'paddingLeft':'paddingRight'] = this.__mask_size[1] + 10 + 'px';
	}
};
_me.__showMaskHelper = function(){
	if (this._value())
		this.__showMask();
	else
		this.__hideMask();
};
