function obj_initial_loader() { };

obj_initial_loader.prototype = {
	__constructor: async function() {
		var tips_enabled = GWOthers.getItem('LAYOUT_SETTINGS', 'disable_loading_tips') == 0;
		var tip = this.__tips[Math.floor(Math.random() * this.__tips.length)];

		await this._draw('obj_initial_loader', 'main', {
			tip: tips_enabled && {
				image: './client/skins/default/images/preloader/' + tip + (devicePixelRatio > 1 ? '@2x' : '') + '.png',
				label: getLang('PRELOADER::TIP_' + tip),
				header: getLang('PRELOADER::HEADER_' + tip)
			}
		});
		gui._main.classList.add('initial_loading');
	},

	__tips: ['move', 'autohide', 'rightclick'],

	_value: function (sValue) {
		this._getAnchor('state').textContent = sValue || '';

		return this;
	},

	_remove: function () {
		// clearTimeout(this.__timeout);
		this._main.classList.add('removing');
		setTimeout(function() {
			this._destruct();
		}.bind(this), 300);
		gui._main.classList.remove('initial_loading');
	}
};