_me = obj_im.prototype;
function obj_im(){};

// Note: also file skins/default/inc/obj_im.js is used

_me.__constructor = async function() {
	await storage.library('wordGen', 'wordGen');
	var me = this;
	this.__skeletons = false;

	this._telemetry = 'id'; //telemetry log
	this.__rowHeight = 44;

	this.__avatarCache = {};
	this.__activeUser = {};
	this.__chats = [];
	this.__search = '';

	this.__noRefresh = false;
	this.__doRefresh = false;

	this.__deliveredTimeout = {};

	this.__scrollTimeoutId;

	//IM focus
	var hasFocus = false;
	this._main.setAttribute('tabindex', -1);
	AttachEvent(this._main, 'onfocus', function () {
		setTimeout(function() {
			hasFocus = true;
		}, 5);
	});
	AttachEvent(this._main, 'onblur', function () {
		hasFocus = false;
	});

	function onKeydownHandler(e) {
		if (hasFocus && !e.isComposing && e.keyCode !== 229 && (e.key || '').length === 1){
			return me._search_focus();
		}
		var active;
		for (var i in me.__activeUser) {
			active = i;
			break;
		}
		switch(e.key) {
			case 'ArrowDown':
				if ((active = (me._getUsrRow(active, true) || {}).nextElementSibling || me._getAnchor('body').firstElementChild)) {
					me._activate(active.getAttribute('iw-jid'));
				}
				break;
			case 'ArrowUp':
				if ((active = (me._getUsrRow(active, true) || {}).previousElementSibling || me._getAnchor('body').lastElementChild)) {
					me._activate(active.getAttribute('iw-jid'));
				}
				break;
			case 'Enter':
				if (active && me._main.querySelector('[iw-jid="' + active + '"]')) {
					me._chat(active);
					me._parent.inp_search._value('');
					me._search('');
				}
		}
	}

	this.__body = this._getAnchor('body');
	var scroll = this.__body.parentNode;

	AttachEvent(scroll, 'onfocus', function () {
		setTimeout(function() {
			hasFocus = true;
		}, 5);
	});
	AttachEvent(scroll, 'onblur', function () {
		hasFocus = false;
	});

	AttachEvent(this._main, 'onkeydown', onKeydownHandler);
	AttachEvent(scroll, 'onkeydown', onKeydownHandler);

	this.__xmpp = gui.socket.xmpp;

	await this._create('scrollbar', 'obj_scrollbar');
	this.scrollbar._scrollbar(scroll, scroll.parentNode);

	// on scroll handler - start re-render (calling _fill) of content when it is necessary
	scroll.onscroll = function() {
		// do not scroll immediately - scroll when there is no new scroll action
		me.__scrollTimeoutId = setTimeout(function() {
			me.__showVisibleAvatars();
		}, 50);
	};

	this.__body.onmousedown = function (e){
		var elm = e.target,
			id;

		if (me.__dndtimer){
			window.clearTimeout(me.__dndtimer);
			delete me.__dndtimer;
		}

		if (elm != this){
			switch (elm.tagName){
			case 'H3':
			case 'H4':
			case 'SPAN':
			case 'IMG':
				if (!(elm = Is.Child(elm,'DIV')))
					break;

			case 'DIV':
				if ((id = elm.getAttribute('iw-jid'))){

					//Allow Contextmenu over multiple selection
					if (e.button>0 && me.__activeUser[id]) return;

					//Drag and Drop
					if (e.button == 0){
						var x = e.clientX, y = e.clientY;

						gui._obeyEvent('mouseup',[me,'__dndDispatch']);

						me.__dndtimer = setTimeout(function(){
							if (!me.__activeUser[id])
								me._activate(id,e.ctrlKey || e.metaKey);

							me.__initdrag(id,'jabber',x,y);
						}, 250);
					}
				}
			}
		}
	};

	this.__body.onclick = async function(e){
		var elm = e.target,
			id;

		if (elm != this){
			switch (elm.tagName){
			case 'EM':
				e.preventDefault();
				if (hascss(elm,'menu')){
					var aPos = getSize(elm);
					this.oncontextmenu({target:elm,clientX:aPos.x,clientY:aPos.y+(aPos.h/2)});

					e.stopPropagation();
				}
				else
				if (hascss(elm,'video') && (elm = Is.Child(elm,'DIV')) && (id = elm.getAttribute('iw-jid'))){
					await storage.library('wm_conference');
					wm_conference.create(function(conference) {
						conference.join();
						conference.invite([id]);
					}, {
						subject: getLang('CONFERENCE::BETWEEN', [
							dataSet.get('main', ['fullname']),
							dataSet.get('xmpp', ['roster', id, 'name'])
						])
					});
				}
				break;

			case 'H3':
			case 'H4':
			case 'SPAN':
			case 'IMG':
				if (!(elm = Is.Child(elm,'DIV')))
					break;

			case 'DIV':
				if ((id = elm.getAttribute('iw-jid'))){

					//Allow Contextmenu over multiple selection
					if (e.button>0 && me.__activeUser[id]) return;

					me._activate(id,e.ctrlKey || e.metaKey);
				}
			}
		}
	};

	this.__body.ondblclick = function (e){
		var elm = e.target,
			id;

		if (elm != this){
			switch (elm.tagName){
			case 'H3':
			case 'H4':
			case 'SPAN':
			case 'IMG':
				if (!(elm = Is.Child(elm,'DIV')))
					break;

			case 'DIV':
				if ((id = elm.getAttribute('iw-jid'))){
					me._activate(id,e.ctrlKey || e.metaKey);
					me._chat(id);
					me._parent.inp_search._value('');
					me._search('');
				}
			}
		}
	};

	this.__body.onmouseover = function(e){
		var elm = e.target,
			id;

		switch (elm.tagName){
		case 'H3':
		case 'H4':
		case 'SPAN':
		case 'IMG':
			if (!(elm = Is.Child(elm,'DIV')))
				return;
		}

		if ((id = elm.getAttribute('iw-jid'))){
			var iTime = dataSet.get('xmpp', ['roster', id, 'status_time']);

			if (iTime){
				var d = new IcewarpDate(),
					t = d.unix() - iTime,
					s = dataSet.get('xmpp', ['roster', id, 'show']) || 'offline';

				s = getLang('STATUS::'+s.toUpperCase(),'',2);

				if (s){
					if (t<60)
						gui.tooltip._show(elm, getLang('IM::STATUS_SEC', [s]), { y: getSize(elm).y - 28 });
					else
					if (t<3600)
						gui.tooltip._show(elm, getLang('IM::STATUS_MIN', [s, Math.ceil(t/60)]), { y: getSize(elm).y - 28 });
					else
						gui.tooltip._show(elm, getLang('IM::STATUS_HOUR', [s, Math.ceil(t/3600)]), { y: getSize(elm).y - 28 });
				}
			}
		}
	};

	//CONTEXT MENU
	this.__body.oncontextmenu = async function(e){
		var elm = e.target,
			aMenu, bLogin = !me._is_active(), id;

		switch (elm.tagName){
		case 'H3':
		case 'H4':
		case 'SPAN':
		case 'IMG':
		case 'EM':
			if (!(elm = Is.Child(elm,'DIV')))
				return false;
		}

		if ((id = elm.getAttribute('iw-jid'))){
			var	bManagement = GWOthers.getItem('RESTRICTIONS','DISABLE_IM_CONTACT_MANAGEMENT')==1;

			//user's JID
			if (elm.tagName == 'DIV'){

				//contextmenu on multiple
				if (me.__activeUser[id] && count(me.__activeUser)>1)
            	    id = '';
            	else
            		me._activate(id);

				//contextmenu on multiple
				if (id === ''){
					aMenu = [
						{'title':'IM::SEND_MAIL','arg':{'method':'send'}},
						{'title':'-'},
						{'title':'MAIN_MENU::FILTER','arg':{'method':'search'}},
						{'title':'-'},
						{'title':'MAIN_MENU::DELETE','arg':{'method':'user_remove'},disabled:bLogin || bManagement}
					];
				}
				else{
					aMenu = [{'title':'IM::CHAT','arg':{'method':'chat',id:id},disabled:bLogin}];

					if (window.sPrimaryAccountSIP && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1) {
						aMenu.push({'title':'IM::AUDIO_CALL','arg':{'method':'call',id:id},disabled:bLogin || id.indexOf('@')<0});
						aMenu.push({'title':'IM::VIDEO_CALL','arg':{'method':'call_video',id:id},disabled:bLogin || id.indexOf('@')<0 || IceSIP && !IceSIP.supported()});
					}

					if (window.sPrimaryAccountCONFERENCE)
						aMenu.push({'title': (dataSet.get('conference',['live'])?'IM::INVITE':'IM::CONFERENCE'),'arg':{'method':'conference',id:id},disabled:bLogin || id.indexOf('@')<0});

					aMenu.push(
						{'title':'IM::SEND_MAIL','arg':{'method':'send',id:id},disabled:id.indexOf('@')<0},
						//{'title':'IM::SEND_FILE','arg':{'method':'file',id:id},disabled:bLogin},
						{'title':'-'},
						{'title':'IM::VCARD','arg':{'method':'vcard',id:id},disabled:bLogin || id.indexOf('@')<0},
						{'title':'-'},
						{'title':'IM::ADD','arg':{'method':'user_add',id:id},disabled:bLogin || bManagement},
						{'title':'IM::ADD_GATEWAY','arg':{'method':'user_gate',id:id},disabled:bLogin},
						{'title':'-'},
						{'title':'IM::RENAME','arg':{'method':'user_rename',id:id},disabled:bLogin},
						{'title':'IM::SUBSCRIPTION',nodes:[
							{'title':'IM::SEND','arg':{method:'sub_add',id:id}},
							{'title':'IM::REQUEST','arg':{method:'sub_get',id:id}},
							{'title':'IM::REMOVE','arg':{method:'sub_remove',id:id}}
						],disabled:bLogin},
						{'title':'-'}
					);

					if (GWOthers.getItem('IM', 'hide_offline_contacts') != '1')
						aMenu.push(
							{'title':'IM::SHOW_OFFLINE_CONTACTS','arg':{'method':'show_offline'}, css:Cookie.get(['im', 'show_all_contacts'])?'ico2 check':''},
							{'title':'-'}
						);

					aMenu.push(
						{'title':'MAIN_MENU::DELETE','arg':{'method':'user_remove',id:id},'css':'color2','disabled':bLogin || bManagement}
					);
				}
			}

		}
		else{
			aMenu = [
				{'title':'IM::ADD','arg':{'method':'user_add',id:id},disabled:bLogin || bManagement},
				{'title':'IM::ADD_GATEWAY','arg':{'method':'user_gate',id:id},disabled:bLogin}
			];

			if (GWOthers.getItem('IM', 'hide_offline_contacts') != '1')
				aMenu.push(
					{'title':'-'},
					{'title':'IM::SHOW_OFFLINE_CONTACTS','arg':{'method':'show_offline'}, css:Cookie.get(['im', 'show_all_contacts'])?'ico2 check':''}
				);
		}

		var cmenu = await gui._create("cmenu","obj_context",'','',me);
			await cmenu._fill(aMenu);
			cmenu._place(e.clientX,e.clientY);
			cmenu._onclick = function(e,elm,id,arg){
				me._oncontext(e,elm,id,arg);
			};

		e && e.preventDefault && e.preventDefault();
	};

	//roster
	this._listen('xmpp',['roster']);

	this.__xmpp._obeyEvent('response', [this, '_response']);
	this.__xmpp._obeyEvent('status', [this, '_status_response']);

	this._add_destructor('__onDestruct');

	//Autologin (always ON)
	var sStatus = Cookie.get(['im', 'status']) || 'offline';
	if (sStatus == 'offline' && GWOthers.getItem('IM', 'auto_status') > '0') {
		sStatus = 'online';
	}
	if (sStatus != 'offline')
		this.__xmpp._presence(sStatus);

	gui._obeyEvent('refreshAvatar',[this, '_refreshMyAvatar']);

	gui._obeyEvent('storage', [function(e, arg){
		if (e && e.type == 'set' && Is.Array(arg) && ~arg.indexOf("IM")) {
			this._fill();
		}
	}.bind(this)]);

	gui._obeyEvent('TeamchatTokenChanged', [this, '__refreshAvatars']);
};

_me._refreshMyAvatar = function(e, arg){
	if (arg === sPrimaryAccount){
		var me = this;
		setTimeout(
			function(){
				me.__xmpp._updatePresencePhoto();
			},
			5000
		);
	}
};

_me._handleVisibilityChange = function() {
	if (gui._isVisible()) {
		clearTimeout(this.__awayTimeout);

		if (this.__lastStatus){
			if (['offline', this.__lastStatus].indexOf(this._status())<0 && ['offline', 'away'].indexOf(this.__lastStatus)<0)
				this._status(this.__lastStatus);

			this.__lastStatus = null;
		}

	} else {
		this.__awayTimeout = setTimeout(function() {
			if (this._destructed)
				return;

			this.__lastStatus = this._status();

			if (['offline', 'away'].indexOf(this.__lastStatus)<0)
				this._status('away');

		}.bind(this), 15 * 60 * 1000); // 15 minutes away
	}
};

_me._search = function(sValue){
	this.__search = sValue;
	this._fill();
};

_me.__dndDispatch = function(){
	if (this.__dndtimer){
		window.clearTimeout(this.__dndtimer);
		delete this.__dndtimer;
	}
	return false; // for _disobeyEvent
};

_me._activate = function (id, bCtrl){

	var aData = dataSet.get('xmpp', ['roster']);

	for(var i in this.__activeUser)
		if ((!bCtrl && i!=id) || (bCtrl && i==id)){
			if (aData[i]){
				[].forEach.call(this._getUsrRow(i), function(elm){
					removecss(elm,'active');
				});
			}
			delete this.__activeUser[i];
		}

	if (id && !this.__activeUser[id]){
		if (aData[id]){
			[].forEach.call(this._getUsrRow(id), function(elm){
				addcss(elm,'active');
				if (!~currentBrowser().indexOf('MSIE')) {
					elm.scrollIntoView({
						block: 'nearest'
					});
				}
			});
		}

		this.__activeUser[id] = true;

		return true;
	}

	return false;
};

_me._is_active = function(){
	return this.__xmpp && this.__xmpp._state()>=5;
};

_me._add_item = function(sGroup, sJID, sName,sTab){
	gui._create('frm_im_add','frm_im_add','','',this.__xmpp, sGroup, sJID, sName,sTab);
};

_me.__onDestruct = function(aHandler){
	var logoutTimeout = setTimeout(function() {
		if (aHandler) {
			executeCallbackFunction(aHandler);
		}
	}, 1000);
	this.__xmpp._presence('offline', '', [function () {
		clearTimeout(logoutTimeout);
		if (aHandler)
			executeCallbackFunction(aHandler);

		dataSet.remove(this._listener, this._listenerPath, true);
		this.__xmpp._disobeyEvent('response', [this, '_response']);
		this.__xmpp._disobeyEvent('status', [this, '_status_response']);

		gui._disobeyEvent('refreshAvatar',[this, '_refreshMyAvatar']);

		clearTimeout(this.__awayTimeout);
		gui._disobeyEvent('visibilitychange',[this, '_handleVisibilityChange']);

	}.bind(this)]);
};

_me._oncontext = async function (e,elm,id,arg){

	if (!arg) return;

	switch(arg.method){
	case 'show_offline':dataSet.remove('xmpp',['roster',this.__sJID,'first_history'], false);
		Cookie.set(['im', 'show_all_contacts'], Cookie.get(['im', 'show_all_contacts'])?0:1);
		this._fill();
		break;
	case 'send':
		if (arg.id)
		 	arg.id = MailAddress.createEmail(dataSet.get('xmpp', ['roster',arg.id,'name']),arg.id);
		else{
			arg.id = '';
		    for (var i in this.__activeUser)
		        if (i.indexOf('@')>-1)
		    		arg.id += (arg.id?', ':'') + MailAddress.createEmail(dataSet.get('xmpp', ['roster',i,'name']),i);
		}

		if (arg.id)
			NewMessage.compose({to:arg.id});

		break;
	case 'file':
		gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this.__chats[arg.id] ,'__addItems'], sPrimaryAccount, '', '', this.__chats[arg.id].text._upload, false, ['F', 'X']);
		break;
	case 'chat':
		this._activate(arg.id);
		this._chat(arg.id);
		this._parent.inp_search._value('');
		this._search('');
		break;
	case 'conference':
		await storage.library('wm_conference');
		var running = dataSet.get('main', ['conference']);
		if (running) {
			wm_conference.get(running).invite([arg.id]);
		} else {
			wm_conference.create(function(conference) {
				conference.join();
				conference.invite([arg.id]);
			}, {
				subject: getLang('CONFERENCE::BETWEEN', [
					dataSet.get('main', ['fullname']),
					dataSet.get('xmpp', ['roster', arg.id, 'name'])
				])
			});
		}
		break;
	case 'vcard':
		gui._create('frm_im_vcard', 'frm_im_vcard', '', '', arg.id, this.__xmpp);
		break;
	case 'sub_add':
		this.__xmpp._user_subscribed(arg.id);
		break;
	case 'search':
		this._search_focus && this._search_focus();
		break;
	case 'sub_get':
		this.__xmpp._user_subscribe('', arg.id);
		break;

	case 'sub_remove':
		this.__xmpp._user_unsubscribed(arg.id);
		break;

	case 'user_remove':
		gui._create('frm_confirm', 'frm_confirm', '', '', [this,'_removeUsr',[[arg.id]]], 'IM::REMOVE',arg.id?'IM::REMOVE_ACCOUNT':'IM::REMOVE_ACCOUNTS',[arg.id]);
		break;

	case 'user_gate':
	case 'user_add':
		this._add_item(arg.id=='*' || arg.id=='~'?'':arg.id,'','',arg.method=='user_gate'?'gateway':'');
		break;

	case 'call':
		gui.frm_main._call(arg.id);
		break;

	case 'call_video':
		gui.frm_main._call(arg.id, true);
		break;

	case 'user_rename':
		var aTmp = dataSet.get('xmpp', ['roster', arg.id]);
		elm = this._getUsrRow(arg.id, true);
		if (elm)
			this.__renameInput(elm, aTmp.name || arg.id,[this,'_renameUsr',[arg.id]]);
		break;
	}
};

_me._removeUsr = function(aID){

	//remove multiple selected
	if (!aID[0]){
		aID = [];
		for(var i in this.__activeUser)
        	aID.push(i);
	}

	if (aID.length){
		this.__xmpp._user_remove(aID, [function(){
			for (var i in aID)
				Cookie.set(['im','queue',aID[i]]);
		}]);
	}

};

_me._renameUsr = function(sName, sJID){
	if (sJID){
		var aTmp = dataSet.get('xmpp', ['roster', sJID]);
		if (aTmp && aTmp.name != sName) {
			this.__xmpp._user_rename(sJID, sName == sJID?'':sName, '', [function() {
				setTimeout(function() {
					gui._getChildObjects('', 'frm_chat').forEach(function(chat) {
						chat.__title();
					});
				}, 50);
			}]);
		}
	}
};

_me._getUsrRow = function(id, bSingle){
	return this.__body[bSingle?'querySelector':'querySelectorAll']('div[iw-jid="'+ id +'"]');
};

_me._focus = function(){
	this._main.focus();
};


// Create input for rename inside given html element
_me.__renameInput = function(hAnchor, sText, oResponse){
	var me = this;

	this.__noRefresh = true;

	removecss(hAnchor,'active');
	addcss(hAnchor,'edit');

	var inp = mkElement('input', {type:'text', className:'rename_input', value:sText});

	// cancel "onclick" propagation to obj_im
	inp.onmousedown = function(e){
		e.stopPropagation();
	};

	inp.onclick = function(e){
		e.preventDefault();
		e.stopPropagation();
	};

	inp.onblur = function (){
		me._doRefresh(true);
	};

	inp.onkeydown = function(e){
		switch (e.keyCode) {
		// Enter
		case 13:
			e.preventDefault();
			e.stopPropagation();
			e.stopImmediatePropagation();
			this.onblur = null;

			if (oResponse)
				executeCallbackFunction(oResponse, this.value);

			me._doRefresh(true);
			break;
		// Esc
		case 27:
			this.blur();
			break;
		}
	};
	inp.onsubmit = function(){
		return false;
	};

	hAnchor.appendChild(inp);

	try{
		inp.setSelectionRange(0, sText.length);
	}
	catch(r){ console.log(this._name||false,r)}
	inp.focus({
		preventScroll: true
	});
};

_me._inRoster = function(sUID){
	return dataSet.get('xmpp', ['roster',sUID.toLowerCase(),'show']) || false;
};

_me._translateUID = function (sUID){
	return Path.split(sUID || '')[0].toLowerCase();
};
_me._translateName = function (sUID){
	if (sUID){
		sUID = this._translateUID(sUID);
		return dataSet.get('xmpp', ['roster', sUID, 'name']) || sUID;
	}
};


_me._chat = async function(sFrom, sTo, sBody, iDate, conference_id, bNoFocus, bError, sId){
	if (!this._is_active()) return;

	sFrom = sFrom ? this._translateUID(sFrom) : '';

	if (sTo === void 0 && this.__chats[sFrom] && !this.__chats[sFrom]._destructed && !sBody){
		if (this.__chats[sFrom].__detached) {
			this.__chats[sFrom].__detached.focus();
		} else if (this.__chats[sFrom].__dock && !this.__chats[sFrom].__dock.classList.contains('active')) {
			await this.__chats[sFrom]._dock(true);
			// this.__chats[sFrom].__dock.__order = -1;
			gui.frm_main.dock._add(this.__chats[sFrom], false, this.__chats[sFrom]._ondock().css + ' active');
		} else {
			this.__chats[sFrom]._focus();
		}
		return;
	}

	var from = sTo, to = sFrom;

 	/* Handle incoming chat messages */
	if (sBody && !sTo){
		from = sFrom;
		to = sPrimaryAccount;

		//Sound
		if (gui.frm_main && gui.frm_main.sound && GWOthers.getItem('IM','sound_notify')>0)
			gui.frm_main.sound._play('im');

		var isConferenceInvite = sBody.toString().match(wm_conference.linkRegExp);
		if (isConferenceInvite) {
			await storage.library('wm_conference');
			var conference = wm_conference.get(isConferenceInvite[2] + '_' + isConferenceInvite[1]);
			conference.getDetail(function(detail) {
				gui.notifier._value({
					type: 'conference_invite',
					args: {
						text: 'NOTIFICATION::CONFERENCE_INVITE',
						args: [dataSet.get('xmpp', ['roster', sFrom, 'name']), conference.data.subject],
						conferenceid: conference.id
					}
				});
			});
			return;
		}
		
		//Notification
		if ((!this.__chats[sFrom] || this.__chats[sFrom]._destructed || !gui.__focus) && GWOthers.getItem('LAYOUT_SETTINGS','notifications') != '2' && gui.notifier._getPermissions() != 'denied' && gui.notifier._getPermissions() != 'unsupported'){

			//parse Body
			var sNotify = '';
			if (Is.String(sBody))
				sNotify = sBody;
			else
				switch(sBody.type){
				case "geoloc":
					sNotify = getLang('IM::REC_GEO');
					break;
				case "file":
					sNotify = getLang('IM::REC_FILE', [sBody.desc]);
					break;
				}

			
			var oNot = gui.notifier._value({
				type:'im',
				args: { jid:sFrom, name: dataSet.get('xmpp', ['roster', sFrom, 'name']), text_plain: sNotify },
				aHandler: [this,'_chat',[sFrom]]
			});
			if (oNot){
				dataSet.add('xmpp', ['roster', sFrom, 'notification'], oNot, true);

				var oHandler = [function(){
					try{
						if (oNot)
							oNot.close();

						if (sFrom)
							dataSet.remove('xmpp', ['roster', sFrom, 'notification'], true);
					}
					catch(r){ console.log(this._name||false,r)}

					gui._disobeyEvent('focus', oHandler);
				}];
				gui._obeyEvent('focus', oHandler);
			}
		}

		//Title
		if (gui.frm_main && gui.frm_main.title)
			gui.frm_main.title._add(getLang('TITLE::NEW_IM',[this._translateName(sFrom)]),5);

		//Not Listed user
		if (!this._inRoster(sFrom))
			dataSet.add('xmpp', ['roster', sFrom], {show:'from', group:'~', user:sFrom});
	}

	var bNew = false;
	if (!this.__chats[sFrom] || this.__chats[sFrom]._destructed == true) {
		if (!conference_id) {
			this.__chats[sFrom] = await gui._create('frm_chat','frm_chat', '', '', sFrom);
			this.__chats[sFrom].__im = this;
			bNew = true;
		}
	}

	dataSet.update('main', ['im']);

	var oMessage, q;
	if (this.__chats[sFrom]){
		var dock = gui.frm_main.dock;
		if (bNew) {
			if (!sBody || (this._getStatus() != 'dnd' && GWOthers.getItem('IM', 'auto_chat') > 0)) {
				await this.__chats[sFrom]._dock(true);
				// this.__chats[sFrom].__dock.__order = -1;
				dock._add(this.__chats[sFrom], false, this.__chats[sFrom]._ondock().css + ' active');
			} else if (sBody && !conference_id) {
				this.__chats[sFrom]._dock();
				dataSet.add('xmpp', ['roster', sFrom, 'action'], 'msg');
				this._addQueueActivity(sFrom, true);
				dock._add(this.__chats[sFrom], false, 'event');
				if (!sPrimaryAccountIMHISTORY || sFrom.indexOf('~')==0 || Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history']))){
					// Add message to the queue for this contact
					oMessage = {'from':from, 'to':to, 'body':sBody, 'date': iDate || (new IcewarpDate()).unix(), undelivered: bError, id: sId};
					if (conference_id)
						oMessage.conference = conference_id;
		
					q = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
					q.push(oMessage);
		
					dataSet.add('xmpp',['roster',sFrom,'history'], q, true);
					return;
				} else if (!Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history']))) {
					return;
				}
			}
		} else {
			if (!sBody) {
				if (this.__chats[sFrom]._docked) {
					if (this.__chats[sFrom].__dock.classList.contains('active')) {
						// this.__chats[sFrom]._undock(true);
					} else {
						await this.__chats[sFrom]._dock(true);
						dock._add(this.__chats[sFrom], false, this.__chats[sFrom]._ondock().css + ' active');
					}
				} else if (this.__chats[sFrom].__detached) {
					this.__chats[sFrom]._focus();
				}
			} else if (sBody && !conference_id) {
				this._addQueueActivity(sFrom, true);
				if (!this.__chats[sFrom]._isActive()) {
					if (from !== sTo) {
						dataSet.add('xmpp', ['roster', sFrom, 'action'], 'msg');
						if (this.__chats[sFrom]._docked) {
							var active = this.__chats[sFrom].__dock.classList.contains('active');
							dock._add(this.__chats[sFrom], false, (active ? 'active' : '') + ' event');
						}
					}
				} else if (!Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history']))) {
					return;
				} else if (Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history'])) && this.__chats[sFrom].__dock && !this.__chats[sFrom].__dock.classList.contains('active')) {
					// Add message to the queue for this contact
					oMessage = {'from':from, 'to':to, 'body':sBody, 'date': iDate || (new IcewarpDate()).unix(), undelivered: bError, id: sId};
					if (conference_id)
						oMessage.conference = conference_id;
		
					q = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
					q.push(oMessage);
		
					dataSet.add('xmpp',['roster',sFrom,'history'], q, true);
					return;
				}
			}
		}
	} else {
		if (!sPrimaryAccountIMHISTORY || sFrom.indexOf('~')==0 || Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history']))){
			// Add message to the queue for this contact
			oMessage = {'from':from, 'to':to, 'body':sBody, 'date': iDate || (new IcewarpDate()).unix(), undelivered: bError, id: sId};
			if (conference_id)
				oMessage.conference = conference_id;

			q = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
			q.push(oMessage);

			dataSet.add('xmpp',['roster',sFrom,'history'], q, true);
		}

		// Notify user with flashing label (but not for conference invitations)
		if (sBody && !conference_id){

			dataSet.add('xmpp', ['roster', sFrom, 'action'], 'msg', true);

			// Remember that there are new messages in the queue for next login
			this._addQueueActivity(sFrom);

			dataSet.update('xmpp', ['roster', sFrom, 'action']);
		}

		return;
	}

	// Add chat message
	var message = await this.__chats[sFrom]._chat(sFrom, sTo, sBody, iDate, bError, sId);
	if (message && sId) {
		message.id = sId;
	}

	dataSet.update('main', ['im']);

	return message;
};

_me._send = async function(sTo, sBody, bConference){
	if (this._is_active()){
		var message;

		if (this.__chats[sTo]) {
			this.__chats[sTo].text._focus(true);
			message = await this._chat(sTo, sPrimaryAccount, sBody, false, false, false, false, this.__xmpp._getUniqueID());
		}

		if (bConference) {
			// Show notification of sent invitation
			if (gui.notifier)
				gui.notifier._value({type: 'invitation_sent', args: [sTo]});

			// Send invitation to conference conference
			this.__xmpp._invitation(sTo, sBody, [this, '__messageSent', [message]], [this, '__messageDelivered', [message]]);
		}
		else{
			this.__xmpp._message(sTo, sBody, [this, '__messageSent', [message]], [this, '__messageDelivered', [message]], message);

			this._addQueueActivity(sTo, true);
		}

		return true;
	}
	return false;
};

_me.__messageSent = function (message) {
	if (!this.__xmpp._opt.amp || !((message || {}).data || {}).to) {
		return;
	}
	var me = this;

	var h = dataSet.get('xmpp', ['roster', message.data.to, 'history']);
	for(var i in h) {
		if (h[i].date === message.data.date && h[i].to === message.data.to && h[i].body === message.data.body) {
			h[i].id = message.id;
			break;
		}
	}
	dataSet.add('xmpp', ['roster', message.data.to, 'history'], h);

	this.__deliveredTimeout[message.id] = setTimeout(function () {
		var h = dataSet.get('xmpp', ['roster', message.data.to, 'history']);
		for(var i in h) {
			if (h[i].date === message.data.date && h[i].to === message.data.to && h[i].body === message.data.body) {
				h[i].undelivered = true;
				break;
			}
		}
		dataSet.add('xmpp', ['roster', message.data.to, 'history'], h);

		message.data.undelivered = true;
		if (me.__chats[message.data.to] && !me.__chats[message.data.to]._destructed){
			message.elm.classList.add('undelivered');
		} else {
			me._chat(message.data.to);
		}
	}, 5000);
};

_me.__messageDelivered = function (response, message) {
	if (message) {
		clearTimeout(this.__deliveredTimeout[message.id]);
		delete this.__deliveredTimeout[message.id];
	}
};

_me._geo = function(sTo, aArg){
	if (this._is_active()){

		this.__xmpp._geo([sTo], aArg, [function(aArg){

			if (this.__chats[sTo]){
				var geo = {
					ATTRIBUTES:{XMLNS:"http://jabber.org/protocol/geoloc", 'XML:LANG':"en"},
					LAT:[{VALUE:aArg.lat}],
					LON:[{VALUE:aArg.lon}]
				};

				this._chat(sTo, sPrimaryAccount, {geoloc: geo, type: "geoloc"});
			}

		}.bind(this, aArg)]);

		return true;
	}
	return false;

};

_me._skeletons = function() {
	if (this.__skeletons) {
		return;
	}
	this.__skeletons = true;
	this._fill();
}

/*
<message from="x@icewarp.com" type="chat" id="A80E8C0C-A362-40FD-AEEF-4F768B54B451" to="lukas@icewarp.com">
	<displayed xmlns="urn:xmpp:chat-markers:0" id="A80E8C0C-A362-40FD-AEEF-4F768B54B451"/>
	<x xmlns="jabber:x:oob">
		<url>https://server.icewarp.com/teamchatapi/files.download?ticket=eJxNizkOgDAMwF5DNiBNUpoOWfkH6iVgQfB,iU4IyZvtZqwkXjk4jALVJGpamD3VLJBshecrMkaG20ZyEsRjUIFisP.WUudBsDMdV4OzG8a0Jar8AhgmGZM_t</url>
		<desc>image</desc>
	</x>
</message>
*/

_me._link = function(sTo, aArg){
	var sId = this.__xmpp._getUniqueID();
	this.__xmpp._file_upload(sTo, aArg, [function(aArg){

		if (this.__chats[sTo]){
			this._chat(sTo, sPrimaryAccount, {
				url: aArg.link,
				desc: aArg.desc,
				size:aArg.size,
				type: "file"
			}, false, false, false, false, sId);
		}

	}.bind(this, aArg)], sId);
};

_me._status_response = function(){

	//Do not save auto-away status
	var status = this._getStatus();
	if (status != 'away' || !this.__lastStatus)
		Cookie.set(['im','status'], status);

	//Disable auto-away when offline
	if (status == 'offline'){
		clearTimeout(this.__awayTimeout);
		gui._disobeyEvent('visibilitychange',[this, '_handleVisibilityChange']);
	}
	else
		gui._obeyEvent('visibilitychange',[this, '_handleVisibilityChange']);
};

_me._response = async function(sType,aData){
	var sFrom, sTo, iDate, stamp, conference_id, me = this, frm, sHtml, i;
	switch (sType){
	case 'notice':

		sFrom = this._translateUID(aData.FROM);
		if (aData && this.__chats[sFrom]){

			if (!dataSet.get('xmpp', ['roster', sFrom]))
				if (dataSet.get('xmpp', ['roster', aData.FROM]))
				    sFrom = aData.FROM;
				else
				    break;

			this.__chats[sFrom]._notice(aData.TEXT);
		}
		break;

	//ERROR
	case 'error':

		if (aData.IQ){
			try{
				//Server Offline
				if (aData.IQ[0].ERROR && aData.IQ[0].ERROR[0] && aData.IQ[0].ERROR[0].ATTRIBUTES && aData.IQ[0].ERROR[0].ATTRIBUTES.STATUS != 408)
					gui.notifier._value({type: 'alert', args: {header: 'IM::ERROR_IM', text_plain: aData.IQ[0].ERROR[0].VALUE + ' (' + aData.IQ[0].ERROR[0].ATTRIBUTES.STATUS+')'}});
			}
			catch(e){ console.log(this._name||false,e)}
		}
		break;

	//MESSAGE
	case 'event':
		if (aData.EVENT && aData.EVENT[0].ITEMS && aData.EVENT[0].ITEMS[0].ITEM && aData.EVENT[0].ITEMS[0].ITEM[0].GEOLOC) {
			aData.BODY = [{VALUE: {geoloc: aData.EVENT[0].ITEMS[0].ITEM[0].GEOLOC[0], type: "geoloc"}}];
			return this._response('message', aData);
		}
		break;

	case 'x':
		if (aData.X && aData.X[0].URL){
			var aVal = {url: aData.X[0].URL[0].VALUE, type: "file"};

			if (aData.X[0].DESC)
				aVal.desc = aData.X[0].DESC[0].VALUE;

			if (aData.X[0].SIZE)
				aVal.size = aData.X[0].SIZE[0].VALUE;

			aData.BODY = [{VALUE: aVal}];
			return this._response('message', aData);
		}

	case 'message':
		if (aData.BODY && aData.BODY[0] && aData.BODY[0].VALUE){

			iDate = '';
			if (aData.X && aData.X[0] && aData.X[0].ATTRIBUTES && (stamp = aData.X[0].ATTRIBUTES.STAMP)){
				iDate = new IcewarpDate(stamp, {format:'YYYYMMDDThh:mm:ss'}); //CCYYDDMMThh:mm:ss
				iDate = iDate.add(iDate.utcOffset(),'m').unix();
			}

			// Conference conference message
			if (aData.X && aData.X[0] && aData.X[0].ATTRIBUTES && aData.X[0].ATTRIBUTES.XMLNS == 'jabber:x:icewarpconference')
				conference_id = aData.X[0].ID[0].VALUE;

			await this._chat(aData.ATTRIBUTES.FROM, '', aData.BODY[0].VALUE, iDate, conference_id, true, aData.ATTRIBUTES.TYPE === 'error', aData.ATTRIBUTES.ID);
		}
		break;

	//CARBONS xep-0280
	case 'sent':
	case 'received':

		//Parse From
		sFrom = this._translateUID(aData.MESSAGE[0].ATTRIBUTES.FROM);
		sTo = this._translateUID(aData.MESSAGE[0].ATTRIBUTES.TO);
		var sUser = sType === 'sent'?sTo:sFrom;

		//No group support
		if (sFrom.indexOf('~') === 0)
			break;

		//omit if user hes no history yet
		if (sPrimaryAccountIMHISTORY && !Is.Defined(dataSet.get('xmpp',['roster',sUser,'history'])))
		 	break;

		//Parse Date
		iDate = '';
		if (aData.DELAY && aData.DELAY[0] && aData.DELAY[0].ATTRIBUTES && (stamp = aData.DELAY[0].ATTRIBUTES.STAMP)){
			iDate = new IcewarpDate(stamp,{format:'YYYYMMDDThh:mm:ss'});
			iDate = iDate.add(iDate.utcOffset(),'m').unix();
		}
		else
			iDate = (new IcewarpDate()).unix();

		var sBody = '';

		//GEO
		if (aData.MESSAGE[0].EVENT && aData.MESSAGE[0].EVENT[0].ITEMS && aData.MESSAGE[0].EVENT[0].ITEMS[0].ITEM && aData.MESSAGE[0].EVENT[0].ITEMS[0].ITEM[0].GEOLOC) {
			sBody = {geoloc: aData.MESSAGE[0].EVENT[0].ITEMS[0].ITEM[0].GEOLOC[0], type: "geoloc"};
		}
		//Parse Body
		else{
			sBody = (aData.MESSAGE[0].BODY && aData.MESSAGE[0].BODY[0].VALUE) || '';

			if (aData.MESSAGE[0].X && aData.MESSAGE[0].X[0] && aData.MESSAGE[0].X[0].ATTRIBUTES){
				switch(aData.MESSAGE[0].X[0].ATTRIBUTES.XMLNS){
					// Conference conference message
					case 'jabber:x:icewarpconference':
						conference_id = aData.MESSAGE[0].X[0].ID[0].VALUE;
					break;

					//Image
					case 'jabber:x:oob':
						if (aData.MESSAGE[0].X[0].URL){
							sBody = {url: aData.MESSAGE[0].X[0].URL[0].VALUE, type: "file"};

							if (aData.MESSAGE[0].X[0].DESC)
								sBody.desc = aData.MESSAGE[0].X[0].DESC[0].VALUE;
							if (aData.MESSAGE[0].X[0].SIZE)
								sBody.size = aData.MESSAGE[0].X[0].SIZE[0].VALUE;
						}
					break;
				}
			}
		}

		//User has active chat
		var id = (aData.MESSAGE[0].ATTRIBUTES || {}).ID;
		if (dataSet.get('xmpp',['roster',sUser,'active']) === true && this.__chats[sUser]){
			// skip carbons already in history
			var h = dataSet.get('xmpp',['roster',sUser,'history']) || [];
			if (h.some(function(m) {
				return id === m.id;
			})) {
				return;
			}

			//ADD MESSAGE WO NOTIFICATION
			await this._chat(sUser, sType === 'sent'?sFrom:'', sBody, iDate, void 0, void 0, void 0,id);
		}
		else
		// Add message to the queue for this contact
		{
			var oMessage = {'from':sFrom, reply:sType === 'sent', 'body':sBody, 'date': iDate, id: id};
			if (conference_id)
				oMessage.conference = conference_id;

			var q = dataSet.get('xmpp',['roster',sUser,'history']) || [];
				q.push(oMessage);

			dataSet.add('xmpp',['roster',sUser,'history'], q, true);
		}

		break;

	case 'gone':
		aData = this._translateUID(aData);
		if (this.__chats[aData])
			this.__chats[aData]._gone();
		break;

	case 'paused':
		aData = this._translateUID(aData);
		if (aData){
			if (gui.frm_main && gui.frm_main.title)
				gui.frm_main.title._refresh();

			if (this.__chats[aData])
				this.__chats[aData]._wait();
		}
		break;
	case 'composing':
		aData = this._translateUID(aData);
		if (aData){
			if (gui.frm_main && gui.frm_main.title)
				gui.frm_main.title._add(getLang('IM::COMPOSING',[this._translateName(aData)]),5,true);

			if (this.__chats[aData])
				this.__chats[aData]._compose();
		}
		break;

	//RESPONSE
	case 'subscribe':
		if (aData.ATTRIBUTES.FROM){
			if (GWOthers.getItem('IM','auto_subscribe')>0)
				this.__subscribed(true,aData.ATTRIBUTES.FROM);
			else{
				frm = await gui._create('subscribe','frm_confirm_threestates','','',[this,'__subscribed',[aData.ATTRIBUTES.FROM]],'IM::SUBSCRIPTION','IM::SUB_ASK',[aData.ATTRIBUTES.FROM],'FORM_BUTTONS::ACCEPT','FORM_BUTTONS::DECLINE');

				//Service
				if (aData.ATTRIBUTES.FROM.indexOf('@')==-1){
					frm.x_btn_cancel2._disabled(true);
					frm.x_btn_cancel._onclick = function(){
						me.__xmpp._user_remove([aData.ATTRIBUTES.FROM]);
						frm._destruct();
					};
				}
			}
		}
		break;

	case 'subscribed':
		break;

	case 'unavailable':
		if (aData.ATTRIBUTES && aData.ATTRIBUTES.FROM){
			sFrom = this._translateUID(aData.ATTRIBUTES.FROM);
			if (dataSet.get('xmpp', ['roster', sFrom])){
				dataSet.remove('xmpp', ['roster', sFrom, 'status'],true);
				dataSet.remove('xmpp', ['roster', sFrom, 'sip'],true);
				dataSet.remove('xmpp', ['roster', sFrom, 'show'],true);
				dataSet.update('xmpp', ['roster', sFrom]);
			}
		}

		break;

	case 'unsubscribed':

		if (aData.ATTRIBUTES && aData.ATTRIBUTES.FROM){
			sFrom = this._translateUID(aData.ATTRIBUTES.FROM);

			if (dataSet.get('xmpp', ['roster', sFrom])){
				dataSet.remove('xmpp', ['roster', sFrom, 'status'],true);
				dataSet.add('xmpp', ['roster', sFrom, 'status'],'from');

				//Remove from Queue
				this._removeQueue(sFrom);

				gui.notifier._value({type: 'alert', args: {header: 'IM::SUBSCRIPTION', text: 'IM::UNSUBSCRIBED', args: [sFrom]}});
			}
		}

		break;

	case 'state_change':

		if (aData.ATTRIBUTES && aData.ATTRIBUTES.FROM){

			var aFrom = Path.split(aData.ATTRIBUTES.FROM);
			sFrom = aFrom[0];

			if (!dataSet.get('xmpp', ['roster', sFrom]))
				if (dataSet.get('xmpp', ['roster', aData.ATTRIBUTES.FROM]))
				    sFrom = aData.ATTRIBUTES.FROM;
				else
				    break;

			var ds = dataSet.get('xmpp', ['roster', sFrom]),
				bUpdate = false;

			//set status text
			var sStat = '';
			if (aData.STATUS && aData.STATUS[0] && aData.STATUS[0].VALUE)
				sStat = aData.STATUS[0].VALUE;

			if (ds.status != sStat){
				bUpdate = true;
				dataSet.add('xmpp', ['roster', sFrom, 'status'], sStat, true);
			}

			//set resource
			if (aFrom[1])
				dataSet.add('xmpp', ['roster', sFrom, 'resource'], aFrom[1], true);

			//set VoIP & Avatar update
			var bSIP = false;
			if (aData.X)
			    for(i in aData.X){
					switch(aData.X[i].ATTRIBUTES.XMLNS){
						case 'sip-presence:x:update':
							bSIP = true;
							break;

						//update avatar
						case 'vcard-temp:x:update':
							if (aData.X[i].PHOTO){
								var new_hash = aData.X[i].PHOTO[0].VALUE;
								if (ds.photo && new_hash !== ds.photo)
									bUpdate = true;

								dataSet.add('xmpp', ['roster', sFrom, 'photo'], new_hash, true);
							}
					}
				}

			dataSet.add('xmpp', ['roster', sFrom, 'sip'], bSIP, true);

			//set status time
			dataSet.add('xmpp', ['roster', sFrom, 'status_time'], (new IcewarpDate()).unix(), true);

			//set status icon
			var new_show = 'offline';
			if (aData.SHOW && aData.SHOW[0] && aData.SHOW[0].VALUE)
				new_show = aData.SHOW[0].VALUE.toLowerCase();
			else
			if (aData.ATTRIBUTES.TYPE != "unavailable")
				new_show = ds.show == 'from'?'from':'online';

			if (ds.show !== new_show){
				dataSet.add('xmpp', ['roster', sFrom, 'show'], new_show, true);
				bUpdate = true;
			}

			bUpdate && dataSet.update('xmpp', ['roster', sFrom]);
		}

		break;

	case 'download':

		if (aData){

			var sDesc = (aData.FILE[0].DESC && aData.FILE[0].DESC[0] && aData.FILE[0].DESC[0].VALUE?aData.FILE[0].DESC[0].VALUE:'');
			sFrom = this._translateName(aData.FROM[0].VALUE);

			//Bytestream transfer
			if (aData && aData.FILE && aData.FEATURE){

				//Feature check
				if (aData.FEATURE[0].X && aData.FEATURE[0].X[0].ATTRIBUTES && aData.FEATURE[0].X[0].ATTRIBUTES.XMLNS == 'jabber:x:data'	&&
		            aData.FEATURE[0].X[0].FIELD && aData.FEATURE[0].X[0].FIELD[0].ATTRIBUTES && aData.FEATURE[0].X[0].FIELD[0].ATTRIBUTES.TYPE == 'list-single' &&
		            aData.FEATURE[0].X[0].FIELD[0].OPTION && aData.FEATURE[0].X[0].FIELD[0].OPTION[0].VALUE && aData.FEATURE[0].X[0].FIELD[0].OPTION[0].VALUE[0].VALUE == 'http://jabber.org/protocol/bytestreams'){

					//Auto-Accept files below 5MB
					if (!aData.FILE[0].ATTRIBUTES || aData.FILE[0].ATTRIBUTES.SIZE>5242880){
						sHtml = getLang('IM::RECEIVE_NOTE',[sFrom.escapeHTML(), aData.FILE[0].ATTRIBUTES.NAME.escapeHTML()]) + (sDesc?'<hr size="1">' + sDesc.escapeHTML():'');
						frm = await gui._create('download','frm_confirm','','',[this,'_response',['stream_start',aData]],'IM::RECEIVE_FILE','', sHtml);
						frm.x_btn_cancel._onclick = function(){
			                    me.__xmpp._stream_cancel(aData.ID[0].VALUE,aData.FROM[0].VALUE);
							this._parent._destruct();
						};
					}
					else
						this.__xmpp._stream_accept(aData, aData.ID[0].VALUE, aData.FROM[0].VALUE);
				}
				else
					this.__xmpp._stream_cancel(aData.ID[0].VALUE, aData.FROM[0].VALUE);

			}
			else
			//OOB transfer
			if (aData && aData.URL && aData.URL[0] && aData.URL[0].VALUE){
				sHtml = getLang('IM::RECEIVE_NOTE',[sFrom.escapeHTML(), Path.basename(aData.URL[0].VALUE).escapeHTML()]) + (sDesc?'<hr size="1">' + sDesc.escapeHTML():'');
				frm = await gui._create('download','frm_confirm','','',[this,'_response',['download_start',aData.URL[0].VALUE]], 'IM::RECEIVE_FILE','', sHtml);

				frm.x_btn_cancel._onclick = function(){
					me._response('download_stop',aData);
					this._parent._destruct();
				};
			}

		}
		break;

	case 'stream_start':
		this.__xmpp._stream_accept(aData, aData.ID[0].VALUE,aData.FROM[0].VALUE);
		break;

	case 'streamhost':

		if (aData && aData.size>0 && aData.socket){
			var aUrl = {
				'dlsess': dataSet.get('main', ['dlsess']),
				'class': 'socks',
				'fullpath': aData.name+'/'+aData.size+'/'+aData.socket
			};

			downloadItem(buildURL(aUrl));
		}
		else
			gui.notifier._value({type: 'alert', args: {header: '', text: 'IM::ERROR_SOCKET'}});

		break;

	case 'download_start':
		window.open(aData, "file", "directories=no,toolbar=no,status=no,menubar=yes,width=200,height=200");
		break;

	case 'download_stop':
		var sID = '';
		sTo = '';
		if (aData.ID){
			sID = aData.ID[0].VALUE;
			delete aData.ID;
		}
		if (aData.FROM){
			sTo = aData.FROM[0].VALUE;
			delete aData.FROM;
		}
		this.__xmpp._oob_cancel(aData, sID, sTo);
		break;

	case 'roster':

		//update roster
		if (aData.ITEM){
			var oldShow, sJID, sSub, sName, bRefresh = false;
			for(i in aData.ITEM){
				sSub = aData.ITEM[i].ATTRIBUTES.SUBSCRIPTION;
				sJID = aData.ITEM[i].ATTRIBUTES.JID;
				sName= aData.ITEM[i].ATTRIBUTES.NAME;

				if (sSub == 'remove')
					dataSet.remove('xmpp', ['roster', sJID], true);
				else{
					//do not overwrite show icon with subscription ("both")
					oldShow = dataSet.get('xmpp', ['roster', sJID,'show']);
					if (!oldShow || sSub != 'both' || (sSub == 'both' && (oldShow == 'from' || oldShow == 'to')))
						dataSet.add('xmpp', ['roster', sJID,'show'], sSub, true);

					dataSet.add('xmpp', ['roster', sJID,'name'], sName, true);
					dataSet.add('xmpp', ['roster', sJID,'user'], sJID, true);
					dataSet.add('xmpp', ['roster', sJID,'group'],aData.ITEM[i].GROUP?aData.ITEM[i].GROUP[0].VALUE:'*', true);
				}
				bRefresh = true;
			}

			//prefill roster with COOKIE
			if (sPrimaryAccountIMHISTORY){
				var mem = Cookie.get(['im','queue']);
				if (mem)
					for(sFrom in mem)
						if (dataSet.get('xmpp', ['roster', sFrom])){
							if (mem[sFrom].msg){
								dataSet.add('xmpp', ['roster', sFrom, 'action'], 'msg', true);
								bRefresh = true;
							}
						}
			}

			if (bRefresh)
				dataSet.update('xmpp', ['roster']);
		}

		break;
	}
};

_me.__subscribed = function(bOK,sJID){
	this.__xmpp[bOK?'_user_subscribed':'_user_unsubscribed'](sJID);
};

_me.__update = function(sDataSet, aDName){
	if (aDName && aDName[0] == 'roster'){
		//Update Activity
		var aQ = Cookie.get(['im', 'queue']);
		this.__skeletons = false;
		if (!Is.Empty(aQ)){
			var aData = dataSet.get('xmpp', ['roster']);
			for (var jid in aQ){
				if (!aData[jid])
					this._removeQueue(jid);
				else
				//Roster fully loaded
				if (Is.Defined(aData[jid].action)){
					Cookie.set(['im', 'queue', jid, 'msg'], aData[jid].action == 'msg'?1:0);
				}
			}
		}

		//Update roster
		this._fill();
	}
};


_me._doRefresh = function(b){
	this.__noRefresh = false;
	if (b || this.__doRefresh){
		this.__doRefresh = false;
		this._fill();
	}
};

_me.__generateSkeletons = function() {
	if (!this._getAnchor('body')) {
		return {};
	}

	var rows = this._getAnchor('body').clientHeight / 45;
	var skeletons = {};
	for(var i = 0; i < rows; i++) {
		skeletons[i] = {
			name: [wordGen(), wordGen()].join(' '),
			show: 'skeleton'
		};
	}
	return skeletons;
}

/**
 * get sorted data for roster (sorted groups, sorted items in each group)
 *
 * @param {array} aCookie
 * @return {array}
 */
_me.__prepareData = function() {
	var	aRoster = this.__skeletons ? this.__generateSkeletons() : (dataSet.get('xmpp', ['roster']) || {}),
		aData = [],
		tmp;

	for(var jid in aRoster)	{
		tmp = clone(aRoster[jid]);
		tmp.user = jid;
		delete tmp.history;

		aData.push(tmp);
	}

	return aData;
};

/**
 * returns html of the user row
 *
 * @param {string} id
 * @param {object} data
 * @param {object} userRowParts
 * @return {string}
 */
_me.__getHtmlUserRow = function(data) {
	var html = '',
		css = 'user_' + encodeURIComponent(data.show || 'offline');

	if (data.action) {
		css += ' action_' + encodeURIComponent(data.action);
	}
	if (this.__activeUser[data.user]) {
		css += ' active';
	}
	if (data.type) {
		css += ' ' + encodeURIComponent('set_' + data.type);
	}
	if (data.type !== 'service') {
		css += ' avatar';

		var user = data.user.match(/^\d+$/) ? '' : data.user;
		html += obj_avatar.getAvatarHTML({
			email: user,
			name: data.name || data.user,
			size: 32,
			bNoAvatar: !this.__avatarCache[user]
		});
	}

	html += '<div class="info"><h3>' + ((data.name ? data.name.trim() : '') || data.user || '').escapeHTML() + '</h3>';

	if (data.status) {
		css += ' status';
		html += '<h4>' + data.status.escapeHTML() + '</h4>';
	}
	html += '</div>';

	var btn = '';
	if (!sPrimaryAccountGUEST && window.sPrimaryAccountCONFERENCE)
		btn += '<em class="video"></em>';

	btn += '<em class="menu"></em>';

	return {css: css, html: html + btn};
};

/**
 * returns view port height (visible area) and current scrolled position in pixels
 *
 * @return {object} scrollTop: number, viewPortHeight: number
 */
_me.__getVisibleRange = function() {
	var scrollTop, viewPortHeight, documentHeight;
	scrollTop = this.__body.parentNode.scrollTop || 0;
	documentHeight = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
	viewPortHeight = this.__body.parentNode.clientHeight === 0 ? documentHeight : Math.min(this.__body.parentNode.offsetHeight, documentHeight);
	viewPortHeight = Math.max(viewPortHeight, 100); // minimal height

	//viewPadding = Math.max(parseInt(getComputedStyle(this.__body).paddingTop || 0), 20);
	//scrollTop = scrollTop<viewPadding?0:scrollTop;

	return {scrollTop: scrollTop, viewPortHeight: viewPortHeight};
};

_me.__showVisibleAvatars = function() {

	var	me = this,
		range = this.__getVisibleRange(),
		offset = Math.floor(range.scrollTop / this.__rowHeight),
		limit = Math.ceil(range.viewPortHeight / this.__rowHeight);

	[].slice.call(this.__body.querySelectorAll('div[iw-jid]'), offset, offset + limit).forEach(function(elm){
		var jid = elm.getAttribute('iw-jid');
		if (!jid || jid.match(/^\d+$/)) {
			return;
		}

		var avatar = elm.querySelector('.component-avatar--image');
		if (!avatar) {
			return;
		}
		me.__avatarCache[jid] = me.__avatarCache[jid] || obj_avatar.getAvatarURL(jid, void 0, !!(dataSet.get('xmpp', ['roster', jid, 'name']) || jid));

		avatar.setAttribute('style', 'background-image: url("' + me.__avatarCache[jid] + '");');
		gui.tooltip._add(avatar, function() {
			return obj_avatar.getAvatarHTML({
				email: jid,
				name: dataSet.get('xmpp', ['roster', jid, 'name']) || jid,
				size: 120
			});
		}, {y: '-124', html: true, css: 'borderless'});
	});
};

_me.__fillTimeout;
_me._fill = function() {
	clearTimeout(this.__fillTimeout);
	this.__fillTimeout = setTimeout(this.__fill.bind(this), 50);
};

_me.__refreshAvatars = function() {
	this.__avatarCache = {};
	this.__showVisibleAvatars();
};

/**
 * main render function of the roster
 **/
_me.__fill = function() {
	if (this.__noRefresh) {
		this.__doRefresh = true;
		return;
	}

	var me = this,
		aData = this.__prepareData(),
		//aOutput = [],
		aCurrentDOM = [].slice.call(this.__body.querySelectorAll('div[iw-jid]')),
		bFilterOffline = GWOthers.getItem('IM', 'hide_offline_contacts') == '1' || !Cookie.get(['im', 'show_all_contacts']);

	//Search Filter
	if (this.__search !== ''){
		aData = aData.filter(function(usr){
			var s = me.__search.toLowerCase();
			var normalized = (usr.name || '').toLowerCase();
			if (String.prototype.normalize) {
				s = s.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
				normalized = normalized.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
			}
			return ~normalized.indexOf(s) || ~usr.user.indexOf(s);
		});
	}
	//Online filter
	else
	if (bFilterOffline){
		aData = aData.filter(function(usr){
			return (usr.show && !~['both', 'none', 'to', 'offline'].indexOf(usr.show)) || usr.action == 'msg';
		});
	}

	var aQ = Cookie.get(['im','queue']) || {};
	var sort_by_last_name = GWOthers.getItem('IM', 'sort_by_surname') == '1';
	aData.sort(function(a,b){
		var a_act = aQ[a.user]?aQ[a.user].activity:0,
			b_act = aQ[b.user]?aQ[b.user].activity:0;

		//Action
		// if (a.action != b.action)
		// 	return a.action == 'msg'?-1:1;

		//Activity
		if (a_act != b_act)
			return b_act - a_act;

		//Alfa-numeric
		if (sort_by_last_name) {
			return (a.name || a.user).split(' ').reverse().join(' ').toLowerCase().localeCompare((b.name || b.user).split(' ').reverse().join(' ').toLowerCase());
		} else {
			return (a.name || a.user).localeCompare(b.name || b.user);
		}

	}).forEach(function(data, i){
		var row  = me.__getHtmlUserRow(data),
			jid = data.user,
			elm = mkElement('div', {
				className: row.css,
				'iw-jid': jid,
				unselectable: 'on',
				innerHTML: row.html
			});

		if (aCurrentDOM[i]){
			if (elm.outerHTML !== aCurrentDOM[i].outerHTML) {
				me.__body.replaceChild(elm, aCurrentDOM[i]);
			}
		}
		//create
		else{
			me.__body.appendChild(elm);
		}
	});

	
	if (aData.length) {
		removecss(this._main, 'noitems');
	} else {
		if (this._getAnchor('noitems')) {
			this._getAnchor('noitems').textContent = getLang('IM::NOITEMS' + (this.__search ? '_FILTER' : ''), [this.__search]);
		}
		addcss(this._main, 'noitems');
	}

	//remove rest of the elements
	if (aCurrentDOM.length>aData.length)
		aCurrentDOM.slice(aData.length).forEach(function(elm){
			elm.parentNode.removeChild(elm);
		});

	this.__showVisibleAvatars();

	return;
};


/**
 * Drag & Drop
 **/
_me.__initdrag = function(id, sType, x, y) {
	if (this._is_active()) {
		if (!this.__activeUser[id]) {
			this._activate(id);
		}
		if ((id = Object.keys(this.__activeUser))) {
			//create Drag box
			gui.frm_main.dnd.create_drag({
				type: sType,
				value: id.map(function(id) {
					return {
						id: id,
						type: 'contact',
						name: dataSet.get('xmpp',['roster', id, 'name']),
						folder: id,
						icon: obj_avatar.getAvatarHTML({
							email: id,
							name: dataSet.get('xmpp', ['roster', id, 'name']) || id,
							size: 48
						})
					}
				}, this),
				x: x,
				y: y,
				obj: this
			});
		}
	}
};

_me.__wheel = function(e){
	this.__body.scrollTop += e.delta*20;
};

_me._addQueueActivity = function(sUID, bFill){
	if (sUID){
		Cookie.set(['im', 'queue', sUID, 'activity'], +(new IcewarpDate()));
		bFill && this._fill();
	}
};
_me._removeQueue = function(sUID){
	Cookie.set(['im', 'queue', sUID]);
};

_me._getStatus = function(sJID){
	return this.__xmpp._user_status(sJID);
};

_me._status = function(sStatus, sStatusText){
	if (sStatus)
		this.__xmpp._presence(sStatus, sStatusText);
	else
		return this._getStatus();
};
_me._getStatusText = function(){
	return this._getStatus() === 'offline'?'':dataSet.get('xmpp', ['statusText']) || Cookie.get(['im', 'statusText']) || '';
};
