_me = obj_hmenu_toolbar.prototype;
function obj_hmenu_toolbar() {}

_me.__constructor = async function (bObey, aOptions) {
	await storage.library('gw_others');

	this.__currentFolder = [];

	this.__bObey = bObey;
	if (bObey) {
		gui._obeyEvent('viewSelected', [this, '__viewSelect_handler']);
		gui._obeyEvent('folderSelected', [this, '__folderSelect_handler']);
		gui._obeyEvent('itemSelected', [this, '__itemSelect_handler']);
		gui._obeyEvent('chatgptChanged', [this, '__initChatGPT']);
	}

	this.__opt = Object.assign({
		context: null
	}, aOptions);

	this._autoCollapse(true);
	await this._create('_close', 'obj_button', 'main', 'ico transparent close');
	this._close._onclick = function() {
		gui.frm_main.filter.__filter('D', false, false, 5);
	};

	this.__initChatGPT();

	this._add_destructor('__destructor');
};

_me.__initChatGPT = function() {
	this.__currentIDs && this.__menu(this.__currentIDs);
};

	_me.__viewSelect_handler = function (arg, aCurrentFolder) {
		this.__currentView = arg;
		this.__menu(aCurrentFolder || this.__currentFolder);
	};

	_me.__folderSelect_handler = function(arg){
		var arg_copy = clone(arg);

		//Get primary Calendar folder
		if (arg.aid == sPrimaryAccount && arg.fid == '__@@VIRTUAL@@__/__@@EVENTS@@__'){
			arg_copy.fid = Folder.getActiveCalendar() || arg_copy.fid;
		}

		if (this.__currentFolder.length){
			if ((arg.ftype && this.__currentIDs.length == 3) || this.__currentFolder[0] != arg.aid || (this.__currentFolderTranslated[1] != arg_copy.fid))
				this.__menu([arg.aid, arg_copy.fid]);
		}
		else{
			this.__menu([arg.aid, arg_copy.fid]);
		}

		this._folder_tree_popup && this._folder_tree_popup._destruct();
	};

	_me.__itemSelect_handler = function(arg){
		if (!this.__currentFolder.length || (!compareObj(this.__currentIDs,arg,true) && WMFolders.getType(arg) === WMFolders.getType(this.__currentFolder))) {
			this.__menu(arg);
		}
	};


_me.__destructor = function () {
	this._close && this._close._destruct();
	if (this.__bObey) {
		gui._disobeyEvent('viewSelected', [this, '__viewSelect_handler']);
		gui._disobeyEvent('folderSelected', [this, '__folderSelect_handler']);
		gui._disobeyEvent('itemSelected', [this, '__itemSelect_handler']);
		gui._disobeyEvent('chatgptChanged', [this, '__initChatGPT']);
	}
};

_me.__menu = async function (ids) {
	if (this.__menuTimeout) {
		clearTimeout(this.__menuTimeout);
	}

	this.__menuTimeout = setTimeout(this.___menu.bind(this, ids), 5);
};

_me.___menu = async function (ids) {

	if (Is.String(ids[2]))
		ids[2] = [ids[2]];

	this.__currentIDs = ids;
	this.__currentFolder = ids.slice(0,2);
	if (ids[2] && ids[2].length === 1) {
		this.__currentFolder[0] = (dataSet.get('items', [ids[0], ids[1], ids[2][0]]) || {}).ORIGINALACCOUNT || ids[0];
		this.__currentFolder[1] = (dataSet.get('items', [ids[0], ids[1], ids[2][0]]) || {}).ORIGINALFOLDER || ids[1];
	}

	this.__currentFolderTranslated = this.__currentFolder.concat();
	if (this.__currentFolder[0] == sPrimaryAccount && this.__currentFolder[1] == '__@@VIRTUAL@@__/__@@EVENTS@@__'){
		this.__currentFolder[1] = Folder.getActiveCalendar();
		this.__currentFolderTranslated[1] = Folder.getActiveCalendar();
	}

	dataSet.add('folders',[sPrimaryAccount, '__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__'], {
		TYPE: 'Y',
		NAME: getLang('FOLDER_TYPES::GROUPCHAT')
	});

	var me = this,
		aMenu = [],
		sType = WMFolders.getType(this.__currentFolder),
		bShort = false,
		aFolder = dataSet.get('folders', this.__currentFolder) || {},
		aRights = WMFolders.getRights(this.__currentFolder),
		aAccess = WMFolders.getAccess(this.__currentFolder),
		del = false,
		bNoMore = false,
		bIsFavorite = (dataSet.get('cookies', ['favorites']) || []).some(function(fav) {
			return fav.arg.aid === this.__currentFolder[0] && fav.arg.fid === this.__currentFolder[1];
		}.bind(this));

	this._main.setAttribute('folder-type', sType);

	if (this._share) {
		await this._share._destruct();
	}

	//FOLDERS
	if (ids.length == 2) {
		if (Mapping.isGlobalSearchFolder(ids[1])) {
			return this._fill([], 'static');
		}

		if (sType != 'I' && sType != 'Y' && aRights.owner && ids[0] === sPrimaryAccount && (GWOthers.getItem('RESTRICTIONS', 'disable_folder_sharing') == 0)) {
			var sName = dataSet.get('folders', this.__currentFolder.concat('NAME'));
			if (sType === 'M') {
				var static_flags = dataSet.get('folders', this.__currentFolder.concat('STATIC_FLAGS'));
				if ((static_flags & 8) || (static_flags & 16) || !sPrimaryAccountCHAT || !sPrimaryAccountGWSUPPORT) {
					sName = false;
				}
			}

			if (sName) {
				await this._create('_share', 'obj_button', 'main', 'color1 rounded share ico share2 simple');
				this._share._text(getLang('popup_items::share_folder', [sName || this.__currentFolder[1].split('/').pop()]));
				this._share._onclick = function() {
					me._gui._create('frm_sharing', 'frm_sharing', '', '', void 0, {aid:me.__currentFolder[0], fid:me.__currentFolder[1]});
				};
			}
		}

		switch(sType){
			case 'M':
				if (aFolder.RSS){
					aMenu.push(
						{"title": 'POPUP_FOLDERS::CHANGE_CHANNEL', css: 'ico2 change_channel', "arg": 'change_channel', disabled:!aRights.modify}
					);
				}

				if (!aFolder.SPAM)
					aMenu.push({"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'});

				if (aFolder.SPAM || aFolder.DEFAULT === 'H' || (aFolder.DEFAULT == 'S' && GWOthers.getItem('RESTRICTIONS', 'DISABLE_EMPTY_FOLDER') != 1))
					aMenu.push({"title": GWOthers.getItem('DEFAULT_FOLDERS','trash') === ids[0] + '/' + ids[1] ? 'MAIN_MENU::EMPTY_TRASH' : 'MAIN_MENU::EMPTY_FOLDER', css: 'ico2 empty_folder', "arg": 'empty'});

				if (!bIsFavorite) {
					aMenu.push({title: 'POPUP_FOLDERS::ADD_FAVORITES', arg: 'add_favorite', css:'ico2 fav_folder'});
				} else {
					aMenu.push({title: 'POPUP_FOLDERS::REMOVE_FAVORITES', arg: 'remove_favorite', css:'ico2 fav_folder'});
				}

				break;

			case 'E':
				if (~['day_view','week_view','workweek_view','month_view'].indexOf(this.__currentView))
					aMenu.push({"title": 'MAIN_MENU::PRINT', css: 'ico2 print noarrow', "arg": 'print', nodetype: 'click', nodes:[
						{"title": 'MAIN_MENU::PRINT_CALENDAR', css:'ico2 print_calendar', "arg": 'print_calendar'},
						{"title": 'MAIN_MENU::EVENTS_LIST',  css:'ico2 print_list', "arg": 'print_list'}
					]});

				aMenu.push({"title": 'MAIN_MENU::ADD_CALENDAR', css: 'ico2 add_calendar', "arg": 'add_folder'});

				break;

			case 'F':
				var aDoc = [
					{"title": 'MAIN_MENU::NEW_WORD', "arg": {arg:'new_item', type:'.docx'}, css: 'ico2 word shorten', disabled:!aAccess.write},
					{"title": 'MAIN_MENU::NEW_EXCEL', "arg": {arg:'new_item', type:'.xlsx'}, css: 'ico2 xls shorten', disabled:!aAccess.write},
					{"title": 'MAIN_MENU::NEW_PPOINT', "arg": {arg:'new_item', type:'.pptx'}, css: 'ico2 ppt shorten', disabled:!aAccess.write}
				];
				aMenu = aMenu.concat(aDoc);
				aMenu.push(
					{"title": 'MAIN_MENU::NEW_DOCUMENT', css: 'ico2 add_doc short', disabled:!aAccess.write, nodes:aDoc},
					{"title": 'MAIN_MENU::NEW_UPLOAD', css: 'ico2 upload', "arg": 'upload_file', disabled:!aAccess.write},
					{"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'}
				);
				break;

			case 'C':
				aMenu.push(
					{"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'}
				);
				break;

			case 'T':
				aMenu.push(
					{"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'}
				);
				break;

			case 'N':
				aMenu.push(
					{"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'}
				);
				break;

			case 'I':

				// var nodes = [
				// 	{"title": 'CHAT::ROOM', css: 'room', "arg": 'room_view'},
				// 	{"title": 'CHAT::FILES', css: 'files', "arg": 'files_view'},
				// 	{"title": 'CHAT::EVENTS', css: 'events', "arg": 'events_view'},
				// 	{"title": 'CHAT::PINS', css: 'pins', "arg": 'pins_view'},
				// 	{"title": 'CHAT::MENTIONS', css: 'mentions', "arg": 'mentions_view'},
				// 	{"title": 'CHAT::THREADS', css: 'threads', "arg": 'threads_view'},
				// 	{"title": 'CHAT::UNREAD_THREADS', css: 'threads hidden', "arg": 'unread_threads_view'}
				// ];

				// if (!~['room_view', 'files_view', 'events_view', 'pins_view', 'mentions_view', 'threads_view', 'unread_threads_view'].indexOf(this.__currentView)) {
				// 	this.__currentView = 'room_view'
				// }

				// aMenu = nodes.filter(function(itm, pos){
				// 	if (itm.arg == this.__currentView){
				// 		nodes.splice(pos,1);
				// 		return true;
				// 	}
				// }, this);

				// aMenu[0].css += ' active tch_label ico';
				// aMenu[0].css = aMenu[0].css.replace('hidden', '');
				// aMenu[0].text = getLang('CHAT::DISPLAY') + ':';
				// aMenu[0].subtitle = getLang(aMenu[0].title);
				// delete aMenu[0].title;
				// aMenu[0].nodes = nodes;

				bNoMore = true;
				break;

			case 'X':
				aMenu.push(
					{"title": 'MAIN_MENU::ADD_FOLDER', css: 'ico2 add_folder', "arg": 'add_folder'},
					{"title": 'POPUP_FOLDERS::ADD_SHARED_ACCOUNT', css:'ico2 share_account', "arg":'add_account', disabled:ids[0]!=sPrimaryAccount || !sPrimaryAccountSHARING}
				);

				bNoMore = true;
				break;

			//Items wo Share & More
			default:

					bShort = true;

					switch(sType){
						//Quarantine
						case 'Q':
							aMenu.push(
								{"title": 'MAIN_MENU::DELIVER', css: 'ico2 deliver', disabled:true},
								{"title": 'MAIN_MENU::BLACK_LIST', css: 'ico2 blacklist', disabled:true},
								{"title": 'MAIN_MENU::WHITE_LIST', css: 'ico2 whitelist', disabled:true}
							);
							del = {
								disabled: true
							};
							break;

						//Blacklist & Whitelist
						case 'QL':
							aMenu.push({"title": 'MAIN_MENU::NEW', "arg": 'new_ql', css: 'ico2 new'});

							if (ids[1] === 'SPAM_QUEUE/Blacklist')
								aMenu.push({"title": 'MAIN_MENU::WHITE_LIST', css: 'ico2 whitelist', disabled:true});
							else
								aMenu.push({"title": 'MAIN_MENU::BLACK_LIST', css: 'ico2 blacklist', disabled:true});

							aMenu.push({"title": 'POPUP_ITEMS::SEND_EMAIL_TO', css: 'ico2 send', disabled:true});
							del = {
								disabled: true
							};
							break;

						//Recovery
						case 'G':

							aMenu.push(
								{"title": 'POPUP_ITEMS::RECOVER', css: 'ico2 recover', disabled:true}
							);
							if (!dataSet.get('main',['keep_deleted_items_force_expiration'])) {
								aMenu.push(
									{"title": 'MAIN_MENU::EMPTY_FOLDER', "arg": 'empty', css: 'color2 ico2 empty'}
								);
								del = {
									disabled: true
								};
							}
							break;
					}
		}

	}
	//ITEM(s)
	else
	if (ids.length === 3){
		var bSingle = ids[2].length === 1,
			id = bSingle?ids.slice(0,2).concat(ids[2][0]):null;
		if (bSingle) {
			aRights.STATIC_FLAGS = dataSet.get('items', id.concat('STATIC_FLAGS'));
		}

		if (sType !== 'F' || (bSingle && (dataSet.get('items', id.concat('EVNOWN_ID')) === sPrimaryAccountGWID || aAccess.modify))) {
			if (sType == 'F') {
				await this._create('_share', 'obj_button', 'main', 'color1 rounded share teamchat simple');
				this._share._text(getLang('common::share'));
				this._share._main.classList.remove('ico')
				this._share._onclick = function() {
					Item.collaborate(me.__currentIDs);
				};
			} else if (sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT && sType !== 'E') {
				await this._create('_share', 'obj_button', 'main', 'color1 rounded share teamchat simple');
				this._share._text(getLang('collaboration::share_to_teamchat'));
				this._share._main.classList.add('ico')
				this._share._onclick = function() {
					Item.copy_tch(me.__currentIDs, false, me._gui);
				};
			}
		}
	
		switch(sType){
			case 'M':
				var sPath = this.__currentFolder.join('/'),
					bTemplates = GWOthers.getItem('DEFAULT_FOLDERS','templates') && ~(sPath + '/').indexOf(GWOthers.getItem('DEFAULT_FOLDERS','templates') + '/'),
					bSent = aFolder.DEFAULT == 'S';
						
				var day_starts = GWOthers.getItem('CALENDAR_SETTINGS', 'day_begins') || 9;
				var day_starts_hour = Math.floor(day_starts);
				var day_starts_minute = (day_starts % 1) * 4;

				var now = new IcewarpDate();
				var today = (now.hour() < 21) && now.clone().hour(now.hour() + 3).minute(0);
				var tomorrow = now.clone().add(1, 'day').hour(day_starts_hour).minute(day_starts_minute);
				var next_week = now.clone().add(7, 'days').hour(day_starts_hour).minute(day_starts_minute);

				//SINGLE ITEM
				if (bSingle){

					//Templates
					if (bTemplates){
						aMenu.push(
							{"title": 'MAIN_MENU::NEW_FROM_TEMPLATE', 'arg': 'new_from_template', css:'ico2 from_template'},
							{"title": 'POPUP_ITEMS::EDIT', 'arg': 'edit_template', css:'ico2 edit'}
						);
					}
					else{
						//Drafts
						if (aFolder.DEFAULT == 'D'){
							aMenu.push({"title": 'POPUP_ITEMS::EDIT', css: 'ico2 edit', 'arg': 'edit_message', disabled:!aAccess.modify});
						}

						if (!(aRights.STATIC_FLAGS & 16)) {
							if (aFolder.SPAM){
								aMenu.push(
									{"title": 'MAIN_MENU::REPLY_TO_SENDER', tooltip_text: me.__tooltip('MAIN_MENU::REPLY_TO_SENDER', { key: 'R' }), "arg": 'reply', css: 'ico2 reply'}
								);
							}
							else
							if (!aFolder.RSS){
								aMenu.push(
									{"title": 'MAIN_MENU::REPLY_TO_SENDER', tooltip_text: me.__tooltip('MAIN_MENU::REPLY_TO_SENDER', { key: 'R' }), "arg": 'reply', css: 'ico2 reply', disabled:bSent},
									{"title": 'MAIN_MENU::REPLY_TO_ALL', tooltip_text: me.__tooltip('MAIN_MENU::REPLY_TO_ALL', { key: 'R', shift: true }), "arg": 'reply_all', css: 'ico2 reply_all'}
								);
							}
						}
						if (!(aRights.STATIC_FLAGS & 8)) {
							aMenu.push(
								{"title": 'MAIN_MENU::FORWARD', tooltip_text: me.__tooltip('MAIN_MENU::FORWARD', { key: 'F' }), 'arg': 'forward', css:'ico2 forward'}
							);
						}

						aMenu.push(
							{ title: 'MAIN_MENU::SNOOZE', css:'ico2 snooze noarrow', nodetype: 'click', nodes: [
								today && { title: 'CALENDAR::LATER_TODAY', shortcut: { key: today.format('ddd LT') }, css: '', arg: 'snooze_later' },
								{ title: 'CALENDAR::TOMORROW', shortcut: { key: tomorrow.format('ddd LT') }, css: '', arg: 'snooze_tomorrow' },
								{ title: 'CALENDAR::IN_A_WEEK', shortcut: { key: next_week.format('ddd LT') }, css: '', arg: 'snooze_next_week' },
								{ title: '-' },
								{ title: 'CALENDAR::PICK_DATETIME', css: 'ico2 time', arg: 'snooze_custom' },
								ids[1] === '__@@SNOOZED@@__' && { title: 'MAIN_MENU::UNSNOOZE', css: 'ico2 unsnooze', arg: 'unsnooze' }
							].filter(Boolean)}
						);
					}

					if (!bTemplates && !aFolder.RSS && aFolder.DEFAULT !== 'D') {
						if (aFolder.SPAM){
							if (dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Whitelist'])){
								aMenu.push(
									{"title": 'MAIN_MENU::WHITE_LIST', "arg": 'whitelist_sender', css: 'ico2 whitelist'}
								);
							}
						}
						else
						if (dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Blacklist'])){
							aMenu.push(
								{"title": 'MAIN_MENU::BLACK_LIST', "arg": 'blacklist_sender', css: 'ico2 blacklist'}
							);
						}
					}

					if (this.__currentView != 'mail_view_list' && aFolder.DEFAULT != 'H' && !(aRights.STATIC_FLAGS & 4)){
						aMenu.push({'title': 'MAIN_MENU::PRINT', 'arg': 'print', css: 'ico2 print'});
					}

				}
				//MULTIPLE ITEMS
				else{
					aMenu.push(
						{ title: 'MAIN_MENU::SNOOZE', css:'ico2 snooze noarrow', nodetype: 'click', nodes: [
							today && { title: 'CALENDAR::LATER_TODAY', shortcut: { key: today.format('ddd LT') }, css: 'ico2', arg: 'snooze_later' },
							{ title: 'CALENDAR::TOMORROW', shortcut: { key: tomorrow.format('ddd LT') }, css: 'ico2', arg: 'snooze_tomorrow' },
							{ title: 'CALENDAR::NEXT_WEEK', shortcut: { key: next_week.format('ddd LT') }, css: 'ico2', arg: 'snooze_next_week' },
							{ title: '-' },
							{ title: 'CALENDAR::PICK_DATETIME', css: 'ico2 time', arg: 'snooze_custom' },
							ids[1] === '__@@SNOOZED@@__' && { title: 'MAIN_MENU::UNSNOOZE', css: 'ico2 unsnooze', arg: 'unsnooze' }
						]},
						{"title":'POPUP_ITEMS::MOVE_MAIL_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_MAIL_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_MAIL_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_MAIL_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'},
						{"title":'POPUP_ITEMS::MARK_AS_READ', tooltip_text: me.__tooltip('POPUP_ITEMS::MARK_AS_READ', { key: 'E' }), 'arg': 'mark_read', css: 'ico2 markread', disabled:!aAccess.modify},
						{"title":'POPUP_ITEMS::MARK_AS_UNREAD', tooltip_text: me.__tooltip('POPUP_ITEMS::MARK_AS_UNREAD', { key: 'U' }), 'arg': 'mark_unread', css: 'ico2 markunread', disabled:!aAccess.modify}
					);
					if (!bTemplates && !aFolder.RSS && aFolder.DEFAULT !== 'D') {
						aMenu.push(aFolder.SPAM ?
							{"title": 'MAIN_MENU::WHITE_LIST', "arg": 'whitelist_sender', css: 'ico2 whitelist'} :
							{"title": 'MAIN_MENU::BLACK_LIST', "arg": 'blacklist_sender', css: 'ico2 blacklist'}
						);
					}
				}

				del = {
					disabled: !aAccess.remove
				};
				break;

			case 'E':

				//SINGLE ITEM
				if (bSingle){
					var iFlags = dataSet.get('items',id.concat('EVNFLAGS'));

					aMenu.push(
						{"title":'MAIL_VIEW::ACCEPT', 'arg': 'accept', css: 'ico2 accept', disabled:!(iFlags&32||iFlags&8)},
						{"title":iFlags&2?'MAIL_VIEW::DECLINE':'MAIN_MENU::DELETE', 'arg': 'delete', css: 'ico2 ' + (iFlags&2?'decline':'delete'), disabled:!aAccess.remove}
					);
				}
				//MULTIPLE ITEMS
				else{
					aMenu.push(
						{"title":'POPUP_ITEMS::MOVE_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_ITEM_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_ITEM_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'}
					);
				}

				break;

			case 'F':

			var bLocked = false;

			//SINGLE ITEM
				if (bSingle){
					var sLockID = dataSet.get('items', id.concat('EVNLOCKOWN_ID'));
					bLocked = sLockID && sLockID != sPrimaryAccountGWID,
					sName = dataSet.get('items',id.concat('EVNTITLE'));

					aMenu.push({"title": 'MAIN_MENU::NEW_UPLOAD', css: 'ico2 upload', "arg": 'upload_file', disabled:!aAccess.write});

					if (Item.officeSupport(sName)){
						var sMode;
						if (~['I', 'Y'].indexOf(WMFolders.getType([this._aid, this._fid]))) {
							sMode = 'view';
						}

						var aArgAuto = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName), sMode]],
							aArgWeb = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName), 'edit']],
							aArgWebView = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]}, [Item.downloadFile, [id]], Path.extension(sName), 'view']],
							aArgExt = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName),'external']],
							bIWD = dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true';

						aMenu.push(
							{"title":'POPUP_ITEMS::OPEN', css: 'ico2 open short', "arg": aArgAuto, nodes:[
								{"title":'DOCUMENT::OPENDOCUMENT', css:'ico2 open_edit', 'arg': aArgWeb, disabled: !bIWD},
								{"title":'DOCUMENT::OPENDOCUMENTVIEW', css:'ico2 open_edit', 'arg': aArgWebView, disabled: !bIWD},
								{"title":'OFFICELAUNCHER::OFFICESUITE', css:'ico2 open_suite', 'arg': aArgExt}
							]},
							{"title":'POPUP_ITEMS::DOWNLOAD_FILE', css: 'ico2 download', "arg": 'download_file'}
						);
					}
					else
						aMenu.push({"title":'POPUP_ITEMS::DOWNLOAD_FILE', css: 'ico2 download', "arg": 'download_file'});
					aMenu.push({
						title: 'POPUP_ITEMS::DUPLICATE',
						css: 'ico2 copy',
						arg: [Item.cloneEvent, [id]],
						disabled: !aAccess.write || dataSet.get('items', id.concat('EVNCLASS')) == 'O'
					});
				}
				//MULTIPLE ITEMS
				else{
					aMenu.push(
						{"title":'POPUP_ITEMS::MOVE_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_ITEM_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_ITEM_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'}
					);
				}

				del = {
					disabled: !aAccess.remove || bLocked
				};
				break;

			case 'C':
				//SINGLE ITEM
				if (bSingle){
					var item = dataSet.get('items',id) || {};

					aMenu.push(
						{"title": 'IM::SEND_MAIL', css: 'ico2 send', "arg": 'send'},
						{"title": 'MAIN_MENU::DIAL', css: 'ico2 dial', "arg": 'dial', disabled: item.ITMCLASS == 'L'}
					);
					if(sPrimaryAccountCHAT)
						aMenu.push({title: 'POPUP_ITEMS::INVITE_TEAMCHAT', css: 'ico2 teamchat', arg: 'invite_to_teamchat'});
				}
				//MULTIPLE ITEMS
				else{
					aMenu.push(
						{"title":'POPUP_ITEMS::MOVE_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_ITEM_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_ITEM_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'},
						{"title": 'MAIN_MENU::PRINT', css: 'ico2 print', "arg": 'print'}
					);
				}

				del = {
					disabled: !aAccess.remove
				};
				break;

			case 'T':
				//MULTIPLE ITEM
				if (!bSingle){
					aMenu.push(
						{"title":'POPUP_ITEMS::MOVE_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_ITEM_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_ITEM_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'}
					);
				}

				aMenu.push(
					{"title": 'MAIN_MENU::PRINT', css: 'ico2 print', "arg": 'print'}
				);
				del = {
					disabled: !aAccess.remove
				};
				break;

			case 'N':
				//MULTIPLE ITEMS
				if (!bSingle){
					aMenu.push(
						{"title":'POPUP_ITEMS::MOVE_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::MOVE_ITEM_TO', { key: 'M' }), 'arg': 'move', css: 'ico2 move', disabled:!aAccess.remove},
						{"title":'POPUP_ITEMS::COPY_ITEM_TO', tooltip_text: me.__tooltip('POPUP_ITEMS::COPY_ITEM_TO', { key: 'C' }), 'arg': 'copy', css: 'ico2 copy'}
					);
				}

				aMenu.push(
					{"title": 'MAIN_MENU::PRINT', css: 'ico2 print', "arg": 'print'}
				);

				del = {
					disabled: !aAccess.remove
				};
				break;

			default:
				bShort = true;
				switch(sType){

					//Quarantine
					case 'Q':
						aMenu.push({"title": 'MAIN_MENU::DELIVER', "arg": 'deliver', css: 'ico2 deliver'},
							{"title": 'MAIN_MENU::BLACK_LIST', "arg": 'blacklist', css: 'ico2 blacklist'},
							{"title": 'MAIN_MENU::WHITE_LIST', "arg": 'whitelist', css: 'ico2 whitelist'}
						);
						del = true;
						break;

					//Blacklist & Whitelist
					case 'QL':
						aMenu.push({"title": 'MAIN_MENU::NEW', "arg": 'new_ql', css: 'ico2 new'});

						if (ids[1] === 'SPAM_QUEUE/Blacklist')
							aMenu.push({"title": 'MAIN_MENU::WHITE_LIST', "arg": 'whitelist', css: 'ico2 whitelist'});
						else
							aMenu.push({"title": 'MAIN_MENU::BLACK_LIST', "arg": 'blacklist', css: 'ico2 blacklist'});

						aMenu.push({"title": 'POPUP_ITEMS::SEND_EMAIL_TO', "arg": 'send', css: 'ico2 send'});
						del = true;
						break;

					//Recovery
					case 'G':

						aMenu.push(
							{"title": 'POPUP_ITEMS::RECOVER', "arg": 'recover', css: 'ico2 recover'}
						);
						if (!dataSet.get('main',['keep_deleted_items_force_expiration'])) {
							del = true;
							aMenu.push(
								{"title": 'MAIN_MENU::EMPTY_FOLDER', "arg": 'empty', css: 'color2 ico2 empty'}
							);
						}
						break;
				}
		}
	}

	if (!bNoMore && (!bShort && aMenu.length))
		aMenu.push({"title":'COMMON::MORE', css: 'ico2 more noarrow', "arg": 'more', nodetype: 'click', keep:true, callback: [this, '__more_menu', [dataSet.get('items', [ids[0], ids[1], ids[2]])]]});

	if (sType === 'E' && !~['day_view','week_view','workweek_view','month_view'].indexOf(this.__currentView)) {
		var bgn = GWOthers.getItem('CALENDAR_SETTINGS', 'workweek_begins'),
			end = GWOthers.getItem('CALENDAR_SETTINGS', 'workweek_ends'),
			workweek = bgn > 0 && end > 0 && !(bgn == 1 && end == 7);

		aMenu.push({
			title: 'CHAT::DISPLAY',
			nodetype: 'click',
			nodes: [
				{ title: 'MAIN_MENU::day_view', arg: 'day_view', css: this.__currentView == 'day_view' ? 'active ' : '' },
				{ title: 'MAIN_MENU::week_view', arg: 'week_view', css: this.__currentView == 'week_view' ? 'active ' : '' },
				workweek && { title: 'MAIN_MENU::workweek_view', arg: 'workweek_view', css: this.__currentView == 'workweek_view' ? 'active ' : '' },
				{ title: 'MAIN_MENU::month_view', arg: 'month_view', css: this.__currentView == 'month_view' ? 'active ' : '' }
			].filter(Boolean)
		});
	}

	del && aMenu && aMenu.push({"title": 'MAIN_MENU::DELETE', tooltip_text: me.__tooltip('MAIN_MENU::DELETE', { key: 'Del' }), "arg": 'delete', css: 'color2 ico2 delete', disabled: (del || {}).disabled});

	this._fill(aMenu, 'static');
};

_me.__tooltip = function(sText, shortcut) {
	return getLang(sText) + '<div class="keyboard_shortcut">' + (shortcut.control ? '<div class="switch control"></div>' : '') + (shortcut.alt ? '<div class="switch alt"></div>' : '') + (shortcut.meta ? '<div class="switch meta"></div>' : '') + (shortcut.shift ? '<div class="switch shift"></div>' : '') + '<div class="key">' + shortcut.key + '</div></div>'
}

_me.__more_menu = async function (e, id, parentData, aData) {
	var aMenu,
		sType = WMFolders.getType(this.__currentFolder),
		aAccess = WMFolders.getAccess(this.__currentFolder),
		ids = this.__currentIDs;

	try{
		//Item
		if (ids[2] && ids[2].length){
			await storage.library('obj_context_item');

			id = ids.slice(0,2).concat(ids[2][0]);
			switch(sType){
				case 'M':
					aAccess.STATIC_FLAGS = dataSet.get('items', id.concat('STATIC_FLAGS'));
					aMenu = await obj_context_item.prototype.__createMailMenu.call(this,
						id,
						ids,
						ids[2] && ids[2].length>1,
						dataSet.get('items', id.concat('FROM')),
						aAccess,
						true
					);
					break;

				default:

					if (sType == 'C' && aData.ITMCLASS == 'L')
						sType = 'L';

					aMenu = obj_context_item.prototype.__createGWMenu.call(this,
						id,
						ids,
						sType,
						ids[2] && ids[2].length>1,
						"",
						aAccess,
						{C:'ITMCLASSIFYAS', F:'EVNFILENAME'}[sType] ||  "EVNTITLE",
						gui.frm_main.main.list,
						true,
						aData
					);
				break;
			}
		}
		//Folder
		else{
			await storage.library('obj_tree_folder_context');
			await storage.library('obj_context_folder');
			aMenu = obj_tree_folder_context.__createFolderMenu({aid:this.__currentFolder[0], fid:this.__currentFolder[1]}, true);
			parentData.arg2 = obj_context_folder.prototype._onclick;
		}
	}
	catch {
		aMenu = false;
	}

	return aMenu || false;
};

_me._onclick = async function (e, elm, id, arg) {

	if (e.__arg2){
		if(!e.__arg2.apply({_owner:gui.frm_main.bar.folders}, arguments)) {
			return;
		}
	}
	else
	//More -> obj_context_item uses callbacks directly
	if (Is.Array(arg)) {
		executeCallbackFunction(arg);
		return;
	}

	var sType = WMFolders.getType(this.__currentFolder),
		sPath = this.__currentFolder.join('/'),
		ids = this.__currentIDs,
		aFolderId = {aid:this.__currentFolder[0],fid:this.__currentFolder[1]};

	if (sType === 'X')
		delete aFolderId.fid;

	var args = clone(arg);
	if (Is.Object(arg))
		arg = arg.arg;

	//console.warn(arg, this.__currentFolder, sType, sPath);

	switch (arg) {
		//Mail
		case 'new_mail':
			NewMessage.compose({alias:Item.getAliasFromPath(sPath)});
			break;
		case 'new_template':
			NewMessage.compose({template:true});
			break;
		case 'add_folder':
			await storage.library('obj_context_folder');
			Folder.addFolder(aFolderId, [obj_context_folder.__openFolder]);
			break;
		case 'add_account':
			Folder.addAccount();
			break;
		case 'add_favorite':
			WMFolders.addToFavorites(aFolderId);
			break;
		case 'remove_favorite':
			WMFolders.removeFromFavorites(aFolderId);
			break;
		//RSS
		case 'change_channel':
			Folder.changeChannel(aFolderId);
			break;
		//File
		case 'upload_file':
			await gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [gui.frm_main, '__copyItem', [this.__currentFolder]], this.__currentFolder[0], this.__currentFolder[1], '', (gui.frm_main.main || {})._upload || gui.frm_main.upload, false, ['F', 'I', 'X'], 'X');
			break;
		case 'download_file':
			Item.downloadFile([ids[0],ids[1],ids[2][0]]);
			break;
		//B&W
		case 'new_ql':
			await gui._create('frm_blackwhite', 'frm_blackwhite', '', '', this.__currentFolder[0], this.__currentFolder[1]);
			break;
		//All Folders
		case 'empty':
			Folder.empty(aFolderId);
			break;
		case 'share':
			Folder.share(aFolderId);
			break;

		case 'new_item':
			switch(sType){
				case 'E':
					if (gui.frm_main.main && (gui.frm_main.main._type === 'frm_main_calendar_dayweek' || gui.frm_main.main._type === 'frm_main_calendar_month'))
						gui.frm_main.main._createEvent();
					else
						Item.openwindow(this.__currentFolder, getCurrentEventTime(), null, sType);

					break;

				case 'I':
						var aMap = {'.docx':'_word','.xlsx':'_excel','.pptx':'_ppoint'};
						if (aMap[args.type] && gui.frm_main.main[aMap[args.type]])
							gui.frm_main.main[aMap[args.type]]();
					break;

				default:
					var aValues;
					if (args.type)
						aValues = {'ATTACHMENTS': [{'values': {'ATTTYPE': 'document', 'ATTDESC': args.type}}]};

					Item.openwindow(this.__currentFolder, aValues, null, sType);
			}
			break;
		case 'print_calendar':
		case 'print_list':
			if (gui.frm_main.main && gui.frm_main.main._print)
				gui.frm_main.main._print(arg == 'print_calendar');
			break;

		// EVENT
		case 'day_view':
		case 'week_view':
		case 'workweek_view':
		case 'month_view':
			gui.frm_main._selectView({
				aid: sPrimaryAccount,
				fid: "__@@VIRTUAL@@__/__@@EVENTS@@__"
			}, arg);

		// //TEAMCHAT
		// case 'room_view':
		// case 'files_view':
		// case 'events_view':
		// case 'pins_view':
		// case 'mentions_view':
		// case 'threads_view':
		// case 'unread_threads_view':
		// 	if (this.__opt.context) {
		// 		this.__opt.context._serverSort(arg);
		// 		this.__viewSelect_handler(arg);
		// 	} else {
		// 		gui.frm_main._selectView(aFolderId, arg);
		// 	}
		// 	break;

		//ITEMS
		default:
			if (ids.length === 3){

				id = this.__currentFolder.concat(ids[2].slice(0,1));

				var day_starts = GWOthers.getItem('CALENDAR_SETTINGS', 'day_begins') || 9;
				var day_starts_hour = Math.floor(day_starts);
				var day_starts_minute = (day_starts % 1) * 4;

				var fid, now = new IcewarpDate();

				switch(arg){
					//Recovery items
					case 'recover': Item.recover(ids);
						break;
					case 'deliver': OldMessage.deliver(ids);
						break;
					case 'whitelist': OldMessage.whitelist(ids);
						break;
					case 'blacklist': OldMessage.blacklist(ids);
						break;

					case 'send':
					case 'invite_to_teamchat':
						var item = dataSet.get('items', id),
							email;

						if (item.ITMCLASS == 'L')
							email = '[' + ids[1] + '::' + (item.ITMCLASSIFYAS || item.ITMTITLE)+']';
						else
							email = item.LCTEMAIL1 || item.LCTEMAIL2 || item.LCTEMAIL3 || item.SNDEMAIL;

						if (email){
							if (arg == 'send')
								NewMessage.compose({to:email});
							else{
								Item.invite_tch(email);
							}
						}
						break;

					case 'dial':
						gui.frm_main.__showDialDialog.apply(null, id);
						break;
					case 'delete':
							if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.list && gui.frm_main.main.list.__deleteItems)
								gui.frm_main.main.list.__deleteItems({aid:ids[0],fid:ids[1]},ids[2]);
							else
							if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.calendar){
								if (ids[2].length == 1){
									var aid = ids[0],
										oRepeating, n;
									fid = ids[1],
									id  = ids[2][0];

									if (Item.hasReccurence([aid, fid, id]))
										oRepeating = dataSet.get('items', [aid, fid, id]);

									//strip pipe
									if ((n = id.indexOf('|')) >= 0)
										id = id.substr(0,n);

									Item.remove([aid, fid, [id]], false, oRepeating, gui.frm_main.main.calendar);
								}
							}
							else
								Item.remove(ids);

						break;

					//Mail
					case 'mark_read':
						OldMessage.markAsRead(ids);
						break;
					case 'mark_unread':
						OldMessage.markAsUnread(ids);
						break;

					case 'reply':
						OldMessage.reply({id});
						break;
					case 'reply_all':
						OldMessage.reply({id, bReplyToAll: true});
						break;
					case 'forward':
						OldMessage.forward({id});
						break;
					case 'new_from_template':
						var old = new OldMessage;
						await old.init(id);
						NewMessage.compose(old);
						break;
					case 'edit_message':
						OldMessage.edit(id);
						break;
					case 'edit_template':
							OldMessage.edit(id,{template:true});
						break;
					case 'blacklist_sender':
						OldMessage.blacklistSender(ids, gui.frm_main.main.list, gui.frm_main.main.list && gui.frm_main.main.list.__getNext(ids[2]));
						break;
					case 'whitelist_sender':
						OldMessage.whitelistSender(ids, gui.frm_main.main.list, gui.frm_main.main.list && gui.frm_main.main.list.__getNext(ids[2]));
						break;

					//Event
					case 'accept':
						fid = id[1];
						for (var i in dataSet.get('items', [id[0]])) {
							if ((dataSet.get('items', [id[0], i, id[2]]) || {}).EVNFOLDER) {
								fid = i;
								break;
							}
						}
						WMItems.imip({aid: id[0], fid: fid, iid: id[2]},'accept',[async function(bOK){
							if (bOK){
								//redraw menu
								var itm = dataSet.get('items', [id[0], fid, id[2]]);
								if (itm['EVNFLAGS'] & 32){
									itm['EVNFLAGS'] -= 30;

									dataSet.update('items',id);
									this.__menu(this.__currentIDs);
								}
								//refresh view
								else
									Item.__refreshView(ids);
							}

						}.bind(this)]);
						break;

					//Generic item
					case 'move':
						Item.move(ids, gui.frm_main.main.list, gui.frm_main.main.list && gui.frm_main.main.list.__getNext(ids[2]));
						break;
					case 'copy':
						Item.copy(ids, gui.frm_main.main.list);
						break;

					case 'print':
						switch(sType){
							case 'M':
								if (gui.frm_main.main && gui.frm_main.main.mailview)
									gui.frm_main.main.mailview._print();
							default:
								Item.print(ids);
						}
						break;

					case 'snooze_later':
						var today = (now.hour() < 21) && now.clone().hour(now.hour() + 3).minute(0);
						OldMessage.snooze(ids, today);
						break;
					case 'snooze_tomorrow':
						var tomorrow = now.clone().add(1, 'day').hour(day_starts_hour).minute(day_starts_minute);
						OldMessage.snooze(ids, tomorrow);
						break;
					case 'snooze_next_week':
						var next_week = now.clone().add(7, 'days').hour(day_starts_hour).minute(day_starts_minute);
						OldMessage.snooze(ids, next_week);
						break;
					case 'snooze_custom':
						OldMessage.snooze(ids);
						break;
					case 'unsnooze':
						OldMessage.snooze(ids, false);
						break;
				}
			}
	}

};