/**
 * Horizontal menu object
 *
 * <p item>	is text content of menu
 *			if value is equal to '-' than <hr> tag is used instead of link
 *
 * Input array example:
 * x[<p item>]	[arg] = obj | string
 *				[disabled]
 *				[css] = 'className'
 *				[nodes][<ch item>]	[arg]
 *									[css]
 *									[nodes]
 *
 * This object handles dropdown and submenus on hover, click or context for menu buttons
 **/
_me = obj_hmenu_plus.prototype;
function obj_hmenu_plus(){};

_me.__constructor = async function(){
	var me = this;

	this._opt = {collapse:false};

	this.__ePull = null;
	this.__timeout = null;
	this.__openedNode = [];
	this.__timeoutdelay = 150;

	this.__sizes = {};

	this._upMenu = false; // show pullUp menu

	// Open dropdown menu for this item
	async function openNodes(id,elm,e) {
		var body = me._gui._main;

		//odznacit parent elm
		if (me.__openedNode.length)
			me.__close();

		me.__openedNode.push(id);

		//vytvorit nabidku
		if (!me.__ePull){

			me.__ePull = mkElement('div',{className:'obj_context '+(me._css?' '+me._css+'_plus':'')/*, id:this._pathName + '#' + anchor*/});

			if (window.navigator.msPointerEnabled)
				me.__ePull.onmspointerup = function(e){
					//Extend mouseEvent by arg2 attribute
					if (me.__aData[id]['arg2'])
						e.__arg2 = me.__aData[id]['arg2'];

					me._main.onmspointerup.apply(me, arguments);
				};
			else
				me.__ePull.onclick = function(e){
					//Extend mouseEvent by arg2 attribute
					if (me.__aData[id]['arg2'])
						e.__arg2 = me.__aData[id]['arg2'];

					me._main.onclick.apply(me, arguments);
				};

			me.__ePull.onmousemove = function(){
				if (me.__timeout){
					window.clearTimeout(me.__timeout);
					me.__timeout = null;
				}
			};

			me.__ePull.mouseleave = function(){
				if (me.__ignoreMouseOut)
					return;

				if (!me.__timeout)
					me.__timeout = window.setTimeout(function(){
						if (this && this._destructed === false)
							this.__close();
					}.bind(me),
					me.__timeoutdelay);
			};

			body.appendChild(me.__ePull);
		}
		else{
			me.__ePull.style.display = 'block';

			while (me.__ePull.firstChild)
				me.__ePull.removeChild(me.__ePull.firstChild);
		}

		me.__ePull.setAttribute('menu', me.__aData[id]['rel'] || '');

		//position
		var pos = getSize(elm);

		if (me._upMenu){
			addcss(me.__ePull,'bottom');
			me.__ePull.style.bottom = (body.clientHeight - pos.y) + 'px';
		}
		else{
			addcss(me.__ePull,'top');
			me.__ePull.style.top = (pos.y+pos.h)+'px';
		}
		if(me.__ePull.clientHeight > body.clientHeight) {
			addcss(me.__ePull, 'scrollable');
		} else {
			removecss(me.__ePull, 'scrollable');
		}

		//fill
		if (me.__aData[id]['callback']){
			var rows = await executeCallbackFunction(me.__aData[id]['callback'], e, id, me.__aData[id]);

			if (rows){
				if (rows instanceof Element)
					me.__ePull.appendChild(rows);
				else
					me.__ePull.appendChild(me.__row(rows, id));
			}
			else
			if (rows === false)
				return;
		}
		else
		if (me.__aData[id]['child'])
			me.__ePull.appendChild(me.__aData[id]['child']);
		else
			me.__ePull.appendChild(me.__row(me.__aData[id].nodes,id));

		var win = me._main.ownerDocument.defaultView,
			w = win.innerWidth || body.offsetWidth,
			left = (pos.x+pos.w/2) - me.__ePull.offsetWidth/2,
			right = (w-pos.x-pos.w/2 - me.__ePull.offsetWidth/2);

		left = left<0?0:left,

		right = right < 10 ? 10 : right;
		right = right > (win.innerWidth - 10 - me.__ePull.offsetWidth) ? (win.innerWidth - 10 - me.__ePull.offsetWidth) : right;
		if (w < left+me.__ePull.offsetWidth)
			left = w-me.__ePull.offsetWidth;


		if(gui._rtl){
			me.__ePull.style.right = right+'px';
			me.__ePull.style.left = 'auto';
		}else{
			me.__ePull.style.left = left + 'px';
		}

		//Arrow
		//var pos2 = getSize(me.__ePull);
		// if(gui._rtl){
		// 	me.__ePull.appendChild(mkElement('div',{style:{right:(pos2.x + pos2.w - pos.x - pos.w / 2) + 'px', left:'auto'}}));
		// }else{
		// 	me.__ePull.appendChild(mkElement('div',{style:{left:(pos.x+pos.w/2-pos2.x) + 'px'}}));
		// }

		//oznacit aktualni parent elm
		var prt = document.getElementById(me._pathName+'/'+id);
		if (prt){
			addcss(prt,'active');
			prt = null;
		}

		executeCallbackFunction(me.__aData[id].afterRender, elm);
	};

	// Handle opening of new dropdown menu (closing other open etc)
	function handleOpenEvent(e) {
		var elm = e.target;
		if (e.detail instanceof Element) {
			elm = e.detail;
		}
		// Find if we are within an A element
		if (elm.tagName != 'A')
			elm = Is.Child(elm,'A',me._main);

		if (elm.tagName != 'A'){
			//odznacit parent elm
			if (me.__openedNode.length)
				me.__close();

			return false;
		}

		if (!me.__root || !me.__root.contains(elm)) {
			return;
		}

		// We are still inside, clear timeout
		if (me.__timeout){
			window.clearTimeout(me.__timeout);
			me.__timeout = null;
		}

		// Get id from element
		var id = me.__getId(elm.id);

		// Show tooltip if specified
		if (me.__aData[id] && e.type=='mousemove' && (me.__aData[id].tooltip || me.__aData[id].tooltip_text || (me.__aData[id].title && (hascss(me._main,'short') || me._main.getAttribute('iw-mode')=='smaller')))) {
			me.__setTooltip(elm, me.__aData[id].tooltip_text || getLang(me.__aData[id].tooltip || me.__aData[id].title));
		}

		// If dropdown for this button is already displayed just return
		if (me.__openedNode[me.__openedNode.length-1] == id){

			// Click on same button second time closes dropdown
			if (e.type == 'click')
				me.__close();

			return false;
		}

		var ntype = Is.Array(me.__aData[id]['nodetype'])?me.__aData[id]['nodetype']:[me.__aData[id]['nodetype'] || 'hover'];

		// Delay staying open longer for clicking
		me.__timeoutdelay = e.type=='click' && inArray(ntype, 'click')>-1? 2000 : 100;

		//OPEN NEW NODES - Check for type (hover, click or context)
		if (me.__aData[id] && !me.__aData[id]['disabled'] && (me.__aData[id]['nodes'] || me.__aData[id]['callback'])){
			if (
				(e.type=='mousemove' && inArray(ntype, 'hover')>-1) ||
				(e.type=='mousemove' && inArray(ntype, 'drag')>-1 && gui.__dragging) ||
				(e.type=='contextmenu' && inArray(ntype, 'context')>-1) ||
				(e.type=='click' && (inArray(ntype, 'click')>-1 || inArray(ntype, 'hover')>-1))
			){
				openNodes(id,elm,e);
				return;
			}
		}
		// try to close old nodes
		else
			me.__close();
	};

	AttachEvent(this._main,'onmousemove', function(e){
		handleOpenEvent(e);
	});

	AttachEvent(this._main,'onclick', function(e){
		handleOpenEvent(e);
	});

	AttachEvent(this._main,'oncontextmenu', function(e){
		handleOpenEvent(e);
		e.preventDefault();
	});

	AttachEvent(this._main,'onmouseout', function(e){
		if(me.__ignoreMouseOut) {
			return;
		}

		// Check if we are still within the menu
		var rel = e.relatedTarget || e.toElement,
			inside = Is.Child(rel, me.__root);

		// Close any remaining tooltip if we left the menu
		if(!inside)
			gui.tooltip._hide();

		// Close the tooltip if we left the menu button
		if(e.target.nodeName=='A' && (!rel || rel.nodeName!='SPAN'))
			gui.tooltip._hide(e.target);

		// Close any remaining open dropdowns
		if (me.__openedNode!=null){
			if (me.__timeout)
				window.clearTimeout(me.__timeout);

			me.__timeout = window.setTimeout(function(){
				if (this && this._destructed === false)
					this.__close();
			}.bind(me),
			me.__timeoutdelay+100);
		}
	});

	// Notice also clicks outside the menu

	this._gui._obeyEvent('click',[this,'__outsideclick']);

	this._add_destructor('__destruct_menu');
};
_me.__setTooltip = function(elm, sString){
	gui.tooltip._show(elm, sString, {y: '-20', html: true});
};
// User clicked outside of the menu
_me.__outsideclick = function(e) {
	if (!e || (Is.Child(e.target, this.__ePull) == false && Is.Child(e.target, this._main) == false)) {
	 	this.__close();
	}
};

// When destructing, close any open nodes and don't listen for global clicks
_me.__destruct_menu = function() {
	this.__close(true);
	gui._disobeyEvent('click',[this,'__outsideclick']);
};

// Close open menu nodes
_me.__close = function(bFully){
	//clear timeout
	if (this.__timeout){
		window.clearTimeout(this.__timeout);
		this.__timeout = null;
	}

	//odznacit parenta
	if (this.__openedNode.length){
		for(var i = this.__openedNode.length-1;i>=0;i--){

			//call callback 2
			if (this.__aData[this.__openedNode[i]] && this.__aData[this.__openedNode[i]].destructor){
				executeCallbackFunction(this.__aData[this.__openedNode[i]].destructor, this.__openedNode[i], this.__aData[this.__openedNode[i]]);
			}

			var elm = document.getElementById(this._pathName+'/'+this.__openedNode[i]);
			if (elm){
			    removecss(elm,'active');
				elm = null;
			}

			this.__openedNode.splice(i,1);
		}
	}

	//close popup
	try{
		if (this.__ePull)
			if (bFully){
				this.__ePull.parentNode.removeChild(this.__ePull);
				this.__ePull = null;
			}
			else
				this.__ePull.style.display = 'none';
	}
	catch(er){ console.log(this._name||false,er)}
};

_me.__getId = function(elmid){
	return elmid.substr(this._pathName.length+1);
};

_me._fill = async function (aData){
	this.__close(true);
	await this._clear();

	// retrieve data from dataset
	if (!aData && this._listener)
		this.__aData = dataSet.get(this._listener,this._listenerPath);
	else
	if (!(this.__aData = (aData || []).filter(Boolean)).length)
		return;

	this.__root = this.__row(this.__aData.filter(Boolean),'',true);

	//reset auto-collapse
	if (this._opt.collapse){
		this.__resize_reset();
		this.__resize_handler();
	}
};

// auto-collapse
_me._autoCollapse = function(b){
	this._opt.collapse = b;
	if (b){
		this.__iframe = mkElement('iframe');
		this._main.appendChild(this.__iframe);

		this.__iframe.contentWindow.onresize = function (){
			this.__resize_handler()
		}.bind(this);
	}
	else{
		if (this.__iframe){
			this.__iframe.parentNode.removeChild(this.__iframe);
			this.__iframe = null;
		}

		this.__resize_reset();
	}
};

_me.__resize_reset = function(){
	this.__sizes = {};
	this._main.removeAttribute('iw-mode');
};
_me.__resize_handler = function(){
	this._main.setAttribute('iw-mode', 'smaller');
};