function obj_highlight(){};

obj_highlight.__casing = {
	"xml": 'HTML / XML',
	"markdown": 'Markdown',
	"dart": 'Dart',
	"cs": 'C#',
	"json": 'JSON',
	"swift": 'Swift',
	"php": 'PHP',
	"bash": 'Bash',
	"dockerfile": 'Dockerfile',
	"css": 'CSS',
	"python": 'Python',
	"objectivec": 'Objective-C',
	"sql": 'SQL',
	"typescript": 'TypeScript',
	"javascript": 'JavaScript',
	"java": 'Java',
	"cpp": 'C++',
	"powershell": 'PowerShell',
	"diff": 'Diff',
	"go": 'Go',
	"delphi": 'Delphi'
};

obj_highlight._md = function() {
	if (!this.__md) {
		this.__md = markdownit({
			breaks: true,
			linkify: true,
			typographer: true,
			highlight: function(str, language) {
				if (language && (language === 'noformat' || !hljs.getLanguage(language))) {
					return '<pre class="hljs ' + language + '"><code>' + str.escapeHTML() + '</code></pre>';
				}

				var legend = '';
				var highlight = {
					value: str
				};
				if (str.trim().split(/\n/).length > 2 || language) {
					try {
						highlight = language ? hljs.highlight(str, { language: language }) : hljs.highlightAuto(str);
					} catch {
						highlight = hljs.highlightAuto(str);
					}

					legend = highlight.language ? '<div class="legend">' + (this.__casing[highlight.language] || highlight.language) + '</div>' : '';
				} else {
					highlight.value = highlight.value.escapeHTML();
				}

				if (highlight.language === 'html') {
					highlight.value = highlight.code.escapeHTML();
				}
				return '<pre class="hljs ' + (highlight.language || '') + '">' + legend + '<code>' + highlight.value + '</code></pre>';
			}.bind(this)
		});

		var defaultRender = this.__md.renderer.rules.link_open || function (tokens, idx, options, env, self) {
			return self.renderToken(tokens, idx, options);
		};
		
		this.__md.renderer.rules.link_open = function (tokens, idx, options, env, self) {
			// Add a new `target` attribute, or replace the value of the existing one.
			tokens[idx].attrSet('target', '_blank');
			
			// Pass the token to the default renderer.
			return defaultRender(tokens, idx, options, env, self);
		};

		// skip ##internalservicedomain
		this.__md.linkify.add('##', {
			validate: function (text, pos) {
				var tail = text.slice(pos);
				return ((tail.match(/.*?##/) || [])[0] || []).length;
			},
			normalize: function(match) {
				match.url = 'data:';
			}
		});

		// skip mention @[us.er@domain]
		this.__md.linkify.add('@[', {
			validate: function (text, pos) {
				var tail = text.slice(pos);
				return ((tail.match(/.*?\]/) || [])[0] || []).length;
			},
			normalize: function(match) {
				match.url = 'data:';
			}
		});
	}
	return this.__md;
};

obj_highlight._highlight = function(sBody, bSubstitutePForDiv) {
	var result = '';
	try {
		sBody = sBody.replace(/^\+\s/g, '░+░').replace(/^([#>]\s?)+$/g, '░$1░').replace(/^(\s*\d+)\.(\s?\d+)\./, '$1\\.$2\\.');
		result = this._md().render(sBody).replace(/░\+░/g, '+ ').replace(/░((?:[#>]|(?:&gt;))\s?)+░/g, '$1').replace(/(<\/?(?:ol|ul|li)>)\s+(<\/?(?:ol|ul|li)>)/g, '$1$2');
	} catch {
		//
	}

	for (var i in ShortURL.services) {
		var service = ShortURL.services[i];
		result = result.replace(new RegExp('href="' + service + '"', 'g'), '$1 rel="opener"');
	}
	result = result.replace(/(href="[^"]+\/collaboration\/\?ticket=(?:.*?)&url=(?:.*?)(?:&|$))"/g, '$1 rel="opener"');

	if (bSubstitutePForDiv) {
		result = result.replace(/<(\/?)p\b/g, '<$1div');
	}

	return result;
};
