_me = obj_groupfiles_item.prototype;
function obj_groupfiles_item(){};

_me.__constructor = async function(aData) {
	this.__init(aData);

	this.__updateTime(60000);
	this._add_destructor('__destructor');
};

_me.__init = async function(aData){

	this.__aData = aData;

	var me = this,
		d = new IcewarpDate(aData.EVN_MODIFIED*1000),
		out = clone(aData, true);

	//ouput
	out.size = parseFileSize(out.EVNCOMPLETE);
	out.fulltime =  d.format('L LT');
	out.date = this.__getTimeString(d);
	out.avatar = obj_avatar.getAvatarHTML({
		email: aData.EVNMODIFIEDOWNEREMAIL,
		name: aData.EVNMODIFIEDOWNERNAME || aData.EVNMODIFIEDOWNEREMAIL,
		size: 28
	});
	out.modified_name = (out.EVNMODIFIEDOWNERNAME || out.EVNMODIFIEDOWNEREMAIL).escapeHTML();
	out.draft = this.__aData.EVNFLAGS & 128;
	out.ext = 'filetype ' + Item.getFileType(aData.EVNTITLE);

	out.EVNTITLE = 	out.EVNTITLE || getLang('EVENT_VIEW::NOTITLE');

	await this._draw('obj_groupfiles_item', 'main', {item:out});

	//// LOCK ////
	var eLock = this._getAnchor('lock');
	if (!eLock)
		return;

	if (this.__aData.EVNLOCKOWN_ID){
		switch (this.__aData.EVNLOCKOWN_ID){
			case sPrimaryAccountGWID:
				addcss(this._main,'locked');
				eLock.title = getLang('FILE::LOCKED_BY_ME');
				eLock.onclick = function(){
					Item.set_lock([aData.aid,aData.fid,aData.iid], false, false, null, 'I');
				};
				break;

			default:
				addcss(this._main,'locked');
				addcss(eLock, 'red');
				if (this.__aData.EVNLOCKOWN_EMAIL){
					eLock.title = getLang('FILE::LOCKED_BY',[this.__aData.EVNLOCKOWN_EMAIL.escapeHTML()]);
					eLock.onclick = function(){
						NewMessage.compose({to:aData.EVNLOCKOWN_EMAIL, subject:aData.EVNTITLE});
					};
				}
				else{
					eLock.title = getLang('FILE::LOCKED');
				}
		}
	}
	else{
		removecss(this._main,'locked');
		eLock.onclick = function(){
			Item.set_lock([aData.aid,aData.fid,aData.iid], true, false, null, 'I');
		};
	}


	//// DOWNLOAD ////
	this._getAnchor('icon').onclick = this._getAnchor('name').onclick = async function(){

		if (hascss(me._main, 'edit')) return;

		if (out.EVNCLASS == 'M'){
			var aLockInfo = {
				EVNLOCKOWN_EMAIL:me.__aData.EVNLOCKOWN_EMAIL,
				EVNLOCKOWN_ID:me.__aData.EVNLOCKOWN_ID,
				EVNTITLE:out.EVNTITLE,
				draft:me.__aData.EVNFLAGS & 128,
				id:me.__aData.iid
			};

			OldMessage.openwindow([aData.aid, aData.fid, aData.iid+'|@@MAIN@@'], null, aLockInfo);
		}
		else
		if (out.EVNTICKET && Path.extension(aData.EVNTITLE) == 'pdf' && GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') != 1) {
			var pdf = await gui._create('pdf', 'frm_pdf');
			pdf._load(out.EVNTICKET, aData.EVNTITLE);
		} else
		if (out.EVNTICKET && Item.imageSupport(aData.EVNTITLE)){
			var img = await gui._create('imgview','frm_imgview');
				await img._fill([{
					url:out.EVNTICKET,
					title:aData.EVNTITLE
				}]);
				img._value(0);
		}
		else
		if (Item.editSupport(aData.EVNTITLE)){
			Item.previewItem([aData.aid, aData.fid, aData.iid]);
		}
		else
		if (Item.officeSupport(aData.EVNTITLE)) {
			Item.officeOpen(aData,[me,'_download'], Path.extension(aData.EVNTITLE));
		}
		else
			me._download();
	};


	this._main.querySelector('.control>.share').onclick = function(){
		Item.collaborate([aData.aid,aData.fid, aData.iid], this._gui);
	};

	this._main.querySelector('.control>.download').onclick = function(){
		this._download();
	}.bind(this);
};

_me._download = function(){
	if (this.__aData.EVNTICKET)
		return downloadItem(this.__aData.EVNTICKET,true);
	else
		return Item.downloadFile([this.__aData.aid, this.__aData.fid, this.__aData.iid]);
};

_me._share = function(b){
	if (b){
		addcss(this._main,'share');
		this.email._focus();
	}
	else{
		removecss(this._main,'share');
		this.share._focus();
	}
};

_me._send = function(){

	var me = this,
		email = MailAddress.splitEmailsAndNames(this.email._value());

	if (!this.send._disabled() && email && (email = email[0]) && (email = email.email)){

		this.email._disabled(true);
		this.send._disabled(true);

		WMItems.action({aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid, values:{EMAIL:email}},'notify_groupchat',[
			function(bOK){

				if (bOK){
					me._share(false);
					me.email._value('');

					//notify OK
					gui.notifier._value({type: 'message_sent'});
				}

				me.email._disabled(false);
				me.send._disabled(false);

				if (!bOK){
					me.email._select();

					//notify Error

				}
			}
		]);
	}
};

_me._edit = async function(b){

	if (b){
		if (!this.inp_edit){
			addcss(this._main, 'edit');
			var inp = await this._create('inp_edit','obj_input','name', 'obj_input_100 noborder');
				inp._value(this.__aData.EVNTITLE);
				inp._setRange(0, Math.ceil(this.__aData.EVNTITLE.lastIndexOf('.')) || this.__aData.EVNTITLE.length);

			inp._onblur	= function(){
				this._onsubmit();
			};

			inp._onsubmit = function(){
				var v = this.inp_edit._value();

				inp._onblur = null; //avoid double submitting

				if (v && Is.Filename(v) && this.__aData.EVNTITLE !== v){

					this._getAnchor('name').querySelector('.filename').innerText = v;
					this._edit(false);

					var aItemInfo = {values:{EVNTITLE:v}};

					WMItems.add([this.__aData.aid, this.__aData.fid, this.__aData.iid || this.__aData.EVN_ID], aItemInfo,'','','', [function(bOK){

						if (bOK === true)
							this._parent._fire(this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID), 'update');
						else
							this._getAnchor('name').querySelector('.filename').innerText = this.__aData.EVNTITLE;

					}.bind(this)]);

				}
				else
					this._edit(false);

			}.bind(this);

			inp._onclose = function(){
				this._parent._edit();
			};
		}
	}
	else{
		if (this.inp_edit){
			this.inp_edit._destruct();
		}

		removecss(this._main, 'edit');
	}
};

_me.__getTimeString = function(d){
	return getLang('CHAT::FILE_MODIFY', [d.fromNow(), (this.__aData.EVNMODIFIEDOWNERNAME || '').escapeHTML()]);
};

_me.__updateTime = function(iInterval){

	if (this.__updTimeInt)
		clearInterval(this.__updTimeInt);

	this.__updTimeInt = setInterval(
		function () {
			var elm = this._main.querySelector('div.file>.date'),
				d = new IcewarpDate(this.__aData.EVN_MODIFIED * 1000);

			if (elm)
				elm.innerHTML = this.__getTimeString(d);

			if (iInterval < 3600000) {
				var now = new IcewarpDate();
				if (now.diff(d) > 3600000)
					this.__updateTime(3600000);
			}

		}.bind(this), iInterval);
};

_me.__update = function(){
	var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid || this.__aData.EVN_ID, values:['EVN_ID','EVNTITLE', 'EVNCLASS', 'EVNTICKET', 'EVN_MODIFIED','EVNTHUMBNAILID','EVNTHUMBNAILTIME','EVNPROCESSINGQUEUED','EVNCOMPLETE','EVNLOCKOWN_EMAIL','EVNLOCKOWN_ID','EVNFLAGS']};

	WMItems.list(aItemsInfo,'','','',[function(aData){
		this._edit(false);

		if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID)])){
			for (var k in aData)
				this.__aData[k] = aData[k];

			this.__init(this.__aData);
		}

	}.bind(this)]);
};

_me.__destructor = function(){
	if (this.__updTimeInt)
		clearInterval(this.__updTimeInt);
};
