_me = obj_groupevents_item.prototype;
function obj_groupevents_item(){};

_me.__constructor = async function(aData) {
	this.__fill(aData);
};

_me.__fill = async function(aData){
	await this._clean();

	var me = this;

	this.__aData = aData;
	this.__aData.iid = WMItems.__clientID(aData.EVN_ID);
	this.__aData.start = IcewarpDate.julian(aData.EVNSTARTDATE, Math.max(aData.EVNSTARTTIME, 0));
	this.__aData.end = IcewarpDate.julian(aData.EVNENDDATE, Math.max(aData.EVNENDTIME, 0));

	var out = clone(this.__aData, true),
		org = (out.EVNORGANIZER?MailAddress.splitEmailsAndNames(out.EVNORGANIZER):[{name:out.EVNOWNERNAME, email:out.EVNOWNEREMAIL}])[0];

	out.avatar = obj_avatar.getAvatarHTML({
		email: org.email || 'blank',
		name: org.name || org.email,
		size: 48
	});
	out.name = org.name || org.email;
	out.title = out.EVNTITLE || getLang('EVENT_VIEW::NOTITLE');
	out.date = this.__date();
	out.meeting = !!out.EVNMEETINGID;

	await this._draw('obj_groupevents_item', 'main', {item:out});

	this._main.ondblclick = function(){
		Item.openwindow([me.__aData.aid, me.__aData.fid, me.__aData.iid], null, me.__aData, 'E', [me, '__update']);
	};

	//Meet button
	if (this.btn_meet){
		this.btn_meet._onclick = function(){
			me.__join();
		};
		this.__badge();
	}

	//Accept button
	this.btn_accept._disabled(sPrimaryAccountGUEST === 1);

	if (out.EVNMYSTATUS == 'A' || out.EVNMYSTATUS == 'D'){
		removecss(this.btn_accept._main, 'color3');
		this.btn_accept._value(out.EVNMYSTATUS == 'A'?'FORM_BUTTONS::ACCEPTED':'FORM_BUTTONS::DECLINED');
	}

	this.btn_accept._onclick = async function(e){
		e.stopPropagation();
		e.preventDefault();

		me.cmenu = await gui._create('cmenu','obj_context');
		await me.cmenu._fill([
			{title:'FORM_BUTTONS::ACCEPT', arg:[me,'_action',['accept']], disabled: out.EVNMYSTATUS == 'A'},
			{title:'FORM_BUTTONS::DECLINE', arg:[me,'_action',['decline']], disabled: out.EVNMYSTATUS == 'D'}
		]);
		me.cmenu._placeMenu(this._main, {mode:'bottom'});
	};

	//Menu button
	var aMenu = [{
			css: 'ico2 edit',
			title: 'POPUP_ITEMS::EDIT',
			arg: [function() {
				this._main.ondblclick();
			}.bind(this)]
		}, {
			css: 'ico2 delete color2',
			title: 'POPUP_ITEMS::DELETE',
			arg: [Item.remove, [[me.__aData.aid, me.__aData.fid, [me.__aData.iid]], false, null, '', '',
				[function(bOK){
					if (bOK)
						this._parent._fire(WMItems.__clientID(me.__aData.EVN_ID), 'delete');
				}.bind(this)]
			]]
		}];

	this.btn_menu._onclick = async function(e) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();

		me.cmenu = await gui._create("cmenu", "obj_context");
		await me.cmenu._fill(aMenu);
		me.cmenu._placeMenu(this.btn_menu._main, {mode:'bottom'});

		return false;
	}.bind(this);

};

_me._action = async function(name){
	var me = this,
		aItem = {aid:me.__aData.aid, fid:me.__aData.fid, iid:me.__aData.iid};

	if (!this.__aData.EVNRCR_ID)
		this.btn_accept._disabled(true);

	switch(name){
		case 'decline':
			if (me.__aData.EVNRCR_ID) {
				gui._create('frm_confirm','frm_confirm_repeating','','', [async function(iState) {
					var frm = await gui._create('decline', 'frm_text', '', 'frm_ok_cancel', [
						function (s) {
							aItem.reason = s;
							aItem.gwparams = {};
							switch (+iState) {
								case 2:
									aItem.EXPFOLLOWING = 'true';
								case 0:
									aItem.EXPDATE = me.__aData.EVNSTARTDATE;
							}
							WMItems.imip(aItem, name, [function () {
								me.__update(true);
							}]);
						}], 'EVENT::REASON');

					frm._onclose = function () {
						me.btn_accept._disabled(false);
					};

					frm.x_btn_ok._value('FORM_BUTTONS::DECLINE');
				}],'REPEATING_CONFIRM::TITLE_DELETE','REPEATING_CONFIRM::TEXT_DELETE');
			} else {
				var frm = await gui._create('decline', 'frm_text', '', 'frm_ok_cancel', [
					function (s) {
						aItem.reason = s;
						WMItems.imip(aItem, name, [function () {
								me.__update(true);
							}]);
					}], 'EVENT::REASON');

				frm._onclose = function () {
					me.btn_accept._disabled(false);
				};

				frm.x_btn_ok._value('FORM_BUTTONS::DECLINE');
			}
		break;

		case 'accept':
			WMItems.imip(aItem, name, [function(){
				me.__update(true);
			}]);
	}
};

_me.__update = function(bOK){

	if (bOK == true){
		var me = this;

		WMItems.list({aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid, values: obj_groupchat.aRequestArray},'','','',[function(aData){
				if (aData && (aData = aData[me.__aData.aid]) && (aData = aData[me.__aData.fid]) && (aData = aData[me.__aData.iid])){

					if (aData.EVNSTARTDATE != me.__aData.EVNSTARTDATE || aData.EVNSTARTTIME != me.__aData.EVNSTARTTIME)
						me._parent._serverSort(me._parent.__aRequestData.folder, true);
					else
						me.__fill(aData);
				}
				// delete
				else{
					me._parent._remove(me._anchor, me.__aData.iid);

					if (me._parent && !me._parent._destructed)
						me._parent._serverSort();
				}

			}]);
	}
	else
	if (this._parent && !this._parent._destructed)
		this._parent._serverSort();
};

_me.__date = function(){

	var sDate = '';

	if (this.__aData.EVNSTARTTIME<0){
		if (this.__aData.EVNSTARTDATE<this.__aData.EVNENDDATE-1){
			sDate = this.__aData.start.format('L') + ' - ' + this.__aData.end.format('L');
		}
		else{
			sDate = CalendarFormatting.normalWithWeekDay(this.__aData.start);
		}
	}
	else{
		sDate = CalendarFormatting.normalWithWeekDayAndTime(this.__aData.start);
		if (this.__aData.EVNSTARTDATE<this.__aData.EVNENDDATE){
			sDate += ' - ' + CalendarFormatting.normalWithWeekDayAndTime(this.__aData.end);
		}
		else{
			sDate += ' - ' + this.__aData.end.format('LT');
		}
	}

	return sDate;
};

_me.__badge = function(){

	var t = new IcewarpDate().second(0);

	//starts in...
	if ((this.__aData.start.isToday() && this.__aData.start.isAfter(t, 'time')) || this.__aData.start.isTomorrow()){
		//in 60min
		if (t.unix()+3600 >= this.__aData.start.unix()){

			var elm = this._getAnchor('badge');

			var fce = function(){
				var t = new IcewarpDate();

				var sec = Math.max(this.__aData.start.unix() - t.unix(), 0);
				if (sec){
					elm.textContent = getLang('CONFERENCE::MIN_TO_GO',[Math.ceil(sec/60)]);
					addcss(elm, 'show');
				}
				else{
					clearInterval(this.__badgeInterval);
					removecss(elm, 'show');

					//to in progress state
					this.__badge();
				}

			}.bind(this);

			//set interval
			this.__badgeInterval && clearInterval(this.__badgeInterval);
			this.__badgeInterval = setInterval(fce,	10000);
			fce();
		}
		//more then 60min
		else{
			//set timer to start count
			this.__badgeTimer && clearTimeout(this.__badgeTimer);
			this.__badgeTimer = setTimeout(function(){
				this.__badge();
			}.bind(this),
			(this.__aData.start.unix() - t.unix() + 5) * 1000);
		}
	}
	else
	//running
	if (this.__aData.end.isSameOrAfter(t) && this.__aData.start.isSameOrBefore(t)){
		t = new IcewarpDate(),
		elm = this._getAnchor('badge');
		elm.textContent = getLang('TASK::IN_PROGRESS');
		addcss(elm, 'show');
		addcss(elm, 'in_progress');

		this.__badgeTimer && clearTimeout(this.__badgeTimer);
		this.__badgeTimer = setTimeout(function(){
			this.__badge();
		}.bind(this), (this.__aData.end.unix() - t.unix() + 5) * 1000);
	}
	else{
		removecss(this._getAnchor('badge'), 'show');

		//For Upcoming only
		if (this._parent.__options && this._parent.__options.order == 'asc' && this.__aData.end.isBefore(t, 'time'))
			this._parent._remove(this, 2000);
	}
};

_me.__join = function() {
	var id = this.__aData.iid;
	var date;
	if (Is.Defined(this.__aData.EVNRCR_ID) && Is.Defined(this.__aData.EVNSTARTDATE)) {
		date = this.__aData.EVNSTARTDATE;
		id = id.split('|')[0];
	}
	WMItems.list({
		aid: this.__aData.aid,
		fid: this.__aData.fid,
		iid: id,
		date: date
	},null,null,null,[async function(aResponse) {
		await storage.library('wm_conference');
		wm_conference.get(this.__aData.EVNMEETINGID, aResponse[this.__aData.aid][this.__aData.fid][WMItems.__clientID(this.__aData.EVN_ID)]).join();
	}]);
};