_me = obj_groupchat_message.prototype;
function obj_groupchat_message(){};

_me.__constructor = async function() {
	await storage.library('short_url');
	await storage.library('purify.wrapper', 'purify');

	if (this.__aData.EVNURL)
		await this._init_addon(this.__aData);
};

_me.__update = function(){
	var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid || this.__aData.EVN_ID, values:['EVNNOTE','EVN_CREATED', 'EVN_MODIFIED', 'EVNSHARETYPE','EVNLINKEXTRAS','EVN_METADATA','EVNURL','EVNTHUMBNAILID','EVNTHUMBNAILTIME','EVNPROCESSINGQUEUED', 'EVN_ID']};

	WMItems.list(aItemsInfo,'','','',[async function(aData){

		if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID)])){

			if (this.__aData.tmp) {
				this.__aData.tmp = false;
				this._main.classList.remove('tmp');
			}

			if (aData.EVNMENTIONS_INFO) {
				aData.MENTIONS = parseParamLine(aData.EVNMENTIONS_INFO);
			}

			//Body
			if (this.__aData.EVNNOTE != aData.EVNNOTE) {
				if (aData.EVNCLASS === 'I') {
					aData.EVNNOTE = aData.EVNNOTE || ' ';
				}
				await this._init_body(aData);
			}

			//Link
			if (aData.EVNURL){
				if (this.__aData.EVNURL != aData.EVNURL){
					await this._init_addon(aData);
				}
				else
				if (this.__aData.EVNTHUMBNAILTIME != aData.EVNTHUMBNAILTIME)
				{
					this.__destructor();

					if (aData.EVNPROCESSINGQUEUED == '0'){
						if (this._preview_image){
							if (aData.EVNTHUMBNAILTICKET)
								this._preview_image(aData.EVNTHUMBNAILTICKET, this.__dimensions(aData.EVNSIZEINFO));
							else
							if (aData.EVNTHUMBNAILID){
								var src = await Item.webdavURL([this.__aData.aid, this.__aData.fid, this.__aData.iid], aData.EVNTHUMBNAILID) + '&t=' + (aData.EVNTHUMBNAILTIME || 0);
								this._preview_image(src, this.__dimensions(aData.EVNSIZEINFO));
							}
						}
					}
					else
					if (!gui.socket && (!Is.Defined(aData.EVNPROCESSINGQUEUED) || aData.EVNPROCESSINGQUEUED == '1'))
						this.__timeout = setTimeout(function(){
							this.__update();
						}.bind(this), 5000);
				}
			}
			else{
				this.__destructor();
				this._getAnchor('addon').innerHTML = '';
				removecss(this._main, 'obj_groupchat_link');
			}

			//Reactions
			this._init_toolbar(aData);
		}

	}.bind(this)]);

};

_me._init_addon = async function(aData){
	var height = this._main.clientHeight;

	this.__destructor();
	addcss(this._main, 'obj_groupchat_link');

	if (aData.EVNNOTE == aData.EVNURL)
		addcss(this._main, 'nobody');

	var a = mkElement('A',{href:aData.EVNURL}),
		aTmp = {
			title: aData.EVNTITLE,
			desc: (aData.EVNLOCATION || '').entityify().replace(/\n/g, '<br />'),
			url: a.hostname,
			fullurl: aData.EVNURL
		};

	//Update data
	if (aData.EVN_METADATA){
		this.__aData.EVN_METADATA = aData.EVN_METADATA = parseURL(aData.EVN_METADATA);
		if (aData.EVN_METADATA.core_linkinfo) {
			this.__aData.CORE_LINKINFO = aData.CORE_LINKINFO = parseURL(aData.EVN_METADATA.core_linkinfo);
		}
	}
	this.__aData.EVNURL = aData.EVNURL;
	this.__aData.EVNTHUMBNAILID = aData.EVNTHUMBNAILID || (aData.EVN_METADATA || {}).core_thumbnailimage_id;
	this.__aData.EVNTHUMBNAILTIME = aData.EVNTHUMBNAILTIME;
	this.__aData.EVNPROCESSINGQUEUED = aData.EVNPROCESSINGQUEUED;

	//Preview image
	if (aData.EVNTHUMBNAILID || aData.EVNTHUMBNAILTICKET || aData.THUMBNAILIMAGEID)
		aTmp.preview = true;

	var addon = (this._getAnchor('addon') || {}).firstElementChild;
	addon && addon.parentNode.removeChild(addon);

	//switch between modes
	var linkData = {}, src;
	try {
		linkData = JSON.parse(aData.CORE_LINKINFO.linkData || '{}');
		aData.CORE_LINKINFO.type = linkData.type || aData.CORE_LINKINFO.type;
	} catch {
		//
	}

	this._cangroup = false;
	switch(+(aData.CORE_LINKINFO || {}).type || +linkData.type) {
		case WMChat.const.LINK.VIDEO:
			if (aData.CORE_LINKINFO.videourl && !this.__options.novideo) {
				this._main.classList.add('obj_groupchat_file');
				await this._draw('obj_groupchat_video', 'addon', aTmp, 2);
				await this._draw('obj_groupchat_file-actionbar', 'actionbar', {
				});

				this._getAnchor('video-wrapper').onclick = function(e) {
					this.__previewVideo(true);
					e.stopImmediatePropagation();
				}.bind(this);

				if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
					this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
				}

				//Preview Image
				if (aData.EVNTHUMBNAILTICKET){
					this._preview_image(aData.EVNTHUMBNAILTICKET, aData.EVNSIZEINFO, this.__previewVideo.bind(this, false));
				}
				else
				if (aData.THUMBNAILIMAGEID){
					this._preview_image(aData.THUMBNAILIMAGEID, false, this.__previewVideo.bind(this, false));
				}
				else
				if (aData.EVNTHUMBNAILID){
					src = await Item.webdavURL([aData.aid, aData.fid, WMItems.__serverID(aData.iid)], aData.EVNTHUMBNAILID) + '&t=' + (aData.EVNTHUMBNAILTIME || 0);
					this._preview_image(src, aData.EVNSIZEINFO, this.__previewVideo.bind(this, false));
				}
				else
				if (!gui.socket && (!Is.Defined(aData.EVNPROCESSINGQUEUED) || aData.EVNPROCESSINGQUEUED == '1')){
			
					this.__timeout = setTimeout(function(){
						this.__update();
					}.bind(this), 5000);
			
					this._add_destructor('__destructor');
				} else {
					this.__previewVideo();
				}
			}
			break;
		case WMChat.const.LINK.NOTE:
			this._title(getLang('CHAT::ITM_NOTE'));
			aTmp.body = DOMPurify.sanitize(linkData.body || '');

			addcss(this._main, 'obj_groupchat_note');
			await this._draw('obj_groupchat_note', 'addon', aTmp, 2);

			if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
				this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
			}

			break;
			
		case WMChat.const.LINK.COLLABORATION:
			break;
			
		case WMChat.const.LINK.RECORDING:
			this._title(getLang('CHAT::ITM_RECORDING'));
			var start = new IcewarpDate(linkData.startAt);
			var expiration = obj_list_conference_item.prototype.__expiration(linkData.expireAt);
			
			addcss(this._main, 'obj_groupchat_recording');
			if (expiration) {
				aData.EVNTHUMBNAILTICKET = linkData.preview || aData.EVNTHUMBNAILTICKET;
				aData.EVNPROCESSINGQUEUED = 0;
				aTmp.preview = true;
			} else {
				aTmp.expired = true;
				aData.EVNURL = '';
			}
			aTmp.recorded_on = start.format('LL LT');
			aTmp.expiration = expiration || getLang('CONFERENCE::EXPIRED');
			aTmp.organizer = linkData.organizerName;
			await this._draw('obj_groupchat_recording', 'addon', aTmp, 2);

			if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
				this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
			}

			//Preview Image
			if (aData.EVNTHUMBNAILTICKET){
				this._preview_image(aData.EVNTHUMBNAILTICKET, aData.EVNSIZEINFO);
			}
			else
			if (aData.THUMBNAILIMAGEID){
				this._preview_image(aData.THUMBNAILIMAGEID);
			}
			else
			if (aData.EVNTHUMBNAILID){
				src = await Item.webdavURL([aData.aid, aData.fid, WMItems.__serverID(aData.iid)], aData.EVNTHUMBNAILID) + '&t=' + (aData.EVNTHUMBNAILTIME || 0);
				this._preview_image(src, aData.EVNSIZEINFO);
			}
			else
			if (!gui.socket && (!Is.Defined(aData.EVNPROCESSINGQUEUED) || aData.EVNPROCESSINGQUEUED == '1')){
		
				this.__timeout = setTimeout(function(){
					this.__update();
				}.bind(this), 5000);
		
				this._add_destructor('__destructor');
			}
			break;
		default:
			ShortURL.resolve({
				url: aData.EVNURL,
				callback: async function(oURL, sError) {
					if (this._destructed) {
						return;
					}
					if (oURL) {
						this.__aData.EVNTITLE = oURL.filename;
						this.__renderAsFile();
					} else {
						switch(sError) {
							case 'E_DOCUMENT_INVITE_PASSWORD':
								aTmp.password_protected = true;
								this.__aData.EVNTITLE = getLang('FILE::UNKNOWN_FILENAME');
								this.__renderAsFile();
								if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
									this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
								}
								return;
							case 'E_DOCUMENT_UNAVAILABLE':
								aTmp.smartURLError = getLang('FILE::UNAVAILABLE');
								this.__aData.EVNTITLE = getLang('FILE::UNKNOWN_FILENAME');
								this.__renderAsFile();
								if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
									this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
								}
								return;
						}

						await this._draw('obj_groupchat_link', 'addon', aTmp, 2);

						if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
							this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
						}

						//Controls
						this._getAnchor('addon').querySelector('.body').onclick = async function(e){
							if (aData.EVNURL) {
								var conferenceId;
								if (+(aData.CORE_LINKINFO || {}).type === WMChat.const.LINK.NOTE) {
									linkData.url = aData.EVNURL;
									linkData.title = aData.EVNTITLE;
									linkData.type = 'note';
									linkData.detachable = true;
									await gui._create('note', 'frm_dashboard_window', '', '', linkData);
								} else if (conferenceId = (aData.EVNURL.match(new RegExp(location.hostname + '/conference/(\\d+)')) || [])[1]) {
									await storage.library('wm_conference');
									wm_conference.get(conferenceId).join();
								} else {
									window.open(aData.EVNURL);
								}
							}
							e.stopPropagation();
							e.preventDefault();
						};
					
						//Preview Image
						if (aData.EVNTHUMBNAILTICKET){
							this._preview_image(aData.EVNTHUMBNAILTICKET, aData.EVNSIZEINFO);
						}
						else
						if (aData.THUMBNAILIMAGEID){
							this._preview_image(aData.THUMBNAILIMAGEID);
						}
						else
						if (aData.EVNTHUMBNAILID){
							var src = await Item.webdavURL([aData.aid, aData.fid, WMItems.__serverID(aData.iid)], aData.EVNTHUMBNAILID) + '&t=' + (aData.EVNTHUMBNAILTIME || 0);
							this._preview_image(src, aData.EVNSIZEINFO);
						}
						else
						if (!gui.socket && (!Is.Defined(aData.EVNPROCESSINGQUEUED) || aData.EVNPROCESSINGQUEUED == '1')){
					
							this.__timeout = setTimeout(function(){
								this.__update();
							}.bind(this), 5000);
					
							this._add_destructor('__destructor');
						}
					}
				}.bind(this),
				doNotTrack: true,
				skipPasswordPrompt: true
			});
	}

	//Controls
	this._getAnchor('addon').querySelectorAll('.body').forEach(function(body) {
		body.onclick = async function(e){
			if (aData.EVNURL) {
				if (+(aData.CORE_LINKINFO || {}).type === WMChat.const.LINK.NOTE) {
					linkData.url = aData.EVNURL;
					linkData.title = aData.EVNTITLE;
					linkData.type = 'note';
					linkData.detachable = true;
					await gui._create('note', 'frm_dashboard_window', '', '', linkData);
				} else {
					window.open(aData.EVNURL);
				}
			}
			e.stopPropagation();
			e.preventDefault();
		};
	});
};

_me.__previewVideo = function(bAutoplay) {
	var preview;
	if (this._destructed || !(preview = this._getAnchor('preview'))) {
		return;
	}
	var url = mkElement('A',{href:this.__aData.CORE_LINKINFO.videourl}),
		search = parseURL(url.search);
		search.autoplay = bAutoplay;

	// YOUTUBE https://developers.google.com/youtube/player_parameters
	search.showinfo = 0;
	search.modestbranding = 1;

	var attr = {
		src: url.protocol + '//' + (url.hostname + '/' + url.pathname).replace(/\/\//g, '/') + '?' + buildURL(search) + url.hash,
		frameborder: 0, scrolling: 'no'
	};

	var ratio = 9 / 16 * 100;

	var poster = preview.querySelector('img');
	if (poster) {
		ratio = poster.clientHeight < 100 ? ratio : (poster.clientHeight / poster.clientWidth * 100);
	}

	var elm = mkElement('div', {className:'video-c1'},null, [mkElement('div', {className:'video-c2',style:{paddingTop: ratio +'%'}},null,[mkElement('iframe', attr)])]);

	preview.parentNode.replaceChild(elm, preview);
};

_me.__renderAsFile = async function() {
	if (this._destructed) {
		return;
	}

	this.__aData.EVNCLASS = 'Z';
	this.__aData.EVNLINKEXTRAS = buildURL({ EvnTicket: this.__aData.EVNURL });

	var parent = this._main.parentNode;
	this._destruct();
	var item = await this._parent._create('file', 'obj_groupchat_file', {
		element: parent,
		position: 'beforeEnd'
	}, '', this.__aData, this.__list, this.__options, this.__aTmp);

	this._parent._updateItem && this._parent._updateItem(this, item);

	if (this._parent.__aData[this.__aData.iid]) {
		this._parent.__aData[this.__aData.iid].obj = item;
	}
};

_me.__dimensions = function(sDim){
	var dim;

	if (sDim){
		var tmp = parseURL(sDim);

		if (tmp.tw>0){
			dim = {w:tmp.tw, h:tmp.th};
		}
		else
		if (tmp.ow>0){
			if (tmp.o>4)
				dim = {w:tmp.oh, h:tmp.ow};
			else
				dim = {w:tmp.ow, h:tmp.oh};
		}
	}

	return dim;
};

_me._preview_image = function(src, aSizeInfo, errorCallback){
	var ePreview = this._getAnchor('preview');

	if (!this._destructed && src && ePreview){

		var bVid = this.__aData.CORE_LINKINFO && this.__aData.CORE_LINKINFO['type'] == 2 && this.__aData.CORE_LINKINFO.videourl && !this.__options.novideo,
			w, h;

		if (bVid){
			// w = 500;
			// h = 500;

			if (aSizeInfo){
				var aDim = this.__dimensions(aSizeInfo);
				if (aDim){
					ePreview.firstElementChild.style.width = Math.round(aDim.w/(aDim.w/w)) + 'px';
				}

				var bScroll = false;
				if (this.__list && this.__list.__body){
					var pos1 = getSize(this.__list.__body),
						pos2 = getSize(this._main),
						height = this._main.offsetHeight;
					bScroll = (pos1.y + pos1.h > pos2.y + pos2.h);
				}

				ePreview.firstElementChild.src = src + (~src.indexOf('?') ? '&' : '?') + buildURL({'resize':1, 'width':w, 'height':h});

				if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
					this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
				}
			}
		}
		else{
			ePreview.style.backgroundImage = 'url("'+ encodeURI(src) +'")';
		}

		if (errorCallback) {
			var img = new Image();
			img.onerror = errorCallback;
			img.src = src;
		}
	}

};

_me.__destructor = function(){
	if (this.__timeout){
		window.clearTimeout(this.__timeout);
		delete this.__timeout;
	}
};
