_me = obj_groupchat_mail.prototype;
function obj_groupchat_mail(){};

_me.__constructor = async function() {
	this._title(getLang('CHAT::ITM_NEW_MSG'));
	await this.__fill(this.__aData);
};

_me._download = function() {
	if (this.__aTmp.url) {
		downloadItem(this.__aTmp.url, true);
	}
}

_me.__update = function(){
	var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid, values:['EVNNOTE','EVN_CREATED', 'EVN_MODIFIED', 'EVNSHARETYPE','EVNLINKEXTRAS','EVNURL', 'EVN_ID', 'EVNSIZEINFO', 'EVNMEETINGID','EVNLINKID']};

	WMItems.list(aItemsInfo,'','','',[async function(aData){

		if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[this.__aData.iid]) && aData.EVNLINKEXTRAS){

			if (this.controls)
				await this.controls._destruct();

			//Body
			if (this.__aData.EVNNOTE != aData.EVNNOTE)
				await this._init_body(aData);

			//Reactions
			this._init_toolbar(aData);

			//Merge Data
			for (var k in aData)
				this.__aData[k] = aData[k];

			this.__fill(this.__aData);
		}

	}.bind(this)]);
};

_me.__fill = async function(aData){

	this.btn_edit && await this.btn_edit._destruct();
	this.btn_reply && await this.btn_reply._destruct();
	this.full_switch && await this.full_switch._destruct();
	this.attach && await this.attach._destruct();

	var aTmp = {},
		linkextras = parseURL(aData.EVNLINKEXTRAS);

	if (linkextras.EvnTicket){
		aTmp.size = parseFileSize(linkextras.EvnComplete);
		aTmp.url = linkextras.EvnTicket;
		aTmp.subject = linkextras.EvnTitle.replace(/.eml$/, '');
		aTmp.draft = linkextras.EvnFlags & 128;

		aTmp.from = MailAddress.splitEmailsAndNames(linkextras.EvnOrganizer)[0] || {};
		aTmp.from.name = aTmp.from.name || aTmp.from.email;
		aTmp.from.address = linkextras.EvnOrganizer;
		aTmp.from.avatar = obj_avatar.getAvatarHTML({
			email: aTmp.from.email,
			name: aTmp.from.name,
			size: 40
		});

		aTmp.frame_src = await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID], 'MAIL_PREVIEW.html', { tmod: linkextras.Evn_Modified });

		var oDate = new IcewarpDate(linkextras.EvnStartDate, {format: IcewarpDate.JULIAN});
			oDate.setTime(linkextras.EvnStartTime, true);
		aTmp.date = CalendarFormatting.normalWithTime(oDate);

		aTmp.attach = [];
		if (linkextras.Evn_MetaData && this._parent._type == 'obj_groupchat'){
			var metadata = parseURL(linkextras.Evn_MetaData);
			if (metadata.attachments){
				try{
					var att = JSON.parse(metadata.attachments);
					if (Is.Array(att)){
						aTmp.attach = att.map(function(v){
							v.id = v.part_id;
							return v;
						});
					}
				}
				catch(r){
					 console.log('attachments json', r);
				}
			}
		}
	}
	this.__aTmp = aTmp;

	aTmp.draft = linkextras.EvnFlags & 128;

	await this._draw('obj_groupchat_mail', 'addon', aTmp);

	await this.__renderAddonInfobar();

	//lazy init for comments
	if (this._parent._type == 'obj_groupchat'){

		this.__initFrame(aTmp.frame_src);

		if ((aTmp.attach || []).length)
			this.__initAttach(aTmp.attach);
	}

	this.full_switch._onclick = function(){
		var aLockInfo;
		var bIsHTML;

		if (linkextras){
			aLockInfo = {
				EVNLOCKOWN_EMAIL:linkextras.evnlockown_email,
				EVNLOCKOWN_ID:linkextras.evnlockown_id,
				EVNTITLE: linkextras.EvnTitle,
				draft:linkextras.EvnFlags & 128,
				id:WMItems.__clientID(aData.EVNLINKID),
				guest: sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())
			};
			bIsHTML = !!(linkextras.EvnFlags & 256);
		}

		OldMessage.openwindow([aData.aid, aData.fid, WMItems.__clientID(aData.EVNLINKID+'|@@MAIN@@')], null, aLockInfo, bIsHTML);
	};

};

_me._open = function() {
	var aLockInfo;
	var bIsHTML;

	if (this.__aData.EVNLINKEXTRAS){
		var linkextras = parseURL(this.__aData.EVNLINKEXTRAS);
	}

	if (linkextras){
		aLockInfo = {
			EVNLOCKOWN_EMAIL:linkextras.evnlockown_email,
			EVNLOCKOWN_ID:linkextras.evnlockown_id,
			EVNTITLE: linkextras.EvnTitle,
			draft:linkextras.EvnFlags & 128,
			id:WMItems.__clientID(this.__aData.EVNLINKID),
			guest: sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())
		};
		bIsHTML = !!(linkextras.EvnFlags & 256);
	}

	OldMessage.openwindow([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID+'|@@MAIN@@')], null, aLockInfo, bIsHTML);
}

_me.__initFrame = function(src){

	var frame = mkElement('iframe',{frameborder:"0",marginwidth:"0",marginheight:"0", scrolling:"no", seamless:"seamless"});

	frame.onload = async function(){
		var doc = this.contentWindow.document,
			skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

		function cssLink(filename, skin) {
			return {
				type: "text/css",
				rel: "stylesheet",
				href: getCssPath(filename, skin),
				iwstyle:'iwstyle'
			};
		}

		doc.head.appendChild(mkElement('base', { href: document.baseURI }, doc));
		doc.head.appendChild(mkElement('link', cssLink('font.css'), doc));
		doc.head.appendChild(mkElement('link', cssLink('obj_mailview_body.css', 'default'), doc));
		if (skin !== 'default') {
			doc.head.appendChild(mkElement('link', cssLink('obj_mailview_body.css', skin), doc));
		}

		if (doc.body){
			doc.body.style.padding = '0';

			//translate Image SRC
			var dlsess = dataSet.get('main',['dlsess']);
			[].forEach.call(doc.querySelectorAll('img[icewarp-src]'), function(elm){
				elm.src = sPrimaryAccountClient + 'server/download.php' + (elm.getAttribute('icewarp-src') || '').replace('@@DLSESSION_ID@@', dlsess);
			});
			if (dataSet.get('main', ['night_mode_enabled'])) {
				await storage.library('night_mode');
				var styles = doc.querySelectorAll('link[rel="stylesheet"]');
				var parsed = 0;
				[].forEach.call(styles, function(style) {
					style.onload = style.onerror = function() {
						if(++parsed === styles.length) {
							NightMode(doc.defaultView).activate();
						}
					};
				});
				setTimeout(function() {
					NightMode(doc.defaultView).activate();
				}, 1000);
			}
		}
	};

	this._getAnchor('frame').insertBefore(frame, this._getAnchor('frame').firstChild || null);

	frame.src = src;
};

_me.__initAttach = async function(att){
	if (att){
		if (!this.attach){
			await this._create('attach','obj_attach_mailview','attach','noico');
			this.attach._aid = this.__aData.aid;
			this.attach._fid = this.__aData.fid;
			this.attach._iid = WMItems.__clientID(this.__aData.EVNLINKID + '|@@MAIN@@');
		}

		this.attach._value({'attachments':att});
	}
};

_me._replyMail = function(bReplyToAll){

	var bIsHTML = false;

	if (this.__aData.EVNLINKEXTRAS){
		var linkextras = parseURL(this.__aData.EVNLINKEXTRAS) || {};
		if (linkextras.EvnFlags)
			bIsHTML = !!(linkextras.EvnFlags & 256);
	}

	OldMessage.reply({
		id: [this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID + '|@@MAIN@@')],
		bReplyToAll,
		bIsHTML
	});
};

_me._editMail = function(){

	var id = [this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID)];

	Item.set_lock(id, true, false, [function(bOK){

		var bIsHTML, linkextras;
		if (this.__aData.EVNLINKEXTRAS){
			linkextras = parseURL(this.__aData.EVNLINKEXTRAS) || {};
			if (linkextras.EvnFlags)
				bIsHTML = !!(linkextras.EvnFlags & 256);
		}

		if (bOK){

			var sName = dataSet.get('folders', [this.__aData.aid, this.__aData.fid,'NAME']) || dataSet.get('folders', [this.__aData.aid, this.__aData.fid,'RELATIVE_PATH']) || '';
			var aOpt = {
				sTeamchat: this.__aData.fid + (sName?'::'+sName:''),
				sComment: this.__aData.EVNNOTE,
				__id_chat: id,
				__id:null
			};

			OldMessage.edit([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID + '|@@MAIN@@')], aOpt, bIsHTML);
		}
		else{
			var aLockInfo = {id:WMItems.__clientID(this.__aData.EVNLINKID)};

			if (this.__aData.EVNLINKEXTRAS){
				linkextras = parseURL(this.__aData.EVNLINKEXTRAS) || {};
				aLockInfo.EVNLOCKOWN_EMAIL = linkextras.evnlockown_email;
				aLockInfo.EVNLOCKOWN_ID = linkextras.evnlockown_id;
				aLockInfo.EVNTITLE = linkextras.EvnTitle;
				aLockInfo.draft = linkextras.EvnFlags & 128;
			}

			//LOCK ERROR
			OldMessage.openwindow([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID+'|@@MAIN@@')], null, aLockInfo, bIsHTML);
		}

	}.bind(this)]);

};

_me._forward = function() {
	var bIsHTML;
	if (this.__aData.EVNLINKEXTRAS){
		var linkextras = parseURL(this.__aData.EVNLINKEXTRAS) || {};
		if(linkextras.EvnFlags) {
			bIsHTML = !!(linkextras.EvnFlags & 256);
		}
	}
	OldMessage.forward({
		id: [this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID + '|@@MAIN@@')],
		bIsHTML
	});
}