_me = obj_groupchat_item.prototype;
function obj_groupchat_item(){};

obj_groupchat_item.__comTypes = {I:'obj_groupchat_message', R:'obj_groupchat_file', Q:'obj_groupchat_event', S:'obj_groupchat_conference', F:'obj_groupchat_file', Z:'obj_groupchat_file', E:'obj_groupchat_event', Y:'obj_groupchat_mail', W:'obj_groupchat_invite', GPT: 'obj_chatgpt_item', X: 'obj_groupchat_deleted'};

/*
<evnmentions_info>
	<mention>
		<id>4916541c933f</id>
		<email>a1@merakdemo.com</email>
		<name>A1</name>
	</mention>
	<mention>
		<id>4916541c9340</id>
		<email>user@merakdemo.com</email>
		<name>User</name>
	</mention>
</evnmentions_info>
*/

_me.__constructor = async function(aData, oList, aOpt, aTmp) {
	if (Array.isArray(aData)) {
		if (aData.length > 1) {
			this.__aDatas = aData;
		}
		aData = aData[0];
	}

	if (aData.skeleton) {
		Object.assign(aData, {
			EVNNOTE: this.__generateSkeletonNote(),
			EVN_CREATED: Math.floor(new Date() / 1000),
			EVNMODIFIEDOWNERNAME: 'EVNOWNERNAME',
			EVNMODIFIEDOWNEREMAIL: Math.random() > 0.8 ? sPrimaryAccount : Math.floor(Math.random() * 3),
			EVN_METADATA: 'core_own_email=a&' + (Math.random() > 0.7 ? 'core_reactions_data=%26thumbsup%3D1' : ''),
		});
	}

	var me = this;
	this.__options = this.__options || aOpt || {};
	this.__aTmp = aTmp || {};
	this.__aData = aData;
	// this.__aData = clone(aData, true);
	this.__pendingReaction = null;

	//Search for parent List object (for nested items)
	if (oList)
		this.__list	 = oList;
	else{
		this.__list = this._parent;
		while(!this.__list._serverSort)
			if (!(this.__list = this.__list._parent))
				return;
	}

	var d = (new IcewarpDate(aData.EVN_CREATED*1000)),
		d2 = aData.EVN_MODIFIED ? (IcewarpDate.unix(aData.EVN_MODIFIED)) : false,
		metadata = parseURL(aData.EVN_METADATA),
		owner = (aData.EVNOWNERNAME && aData.EVNOWNERNAME != '0'?aData.EVNOWNERNAME:(aData.EVNMODIFIEDOWNERNAME && aData.EVNMODIFIEDOWNERNAME != '0'?aData.EVNMODIFIEDOWNERNAME:aData.EVNOWNEREMAIL)) || metadata.core_own_name || metadata.modified_own_email || metadata.core_own_email || '',
		name = (aData.EVNMODIFIEDOWNERNAME && aData.EVNMODIFIEDOWNERNAME != '0'?aData.EVNMODIFIEDOWNERNAME:aData.EVNMODIFIEDOWNEREMAIL) || metadata.modified_own_name || metadata.core_modifiedown_name || metadata.modified_own_email || metadata.core_own_email || '',
		filterType = (this.__list.__aRequestData.filter || {}).type;
	aTmp = {
		id: aData.EVN_ID,
		owner: owner,
		name: name,
		time: this.__options.fulldate ? CalendarFormatting.normalWithWeekDayAndTime(d) : d.format('LT'),
		fulltime: d.format('L LT'),
		body: '',
		comment: this.__options.followed_thread_comment,
		goto: filterType && !~['gchat:main', 'gchat:threads', 'gchat:unread_threads'].indexOf(filterType),
		avatar: (metadata.core_own_email || aData.EVNOWNEREMAIL) && {elm: obj_avatar.getAvatarHTML({
			email: metadata.core_own_email || aData.EVNOWNEREMAIL,
			name: name,
			size: 32
		}), link: MailAddress.createEmail(name, metadata.core_own_email || aData.EVNOWNEREMAIL).urlEncode()},
		edited_text: d2 ? getLang('CHAT::EDITED_BY', [name.escapeHTML(), d2.format('L LT')]) : false,
		followed_thread: this.__options.followed_thread_post || this.__options.followed_thread_comment,
		room: this.__options.room,
		last_change: this.__options.last_change,
		show_all: (this.__aDatas || {}).length > 6,
		is_image: aData.is_image
	};

	if (aData.EVNNOTE && !~['Q', 'X'].indexOf(aData.EVNCLASS)){
		if (!aData.MENTIONS && aData.EVNMENTIONS_INFO)
			aData.MENTIONS = parseParamLine(aData.EVNMENTIONS_INFO);

		if (aData.skeleton) {
			aTmp.body = aData.EVNNOTE;
		} else {
			aTmp.body = this.__encode_body(aData.EVNNOTE, aData.MENTIONS);
		}
	}

	if (!(aTmp.body || '').trim().length) {
		addcss(this._main, 'empty_note');
	}

	if (aData.EVNMODIFIEDOWNEREMAIL == sPrimaryAccount || aData.EVNMODIFIEDOWNEREMAIL == dataSet.get('main', ['user']) || metadata.core_own_email == sPrimaryAccount || metadata.core_own_email == dataSet.get('main', ['user'])) {
		aTmp.me = true;
		addcss(this._main,'me');
	}

	//Group support?
	if (!(this._cangroup = (!aData.EVN_MODIFIED || aData.EVN_CREATED == aData.EVN_MODIFIED)))
		addcss(this._main,'edited');

	if (parseInt(aData.UNREADCOUNT)) {
		addcss(this._main, 'unread');
	}

	var linkextras;
	if (aData.EVNLINKEXTRAS){
		linkextras = parseURL(aData.EVNLINKEXTRAS);

		if (linkextras.Evn_MetaData && !aData.EVN_METADATA)
		 	aData.EVN_METADATA = linkextras.Evn_MetaData;

		if (this.__aData.EVNLINKTYPE == '10' && Is.Defined(linkextras.ReaValue))
			aData.REAVALUE = linkextras.ReaValue;

		//Conference
		if (aData.EVNCLASS == 'S' && linkextras.organizer){
			aTmp.me = linkextras.organizer == sPrimaryAccount || linkextras.organizer == dataSet.get('main', ['user']);
			aTmp.avatar = {elm: obj_avatar.getAvatarHTML({
				email: linkextras.organizer,
				name: linkextras.organizer_name || linkextras.organizer
			}), link:MailAddress.createEmail(linkextras.organizer_name, linkextras.organizer).urlEncode()};
			aTmp.name = linkextras.organizer_name || linkextras.organizer;

			aData.AccountName = linkextras.organizer_name || linkextras.organizer;
			aData.AccountEmail = linkextras.organizer;
		}
		else
		if (linkextras.AccountEmail){
			aData.AccountName = linkextras.AccountName || linkextras.AccountEmail;
			aData.AccountEmail = linkextras.AccountEmail;
		}
	}
	this.__linkextras = linkextras || {};

	//User edited document from Admin
	if (aData.EVNCLASS == 'R' && aData.EVNLINKTYPE == '1')
		aTmp.modify_text = getLang('CHAT::MODIFIED_BY',['<strong>'+ (linkextras.EvnOwnerName || linkextras.EvnOwnerEmail || '').escapeHTML() +'</strong>']);

	//Reactions
	if (!aData.META_REACTIONS && aData.EVN_METADATA){
		var meta = parseURL(aData.EVN_METADATA);

		if (meta.core_reactions_data)
			aData.META_REACTIONS = parseURL(meta.core_reactions_data);
	}

	switch(this._type){
		//SYSTEM MESSAGES
		case 'obj_groupchat_invite':
		case 'obj_groupchat_deleted':
		case 'obj_groupchat_info':
		case 'obj_groupchat_pin':
		case 'obj_groupchat_thread':
			addcss(this._main, 'system');
			await this._draw('obj_groupchat_system', 'main', aTmp);
			break;

		//USER MESSAGES
		default:
			if (aData.EVNCLASS === 'I')
				aTmp.body = aTmp.body || ' ';

			await this._draw('obj_groupchat_item', 'main', aTmp);
			[].forEach.call(this._getAnchor('body').querySelectorAll('img'), function(image) {
				var height = me._main.clientHeight;
				image.addEventListener('load', function() {
					if (me._parent._scrollBy) {
						me._parent._scrollBy(me._main.clientHeight - height);
					}
				});
			});

			if (!this.__aDatas) {
				this._init_toolbar(aData, true);
			}
	}

	//Control bar
	var eMessage = this._getAnchor('message'),
		aAccess = WMFolders.getAccess([aData.aid, aData.fid]);

	eMessage.addEventListener('click', async function(e) {
		var elm = e.target;
		if (hascss(elm, 'private_msg')) {
			e.preventDefault();
			var sMail = elm.getAttribute('rel');
			if (sMail){
				var addr = MailAddress.splitEmailsAndNames(sMail.urlDecode());
				if (addr && addr[0]){
					var pos = getSize(elm),
						cmenu = await me._gui._create('cmenu', 'obj_context_link','','',addr[0].name, addr[0].email);
						cmenu._place(pos.x+pos.w,pos.y+(pos.h/2));
					e.stopPropagation();
				}
			}
		}
	});

	if (this._type == 'obj_groupchat_pin'){
		eMessage.onclick = function(e){
			e.stopPropagation();
			e.preventDefault();

			if (aData && this.__list._ongoto)
				this.__list._ongoto.call(this.__list, {aid:aData.aid, fid:aData.fid, iid:WMItems.__clientID(linkextras.evn_id)});
		}.bind(this);
	}
	else
	if (this._type == 'obj_groupchat_thread'){
		eMessage.onclick = function(e){
			e.stopPropagation();
			e.preventDefault();

			if (aData && this.__list._onreply)
				this.__list._onreply.call(this.__list, {aid:aData.aid, fid:aData.fid, iid:WMItems.__clientID(linkextras.evn_id)});
		}.bind(this);
	}
	else{
		eMessage.onclick = function(e){

			var elm = e.target;

			if (hascss(me._main, 'edit') || elm.tagName == 'FORM' || Is.Child(elm,'FORM', this) || (elm.tagName == 'SPAN' && (hascss(elm,'mention') || hascss(elm,'private_msg'))))
				return;

			if (this.__timein){
				clearTimeout(this.__timein);
				delete this.__timein;
			}

			if (this.__timeout){
				clearTimeout(this.__timeout);
				delete this.__timeout;
			}

			if (aAccess.write && me._init_controls(true))
				addcss(me._main.parentElement, 'active');
		};
	}

	eMessage.onmouseover = function(){

		if (this.__timeout){
			clearTimeout(this.__timeout);
			delete this.__timeout;
		}

		if (hascss(me._main, 'edit'))
			return;

		if (!this.__timein)
			this.__timein = setTimeout(function(){

				if (me && !me._destructed){
					if (aAccess.write && me._init_controls(true))
						addcss(me._main.parentElement, 'active');
				}

			}, 50);
	};

	eMessage.onmouseout = function(e){
		if (!Is.Child(e.relatedTarget, this)){

			if (this.__timein){
				clearTimeout(this.__timein);
				delete this.__timein;
			}

			if (hascss(me._main, 'edit'))
				return;

			if (!this.__timeout)
				this.__timeout = setTimeout(function(){
					if (me && !me._destructed){
						if (me._init_controls(false))
							removecss(me._main.parentElement, 'active');
					}
				}.bind(this), 25);
		}
	};

	var last = {};
	for (var i in this.__aData) {
		if (i.indexOf('LAST') === 0) {
			last[i.replace(/^LAST/, '')] = this.__aData[i];
			last.aid = last.aid || this.__aData.aid;
			last.fid = last.fid || this.__aData.fid;
		}
	}
	this.__aData.COMMENT = this.__aData.COMMENT || last;

	if (this.__aData.COMMENT.EVNCLASS) {
		await this._setLastComment(this.__aData.COMMENT);
	}

	//Item base code is fully done (apply animations since now)
	this.__initialised = true;

	this._add_destructor('__destructor_item');
	
	[].forEach.call(this._main.querySelectorAll('.hljs'), function(hljs) {
		hljs.addEventListener('contextmenu', async function(e) {
			await gui._create("cmenu", "obj_context", '', '', me);
			var aMenu = [{
				title: 'CHATGPT::COPY_TO_CLIPBOARD',
				arg: [function() {
					var text = obj_groupchat_item.prototype.__encode_body(this.__aData.message);
					text = createTextVersion(text, {
						linkProcess: function(href, linkText) {
							return linkText || href;
						},
						imgProcess: function() {
							return '';
						}
					});
					toClipboard({
						'text/plain': text,
					}, 'codeblock');
				}.bind(this)]
			}];

			await gui.cmenu._fill(aMenu);
			gui.cmenu._place(e.clientX, e.clientY);
			e.preventDefault();
			e.stopImmediatePropagation();
		});
	});
};

_me._setLastComment = async function(aData) {
	this.last_comment && await this.last_comment._destruct();
	var obj = obj_groupchat_item.__comTypes[aData.EVNCLASS];
	var oOptions = {
		fulldate: true,
		followed_thread_comment: true,
		disable_controls: true
	};
	if (aData.EVNLINKID && aData.EVNLINKID === this.__aData.EVNLINKID) {
		obj = 'obj_groupchat_info';
		oOptions.fulldate = false;
		var extras = parseURL(aData.EVNLINKEXTRAS);
		aData.EVNOWNEREMAIL = extras.EvnModifiedOwnerEmail || extras.EvnOwnerEmail;
		aData.EVNOWNERNAME = extras.EvnModifiedOwnerName || extras.EvnOwnerName;
		var sUser = (aData.EVNOWNERNAME || aData.EVNOWNEREMAIL).escapeHTML();
		oOptions.body = getLang('CHAT::DOCUMENT_EDITED', ['<strong>' + sUser + '</strong>', '<b>' + extras.EvnTitle.escapeHTML() + '</b>']);
	}
	await this._create('last_comment', obj, {
		position: 'afterend',
		element: this._getAnchor('addon')
	}, 'comment', aData, '', oOptions);
};

_me.__generateSkeletonNote = function() {
	var note = '';
	for(var i = 0; i <= Math.floor(Math.random() * 5); i++) {
		note += '<div class="skeleton" style="width: ' + (80 + Math.floor(Math.random() * 20)) + '%">&nbsp;</div>';
	}
	return note;
};

_me._title = function(str){
	this._main.querySelector('h3>span.modify').innerText = str;
};

_me._ungroup = function(bForce){

	if (this._cangroup){
		this._cangroup = false;

		var eSec = Is.Child(this._main, 'SECTION', this.__list._main);
		if (eSec)
			if (!bForce && this.__aData.EVNCOMEVNID){
				if (hascss(eSec, 'group'))
					addcss(eSec, 'nogroup');
			}
			else{
				if (this.__aData.EVNCOMEVNID && this.item && this.item.__updateMe){
					this.item.__update();
					//async __update handler for ungroup would be nice here...
				}
				removecss(eSec, 'group');
			}
	}
};

_me._edit = async function(b){
	if (this._destructed) {
		return false;
	}
	if (b instanceof KeyboardEvent && b.key === 'Escape') {
		b = false;
	}
	//make <section> active
	var sel = Is.Child(this._main, 'SECTION', this.__list._main);

	if (!b && this.text){
		this.text._destruct();

		if (this.preview)
			this.preview._destruct();

		removecss(this._main, 'edit');
		removecss(sel, 'edit');

		this.__list._mask(false);
		this.__list.__options.autoscroll = true;
		this._gui._disobeyEvent('keydown', [this, '_edit']);
	}
	else
	if (b && !this.text){

		this.__list._mask(true);

		//jump fix 1
		if (this.__aData.EVNCLASS == 'I' && this._getAnchor('addon') && this._getAnchor('addon').offsetHeight)
			this._getAnchor('addon').style.height = this._getAnchor('addon').offsetHeight + 'px';

		//Scroll fix part 1
		var eBody = this._getAnchor('body'),
			initHeight = Math.min(eBody.offsetHeight, 450);

		eBody.style.height = initHeight + 'px';

		addcss(this._main, 'edit');
		addcss(sel, 'edit');
		this._init_controls(false);

		await this._create('text', 'obj_chat_input','body','small',{
			smiles_enabled: this.__list.__options.smiles_enabled,
			gifs_enabled: false,
			chatgpt_enabled: false,
			formatting_enabled: this.__list.__options.formatting_enabled,
			parseurl:this.__aData.EVNCLASS == 'I',
			loading: false,
			upload: false,
			alias: this.__aData.aid + '_' + this.__aData.fid + '_' + this.__aData.iid
		});
		this.text.input.__maxHeight = 450;
		this.text.__lastURL = this.__aData.EVNURL;
		this.text._folder({aid:this.__aData.aid,fid:this.__aData.fid, iid: this.__aData.iid});

		/* Preview part */
		if (this.__aData.EVNCLASS == 'I'){

			var aOut = {};

			if (this.__aData.EVNURL){

				var bVid = this.__aData.CORE_LINKINFO && this.__aData.CORE_LINKINFO.type == WMChat.const.LINK.VIDEO && this.__aData.CORE_LINKINFO.videourl,
					w = bVid?500:300,
					h = bVid?281:600;

				aOut = {
					DESC:[{VALUE:this.__aData.EVNLOCATION}],
					TITLE:[{VALUE:this.__aData.EVNTITLE}],
					URL:[{VALUE:this.__aData.EVNURL}],
					IMAGES:[{IMAGE:[{
						URL:[{VALUE: this.__aData.EVNTHUMBNAILTICKET || await Item.webdavURL([this.__aData.aid, this.__aData.fid, this.__aData.iid], this.__aData.EVNTHUMBNAILID, {resize: 1, width: w, height: h, t: this.__aData.EVNTHUMBNAILTIME || 0 })}]
					}]}]
				};

				this.text.preview = await this._create('preview', 'obj_urlpreview','addon','', aOut);
				this.text.preview._onclose = function(){
					this.text._focus();
				}.bind(this);

				//jump fix 2
				this._getAnchor('addon').style.height = '';
			}

			this.text.__urlpreview = async function(aOut){
				this.text.preview = await this._create('preview', 'obj_urlpreview','addon','', aOut, 2);

				//jump fix 2
				this._getAnchor('addon').style.height = '';
			}.bind(this);
		}

		//Submit
		this.text._onsubmit = function(v, aArgs, aPrivate) {
			this.text.input._disabled(true);

			if (this.__save(v, aArgs, aPrivate) === false)
				this.text.input._disabled(false);
		}.bind(this);

		//Cancel
		this.text.input._onclose = function(){
			if (!this.text.input.suggest)
				this._edit(false);
		}.bind(this);
		this._gui._obeyEvent('keydown', [this, '_edit']);

		//Private (I)
		if (this.__aData.EVNLINKEXTRAS && this.__aData.EVNCLASS == 'I'){
			var ext = parseURL(this.__aData.EVNLINKEXTRAS);
			if (ext.AccountEmail)
				this.text._private(ext.AccountName, ext.AccountEmail);
		}

		if (Is.String(this.__aData.EVNNOTE)){
			this.text._value(this.__aData.EVNNOTE);
			this.text.input._setRange(this.__aData.EVNNOTE.length);
		}
		else
			this.text._focus();

		//Scroll fix part 2
		// this._main.scrollIntoView({behavior: "smooth", block: "center"});

		eBody.style.height = '';
		eBody = null;

		this._getAnchor('esc_msg').onclick = function(e){
			e.stopPropagation();

			this._edit(false);

		}.bind(this);

		this.__list.__options.autoscroll = false;
	}

};

_me.__save = function(v, aArgs, aPrivate){

	aPrivate = aPrivate || {};

	var url1 = this.__aData.EVNURL || '',
		url2 = aArgs && aArgs.url?aArgs.url:'';

	if (this.__aData.AccountEmail == aPrivate.email && this.__aData.EVNNOTE == v && url1 == url2)
		this._edit(false);
	else{

		var aItemInfo = {
				values: {
					EVNNOTE: v.replace(/^\//, '\\/')
				}
			};

		switch (this.__aData.EVNCLASS){
			case 'I':
				aItemInfo.values.EVNLINKID = aPrivate.email?aPrivate.email:'';

				if (this.__aData.EVNURL)
					this.__aData.EVNURL = aItemInfo.values.EVNURL = '';

				//Extesions
				if (aArgs){
					//Add link
					if (aArgs.url)
						aItemInfo.values.EVNURL = aArgs.url;

					//Message with link
					if (aArgs.title)
						aItemInfo.values.EVNTITLE = aArgs.title;
					if (aArgs.desc)
						aItemInfo.values.EVNLOCATION = aArgs.desc;
					if (aArgs.thumbnailimageid)
						aItemInfo.values.THUMBNAILIMAGEID = aArgs.thumbnailimageid;

					var info = {};
					if (aArgs.type)	info.type = aArgs.type;
					if (aArgs.videourl) info.videourl = aArgs.videourl;
					if (aArgs.videotype) info.videotype = aArgs.videotype;
					if (!Is.Empty(info))
						aItemInfo.values.LINKINFO = buildURL(info);
				}

				break;
		}

		WMItems.add([this.__aData.aid, this.__aData.fid, this.__aData.iid || this.__aData.EVN_ID], aItemInfo,'','','', [function(bOK){

			if (bOK === true){

				//Edit css
				addcss(this._main, 'edited');

				//finish editing
				this._edit(false);

				this._ungroup();

				//Fire Update event
				this.__list._fire(this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID), 'update');

			}
			else
				this._edit(false);

		}.bind(this)]);
	}
};

_me._pin = function(sVal){
	var sAction = sVal == 'public'?'add_global_pin':'add_pin';

	if (this.__aData.GPINWHEN && sVal == 'public')
		sAction = 'delete_global_pin';
	else
	if (this.__aData.PINWHEN && sVal == 'private')
		sAction = 'delete_pin';

	WMItems.action({aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid}, sAction, [function(bOK, aData){

		if (bOK && this.__list){
			var arg = {};

			if (sAction == 'add_global_pin' && aData.IQ && aData.IQ[0].RESULT && aData.IQ[0].RESULT[0].LAST_PINNED_ITEM)
				arg.LAST_PINNED_ITEM = aData.IQ[0].RESULT[0].LAST_PINNED_ITEM[0].VALUE;

			//call pin event
			if (!this.__list._fire(this.__aData.iid, sAction, arg) && this.__update)
				this.__update(true);
		}

	}.bind(this)]);
};

_me._reaction = function(sVal, iid){

	var data = this.__aData;

	if (iid && this.__aDatas) {
		for (var i in this.__aDatas) {
			if (this.__aDatas[i].iid === iid) {
				data = this.__aDatas[i];
			}
		}
	}

	if (data.REAVALUE != sVal && this.__pendingReaction !== sVal){

		this.__pendingReaction = sVal; //Safari async issue

		var aItemInfo = {
			reactions:{REACTION:{values:{REACTION:sVal || ''}}}
		};

		WMItems.add([data.aid, data.fid, data.iid], aItemInfo,'','','', [function(sVal, sRea, bOK, aData){

			if (this.react){
				this.react._destruct();
				delete this.react;
			}

			if (bOK){
				var sType = 'reaction',
					sBody = sVal;

				if (!sVal){
					sType = 'reaction-deleted';
					sBody = sRea;
				}

				if (this.__list){
					var aFireData = {BODY:sBody, REAVALUE:sVal};

					//fill-in EVNCLASS for link items (pins)
					if (!this.__list.__aData[data.iid] && data.EVNCLASS)
						aFireData['ITEM-TYPE'] = data.EVNCLASS;

					if (!this.__list._fire(data.iid, sType, aFireData) && this._init_toolbar){

						var meta_reactions = '';
						if (aData.xml && (aData = aData.xml.IQ) && (aData = aData[0].RESULT) && aData[0].META_REACTIONS)
							meta_reactions = aData[0].META_REACTIONS[0].VALUE;

						this._init_toolbar({META_REACTIONS:meta_reactions?parseURL(meta_reactions):'', REAVALUE:sVal});
					}
				}

				this.__pendingReaction = null;
			}
			else
			if (this.__list && !this.__list._fire(iid, 'update') && this.__update){
				this.__pendingReaction = null;
				this.__update(true);
			}

		}.bind(this, sVal, data.REAVALUE)]);
	}
};

_me._data = function(id, aData, sCall, aArgs){
	var obj = this;
	if (Is.Defined(id) && (this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID)) != id){
		if (this.item && !this.item._destructed && this.item.__aData){
			if (this.item.__aData.iid == id || (parseInt(this.__aData.EVNLINKTYPE, 10) == 10 && this.item.__aData.EVNLINKID == id)){
				obj = this.item;

				if (hascss(this._main.parentElement, 'group')){
					obj.__updateMe = true;
					return;
				}
			}
		}
		else
		if (!this.__aData.EVNLINKID || parseInt(this.__aData.EVNLINKTYPE, 10) == 10 || WMItems.__clientID(this.__aData.EVNLINKID) != id)
			return;
	}

	if (Is.Object(aData))
		for(var k in aData)
			obj.__aData[k] = aData[k];

	if (sCall && Is.Function(obj[sCall]))
		obj[sCall].apply(obj, aArgs || []);
};

_me._init_toolbar = function(aData, bNoScroll){
	if (this.__aDatas) {
		this._init_toolbar_multi && this._init_toolbar_multi(aData);
	}

	var eTool = this._getAnchor('toolbar');
	if (~['obj_groupchat_pin', 'obj_groupchat_thread'].indexOf(this._type) || this.__aData.attachment || this._destructed || !eTool) {
		return eTool && eTool.parentNode.removeChild(eTool);
	}

	aData = aData || this.__aData;
	if (Array.isArray(aData)) {
		aData = aData[0];
	}
	var show = !this.__aData.EVNCOMEVNID, 							// on main thread always TRUE
		elm, id,
		r = {};

	//// REACTIONS ////

	//From detail
	if (aData.REACTIONS){

		this.__aData.REACTIONS = aData.REACTIONS;
		var sRea = '';
		for (id in aData.REACTIONS)
			if (aData.REACTIONS[id].values && aData.REACTIONS[id].values.REAVALUE){
				r[aData.REACTIONS[id].values.REAVALUE] = (r[aData.REACTIONS[id].values.REAVALUE] || 0) + 1;

				if (aData.REACTIONS[id].values.REAOWNEMAIL == sPrimaryAccount || aData.REACTIONS[id].values.REAOWNEMAIL == dataSet.get('main', ['user']))
					sRea = aData.REACTIONS[id].values.REAVALUE;
			}

		this.__aData.REAVALUE = sRea;
	}
	else
	//From list
	if (aData.META_REACTIONS && !Is.Empty(aData.META_REACTIONS)){

		r = this.__aData.META_REACTIONS = aData.META_REACTIONS;
		delete this.__aData.REACTIONS;

		if (Is.Defined(aData.REAVALUE))
			this.__aData.REAVALUE = aData.REAVALUE;
	}
	else
	//From notification
	if (aData.NOTIFY_REACTIONS){

		if (this.__aData.REACTIONS){
			for (id in this.__aData.REACTIONS)
				if (this.__aData.REACTIONS[id].values && this.__aData.REACTIONS[id].values.REAVALUE){
					r[this.__aData.REACTIONS[id].values.REAVALUE] = (r[this.__aData.REACTIONS[id].values.REAVALUE] || 0) + 1;
				}

			delete this.__aData.REACTIONS;
		}
		else
		if (this.__aData.META_REACTIONS){
			r = this.__aData.META_REACTIONS;
		}

		if (aData.ACTION == 'reaction'){
			r[aData.NOTIFY_REACTIONS] = parseInt(r[aData.NOTIFY_REACTIONS] || 0) + 1;

			if (Is.Defined(aData.REAVALUE) && this.__aData.REAVALUE != aData.REAVALUE){

				if (this.__aData.REAVALUE){
					if (r[this.__aData.REAVALUE]>'1')
						r[this.__aData.REAVALUE] = parseInt(r[this.__aData.REAVALUE]) - 1;
					else
						delete r[this.__aData.REAVALUE];
				}

				this.__aData.REAVALUE = aData.REAVALUE;
			}
		}
		else{
			if (r[aData.NOTIFY_REACTIONS]>'1')
				r[aData.NOTIFY_REACTIONS] = parseInt(r[aData.NOTIFY_REACTIONS]) - 1;
			else{
				delete r[aData.NOTIFY_REACTIONS];
			}

			if (Is.Defined(aData.REAVALUE))
				this.__aData.REAVALUE = aData.REAVALUE;
		}

		this.__aData.META_REACTIONS = r;
	}
	else{
		delete this.__aData.REACTIONS;
		// this.__aData.REAVALUE = '';
	}

	//close reaction bubble
	if (this.react && !this.react._destructed){
		this.react._destruct();
	}

	elm = this._getAnchor('reactions');
	if (elm) {
		elm.innerHTML = '';
		if (!Is.Empty(r)){
			var count = 0;
			for (var i in r)
				if (Object.prototype.hasOwnProperty.call(r, i)){
					elm.appendChild(mkElement('span', {className:'react r_' + i, rel:i}));
					count += +(r[i] || 1);
				}

			if (count){
				elm.appendChild(mkElement('span', {className:'count', text: count}));
				show = true;
			}
		}

		//My reaction
		elm = eTool.querySelector('.button-reaction');
		if (elm){
			if (this.__aData.REAVALUE)
				elm.setAttribute('iw-reaction', this.__aData.REAVALUE);
			else
				elm.removeAttribute('iw-reaction');
		}
	}

	//Pins
	if (Is.Defined(aData.GPINWHEN))
		this.__aData.GPINWHEN = aData.GPINWHEN;

	elm = eTool.querySelector('.button-public');
	if (this.__aData.GPINWHEN){
		show = true;
		addcss(elm,'show');

		if (aData.GPINOWNEMAIL && (aData.GPINOWNEMAIL == sPrimaryAccount || aData.GPINOWNEMAIL == dataSet.get('main', ['user'])))
			addcss(elm,'delete');
		else
			removecss(elm,'delete');
	}
	else
		removecss(elm,'show');

	if (Is.Defined(aData.PINWHEN))
		this.__aData.PINWHEN = aData.PINWHEN;

	elm = eTool.querySelector('.button-private');
	if (this.__aData.PINWHEN){
		show = true;
		addcss(elm,'show');
	}
	else
		removecss(elm,'show');

	elm = eTool.querySelector('.button-goto');
	if (elm){
		elm.onclick = function(e){
			e.preventDefault();
			e.stopPropagation();

			var aData = null;

			if (this.__aData.EVNLINKTYPE == '10'){
				if (this.item)
					aData = clone(this.item.__aData, true);
			}
			else
				aData = this.__aData;

			if (aData && this.__list._ongoto)
				this.__list._ongoto.call(this.__list, aData);
		}.bind(this);
	}

	//Comments
	if (!this.__aData.EVNCOMEVNID){
		var cnt = 0;

		if (Is.Defined(aData.META_COMMENTS))
			this.__aData.META_COMMENTS = aData.META_COMMENTS;
		else
		if (Is.Defined(this.__aData.COMCOUNT))
			this.__aData.META_COMMENTS = {count: this.__aData.COMCOUNT };
		else
		if (!this.__aData.META_REACTIONS && Is.Defined(aData.EVN_METADATA)){
			var meta = parseURL(aData.EVN_METADATA);

			if (meta.core_reactions_data)
				this.__aData.META_REACTIONS = parseURL(meta.core_reactions_data);
		}

		if (this.__aData.META_COMMENTS && this.__aData.META_COMMENTS.count)
			cnt = parseInt(this.__aData.META_COMMENTS.count) || 0;

		elm = eTool.querySelector('.button-reply');
		if (elm){
			if (cnt>0){
				show = true;
				elm.innerHTML = '<span class="reply-count">' + cnt + '</span><label>' + getLang('CHAT::COMMENTS::'+cnt, [cnt]) + '</label>';
				addcss(elm, 'replies');
			} else {
				elm.innerHTML = '<label>' + getLang('CHAT::ADD_COMMENT') + '</label>';
				removecss(elm, 'replies');
			}
		}
	}

	if (bNoScroll)
		removecss(this._main, 'anim');
	else
		addcss(this._main, 'anim');

	if ((((this.__list || {}).__aRequestData || {}).filter || {}).type === 'gchat:mentions') {
		show = true;
	}

	if (!show){
		removecss(this._main, 'reactions');
	}
	else{
		if (!this.__reactions){
			this.__reactions = true;

			//click on reaction
			// if (WMFolders.getAccess({aid:this.__aData.aid, fid:this.__aData.fid}, 'write'))
				eTool.onclick = async function(e){
					var eT = e.target;
					if (eT.tagName == 'SPAN'){

						if (hascss(eT,'react')){
							if (this.__reactTimeOut){
								window.clearTimeout(this.__reactTimeOut);
								delete this.__reactTimeOut;
							}

							if (this.__reactTimeIn){
								window.clearTimeout(this.__reactTimeIn);
								delete this.__reactTimeIn;
							}

							if (this.react){
								this.react._destruct();
								delete this.react;
							}

							await this._gui._create('reactions', 'frm_reactions','','', this.__aData);
						}
						else
						if (hascss(eT,'button-reaction')){
							if (!this.smiles || this.smiles._destructed){
								if (this.__aData.REAVALUE) {
									this._reaction('');
									this.__aData.REAVALUE = '';
								} else {
									this.smiles = await this._gui._create('smiles', 'obj_minismile', '','arrow',[function(sReaction){
										this._reaction(this.__aData.REAVALUE == sReaction?'':sReaction);
									}.bind(this)]);

									this.smiles._active(this.__aData.REAVALUE);

									this.smiles._onclose = function(){
										this._destruct();
									};

									this.smiles._placeElement(eT, {mode:'top'});
									this.smiles._modal(true);
									this.smiles._show();
								}
							}
						}
						else
						if (hascss(eT,'button-reply') && this.__list.__options.comments){
							this._comment();
						}
						else
						if (hascss(eT,'button-public') && hascss(eT,'delete')){
							this._pin('public');
						}
						else
						if (hascss(eT,'button-private') && hascss(eT,'delete')){
							this._pin('private');
						}
						else
							return;

						e.stopPropagation();
						e.preventDefault();
					}
				}.bind(this);


			eTool.onmouseover = function(e){
				var eT = e.target;
				if (eT.tagName == 'SPAN' && hascss(eT, 'react')){
					if (this.__reactTimeOut){
						window.clearTimeout(this.__reactTimeOut);
						delete this.__reactTimeOut;
					}

					if (this.__reactTimeIn){
						window.clearTimeout(this.__reactTimeIn);
						delete this.__reactTimeIn;
					}

					this.__reactTimeIn = setTimeout(
						function(){
							this._show_react(eT);
						}.bind(this), 500);
				}
			}.bind(this);

			eTool.onmouseout = function(){

				if (this.__reactTimeOut){
					window.clearTimeout(this.__reactTimeOut);
					delete this.__reactTimeOut;
				}

				if (this.__reactTimeIn){
					window.clearTimeout(this.__reactTimeIn);
					delete this.__reactTimeIn;
				}

				if (this.react)
					this.__reactTimeOut = setTimeout(
						function(){
							if (this.react){
								this.react._destruct();
								delete this.react;
							}
						}.bind(this), 300);

			}.bind(this);

		}

		//Animation vs Scroll handling
		if (this.__initialised && !hascss(this._main, 'reactions')){

			// shift last item up to see reactions
			if (!bNoScroll && !this._main.parentNode.nextSibling) {
				if (browserEvent('transitionend')) {

					this.__scrollInterval && clearInterval(this.__scrollInterval);

					this.__scrollInterval = setInterval(function() {
						if (this.__list && !this.__list._destructed && this.__list._scrollBy)
							this.__list._scrollBy(this._main.offsetHeight);
						else
							clearInterval(this.__scrollInterval);
					}.bind(this), 5);

					var transition_callback = function() {
						clearInterval(this.__scrollInterval);
						this._getAnchor('toolbar').removeEventListener(browserEvent('transitionend'), transition_callback);
					}.bind(this);

					this._getAnchor('toolbar').addEventListener(browserEvent('transitionend'), transition_callback);
				} else {
					setTimeout(function() {
						if (this.__list && !this.__list._destructed && this.__list._scrollBy)
							this.__list._scrollBy(this._main.offsetHeight);
					}.bind(this), 250); // 200ms animation
				}
			}
		}

		addcss(this._main, 'reactions');
	}
};

_me._init_toolbar_multi = function() {
	if (this.__aDatas.length > 6) {
		var show_all = this._getAnchor('show_all');
		show_all.textContent = getLang('CHAT::SHOW_ALL_IMAGES', [this.__aDatas.length]);
		show_all.onclick = function() {
			this._main.classList.remove('collapsed');
		}.bind(this);
	}

	//Comments
	this.__aDatas.forEach(function(aData) {
		var image = this._main.querySelector('.image[rel="' + WMItems.__clientID(aData.EVN_ID));
		if (!image) {
			return;
		}
		var elm = image.querySelector('.replies');
		if (!elm) {
			return;
		}

		elm.onclick = function(e) {
			e.stopPropagation();
			gui.frm_main._openTeamchatThread({
				aid: aData.aid,
				fid: aData.fid,
				iid: aData.iid || WMItems.__clientID(aData.EVN_ID)
			});
		}.bind(this);

		var comcount = parseInt(aData.COMCOUNT ? aData.COMCOUNT : (aData.META_COMMENTS || parseURL(parseURL(aData.EVN_METADATA).core_commentsinfo) || {}).count || 0);

		if (comcount) {
			image.classList.add('has-replies');
			elm.textContent = comcount;
		} else {
			elm.textContent = '';
			image.classList.remove('has-replies');
		}
	}, this);

	//// REACTIONS ////
	this.__aDatas.forEach(function(aData) {
		var image = this._main.querySelector('.image[rel="' + WMItems.__clientID(aData.EVN_ID));
		if (!image) {
			return;
		}
		var elm = image.querySelector('.reactions'), id;
		if (!elm) {
			return;
		}

		var r = {};
		if (aData.REACTIONS) { //From detail

			var sRea = '';
			for (id in aData.REACTIONS) {
				if (aData.REACTIONS[id].values && aData.REACTIONS[id].values.REAVALUE) {
					r[aData.REACTIONS[id].values.REAVALUE] = (r[aData.REACTIONS[id].values.REAVALUE] || 0) + 1;
	
					if (aData.REACTIONS[id].values.REAOWNEMAIL == sPrimaryAccount || aData.REACTIONS[id].values.REAOWNEMAIL == dataSet.get('main', ['user'])) {
						sRea = aData.REACTIONS[id].values.REAVALUE;
					}
				}
			}
			aData.REAVALUE = sRea;
	
		} else if (aData.NOTIFY_REACTIONS) { //From notification
	
			if (aData.REACTIONS) {
				for (id in aData.REACTIONS) {
					if (aData.REACTIONS[id].values && aData.REACTIONS[id].values.REAVALUE) {
						r[aData.REACTIONS[id].values.REAVALUE] = (r[aData.REACTIONS[id].values.REAVALUE] || 0) + 1;
					}
				}
	
				delete aData.REACTIONS;
			} else if (aData.META_REACTIONS) {
				r = aData.META_REACTIONS;
			}
	
			if (aData.ACTION === 'reaction') {
				r[aData.NOTIFY_REACTIONS] = parseInt(r[aData.NOTIFY_REACTIONS] || 0) + 1;
			} else {
				if (r[aData.NOTIFY_REACTIONS] > 1) {
					r[aData.NOTIFY_REACTIONS] = parseInt(r[aData.NOTIFY_REACTIONS]) - 1;
				} else {
					delete r[aData.NOTIFY_REACTIONS];
				}
			}
	
			aData.META_REACTIONS = r;
			aData.NOTIFY_REACTIONS = '';
	
		} else if (aData.META_REACTIONS && !Is.Empty(aData.META_REACTIONS)) { //From list
	
			r = aData.META_REACTIONS;
			delete aData.REACTIONS;
	
		} else {
			delete aData.REACTIONS;
			aData.REAVALUE = '';
		}
	
		elm.innerHTML = '';
		if (!Is.Empty(r)) {
			var count = 0;
			for (var i in r)
				if (Object.prototype.hasOwnProperty.call(r, i)) {
					elm.appendChild(mkElement('span', {className: 'react r_' + i, rel: i}));
					count += +(r[i] || 1);
				}
	
			if (count){
				elm.appendChild(mkElement('span', {className: 'count', text: count}));
			}
		}

		//My reaction
		var eT = image.querySelector('.button-reaction');
		if (eT){
			if (aData.REAVALUE)
				eT.setAttribute('iw-reaction', aData.REAVALUE);
			else
				eT.removeAttribute('iw-reaction');
		}

		var eTool = image.querySelector('.toolbar');
		if (WMFolders.getAccess({aid:aData.aid, fid:aData.fid}, 'write')) {
			eTool.onclick = async function(e){
				var eT = e.target;
				if (eT.tagName == 'SPAN'){

					if (hascss(eT,'react')){
						if (this.__reactTimeOut){
							window.clearTimeout(this.__reactTimeOut);
							delete this.__reactTimeOut;
						}

						if (this.__reactTimeIn){
							window.clearTimeout(this.__reactTimeIn);
							delete this.__reactTimeIn;
						}

						if (this.react){
							this.react._destruct();
							delete this.react;
						}

						await this._gui._create('reactions', 'frm_reactions','','', aData);
					}
					else
					if (hascss(eT,'button-reaction')){
						if (!this.smiles || this.smiles._destructed){
							if (aData.REAVALUE) {
								this._reaction('', aData.iid);
								aData.REAVALUE = '';
							} else {
								this.smiles = await this._gui._create('smiles', 'obj_minismile', '','arrow',[function(sReaction){
									this._reaction(aData.REAVALUE == sReaction?'':sReaction, aData.iid);
								}.bind(this)]);

								this.smiles._active(aData.REAVALUE);

								image.classList.add('active');
								this.smiles._onclose = function(){
									this._destruct();
									image.classList.remove('active');
								};

								this.smiles._placeElement(eT, {mode:'top'});
								this.smiles._modal(true);
								this.smiles._show();
							}
						}
					}
					else
					if (hascss(eT,'button-reply') && this.__list.__options.comments){
						this._comment();
					}
					else
						return;

					e.stopPropagation();
					e.preventDefault();
				}
			}.bind(this);

			eTool.onmouseover = function(e){
				var eT = e.target;
				if (eT.tagName == 'SPAN' && hascss(eT, 'react')){
					if (this.__reactTimeOut){
						window.clearTimeout(this.__reactTimeOut);
						delete this.__reactTimeOut;
					}

					if (this.__reactTimeIn){
						window.clearTimeout(this.__reactTimeIn);
						delete this.__reactTimeIn;
					}

					this.__reactTimeIn = setTimeout(
						function(){
							this._show_react(eT);
						}.bind(this), 500);
				}
			}.bind(this);

			eTool.onmouseout = function(){

				if (this.__reactTimeOut){
					window.clearTimeout(this.__reactTimeOut);
					delete this.__reactTimeOut;
				}

				if (this.__reactTimeIn){
					window.clearTimeout(this.__reactTimeIn);
					delete this.__reactTimeIn;
				}

				if (this.react)
					this.__reactTimeOut = setTimeout(
						function(){
							if (this.react){
								this.react._destruct();
								delete this.react;
							}
						}.bind(this), 300);

			}.bind(this);
		}
	}, this);
};

_me._init_controls = async function(bShow){
	if (~['obj_groupchat_pin', 'obj_groupchat_thread'].indexOf(this._parent._type) || ~['obj_groupchat_deleted', 'obj_groupchat_info'].indexOf(this._type) || this.__aData.attachment || this._destructed || this.__aData.skeleton || this.__options.disable_controls)
		return true;

	if (bShow){

		if (!this.controls) {
			var is_comment = this.__aData.EVNCOMEVNID && !(this.__list.__aRequestData.filter || {}).type;
			var disable_pin = this.__aData.EVNCLASS == 'L' || this.__aData.EVNCLASS == 'W' || this.__aData.EVNLINKTYPE == '10';
			var disable_edit = this.__aData.EVNCLASS == 'L' || this.__aData.EVNCLASS == 'Q' || this.__aData.EVNLINKTYPE == '10' || (this.__aData.EVNCLASS == 'W' && (this.__aData.EVNLINKTYPE == '7' || this.__aData.EVNLINKTYPE == '8')) || !((this.__aData.EVNOWNEREMAIL == sPrimaryAccount || this.__aData.EVNOWNEREMAIL == dataSet.get('main', ['user'])) || WMFolders.getAccess({aid:this.__aData.aid, fid:this.__aData.fid},'modify'));
			var disable_remove = (!this.__list.__options.comments && !this.__aData.EVNCOMEVNID) || !(this.__aData.EVNOWNEREMAIL == sPrimaryAccount || this.__aData.EVNOWNEREMAIL == dataSet.get('main', ['user']) || WMFolders.getAccess({aid:this.__aData.aid, fid:this.__aData.fid},'remove'));

			await this._create('controls', 'obj_tch_control', 'message', '', [
				dataSet.get('chatgpt') && this.__aData.EVNNOTE && {
					id: 'chatgpt',
					tooltip: getLang('MAIN_MENU::CHATGPT'),
					callback: [this, '__chatgpt_menu']
				},
				this.__aData.EVNNOTE && {
					id: 'copy',
					tooltip: getLang('CHATGPT::COPY_TO_CLIPBOARD'),
					callback: [function() {
						var text = this.__aData.EVNNOTE;
						if (text.indexOf('```') === 0 && (text.match(/```/g) || []).length < 3) {
							text = text.replace(/```(.*?\n|$)/g, '').trim();
						}
						text = this.__encode_body(text);
						var text2 = createTextVersion(text, {
							linkProcess: function(href, linkText) {
								return linkText || href;
							},
							imgProcess: function() {
								return '';
							}
						});
						toClipboard({
							'text/html': text,
							'text/plain': text2
						}, 'message');
					}.bind(this)]
				},
				is_comment && {
					id: 'like',
					tooltip: getLang('SMILES_NAME::THUMBSUP'),
					callback: [function(sData) {
						if (this.__aData.EVNLINKTYPE == '10'){
							if (this.item){
								if (this.item.__aData.REAVALUE == sData)
									this.item._reaction('');
								else
									this.item._reaction(sData);
							}
						}
						else
						if (this.__aData.REAVALUE == sData)
							this._reaction('');
						else
							this._reaction(sData);
					}.bind(this)]
				},
				!is_comment && (!this.__list.__options.comments || this.__aData.EVNLINKTYPE == '10') && !this.__list.__options.thread && {
					id: 'comment',
					tooltip: getLang('CHAT::ADD_COMMENT'),
					callback: [this, '_comment']
				},
				!is_comment && {
					id: 'pin',
					disabled: disable_pin,
					tooltip: getLang('CHAT::PIN'),
					callback: [this, '_pin']
				},
				{
					id: 'edit',
					disabled: disable_edit,
					tooltip: getLang('FORM_BUTTONS::EDIT'),
					callback: [this, '_edit', [true]]
				},
				{
					id: 'delete',
					disabled: disable_remove,
					tooltip: getLang('FORM_BUTTONS::REMOVE'),
					callback: [function() {
						this._gui._create('frm_confirm', 'frm_confirm', '', 'noblur', [async function() {
							if (this.__aData.EVNLINKEXTRAS){
								var linkextras = parseURL(this.__aData.EVNLINKEXTRAS) || {};
								if (linkextras.evnlockown_id && linkextras.evnlockown_id !== sPrimaryAccountGWID){
	
									var frm = await this._gui._create('remove', 'frm_confirm_threestates', '', 'noblur', [
										function () {
											TeamChatAPI.requestUnlock(this.__aData.fid, this.__aData.EVNTITLE, linkextras.evnlockown_email, 'remove');
										}.bind(this)
									], 'CONFIRMATION::DELETE_ITEM_CONFIRMATION', 'CONFIRMATION::DELETE_LOCKED_ITEM', [linkextras.evnlockown_email]);
	
									frm.x_btn_ok._value('DOCUMENT::REQUEST_UNLOCK');
	
									frm.x_btn_cancel._value('FORM_BUTTONS::REMOVE');
									frm.x_btn_cancel._onclick = function(){
										frm._destruct();
										this.__remove();
									}.bind(this);
									addcss(frm.x_btn_cancel._main, 'color2');
	
									return;
								}
							}
	
							this.__remove();
						}.bind(this)], 'CONFIRMATION::DELETE_ITEM_CONFIRMATION', 'CONFIRMATION::DELETE_ITEM');
					}.bind(this)]
				}
			], this.__aData);
		}

		if (this.controls) {
			this.controls._onhide = function(){
				removecss(this._main.parentElement, 'active');
			}.bind(this);

			this.controls._show();
		}

	} else if (this.controls) {
		return this.controls._hide();
	}

	return true;
};

_me.__renderAddonInfobar = async function() {
	if (!this._getAnchor('actionbar') || this.__aTmp.attachment) {
		return;
	}

	var my_file = this._type === 'obj_groupchat_file' && this.__aData.EVNOWNEREMAIL === sPrimaryAccount;
	var share = my_file && !this.__linkextras.EvnUrl && !this.__sharing && this.__aData.EVNLINKID;
	var tracking = my_file && this.__linkextras.EvnUrl;
	this.__aTmp.isPinnedItem = gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._isPinnedItem({ aid:this.__aData.aid, fid:this.__aData.fid, iid: this.__aData.EVNLINKID, type: 'file' });

	this.__aTmp.download = ~['obj_groupchat_file'].indexOf(this._type) && !this.__aTmp.smartURLError && (this.__aData.downloadable === void 0 ? true : this.__aData.downloadable);
	this.__aTmp.pin_dashboard = this._type === 'obj_groupchat_file' && this.__linkextras.EvnTicket && gui.frm_main._dashboardLoaded();
	this.__aTmp.save = this._type === 'obj_groupchat_file' && this.__linkextras.EvnTicket && (this.__aData.downloadable === void 0 ? true : this.__aData.downloadable);
	this.__aTmp.share = share;
	this.__aTmp.tracking = tracking;

	this.__aTmp.isMail = this._type === 'obj_groupchat_mail';
	this.__aTmp.draft = this.__aTmp.isMail && (this.__linkextras.EvnFlags & 128);

	this.__aTmp.preview = this._aTemplateData.preview;

	this.__aTmp.menu = (this.__options.followed_thread_post || this.__options.followed_thread_comment) && !this.__aTmp.draft;

	this.__aTmp.open = this.__aTmp.open || this.__aTmp.isMail;

	await this._draw('obj_groupchat_file-actionbar', 'actionbar', this.__aTmp);

	if (this.menu) {
		this.menu._menu([
			// this.__aTmp.open && {
			// 	title: 'FORM_BUTTONS::PREVIEW',
			// 	css: 'ico2 preview',
			// 	arg: [this, '_open']
			// },
			!this.__aTmp.isMail && this.__aTmp.download && {
				title: 'ATTACHMENT::DOWNLOAD',
				css: 'ico2 download',
				arg: [this, '_download']
			},
			!this.__aTmp.isMail && this.__aTmp.pin_dashboard && {
				title: this.__aTmp.isPinnedItem ? 'POPUP_ITEMS::UNPIN_FROM_DASHBOARD' : 'POPUP_ITEMS::PIN_TO_DASHBOARD',
				css: 'ico2 dashboard_pin',
				arg: [this, '_pin_dashboard']
			},
			!this.__aTmp.isMail && this.__aTmp.save && {
				title: 'ATTACHMENT::SAVE_TO_FOLDER',
				css: 'ico2 folders',
				arg: [this, '_save']
			},
			!this.__aTmp.isMail && this.__aTmp.share && {
				title: 'UPLOAD_DETAIL::SHARE',
				css: 'ico2 share2',
				arg: [this, '_share']
			},
			!this.__aTmp.isMail && this.__aTmp.tracking && {
				title: 'UPLOAD_DETAIL::TRACKING',
				css: 'ico2 tracking',
				arg: [this, '_tracking']
			},
			!this.__aTmp.isMail && this.__aTmp.tracking && {
				title: 'UPLOAD_DETAIL::SETTINGS',
				css: 'ico2 share2',
				arg: [this, '_smart_settings']
			},
			this.__aTmp.isMail && this.__aTmp.draft && {
				title: 'form_buttons::edit',
				css: 'ico2 edit',
				arg: [this, '_editMail']
			},
			this.__aTmp.isMail && !this.__aTmp.draft && {
				title: 'popup_items::reply_to_sender',
				css: 'ico2 reply',
				arg: [this, '_replyMail', [false]]
			},
			this.__aTmp.isMail && !this.__aTmp.draft && {
				title: 'popup_items::reply_to_all',
				css: 'ico2 reply_all',
				arg: [this, '_replyMail', [true]]
			},
			this.__aTmp.isMail && !this.__aTmp.draft && {
				title: 'popup_items::forward',
				css: 'ico2 forward',
				arg: [this, '_forward']
			}
		].filter(Boolean));
		this.menu._onclick = function() {
			setTimeout(function() {
				this.__eArrow.onclick();
			}.bind(this), 5);
		}
	}

	// if (this.open) {
	// 	this.open._title(getLang('FORM_BUTTONS::PREVIEW'));
	// 	this.open._onclick = this._open.bind(this);
	// }

	if (this.download) {
		this.download._title(getLang('ATTACHMENT::DOWNLOAD'));
		this.download._onclick = this._download.bind(this);
	}

	if (this.pin_dashboard) {
		this.pin_dashboard._title(this.__aTmp.isPinnedItem ? getLang('POPUP_ITEMS::UNPIN_FROM_DASHBOARD') : getLang('POPUP_ITEMS::PIN_TO_DASHBOARD'));
		this.pin_dashboard._onclick = this._pin_dashboard.bind(this);
	}

	if (this.save) {
		this.save._title(getLang('ATTACHMENT::SAVE_TO_FOLDER'));
		this.save._onclick = this._save.bind(this);
	}

	if (this.share) {
		this.share._title(getLang('UPLOAD_DETAIL::SHARE'));
		this.share._onclick = this._share.bind(this);
	}

	if (this.tracking) {
		this.tracking._title(getLang('UPLOAD_DETAIL::TRACKING'));
		this.tracking._onclick = this._tracking.bind(this);
	}

	if (this.smart_settings) {
		this.smart_settings._title(getLang('UPLOAD_DETAIL::SETTINGS'));
		this.smart_settings._onclick = this._smart_settings.bind(this);
	}

	if (this.edit_mail) {
		this.edit_mail._title(getLang('FORM_BUTTONS::EDIT'));
		this.edit_mail._onclick = this._editMail.bind(this);
	}

	if (this.reply) {
		this.reply._title(getLang('MAIN_MENU::REPLY_TO_SENDER'));
		this.reply._onclick = this._replyMail.bind(this, false);
	}

	if (this.reply_all) {
		this.reply_all._title(getLang('MAIN_MENU::REPLY_TO_ALL'));
		this.reply_all._onclick = this._replyMail.bind(this, true);
	}

	if (this.forward) {
		this.forward._title(getLang('MAIN_MENU::FORWARD'));
		this.forward._onclick = this._forward.bind(this);
	}
};

_me.__chatgpt_menu = async function(elm) {
	this.controls._show();
	addcss(elm, 'active');
	var cmenu = await this._gui._create('cmenu', 'obj_context');
	this.controls.chatgpt = cmenu;
	cmenu.__state = 'visible';
	cmenu._onclose = function() {
		removecss(elm, 'active');
		delete cmenu.__state;
	}.bind(this);
	cmenu._modal(true);

	await cmenu._fill([
		{
			title: 'CHATGPT::SUGGEST_REPLY',
			handler: [function() {
				this.__startChatGPTConversation(getLang('chatgpt::suggest_reply'));
			}.bind(this)],
			css: 'ico2 reply'
		},
		{
			title: 'CHATGPT::MAKE_OVERVIEW',
			handler: [function() {
				this.__startChatGPTConversation(getLang('chatgpt::make_overview'));
			}.bind(this)],
			css: 'ico2 make_overview'
		},
		{
			title: 'CHATGPT::TRANSLATE',
			css: 'ico2 translate',
			nodes: [{
				anchor: 'languages',
				css: 'languages'
			}],
			onmouseover: async function() {
				await cmenu._create('translate', 'obj_chatgpt_menu', 'languages', '', {
					header: false
				});
				cmenu.translate._createLanguageMenu(function(lang) {
					this.__startChatGPTConversation(getLang('chatgpt::translate_query', [getLang('language::'+ lang)]))
					cmenu._destruct();
				}.bind(this));
			}.bind(this),
			onmouseout: function() {
				cmenu.translate && cmenu.translate._destruct();
			}
		}
	].filter(Boolean));

	var pos = getSize(elm);
	cmenu._place(pos.x + pos.w / 2, pos.y + pos.h, '', 3);
};

_me.__startChatGPTConversation = function(command) {
	var sContext = this.__aData.EVNNOTE;

	if (!sContext) {
		return;
	}

	ChatGPT.conversationCreate({
		label: sContext,
		alias: this.__aData.EVN_ID
	}, function(bOK, conversation) {
		if (!bOK) {
			return;
		}

		gui.frm_main._openChatGPTConversation(conversation);

		conversation.messageCreate({
			message: command + '.\n' + getLang('chatgpt::context') + ':\n\n' + sContext,
		}, function(bOK) {
			if (bOK) {
				conversation.process();
			} else {
				conversation.delete();
			}
		})
	}.bind(this));
};

_me.__remove = function(){
	WMItems.remove({aid:this.__aData.aid, fid:this.__aData.fid, iid:[this.__aData.iid]},'','','',[function(bOK){
		bOK && this.__list._fire(this.__aData.iid, 'delete');
	}.bind(this)]);
};

_me._init_body = async function(aData){

	//update scroll!
	await this._draw('obj_groupchat_message', 'body', {
		body: this.__encode_body(aData.EVNNOTE || '', aData.MENTIONS)
	});
	[].forEach.call(this._main.querySelectorAll('.hljs'), function(hljs) {
		hljs.addEventListener('contextmenu', async function(e) {
			await gui._create("cmenu", "obj_context", '', '', me);
			var aMenu = [{
				title: 'CHATGPT::COPY_TO_CLIPBOARD',
				arg: [function() {
					var text = obj_groupchat_item.prototype.__encode_body(this.querySelector('code').textContent);
					text = createTextVersion(text, {
						linkProcess: function(href, linkText) {
							return linkText || href;
						},
						imgProcess: function() {
							return '';
						}
					});
					toClipboard({
						'text/plain': text
					}, 'codeblock');
				}.bind(this)]
			}];

			await gui.cmenu._fill(aMenu);
			gui.cmenu._place(e.clientX, e.clientY);
			e.preventDefault();
			e.stopImmediatePropagation();
		});
	});
	if (this.__aData.EVN_ID === aData.EVN_ID) {
		addcss(this._main, 'edited');
	}

	if (aData.EVNLINKEXTRAS){
		var linkextras = parseURL(aData.EVNLINKEXTRAS);
		if (linkextras.AccountEmail){
			aData.AccountName = linkextras.AccountName || linkextras.AccountEmail;
			aData.AccountEmail = linkextras.AccountEmail;
		}
	}

	var edit = this._main.querySelector('.name span.edit');
	if (edit){
		var name = aData.EVNMODIFIEDOWNERNAME && aData.EVNMODIFIEDOWNERNAME != '0'?aData.EVNMODIFIEDOWNERNAME:aData.EVNMODIFIEDOWNEREMAIL;
		edit.title = getLang('CHAT::EDITED_BY', [name.escapeHTML(), IcewarpDate.unix(aData.EVN_MODIFIED).format('L LT')]);
	}

	//Update Data
	this.__aData.EVNNOTE = aData.EVNNOTE;
	this.__aData.MENTIONS = aData.MENTIONS;
	this.__aData.AccountName = aData.AccountName;
	this.__aData.AccountEmail = aData.AccountEmail;
};

_me._show_react = function(elm){
	if (elm){

		if (this.__reactTimeIn){
			window.clearTimeout(this.__reactTimeIn);
			delete this.__reactTimeIn;
		}

		if (this.__aData.REACTIONS)
			this._fill_react(elm);
		else{
			var iid = this.__aData.iid;

			if (this.__aData.EVNLINKTYPE == '10')
				iid = this.__aData.EVNLINKID?WMItems.__clientID(this.__aData.EVNLINKID):this.__aData.iid;

			var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:iid, values:[]};
			WMItems.list(aItemsInfo,'','','',[function(aData){

				if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[iid])){
					//Reactions
					this.__aData.REACTIONS = aData.REACTIONS;
					this._fill_react(elm);
				}

			}.bind(this)]);
		}
	}
};

_me._fill_react = async function(elm){

	if (this.__aData.REACTIONS){

		if (!this.react || this.react._destructed){
			this.react = await this._gui._create('react','obj_block','','react','absolute');

			this.react._main.onmouseover = function(){
				if (this.__reactTimeOut){
					window.clearTimeout(this.__reactTimeOut);
					delete this.__reactTimeOut;
				}

				if (this.__reactTimeIn){
					window.clearTimeout(this.__reactTimeIn);
					delete this.__reactTimeIn;
				}

			}.bind(this);

			this.react._main.onmouseout = function(e){

				this.react._main.onmouseover(e);

				this.__reactTimeOut = setTimeout(
					function(){
						if (this.react){
							this.react._destruct();
							delete this.react;
						}
					}.bind(this), 300);

			}.bind(this);

		}

		var i = 0,
			sType = elm.getAttribute('rel');

		//Title
		this.react._main.innerHTML = '';
		this.react._main.appendChild(mkElement('h4',{text:getLang('SMILES_NAME::'+sType)}));

		//Values
		for(var id in this.__aData.REACTIONS){
			if (this.__aData.REACTIONS[id].values && sType == this.__aData.REACTIONS[id].values.REAVALUE){
				this.react._main.appendChild(mkElement('div',{text:this.__aData.REACTIONS[id].values.REAOWNNAME || this.__aData.REACTIONS[id].values.REAOWNEMAIL}));

				if (++i>10){
					this.react._main.appendChild(mkElement('div',{text:getLang('CHAT::REACTIONS_BUBBLE',[count(this.__aData.REACTIONS)-10])}));
					break;
				}
			}
		}

		var eAll = mkElement('div',{text:getLang('CHAT::ALL_REACTIONS'), className:'all'});
			eAll.onclick = function(){
				this._gui._create('reactions', 'frm_reactions','','', this.__aData, sType);
			}.bind(this);
		this.react._main.appendChild(eAll);


		//position
		var pos = getSize(elm),
			iTop = pos.y - (this.react._main.offsetHeight) - 15;

		if (iTop<10){
			addcss(this.react._main,'bottom');
			this.react._place(pos.x, pos.y + pos.h + 15);
		}
		else{
			removecss(this.react._main,'bottom');
			this.react._place(pos.x, iTop);
		}

	}
};

_me.__encode_body = function(sBody, aMentions){
	var aMen = {};
	for (var id in aMentions || {}) {
		aMen[aMentions[id].values.EMAIL] = {
			name: aMentions[id].values.NAME,
			email: aMentions[id].values.EMAIL
		};
	}

	return obj_highlight._highlight((sBody || '')).split(/<\/?code>/).map(function(v, i){
		if (i % 2) {
			return '<code>' + v + '</code>';
		} else {
			var sOut = v;

			if (GWOthers.getItem('CHAT','smiles') == '1') {
				sOut = Smiles.replaceSmiles(sOut);
			}

			if (sOut.indexOf('@[')>-1){
				sOut = sOut.replace(/(@\[([^\]]{1,128})\])/g, function(){
					var str = arguments[2],
						name = str,
						email = str.indexOf('@')>-1?str:str + '@' + dataSet.get('main',['domain']),
						full = email,
						title = email;

					if (name === '@all@') {
						name = getLang('CHAT::ALL_MEMBERS');
					} else if (aMen[email]){
						name = aMen[email].name || aMen[email].email;
						full = MailAddress.createEmail(aMen[email].name, aMen[email].email);
						title = MailAddress.createEmail(aMen[email].name, aMen[email].email, true);
					}

					return mkElement('span', {className:'mention ' + ((email == sPrimaryAccount || email == dataSet.get('main', ['user']))?' me':''), title:title, rel:full, text: (gui._rtl?'':'@')+name}).outerHTML;
				});
			}

			return sOut;
		}

	}).join('');
};

_me._comment = function(){
	var aData = this.__aData;
	if (this.__aData.EVNCOMEVNID){
		if (this.__list.__options.comments && this.item){

			//Update when old values
			aData = clone(this.item.__aData, true);
			aData.updateMe = this.item.__updateMe;
		}
	}
	else
	if (this.__aData.EVNLINKTYPE == '10'){
		if (this.item)
			aData = clone(this.item.__aData, true);
	}

	if (aData && this.__list._onreply)
		this.__list._onreply.call(this.__list, aData);
};

_me.__destructor_item = function(){
	this.__scrollInterval && clearInterval(this.__scrollInterval);
};