_me = obj_groupchat_file.prototype;
function obj_groupchat_file(){};

_me.__constructor = async function() {
	await storage.library('short_url');
	var me = this,
		aData = this.__aData,
		linkextras = {},
		sTemplate = 'obj_groupchat_file-file',
		aTmp = this.__aTmp || {
			doctype: 'file',
			open: false
		},
		url;

	this._opt = {
		preview: {
			w:942,
			h:942
		}
	};

	this._main.setAttribute('evnclass',aData.EVNCLASS);
	if (aData.attachment) {
		this._main.classList.add('tmp');
	}

	if (aData.EVNLINKEXTRAS) {
		linkextras = parseURL(aData.EVNLINKEXTRAS);
	} else {
		var map = ['EvnClass', 'EvnComplete', 'EvnLocation', 'EvnTicket', 'EvnThumbnailId', 'EvnThumbnailTicket', 'EvnProcessingQueued', 'EvnTitle', 'EvnSizeInfo', 'EvnThumbnailTime'];
		for (var i in map) {
			linkextras[map[i]] = aData[map[i].toUpperCase()];
		}
	}

	if (linkextras.EvnComplete) {
		aTmp.size = parseFileSize(linkextras.EvnComplete);
	}

	if (linkextras.EvnTicket) {
		if (~linkextras.EvnTicket.indexOf('/teamchatapi/') && ~linkextras.EvnTicket.indexOf('ticket=')) {
			linkextras.EvnTicket = linkextras.EvnTicket.replace(/(&token=[a-z\d-]+)/, '');
			linkextras.EvnTicket += '&token=' + sPrimaryAccountTeamchatToken;
		}

		if (linkextras.EvnThumbnailTicket && ~linkextras.EvnThumbnailTicket.indexOf('/teamchatapi/') && ~linkextras.EvnThumbnailTicket.indexOf('ticket=')) {
			linkextras.EvnThumbnailTicket = linkextras.EvnThumbnailTicket.replace(/(&token=[a-z\d-]+)/, '');
			linkextras.EvnThumbnailTicket += '&token=' + sPrimaryAccountTeamchatToken;
		}

		//Encode attachment ID with %20
		linkextras.EvnLocation = encodeURIComponent(linkextras.EvnLocation).replace(/!/g, '%21').replace(/'/g, '%27').replace(/\(/g, '%28').replace(/\)/g, '%29').replace(/\*/g, '%2A');

		if (aData.EVNCLASS == 'Z'){
			this.__ticketUrl = parseURL(linkextras.EvnTicket.split('#').pop());
			aTmp.smartURL = aTmp.smartURL === void 0 ? true : aTmp.smartURL;
			aTmp.filename = aData.filename = aData.EVNTITLE;
			if (this.__ticketUrl.ticket) {
				aTmp.url = aData.url = location.origin + '/teamchatapi/files.download?' + buildURL({ticket: this.__ticketUrl.ticket, password: this.__ticketUrl.password});
			} else if (aTmp.smartURL) {
				return ShortURL.resolve({
					url: linkextras.EvnTicket,
					callback: function(oURL, sError) {
						if (oURL) {
							linkextras.EvnTicket = oURL.url;
							linkextras.EvnUrl = oURL.url;
							aData.editable = oURL.editable;
							aData.downloadable = oURL.downloadable;
							aData.EVNLINKEXTRAS = buildURL(linkextras);
							if (+oURL.expiration && +oURL.expiration < Math.floor(+new Date() / 1000)) {
								aTmp.smartURLError = getLang('FILE::UNAVAILABLE');
							}
						} else {
							switch(sError) {
								case 'E_DOCUMENT_INVITE_PASSWORD':
									aTmp.password_protected = true;
								break;
								default:
									aTmp.smartURLError = getLang('FILE::UNAVAILABLE');
							}
						}
						aTmp.smartURL = false;
						me.__rerender();
					},
					filename: aTmp.filename,
					skipPasswordPrompt: true,
					doNotTrack: true
				});
			}
		}
		else{
			aTmp.filename = aData.filename = linkextras.EvnTitle;
			aTmp.url = aData.url = linkextras.EvnTicket || aData.EVNTICKET;
			aTmp.preview = !!linkextras.EvnThumbnailId || linkextras.EvnProcessingQueued == '1';
			aTmp.menubutton = true;
		}

		//Image
		if (Item.imageSupport(aTmp.filename)){
			var ratio;
			aTmp.open = true;
			aTmp.doctype = 'image';
			if (this.__aDatas) {
				sTemplate = 'obj_groupchat_file-images';
				this._fileinfo = [];
				for (aData of this.__aDatas) {
					linkextras = parseURL(aData.EVNLINKEXTRAS);
					ratio = window.retina || window.devicePixelRatio || 1;
					if (linkextras.EvnComplete>10485760)
						url = await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID], void 0, {resize: 1, width: window.screen.availWidth * ratio, height: window.screen.availHeight * ratio});
					else
						url = aData.EVNTICKET || await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID]);

					var previewURL = url;
					if (linkextras.EvnProcessingQueued == '0') {
						if (linkextras.EvnThumbnailTicket){
							previewURL = linkextras.EvnThumbnailTicket  + '&' + buildURL({'resize':1, 'width':this._opt.w, 'height':this._opt.h});
						} else if (linkextras.EvnThumbnailId){
							previewURL = await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID], linkextras.EvnThumbnailId, { resize: 1, width: this._opt.w, height: this._opt.h, t: linkextras.EvnThumbnailTime});
						}
					}
					
					this._fileinfo.push({
						data: aData,
						title: aTmp.filename,
						url: url,
						previewURL: previewURL
					});
				};
				aTmp.images = this._fileinfo;
				aTmp.count = Math.min(6, aTmp.images.length);
				if (aTmp.images.length > 9) {
					this._main.classList.add('collapsed');
				}
			} else {
				sTemplate = 'obj_groupchat_file-image';

				var dim = parseURL(linkextras.EvnSizeInfo);
					dim.oh = +dim.oh || +dim.th || (aData.attachment || {}).height || 0;
					dim.ow = +dim.ow || +dim.tw || (aData.attachment || {}).width || 0;

				if (dim.oh && dim.ow) {
					aTmp.wrap = {ratio: dim.oh/dim.ow*100};
					if (dim.oh>400){
						aTmp.wrap.width = dim.ow * (400/dim.oh);
						aTmp.wrap.height = dim.oh * (400/dim.oh);
					}
					else{
						aTmp.wrap.width = dim.ow;
						aTmp.wrap.height = dim.oh;
					}
				}

				if (aData.attachment && aTmp.url) {
					aTmp.preview = true;
				}

				if (linkextras.EvnProcessingQueued == '0' && (linkextras.EvnThumbnailTicket || linkextras.EvnThumbnailId)) {
					delete aTmp.url;
				}

				addcss(this._main, 'wrap');

				this._fileinfo = Object.assign({
						title: aTmp.filename,
						data: aData
					},
					aTmp.wrap
				);

				//Set bubble width
				// if (this._fileinfo.width<640)
				// 	this._main.style.maxWidth = (Math.max(360, this._fileinfo.width) + 70) + 'px';

				if (aData.EVNCLASS == 'Z' && aData.url){
					this._fileinfo.url = aData.url;
				}
				//resize images bigger then 10MB
				else{
					ratio = window.retina || window.devicePixelRatio || 1;
					if (linkextras.EvnComplete>10485760)
						this._fileinfo.url = await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID], void 0, {resize: 1, width: window.screen.availWidth * ratio, height: window.screen.availHeight * ratio});
					else
						this._fileinfo.url = aData.EVNTICKET || aTmp.url || await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID]);
				}
			}
		} else if (Path.extension(aTmp.filename) === 'heic') {
			sTemplate = 'obj_groupchat_file-image';
			this._fileinfo = {
				url: aTmp.url,
				data: aData,
				title: aTmp.filename,
				generatingPreview: true
			};
			aTmp.wrap = {
				width: 0,
				height: 0
			};
		}
		else
		//Video
		if (Item.videoSupport(aTmp.filename)){
			aTmp.id = unique_id();
			sTemplate = 'obj_groupchat_file-video';

			this._fileinfo = {
				title: aTmp.filename,
				iid: aData.EVN_ID
			};

			aTmp.wrap = {
				ratio: 56.25
			};


			if (aData.attachment) {
				aTmp.preview = true;
				this._fileinfo.url = aTmp.url;
				aTmp.type = aData.attachment.type;
			} else if (aData.EVNCLASS == 'Z')
				this._fileinfo.url = aTmp.url;
			else
				this._fileinfo.url = await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID]);

			aTmp.poster = './client/skins/blank.gif';
		}
	}

	var ext;

	//conference recording
	if (aData.EVNCLASS === 'R' && aData.EVNLINKTYPE == 9){
		ext = 'conference-record';
		sTemplate = 'obj_groupchat_file-video';
	}
	else{
		ext = Path.extension(aTmp.filename);
	}

	switch(ext) {
		//Sound
		case 'mp3':
			aTmp.play = !this.__options.room;
			aTmp.doctype = 'audio';
			this._title(getLang('CHAT::ITM_NEW_AUDIO'));
			break;
		case 'wav':
			aTmp.play = !this.__options.room;
			aTmp.doctype = 'audio';
			break;

		case 'pdf':
			this._title(getLang('CHAT::ITM_NEW_DOC'));
			aTmp.doctype = 'pdf';
			aTmp.open = true;
			break;

		default:
			if (Item.isDocument(aTmp.filename)){
				this._title(getLang('CHAT::ITM_NEW_DOC'));
				aTmp.doctype = 'doc';
				aTmp.open = Item.officeSupport(aTmp.filename);
			} else if (Item.isSpreadsheet(aTmp.filename)){
				this._title(getLang('CHAT::ITM_NEW_XLS'));
				aTmp.doctype = 'xls';
				aTmp.open = Item.officeSupport(aTmp.filename);
			} else if (Item.isPresentation(aTmp.filename)){
				this._title(getLang('CHAT::ITM_NEW_PPT'));
				aTmp.doctype = 'ppt';
				aTmp.open = Item.officeSupport(aTmp.filename);
			} else if (!this._fileinfo) {
				aTmp.open = Item.editSupport(aTmp.filename);
			}
	}

	if (this._fileinfo) {
		if (Item.videoSupport(aTmp.filename)) {
			aTmp.doctype = 'video';
			aTmp.open = true;
			this._title(getLang('CHAT::ITM_NEW_VIDEO'));
		} else if (this.__aDatas) {
			this._title(getLang('CHAT::ITM_NEW_PICTURES', [this.__aDatas.length]));
		} else {
			this._title(getLang('CHAT::ITM_NEW_PICTURE'));
		}
	}
	else
	if (aTmp.doctype == 'file')
		this._title(getLang('CHAT::ITM_NEW_FILE'));

	aTmp.shareable = !sPrimaryAccountGUEST && aData.EVNCLASS !== 'Z';
	aTmp.attachment = aData.attachment;

	if (aTmp.password_protected || aTmp.smartURLError) {
		sTemplate = 'obj_groupchat_file-protected';
	}
	addcss(this._main, sTemplate);
	var height = this._main.clientHeight;

	await this._draw(sTemplate, 'addon', aTmp, 2);

	this.__aTmp = aTmp;
	this.__linkextras = linkextras;

	await this.__renderAddonInfobar();

	if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
		this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
	}
	
	if (aTmp.password_protected && this.unlock) {
		this.unlock._onclick = function(e) {
			e.stopPropagation();
			this._unlock();
		}.bind(this);
	}

	if (sTemplate == 'obj_groupchat_file-video') {

		//for frm=main mode
		await storage.library('video.min', 'videojs');
		storage.css('video-js-base');
		storage.css('video-js-theme-fantasy');

		this.__video = videojs(this._getAnchor('video'), {
			controlBar: {
				pictureInPictureToggle: false
			}
		});
		this.__video.on('play', function() {
			gui.__exeEvent('videojs-started', this.__video);
		}.bind(this));
		height = this._main.clientHeight;
		this.__video.on('canplay', function() {
			if (this._destructed) {
				return;
			}
			this.__video.off('canplay');
			this._getAnchor('video-wrapper').classList.remove('hidden');
			if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
				this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
			}
		}.bind(this));
		this.__video.on('error', function() {
			this._getAnchor('video-wrapper').classList.add('hidden');
		}.bind(this));
		gui._obeyEvent('videojs-started', [this, '__stopVideo']);
	}
	else
	if (sTemplate == 'obj_groupchat_file-image') {

		if (this._main.querySelector('.foto-wrapper')) {
			this._main.querySelector('.foto-wrapper').onclick = this._open.bind(this);
		}

		// var eFoto = this._main.querySelector('.foto-wrapper'),
		// 	eWrap = this._main.querySelector('.ratio-wrapper'),
		// 	eCWindow = this._main.querySelector('.foto-wrapper>iframe').contentWindow,
		// 	eAddon = this._getAnchor('addon');

		// eCWindow.onresize = function(){
		// 	if (eCWindow.__lastHeight == eWrap.offsetHeight && eCWindow.__lastWidth == eWrap.offsetWidth)
		// 		return;

		// 	eCWindow.__lastHeight = eWrap.offsetHeight;
		// 	eCWindow.__lastWidth = eWrap.offsetWidth;

		// 	var width = Math.round(this._fileinfo.width || 0),
		// 		height = Math.round(this._fileinfo.height || 0);

		// 	if (width && eFoto.offsetWidth>=width){
		// 		eAddon.setAttribute('iw-rounded','rounded');
		// 	}
		// 	else
		// 	if (height && eFoto.offsetHeight>height || Math.round(eFoto.offsetWidth*(this._fileinfo.height/this._fileinfo.width))<200){
		// 		eAddon.setAttribute('iw-rounded','rounded');
		// 	}
		// 	else{
		// 		eAddon.removeAttribute('iw-rounded');
		// 		return;
		// 	}

		// 	if (eWrap.offsetHeight<100 || eWrap.offsetWidth<100)
		// 		eAddon.setAttribute('iw-rounded','small');

		// }.bind(this);

		// eCWindow.onresize();
	} else if (sTemplate === 'obj_groupchat_file-images') {
		[].forEach.call(this._main.querySelectorAll('.image[rel]'), function(image) {
			image.onclick = this._open.bind(this);
			image.oncontextmenu = function(image, e) {
				this._parent._oncontext(e, e.target, image);
			}.bind(this, image);
		}.bind(this));
	}

	//Preview with Thumb
	if (linkextras.EvnProcessingQueued == '0') {
		if (linkextras.EvnThumbnailTicket){
			this._preview_image(linkextras.EvnThumbnailTicket  + '&' + buildURL({'resize':1, 'width':this._opt.w, 'height':this._opt.h}));
		}
		else
		if (linkextras.EvnThumbnailId){
			this._preview_image(await Item.webdavURL([aData.aid, aData.fid, aData.EVNLINKID], linkextras.EvnThumbnailId, { resize: 1, width: this._opt.w, height: this._opt.h, t: linkextras.EvnThumbnailTime}));
		}
		else
		//Image preview
		if (linkextras.EvnTicket && Item.imageSupport(linkextras.EvnTitle)){
			this._preview_image(linkextras.EvnTicket);
		}
	}
	else
	if (sTemplate === 'obj_groupchat_file-image' && aTmp.url) {
		this._preview_image(aTmp.url);
	}

	if (Path.extension(aTmp.filename) === 'heic') {
		url = dataSet.get('cache', ['image', aTmp.url]);
		if (url) {
			var image = new Image();
			image.onload = function() {
				if (me._destructed) {
					return;
				}
				var width = image.naturalWidth,
					ratio = image.naturalHeight / image.naturalWidth * 100;

				if (image.naturalHeight > 400){
					width = image.naturalWidth * (400 / image.naturalHeight);
				}

				if (me._getAnchor('preview')) {
					me._getAnchor('preview').removeAttribute('hidden');
				}
				me._getAnchor('img').src = url;
				me._getAnchor('ratio').style.paddingBottom = ratio + '%';
				me._getAnchor('width').style.width = width + 'px';
				addcss(me._main, 'wrap');
				// if (width < 640) {
				// 	me._main.style.maxWidth = (Math.max(360, width) + 70) + 'px';
				// }
				me._fileinfo.url = url;
				me._fileinfo.generatingPreview = false;
			};
			image.src = url;
		} else {
			addcss(this._main, 'generating_preview');
			await storage.library('heic-to', 'heic-to/dist');
			var loader = await this._create('img_generator_loader', 'obj_loader', 'ratio');
			loader._value('Generating preview');
			getRemoteFileContent(aTmp.url, function(response) {
				heicTo({ blob: response, toType: "image/jpg", quality: 0.5 }).then(function(newImage) {
					var url = URL.createObjectURL(newImage);
					dataSet.add('cache', ['image', me._fileinfo.url], url);
					me._fileinfo.url = url;
					if (me._destructed) {
						return;
					}

					var image = new Image();
					image.onload = function() {
						if (me._destructed) {
							return;
						}
						removecss(me._main, 'generating_preview');
						me._fileinfo.generatingPreview = false;
						loader._destruct();
						var width = image.naturalWidth,
							ratio = image.naturalHeight / image.naturalWidth * 100;

						if (image.naturalHeight > 400){
							width = image.naturalWidth * (400 / image.naturalHeight);
						}

						if (me._getAnchor('preview')) {
							me._getAnchor('preview').removeAttribute('hidden');
						}
						me._getAnchor('img').src = url;
						me._getAnchor('ratio').style.paddingBottom = ratio + '%';
						me._getAnchor('width').style.width = width + 'px';
						addcss(me._main, 'wrap');
						// if (width < 640) {
						// 	me._main.style.maxWidth = (Math.max(360, width) + 70) + 'px';
						// }
					};
					image.src = url;
				}).catch(function() {
					loader._destruct();
				});
			}, 'blob');
		}
	}

	if (aTmp.open) {
		if (this._getAnchor('preview')) {
			this._getAnchor('preview').onclick = function() {
				me._open();
			};
		}
		if (this._getAnchor('filename')) {
			this._getAnchor('filename').onclick = function() {
				me._open();
			};
		}
	}

	//Reload preview
	if (!gui.socket && linkextras.EvnProcessingQueued == 1){
		this.__timeout = setTimeout(function(){
			me.__update();
		}, 5000);
	}

	if (aData.attachment) {
		(this._main.querySelector('.center-wrapper') || this._getAnchor('addon') || this._getAnchor('body')).appendChild(mkElement('div', {
			className: 'progress pie',
			id: this._pathName + '#progress-pie'
		}));
		gui._obeyEvent('onuploadprogress', [this, '__onuploadprogress']);
		gui._obeyEvent('onuploaderror', [this, '__onuploaderror']);
	}

	if (this.__aDatas) {
		this._init_toolbar(this.__aDatas, true);
	}

	this._add_destructor('__destructor');
};

_me._pin_dashboard = function() {
	gui.frm_main.dashboard[this.__aTmp.isPinnedItem ? '_unpinItem' : '_pinItem']({
		aid: this.__aData.aid,
		fid: this.__aData.fid,
		iid: this.__aData.EVNLINKID,
		type: 'file'
	});

	this.__aTmp.isPinnedItem = !this.__aTmp.isPinnedItem;
	this.pin_dashboard._title(this.__aTmp.isPinnedItem ? getLang('POPUP_ITEMS::UNPIN_FROM_DASHBOARD') : getLang('POPUP_ITEMS::PIN_TO_DASHBOARD'));
};

_me._save = function() {
	ShortURL.resolve({
		url: this.__linkextras.EvnTicket,
		callback: function(oURL, error) {
			if (error) {
				return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
			}
			var url = oURL ? oURL.url : this.__linkextras.EvnTicket;

			gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', sPrimaryAccount, Mapping.getDefaultFolderForGWType('F'), [this, '_saveFolder', [[{ values: { description: this.__aData.EVNTITLE, size: this.__aData.EVNCOMPLETE, class: 'link', fullpath: url } }]]], true, false, 'F', 'i', true);
		}.bind(this),
		filename: this.__aData.EVNTITLE
	});
};

_me._share = function() {
	this.__sharing = true;
	this.share && this.share._main.classList.add('loading');
	this.menu && this.menu._main.classList.add('loading');
	TeamChatAPI.filesInvite({ id: this.__aData.EVNLINKID, editable: false }, {
		success: async function (response) {
			this.__linkextras.EvnUrl = this.__aData.EVNURL = response.inviteticket;
			this.__sharing = false;
			this.__renderAddonInfobar();
			Item.collaborate([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID)], this._gui);
		},
		context: this
	});
};

_me._tracking = function() {
	gui.frm_main.rslide.upload_detail._init({fid: this.__aData.fid, iid: this.__aData.EVNLINKID});
	gui.frm_main.rslide._value('upload_detail');
};

_me._smart_settings = function() {
	Item.collaborate([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID)], this._gui);
};

_me._unlock = function(callback) {
	this.unlock._disabled(true);
	return ShortURL.resolve({
		url: this.__linkextras.EvnTicket,
		callback: function(oURL, error) {
			if (error) {
				gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
				return this.unlock._disabled(false);
			}
			if (oURL) {
				this.__linkextras.EvnTicket = oURL ? oURL.url : this.__linkextras.EvnTicket;
				this.__aData.editable = oURL.editable;
				this.__aData.downloadable = oURL.downloadable;
				this.__aData.EVNLINKEXTRAS = buildURL(this.__linkextras);
				this.__aData.EVNTITLE = oURL.filename;
				this.__aTmp.password_protected = false;
				if (+oURL.expiration && +oURL.expiration < Math.floor(+new Date() / 1000)) {
					this.__aTmp.smartURLError = getLang('FILE::UNAVAILABLE');
				}
				this.__rerender();

				callback && callback();
			}
		}.bind(this),
		filename: this.__aTmp.filename,
		doNotTrack: true
	});
};

_me.__rerender = function() {
	if (this._destructed) {
		return;
	}
	// this._clean();
	var addons = this._getAnchor('addon');
	[].forEach.call(addons.querySelectorAll('.body.protected'), function(addon) {
		addons.removeChild(addon);
	});

	this.__constructor();
};

_me._download = function() {
	if (this.__aTmp.smartURL || this.__aTmp.smartURLError) {
		return;
	}
	if (this.__aTmp.password_protected) {
		this._unlock(function() {
			ShortURL.resolve({
				url: this.__linkextras.EvnTicket,
				callback: function(oURL) {
					this.__linkextras.EvnTicket = oURL ? oURL.url : this.__linkextras.EvnTicket;
					this.__aData.EVNLINKEXTRAS = buildURL(this.__linkextras);
					downloadItem(this.__linkextras.EvnTicket, true);
				}
			});
		}.bind(this));
	} else if (this.__aTmp.url) {
		downloadItem(this.__aTmp.url, true);
	} else if (this.__aData.EVNURL || this.__aData.EVNTICKET) {
		ShortURL.resolve({
			url: this.__aData.EVNURL || this.__aData.EVNTICKET,
			callback: function(oURL) {
				this.__aData.EVNURL = oURL ? oURL.url : this.__aData.EVNURL || this.__aData.EVNTICKET;
				downloadItem(this.__aData.EVNURL, true);
			}.bind(this)
		})
	}
};

_me.__getFilename = function(aData) {
	if (aData.EVNCLASS == 'Z') {
		return aData.EVNTITLE;
	} else if (aData.EVNLINKEXTRAS) {
		var linkextras = parseURL(aData.EVNLINKEXTRAS);
		if (linkextras.EvnTicket) {
			return linkextras.EvnTitle;
		}
	}
	return '';
};

_me.__onuploadprogress = function(data) {
	if (data.file === this.__aData.attachment) {
		this._getAnchor('progress-pie').style.setProperty('--p', Math.ceil(100 / data.size * data.completed));
	}
};

_me.__onuploaderror = function() {

};

_me.__stopVideo = function(context) {
	if (this.__video && context !== this.__video) {
		try {
			this.__video.pause();
		} catch {
			//
		}
	}
};

_me._open = async function(e, sid, sURL) {
	if (e) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	}

	if (this.__aTmp.smartURLError) {
		return;
	}
	if (this.__aTmp.password_protected) {
		return this._unlock(function() {
			this._open(e, sid);
		}.bind(this));
	}

	var i, id = sid || (e && e.target.getAttribute('rel')),
		data;

	if (this.__aDatas && id) {
		for (i in this.__aDatas) {
			if (this.__aDatas[i].EVN_ID === WMItems.__serverID(id)) {
				data = this.__aDatas[i];
				break;
			}
		}
	} else {
		data = this.__aData;
	}

	sURL = sURL || data.url;
	if (!sURL && (ShortURL.matches(this.__linkextras.EvnTicket) || this.__linkextras.EvnTicket.match(/\/collaboration\/\?ticket=(.*?)&url=(.*?)(?:&|$)/g))) {
		return ShortURL.resolve({
			url: this.__linkextras.EvnTicket,
			callback: function(oURL, sError) {
				if (sError) {
					return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
				}
				this._open(e, sid, oURL ? oURL.url : this.__linkextras.EvnTicket);
			}.bind(this)
		});
	}

	var iid = WMItems.__clientID(data.EVNLINKID);
	var filename = this.__getFilename(data);

	if (Path.extension(filename) == 'pdf') {
		if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
			downloadItem(sURL || this.__linkextras.EvnTicket, true);
		} else {
			var pdf = await this._gui._create('pdf', 'frm_pdf');
			pdf._load(sURL || this.__linkextras.EvnTicket, filename, this.__linkextras.EvnThumbnailTicket);
		}
	} else
	if (Item.imageSupport(filename) || (Path.extension(filename) == 'heic' && !this._fileinfo.generatingPreview)){

		var arr = [].concat(this._fileinfo);

		var value = 0, l;
		for (i = 0, l = arr.length; i<l; i++)
			if (arr[i].data.EVN_ID === data.EVN_ID){
				value = i;
				break;
			}

		var img = await this._gui._create('imgview','frm_imgview');
			await img._fill(arr);
			img._value(value);
	}
	else
	if (Item.editSupport(filename))
		if (data.EVNCLASS === 'Z') {
			getRemoteFileContent(sURL, function(content) {
				this._gui._create('text','frm_editor', '', '', {
					filename: filename,
					content: content
				});
			}.bind(this));
		} else {
			Item.previewItem([data.aid, data.fid, iid], filename, false, true);
		}
	else
	if (Item.officeSupport(filename)) {
		data = clone(data, true);
		data.previewURL = this.__linkextras.EvnThumbnailTicket;

		if (data.EVNCLASS == 'Z'){
			data.ticket = this.__ticketUrl.ticket;
			if (this.__ticketUrl.password) {
				data.password = this.__ticketUrl.password;
			}
			Item.officeOpen(data, [downloadItem, [sURL, true]], Path.extension(filename), data.editable === false ? 'view' : '');
		}
		else{
			data.iid = iid;
			data.fid = data.fid.replace('/' + (data.EVNCOMEVNID || data.EVN_ID), '');
			Item.officeOpen(data, [Item.downloadFile, [[data.aid, data.fid, data.iid]]], Path.extension(filename), data.editable === false ? 'view' : '');
		}
	}
	else
	if (Item.videoSupport(filename)) {
		Item.playFile([data.aid, data.fid, iid], filename, true, sURL);
	}
	else
	if (sURL) {
		downloadItem(sURL,true);
	}
};

_me.__update = function(){
	var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid || this.__aData.EVN_ID, values:['EVNNOTE','EVN_CREATED','EVN_MODIFIED','EVNLINKEXTRAS']};

	WMItems.list(aItemsInfo,'','','',[async function(aData){

		if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[this.__aData.iid || WMItems.__clientID(this.__aData.EVN_ID)]) && aData.EVNLINKEXTRAS){

			if (this.__timeout){
				clearTimeout(this.__timeout);
				delete this.__timeout;
			}

			//preview
			var linkextras = this.__linkextras = parseURL(aData.EVNLINKEXTRAS);
			if (linkextras){
				if (linkextras.EvnProcessingQueued == '0'){

					//Preview with Thumb
					var src;
					if (linkextras.EvnThumbnailTicket)
						src = linkextras.EvnThumbnailTicket  + '&' + buildURL({'resize':1, 'width':this._opt.w, 'height':this._opt.h, 't':linkextras.EvnThumbnailTime});
					else
					if (linkextras.EvnThumbnailId)
						src = await Item.webdavURL([this.__aData.aid, this.__aData.fid, this.__aData.EVNLINKID], linkextras.EvnThumbnailId, { resize: 1, width: this._opt.w, height: this._opt.h, t: linkextras.EvnThumbnailTime });

					this._preview_image(src);
				}
				else{
					this.__timeout = setTimeout(this.__update.bind(this), 5000);
				}

				//Reactions
				if (!aData.REACTIONS && linkextras.Evn_MetaData){
					this.__aData.REAVALUE = linkextras.ReaValue || '';
					var meta = parseURL(linkextras.Evn_MetaData);
					aData.REACTIONS = meta.core_reactions_data?parseURL(meta.core_reactions_data):{};
				}
			}

			this.__aData.EVNLINKEXTRAS = aData.EVNLINKEXTRAS;

			//Body
			if (this.__aData.EVNNOTE != aData.EVNNOTE)
				this._init_body(aData);

			if (!this.__aDatas) {
				for (var i in this.__aDatas) {
					if (this.__aDatas[i] === this.__aData) {
						this.__aDatas[i] = aData;
					}
				}
			}
			this.__aData = aData;
			if ((this._main || {}).parentElement) {
				this._init_toolbar(aData);
			}
		}

	}.bind(this)]);
};

_me._preview_image = function(src){
	if (!this._destructed && src) {
		if (~src.indexOf('/teamchatapi/') && ~src.indexOf('files.download') && ~src.indexOf('ticket=') && !~src.indexOf('token=')) {
			src += '&token=' + sPrimaryAccountTeamchatToken;
		}
		var elm = this._getAnchor('video');
		if (elm) {
			elm.querySelector('.vjs-poster').style.backgroundImage = 'url("'+ encodeURI(src) +'")';
		} else {
			elm = this._getAnchor('preview');
			var img = this._getAnchor('img') || (elm && elm.firstElementChild);
			if (img) {
				var height = this._main.clientHeight;
				img.addEventListener('load', function() {
					if (this._destructed) {
						return;
					}

					var width = img.naturalWidth,
						ratio = img.naturalHeight / img.naturalWidth * 100;

					width && elm && elm.removeAttribute('hidden');

					if (img.naturalHeight > 400){
						width = img.naturalWidth * (400 / img.naturalHeight);
					}

					if (this._getAnchor('ratio')) {
						this._getAnchor('ratio').style.paddingBottom = ratio + '%';
					}
					if (this._getAnchor('width')) {
						this._getAnchor('width').style.width = width + 'px';
					}
					addcss(this._main, 'wrap');

					if (this.__initialLoad || (currentBrowser() === 'Safari' && (this.__list._main.scrollTop < (this._main.parentElement.offsetTop + this._main.parentElement.offsetHeight)))) {
						this.__list._scrollBy && this.__list._scrollBy(Math.abs(this._main.clientHeight - height));
					}
				}.bind(this));
				img.src = src;
			}

			if (Path.extension(this.__aTmp.filename) === 'heic') {
				this._fileinfo.previewURL = src;
				this._fileinfo.generatingPreview = false;
			}
		}
	}
};

_me._saveFolder = function(aid, fid, atts) {
	//DIRECT
	var extras = parseURL(this.__aData.EVNLINKEXTRAS),
		now = new IcewarpDate(),
		att = atts || [{
			values:{
				'class': 'file_attachment',
				'description':extras.EvnLocation,
				'size':extras.EvnComplete,
				'fullpath':this.__aData.aid +'/'+ this.__aData.fid + '/' +  this.__aData.EVNLINKID
			}
		}];

	//For filetime use Evn_Created

	WMItems.add([aid,fid],{
		values:{
			'EVNSHARETYPE':GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS','file_sharing'),
			'EVNSTARTDATE':now.format(IcewarpDate.JULIAN),
			'EVNSTARTTIME':now.format(IcewarpDate.JULIAN_TIME)
		},
		duplicity:'rename',
		ATTACHMENTS:att
	},'','','',[
		function(bOK, result){
			//Notify user
			if (bOK && result && result.id){

				// if (gui.notifier)
				// 	gui.notifier._value({type: 'item_saved', args: [aid, fid]});

				//refresh Files folder if active
				var aItems = dataSet.get('items');
				for(var sAccId in aItems)
					for(var sFolId in aItems[sAccId])
						break;

				if (aid == sAccId && fid == sFolId)
					try{
						gui.frm_main.main.list._serverSort({aid:aid,fid:fid});
					}
					catch(r){ console.log(this._name||false,r);}
			}
			else
			if (gui.notifier)
				gui.notifier._value({type: 'alert', args: {text:'DOCUMENT::SAVE_ERROR'}});
		}
	]);
};

_me.__destructor = function(){
	if (this.__timeout) {
		window.clearTimeout(this.__timeout);
	}

	if (this.__video) {
		this.__video.dispose();
	}

	gui._disobeyEvent('videojs-started', [this, '__stopVideo'])
	gui._disobeyEvent('onuploadprogress', [this, '__onuploadprogress']);
	gui._disobeyEvent('onuploaderror', [this, '__onuploaderror']);
};
