_me = obj_groupchat_event.prototype;
function obj_groupchat_event(){};

_me.__constructor = async function() {
	this.__fill(this.__aData);
};

_me.__fill = async function(aData){

	if (this.btn_accept)
		await this._clean(this.btn_accept._anchor);

	var aTmp = {},
		linkextras = {};

	if (aData.EVNLINKEXTRAS){

		linkextras = parseURL(aData.EVNLINKEXTRAS);
		if (linkextras){

			if (linkextras.EvnLinkInvalid == '1'){
				this._parent._remove(this._anchor, this.__aData.iid);
				return;
			}

			aTmp.title = linkextras.EvnTitle || '';
			aTmp.conference = parseURL(linkextras.meeting_info || '').id;

			var a = new IcewarpDate(linkextras.EvnStartDate, {format:IcewarpDate.JULIAN});
			if (linkextras.EvnStartTime>=0){
				a.setTime(linkextras.EvnStartTime, true);
				aTmp.date = a.format('dddd, L LT');
			}
			else{
				aTmp.date = a.format('dddd, L');
			}
		}
	}

	await this._draw('obj_groupchat_event', 'addon', aTmp, 2);

	if (linkextras.EvnMyStatus == 'A'){
		this.btn_accept._value('ATTENDEES::STATUS_A');
		removecss(this.btn_accept._main, 'select');
	}
	else
	if (linkextras.EvnMyStatus == 'D'){
		this.btn_accept._value('ATTENDEES::STATUS_D');
		removecss(this.btn_accept._main, 'select');
	}
	else{
		addcss(this.btn_accept._main, 'select');

		var me = this;

		this.btn_accept._disabled(sPrimaryAccountGUEST === 1);
		this.btn_accept._onclick = async function(e){
			if (!this.cmenu || this.cmenu._destructed){
				e.stopPropagation();
				e.preventDefault();

				this.cmenu = await me._gui._create('cmenu','obj_context');
				await this.cmenu._fill([
					{title:'FORM_BUTTONS::ACCEPT', arg:[me,'_action',['accept']]},
					{title:'FORM_BUTTONS::DECLINE', arg:[me,'_action',['decline']]}
				]);

				this.cmenu._placeMenu(this._main, {mode:'bottom'});
			}
		};
	}

	if (aTmp.conference) {
		this.btn_join._onclick = async function() {
			await storage.library('wm_conference');
			wm_conference.get(aTmp.conference).join();
		};

		this._title(getLang('CHAT::ITM_NEW_CONFERENCE'));
	}
	else
		this._title(getLang('CHAT::ITM_NEW_EVENT'));

	this._main.querySelector('.infobar_ico').onclick = this._main.querySelector('.event_info').onclick = function(){
		Item.openwindow([this.__aData.aid, this.__aData.fid, WMItems.__clientID(this.__aData.EVNLINKID)], '', '', 'E', [function (bOK, aData) {
			this.__update(bOK, aData);
		}.bind(this)]);
	}.bind(this);

	//Participants
	if (parseInt(linkextras.EvnAcceptedParticipantCount)>0){
		this._main.querySelector('.event_attendees').innerText = getLang('IM::PARTICIPANTS::' + linkextras.EvnAcceptedParticipantCount, [linkextras.EvnAcceptedParticipantCount]);
	}
	else
		this._main.querySelector('.event_attendees').innerText = '';
};

_me._action = async function(name){

	this.btn_accept && this.btn_accept._disabled(true);

	var aItem = {aid:this.__aData.aid, fid:this.__aData.fid, iid:WMItems.__clientID(this.__aData.EVNLINKID)};

	switch(name){
		case 'decline':

			var frm = await this._gui._create('decline','frm_text','','frm_ok_cancel', [
					function(s){
						aItem.reason = s;
						WMItems.imip(aItem, name, []);
					}.bind(this)],
					'EVENT::REASON');

				frm._onclose = function(){
					if (this.btn_accept)
						this.btn_accept._disabled(false);
				}.bind(this);

				frm.x_btn_ok._value('FORM_BUTTONS::DECLINE');
		break;

		case 'accept':
			WMItems.imip(aItem, name, []);
	}
};


_me.__update = function (bOK) {

	if (bOK == true && !this._destructed){
		WMItems.list({aid:this.__aData.aid, fid:this.__aData.fid, iid:this.__aData.iid, values: obj_groupchat.aRequestArray},'','','',[function(aData){

			// refresh
			if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[this.__aData.iid])){
				this.__fill(aData);
				var meta;
				//Reactions
				if (!aData.META_REACTIONS && aData.EVN_METADATA){
					meta = parseURL(aData.EVN_METADATA);
					aData.META_REACTIONS = meta.core_reactions_data?parseURL(meta.core_reactions_data):{};
				}
				else
				if (aData.EVNLINKEXTRAS){
					var linkextras = parseURL(aData.EVNLINKEXTRAS);
					if (linkextras.Evn_MetaData){
						this.__aData.REAVALUE = linkextras.ReaValue || '';
						meta = parseURL(linkextras.Evn_MetaData);
						aData.REACTIONS = meta.core_reactions_data?parseURL(meta.core_reactions_data):{};
					}
				}

				this._init_toolbar(aData);
			}
			// delete
			else
				this._parent._remove(this._anchor, this.__aData.iid);

		}.bind(this)]);
	}
};
