_me = obj_groupchat.prototype;
function obj_groupchat(){};

obj_groupchat.aRequestArray = ['EVNNOTE','EVN_CREATED', 'EVN_MODIFIED', 'EVNSHARETYPE','EVNLINKEXTRAS','EVNURL','EVNTHUMBNAILID','EVNTHUMBNAILTIME','EVNPROCESSINGQUEUED', 'EVN_ID', 'EVNTHUMBNAILTICKET', 'EVNSIZEINFO', 'EVNMEETINGID', 'COMCOUNT', 'EVNFOLDER', 'TCOCFDR_ID', 'EVNLOCATION'];

/**
 * extend obj_list_load_reverse
 * bottom preloading list
 */
_me.__constructor = async function(){
	await storage.library('short_url');
	this.__observer;

	this.__options = {
		preload: 10,
		autoscroll: true,
		comments: true,
		notifyItem: [
			'I','W','R','S','Q','Z',
			'Y','M',
			'E','B','D','L','-'],
		notifyType: ['item','gw-queue','account'],
		searchType: 'gchat:main',
		layout: {600:'small'}
	};

	this.__aDataLink = {};

	this._getAnchor('loading').innerHTML = getLang('CHAT::LOADING');
	this._getAnchor('refresh').onclick = function(){
		if (this.__aRequestData.oldest || (this.__aRequestData.filter && this.__aRequestData.filter.until)){
			var aFilter = this.__aRequestData.filter?clone(this.__aRequestData.filter, true):{};
			delete aFilter.until;
			delete this.__aRequestData.filter;

			this._serverSort(this.__aRequestData.folder, true, aFilter);
		}
		else
			this._scroll(0);

	}.bind(this);

	this._getAnchor('unread_threads').onclick = function() {
		WMChat.readThread(this.__aRequestData.folder);
		gui.frm_main._selectView(this.__aRequestData.folder, 'unread_threads_view', {
			lasttime: this.__lasttime
		}, false, true);
		this.__lasttime = 0;
	}.bind(this);

	this._add_destructor('__destructor_groupchat');
};
	_me.__destructor_groupchat = function(){
		if (this.__aRequestData.folder){
			if (this.__aRequestData.folder.cid)
				WMChat.thread.remove(this);
			else
				WMChat.room.remove(this);
		}
	};

_me._search = function(s){
	if (Is.Defined(s)){
		var aFilter = this.__aRequestData.filter?clone(this.__aRequestData.filter, true):{};
		if (aFilter.search !== s){
			aFilter.search = s;
			this._serverSort(this.__aRequestData.folder, true, aFilter);
		}
	}
	else
		return this.__aRequestData.filter?this.__aRequestData.filter.search:'';
};


/*
	bUpdate		- not used
*/
_me._serverSort = async function(aFolder, bUpdate, aFilter){
	this.__aRequestData.uniq = unique_id();
	this.__lasttime = 0;
	var aRequestData;
	//Manual Get New
	if (((!aFolder && this.__aRequestData.folder) || compareObj(this.__aRequestData.folder, aFolder, true)) && (!Is.Object(aFilter) || (Is.Object(this.__aRequestData.filter) && !this.__aRequestData.filter.until && compareObj(this.__aRequestData.filter, aFilter, true)))) {
		if (this.__aRequestData.fetchnew)
			return;

		this.__aRequestData.fetchnew = true;
	}
	else{

		//Do not cls when pinned item (comments)
		if (!this.__pinned)
			await this._clear();

		//Registr thread
		if (aFolder.cid){
			if (this.__aRequestData.folder && !this.__aRequestData.folder.cid)
				WMChat.room.remove(this);

			WMChat.thread.add(this, aFolder.cid);
			WMChat.readThread(aFolder, aFolder.cid);
		}
		else{
			if (aFolder.fid){
				WMChat.readThread(aFolder);
				if (aFilter && aFilter.type)
					WMChat.room.remove(this, aFolder.fid);
				else
					WMChat.room.add(this, aFolder.fid);
			}

			if (this.__aRequestData.folder && this.__aRequestData.folder.cid)
				WMChat.thread.remove(this);
		}

		this.__aRequestData.folder = aFolder;
		this.__aRequestData.filter = aFilter;

		this.__options.autoscroll = true;
		this.__loading = 0;
	}

	if (!Object.keys(this.__aData).length) {
		removecss(this._main, 'unread_threads');
		aRequestData = clone(this.__aRequestData, true);
		await this.__renderSkeletons(this.__aRequestData.uniq);
		this.__aRequestData = aRequestData;
	}
	this._fetch(this.__aRequestData.uniq);

	if (((this.__aRequestData.filter || {}).type || this.__options.searchType) === 'gchat:main') {
		dataSet.add('folders', [this.__aRequestData.folder.aid, this.__aRequestData.folder.fid, 'RECENT'], 0);
	}
};

_me.__renderSkeletons = async function(uid) {
	var aData = {};
	aData[this.__aRequestData.folder.aid] = {};
	aData[this.__aRequestData.folder.aid][this.__aRequestData.folder.fid + (this.__aRequestData.folder.cid?'/'+this.__aRequestData.folder.cid:'')] = new Array(Math.floor(Math.random() * 3) + 3).fill().map(function() {
		return { EVNCLASS: 'I', skeleton: true, EVN_CREATED: Math.random() > 0.5 ? 0 : 100000, aid: this.__aRequestData.folder.aid, fid: this.__aRequestData.folder.fid };
	}, this);

	this.__skeletons = true;
	this._main.classList.add('skeletons');
	await this._response(aData, true, void 0, void 0, void 0, uid);
};

_me.__removeSkeletons = async function() {
	if (this._destructed || !this.__skeletons) {
		return;
	}
	this.__skeletons = false;
	this._main.classList.remove('skeletons');
	for(var i in this.__aData) {
		if (this.__aData[i].data.skeleton) {
			await this.__aData[i].obj._destruct();
			var anchor = this._getAnchor(this.__aData[i].anchor);
			anchor && anchor.parentElement.removeChild(anchor);
			delete this.__aData[i];
		}
	}
	this.__anim_last && this.__anim_last.parentElement.removeChild(this.__anim_last);
	this.__anim_last = null;
	this.__anim && this.__anim.parentElement.removeChild(this.__anim);
	this.__anim = null;
	this.__sep1 = {};
	this.__sep2 = {};
	this.__separators = this.__separators.filter(function(separator) {
		separator.parentElement.removeChild(separator);
	});
};

//load history (top)
_me._request = function(uid){
	if (this.__aRequestData.folder){

		this.__loading = 1;
		addcss(this._main, 'loading');

		//Build Search
		var aSearch = [];
		if (this.__aRequestData.oldest)
			aSearch.push('beforeid:'+ this.__aRequestData.oldest);
		else
		if (this.__aRequestData.filter && this.__aRequestData.filter.until){

			if (this.__aRequestData.filter.until !== '*0'){
				aSearch.push('untilid:' + WMItems.__serverID(this.__aRequestData.filter.until));
				aSearch.push('next:' + this.__options.preload);
			}

			//first request
			if (!this.__aRequestData.fetchnew)
				this.__aRequestData.fetchnew = true;
		}

		if (this.__aRequestData.filter && this.__aRequestData.filter.sys_search)
			aSearch.push(this.__aRequestData.filter.sys_search);

		if (this.__aRequestData.filter && this.__aRequestData.filter.search)
			aSearch.push(this.__aRequestData.filter.search);

		//Build Filter
		var aFilter = {
				sort: 'EVN_ID desc',
				limit: this.__options.preload,
				search: aSearch.join(' '),
				type: this.__aRequestData.filter && this.__aRequestData.filter.type?this.__aRequestData.filter.type:this.__options.searchType,
				lasttime: this.__aRequestData.filter && this.__aRequestData.filter.lasttime
			},
			bScroll = false;

		if (!this.__aRequestData.oldest){
			//send reset unread only on main room
			if (aFilter.type == this.__options.searchType && !this.__aRequestData.folder.cid)
				aFilter.reset_unread = 1;

			//scroll first request
			bScroll = true;
		}

		var aItemsInfo = {
			aid: this.__aRequestData.folder.aid,
			fid: this.__aRequestData.folder.fid + (this.__aRequestData.folder.cid?'/'+this.__aRequestData.folder.cid:''),
			values: obj_groupchat.aRequestArray,
			filter: aFilter
		};

		WMItems.list(aItemsInfo,'','','',[async function(aData){
			await this.__removeSkeletons();

			WMChat.restoreMessageQueue(this.__aRequestData.folder);

			this._response(aData, false, bScroll, false, false, uid);
		}.bind(this)]);
	}
};

//load recent (bottom)
_me._request2 = function(uid){
	if (this.__aRequestData.folder){

		this.__loading = this.__loading || 1;

		//Build Search
		var aSearch = [];
		if (this.__aRequestData.youngest)
			aSearch.push('afterid:' + this.__aRequestData.youngest);

		if (this.__aRequestData.filter && this.__aRequestData.filter.sys_search)
			aSearch.push(this.__aRequestData.filter.sys_search);

		if (this.__aRequestData.filter && this.__aRequestData.filter.search)
			aSearch.push(this.__aRequestData.filter.search);

		//Build Filter
		var aFilter = {
				sort: 'EVN_ID asc',
				limit: this.__options.preload,
				search: aSearch.join(' '),
				type: this.__aRequestData.filter && this.__aRequestData.filter.type?this.__aRequestData.filter.type:this.__options.searchType,
				lasttime: this.__aRequestData.filter && this.__aRequestData.filter.lasttime
			},
			bScroll = true;

		//send reset unread only on main room
		if (aFilter.type == this.__options.searchType && !this.__aRequestData.folder.cid)
			aFilter.reset_unread = 1;

		if (this.__aRequestData.filter && this.__aRequestData.filter.until)
			bScroll = false;

		var aItemsInfo = {
			aid:this.__aRequestData.folder.aid,
			fid:this.__aRequestData.folder.fid + (this.__aRequestData.folder.cid?'/'+this.__aRequestData.folder.cid:''),
			values: obj_groupchat.aRequestArray,
			filter:aFilter
		};

		this.__aRequestData.fetchnew = false;

		WMItems.list(aItemsInfo,'','','',[async function(aData){
			await this.__removeSkeletons();

			this._response(aData, true, bScroll, false, false, uid);
		}.bind(this)]);
	}
};

// bPinned [bool] pin item to the top, for comments purpose
_me._response = async function(aData, bUpdate, bScroll, bSkipTime, bPinned, uid){
	if (this._destructed || (uid && uid != this.__aRequestData.uniq))
		return;

	this.__rendering = true;
	this._getAnchor('main').style.setProperty('overflow', 'hidden', 'important');
	this.__initialLoad = !Object.keys(this.__aData || {}).length;

	if (this._main)
		removecss(this._main, 'loading');

	//error
	if (aData === false){
		if (this._onerror)
			this._onerror();
		return;
	}

	this.__threadsView = !!~['gchat:threads', 'gchat:unread_threads'].indexOf((this.__aRequestData.filter || {}).type || this.__options.searchType) || !!this.__aRequestData.folder.cid;

	if ((aData = aData[this.__aRequestData.folder.aid]) && (aData = aData[this.__aRequestData.folder.fid + (this.__aRequestData.folder.cid?'/'+this.__aRequestData.folder.cid:'')])){

		if (parseInt((aData['@'] || {}).LASTTIME)) {
			this.__lasttime = this.__lasttime || parseInt((aData['@'] || {}).LASTTIME);
		}
		if (!this.__aRequestData.folder.cid && parseInt((aData['@'] || {}).THREADUNREADCOUNT) > 0) {
			WMItems.list({
				aid: this.__aRequestData.folder.aid,
				fid: this.__aRequestData.folder.fid,
				values: obj_groupchat.aRequestArray,
				filter: {
					type: 'gchat:unread_thread_ids',
					lasttime: aData['@'].LASTTIME
				}
			}, '', '', '', [function(aData) {
				if ((aData = aData[this.__aRequestData.folder.aid]) && (aData = aData[this.__aRequestData.folder.fid])){
					delete aData['/'];
					delete aData['#'];
					delete aData['$'];
					delete aData['@'];

					for (var i in aData) {
						WMChat.setUnreadThread(this.__aRequestData.folder, i);
					}
				}
			}.bind(this)])
		}

		var bScrollDown = false;

		//Scroll to bottom?
		if (bScroll){
			var elm, n = this.__body.childNodes;
			if (n.length && (elm = n[n.length-1])){
				if (elm.offsetTop<this.__body.scrollTop + this.__body.clientHeight)
					bScrollDown = true;
				else
				if (this.__body.scrollTop+this.__body.scrollHeight == this.__body.clientHeight)
					bScrollDown = true;
			}
			else
				bScrollDown = true;
		}

		// _onresponse event
		if (this._onresponse)
			this._onresponse(aData);

		delete aData['/'];	//count
		delete aData['#'];
		delete aData['$'];
		delete aData['@'];

		var c = 0, last, iid;

		if (!this.__skeletons) {
			this.__last_read_id = parseInt(Folder.lastId(this.__aRequestData.folder), 16);
			this.__last_message_id = 0;

			// set until to highest ID
			if (this.__aRequestData.filter && this.__aRequestData.filter.until === '*0'){
				this.__aRequestData.filter.until = Object.keys(aData).sort().shift();
			}
			// set next ID into filter.until (unread messages)
			else{

				var	bNext = this.__aRequestData.filter && this.__aRequestData.filter.until && !this.__aRequestData.filter.highlight && parseInt(WMItems.__serverID(this.__aRequestData.filter.until), 16) === this.__last_read_id,
					tmp_id, evnid;

				for (iid in aData){
					evnid = parseInt(aData[iid].EVN_ID, 16);
					this.__last_message_id = Math.max(this.__last_message_id, evnid);

					//Select next message (unread messages)
					if (bNext){
						if (evnid<=this.__last_read_id){
							if (tmp_id)
								this.__aRequestData.filter.until = WMItems.__clientID(tmp_id || aData[iid].EVN_ID);

							bNext = false;
						}
						tmp_id = aData[iid].EVN_ID;
					}
				}

			}

			//Update LASTREADID (in ROOM only)
			if (!this.__aRequestData.folder.cid && (!this.__aRequestData.filter || !this.__aRequestData.filter.type) && this.__last_message_id>this.__last_read_id){
				Folder.lastId(this.__aRequestData.folder, this.__last_message_id.toString(16));
			}
		}

		var length = Object.keys(aData).length;
		if (!length && this.__aRequestData.filter && this.__aRequestData.filter.search) {
			this._placeholder('IM::SEARCH_NO_RESULTS');
			addcss(this._main, 'noitems');
		} else {
			removecss(this._main, 'noitems');
		}

		var offset = this.__body.scrollHeight - this.__body.clientHeight - this.__body.scrollTop;
		async function callback() {
			if (!bSkipTime && !this.__skeletons)
				this.__loading = (bUpdate || c >= this.__options.preload) ? 0 : 2;
	
			if (!bUpdate){
				if (this.__anim_last && this.__anim_last.parentNode)
					this.__anim_last.parentNode.removeChild(this.__anim_last);
	
				if (this.__sep1.sep){
					this.__anim_last = this._separator(this.__sep1.sep, bPinned ? 'pinned' : '', true);
					addcss(this.__anim_last,'last');
	
					if (this.__anim)
						this.__anim_last.style.top = this.__anim.style.top;
	
					this._main.appendChild(this.__anim_last);
				}
			}
	
			if (this.__sep1.sep && !this.__anim && last && this.__sep1.elm !== last.elm){
				this.__anim = this._separator(this.__sep1.sep, bPinned ? 'pinned' : '', true);
				this._main.appendChild(this.__anim);
			}
	
			if (this._oncount)
				this._oncount(c);

			// Fetch new response with search and possibility of recent items
			if (bUpdate) {
				if (c >= this.__options.preload)
					this.__aRequestData.fetchnew = true;

				if (!bScroll && !bPinned && !this.__skeletons){
					// switch back to normal behavior
					if (this.__aRequestData.filter && this.__aRequestData.filter.until){

						if (Object.keys(aData).length) {
							//scroll to until ID
							var tmp = this.__aData[this.__aRequestData.filter.until];
							if (tmp && tmp.anchor && (tmp = this._getAnchor(tmp.anchor))){
								if (tmp.offsetHeight>this.__body.clientHeight)
									this.__body.scrollTop = tmp.offsetTop + 30;
								else
									this.__body.scrollTop = tmp.offsetTop - this.__body.clientHeight/2 + tmp.offsetHeight/2;
							}

							addcss(this._main,'scrollbtn');
						}

						delete this.__aRequestData.filter.until;
						delete this.__aRequestData.filter.highlight;
					}
				}
			}

			var bRemoveNew = bUpdate;
			if (!bPinned && (!bUpdate || this.__aRequestData.fetchnew) && !this.__skeletons)
				bRemoveNew = !await this._fetch(uid);

			if (bRemoveNew && !c){
				window[this.__body.hasChildNodes()?'removecss':'addcss'](this._main,'noitems');
			}

			if (bRemoveNew && this._scroll() < 10){
				removecss(this._main, 'newitem', 'scrollbtn');
				this._getAnchor('refresh').innerHTML = getLang('COMMON::SCROLL_DN');
				this.__newitems = 0;
			}

			if (this.__options.autoscroll && bScrollDown) {
				this._scroll(offset);
			}

			this.__rendering = false;
			this._getAnchor('main').style.setProperty('overflow', '');
		};

		if (length) {
			for (iid in aData) {
				// if (this.__skeletons) {
					last = await this.__createItem(aData, iid, bUpdate, bPinned, bScrollDown, bScroll, bSkipTime, ++c, length, uid, callback.bind(this));
				// } else {
				// 	setTimeout(this.__createItem.bind(this, aData, iid, bUpdate, bPinned, bScrollDown, bScroll, bSkipTime, ++c, length, uid, callback.bind(this)), 5);
				// }
			}
		} else {
			await callback.call(this);
		}
	}
	//clear on error
	else if (!aData){
		await this._clear(true);

		if (this._oncount)
			this._oncount(0);
	}
};

_me.__createItem = async function(aData, iid, bUpdate, bPinned, bScrollDown, bScroll, bSkipTime, c, length, uid, callback) {
	if ((uid && uid != this.__aRequestData.uniq) || aData[iid].aid !== this.__aRequestData.folder.aid || aData[iid].fid !== ([this.__aRequestData.folder.fid, this.__aRequestData.folder.cid].filter(Boolean).join('/'))) {
		return;
	}

	var rowUpdate = bUpdate && obj_list_load.prototype._row.bind(this);

	if (this.__aData[iid]) {

		//update link preview
		if (this.__aData[iid].obj && this.__aData[iid].obj._type == "obj_groupchat_message" && !this.__aData[iid].obj.__src){
			if (aData[iid].EVNTHUMBNAILTICKET)
				this.__aData[iid].obj._preview_image(aData[iid].EVNTHUMBNAILTICKET, aData[iid].EVNSIZEINFO);
			else
			if (aData[iid].EVNTHUMBNAILID){
				var src = await Item.webdavURL([aData[iid].aid, aData[iid].fid, aData[iid].EVN_ID], aData[iid].EVNTHUMBNAILID) + '&t=' + (aData[iid].EVNTHUMBNAILTIME || 0);
				this.__aData[iid].obj._preview_image(src, aData[iid].EVNSIZEINFO);
			}
		}

		return callback && c === length && callback();
	}

	var scroll = false;
	if (!bScroll && !bUpdate) {
		scroll = [this.__body.scrollTop, this.__body.scrollHeight];
	}

	aData[iid].EVN_CREATED = parseInt(aData[iid].EVN_CREATED) || 0;

	//set iid if not exists (pinned item in comment)
	if (!aData[iid].iid) aData[iid].iid = iid;

	this.__aData[iid] = {data:aData[iid]};

	//Parse link extras of Private messages
	var linkextras = aData[iid].EVNLINKEXTRAS?parseURL(aData[iid].EVNLINKEXTRAS):{};

	if (/*linkextras.EvnLinkInvalid != '1' && */!(aData[iid].EVNLINKTYPE == 10 || aData[iid].EVNCLASS == 'L')) {
		//separator
		var sep, sepelm;
		if (this.__threadsView) {
			sep = IcewarpDate.unix(aData[iid].TCTLASTTIME || aData[iid].EVN_CREATED);
		} else {
			sep = IcewarpDate.unix(aData[iid].EVN_CREATED);
		}
		//New Messages

		if (!bUpdate && this.__last_read_id>0 && this.__last_message_id>this.__last_read_id && this.__last_read_id >= parseInt(aData[iid].EVN_ID, 16)){
			this._separator(getLang('CHAT::NEW_SEPARATOR'), 'unread' + (bPinned?' pinned':''));
			this.__last_read_id = 0;
		}

		if (bUpdate){
			if (!this.__sep2.sep || !sep.isSame(this.__sep2.sep, 'date')){
				sepelm = obj_list_load.prototype._separator.call(this, sep, bPinned ? 'pinned' : '');
				this.__sep2 = {sep:sep, elm: sepelm};
			}
		}
		else
		if (!this.__sep1.sep || !sep.isSame(this.__sep1.sep, 'date')){
			if (this.__sep1.sep)
				sepelm = this._separator(this.__sep1.sep, bPinned ? 'pinned' : '');

			if (!bPinned) {
				this.__sep1 = {sep:sep, elm: sepelm};
			}

			if (!this.__sep2.sep)
				this.__sep2 = {sep:sep, elm: sepelm};
		}


		var row = false,
			bGroup = false;

		if (!bUpdate){
			//Group only I (message)
			if (this.__sep1.row && aData[iid].EVNCLASS == 'I') {
				var tmpRow = this.__sep1.row;
				if (aData[iid].EVNCOMEVNID){
					if (aData[iid].EVNCOMEVNID == tmpRow.com){
						addcss(tmpRow.elm, 'group');

						if (!(tmpRow.group && tmpRow.email == aData[iid].EVNMODIFIEDOWNEREMAIL && tmpRow.email2 == linkextras.AccountEmail && tmpRow.time<aData[iid].EVN_CREATED+300))
							addcss(tmpRow.elm, 'nogroup');
					}
				}
				else
				if (tmpRow.com){
					if (tmpRow.com == aData[iid].EVN_ID)
						addcss(tmpRow.elm, 'group','nogroup');
				}
				else
				//Grouping History
				if (tmpRow.group && tmpRow.email == aData[iid].EVNMODIFIEDOWNEREMAIL && tmpRow.email2 == linkextras.AccountEmail && tmpRow.time<aData[iid].EVN_CREATED+300){
					addcss(tmpRow.elm, 'group');
				}
			}
		}

		var objOptions = {};
		if (this.__threadsView) {
			objOptions.fulldate = !objOptions.rdock;
			if (aData[iid].EVNCOMEVNID) {
				objOptions.followed_thread_comment = true;
			} else {
				objOptions.followed_thread_post = true;
			}
		}

		var className = '', cid;
		if (aData[iid].tmp) {
			className += 'tmp';
		}

		switch(aData[iid].EVNCLASS){
		case 'I':

			// WC-5516 TeamChat plugins slash command
			if (aData[iid].EVNNOTE && aData[iid].EVNNOTE.indexOf('/') === 0)
				return callback && c === length && callback();

			if (bUpdate){

				if (rowUpdate)
					row = rowUpdate('', this.__threadsView ? 'obj_threads_item' : '', iid);

				//Group only I (message)
				if (this.__sep2.row && aData[iid].EVNCLASS == 'I' && !this.__threadsView)
					if (aData[iid].EVNCOMEVNID){
						if (this.__sep2.row.com == aData[iid].EVNCOMEVNID){
							addcss(row.elm, 'group');

							if (!(this.__sep2.row.group && this.__sep2.row.email == aData[iid].EVNMODIFIEDOWNEREMAIL && this.__sep2.row.email2 == linkextras.AccountEmail && this.__sep2.row.time<aData[iid].EVN_CREATED+300))
								addcss(row.elm, 'nogroup');
						}
						else
						if (this.__sep2.row.id == aData[iid].EVNCOMEVNID)
							addcss(row.elm, 'group','nogroup');
					}
					else
					//Grouping Update
					if (!this.__sep2.row.com && this.__sep2.row.group  && this.__sep2.row.email == aData[iid].EVNMODIFIEDOWNEREMAIL && this.__sep2.row.email2 == linkextras.AccountEmail && this.__sep2.row.time>aData[iid].EVN_CREATED-300)
						addcss(row.elm, 'group');

			}
			else
				row = this._row('', this.__threadsView ? 'obj_threads_item' : '', iid);

			try{
				this.__aData[iid].obj = await this._create('mssg', 'obj_groupchat_message', row.anchor, className, aData[iid], '', objOptions);
			}
			catch(r){
				if (this.__aData[iid] && (!this.__aData[iid].obj || !this.__aData[iid].obj._destructed))
					throw r;
				return callback && c === length && callback();
			}

			//Do not group edited messages
			bGroup = this.__aData[iid].obj._cangroup && !this.__threadsView;

			break;

		case 'L':
		case 'R':
		case 'Z':
		case 'B':
		case 'Q':
		case 'S':
		case 'W':
		case 'D':
		case 'X':
		case 'Y':

			try{
				if (bUpdate){
					if (rowUpdate)
						row = rowUpdate('', this.__threadsView ? 'obj_threads_item' : '', iid);
				}
				else
					row = this._row('', this.__threadsView ? 'obj_threads_item' : '', iid);

				//Public PIN & Threads
				if (aData[iid].EVNLINKTYPE == 10 || aData[iid].EVNCLASS == 'L'){

					if (aData[iid].EVNCLASS == 'L')
						this.__aData[iid].obj = await this._create('pin', 'obj_groupchat_thread', row.anchor, className, aData[iid], '', objOptions);
					else
						this.__aData[iid].obj = await this._create('pin', 'obj_groupchat_pin', row.anchor, className, aData[iid], '', objOptions);

					if (aData[iid].EVNLINKEXTRAS){
						if (linkextras && linkextras.evnlinkid){
							cid = WMItems.__clientID(linkextras.evnlinkid);
							if (cid!= iid)
								if (this.__aDataLink[cid]){
									if (inArray(this.__aDataLink[cid], iid)<0)
										this.__aDataLink[cid].push(iid);
								}
								else
									this.__aDataLink[cid] = [iid];
						}
					}

				}
				else
					switch(aData[iid].EVNCLASS){
					case 'R':
					case 'Z':
						var lastRow = this.__getLastRow(!bUpdate);
						var merge = lastRow && this.__shouldMergeRows(aData[iid], lastRow.data);
						if (!this.__aRequestData.folder.cid && merge) {
							this.__aData[iid].data = [].concat(aData[iid], lastRow.data);
							this.__aData[iid].data.sort(function(a, b) {
								return a.EVN_ID < b.EVN_ID ? -1 : b.EVN_ID < a.EVN_ID;
							});
							aData[iid] = this.__aData[iid].data;
							await lastRow.obj._destruct();
							var anchor = this._getAnchor(lastRow.anchor);
							anchor && anchor.parentElement.removeChild(anchor);
						}

						if (this.__originalItem && iid !== (this.__originalItem || {}).iid && aData[iid].EVNLINKID === (this.__originalItem || {}).EVNLINKID) {
							var sUser = (aData[iid].EVNOWNERNAME || aData[iid].EVNOWNEREMAIL).escapeHTML();
							objOptions.body = getLang('CHAT::DOCUMENT_EDITED', ['<strong>' + sUser + '</strong>', '<b>' + aData[iid].EVNTITLE.escapeHTML() + '</b>']);
							className = (className || '') + ' document_edited';
							this.__aData[iid].obj = await this._create('info', 'obj_groupchat_info', row.anchor, className, aData[iid], '', objOptions);
							this.__aData[iid].obj._main.onclick = function() {
								this.__aData[this.__originalItem.iid].obj._open();
							}.bind(this);
							break;
						}

						if (bUpdate && merge) {
							this.__aData[iid].obj = this.__aData[lastRow.iid].obj = await this._create('file', 'obj_groupchat_file', row.anchor, className, aData[iid], '', objOptions);
							this.__aData[lastRow.iid].data = aData[iid];
						} else {
							this.__aData[iid].obj = await this._create('file', 'obj_groupchat_file', row.anchor, className, aData[iid], '', objOptions);
						}
						this.__aData[iid].iid = iid;

						if (Array.isArray(aData[iid])) {
							row.elm.setAttribute('rel', aData[iid][0].iid);
						}
						break;

					case 'Q':
						this.__aData[iid].obj = await this._create('event', 'obj_groupchat_event', row.anchor, className, aData[iid], '', objOptions);
						break;

					case 'S':
						this.__aData[iid].obj = await this._create('conference', 'obj_groupchat_conference', row.anchor, className, aData[iid], '', objOptions);
						break;

					case 'W':
						this.__aData[iid].obj = await this._create('invite', 'obj_groupchat_invite', row.anchor, className, aData[iid], '', objOptions);
						break;

					case 'X':
						this.__aData[iid].obj = await this._create('invite', 'obj_groupchat_deleted', row.anchor, className, aData[iid], '', objOptions);
						break;

					case 'Y':
						this.__aData[iid].obj = await this._create('message', 'obj_groupchat_mail', row.anchor, className, aData[iid], '', objOptions);
						break;
					}
			}
			catch(r){
				if (this.__aData[iid] && (!this.__aData[iid].obj || !this.__aData[iid].obj._destructed))
					throw r;
				return callback && c === length && callback();
			}
				//Link Item
			if (aData[iid].EVNLINKID){
					cid = WMItems.__clientID(aData[iid].EVNLINKID);
					if (cid!= iid)
						if (this.__aDataLink[cid]){
							if (inArray(this.__aDataLink[cid], iid)<0)
								this.__aDataLink[cid].push(iid);
						}
						else
							this.__aDataLink[cid] = [iid];
			}
		}

		if (row){

			if (bPinned){
				this.__pinned = row.elm;
				addcss(this.__pinned, 'pinned');
			}

			//Comment Item
			if (this.__options.comments && aData[iid].EVNCOMEVNID){

				cid = WMItems.__clientID(aData[iid].EVNCOMEVNID);

				if (this.__aDataLink[cid]){
					if (inArray(this.__aDataLink[cid], iid)<0)
						this.__aDataLink[cid].push(iid);
				}
				else
					this.__aDataLink[cid] = [iid];
			}


			this.__aData[iid].anchor = row.anchor;

			//Yellow bg for selected message
			if (this.__aRequestData.filter && this.__aRequestData.filter.until == iid && this.__aData[iid].obj)

				if (this.__aRequestData.filter.highlight){
					var box = this._getAnchor(row.anchor),
						func = function(e){
							e.target && removecss(e.target, 'selected');
						};

					box.addEventListener('animationend',func);
					box.addEventListener('webkitAnimationEnd',func);

					addcss(box, 'selected');
				}

			if (bUpdate)
				this.__sep2.row = {elm: row.elm, email: aData[iid].EVNMODIFIEDOWNEREMAIL, email2:linkextras.AccountEmail, time: aData[iid].EVN_CREATED, group: bGroup, com: aData[iid].EVNCOMEVNID, id:aData[iid].EVN_ID};
			else{
				this.__sep1.row = {elm: row.elm, email: aData[iid].EVNMODIFIEDOWNEREMAIL, email2:linkextras.AccountEmail, time: aData[iid].EVN_CREATED, group: bGroup, com: aData[iid].EVNCOMEVNID, id:aData[iid].EVN_ID};

				if (!this.__sep2.row)
					this.__sep2.row = clone(this.__sep1.row);
			}
		}
		if (this.__options.autoscroll || this.__initialLoad){
			if (bScrollDown)
				this._scroll(0);
			else
			if (scroll) {
				this.__body.scrollTop = scroll[0] + this.__body.scrollHeight - scroll[1];
			}
		}
	}

	if (!bSkipTime && !this.__skeletons){
		var real_id = WMItems.__serverID(iid);
		if (!this.__aRequestData.oldest || this.__aRequestData.oldest>real_id)
			this.__aRequestData.oldest = real_id;

		if (!this.__aRequestData.youngest || this.__aRequestData.youngest<real_id){
			if (this.__options.comments == false || (gui.frm_main.main.tabs.room && gui.frm_main.main.tabs.room._isActive)){
				this.__aRequestData.youngest = real_id;
			}
		}
	}

	if (this.__aData[iid].obj) {
		this.__aData[iid].obj.__initialLoad = this.__initialLoad;

		if (this.__observer && !this.__skeletons) {
			this.__observer.observe(this.__aData[iid].obj._main);
		}
	}

	callback && c === length && callback();

	return row;
};

_me.__getLastRow = function(bFirstRow) {
	var last_row;
	var aIds = Object.keys(this.__aData);
	aIds.sort(function(a, b) {
		return (a > b ? -1 : a < b) * (bFirstRow ? -1 : 1);
	});
	for(var i in aIds) {
		if (this.__aData[aIds[i]].obj && !this.__aData[aIds[i]].obj._destructed) {
			last_row = this.__aData[aIds[i]];
			break;
		}
	}
	return last_row;
};

_me.__shouldMergeRows = function(aData, aData2) {
	aData2 = Array.isArray(aData2) ? aData2[0] : aData2;
	return (!aData2.EVNNOTE || (aData.EVNNOTE == aData2.EVNNOTE)) && aData.EVNCLASS !== 'Z' && aData.EVNCLASS === aData2.EVNCLASS && aData.EVNOWN_ID === aData2.EVNOWN_ID && Item.imageSupport(aData.EVNTITLE) && Item.imageSupport(aData2.EVNTITLE) && Math.abs(aData.EVN_CREATED - aData2.EVN_CREATED) < 30 && !aData.attachment && !aData2.attachment;
};

_me._add_message = async function(arg){
	var id = arg.id || arg.iid;
	if (id){

		//Do Not use fast message in search mode
		//Do Not use fast message for links
		if ((this.__aRequestData.filter && this.__aRequestData.filter.search)){
		 	return;
		}

		var fcid = this.__aRequestData.folder.fid + (this.__aRequestData.folder.cid?'/' + this.__aRequestData.folder.cid:''),
			aData = mkArrayPath([this.__aRequestData.folder.aid, fcid, id]),
			tmp = aData[this.__aRequestData.folder.aid][fcid][id];

		tmp.aid = this.__aRequestData.folder.aid;
		tmp.fid = fcid;

		tmp.EVNCLASS = arg.EVNCLASS || 'I';
		tmp.EVN_ID = WMItems.__serverID(id);
		tmp.EVN_CREATED = arg.timestamp || (new IcewarpDate()).unix();
		tmp.EVNOWNEREMAIL = sPrimaryAccount;
		tmp.EVNMODIFIEDOWNEREMAIL = sPrimaryAccount;
		tmp.EVNMODIFIEDOWNERNAME = dataSet.get('main',['fullname']);
		tmp.EVNNOTE = arg.body;
		tmp.EVNLINKEXTRAS = arg.EVNLINKEXTRAS;
		tmp.EVN_METADATA = buildURL({core_linkinfo: buildURL({linkData: arg.linkData})});
		tmp.attachment = arg.attachment;
		tmp.tmp = arg.tmp;

		if (arg.url){
			tmp.EVNURL = arg.url;
			if (arg.desc)
				tmp.EVNLOCATION = arg.desc;
			if (arg.title)
				tmp.EVNTITLE = arg.title;
			if (arg.thumbnailimageid) {
				tmp.THUMBNAILIMAGEID = document.location.origin + '/.well-known/icewarp-imageproxy/' + arg.thumbnailimageid;
			}
		}

		if (arg.type == WMChat.const.LINK.VIDEO)
			tmp.CORE_LINKINFO = arg;

		if (arg.comevnid)
			tmp.EVNCOMEVNID = arg.comevnid;

		//Include mentions
		if (arg.mentions){
			if (!tmp.MENTIONS)
				tmp.MENTIONS = {};

			for (var email in arg.mentions)
				tmp.MENTIONS[unique_id()] = {values:{EMAIL:email, NAME:arg.mentions[email]}};
		}

		await this._response(aData, true, true, true);

		//Always scroll bottom
		if (this.__options.autoscroll)
			this.__body.scrollTop = this.__body.scrollHeight;
	}
};
/////////////////////

_me._onnotify = async function(aData){

	var cid = WMItems.__clientID(aData.ITEM || aData.iid || ''),
		arr = [cid], id, aOut, k, i;

	//traverse linked item
	if (cid && Is.Array(this.__aDataLink[cid]))
		arr = arr.concat(this.__aDataLink[cid]);

	if (aData['ITEM-TYPE'] == '-') {
		if (aData.TYPE == 'gw-queue') {
			if (aData.ACTION == 'add')
				aData.ACTION = 'update_preview';
		}
		else
		if (aData.ACTION === 'add' && aData.TYPE === 'gw-queue-failure') {
			//moved
		}
		else
		switch(aData.ACTION){
			case 'lock':
			case 'unlock':
			case 'comment':
			case 'follow':
			case 'unfollow':
			case 'delete':
				break;

			case 'unread_thread':
				if (this.__aRequestData.folder.cid) {
					break;
				}
				var unreadThreadsCount = aData.THREADS.length;
				if (unreadThreadsCount) {
					if (unreadThreadsCount > 99) {
						unreadThreadsCount = '99+';
					}
					this._getAnchor('unread_threads').textContent = getLang('CHAT::UNREAD_THREADS_COUNT', [unreadThreadsCount]);
					addcss(this._main, 'unread_threads');
				} else {
					removecss(this._main, 'unread_threads');
				}

				var thread = this.__aData[cid];
				if (thread) {
					if (~aData.THREADS.indexOf(aData.ITEM)) {
						addcss(thread.obj._main, 'unread');
					} else {
						removecss(thread.obj._main, 'unread');
					}
				}
				break;

			default:
				return;
		}
	}

	var bServerSort = false;

	for (i = 0; i<arr.length; i++){
		var iid = arr[i];

		switch(aData.ACTION){
			//Conference
		case 'stop':
			 	if (this.__aData[iid] && this.__aData[iid].obj)
			 		this.__aData[iid].obj._data(cid, '', '__stop');

			 	break;

			//Reactions (do update when no BODY)
		case 'reaction':
		case 'reaction-deleted':

			if ((aData.ACTION == 'reaction-deleted' && aData.BODY == '') || !Is.Defined(aData.BODY)) {
				return;
			}

			aOut = {
				NOTIFY_REACTIONS: aData.BODY,
				ACTION: aData.ACTION
			};

			//Update item if notification come from the same account, but different client (To update REAVALUE)
			if (!(aData.SERVICE && (aData['ORIGINATOR-EMAIL'] == sPrimaryAccount || aData['ORIGINATOR-EMAIL'] == dataSet.get('main', ['user']))) && aData['ORIGINATOR-DEVICEID'] !== dataSet.get('main', ['device_id']) && Is.Defined(aData.REAVALUE)){
				aOut.REAVALUE = aData.REAVALUE;
			}

			var parsedObjs = [];
			iid = aData.iid || iid;
			for (id in this.__aData) {
				if (!this.__aData[id].obj || this.__aData[id].obj._destructed || ~parsedObjs.indexOf(this.__aData[id].obj)) {
					continue;
				}
				if (Array.isArray(this.__aData[id].data)) {
					for (k in this.__aData[id].data) {
						if (this.__aData[id].data[k].iid === iid) {
							for(var j in aOut) {
								this.__aData[id].data[k][j] = aOut[j];
							}
							this.__aData[id].obj._init_toolbar();
							parsedObjs.push(this.__aData[id].obj);
							break;
						}
					}
				} else if (id === iid && this.__aData[id].anchor !== void 0) {
					this.__aData[iid].obj._data(cid, '', '_init_toolbar',[aOut]);
				} else if (WMItems.__serverID(iid) === this.__aData[id].data.COMMENT.EVN_ID) {
					this.__aData[id].obj.last_comment._data(void 0, '', '_init_toolbar',[aOut]);
				}
			}

			break;

		//Item
		case 'update_preview':
		case 'lock':
		case 'unlock':
		case 'update':
			if (aData.tmpId && this.__aData[aData.tmpId]) {
				this.__aData[iid] = this.__aData[aData.tmpId];
				delete this.__aData[aData.tmpId];
				this.__aData[iid].obj.__aData.iid = iid;
			}
			if (this.__aData[iid] && this.__aData[iid].obj && this.__aData[iid].obj.__update) {
				this.__aData[iid].obj._data(cid, '', '__update', [true]);
			}
			break;

		//Follow data update
		case 'follow':
		case 'unfollow':
			if (this.__aData[iid] && this.__aData[iid].obj)
				this.__aData[iid].obj._data(cid, {ISFOLLOWED:aData.ACTION == 'follow'?'1':'0'});
			break;

		//Update comments
		case "comment":
			if (!Is.Defined(aData.BODY)) {
				return;
			}

			iid = aData.iid || iid;
			for (id in this.__aData) {
				if (!this.__aData[id].obj || this.__aData[id].obj._destructed) {
					continue;
				}
				if (Array.isArray(this.__aData[id].data)) {
					for (k in this.__aData[id].data) {
						if (this.__aData[id].data[k].iid === iid) {
							this.__aData[id].data[k].META_COMMENTS = { count: aData.BODY };
							this.__aData[id].data[k].COMCOUNT = aData.BODY;
							this.__aData[id].obj._init_toolbar();
							if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
								WMChat.setUnreadThread(this.__aRequestData.folder, iid);
							}
							break;
						}
					}
				} else if (id === iid && this.__aData[id].anchor !== void 0) {
					this.__threadsView && !this.__aRequestData.folder.cid && this.__setLastcomment(iid);
					this.__aData[iid].obj._data(cid, {META_COMMENTS:{count:aData.BODY}, COMCOUNT: aData.BODY}, '_init_toolbar');
					if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
						WMChat.setUnreadThread(this.__aRequestData.folder, iid);
					}
				}
			}
			break;

		case 'add':
			if (!this.__aData[iid] && inArray(['E','M'], aData['ITEM-TYPE'])<0){

				//Filter comment out of main
				if (this.__aRequestData.folder.cid && (this.__aRequestData.folder.cid != aData.COMEVNID)) {
					return;
				}

				if (!this.__aRequestData.folder.cid && (aData.COMEVNID || aData['ITEM-TYPE'] === 'L')) {
					return;
				}

				if (aData.COMEVNID && (aData['ORIGINATOR-EMAIL'] === sPrimaryAccount && dataSet.get('main', ['device_id']) === aData['ORIGINATOR-DEVICEID'])) {
					return;
				}

				var bActive = this._parent._isActive !== false;

				if ((aData.SERVICE && this._scroll()>0) || !bActive){
					this.__newitems++;
					this._getAnchor('refresh').innerHTML = getLang(this.__newitems > 1 ? 'CHAT::NEW_MSGS' : 'CHAT::NEW_MSG', [this.__newitems]);
					addcss(this._main, 'newitem');
					this.__observer = this.__observer || new IntersectionObserver(function(IntersectionObserverEntries) {
						IntersectionObserverEntries.forEach(function(IntersectionObserverEntry) {
							if (!this.__observer || !IntersectionObserverEntry.isIntersecting) {
								return;
							}
							this.__observer.unobserve(IntersectionObserverEntry.target);
							if (this.__newitems--) {
								this._getAnchor('refresh').innerHTML = getLang(this.__newitems > 1 ? 'CHAT::NEW_MSGS' : 'CHAT::NEW_MSG', [this.__newitems]);
							} else {
								removecss(this._main, 'newitem');
								this.__observer.disconnect();
								this.__observer = null;
							}
						}, this);
					}.bind(this), {
						root: this._getAnchor('main'),
						threshold: 1.0
					});
				}

				if (bActive)
					bServerSort = true;
			}

			break;

		case 'delete':
			iid = aData.iid || iid;
			for (id in this.__aData) {
				var anchor = this._getAnchor(this.__aData[id].anchor);
				if (!this.__aData[id].obj || this.__aData[id].obj._destructed || !anchor) {
					continue;
				}
				if (Array.isArray(this.__aData[id].data)) {
					for (k in this.__aData[id].data) {
						if (this.__aData[id].data[k].iid === iid) {
							this.__aData[id].data.splice(k, 1);

							if (this.__aData[id].data.length) {
								await this.__aData[id].obj._destruct();
								this.__aData[id].obj = await this._create('file', 'obj_groupchat_file', this.__aData[id].anchor,'', this.__aData[id].data);
								anchor.setAttribute('rel', this.__aData[id].data[0].iid);
							} else {
								anchor.classList.remove('group');
								var anchorBelow = anchor.nextElementSibling;
								if (anchorBelow) {
									anchorBelow.classList.remove('group');
								}
								var data = this.__aData[iid].obj.__aData;
								await this._clean(this.__aData[id].anchor);
								data.EVNCLASS = 'X';
								data.EVNMODIFIEDOWNERNAME = dataSet.get('main', ['fullname']);
								data.EVNMODIFIEDOWNEREMAIL = sPrimaryAccount;
								this.__aData[iid].obj = await this._create('invite', 'obj_groupchat_deleted', this.__aData[iid].anchor, '', data);
							}
							break;
						}
					}
				} else if (id === iid && this.__aData[id].anchor !== void 0) {
					anchor.classList.remove('group');
					var anchorBelow = anchor.nextElementSibling;
					if (anchorBelow) {
						anchorBelow.classList.remove('group');
					}
					await this._clean(this.__aData[id].anchor);
					this.__aData[iid].data.EVNCLASS = 'X';
					this.__aData[iid].data.EVNMODIFIEDOWNERNAME = dataSet.get('main', ['fullname']);
					this.__aData[iid].data.EVNMODIFIEDOWNEREMAIL = sPrimaryAccount;
					this.__aData[iid].obj = await this._create('invite', 'obj_groupchat_deleted', this.__aData[id].anchor, '', this.__aData[iid].data);
				}
			}
			break;

			//Pinning
		case "add_pin":
			iid = aData.iid || iid;
			for (id in this.__aData) {
				if (!this.__aData[id].obj || this.__aData[id].obj._destructed) {
					continue;
				}
				if (Array.isArray(this.__aData[id].data)) {
					for (k in this.__aData[id].data) {
						if (this.__aData[id].data[k].iid === iid) {
							this.__aData[id].data[k].PINWHEN = true;
							this.__aData[id].obj._init_toolbar();
							break;
						}
					}
				} else if (id === iid && this.__aData[id].anchor !== void 0) {
					this.__aData[iid].obj._data(cid, {PINWHEN: true}, '_init_toolbar');
				}
			}
			break;

		case "add_global_pin":
			iid = aData.iid || iid;
			for (id in this.__aData) {
				if (!this.__aData[id].obj || this.__aData[id].obj._destructed) {
					continue;
				}
				if (Array.isArray(this.__aData[id].data)) {
					for (k in this.__aData[id].data) {
						if (this.__aData[id].data[k].iid === iid) {
							this.__aData[id].data[k].GPINWHEN = true;
							if (!aData.SERVICE) {
								this.__aData[id].data[i].GPINOWNEMAIL = sPrimaryAccount;
							}
							this.__aData[id].obj._init_toolbar();
							break;
						}
					}
				} else if (id === iid && this.__aData[id].anchor !== void 0) {
					aOut = { GPINWHEN: true };

					if (!aData.SERVICE) {
						aOut.GPINOWNEMAIL = sPrimaryAccount;
					}

					this.__aData[iid].obj._data(cid, aOut, '_init_toolbar');
				}
			}

			//Update for local event
			if (!aData.SERVICE)
				bServerSort = true;

			break;

		case "delete_pin":
			if (this.__aData[iid] && this.__aData[iid].obj && this.__aRequestData.filter && this.__aRequestData.filter.type == 'gchat:my_pins') {
				//remove item in pin view
				this._remove(this.__aData[iid].anchor, iid);
			} else {
				iid = aData.iid || iid;
				for (id in this.__aData) {
					if (!this.__aData[id].obj || this.__aData[id].obj._destructed) {
						continue;
					}
					if (Array.isArray(this.__aData[id].data)) {
						for (k in this.__aData[id].data) {
							if (this.__aData[id].data[i].iid === iid) {
								this.__aData[id].data[i].PINWHEN = false;
								this.__aData[id].obj._init_toolbar();
								break;
							}
						}
					} else if (id === iid && this.__aData[id].anchor !== void 0) {
						this.__aData[iid].obj._data(cid, {PINWHEN: false}, '_init_toolbar');
					}
				}
			}
			break;

		case "delete_global_pin":
			if (this.__aData[iid] && this.__aData[iid].obj && this.__aRequestData.filter && this.__aRequestData.filter.type == 'gchat:global_pins') {
				//remove item in pin view
				this._remove(this.__aData[iid].anchor, iid);
			} else {
				iid = aData.iid || iid;
				for (id in this.__aData) {
					if (!this.__aData[id].obj || this.__aData[id].obj._destructed) {
						continue;
					}
					if (Array.isArray(this.__aData[id].data)) {
						for (k in this.__aData[id].data) {
							if (this.__aData[id].data[k].iid === iid) {
								this.__aData[id].data[k].PINWHEN = false;
								this.__aData[id].obj._init_toolbar();
								break;
							}
						}
					} else if (id === iid && this.__aData[id].anchor !== void 0) {
						this.__aData[iid].obj._data(cid, {GPINWHEN: false, GPINOWNEMAIL: ''}, '_init_toolbar');
					}
				}
			}
			break;

		case 'tmp_message':
			if (this.__aRequestData.folder.cid && (this.__aRequestData.folder.cid != aData.COMEVNID)) {
				return;
			}

			if (!this.__aRequestData.folder.cid && (aData.COMEVNID || aData['ITEM-TYPE'] === 'L')) {
				return;
			}

			this._add_message(aData);
		}
	}

	if (bServerSort) {
		clearTimeout(this.__serverSortTimeout);
		this.__serverSortTimeout = setTimeout(function() {
			this._request2(this.__aRequestData.uniq);
		}.bind(this), 5);
	}
};

_me.__setLastcomment = function(iid) {
	var fid = this.__aRequestData.folder.fid + '/' + WMItems.__serverID(iid);
	WMItems.list({
		aid: this.__aRequestData.folder.aid,
		fid: fid,
		filter: { limit: 1, sort: 'EVN_ID desc' },
		values: obj_groupchat.aRequestArray
	}, '', '', '', [async function(aData) {
		if (!this.__aData[iid] || !this.__aData[iid].obj) {
			return;
		}
		aData = aData[this.__aRequestData.folder.aid][fid];
		for (var i in aData) {
			if (i.indexOf('*') === 0) {
				aData = aData[i];
				break;
			}
		}
		if (this.__threadsView && !this.__aRequestData.folder.cid) {
			await this.__moveItemToBottom(iid);
		}
		this.__aData[iid].obj._setLastComment(aData);
	}.bind(this)]);
};

_me.__moveItemToBottom = async function(iid) {
	if (!this.__aData[iid]) {
		return;
	}
	var data = {}, f = this.__aRequestData.folder;;
	data[f.aid] = {};
	data[f.aid][f.fid + (f.cid ? '/' + f.cid : '')] = {};
	data[f.aid][f.fid + (f.cid ? '/' + f.cid : '')][iid] = this.__aData[iid].data;
	this.__aData[iid].obj && this.__aData[iid].obj._destruct();
	delete this.__aData[iid];
	await this._response(data, true);
};

_me._onremove = function(iAnchor, sData_id, bFire){

	//Fire Remove Event
	if (bFire)
		this._fire(sData_id, 'delete');

	//remove from aDataLink
	if (this.__aDataLink && this.__aDataLink[sData_id])
		delete this.__aDataLink[sData_id];

	//remove from aData
	if (this.__aData && this.__aData[sData_id])
		delete this.__aData[sData_id];
};

_me._edit = function(id) {
	if (this.__aData[id] && this.__aData[id].obj && !this.__aData[id].obj._destructed && this.__aData[id].obj._edit){
		return this.__aData[id].obj._edit(true);
	}

	return false;
};

_me._ungroupNode = function(prev, elm){
	var id;
	if ((id = elm.getAttribute('rel')) && this.__aData[id] && this.__aData[id].obj && this.__aData[id].obj._ungroup){

		//force remove "group" for 1st comment
		var bForce = !prev || (!hascss(prev, 'group') && this.__aData[id].obj.__aData.EVNCOMEVNID);

		this.__aData[id].obj._ungroup(bForce);
	}
	else
		removecss(elm,'group');
};

/**
 * object handles context menu itself, creating event call to _oncontextEvent
 *
 * @param {*} e
 * @param {*} eTarget
 * @return {call} _oncontextEvent
 */
_me._oncontext = async function(e, eTarget, elm, id) {
	var i, cmenu;
	//Use system contextmenu on selections
	if (window.getSelection) {
		var sel = window.getSelection();
		if (!sel.isCollapsed && sel.rangeCount)
			for(i = 0; i<sel.rangeCount; i++){
				var range = sel.getRangeAt(i);
				if (!range.isCollapsed && Is.Child(range.commonAncestorContainer || range.startContainer, this._main)) {
					e.stopPropagation();
					return true;
				}
			}
	}

	if (eTarget.tagName == 'A'){
		if (eTarget.protocol === 'mailto:'){
			e.preventDefault();
			e.stopPropagation();

			var pos = getSize(eTarget);
			cmenu = await gui._create('cmenu', 'obj_context_link','','','', eTarget.pathname);
			cmenu._place(pos.x+pos.w,pos.y+(pos.h/2));

			return false;
		}

		//System menu for links
		e.stopPropagation();
		return true;
	}

	e.preventDefault();
	e.stopPropagation();

	elm = elm || Is.Child(eTarget, 'SECTION', this._main);

	if (!elm) {
		return this._oncontextEvent && this._oncontextEvent({type:'event', elm:eTarget, obj:this, e:e});
	}

	id = id || elm.getAttribute('rel');

	if (!id) { return; }

	var aData;
	for (i in this.__aData) {
		if (this.__aData[i].obj && !this.__aData[i].obj._destructed) {
			aData = (this.__aData[i].obj.__aDatas || [this.__aData[i].obj.__aData]).filter(function(data) {
				return data.iid === id;
			})[0];
			if (aData) {
				break;
			}
		}
	}

	if (!aData) {
		return;
	}

	//Traverse data for comment-source
	if (aData.EVNCOMEVNID && this.__aData[aData.iid].obj.item){
		if (Is.Child(eTarget,this.__aData[aData.iid].obj.item._main.parentElement, this._main)){
			elm = this.__aData[aData.iid].obj.item._main.parentElement;
			aData = this.__aData[aData.iid].obj.item.__aData;
		}
	}

	addcss(elm,'active2');

	var arr = [];
	if (this.__aData[id].data.attachment) {
		arr.push(
			{title: 'FORM_BUTTONS::REMOVE', css: 'color2', arg: [function() {
				this.__aData[id].obj.__aData.attachment.xhr.abort();
			}.bind(this)]}
		);
	} else {
		var linkextras = aData.EVNLINKEXTRAS ? parseURL(aData.EVNLINKEXTRAS) : {};
		if (Item.officeSupport(linkextras.EvnTitle)) {
			var iid = (aData.EVNLINKID.indexOf('*') === 0 ? '' : '*') + aData.EVNLINKID;
			var url = {};
			if (aData.url) {
				url = new URL(aData.url);
				url = parseURL(url.search);
			}

			var data = Object.assign({}, aData, url, {iid: iid});
			data = [{aid: aData.aid, fid: aData.fid, iid: iid, ticket: url.ticket, password: url.password}, [Item.downloadFile, [aData.aid, aData.fid, iid]], Path.extension(linkextras.EvnTitle)];

			var aArgAuto = [Item.officeOpen, data];
			var aArgWeb = [Item.officeOpen, data.concat['edit']];
			var aArgWebView = [Item.officeOpen, data.concat['view']];
			var aArgExt = [Item.officeOpen, data.concat['external']];
			var bIWD =  dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true';

			arr.push({
				title: 'POPUP_ITEMS::OPEN',
				arg: aArgAuto,
				'nodes': [
					{"title": 'DOCUMENT::OPENDOCUMENT', 'arg': aArgWeb, disabled: !bIWD},
					{"title": 'DOCUMENT::OPENDOCUMENTVIEW', 'arg': aArgWebView, disabled: !bIWD},
					{"title": 'OFFICELAUNCHER::OFFICESUITE', 'arg': aArgExt}
				]
			});

		}

		if(aData.EVNCLASS === 'R') {
			linkextras.EvnTicket && arr.push({
				title: 'POPUP_ITEMS::DOWNLOAD_FILE',
				arg: [function () {
					downloadItem(linkextras.EvnTicket, true);
				}]
			}, {
				title: 'ATTACHMENT::SAVE_TO_FOLDER',
				arg: [function() {
					ShortURL.resolve({
						url: linkextras.EvnTicket,
						callback: function(oURL, error) {
							if (error) {
								return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
							}
							var url = oURL ? oURL.url : linkextras.EvnTicket;

							gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', sPrimaryAccount, Mapping.getDefaultFolderForGWType('F'), [this, '_saveFolder', [[{ values: { description: linkextras.EvnTitle, size: this.__aData.EVNCOMPLETE, class: 'link', fullpath: url } }]]], true, false, 'F', 'i', true);
						}.bind(this),
						filename: linkextras.EvnTitle
					});
				}.bind(this)]
			}, {
				title: 'MAIN_MENU::SHARE',
				arg: [function () {
					this.__aData[id].obj._share(aData);
				}.bind(this)]
			});
		} else if (aData.EVNURL) {
			arr.push({
				title: 'POPUP_ITEMS::OPEN',
				arg: [function () {
					window.open(aData.EVNURL);
				}]
			});
		}

		if (arr.length)
			arr.push({title: '-'});

		var data = this.__aData[i].obj.__aDatas ? this.__aData[i].obj.__aDatas[0] : this.__aData[i].obj.__aData;
		arr.push({
			title: 'IM::QUOTE',
			arg: [function () {
				this._oncontextEvent && this._oncontextEvent({type:'quote', value:data.EVNNOTE});
			}.bind(this)],
			disabled: !data.EVNNOTE || !WMFolders.getAccess({aid: aData.aid, fid: aData.fid}, 'write')
		});

		if (aData.EVNCLASS != 'Q' && aData.iid &&  aData.EVNLINKTYPE!='10' && (aData.EVNCLASS != 'W' || aData.EVNLINKTYPE == '5')){
			arr.push({title:'FORM_BUTTONS::EDIT', arg:[function(){
				this._edit(data.iid);
			}.bind(this)], disabled: !(aData.EVNOWNEREMAIL == sPrimaryAccount || aData.EVNOWNEREMAIL == dataSet.get('main', ['user']) || WMFolders.getAccess({aid:aData.aid, fid:aData.fid},'modify'))});
		}

		arr.push(
			{title:'-'},
			{title:'FORM_BUTTONS::REMOVE', css:'color2', arg:[function(){
				WMItems.remove({aid:aData.aid, fid:aData.fid.replace('/' + WMItems.__serverID(aData.iid), ''), iid:[aData.iid]},'','','',[function(bOK){
					bOK && this._fire(aData.iid, 'delete');
				}.bind(this)]);
			}.bind(this)], disabled: !(aData.EVNOWNEREMAIL == sPrimaryAccount || aData.EVNOWNEREMAIL == dataSet.get('main', ['user']) || WMFolders.getAccess({aid:aData.aid, fid:aData.fid.replace('/' + WMItems.__serverID(aData.iid))},'remove'))}
		);
	}

	cmenu = await gui._create("cmenu","obj_context",'','');
	await cmenu._fill(arr);
	cmenu._place(e.clientX, e.clientY);

	cmenu._onclose = function(){
		removecss(elm,'active2');
	};
};