_me = obj_frame.prototype;
function obj_frame(){};
/**
 *
 **/
_me.__constructor = async function(){

	this._resize = false; //Content resizing

 	this.__eFrame = this._getAnchor('frame');

	//Allow Full Frame access
	this.__eFrame.setAttribute('allowfullscreen','true');

	this.__doc = this.__eFrame.contentDocument || this.__eFrame.contentWindow.document;

	// stops Esc because it cancel actual open http connection
	if (this.__eFrame.contentWindow.addEventListener)
		this.__eFrame.contentWindow.addEventListener("keydown", function(e){
			e = e || this.event;
			if (e.keyCode == 27) {
				e.preventDefault();
				e.stopPropagation();
			}
		},false);

	//important for Mozilla browser!
	this._write();
};
_me._sandbox = function(arr){
	this.__eFrame.setAttribute('sandbox', (arr || []).join(' '));
};
_me._src = function(sURL){
	this.__eFrame.src = sURL;
};

_me._write = function(html, headers){
	var me = this;

	html = mkElement('div', {
		innerHTML: html || ''
	});
	html.style.setProperty('height', 'auto', 'important');
	html.style.setProperty('overflow', 'hidden');

	while(this.__doc.head.firstElementChild) {
		this.__doc.head.removeChild(this.__doc.head.lastElementChild);
	}
	while(this.__doc.body.firstElementChild) {
		this.__doc.body.removeChild(this.__doc.body.lastElementChild);
	}
	this.__doc.head.appendChild(mkElement('meta', {
		'http-equiv': 'x-dns-prefetch-control',
		content: 'off'
	}, this.__doc));

	this.__doc.body.appendChild(html);

	if (Is.Array(headers)){
		for (var i in headers){
			for (var node in headers[i]){
				this.__doc.head.appendChild(mkElement(node,headers[i][node], this.__doc));
			}
		}
	}

	// window.onload will fire before images are fully loaded/displayed in Chrome, thus also onload on images
	if (html && navigator.userAgent.indexOf('WebKit')!=-1) {
		[].forEach.call(this.__doc.querySelectorAll('img'), function(img) {
			img.addEventListener('load', function(){ me._onresize(me.__doc) }, false);
		});
	}

	// Scroll
	if (this.__doc.body){
		this.__eFrame.onload = function(){
			if (this.contentDocument){
				//Reset scroll
				if (this.contentDocument.scrollingElement)
					this.contentDocument.scrollingElement.scrollTop = 0;

				//Listen
				this.contentDocument.addEventListener('scroll', function(e) {
					if (me._onscroll)
						me._onscroll(e, this.scrollingElement.scrollTop);
					me.__exeEvent('onscroll',e,{"value":this.scrollingElement.scrollTop,"owner":this});
				}, false);
			}
		};
	}

	this.__handlers();
};

_me.__handlers = function(){
	var me = this;

	// destruct contextmenus
	this.__doc.oncontextmenu = function(){
		if (gui.cmenu)
			gui.cmenu._destruct();
	};

	// document Events Forwarding
	function mouseEvn(e){

		var pos = getSize(me.__eFrame);

		var evt = new MouseEvent(e.type, {
			clientX: e.clientX + pos.x,
			clientY: e.clientY + pos.y,
			ctrlKey: e.ctrlKey,
			altKey: e.altKey,
			shiftKey: e.shiftKey,
			metaKey: e.metaKey,
			button: e.button
		});

		return me.__eFrame.dispatchEvent(evt);
	};

	this.__doc.onmousemove = mouseEvn;
	this.__doc.onmousedown = mouseEvn;
	this.__doc.onmouseup = mouseEvn;
	this.__doc.onclick = mouseEvn;
	this.__doc.onmouseover = mouseEvn;

	AttachEvent(this.__doc, "onwheel", function(e){
		if (me._onwheel)
			me._onwheel(e);
	});

	this.__eFrame.contentWindow.onresize = function (){
		if (me._resize && this.__width != me.__eFrame.offsetWidth){
			this.__width = me.__eFrame.offsetWidth;
			me._onresize();
		}
	};
};

_me._onresize = function(){
	var div = this.__doc.querySelector('div');
	if(!this._resize) {
		return;
	}

	this.__eFrame.style.height = (div ? div.offsetHeight + 40 : 0) + 'px';
};

_me._print = function(){
	this.__eFrame.contentWindow.focus();
	if (this.__eFrame.contentWindow.document.queryCommandSupported('print')) {
		this.__eFrame.contentWindow.document.execCommand('print', false, null);
	} else {
		this.__eFrame.contentWindow.print();
	}
};
