function obj_file(){}

obj_file.prototype.__constructor = async function(file){
	this.__file = file;

	var ext = getLang('CHAT::ITM_NEW_FILE');
	if (file.ext == 'pdf'){
		ext = 'pdf';
	} else if (Item.isDocument(file.name)){
		ext = 'doc';
	} else if (Item.isSpreadsheet(file.name)){
		ext = 'xls';
	} else if (Item.isPresentation(file.name)){
		ext = 'ppt';
	}

	await this._draw('obj_file', '', {
		ext: ext,
		title: this.__file.name,
		description: 'Lorem ipsum dolor sit amet'
	});

	this.progress._range(file.size);
	this._getAnchor('progress_text').textContent = 0 + ' / ' + parseFileSize(file.size);
	this._getAnchor('abort').onclick = function(event) {
		event.preventDefault();
		event.stopPropagation();
		if (this.__file.xhr && this.__file.xhr.readyState < 4) {
			this.__file.xhr.abort();
		}
	}.bind(this);

	this._main.onclick = function(event) {
		event.preventDefault();
		event.stopPropagation();
		if (this._onclick) {
			this._onclick();
		}
	}.bind(this);
};

obj_file.prototype._xhr = function(xhr){
	this.__file.xhr = xhr;

	//progress
	xhr.upload.addEventListener("progress", function(evn) {
		this._getAnchor('upload_info').removeAttribute('hidden', true);
		if (evn.lengthComputable){
			this._progress(evn.loaded);
		}
	}.bind(this), false);
	xhr.upload.addEventListener("load", function() {
		this._getAnchor('upload_info').setAttribute('hidden', true);
	}.bind(this), false);
	xhr.upload.addEventListener("abort", function() {
		this._destruct();
	}.bind(this), false);
	xhr.upload.addEventListener("error", function() {
		this._getAnchor('abort').setAttribute('hidden', true);
	}.bind(this), false);
};

obj_file.prototype._progress = function(iLoaded){
	if (iLoaded > this.__file.size) {
		iLoaded = this.__file.size;
	}
	this.progress._value(iLoaded);

	this._getAnchor('progress_text').textContent = parseFileSize(iLoaded) + ' / ' + parseFileSize(this.__file.size);
};