_me = obj_favorites.prototype;
function obj_favorites(){};

_me.__constructor = async function(){
	var me = this;
	this.__filter = '';

    this.__aData = [];
	this.__body = this._getAnchor('main');
	this.__norefresh = 0;

	this.search._onkeyup = function() {
		me._filter(me.search._value());
	};
	this.search._onsubmit = function(){};

	//CLICK ON FOLDER
	this.__body.onclick = function(e){
		var elm = e.target;

		if (elm.tagName == 'SPAN')
			elm = elm.parentNode;

		if (elm.tagName == 'DIV' && elm.id){

			var pos = getSize(elm),
				show_context_menu = false,
				clientX = pos.x;

			if (gui._rtl) {
				show_context_menu = e.clientX - pos.x < 30;
			} else {
				show_context_menu = pos.x+pos.w-e.clientX < 30;
				clientX += pos.w;
			}

			if (show_context_menu){
				this.oncontextmenu({
					target: elm,
					clientX: clientX,
					clientY: pos.y + (pos.h / 2)
				});

				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return;
			}

			var arg,
				id = elm.id.substr(me._pathName.length+1);

			if (!me.__aData[id] || !(arg = me.__aData[id].arg)) return;

			//Naposledy otevřený folder
			var aFolder = dataSet.get('active_folder');

			gui.__exeEvent('folderSelected', Object.assign({ftype:WMFolders.getType(arg)},arg));

			//Neotvíráme již otevřený folder?
			if (aFolder != arg['aid']+'/'+arg['fid'] && dataSet.get('folders',[arg.aid,arg.fid])){
				if (gui.frm_main.bar.folders){
					var sType = WMFolders.getType(arg);
					gui.frm_main.filter.__filter(sType, false, true, ~'NDF'.indexOf(sType) && 5, arg);
					gui.frm_main.bar.folders._setActive(arg['aid']+'/'+arg['fid'], true);
					me._fill();
				}
				gui.frm_main._selectView(arg);
			}
		}
	};

	this.__body.oncontextmenu = async function (e){
		var elm = e.target;

		if (elm.tagName == 'SPAN')
			elm = elm.parentNode;

		if (elm.tagName == 'DIV' && elm.id){
			var id = elm.id.substr(me._pathName.length+1),
				arg = me.__aData[id].arg,
				sFolType = WMFolders.getType(arg),
				aRights = WMFolders.getRights(arg);

			var aMenu = [];

			if (sFolType == 'M') {
				var ds = dataSet.get('folders',[arg['aid'],arg['fid']]);
				var aAccess = WMFolders.getAccess(arg);
				var empty_folder_enabled = ds.DEFAULT === 'H' || ds.SPAM === 'true' || GWOthers.getItem('RESTRICTIONS', 'DISABLE_EMPTY_FOLDER') != 1;
				var bVirtual = arg.fid.indexOf('__@@VIRTUAL@@__/') == 0;
				var bArchive = dataSet.get('folders', [arg.aid, arg.fid.split('/')[0], 'ARCHIVE'])

				if (ds.RSS){
					aMenu.push({
						title: '-'
					}, {
						title: 'POPUP_FOLDERS::CHANGE_CHANNEL',
						arg: {
							aid: arg.aid,
							fid: arg.fid,
							ftype: 'R',
							method: 'change_channel'
						},
						disabled: !aRights.modify,
						css: 'ico2 manage_rss'
					});
				} else {
					aMenu.push({
						title: 'POPUP_FOLDERS::ITEM_ACTIONS',
						css: 'ico2 manage',
						nodes: [{
							title: 'POPUP_FOLDERS::MARK_ALL_AS_READ',
							arg: {
								aid: arg.aid,
								fid: arg.fid,
								method: 'mark_all_as_read'
							},
							css: 'ico2 markread',
							disabled: !aAccess.modify
						}, { title: '-' }, {
							title: 'POPUP_ITEMS::COPY_MAIL_TO',
							arg: {
								aid: arg.aid,
								fid: arg.fid,
								method: 'copyall'
							},
							css: 'ico2 copy',
							disabled: bVirtual
						}, {
							title: 'POPUP_ITEMS::MOVE_MAIL_TO',
							arg: {
								aid: arg.aid,
								fid: arg.fid,
								method: 'moveall'
							},
							css: 'ico2 move',
							disabled: !aAccess.remove || bVirtual
						}, empty_folder_enabled && { title: '-' },
						empty_folder_enabled && {
							title: GWOthers.getItem('DEFAULT_FOLDERS','trash') === arg.aid + '/' + arg.fid ? 'MAIN_MENU::EMPTY_TRASH' : 'MAIN_MENU::EMPTY_FOLDER',
							arg: {
								aid: arg.aid,
								fid: arg.fid,
								method: 'empty_folder'
							},
							disabled: !aAccess.remove,
							css: 'ico2 color2 empty_folder'
						}].filter(Boolean)}
					);
				}
			}

			if (!bVirtual && sFolType !== 'I' && sFolType !== 'Y') {
				aMenu.push({
					title: 'POPUP_FOLDERS::ADD_FOLDER',
					arg: {
						aid: arg.aid,
						fid: arg.fid,
						method: 'add_folder'
					},
					css: 'ico2 add_folder',
					disabled: !aRights.write
				});
			}

			if (!sPrimaryAccountGUEST && sFolType === 'I') {
				aMenu.push({
					title: 'IM::SEND_MAIL_TO_ALL',
					arg: {
						aid: arg.aid,
						fid: arg.fid,
						method: 'sendEmailToAllMembers'
					}, css:'ico2 from_template'
				});
			}

			if (!bVirtual && sFolType !== 'I' && sFolType !== 'Y' && (GWOthers.getItem('RESTRICTIONS', 'disable_folder_sharing') == 0)) {
				aMenu.push({
					title: 'POPUP_FOLDERS::SHARING',
					arg: {
						aid: arg.aid,
						fid: arg.fid,
						method: 'share'
					},
					css: 'ico2 share_folder',
					disabled: (sFolType == 'M' && sPrimaryAccountProtocol != 'imap') || !aRights.owner || bArchive || !sPrimaryAccountSHARING
				});
			}

			if (aMenu.length) {
				aMenu.push({ title: '-' });
			}

			aMenu.push({
				title: 'FAVORITES::RENAME',
				arg: {
					aid: arg.aid,
					fid: arg.fid
				},
				handler: [me, '__rename'],
				keep: true,
				css: 'ico2 edit_folder'
			}, {
				title: 'FAVORITES::REMOVE',
				arg: {
					aid: arg.aid,
					fid: arg.fid
				},
				handler: [me, '__remove'],
				keep: true,
				css: 'ico2 remove_folder'
			});

			me.cmenu = await gui._create("cmenu","obj_context_folder",'','',me);
			await me.cmenu._fill(aMenu);
			me.cmenu._place(e.clientX,e.clientY);

		}

		e.preventDefault();
	};

	//Add destructor
	this._add_destructor('__disobey_ds');

	//Obey DataSets
	this._listen('cookies',['favorites']);

	dataSet.obey(this,'_listener1','folders',true);
	dataSet.obey(this,'_listener2','active_folder',true);

	//**** Drag and Drop ****
	this.__dndtimer = '';
	this.___lastdragover;
	this.__body.onmousedown = function(e){

		if (me.__dndtimer)
			window.clearTimeout(me.__dndtimer);

		if (e.button>1) return;
		var elm = e.target;

		if (elm.tagName == 'SPAN')
		    elm = elm.parentNode;

		if (elm == this || elm.tagName!='DIV' || !elm.id) return;

		//fire the event :)
		var id = elm.id.substring(me._pathName.length+1),
			x = e.clientX,
			y = e.clientY;
		me.__dndtimer = setTimeout(function(){
			me.__initdrag(id,x,y);
		}, 250);
	};

	this.__body.onmouseup = function(){
        //stop DnD
		if (me.__dndtimer)
			window.clearTimeout(me.__dndtimer);
	};

	//Registr "folder" drop
	if (gui.frm_main && gui.frm_main.dnd)
		gui.frm_main.dnd.registr_drop(this,['folder', 'favorite', 'virtual_folder', 'item']);

	if (gui.__dragging) {
		gui.frm_main.dnd.active_drop(1);
	}

	await this._create('scrollbar', 'obj_scrollbar');
	this.scrollbar._scrollbar(this._getAnchor('main'));

	this.add._onclick = function() {
		var dgw = (GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').split('');
		
		gui._create('frm_select_folder', 'frm_quick_select_folder', '', '', 'FAVORITES::ADD', '' , '', [function (aid, fid) {
			WMFolders.addToFavorites({ aid: aid, fid: fid });
		}], false, true, 'MCEFTNIY'.split('').filter(function(type) {
			return !~dgw.indexOf(type.toLowerCase());
		}));
	};
};

_me.__collapsed = function(bCollapse) {
	if (bCollapse === void 0) {
		return !!+Cookie.get(['favorites_collapsed']);
	}

	this._main.classList.toggle('collapsed', !!bCollapse);
	Cookie.set(['favorites_collapsed'], +bCollapse);
}

_me.__remove = function(x0,x1,x2,arg){
	WMFolders.removeFromFavorites(arg);
	this.cmenu && this.cmenu._destruct();
};

_me.__rename = async function(x0,x1,x2,arg){
	this.cmenu && await this.cmenu._destruct();
	var id;
	for(var i in this.__aData)
	    if (arg.aid == this.__aData[i].arg.aid && arg.fid == this.__aData[i].arg.fid){
			id = i;
			break;
		}

	if (typeof id != 'undefined'){
		var me = this,elm;

		//Add anchor
		this._anchors.edit = this._pathName+"/"+id;
		if ((elm = this._getAnchor('edit'))){
			elm.innerHTML = '';
			addcss(elm,'edit');
		}
		else
		 	return;

        this.__norefresh = 1;

		//Create Input
		await this._create('edit','obj_input','edit','obj_input_100');
		this.edit._value(this.__aData[id].title);
		this.edit._onsubmit = function (){
            me.__aData = dataSet.get(me._listener,me._listenerPath);
			var id = null;

			for(var i in me.__aData)
			    if (arg.aid == me.__aData[i].arg.aid && arg.fid == me.__aData[i].arg.fid){
					id = i;
					break;
				}

			if (id !== null){
                me.__aData[i].title = this._value();
				dataSet.add(me._listener,me._listenerPath,me.__aData,true);
			}

			this._destruct();
			me._anchors.edit = '';
			me.__norefresh = 0;

			dataSet.update(me._listener,me._listenerPath);
		};
		this.edit._onblur = function (){
			this._destruct();
			me._anchors.edit = '';
			me.__norefresh = 0;
			me.__update(me._listener,me._listenerPath);
		};
        this.edit._onclose = this.edit._onblur;
		this.edit._focus(true);
	}
};

_me.__disobey_ds = function(){
	dataSet.disobey(this,'_listener1','folders');
	dataSet.disobey(this,'_listener2','active_folder');
};

/**
 * aData = [{title:'Inbox',arg:{aid:'admin@merakdemo.com',fid:'INBOX'}}]
 **/
_me._fill = function(aData){
	// check data
	if (aData) {
		this.__aData = aData;
	}

	this.__body.innerHTML = '';

	if (!Is.Array(this.__aData) || !this.__aData.length) {
		return this._main.classList.add('is-empty');
	}

	this._main.classList.remove('is-empty');

	// get datasets
	var tmp1 = dataSet.get('folders'),
		tmp2 = dataSet.get('active_folder'),
		str  = '',
		sType,
		bOk  = true,
		aDFolders = GWOthers.get('DEFAULT_FOLDERS','storage')['VALUES'],
		sSpamFolder = dataSet.get('main', ['spam_path']),
		sArchivePath = dataSet.get('main', ['archive_path']),
		sFid;

	for (var i = 0; i < this.__aData.length; i++) {

		//check if folder exists in "folders" dataset
		if ((!this.__aData[i] || !this.__aData[i].arg || !tmp1[this.__aData[i].arg.aid] || !tmp1[this.__aData[i].arg.aid][this.__aData[i].arg.fid]) && (((this.__aData[i] || {}).arg || {}).fid !== '__@@UPLOAD@@__')) {
			this.__aData.splice(i,1);
			i--;
			bOk = false;
		} else {
			sType = WMFolders.getType(this.__aData[i].arg);

			if (sType == 'M'){

				//Archive Icons
				if (sArchivePath && (this.__aData[i].arg.aid+'/'+this.__aData[i].arg.fid).indexOf(sArchivePath+'/')==0) {
					sFid = (this.__aData[i].arg.aid+'/'+this.__aData[i].arg.fid).replace(sArchivePath+'/','');
				} else {
					sFid = this.__aData[i].arg.fid;
				}

				switch(this.__aData[i].arg.aid + '/' + sFid) {
					case sPrimaryAccount + '/INBOX':
						sType = 'inbox';
						break;
					case aDFolders.trash:
						sType = 'trash';
						break;
					case aDFolders.sent:
						sType = 'sent';
						break;
					case aDFolders.drafts:
						sType = 'drafts';
						break;
					case sSpamFolder:
						sType = 'spam';
						break;
					default:
						if (sPrimaryAccount == this.__aData[i].arg.aid && tmp1[this.__aData[i].arg.aid][this.__aData[i].arg.fid].RSS) {
							sType = 'R';
						}
				}
			} else if (sType == 'QL' && this.__aData[i].arg.aid == sPrimaryAccount){
				if (this.__aData[i].arg.fid == 'SPAM_QUEUE/Blacklist')
					sType = 'black';
				else
				if (this.__aData[i].arg.fid == 'SPAM_QUEUE/Whitelist')
					sType = 'white';
			}

			str += '<div id="'+this._pathName +'/'+ i +'" title="'+(this.__aData[i].arg.aid+'/'+this.__aData[i].arg.fid).escapeHTML().replace(/"/g, '&quot;') +'" class="folder folder_'+sType+(tmp2 == this.__aData[i].arg.aid+'/'+this.__aData[i].arg.fid?' active':'')+(tmp1[this.__aData[i].arg.aid][this.__aData[i].arg.fid].RECENT>0?' recent':'')+'">'+ this.__aData[i].title + ' '+ (tmp1[this.__aData[i].arg.aid][this.__aData[i].arg.fid].RECENT>0?'<span>'+tmp1[this.__aData[i].arg.aid][this.__aData[i].arg.fid].RECENT+'</span>':'') +'</div>';
		}
	}

	this.__body.innerHTML = str;

	//Save change to "favorites" dataset
	if (!bOk)
		dataSet.add(this._listener,this._listenerPath,this.__aData,'',this._pathName);
	
	this._filter();
};

_me._filter = function (sFilter) {
	if (sFilter !== void 0) {
		this.__filter = sFilter;
	}
	[].forEach.call(this.__body.querySelectorAll('.folder'), function(folder) {
		removecss(folder, 'hidden');
		if (this.__filter && (!~folder.textContent.indexOf(this.__filter) || !~folder.getAttribute('title').indexOf(this.__filter))) {
			addcss(folder, 'hidden');
		}
	}.bind(this));
};

_me.__update = function (sName){

	//refresh is prohibited during drag state
	if (this.__norefresh){
		this.__norefresh++;
		return;
	}

	if (this._listener == sName)
		this._fill(dataSet.get(this._listener,this._listenerPath));
	else
		this._fill();
};

//*** Drag and Drop - Create ***
_me.__initdrag = function(id,x,y){
	if (this.__aData[id])
		gui.frm_main.dnd.create_drag({
			type: 'favorite',
			value: [this.__aData[id].arg],
			x: x,
			y: y,
			obj: this
		});
};

//*** Drag and Drop - Catch ***
_me._active_dropzone = function(v){
	if (v)
		this.__norefresh = 1;
	else{
		this._ondragout();
		if (this.__norefresh>1){
		    this.__norefresh = 0;
		    this.__update(this._listener,this._listenerPath);
		}
		else
			this.__norefresh = 0;
	}
};


_me._ondragover = function(v){

 	if ((v.type == 'folder' || v.type == 'virtual_folder') && this.__aData.length>=this.__maxcount) return false;

    var iScroll = this.__body.scrollTop,
		aElm = this.__body.querySelectorAll('.folder'),
		size,tmp = '';

	for(var i = 0; i<aElm.length; i++){
		size = getSize(aElm[i]);

        if (v.y>=size.y-iScroll && v.y<=size.y+size.h-iScroll){
			tmp = (v.y - size.y) > (size.h/2)?'b':'t';

			if (this.___lastdragover && (this.___lastdragover != aElm[i] || this.___lastdragpos != tmp)){
				removecss(this.___lastdragover,v.type == 'item'?'dragover_active':'dragover_'+this.___lastdragpos);
				this.___lastdragpos = this.___lastdragover = null;
			}

			if (v.type == 'item'){
				var id = aElm[i].id.substring(this._pathName.length+1),
					fav_type = WMFolders.getType(this.__aData[id].arg);

				//check if exists, if not the same Folder
				if (!this.__aData[id] || (this.__aData[id].arg.aid == v.value[0].aid && this.__aData[id].arg.fid == v.value[0].fid) || ((fav_type == 'M' || fav_type == 'QL') && WMFolders.getType(v.value[0]) != 'M'))
                    return false;
			}

			if (!this.___lastdragpos){

				if (tmp == 'b' && aElm.length-1>i){
					this.___lastdragover = aElm[i+1];
					this.___lastdragpos = 't';
				}
				else{
					this.___lastdragover = aElm[i];
					this.___lastdragpos = tmp;
				}

				addcss(this.___lastdragover, v.type == 'item'?'dragover_active':'dragover_' + this.___lastdragpos);
			}

			return true;
		}
	}

	if (this.___lastdragover){
        removecss(this.___lastdragover,'dragover_active');
		this.___lastdragover = '';
		this.___lastdragpos = '';
	}

    return false;
};

_me._ondragout = function(){
	if (this.___lastdragover)
		removecss(this.___lastdragover,'dragover_'+this.___lastdragpos,'dragover_active');

	this.___lastdragover = null;
	this.___lastdragpos = null;
};

_me._ondrop = function(v){
	var i, id;
	//item
	if (v.type == 'item'){
		if (this.___lastdragover){
			id = this.___lastdragover.id.substr(this._pathName.length+1);
			if (this.__aData[id]){
				var iids = [];
				for (i in v.value){
					iids.push(v.value[i].iid)
				}
				Item.__convertToFolder(this.__aData[id].arg.aid, this.__aData[id].arg.fid, v, gui.frm_main.main.list, gui.frm_main.main.list && gui.frm_main.main.list.__getNext(iids));
				this._parent._destruct();
				return;
			}
		}
	}
	//folder, virtual
	else
	if (v.type == 'favorite' || v.type == 'folder' || v.type == 'virtual_folder') {

	 	var tmp,src_id;
		for(i = 0; i<this.__aData.length;i++)
			if (this.__aData[i].arg.aid == v.value[0].aid && this.__aData[i].arg.fid == v.value[0].fid)
				if (v.type == 'folder' || v.type == 'virtual_folder')
				    return
				else{
					src_id = i;
					break;
				}

		var aData = clone(this.__aData,1);
		tmp = {title:dataSet.get('folders',[v.value[0].aid, v.value[0].fid, 'NAME']) || Path.basename(v.value[0].fid),arg:v.value[0]};
		if (this.___lastdragover){
			id = this.___lastdragover.id.substr(this._pathName.length+1);

			if (this.___lastdragpos == 'b')
			    id++;

			if (v.type == 'favorite'){
				tmp = aData.splice(src_id,1)[0];
				if (id>src_id)
				    id--;
				else
				if (id==src_id)
				    return;
			}

	        aData.splice(id,0,tmp);
		}
		else
		if (typeof src_id == 'undefined')
			aData.push(tmp);

		//only if successfull drop
		this.__norefresh = 0;
		dataSet.add(this._listener,this._listenerPath,aData);
	}
};