/***
	SIZE AWARE Small Mode View
	14.3.2013

	@aParams:
		rows (int)		- row height multiplicator
		size (int)		- switch trashold
		sort (str)		- column name
		sorttype (str)	- asc | desc
***/
_me = obj_datagrid_small.prototype;
function obj_datagrid_small(){};

_me.__constructor = async function(){
	this.__small = false;
	this.__oldSmall = false;
	this.__smallOptions = null;
};

_me._small = async function (aParams){
	if (!aParams){
		//Remove resize handler
		if (this.__smallOptions != null){
			this._disobeyEvent('onsize',[this, '_onsize']);

			// var eFrame = this._main.getElementsByTagName('iframe')[0];
			// 	eFrame.parentNode.removeChild(eFrame);
		}


		this.__smallOptions = null;

		this._smallfilter = '';

		if (this.sort)
			await this.sort._destruct();
		if (this.filter)
			await this.filter._destruct();
	}
	else{
		var me = this;

		//Add resize handler
		if (this.__smallOptions == null){

			this._obeyEvent('onsize',[this, '_onsize']);
			/*
			var eFrame = mkElement('iframe',{seamless:'seamless', frameborder:0,name:this._pathName + "#frame", marginheight:0, marginwidth:0, src:"", id: this._pathName + '#frame'});

			this._main.appendChild(eFrame);

			eFrame.contentWindow.onresize = function (e){
				if (this.__width != eFrame.offsetWidth){
					this.__width = eFrame.offsetWidth;

					if (me._onsize && me.__smallOptions!=null) {
						me._onsize(true);

						// When size of datagrid is changed from 'small' to 'all', update headers in 'all' view to reflect current sort column and order
						if (!me.__small){
							me.__refreshHeaders();
						}
					}
				}
			};
			*/

		}

		if (aParams.filters) {
			this.filter || await this._create('filter', 'obj_hmenu', 'filter', 'filter');
			this._getAnchor('small_header') && this._getAnchor('small_header').classList.remove('no-filter');
		} else {
			this.filter && await this.filter._destruct();
			this._getAnchor('small_header') && this._getAnchor('small_header').classList.add('no-filter');
		}

		if (aParams.sorting && !this.sort){
			await this._create('sort', 'obj_hmenu', 'sort', 'sort');
			this.sort._onclick = function(a, b, c, arg) {
				switch (arg) {
					case 'asc':
					case 'desc':
						this.__dir = arg;
						break;
					default: 
						this.__sort = arg;
						this.__dir = me._aCols[arg].arg.sort;
				}
				Cookie.set(['views', me._aFolder.aid, me._aFolder.fid, 'sort'], {
					column: this.__sort,
					type: this.__dir
				});
				me._serverSort && me._serverSort('', this.__sort, this.__dir);
				me.__fillSort();
			};
		}

		if (!this.compact){
			await this._create('compact', 'obj_hmenu', 'compact', 'compact');
			this.compact._onclick = function(a, b, c, arg) {
				GWOthers.setItem('LAYOUT_SETTINGS', 'compact_view', arg);
				GWOthers.save([function() {
					gui.frm_main._changeViewSize(arg);
				}]);
				me.__fillCompact();
			};
		}

		this.__smallOptions = aParams;
		this.__smallOptions.size = this.__smallOptions.size || 500;
	}

	this._onsize();
};

_me.__fillCompact = async function() {
	await this.compact._fill([{
		title: GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') != 0 ? 'SETTINGS::COMPACT' : 'SETTINGS::DEFAULT',
		nodetype: 'click',
		css: 'ico compact',
		callback: [function() {
			return [{
				arg: 1,
				title: 'SETTINGS::COMPACT_LAYOUT',
				css: 'ico2' + (GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') != 0 ? ' check' : '')
			},
			{
				arg: "0",
				title: 'SETTINGS::DEFAULT_LAYOUT',
				css: 'ico2' + (GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') == 0 ? ' check' : '')
			}];
		}]
	}], 'static');
};

_me.__fillSort = async function() {
	if (!this._aCols || !this.sort){
		return;
	}
	var sortLabel;

	var sort = this.sort.__sort = this.sort.__sort || this.__sortColumn;
	this.sort.__dir = this.sort.__dir || (this.__sortType ? 'desc' : 'asc');
	
	if (!sort) {
		for (var i in this._aCols) {
			if (this._aCols[i].arg && this._aCols[i].arg.sort) {
				sort = this.sort.__sort = this.__sortColumn = i;
				this.sort.__dir = this.__sortType = this._aCols[i].arg.sort;
				break;
			}
		}
	}

	var sorts = [];
	for (var i in this._aCols) {
		if (this._aCols[i].arg && this._aCols[i].arg.sort && this._aCols[i]['display'] && this._aCols[i].title) {
			var title = this._aCols[i].title === 'DATAGRID_ITEMS_VIEW::ITMCLASSIFYAS' ? 'DATAGRID_ITEMS_VIEW::NAME' : this._aCols[i].title;
			sorts.push({
				title: title,
				arg: i,
				css: 'ico2' + (sort === i ? ' check' : '')
			});
			if(sort === i) {
				sortLabel = title;
			}
		}
	}
	if (sort === 'DATE' && this._aFolder.fid === '__@@SNOOZED@@__') {
		sort = 'DATE_SNOOZED'
	}
	var asc = 'SORT::' + sort + '_ASC';
	var desc = 'SORT::' + sort + '_DESC';
	if('{' + asc + '}' === getLang(asc) || !getLang(asc)) {
		asc = 'SORT::ASC';
	}
	if('{' + desc + '}' === getLang(desc) || !getLang(desc)) {
		desc = 'SORT::DESC';
	}

	var ascOption = {
		arg: 'asc',
		title: asc,
		css: 'ico2' + (this.sort.__dir === 'asc' ? ' check' : '')
	};
	var descOption = {
		arg: 'desc',
		title: desc,
		css: 'ico2' + (this.sort.__dir === 'desc' ? ' check' : '')
	};

	await this.sort._fill([{
		title: sortLabel,
		nodetype: 'click',
		css: 'ico sort' + (this.sort.__dir === 'desc' ? ' desc' : ''),
		callback: [function() {
			var descFirst = this._aCols[this.__sortColumn].arg.sort === 'desc';

			return sorts.concat([
				{ title: '-' },
				descFirst ? descOption : false,
				ascOption,
				!descFirst ? descOption : false
			].filter(Boolean));
		}.bind(this)]
	}], 'static');
};

_me.__fillFilter = async function() {
	if (!(this.__smallOptions || {}).filters || !this.filter){
		return;
	}

	await this.filter._fill([{
		title: this.__smallOptions.filters.filter(function(filter) {
			return filter.search === (this._smallfilter || '');
		}, this)[0].text,
		nodetype: 'click',
		callback: [function() {
			return this.__smallOptions.filters.map(function(filter) {
				return {
					title: filter.text,
					arg: [filter.search],
					css: 'ico2' + (filter.search === (this._smallfilter || '') ? ' check' : '')
				};
			}.bind(this));
		}.bind(this)]
	}], 'static');
	this.filter._onclick = function(e, elm, id, args) {
		this._onfilterchange(args[0]);
		this.__fillFilter();
	}.bind(this);
};

_me._onfilterchange = function (sValue) {
	this._smallfilter = sValue;

	//Save to Cookie
	if (this._cookiesEnabled){
		var aFolder = this._getFolder();
		Cookie.set(['views',aFolder['aid'],aFolder['fid'],'filter'], this._smallfilter);
	}
	this._serverSort(void 0, void 0, void 0, void 0, void 0, true);
};

_me._onsize = function(e){

	if (this.__smallOptions == null)
		return;

	var bRefresh = !!e;

	if (bRefresh && !this.__small)
		this.__refreshHeaders();

	var cb = false;
	var me = this;

	var width = this._main.offsetWidth;

	if (width<=this.__smallOptions.size && !this.__small)
		this.__small = true;
	else
	if (width>this.__smallOptions.size && this.__small)
		this.__small = false;
	else
		bRefresh = false;

	var compact = +GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') != 0;
	if (this.__small){
		cb = function() {
			me._main && addcss(me._main,'small');
		};
		this._row_height = 28 * (compact ? 1 : 2);

		if (this.__globalSearch && !compact) {
			this._row_height = 68;
		}
	}
	else{
		cb = function() {
			me._main && removecss(me._main,'small');
		};
		this._row_height = 28 * (compact ? 1 : 1.5);
	}

	if (bRefresh){
		this.__oldSmall = this.__small;
		//clear limit
		this.__limit = [0,0];
		//refresh
		if (this._serverSort)
			this._serverSort(void 0, void 0, void 0, cb ? [cb] : void 0);
		else {
			this._fill();
			cb && cb();
		}
	} else if(this.__oldSmall !== this.__small) {
		this.__oldSmall = this.__small;
		cb && cb();
	}
};
