_me = obj_datagrid_core.prototype;
function obj_datagrid_core(){};

_me.__constructor = async function(){
	var me = this;

	this._telemetry = 'off';

	this._main.parentNode.style.overflow = 'hidden';

	//sort vars
	this.__sortColumn;
	this.__sortType;

	this._aData;
	this._aCols;

	this._cookiesEnabled = false;

	//search
	this._SQLfilter = '';
	this._SQLfilter_last = '';
	this._SQLfulltext = '';
	this._SQLfulltext_last = '';

	this.__active = [];
	this.__value = [];
	this.__valueData = {};

	this.__cursor;

	//Drag Drop
	this.__dragtype = '';
	this.__dndtimer = '';

	//anchors
	this.__eHeader	= this._getAnchor('header');
	this.__eBody	= this._getAnchor('body');
	this.__eContainer1 = this._getAnchor('container1');
	this.__eContainer2 = this._getAnchor('container2');
	this.__separators = {};

	this._row_height = 40;
	this._separator_height = 38;
	this.__rowOffset = {};

	this._scrollbar(this.__eContainer2, void 0, void 0, void 0, void 0, true);

	//*** RESIZE
	this.__move_timeout;
	this.__eHeader.onmousedown = function(e){
		var elm = e.target;

		if (e.button == 2 || elm == this) return true;

		if (elm.tagName == 'DIV' || elm.tagName == 'P'){
			var id = me.__getId(elm.id || elm.parentNode.id,'#');

			if (!id || !(id = id[0]))
				return;

			// move column
			if (elm.tagName == 'DIV'){
				if (me.__move_timeout)
					window.clearTimeout(me.__move_timeout);

				if (elm.parentNode.classList.contains('static')) {
					return;
				}
				me.__move_timeout = window.setTimeout(function() {
					!me._destructed && me.__move(id, e.clientX);
				}, 400);
			}
			// resize
			else{
				elm = elm.parentNode;
				if (me._onresize) me._onresize(e,elm,id,me._aCols[id].arg);
				me.__exeEvent('onresize',e,{"arg":me._aCols[id].arg,"id":id,"elm":elm,"owner":me});
			}
		}
	};
	this.__eHeader.onmouseup = function(){
		if (me.__move_timeout){
			window.clearTimeout(me.__move_timeout);
			me.__move_timeout = null;
		}
	};

	// Click on header to sort by that column data (or reverse sort if the column is previously selected)
	this.__eHeader.onclick = function(e){
		var elm = e.target;

		if (elm.tagName == 'P' || elm == this)
			return false;

		// clear Move or skip sorting
		if (me.__move_timeout) window.clearTimeout(me.__move_timeout);

		// vraci to blby ID kdyz se klikne mimo!
		elm = elm.id?elm:elm.parentNode;

		var id = elm.id;

		if (elm.tagName != 'DIV' || !id || !(id = me.__getId(id,'#')) || !(id = id[0])) return;

		//if (!me._aFolder && !me._listener) return;

		var arg = me._aCols[id].arg;
		if (!arg || (!arg.sort && !arg.search)) return;

		if (arg.search) {
			if (me._smallfilter === arg.search) {
				me._smallfilter = '';
				removecss(elm,'active');
			} else {
				me._smallfilter = arg.search;
				addcss(elm,'active');
			}
			id = me.__sortColumn;
		} else {
			if (me.__sortColumn==null)
				me.__sortType = arg.sort=='desc'?1:0;
			else
			if (me.__sortColumn!=id){
				var tmp;
				if((tmp = me.__getElement([me.__sortColumn],'#')))
					removecss(tmp,'desc','asc');

				tmp = null;
				me.__sortType = arg.sort=='desc'?1:0;
			}
			else{
				removecss(elm,'desc','asc');
				me.__sortType = me.__sortType?0:1;
			}

			addcss(elm,me.__sortType?'desc':'asc');
		}

		me._serverSort('',id,me.__sortType?'desc':'asc',false, false, true);

		if (!arg.search) {
			if (me._onsort) me._onsort(e,elm,id,arg,(me.__sortType?'desc':'asc'));
			me.__exeEvent('onsort',e,{"arg":arg,"id":id,"type":(me.__sortType?'desc':'asc'),"elm":elm,"owner":me});
		}

		//Telemetry reporting
		if (gui.telemetry)
			gui.telemetry._add({id:elm.id, type:me._type});
	};

	this.__eContainer2.onmouseover = this.__eContainer2.onmouseout = function(e) {
		var elm = e.target;

		var id, arg = {};

		if (me._getFolder) {
			arg = me._getFolder();
		}

		if(elm.tagName=='DIV' && !elm.id && elm.parentNode.id) {
			elm = elm.parentNode;
		}

		if (elm.tagName != 'DIV' && elm!=this) {
			elm = Is.Child(elm,'DIV');
		}

		if (elm && elm.tagName == 'DIV' && elm.id && (id = me.__getId(elm.id))){
			if (id[0]){
				if (id[1] && me._aData[id[0]] && me._aData[id[0]].arg) {
					arg = objConcat(arg,me._aData[id[0]].arg);
				}

				if (id[1]) {
					me['_on' + e.type] && me['_on' + e.type].call(me, e, elm, arg, id[0], id[1]);

					if (e.type === 'mouseover') {
						if (me.__highlightHover) {
							me.__highlightHover.style.display = 'block';
							me.__highlightHover.style.top = document.getElementById(me._pathName + '/' + encodeURIComponent(id[0]) + '/' + id[1]).style.top;
						}

						[].forEach.call(me._main.querySelectorAll('.hover'), function(el) {
							el.classList.remove('hover');
						});
					
						for(var j in me._aCols) {
							var el = me.__getElement([id[0], j]);
							el && addcss(el, 'hover');
						}
					} else  if (e.type === 'mouseout') {
						if (me.__highlightHover) {
							me.__highlightHover.style.display = 'none';
						}
						[].forEach.call(me._main.querySelectorAll('.hover'), function(el) {
							el.classList.remove('hover');
						});
					}
				}
			}
		} else if (me.__highlightHover) {
			me.__highlightHover.style.display = 'none';
		}
	}

	this.__eContainer2.onclick = async function(e){
		var elm = e.target;

		//stop DnD
		if (me.__dndtimer)
			window.clearTimeout(me.__dndtimer);

		var id, arg = {};

		if (me._getFolder)
			arg = me._getFolder();

		if(elm.tagName=='DIV' && !elm.id && elm.parentNode.id)
			elm = elm.parentNode;

		if (elm.tagName != 'DIV' && elm!=this)
			elm = Is.Child(elm,'DIV');

		if (elm && elm.tagName == 'DIV' && elm.id && (id = me.__getId(elm.id))){
			if (id[0]){

				if (id[1] && me._aData[id[0]] && me._aData[id[0]].arg) {
					arg.id = arg.id || me._aData[id[0]].arg.id;
					arg.aid = arg.aid || me._aData[id[0]].arg.aid;
					arg.fid = arg.fid || me._aData[id[0]].arg.fid;
					arg.iid = arg.iid || me._aData[id[0]].arg.iid;
					arg.rights = arg.rights || me._aData[id[0]].arg.rights;
					arg.user = arg.user || me._aData[id[0]].arg.user;
				}

				if (e.type == 'contextmenu' && me._aData[id[0]]){
					if (me._oncontext) me._oncontext(e,elm,arg,me._aData[id[0]].id,id[1]);
					me.__exeEvent('oncontext',e,{"arg":arg,"id":me._aData[id[0]].id,"cell":id[1],"elm":elm,"owner":me});
					return false;
				}

				me._select_all = false;

				if (id[1]){
					if (e.type == 'dblclick'){
						if (me._ondblclick)
							me._ondblclick(e,elm,arg,id[0],id[1]);

						me.__exeEvent('ondblclick',e,{"arg":arg,"id":id[0],"cell":id[1],"elm":elm,"owner":me});
						return true;
					}

					var aClickType = [];
					if (e.ctrlKey || e.metaKey)
						aClickType.push('CTRL');
					if (e.shiftKey)
						aClickType.push('SHIFT');

					if (me._onclick) {
						if (await me._onclick(e,elm,arg,id[0],id[1],aClickType) === false) {
							return;
						}
					}

					if (!me._select_single && (e.ctrlKey || e.metaKey)){
						var p, v = clone(me.__value);
						if ((p = inArray(v, id[0]))>-1)
							v.splice(p,1);
						else
							v.push(id[0]);

						me._value(v);
					}
					else
					if (!me._select_single && e.shiftKey)
						me.__blockselection(id[0],true);
					else
						me._value([id[0]]);

					me.__exeEvent('onclick',e,{"arg":arg,"id":id[0],"cell":id[1],"elm":elm,"owner":me});
				}
			}
		}
		else
		    delete arg.iid;

		if (e.type == 'dblclick'){
			if (me._ondblclick)
				me._ondblclick(e,null,arg);

			me.__exeEvent('ondblclick',e,{"owner":me,"arg":arg});
		}
		else
		if (e.type == 'contextmenu'){
			if (me._oncontext)
				me._oncontext(e,null,arg);

			me.__exeEvent('oncontext',e,{"owner":me,"arg":arg});
			return false;
		}

		return true;
	};

	//*** SCROLLING
	this.__iScroll_left = 0;
	this.__eContainer2.onscroll = function(){
		if (me.__iScroll_left != this.scrollLeft){
			me.__iScroll_left = this.scrollLeft;

			if(gui._rtl && this.scrollRight)
				me.__eHeader.style.marginRight = -this.scrollRight+'px';
			else
				me.__eHeader.style.marginLeft = -me.__iScroll_left+'px';
		}

		if (me.__selectByPosition)
			me._selectPosition();
	};

	this._getAnchor('noitems').oncontextmenu = this._getAnchor('noitems').ondblclick = function(e){
		var arg = {};

		if (me._getFolder)
			arg = me._getFolder();

		if (e.type == 'dblclick'){
			if (me._ondblclick)
				me._ondblclick(e,null,arg);

			me.__exeEvent('ondblclick',e,{"owner":me,"arg":arg});
			return true;
		}
		else
		if (e.type == 'contextmenu'){
			if (me._oncontext)
				me._oncontext(e,null,arg);

			me.__exeEvent('oncontext',e,{"owner":me,"arg":arg});
			return false;
		}
	};

	this._main.oncontextmenu = function(e) {
		e && e.preventDefault && e.preventDefault();
		this.__eContainer2.onclick.apply(this.__eContainer2, arguments);
	}.bind(this);

	//this._main.ondblclick = this.__eContainer2.onclick;
	this.__eContainer2.ondblclick = this.__eContainer2.onclick;

	//Drag and Drop
	this.__eContainer2.onmousedown = function(e){
		if (me.__dndtimer){
			window.clearTimeout(me.__dndtimer);
			delete me.__dndtimer;
		}
		else{
			if (!me.__dragtype || e.button>1 || !me.__initdrag) return true;

			var elm = e.target,
				id,x = e.clientX,y = e.clientY;

			if ((elm.tagName == 'DIV' || (elm = elm.closest('div'))) && !elm.classList.contains('edit') && elm.id && (id = me.__getId(elm.id)) && id[0] && id[1]){
				// Disable scrollbar for Safari browser
				if (currentBrowser() == 'Safari')
					me._disable_scrolbar(me.__eContainer2, true, true);

				gui._obeyEvent('mouseup',[me,'__dndDispatch']);
				me.__dndtimer = window.setTimeout(function() {
					gui.__dragging = true;
					!me._destructed && me.__initdrag(id[0],x,y);
				}, 250);
			}
		}
	};

	//KEYBOARD HANDLERs
	this._main.setAttribute('tabindex',-1);

	AttachEvent(this._main, 'onfocus', function () {
		if (this.__blurTimeout) clearTimeout(this.__blurTimeout);
		addcss(me._main, 'focused');
	});

	AttachEvent(this._main, 'onblur', function () {
		this.__blurTimeout = setTimeout(function () {
			me._main && removecss(me._main, 'focused');
		}, 200);
	});

	function onkeydown(e) {
		var src = e.target, sCol, elm, v, box, pos, act, iPos, i,
			preventDefault = false;

		//Do not catch keyDn from input
		if (Is.Defined(src.value))
			return;

		//Find next position
		switch (e.keyCode) {
			//Enter
			case 13:
				if (me.__value.length && me.__value[0]) {
					var data = me._aData[me.__value[0]];
					if (data) {
						var arg = data.arg || {};

						if (me._onclick)
							me._onclick(e, null, arg, me.__value[me.__value.length - 1], null, []);

						me.__exeEvent('onclick', null, {
							"arg": arg,
							"id": data.id,
							"owner": me
						});
					}
				}
				return;

				//PgUp
			case 33:
				preventDefault = e.shiftKey;
				if (me.__eContainer2.scrollTop == 0)
					me._selectPosition('top');
				else {

					v = me._value();
					if (v && (v = v[v.length - 1])) {
						if (me.__small)
							sCol = '*';
						else
							for (sCol in me._aCols)
								break;

						if (sCol && (elm = document.getElementById(me._pathName + '/' + v + '/' + sCol))) {
							box = getSize(me.__eContainer2);
							pos = getSize(elm);

							if (pos.y > box.y && pos.y - pos.h > box.y) {
								me._selectPosition('top');
								return;
							}
						}
					}

					me._value([]);
					me.__selectByPosition = 'top';
					me.__eContainer2.scrollTop -= me.__eContainer2.offsetHeight;
				}
				return;
				//PgDn
			case 34:
				preventDefault = e.shiftKey;
				if (me.__eContainer2.scrollTop + me.__eContainer2.offsetHeight == me.__eContainer2.scrollHeight)
					me._selectPosition('bottom');
				else {
					v = me._value();
					if (v && (v = v[v.length - 1])) {
						if (me.__small)
							sCol = '*';
						else
							for (sCol in me._aCols)
								break;

						if (sCol && (elm = document.getElementById(me._pathName + '/' + v + '/' + sCol))) {
							box = getSize(me.__eContainer2);
							pos = getSize(elm);

							if (pos.y + pos.h < box.y + box.h && pos.y + (2 * pos.h) < box.y + box.h) {
								me._selectPosition('bottom');
								return;
							}
						}
					}

					me._value([]);
					me.__selectByPosition = 'bottom';
					me.__eContainer2.scrollTop += me.__eContainer2.offsetHeight;
				}
				return;

				//End
			case 35:
				preventDefault = e.shiftKey;
				if (me.__eContainer2.scrollTop + me.__eContainer2.offsetHeight == me.__eContainer2.scrollHeight)
					me._selectPosition('bottom');
				else {
					me._value([]);
					me.__selectByPosition = 'bottom';
					me.__eContainer2.scrollTop = me.__eContainer2.scrollHeight;
				}
				return;
				//Home
			case 36:
				preventDefault = e.shiftKey;
				if (me.__eContainer2.scrollTop == 0)
					me._selectPosition('top');
				else {
					me._value([]);
					me.__selectByPosition = 'top';
					me.__eContainer2.scrollTop = 0;
				}
				return;

				//Left
			case 37:
				preventDefault = e.shiftKey;
				var s = 0;
				if ((s = me.__eContainer2.scrollLeft) > 0) {
					s -= 20;
					me.__eContainer2.scrollLeft = s < 0 ? 0 : s;
				}
				return;

				//Right
			case 39:
				preventDefault = e.shiftKey;
				me.__eContainer2.scrollLeft += 20;
				return;

				//Up
			case 38:
				preventDefault = e.shiftKey;
				if (me.__value.length) {
					act = me.__value[me.__value.length - 1];
					for (i in me._aData) {
						if (i == act) break;
						iPos = i;
					}

					if ((!e.shiftKey || me._select_single) && typeof iPos != 'undefined')
						me._value([iPos]);
				}
				break;

				//Down
			case 40:
				preventDefault = e.shiftKey;
				if (me.__value.length) {
					act = me.__value[me.__value.length - 1];
					var found = false;
					for (iPos in me._aData) {
						if (found)
							break;
						if (iPos == act)
							found = true;
					}

					if (!e.shiftKey || me._select_single)
						me._value([iPos]);
				}
				break;

			default:
				//Select all in view (Ctrl+A)
				if (!me._select_single && (e.ctrlKey || e.metaKey) && !e.altKey && e.keyCode == 65) {
					me._select_all = true;
					var tmp = [];
					for (i in me._aData)
						tmp.push(i);
					me._value(tmp);
					e.preventDefault();
				}

				if (me._onkeydown) {
					setTimeout(function () {
						me._onkeydown(e);
					}, 0);
				}

				return;
		}

		if (preventDefault) {
			e.preventDefault();
		}

		//SHIFT + Up | Down
		if (!me._select_single && e.shiftKey && (e.keyCode == 38 || e.keyCode == 40))
			me.__blockselection(iPos);

		if (me._onkeypress)
			me._onkeypress(e);
	}

	AttachEvent(this._main, 'onkeydown', onkeydown);
	this.__onkeydown = function(e) {
		if (document.activeElement === document.body || document.activeElement.nodeName === 'IFRAME') {
			onkeydown(e);
		}
	};
	AttachEvent(document.body, 'onkeydown', this.__onkeydown);

	this._add_destructor('__removeGlobalKeydownListener');

	//@Note: apply only on width change
	var eFrame = mkElement('iframe',{frameborder:0,name:this._pathName + "#frame", marginheight:0, marginwidth:0, src:"", id: this._pathName + '#frame'});
	this._main.appendChild(eFrame);
	eFrame.contentWindow.onresize = function(e){
		if (this.__width != eFrame.offsetWidth){
			this.__width = eFrame.offsetWidth;

			me.__exeEvent('onsize',e,{"width":this.__width,"owner":me});
		}
	};
};

_me.__removeGlobalKeydownListener = function() {
	document.body.removeEventListener('keydown', this.__onkeydown);
};

_me._placeholder = function (sValue, bHTML){
	this._getAnchor('noitems')[bHTML?'innerHTML':'innerText'] = sValue || getLang('DATAGRID::NOITEMS');
};

_me.__dndDispatch = function(){

	// Enable scrollbar for Safari browser
	if (currentBrowser() == 'Safari')
		this._disable_scrolbar(this.__eContainer2, false, false);

	if (this.__dndtimer){
		window.clearTimeout(this.__dndtimer);
		delete this.__dndtimer;
	}
	gui.__dragging = false;
	return false; // for _disobeyEvent
};

_me._disabled = function(b){
	if (Is.Defined(b))
		window[b?'addcss':'removecss'](this._main,'disabled');
	else
		return hascss(this._main,'disabled');
};

_me._getFocusElement = function(){
	return this._main;
};
_me._focus = function(){
	this._getFocusElement().focus();
};
_me._selectFirst = function(){
    if (this.__eContainer2.scrollTop==0)
		for (var id in this._aData){
			this._value([id]);
			return true;
		}

	return false;
};


	/**
	 * Shift + click|Up|Dn
	 **/

	/*
	- pole realnych pozic v DG z $v
	- najit blok ve kterem je $act
	- smazat ostatni bloky

	#UP
	je-li $iPos v $v
		- smazat vse pod $iPos vcetne $iPos

	- ptidat iPos na konec $v

	#DOWN
	je-li $iPos v $v
		- smazat vse nad $iPos vcetne $iPos

	- ptidat iPos na konec $v
	*/

	_me.__blockselection = function(id,bClick){
		if (typeof id == 'undefined')
			return;

		var i, j, v = clone (this.__value), act_pos;

		//ziskat 1. sloupec
		if (this.__small)
			j = '*';
		else
		for(j in this._aCols)
			break;

		//kdyz neni posledni z value -> smaz vse
		// if (!this._aData[v[v.length-1]]) {
		// 	this._value([id]);
		// 	return;
		// }

		//najdi bloky
		var id_pos,aBlock = [], values = [];
		for (i in this.__rowOffset) {
			var data = this.__rowOffset[i].aData;
			if (data) {
				values.push((data.ORIGINALACCOUNT ? data.ORIGINALACCOUNT + '/' + data.ORIGINALFOLDER + '/' + data.iid : data.iid) || this.__rowOffset[i].id);
			}
		}
		for(i = v.length-1; i>=0; i--){
			// if ((elm = this.__getElement([v[i], j]))){
				aBlock.push([v[i], values.indexOf(v[i])]);

				//kdyby nove id uz bylo vybrano
				if (v[i] == id)
					id_pos = aBlock[aBlock.length-1][1];

				// elm = null;
			// }
			// else
			// 	v.splice(i,1);
		}

		//najdi pozici noveho id
		if (typeof id_pos == 'undefined')
			// if ((elm = this.__getElement([id,j])))
				id_pos = values.indexOf(id);
			// else
			// 	return;

		//najdi aktualni pozici
		if (aBlock.length)
			var act = aBlock[0];
		else{
			this._value([id]);
			return;
		}

		//serad blok
		function sortblock (a,b){ return a[1]-b[1]; };
		aBlock.sort(sortblock);

		//najdi aktualni pozici v blocich
		for(act_pos = -1, i = aBlock.length-1;i>=0;i--)
			if (act === aBlock[i])
				act_pos = i;

		//oriznout blok
		var tmp = act[1];
		if (act_pos)
			for (i = act_pos-1;i>=0;i--){
				if (tmp == aBlock[i][1]+1)
					tmp = aBlock[i][1];
				else{
					aBlock = aBlock.slice(i+1);
					act_pos -= i+1;
					break;
				}
			}

		tmp = act[1];
		for (i = act_pos+1,j = aBlock.length-1;i<=j;i++){
			if (tmp == aBlock[i][1]-1)
				tmp = aBlock[i][1];
			else{
				aBlock = aBlock.slice(0,i);
				break;
			}
		}


		//DOLU
		if (act[1]<id_pos){
			if(bClick){
				aBlock = [];
				var bFound = false;
				for(i in values){
					//else
					if (values[i] == act[0])
						bFound = true;

					if (bFound){
						aBlock.push([values[i]]);
						if (values[i] == id)
							break;
					}
				}

				aBlock.reverse();
			}
			//actual row in TOP
			else
			if (act_pos == 0 && aBlock.length>1 && id_pos-act[1]==1){
				aBlock.shift();
				aBlock.reverse();
			}
			//actual row in BOTTOM
			else
			if (act_pos == aBlock.length-1)
				aBlock.push([id]);
			//MIDDLE
			else{
				aBlock = aBlock.slice(act_pos+1);
				aBlock.reverse();
			}
		}
		//NAHORU
		else{
			if (bClick){
				tmp = [],bFound = false;
				for(i in values){

					if (values[i] == id)
						bFound = true;

					if (bFound)
						tmp.push([values[i]]);

					if (values[i] == act[0])
						break;
				}
				aBlock = tmp;
			}
			//actual row in BOTTOM
			else
			if (act_pos>0 && act_pos == aBlock.length-1)
				aBlock.pop();
			else
			//actual row in TOP
			if (act_pos == 0)
				aBlock.push([id]);
			//MIDDLE
			else
				aBlock = aBlock.slice(0,act_pos);
		}

		var out = [];
		for(i in aBlock)
			out.push(aBlock[i][0]);

		this._value(out, !bClick);
	};

//ok
_me._value = function (v,bScroll,bTimer,bNoUpdate){
	var i, j;
	if (typeof v == 'undefined')
		return clone(this.__value);
	else
	if (Is.Array(v)){
		var elm,tmpData = {};

		//clean keyboard scrolling
		this.__selectByPosition = '';

		//remove unselected
		for(i in this.__value)
		    if (inArray(v,this.__value[i])<0/* || (bPreselect != this.__preselectValue)*/){
				if (this.__small){
					if ((elm = this.__getElement([this.__value[i],'*']))){
						removecss(elm,'active');
						elm = null;
					}
				}
				else
				for(j in this._aCols)
					if ((elm = this.__getElement([this.__value[i],j]))){
						removecss(elm,'active');
						elm = null;
					}
			}

		this.__value = v;

		for(i in v){
			if (this._aData[v[i]])
				tmpData[v[i]] = this._aData[v[i]];
			else
			if (this.__valueData[v[i]])
				tmpData[v[i]] = this.__valueData[v[i]];
			else
				tmpData[v[i]] = {id:v[i]};

			if (this.__small){
				if ((elm = this.__getElement([v[i],'*']))){
					addcss(elm,'active');
				}
			}
			else
			for(j in this._aCols){
				if ((elm = this.__getElement([v[i],j]) || elm)){
					if (addcss(elm, 'active')<1)
						break;
				}
			}
		}

		this.__valueData = tmpData;

		// AUTO SCROLL
		if ((v.length == 1 || bScroll) && elm){

			//actual position
			var a1 = this.__eContainer2.scrollTop;

			//row position
			if (elm.offsetTop < a1)
				this.__eContainer2.scrollTop = elm.offsetTop;
			else{
				var a2 = this.__eContainer2.offsetHeight,
					row = elm.offsetTop + elm.offsetHeight;

				if (a1+a2 < row)
					this.__eContainer2.scrollTop = row - a2;
			}
		}

		elm = null;

		if (!bNoUpdate){
			if (this._onchange)
				this._onchange(this.__value, bTimer);
			this.__exeEvent('onchange',null,{"value":this.__value,"owner":this});
		}

		if (this.info)
			this.info._value(this.__value.length,this.__total);
	}
};

_me._active = function(v) {
	var elm;
	for(var i in this.__active)
		if (inArray(v,this.__active[i])<0){
			if (this.__small){
				if ((elm = this.__getElement([this.__active[i],'*']))){
					removecss(elm,'active2');
					elm = null;
				}
			} else if (this.__highlightContext) {
				this.__highlightContext.style.display = 'none';
			}
		}

	this.__active = v;

	for(i in v){
		if (this.__small){
			if ((elm = this.__getElement([v[i],'*']))){
				addcss(elm,'active2');
			}
		} else {
			if (this.__highlightContext) {
				var col;
				for(var j in this._aCols) {
					col = this.__getElement([this.__active[i], j]);
					break;
				}
				if (col) {
					this.__highlightContext.style.top = col.style.top;
					this.__highlightContext.style.display = 'block';
				}
			}
		}
	}
};

/**
 * @brief: onresize handler
 * @scope: PROTECTED
 * @date : 13.10.2006 12:10:12
 *
 **/
_me._onresize = function(e,elm){
	var me = this,
		bDynamic = false;

	gui._disobeyEvent('mousemove',[this,'__mmove_resize']);
	gui._disobeyEvent('mouseup',[this,'__mup_resize']);

	//get Resizing mode
	for(var i in this._aCols)
		if (this._aCols[i].mode == '%' && this._aCols[i].display != 'small'){
			bDynamic = true;
			break;
		}

	// Collect an measure of the moved column and the columns behind it
	var aCols = [], tmp = elm, sID, oCol = null, maxPos = 0, j;
	do {
		if (tmp.id && (sID = this.__getId(tmp.id,'#')[0]) && this._aCols[sID]){
			aCols.push({
				id:sID,
				headerElm: tmp,
				columnElm: this.__getElement([sID]),
				position: gui._rtl ? parseInt(tmp.style.right) : tmp.offsetLeft,
				width: tmp.offsetWidth,
				mode: this._aCols[sID].mode,
				type: this._aCols[sID].type
			});
		}
	}
	while((tmp = tmp.nextSibling) && tmp.id);

	if (!aCols.length)
		return;

	// check if there is any resizable column
	if (bDynamic){
		for (i = 1, j = aCols.length; i<j; i++){
			if (aCols[i] && aCols[i].type != 'static'){
				oCol = aCols[i];
				break;
			}
		}

		if (oCol)
			maxPos = oCol.width;
		else
			return;
	}

	var difX = e.clientX,
		difS = this.__eContainer2.scrollLeft;

	this.__mmove_resize = function (e){

		var move = e.clientX - difX, // Real movement ± to left in pixels
			pos = gui._rtl ? -move : move + (me.__eContainer2.scrollLeft - difS);

		for (var i = 0, j = aCols.length; i<j; i++){
			// Resize selected column
			if (i==0){
				var w = gui._rtl ? aCols[0].width-move : aCols[0].width+move;

				if (w < me._col_width) {
					w = me._col_width;
					pos = w - aCols[0].width;
				}
				else
				if (bDynamic && (maxPos - me._col_width < pos)){
					pos = maxPos - me._col_width;
					w = pos + aCols[0].width;
				}

				aCols[0].newWidth = w;

				aCols[0].headerElm.style.width = w + 'px';
				if (aCols[0].columnElm)
					aCols[0].columnElm.style.width = w + 'px';

				if (!bDynamic && gui._rtl)
					me.__eHeader.style.marginRight = (me.__eContainer2.clientWidth - me.__eContainer2.scrollWidth + me.__eContainer2.scrollLeft) + 'px';
			}
			// Position columns behind it
			else{
				var s = aCols[i].position + pos;

				aCols[i].headerElm.style[gui._rtl?'right':'left'] = s + 'px';
				if (aCols[i].columnElm)
					aCols[i].columnElm.style[gui._rtl?'right':'left'] = s + 'px';

				if (bDynamic && oCol.headerElm === aCols[i].headerElm){
					oCol.newWidth = maxPos - pos;

					oCol.headerElm.style.width = oCol.newWidth + 'px';
					if (aCols[i].columnElm)
						oCol.columnElm.style.width = oCol.newWidth + 'px';

					break;
				}
			}
		}

	};


	this.__mup_resize = function (){
		gui._disobeyEvent('mousemove',[me,'__mmove_resize']);

		var iDynWidth = 0, i;
		if (bDynamic){
			// get width of all dynamic columns
			for (i in me._aCols)
				if (me._aCols[i].mode == '%' && (elm = this.__getElement([i], '#'))){
					iDynWidth += elm.offsetWidth;
				}
		}

		// translate px to %
		for (i = 0, j = aCols.length; i<j; i++){
			if (me._aCols[aCols[i].id] && Is.Defined(aCols[i].newWidth)){
				if (aCols[i].mode == '%')
					me._aCols[aCols[i].id].width = Math.round(aCols[i].newWidth/(iDynWidth/100),2);
				else
					me._aCols[aCols[i].id].width = aCols[i].newWidth;
			}
		}

		if (me._onresizeend) me._onresizeend(me._aCols);
		me.__exeEvent('onresizeend',null,{"cols":me._aCols,"owner":me});

		return false;
	};

	gui._obeyEvent('mouseup',[this,'__mup_resize']);
	gui._obeyEvent('mousemove',[this,'__mmove_resize']);
};


_me.__move = function(id,difX){
	var me = this;

	// Calculate total width of the grid
	// var totalWidth = 0, tmp = elm.parentNode.firstElementChild;
	// do {
	// 	totalWidth += tmp.offsetWidth;
	// } while (tmp = tmp.nextSibling);

	// Add column label as draggable object
	var elm = this.__getElement([id], '#').cloneNode(true);
	addcss(elm,'coldrag');
	this.__eHeader.appendChild(elm);

	var pos = getSize(elm);
		pos.l = elm.offsetLeft;
	if(gui._rtl)
		pos.r = parseInt(elm.style.right);

	var col = this._aCols[id];

	// Add element for showing column drop position
	var aelm = mkElement('div', {className:'arrow_div'});
	this.__eHeader.appendChild(aelm);

	var offX = 0, aCols = [],tmpX = 0,targetId = id, tmp;
	for(var i in this._aCols){
		if (this._aCols[i].display != 'small' && (tmp = this.__getElement([i], '#'))){
			if (!~(this._aCols[i].css || '').indexOf('static')) {
				aCols.push([tmpX, i]);
			}
			tmpX += tmp.offsetWidth;
		}
	}
	if (tmpX)
		aCols.push([tmpX]);

	//destructor
	async function mouseup(){
		var i;
		gui._disobeyEvent('mousemove',[mousemove]);
		gui._disobeyEvent('mouseup',[mouseup]);

		if (elm)
			elm.parentNode.removeChild(elm);
		if (aelm)
			aelm.parentNode.removeChild(aelm);

		if (targetId == id)
			await me._addColumns(me._aCols);
		else{
			var tmp = {};
			for(i in me._aCols){
				if (i == id)
					continue;

				if (i == targetId)
					tmp[id] = col;

				tmp[i] = me._aCols[i];
			}
			if (targetId == null)
				tmp[id] = col;

			await me._addColumns(tmp);
		}

		if (me._onresizeend) me._onresizeend(me._aCols);
		me.__exeEvent('onresizeend',null,{"cols":me._aCols,"owner":me});

		var aColumns = Object.keys(me._aCols).reverse();
		var body = me._getAnchor('body');
		for (i in aColumns) {
			var column = me.__getElement([aColumns[i]]);
			column && body.insertAdjacentElement('afterbegin', column);
		}

	};
	gui._obeyEvent('mouseup',[mouseup]);

	var difS = me.__eContainer2.scrollLeft;
	var scrollRight = me.__eContainer2.scrollRight || 0;
	offX = difX - pos.x;

	function mousemove(e){
		var left = gui._rtl ? pos.r - (e.clientX - difX) : pos.l + (e.clientX - difX),
			prev,
			p = gui._rtl ? left + me.__eContainer2.scrollRight - scrollRight : left + me.__eContainer2.scrollLeft - difS;
		for (var i in aCols) {
			if (aCols[i][0] >= p + offX){
				break;
			}
			else
				prev = i;
		}

		if(!gui._rtl) left = p;

		if (left<0) left = 0;

		elm.style[gui._rtl?'right':'left'] = left + 'px';

		if (aCols[prev])
			if (typeof prev != 'undefined' && aCols[prev] && aCols[prev][1] != id && (!aCols[prev-1] || aCols[prev-1][1] != id)){

				aelm.style[gui._rtl?'right':'left'] = aCols[prev][0] + 'px';
				targetId = aCols[prev][1];
			}
			else
			{
				if (aCols[prev][1] == id)
					targetId = id;
				else
					targetId = null;

				aelm.style[gui._rtl?'right':'left'] = '';
			}
	};

	gui._obeyEvent('mousemove',[mousemove]);
};

/**
 * @brief: function for decoding ID attribute
 * @scope: PRIVATE
 * @date : 13.10.2006 12:21:29
 **/
_me.__getId = function(id,separator){
	if (id.indexOf(this._pathName+(separator || '/')) !== 0)
		return;
	else{
		var ids = id.substr(this._pathName.length+1).split(separator || '/');
		for (var i = ids.length-1;i>=0;i--)
			ids[i] = decodeURIComponent(ids[i]);

		return ids;
	}
};

_me.__getElement = function (id,separator){
	var tmp = [this._pathName];

	for(var i = 0;i<id.length;i++)
		tmp.push(encodeURIComponent(id[i]));

	return this._main.ownerDocument.getElementById(tmp.join(separator || '/'));
};

/**
 * Initial function
 * add new columns
 * HTML column: <div class="col coldrag" style="left: 250px"><span></span><a href="">title</a></div>
 * DATA column: [{text:"column 1",width:250,css:'test',arg:{sort:'asc'}},...]
 *
 * @Date: 8.2.2008 9:31:13
 **/

_me._addColumns = async function(aData){

	//avoid worthless refresh
	if (aData){
		if (Is.Empty(aData)){
			this._aCols = {};
		}
		else
			this._aCols = aData;
	}
	else
	if (!this._aCols) return;

	this.__prevSort = this.__sortColumn;
	this.__prevSortType = this.__sortType;

	//Create header
	this.__eHeader.innerHTML = '';


	var sCSS = '', eCol, bDynamic = false;
	for(var i in this._aCols){
		this._aCols[i].hideColumnFor = this._aCols[i].hideColumnFor || [];
		//skip "small mode only" columns
		if (this._aCols[i]['display'] == 'small' || ~this._aCols[i].hideColumnFor.indexOf('all') || ~this._aCols[i].hideColumnFor.indexOf('user')) {
			continue;
		}

		if (this._aCols[i].mode == '%')
			bDynamic = true;

		sCSS = this._aCols[i].css || '';
		if (this.__sortColumn == i)
			sCSS += (sCSS?' ':'') + (this.__sortType?'desc':'asc');
		if ((this._aCols[i].arg || {}).search && this._smallfilter === this._aCols[i].arg.search) {
			sCSS += ' active';
		}

		eCol = mkElement('div', {id:this._pathName + '#' + i, className:'col '+ sCSS});

		if (this._aCols[i].type != 'static')
			eCol.appendChild(mkElement('p'));

		eCol.appendChild(mkElement('div',{unselectable:"on", innerHTML:this._aCols[i].text || (this._aCols[i].title?getLang(this._aCols[i].title, '', 2):'') || '&nbsp;'}));

		this.__eHeader.appendChild(eCol);
	}

	this.__fitwidth();

	if (bDynamic){
		this._obeyEvent('onsize',[this, '__fitwidth']);
		addcss(this._main, 'dynamic');
	}
	else{
		this._disobeyEvent('onsize',[this, '__fitwidth']);
		removecss(this._main, 'dynamic');
	}

	if (this._parent && this._parent._name === 'main') {
		var refresh, me = this;
		if (!this.__small && this._getAnchor('header').children.length) {
			this.refresh && await this.refresh._destruct();
			refresh = await this._create('refresh', 'obj_button', this._getAnchor('header').querySelector('.refresh').getAttribute('id').replace(this._pathName + '#', ''), 'ico img refresh transparent');
		}
		if ((refresh || this.refresh)) {
			(refresh || this.refresh)._onclick = function() {
				this._disabled(true);
				this._main.classList.add('loading');

				gui.frm_main._getNew(function() {
					if (me._destructed) {
						return;
					}
					this._disabled(false);
					this._main.classList.remove('loading');
				}.bind(this));
			};
		}
	}
};

_me.__fitwidth = function(){

	if (this.__small)
		return;

	var iWidth = 0, aDyn = [], w, i, j;
	for(i in this._aCols){
		this._aCols[i].hideColumnFor = this._aCols[i].hideColumnFor || [];
		//skip "small mode only" columns
		if (this._aCols[i]['display'] == 'small' || ~this._aCols[i].hideColumnFor.indexOf('all') || ~this._aCols[i].hideColumnFor.indexOf('user')) {
			continue;
		}

		w = parseInt(this._aCols[i].width || this._col_width, 10);

		aDyn.push({
			elm: this.__getElement([i],"#"),
			elm2: this.__getElement([i]),
			width: w,
			mode: this._aCols[i].mode
		});

		if (this._aCols[i].mode != '%')
			iWidth += w;
	}

	if (aDyn.length){
		var iOffset = 0,
			iDynOffset = 0,
			iDynWidth = Math.max(this.__eContainer2.offsetWidth - iWidth, 0),
			iControl = 0;

		for (i = 0, j = aDyn.length;i<j;i++){

			aDyn[i].elm.style[gui._rtl?'right':'left'] = iOffset + 'px';
			if (aDyn[i].elm2)
				aDyn[i].elm2.style[gui._rtl?'right':'left'] = iOffset + 'px';

			//%
			if (aDyn[i].mode == '%'){

				if (iDynWidth>0){
					var v = aDyn[i].width;

					//When somehow % values are over 100
					if (v + iControl>100)
					 	v = 100 - iControl;

					w = Math.ceil(iDynWidth/100*v);
					if (iDynOffset + w > iDynWidth)
					 	w = iDynWidth - iDynOffset;

					aDyn[i].elm.style.width = w + 'px';
					if (aDyn[i].elm2)
						aDyn[i].elm2.style.width = w + 'px';

					iControl += v;
					iOffset += w;
					iDynOffset += w;
				}
				else{
					aDyn[i].elm.style.width = this._col_width + 'px';
					if (aDyn[i].elm2)
						aDyn[i].elm2.style.width = this._col_width + 'px';

					iOffset += parseInt(this._col_width,10);
				}

			}
			//px
			else{
				aDyn[i].elm.style.width = aDyn[i].width + 'px';
				if (aDyn[i].elm2)
					aDyn[i].elm2.style.width = aDyn[i].width + 'px';

				iOffset += aDyn[i].width;
			}
		}
	}
};

/*
EDIT COLUMN
neni hotove, je treba doresit stop scrolling & refresh
*/
_me._editColumn = async function(id,sColumn,aInpControl,aHandler){

	if (this._aData[id]){
		this._anchors['#editObj'] = this._pathName +'/'+id+'/*';
		this._anchors['#edit'] = this._pathName +'/'+id+'/'+sColumn;

		var elm = this._getAnchor('#edit');
		var obj = this._getAnchor('#editObj');
		if (elm){

			//stop scrolling
			this._disable_scrolbar(this.__eContainer2, true, true);

			//stop refresh

			//create edit object
			if (this.edit)
				await this.edit._destruct();

			//Edit mode CSS
			addcss(elm, 'edit');
			addcss(obj, 'edit');

			var edit = await this._create('edit', aInpControl['type'] || 'obj_input','#edit','edit_column');
				edit.__returnScrollbar = function(){
					//Edit mode CSS
					elm && removecss(elm,'edit');

					//start scrolling
					try{ this._parent._disable_scrolbar(this._parent.__eContainer2,false, false); }catch(r){ console.log(this._name||false,r)}

					//start refresh
				};
				edit._add_destructor('__returnScrollbar');

				edit._onblur = function(){
					this._onsubmit();
				};
				edit._onclose = function(){
					this._destruct();
				};
				edit._onclick = function(e){
					e.stopPropagation();
				};
				edit._onsubmit = async function(){
					if (!this._destructed) {
						if(aInpControl['restrictions'] && !edit._validate())
							return false;

						removecss(obj, 'edit');
						if (aHandler && edit.__oldValue != edit._value()){
							
							var sOut = await executeCallbackFunction(aHandler,this._value());

							if (sOut !== false){
								this._destruct();

								if (Is.String(sOut))
									elm.innerHTML = sOut;
							}
						}
						else
							this._destruct();
					}
				};

			if (aInpControl['restrictions']) {
				if(aInpControl['restrictions'] instanceof Array)
					edit._restrict.apply(edit,aInpControl['restrictions']);
				else
					edit._restrict(aInpControl['restrictions']);
			}

			if (aInpControl['fill'])
			    edit._fill(aInpControl['fill']);

			if (aInpControl['value'])
				edit.__oldValue = aInpControl['value'];
			else
			if (Is.Array(this._aData[id].data[sColumn]))
				edit.__oldValue = this._aData[id].data[sColumn][1] || this._aData[id].data[sColumn][0];
			else
				edit.__oldValue = this._aData[id].data[sColumn];

			edit._value(edit.__oldValue);

			edit._focus(true);
		}
	}
};

/**
 * @brief  : fill grid with given data
 * @date   : 8.2.2008 10:33:26
 *
 * @example: aData = {<id>:
 *	{
 *		data:{'col1':{[str,sort str]},'col2':...},
 *		arg: {...}},
 *		css: '',
 *		display: small|all
 *	}
 *
 *	<div class="col" style="left: 250px">
 *		<div class="row" style="top: 20px">a</div>
 *		...
 *	</div>
 **/
_me._fill = async function(aData, rowOffset, bPrefill){
	//Remove all adjecent objects (Edit mode)
	if (this.edit)
		return;
		//this.edit._destruct();

	//Check if folder is new
	var bNewFolder = true;
	if (this._aFolderLast && this._aFolderLast.aid == this._aFolder.aid && this._aFolderLast.fid == this._aFolder.fid && (this._aFilterLast || {}).search == (this.__filter || {}).search) {
		bNewFolder = false;
	}

	var removedFromDataset = [], i, child, j;
	if (this._aFolder) {
		removedFromDataset = dataSet.get('removedFromDataset', [this._aFolder.aid, this._aFolder.fid]) || [];
		if (bNewFolder || (aData && rowOffset === void 0)) {
			for(i in this.__separators) {
				this.__separators[i].parentNode.removeChild(this.__separators[i]);
			}
			this.__separators = {};
		} else if (removedFromDataset.length) {
			for(i in this.__separators) {
				var group = this.__separators[i].group;
				var ids = Object.keys(group);
				if (ids.length && !ids.some(function(id) {
					return !~removedFromDataset.indexOf(id);
				})) {
					this.__separators[i].parentElement.removeChild(this.__separators[i]);
					this.__eBody.style.height = parseInt(this.__eBody.style.height) - this._separator_height + 'px';
					delete this.__separators[i];
				} else {
					removedFromDataset.forEach(function(id) {
						delete this.__separators[i].group[id];
					}, this);
				}
			}
		}
	}

	var aOldData = this._aData;
	if (aData) {
		if (removedFromDataset.length) {
			for (i in aData) {
				if (~removedFromDataset.indexOf(aData[i].ORIGINALACCOUNT ? aData[i].aid + '/' + aData[i].fid + '/' + aData[i].id : aData[i].id)) {
					delete aData[i];
				}
			}
		}

		if (typeof rowOffset == 'undefined')
			this._aData = clone(aData, true);
		else
		for(i in aData)
			this._aData[i] = clone(aData[i], true);
	}
	else
		aData = this._aData;

	var aCols = {},tmp,css,css2;

	if (this.__small){

		if (!bNewFolder && (tmp = this.__eBody.firstChild) && tmp.id == this._pathName+'/*'){
			aCols['*'] = tmp;

			//garbage cleaner
			if (typeof rowOffset == 'undefined') {
				var children = [].slice.call(tmp.children);
				for(i in children) {
					child = children[i];
					if (!child.classList.contains('separator')) {
						if (
							!aData[child.id.replace(this._pathName + '/', '').replace('/*', '')] ||
							!arrayCompare(aData[child.id.replace(this._pathName + '/', '').replace('/*', '')].aData, (aOldData[child.id.replace(this._pathName + '/', '').replace('/*', '')] || {}).aData || {})
						) {
							tmp.removeChild(child);
						}
					} else {
						child.classList.add('hidden');
					}
				};
			}
		}
		else{

			while((child = this.__eBody.lastChild))
				this.__eBody.removeChild(child);

			// for(var en = this.__eBody.childNodes, i = en.length-1; i>=0; i--)
			// 	en[i].parentNode.removeChild(en[i]);

			var s = {width:'100%'};
			s[gui._rtl?'right':'left'] = 0;
			aCols['*'] = mkElement('div',{id:this._pathName+'/*',style: s,className:'col unicolumn'});

			if (this.__smallOptions && this.__smallOptions.css)
				addcss(aCols['*'], this.__smallOptions.css);

			this.__eBody.appendChild(aCols['*']);
		}

		if (this.__highlightHover && this.__highlightHover.parentNode) {
			this.__highlightHover.parentNode.removeChild(this.__highlightHover);
			this.__highlightHover = false;
		}
		if (this.__highlightContext && this.__highlightContext.parentNode) {
			this.__highlightContext.parentNode.removeChild(this.__highlightContext);
			this.__highlightContext = false;
		}

		if (bNewFolder) {
			this.__fillCompact && await this.__fillCompact();
			if (this.sort) {
				delete this.sort.__sort;
				delete this.sort.__dir;
			}
			this.__fillSort && await this.__fillSort();
			this.__fillFilter && await this.__fillFilter();
		}
	}
	else{
		if ((tmp = this.__eBody.firstChild) && tmp.id == this._pathName+'/*')
			bNewFolder = true;

		var defaultColumns = {};
		if (this._aFolder) {
			defaultColumns = await this._default_columns(WMFolders.getType(this._aFolder));
		}
		this._aCols = Is.Empty(this._aCols) ? (this._aFolder ? clone(defaultColumns, true) : this._aCols) : this._aCols;

		var cols = {};
		var aColumnsOrder = this._aFolder ? Cookie.get(['views',this._aFolder.aid,this._aFolder.fid,'columns_order']) || [] : [];
		aColumnsOrder.forEach(function(column) {
			if (this._aCols[column]) {
				cols[column] = this._aCols[column];
				delete this._aCols[column];
			}
		}, this);

		if (!Is.Empty(defaultColumns)) {
			if (!Is.Empty(this._aCols)) {
				tmp = [];
				for (i in cols) {
					cols[i].id = i;
					tmp.push(cols[i]);
				}
		
				for (i in this._aCols) {
					var index = 0;
					for (j in defaultColumns) {
						if (i === j) {
							break;
						}
						index++;
					}
					this._aCols[i].id = i;
					tmp.splice(index, 0, this._aCols[i]);
				};
		
				cols = {};
				tmp.forEach(function(aCol) {
					cols[aCol.id] = aCol;
				});
			}

			this._aCols = cols;
		}

		//get columns
		if (!bNewFolder && this.__eBody.hasChildNodes()){
			for (i in this._aCols)
				if ((tmp = this.__getElement([i]))){
					aCols[i] = tmp;

					//garbage cleaner
					if (typeof rowOffset == 'undefined')
						aCols[i].innerHTML = '';
				}
			if (typeof rowOffset == 'undefined') {
				for(i in this.__separators) {
					this.__separators[i].classList.add('hidden');
				}
			}
		}
		// create columns
		else{
			//destruct old body
			if (bNewFolder){
				while((child = this.__eBody.lastChild))
					this.__eBody.removeChild(child);
			}

			for (i in this._aCols){

				if (!this.__small && (this._aCols[i].display == 'small' || ~(this._aCols[i].hideColumnFor || '').indexOf('all'))) {
					continue;
				}

				aCols[i] = mkElement('div',{id:this._pathName+'/'+encodeURIComponent(i)});
				this.__eBody.appendChild(aCols[i]);
				aCols[i].className = 'col ' + (this._aCols[i].css || '') + (this.__sortColumn == i?' sort':'');
			}

			this.__fitwidth();
		}

		this.__highlightHover = this.__highlightHover || mkElement('section', { className: 'highlight_row' });
		this.__highlightContext = this.__highlightContext || mkElement('section', { className: 'highlight_row' });
		this.__eBody.appendChild(this.__highlightHover);
		this.__eBody.appendChild(this.__highlightContext);
	}

	//revertovany pole kuli pomalosti inArray
	var val = {}, bChange = false;
	for(i = this.__value.length;i--;){
		if (!this.__limit && !aData[this.__value[i]]){
			this.__value.splice(i,1);
			bChange = true;
		}
		else
			val[this.__value[i]] = 1;
	}

	// fill columns
	var str, offset, sTitle, cell, row, row_offset;
	tmp = '';
	if (typeof rowOffset == 'undefined') {
		offset = this.__offset * this._row_height;
		row_offset = this.__offset;
	} else {
		row_offset = rowOffset;
		offset = row_offset * this._row_height;
	}

	var now = new IcewarpDate().startOf('day');
	function separatorFunction(date) {
		date = date.clone().startOf('day');
		if (date.isSame(now, 'day')) {
			return 0; // today
		} else if (date.isSame(now.clone().subtract(1, 'days'), 'day')) {
			return 1; // yesterday
		} else if (date.isSame(now.clone().subtract(2, 'days'), 'day')) {
			return 2; // 2 days ago
		} else if (date.isBefore(now, 'time') && date.isSame(now, 'week')) {
			return 3; // this week
		} else if (date.isSame(now.clone().subtract(7, 'days'), 'week')) {
			return 7; // last week
		} else if (date.isSame(now.clone().subtract(14, 'days'), 'week')) {
			return 14; // two weeks ago
		} else if (date.isBefore(now, 'time')) {
			return 21; // older
		} else if (date.isSame(now.clone().add(1, 'days'), 'day')) {
			return -1; // tomorrow
		} else if (date.isAfter(now, 'time') && date.isSame(now, 'week')) {
			return -3; // this week
		} else if (date.isSame(now.clone().add(7, 'days'), 'week')) {
			return -7; // next week
		} else if (date.isSame(now.clone().add(1, 'month'), 'month')) {
			return -14; // next month
		} else {
			return -21; // newer
		}
	}

	var passed_separators = [];
	var asc = this.__sortType;
	if (this._aFolder && this._aFolder.fid === '__@@SNOOZED@@__') {
		asc = !asc;
	}

	var separatorCache = {};
	for (i in aData){

		if (~['ITM_DELETED', 'QDATE', 'DATE', 'EVN_MODIFIED'].indexOf(this.__sortColumn) && GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'GROUP_BY_DATE') == '1') {
			var date = (aData[i].data[this.__sortColumn] || [])[4];
			if (date) {
				var sid = separatorFunction(date);
				aData[i].separator = sid;
				if (separatorCache[sid]) {
					this.__separators[sid].group[i] = aData[i];
				} else if (sid !== void 0) {
					for (j = asc ? -21 : 21; asc ? j <= sid : (j >= sid); asc ? j++ : j--) {
						var separator = this.__separators[j];
						if (separator && !~passed_separators.indexOf(j)) {
							if (rowOffset === void 0) {
								separator.style.top = offset + 'px';
								if (j === sid) {
									separator.classList.remove('hidden');
								}
							}
							offset += this._separator_height;
							passed_separators.push(j);
						} else if (j === sid) {
							if (separator === void 0) {
								row = mkElement('section', {
									style: {
										top: offset + 'px',
									},
									className: 'separator',
									textContent: getLang('datagrid::days_back_' + sid)
								});
								offset += this._separator_height;
								if (this.__small)
									aCols['*'].appendChild(row);
								else {
									this.__eBody.appendChild(row);
								}
								this.__separators[j] = row;
								passed_separators.push(j);
							}
							this.__separators[j].group = this.__separators[j].group || {};
							this.__separators[j].group[i] = aData[i];
							separatorCache[j] = true;
						}
					}
				}
			}
		}

		tmp = aData[i];

		css = [];
		tmp.css && css.push(tmp.css);

		if (val[i]){
			css.push('active');
		}

		if (this.__small){
			var id = this._pathName + '/' + encodeURIComponent(i) + '/*';
			if ((row = document.getElementById(id))) {
				row.style.top = offset + 'px';
				row = false;
			} else {
				row = mkElement('div', {
					id: id,
					style: {
						top: offset + 'px',
						height: this._row_height + 'px'
					},
					className: css.join(' ')
				});
				aCols['*'].appendChild(row);
			}
		}

		for(j in this._aCols){
            sTitle = '';
            css2 = [];
			str = '';
			this._aCols[j].hideColumnFor = this._aCols[j].hideColumnFor || '';

			if (this.__small){
				if (!row) {
					break;
				}

				if (this._aCols[j]['display'] != 'all' && this._aCols[j]['display'] != 'small')
					continue;

				if (~this._aCols[j].hideColumnFor.indexOf('small')) {
					continue;
				}

				css = ['col_'+j];
				this._aCols[j].css && css.push(this._aCols[j].css);
			}
			else {
				if (~this._aCols[j].hideColumnFor.indexOf('all')) {
					continue;
				}

				if (this._aCols[j]['display'] == 'small')
					continue;
			}
			if (~this._aCols[j].hideColumnFor.indexOf('user')) {
				continue;
			}

			if (typeof tmp.data[j] == 'object'){
				if (tmp.data[j][0])
					str = tmp.data[j][0];

				//title
				if (tmp.data[j][2] && !window.navigator.msPointerEnabled && !('-ms-scroll-limit' in document.documentElement.style && '-ms-ime-align' in document.documentElement.style)) // except edge
				    sTitle = tmp.data[j][2];

				//cell css
				if (tmp.data[j][3])
				    css2.push(tmp.data[j][3]);
			}
			else
			if (tmp.data[j])
				str = tmp.data[j];

			var attrs = {
				id: this._pathName + '/' + encodeURIComponent(i) + '/' + encodeURIComponent(j),
				className: [].concat(css, css2).join(' '),
				unselectable: 'on'
			};
			if(sTitle) {
				attrs.title = sTitle;
			}
			cell = mkElement('div', attrs);

			if (!this.__small){
				cell.style.top = offset+'px';
				cell.style.height = this._row_height+'px';
			}

			if (str){
				if(gui._rtl && this._aCols[j].bidi) {
					var bdi = document.createElement('bdi');
					bdi.appendChild(document.createTextNode(str));
					cell.appendChild(bdi);
				} else
				if (this._aCols[j].encode) {
					var span, p = document.createElement('p');
					if (str.indexOf('<span>') !== 0) {
						span = document.createElement('span');
						p.appendChild(span);
					} else {
						span = p;
					}
					span.textContent = str.unescapeHTML();
					cell.appendChild(p);
				} else {
					if (!Array.isArray(str)) {
						str = [str];
					}
					cell.innerHTML = str.map(function(str) {
						if (str.indexOf('<span') !== 0) {
							str = '<span>' + str + '</span>';
						}
						return '<p>' + str + '</p>';
					}).join('');
				}
			}

			if (this.__small) {
				row.appendChild(cell);
				tmp.row = row;
			} else if (aCols[j]) {
				aCols[j].appendChild(cell);
				[].forEach.call(aCols[j].querySelectorAll('[title]'), function(elm) {
					var span = elm.querySelector('span');
					var small = this.__small;
					if (span && span.scrollWidth > span.clientWidth) {
						gui.tooltip._add(elm, elm.getAttribute('title'), {
							y: function() {
								var size = getSize(this);
								return size.y + (size.h / 2) - (small ? 12 : 11)
							}.bind(span),
							x: function() {
								return getSize(this).x - (small ? 11 : 3);
							}.bind(span)
						});
					}
					elm.removeAttribute('title');
				}.bind(this));
			}
		}

		row && [].forEach.call(row.querySelectorAll('[title]'), function(elm) {
			var span = elm.querySelector('span');
			var small = this.__small;
			if (span && span.scrollWidth > span.clientWidth) {
				gui.tooltip._add(elm, elm.getAttribute('title'), {
					y: function() {
						var size = getSize(this);
						return size.y + (size.h / 2) - (small ? 12 : 11)
					}.bind(span),
					x: function() {
						return getSize(this).x - (small ? 11 : 3);
					}.bind(span)
				});
			}
			elm.removeAttribute('title');
		}.bind(this));

		offset += this._row_height;
		this.__rowOffset[row_offset++] = tmp;
	}

	if (!bPrefill) {
		// set height
		if (typeof this.__total != 'undefined')
			this.__eBody.style.height = Math.min(this.__totalFilteredRows || Number.MAX_SAFE_INTEGER, this.__total, this.__totalRows || Number.MAX_SAFE_INTEGER) * this._row_height + Object.keys(this.__separators).length * this._separator_height + 'px';
	}
	// Show No Items Warning
	this._getAnchor('noitems').style.display = tmp?'none':'block';
	aCols = null;

	this.__sbar_init(this.__eContainer2,true);

	//Resize keeper
	if (!this.__reizeInterval && this.__check_size){
		var me = this;
		this._add_destructor('__clearInterval');
		this.__reizeInterval = setInterval(function() {
			!me._destructed && me.__check_size && me.__check_size();
		}, 2000);
	}

	//classic datagrid, If selected rows missing call onchange
	if (bChange){
		if (this._onchange)
			this._onchange(this.__value);

		this.__exeEvent('onchange',null,{"value":this.__value,"owner":this});
	}

	//select position
	if (this.__selectByPosition)
		this._selectPosition();

	if (this._select_all) {
		tmp = this._value();
		this._value(tmp.concat(Object.getOwnPropertyNames(aData)));
	}
};

_me._selectPosition = function(sbp){
	sbp = sbp || this.__selectByPosition;

	if (sbp){
		var sCol;
		this.__selectByPosition = ''; //can be safer

		if (this.__small)
			sCol = '*';
		else
		for(sCol in this._aCols)
			break;

		if (sCol){

			var elm, pos, pid, box = getSize(this.__eContainer2);

			for(var id in this._aData){
				if ((elm = document.getElementById(this._pathName +'/'+ id +'/'+ sCol))){
					pos = getSize(elm);
					switch (sbp){
						case 'top':
							if (pos.y>=box.y) {
								this._value([id]);
								return;
							}
							break;

						case 'bottom':
							if (pos.y+pos.h<=box.y+box.h)
								pid = id;
							else
							if (pid){
								this._value([pid]);
								return;
							}
							break;

						default:
							return;
					}
				}
			}

			if (pid)
				this._value([pid]);
		}
	}
};

_me.__clearInterval = function(){
	if (typeof this.__reizeInterval != 'undefined')
	    clearInterval(this.__reizeInterval);
};

_me._listen_data = function(sDataSet,aDataPath,bNoUpdate){
	this._listener_data = sDataSet;
	if (typeof aDataPath == 'object') this._listenerPath_data = aDataPath;
	dataSet.obey(this,'_listener_data',sDataSet,bNoUpdate);
};

/**
 * Updates headers to reflect current sort column and order
 *
 * @returns {void}
 */
_me.__refreshHeaders = function () {
	var i, headers, header;

	headers = this.__eHeader.childNodes;
	for (i = 0; i < headers.length; i++) {
		header = headers[i];
		removecss(header, 'desc', 'asc');
		if (-1 !== this.__getId(header.id, '#').indexOf(this.__sortColumn)) {
			addcss(header, this.__sortType ? 'desc' : 'asc');
		}
	}
};

_me.__update = function(){};
