_me = obj_datagrid2_ext.prototype;
function obj_datagrid2_ext(){};

_me.__constructor = async function() {
	await storage.library('short_url');
	this._getAnchor('clear').onclick = function() {
		var query = '';
		if (~(this.__filter.search || '').indexOf('+folders:"all"')) {
			query = '+folders:"all"';
		}
		if (~(this.__filter.search || '').indexOf('+folders:"subtree"')) {
			query = '+folders:"subtree"';
		}
		var aFolder = this._getFolder();
		if (dataSet.get('folders', [aFolder.aid, aFolder.fid, 'ARCHIVE']) && !dataSet.get('main', ['disable_genuine']) && !!~(this.__filter.search || '').indexOf('+is:"genuine"')) {
			query = ' +is:"genuine"';
		}
		gui.frm_main.search._value(query.trim());
	}.bind(this);
};

//////////// Drag & Drop ////////////////////

/**
 * start drag&drop action
 *
 * Note: selected data (rows) are in this.__valueData and also in global dataSet
 *
 * @param {string} id - selected ID; in this.__value there is an array of selected IDs
 * @param {number} x
 * @param {number} y
 */
_me.__initdrag = async function(id, x, y) {
	//Check if ID is already in selection, if not make new one
	if (inArray(this.__value, id) < 0) {
		this._value([id]);
	}

	//prepare data
	var
		out = [],
		f = this._getFolder(),
		aRights = WMFolders.getAccess(f),
		data, rowData, i, j, ds;

	for (i in this.__valueData) {
		data = this.__valueData[i];
		if (!data) {
			continue;
		}

		// update data from dataSet - e.g. when drag&drop currently renamed document
		rowData = data.data || {};
		ds = dataSet.get('items', [f.aid, f.fid, i]);
		for (j in ds) {
			rowData[j] = ds[j];
		}

		// prepare "out" array for drag&drop action (data)
		var aOut = typeof data == 'object' && data.arg ? clone(data.arg) : {iid: id, aid: f.aid};
		aOut.fid = this._aFolder.fid;
		aOut.orig_fid = f.fid;

		aOut.size = rowData.EVNCOMPLETE || rowData.SIZE;
		aOut.name = rowData.SUBJECT || rowData.EVNTITLE || rowData.ITMCLASSIFYAS;
		switch(WMFolders.getType(f)) {
			case 'M':
				aOut.icon_type = 'email';
				aOut.folder = rowData.FROM === sPrimaryAccount ? rowData.TO : rowData.FROM;
				break;
			case 'C':
				aOut.folder = rowData.LCTEMAIL1;
				aOut.icon = obj_avatar.getAvatarHTML({
					contactId: i,
					name: aOut.name,
					size: 48
				});
				aOut.type = 'contact';
				break;
			case 'E':
				aOut.icon_type = 'event';
				aOut.folder = this.__parseGwTime(rowData.EVNSTARTDATE, rowData.EVNSTARTTIME);
				break;
			case 'T':
				aOut.icon_type = 'task';
				break;
		}
		out.push(aOut);
	}

	//create Drag box
	if (out.length > 0) {
		gui.frm_main.dnd.create_drag({
			type: this.__dragtype,
			value: out,
			x: x,
			y: y,
			ctrlKey: !aRights.remove,
			obj: this
		});

		if (!gui.frm_main._folderPickerIsOpen()) {
			var tree = gui.frm_main.bar._main;

			this.__folder_tree_popup = await this._gui._create('this.__folder_tree_popup', 'obj_context', '', 'dnd_folders');
			this.__folder_tree_popup._main.addEventListener('click', function(e) {
				gui.cmenu && gui.cmenu._destruct();
				e.stopPropagation();
			});
			this.__folder_tree_popup._onclose = function(bClose, e){
				if (e && gui.cmenu && Is.Child(e.target, gui.cmenu._main)) {
					return false;
				}
				gui.frm_main._getAnchor('bar').appendChild(tree);
				if (bClose && !Is.Child(e.target, this.__folder_tree_popup._main)) {
					this.__folder_tree_popup._destruct();
				}
				return false;
			}.bind(this);

			this.__folder_tree_popup._fill([{
				element: tree,
				css: 'tree',
				keep: true
			}]);

			var pos = getSize(gui.frm_main.main.list._main);
			var width = Cookie.get(['vertical_slider',screen.width+'x'+screen.height]) || 260;
			if (gui._rtl) {
				this.__folder_tree_popup._place(pos.x - 12 - width, pos.y + 17, width);
			} else {
				this.__folder_tree_popup._place(pos.x + pos.w - 4, pos.y + 17, width);
			}
			this.__folder_tree_popup._main.style.width = width + 'px';

			[].forEach.call(tree.querySelectorAll('.maxbox'), function(scroll) {
				scroll.scrollTop = scroll.getAttribute('data-top') || 0;
			});

			this.__folder_tree_popup._main.addEventListener('mousemove', function() {
				clearTimeout(this.__mouseovertimeout);
				this.__mouseovertimeout = setTimeout(function() {
					this.__folder_tree_popup._focus();
				}.bind(this), 500);
			}.bind(this));
			this.__folder_tree_popup._main.addEventListener('mouseout', function() {
				clearTimeout(this.__mouseovertimeout);
			}.bind(this));
		}

	}
};

_me._ondragend = function() {
	gui.frm_main.bar.search._disabled(false);

	this.__folder_tree_popup && this.__folder_tree_popup._destruct();
};

/**
 * returns html safe string from given string
 *
 * @param {string} value
 * @return {string} html safe string
 */
_me.__getEscapedString = function(value) {
	value = value && typeof value === 'string' ? value : '';
	return value.escapeHTML();
};

/**
 * returns html safe string from given array
 *
 * @param {array} array
 * @return {string} html safe string
 */
_me.__getEscapedArrayString = function(array) {
	var value = array && typeof array === 'object' && typeof array[0] === 'string' ? array[0] : '';
	return value.escapeHTML();
};


//////////// EVENTs ////////////////////


_me._onchange = function(ids, bTimer) {

	var aFolder = this._getFolder();
	gui.__exeEvent('itemSelected', [aFolder.aid, aFolder.fid].concat(ids.length?[ids]:[]));

	// Auto Preview Item
	if (this.__cursortimer){
		window.clearTimeout(this.__cursortimer);
		delete this.__cursortimer;
	}

	var v = this._value();
	if (v.length == 1){
		if (bTimer === false) {
			return this.__selectItem();
		}

		this.__cursortimer = window.setTimeout(this.__selectItem.bind(this), GWOthers.getItem('LAYOUT_SETTINGS', 'PREVIEW_DELAY'));
	}
};

_me.__selectItem = function() {
	if (this._destructed) {
		return;
	}
	try{
		if (this.__value[0]){
			var data = this._aData[this.__value[0]];
			if (data){
				var arg = data.arg || {};

				if (this._onclick)
					this._onclick({type:'click',button:1},null,arg,this.__value[this.__value.length-1],null,[]);

				this.__exeEvent('onclick',null,{"arg":arg,"id":data.id,"owner":this});
			}
		}
	}catch(er){ console.log(this._name||false,er)}
};

// Handle double click on items
_me._ondblclick = async function(e,elm,arg){

	var sType = WMFolders.getType(arg);
	if (!elm){
		if (arg && arg['aid'] && arg['fid']){
			var aValues;
			switch(sType){
				case 'E':
				   	aValues = getCurrentEventTime();
				case 'C':
				case 'L':
				case 'T':
				case 'J':
				case 'F':
				case 'N':
					if (WMFolders.getAccess(arg,'write'))
						Item.createInFolder(arg['aid'],arg['fid'],aValues);
				break;
				case 'M':
					var aOpt = {alias:Item.getAliasFromPath(arg['aid'] +'/'+ arg['fid'])};
					if (arg['aid'] +'/'+ arg['fid'] == GWOthers.getItem('DEFAULT_FOLDERS','templates'))
						aOpt.template = true;

					NewMessage.compose(aOpt);
					break;

				case 'QL':
					gui._create('frm_blackwhite', 'frm_blackwhite', '', '', arg['aid'], arg['fid']);
			}
		}
		return;
	}

	if (elm.classList.contains('edit')) {
		return;
	}

	if (sType == 'C' && dataSet.get('items',[arg['aid'],arg['fid'],arg['iid'],'ITMCLASS']) == 'L')
		sType = 'L';

	if (sType == 'G')
    	Item.recover([arg['aid'],arg['fid'],[arg['iid']]],true);
	else
	if (sType == 'M' || sType == 'Q') {
		arg.aid = (dataSet.get('items', [arg.aid, arg.fid, arg.iid]) || {}).ORIGINALACCOUNT || arg.aid;
		arg.fid = (dataSet.get('items', [arg.aid, arg.fid, arg.iid]) || {}).ORIGINALFOLDER || arg.fid;
		if (GWOthers.getItem('DEFAULT_FOLDERS', 'drafts') == arg['aid']+'/'+arg['fid'])
			OldMessage.edit([arg['aid'], arg['fid'], arg['iid']]);
		else if(GWOthers.getItem('DEFAULT_FOLDERS', 'templates') == arg['aid']+'/'+arg['fid']) {
			var old = new OldMessage();
			await old.init([arg['aid'], arg['fid'], arg['iid']]);
			NewMessage.compose(old);
		}else{

			//Prev|Next
			var aSortInfo = clone(this.__filter);
				aSortInfo.offset = this.__limit[0];
				aSortInfo.limit = this.__limit[1];

			if (this.__small)
				aSortInfo.row = Math.ceil(parseInt(elm.parentNode.style.top || elm.style.top,10)/this._row_height)-this.__offset;
			else
				aSortInfo.row = Math.ceil(parseInt(elm.style.top,10)/this._row_height)-this.__offset;

			OldMessage.openwindow([arg['aid'], arg['fid'], arg['iid']], aSortInfo);
		}
	}
	else
	if (sType == 'F'){
		Item.previewItem(arg);
	}
	else
	if (sType != 'QL')
		Item.openwindow([arg['aid'],arg['fid'],arg['iid']],'','',sType);
};

// Handle right click context menu on item
_me._oncontext = async function(e,elm,arg,sLineId,sColumn){
	var sType;

	//Klikly jsme na místo bez položek?
	if (!arg || !arg['iid']){
		var aItems = dataSet.get('items');

		for(var sAccId in aItems)
			for(var sFolId in aItems[sAccId])
			    break;

		arg = {'aid':sAccId,'fid':sFolId};

		if ((sType = WMFolders.getType(arg))){
			await gui._create("cmenu","obj_context_item",'','',this);
			gui.cmenu._oUpload = this._parent._upload;
			await gui.cmenu._fillGeneralMenu(sType,arg);
		}
		else
			return;
	}
	else
	if ((sType = WMFolders.getType(arg))){
		var aSelected = this._value(),
			bDisableOpen = false;

		if (sType == 'C' && dataSet.get('items',[arg['aid'],arg['fid'],arg['iid'],'ITMCLASS']) == 'L')
			sType = 'L';

		arg.data = dataSet.get('items', [arg.aid, arg.fid, arg.iid]);
		var iid = arg.iid;
		if (arg.data && arg.data.ORIGINALFOLDER) {
			iid = arg.data.ORIGINALACCOUNT + '/' + arg.data.ORIGINALFOLDER + '/' + arg.iid;
		}

		if (inArray(aSelected, iid) >= 0 && aSelected.length > 1)
			bDisableOpen = true;

		if (inArray(aSelected, iid) < 0){
			aSelected = [arg.iid];
		}

		aSelected = aSelected.map(function(aSelected) {
			return Path.basename(aSelected);
		});

		await gui._create("cmenu","obj_context_item",'','',this);
		await gui.cmenu._fillMenu(sType,arg,aSelected,bDisableOpen,false,sColumn);
		gui.cmenu._add_destructor('__onclose');
		gui.cmenu.__onclose = function() {
			this._active([]);
		}.bind(this);
		this._active(aSelected);
	}
	else
		return;

	gui.cmenu._place(e.clientX,e.clientY);
};

_me._onmouseover = function(e, elm, arg, sId, column) {
	switch(WMFolders.getType(arg)) {
		case 'F':
			clearTimeout(this['__sharingToolbarShow' + sId]);
			clearTimeout(this['__sharingToolbarHide' + sId]);
			this['__sharingToolbarShow' + sId] = setTimeout(function() {
				this._init_controls(sId, 'SMART', {}, arg);
				delete this['__sharingToolbarShow' + sId];
			}.bind(this), 5);
	}
};

_me._onmouseout = function(e, elm, arg, sId) {
	switch(WMFolders.getType(arg)) {
		case 'F':
			clearTimeout(this['__sharingToolbarShow' + sId]);
			clearTimeout(this['__sharingToolbarHide' + sId]);
			this['__sharingToolbarHide' + sId] = setTimeout(function() {
				this._init_controls();
				delete this['__sharingToolbarHide' + sId];
			}.bind(this), 5);
	}
};

_me._init_controls = async function(sId, column, options, arg) {
	if (options && document.getElementById(this._pathName + '/' + sId + '/' + column)){
		if (!this.controls) {
			var aData = dataSet.get('items', [arg.aid, arg.fid, sId]);
			if (!aData) {
				return;
			}

			var copy_link = aData.EVNURL && (GWOthers.getItem('RESTRICTIONS', 'disable_shareable_link') != 1) && {
				id: 'smart_link',
				tooltip: getLang('UPLOAD_DETAIL::COPY_LINK'),
				callback: [function() {
					toClipboard({
						'text/plain': aData.EVNURL
					});
				}.bind(this)]
			};

			var share = !aData.EVNURL && !aData.EVNDOCINVITE && !options.sharing && {
				id: 'smart_share',
				tooltip: getLang('UPLOAD_DETAIL::SHARE'),
				callback: [async function() {
					await this.controls._destruct();
					options.sharing = true;
					this._init_controls(sId, column, options, arg);
					
					var password = '';
					if (GWOthers.getItem('RESTRICTIONS', 'force_sharing_password')) {
						await storage.library('wordGen', 'wordGen');
						password = (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10);
					}

					TeamChatAPI.filesInvite({ id: WMItems.__serverID(sId), editable: false, password: password }, {
						success: async function (response) {
							if (ShortURL.matches(response.inviteticket)) {
								dataSet.add('items', [arg.aid, arg.fid, sId, 'EVNURL'], response.inviteticket);
							}
							dataSet.add('items', [arg.aid, arg.fid, sId, 'EVNDOCINVITE'], 1);
							options.sharing = false;

							if (this.controls) {
								await this.controls._destruct();
								this._init_controls(sId, column, options, arg);
							}
						},
						context: this
					});
				}.bind(this)]
			};

			var sharing_options = (aData.EVNURL || aData.EVNDOCINVITE) && {
				id: 'smart_settings',
				tooltip: getLang('UPLOAD_DETAIL::SETTINGS'),
				callback: [function() {
					Item.collaborate([sPrimaryAccount, Path.slash(arg.fid), sId]);
				}.bind(this)]
			};

			var share_loading = options.sharing && {
				loading: true
			};

			var download = {
				id: 'download',
				tooltip: getLang('POPUP_ITEMS::DOWNLOAD_FILE'),
				callback: [function() {
					Item.downloadFile([arg.aid, arg.fid, sId]);
				}.bind(this)]
			};

			var isPinnedItem = gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._isPinnedItem({ aid: arg.aid, fid: arg.fid, iid: sId, type: 'file' });
			var dashboard_pin = gui.frm_main._dashboardLoaded() && {
				id: 'dashboard_pin',
				tooltip: isPinnedItem ? getLang('POPUP_ITEMS::UNPIN_FROM_DASHBOARD') : getLang('POPUP_ITEMS::PIN_TO_DASHBOARD'),
				class: isPinnedItem ? 'active' : '',
				callback: [async function() {
					gui.frm_main.dashboard[isPinnedItem ? '_unpinItem' : '_pinItem']({
						aid: arg.aid,
						fid: arg.fid,
						iid: sId,
						type: 'file'
					}, document.getElementById(this._pathName + '/' + sId + '/*'));

					if (this.controls) {
						await this.controls._destruct();
						this._init_controls(sId, column, options, arg);
					}
				}.bind(this)]
			};

			var remove = {
				id: 'delete',
				tooltip: getLang('FORM_BUTTONS::REMOVE'),
				callback: [function() {
					this.__deleteItems(arg, [sId]);
				}.bind(this)]
			};

			var tracking = !(this.__small && GWOthers.getItem('LAYOUT_SETTINGS','compact_view') == 0) && aData.EVNURL && ShortURL.matches(aData.EVNURL) && {
				id: 'smart_tracking',
				tooltip: getLang('UPLOAD_DETAIL::TRACKING'),
				callback: [function() {
					gui.frm_main.rslide.upload_detail._init({fid: arg.fid, iid: sId});
					gui.frm_main.rslide._value('upload_detail');
				}.bind(this)]
			};

			await this._create('controls', 'obj_tch_control', '', (!this.__small && GWOthers.getItem('LAYOUT_SETTINGS','compact_view') == 0) ? '' : 'small', [
				tracking,
				copy_link,
				share,
				share_loading,
				sharing_options,
				download,
				dashboard_pin,
				remove
			]);

			var item = document.getElementById(this._pathName + '/' + sId + '/*');
			if (this.__small && GWOthers.getItem('LAYOUT_SETTINGS','compact_view') == 0) {
				var bcr = this._main.getBoundingClientRect();
				var bcr2 = item.getBoundingClientRect();
				this.controls._main.style.top = bcr2.top - bcr.top - 12 + 'px';
				if (gui._rtl) {
					this.controls._main.style.left = '8px';
				} else {
					this.controls._main.style.right = '8px';
				}
			} else {
				document.getElementById(this._pathName + '/' + sId + '/' + column).appendChild(this.controls._main);
			}
			this.controls._main.addEventListener('mouseenter', function() {
				clearTimeout(this['__sharingToolbarHide' + sId]);
				item && item.classList.add('active2');
				if (this.__highlightHover) {
					this.__highlightHover.style.display = 'block';
					this.__highlightHover.style.top = document.getElementById(this._pathName + '/' + encodeURIComponent(sId) + '/' + column).style.top;
				}
			}.bind(this));
			this.controls._main.addEventListener('mouseleave', function() {
				this['__sharingToolbarHide' + sId] = setTimeout(function() {
					this._init_controls();
				}.bind(this), 5);
				item && item.classList.remove('active2');
				if (this.__highlightHover) {
					this.__highlightHover.style.display = 'none';
				}
			}.bind(this));
		}
		this.controls._show();

	} else if (this.controls) {
		this.controls._destruct();
		delete this.controls;
	}
};

_me._onclick = async function(e,elm,arg,line,column,aClickType)
{
	e.preventDefault && e.preventDefault();
	e.stopPropagation && e.stopPropagation();
	if (gui.cmenu && e.stopPropagation) {
		await gui.cmenu._destruct();
	}
	if (inArray(aClickType,'SHIFT') > -1 || inArray(aClickType,'CTRL') > -1)
		return;

	var sType = WMFolders.getType(arg);
	if (sType == 'C' && dataSet.get('items',[arg['aid'],arg['fid'],arg['iid'],'ITMCLASS']) == 'L')
		sType = 'L';

	var aAccess = WMFolders.getAccess(arg);

	if (column == 'DELETE' && aAccess.modify) {
		this.__deleteItems(arg,[arg['iid']]);
		return false;
	}

	switch (sType) {
		case 'T':
			if (column == 'CHECK') {
				if (aAccess.modify){
					var stat = 'M';
					if (dataSet.get('items',[arg['aid'],arg['fid'],arg['iid'],'EVNSTATUS'])=='M')
						stat = 'B';

					var me = this;
					dataSet.add('items', [arg['aid'], arg['fid'], arg['iid'], 'EVNSTATUS'], stat);
					WMItems.add([arg['aid'], arg['fid'], arg['iid']], {'values': {'EVNSTATUS': stat}},'','','',[function() {
						if (me && !me._destructed) {
							me._serverSort(void 0, void 0, void 0, void 0, void 0, true, true);
						}
					}]);
				}
				break;
			}

		case 'F':
			if (column == 'SMART' && dataSet.get('items',[arg.aid, arg.fid, arg.iid, 'EVNURL'])) {
				gui.frm_main.rslide.upload_detail._init({fid: arg.fid, iid: arg.iid});
				gui.frm_main.rslide._value('upload_detail');
				return false;
			}
		case 'C':
		case 'L':
		case 'E':
		case 'J':
		case 'N':
		case 'G':

			//Execute Edit dialog on Enter
			if ((gui.frm_main && gui.frm_main.main && gui.frm_main.main.itemview) || (e.type == 'keydown' && e.keyCode == 13))
				Item.open([arg['aid'],arg['fid'],arg['iid']]);

			break;

		case 'Q':
		case 'M':
			if (column == 'COLOR' && aAccess.modify) {
				var id = [arg['aid'],arg['fid'],arg['iid']];
				var sColor = OldMessage.getColor(id);

				if (!sColor || sColor == Item.COLORS.COMPLETE || sColor == Item.COLORS.CLEAR) {
					await storage.library('gw_others');
					var sDefaultColor = GWOthers.getItem('MAIL_SETTINGS_GENERAL','default_flag');

					OldMessage.setColor(id, sDefaultColor);
				}
				else
					OldMessage.setColor(id, Item.COLORS.COMPLETE);

				return false;
			}

			if (column === null && (e.ctrlKey || e.metaKey))
				OldMessage.openwindow([arg['aid'], arg['fid'], arg['iid']]);
			else{
				dataSet.add('active_items',[arg['aid'],arg['fid']],arg['iid']);

				var mailview = gui.frm_main.main.mailview;
				if (mailview){
					if (mailview.__aid !== arg.aid || mailview.__fid !== arg.fid || mailview.__iid !== arg.iid) {
						mailview._value();
						OldMessage.open([arg.aid, arg.fid, arg.iid]);
					} else {
						mailview._highlight();
					}
				}
				else
				if (e.type == 'keydown' && e.keyCode == 13){

					//Prev|Next
					var aSortInfo;
					column = column || this.__sortColumn;

					if (Is.Defined(column) && (elm = this.__getElement([line,column]))){
						aSortInfo = clone(this.__filter);
						aSortInfo.row = Math.ceil(parseInt(elm.style.top,10)/this._row_height)-this.__offset;
					}

					OldMessage.openwindow([arg['aid'], arg['fid'], arg['iid']], aSortInfo);
				}
			}

			break;
	}

	var aFolder = this._getFolder();
	gui.__exeEvent('itemSelected', [aFolder.aid, aFolder.fid].concat(arg['iid'].length?[arg['iid']]:[]));
};

_me._onkeydown = async function(e){
	// nacte vybrane radky
	var value = this._value().map(function(v) {
		return v.split('/').pop();
	});
	if (Is.Empty(value)) return;

	value = value.filter(function(v) {
		for (var i in this.__rowOffset) {
			if (this.__rowOffset[i].id === v) {
				return true;
			}
		}
	}, this);

	if (!value.length) {
		return;
	}

	//ziska sFolId a sAccId
	var popup, i,
		aFolder = this._getFolder(),
		sAccId = aFolder.aid,
		sFolId = aFolder.fid,
		sType = WMFolders.getType([sAccId,sFolId]),
		static_flags = dataSet.get('items', [sAccId, sFolId, value[0], 'STATIC_FLAGS']);

	//numbers as Flags
	if ((e.keyCode>95 && e.keyCode<106) || (e.keyCode==107 || e.keyCode==109)){
		var color, colors;
		if (e.keyCode==107)
			color = 'COMPLETE';
		else
		if (e.keyCode==109)
			color = 'CLEAR';
		else{
			if (sType == 'M')
				colors = ['RED','BLUE','GREEN','ORANGE','PURPLE','YELLOW'];
			else
			if (sType == 'N')
				colors = ['BLUE','GREEN','RED','','GREY','YELLOW'];
			else
				colors = ['RED','BLUE','GREEN','GREY','ORANGE','CYAN','BROWN','PURPLE','LIGHT_BLUE','YELLOW'];

			if(!(color = colors[e.keyCode-96])) return;
		}

		for(i in value)
			if (sType == 'M')
				OldMessage.setColor([sAccId,sFolId,value[i]], Item.COLORS[color]);
			else
			if (WMFolders.getAccess({aid:sAccId,fid:sFolId},'modify'))
				Item.setColor([sAccId,sFolId,value[i]], Item.COLORS[color]);
	}
	else
	if (!e.ctrlKey && !e.metaKey)
	switch(e.keyCode){
	case 82:
		//r - Reply or Reply All
	    if (sType=='M' && !(static_flags & 16)) {
			OldMessage.reply({
				id: [sAccId,sFolId,value[0]],
				bReplyToAll: e.shiftKey
			});
			e.preventDefault();
		}
		break;
	case 70:
		//f - Forward or FW as attachment
	    if (sType=='M' && !(static_flags & 8))
			OldMessage.forward({
				id: [sAccId,sFolId,value[0]],
				bForwardAsMessage: e.shiftKey
			});
		break;
	case 78: //n - New
	    if (sType=='M'){
			var aOpt = {alias:Item.getAliasFromPath(sAccId +'/'+ sFolId)};
			if (sAccId +'/'+ sFolId == GWOthers.getItem('DEFAULT_FOLDERS','templates'))
				aOpt.template = true;

			NewMessage.compose(aOpt);
		}
	    break;
	case 67: //c - Copy
		popup = await Item.copy([sAccId,sFolId,value], this);
		popup.__returnFocus = function() {
			this._focus();
		}.bind(this);
		popup._add_destructor('__returnFocus');
	    break;
	case 77: //m - Move
 		if (sType!='M' && !WMFolders.getAccess({aid:sAccId,fid:sFolId},'remove')) break;

		var selected = !Mapping.isGlobalSearchFolder(sFolId) && this._value().map(function(v) {
			return v.split('/').pop();
		}).filter(function(n) {
			return ~value.indexOf(n);
		})[0];
		var next = selected ? this.__getNext(value) : void 0;

		setTimeout(async function() {
			popup = await Item.move([sAccId,sFolId,value, this._SQLsearch], this, next);
			popup.__returnFocus = function() {
				this._focus();
			}.bind(this);
			popup._add_destructor('__returnFocus');
		}.bind(this), 5);
	    break;
	case 69: //e - Read
		if (sType=='M') {
			if (this._select_all) {
				Folder.markRead({aid: sAccId, fid: sFolId});
			} else {
				OldMessage.markAsRead([sAccId,sFolId,value]);
			}
		}
		break;
		case 85: //u - Unread
		if (sType=='M') {
			if (this._select_all) {
				Folder.markUnread({aid: sAccId, fid: sFolId});
			} else {
				for(i in value) {
					OldMessage.markAsUnread([sAccId,sFolId,value]);
				}
			}
		}
	    break;
	case 84: //t - Tag manager
		if (!this._select_all) {
			Item.tags([sAccId,sFolId,value]);
		}
		break;
	case 87: //w - reply With template
		if (!this._select_all && value.length === 1 && ((sAccId + '/' + sFolId) !== GWOthers.getItem('DEFAULT_FOLDERS', 'sent'))) {
			OldMessage.replyTemplate([sAccId,sFolId,value[0]], e.shiftKey);
		}
		break;
	case 46: //delete
        this.__deleteItems(aFolder,value,e.shiftKey);
	}
};

_me.__deleteItems = function(aFolder,value,shiftKey,oRepeating){
	var sType = WMFolders.getType(aFolder);
	if (sType!='Q' && sType!='QL' && !WMFolders.getAccess(aFolder,'remove')){
		gui.notifier._value({type: 'alert', args: {header: '', text: 'ALERTS::DELETE_ITEM'}});
		return;
	}
	if (sType === 'G' && dataSet.get('main',['keep_deleted_items_force_expiration'])) {
		return;
	}

	var selected = this._value().map(function(v) {
		return v.split('/').pop();
	}).filter(function(n) {
		return ~value.indexOf(n);
	})[0];
	var next = selected ? this.__getNext(value) : void 0;

	if (shiftKey && !Is.Object(oRepeating)) {
		return gui._create('frm_confirm', 'frm_confirm_suppress', '', 'frm_trash', [Item.remove, [[aFolder.aid, aFolder.fid, value, this._SQLsearch],shiftKey,oRepeating,this,next]],'CONFIRMATION::DELETE_ITEM_CONFIRMATION','CONFIRMATION::DELETE_ITEM');
	}

	Item.remove([aFolder.aid, aFolder.fid, value, this._SQLsearch],shiftKey,oRepeating,this,next);
};

_me.__getNext = function(value) {
	var found = false;
	var iNext, iPrev;
	for (var i in this.__rowOffset) {
		if (this.__rowOffset[i] && this.__rowOffset[i].aData && this.__rowOffset[i].aData.skeleton) {
			continue;
		}
		if (found) {
			iNext = this.__rowOffset[i].id;
			found = false;
		} else if (!~value.indexOf(this.__rowOffset[i].id)) {
			iPrev = this.__rowOffset[i].id;
		}
		if (~value.indexOf(this.__rowOffset[i].id)) {
			found = true;
		}
	}

	return iNext || iPrev;
}