_me = obj_datagrid2.prototype;
function obj_datagrid2(){};

_me.__constructor = async function(bDontListen){
	var me = this;

	this._cookiesEnabled = true;

	//data vars
	this._aFolder = null;   	//set in serverSort
	this._aFolderLast = null;   //set in Update

	this.__total = -1;
	this.__totalRows = 0;
	this.__totalFilteredRows = 0;
	this.__offset = 0;
	this.__preload = 20;

	this._SQLsearch = '';
	this._SQLfulltext = '';

	this.__limit = [0,0];

	//view vars
	this.__row_count = 0;
	this.__row_offset = 0;

	this.__includeIds = [];

	//Listen to items dataset
	if (!bDontListen)
		this._listen_data('items','',true); //listen but do not update immediately


	//*** SCROLLING
	this.__iScroll_left = 0;
	this.__iScroll_top = -1;
	this.__eContainer2.onscroll = function(){
		if (me.__preloading) {
			return;
		}

		if (me.__iScroll_left != this.scrollLeft){
			me.__iScroll_left = this.scrollLeft;

			if(gui._rtl && this.scrollRight)
				me.__eHeader.style.marginRight = -this.scrollRight+'px';
			else
				me.__eHeader.style.marginLeft = -me.__iScroll_left+'px';
		}

		//LIMIT
		var pre1 = me.__preload,pre2 = me.__preload,r = me.__getRange();
		if (me.__limit[1]<=me.__limit[0] || (r[0]+r[1]>me.__limit[1]-10 && me.__limit[1]<me.__total) || (r[0]<me.__limit[0]+10 && me.__limit[0]>0)){
			// add another +10 items to scroll end
			if (me.__iScroll_top>-1){
				if (me.__iScroll_top > this.scrollTop) {
					pre1 += 10;
				} else {
					pre2 += 10;
				}
			}

			me.__limit[0] = r[0]>pre1?r[0]-pre1:0;
			me.__limit[1] = r[0] + r[1] + pre2;

			me.__offset = me.__limit[0];

			clearTimeout(this.__scrollTimeout);
			this.__scrollTimeout = setTimeout(function() {
				me._serverSort(false, false, false, false, false, false, true);
			}, 10);
		}
		else
		if (me.__iScroll_top > -1 && (me.__iScroll_top != this.scrollTop)){
			clearTimeout(this.__scrollTimeout);
			this.__scrollTimeout = setTimeout(function() {
				me._serverSort(false, false, false, false, false, false, true);
			}, 10);
		}
		else
		if (me.__selectByPosition) {
			me._selectPosition();
		}

		if (me.__iScroll_top != this.scrollTop)
			me.__iScroll_top = this.scrollTop;
	};

	// rerender datagrid on midnight because of item separators
	var d;
	this.__midnightTimeout = setTimeout(function() {
		if (me.__separators && Object.keys(me.__separators)) {
			me._serverSort(false, false, false, false, false, true, true);
		}
	}, -(d = new Date()) + d.setHours(24, 0, 0, 0) + 5000);

	this._add_destructor('__clearMidnightTimeout');

	gui._obeyEvent('tagUpdate', [this, '__onTagUpdate']);
};

_me.__onTagUpdate = function(tag) {
	var NM = NightMode();
	var invertStyleProperty = NM.invertStyleProperty.bind(NM);
	[].forEach.call(this._main.querySelectorAll('[data-tag="' + tag.ID + '"]'), function(el) {
		var tagColor = tag.TAGCOLOR;
		var textColor = tag.TEXTCOLOR || '#000000';
		var id = el.getAttribute('id');
		if (dataSet.get('main', ['night_mode_enabled'])) {
			var inverted = invertStyleProperty('color', textColor);
			id = inverted.id;
			textColor = inverted.color;
			inverted = tagColor ? invertStyleProperty('background-color', tagColor, id) : { id: id };
			id = inverted.id;
			tagColor = tagColor ? inverted.color : '';
		}
		id && el.setAttribute('id', id);
		el.style.color = textColor;
		el.style.backgroundColor = tagColor;
	});
};

_me.__clearMidnightTimeout = function() {
	this.__midnightTimeout && clearTimeout(this.__midnightTimeout);
	clearTimeout(this.__xhrTimeout);
	gui._disobeyEvent('tagUpdate', [this, '__onTagUpdate']);
};

/**
 * Load rest of values when datagrid height extended
 **/
_me.__check_size = function(){
	var h = this.__eContainer2.offsetHeight;
	if (this.__lastHeight && this.__lastHeight != h)
		this.__eContainer2.onscroll();

	this.__lastHeight = h;
};

_me._default_values = function (sFolType){
	return WMItems.default_values(sFolType);
};

_me._default_columns = async function (sFolType, aOptions){
	var aDefaultColumns = {},
		smallOptions,
		id = this._getFolder() || {}

	this.__aOptions = aOptions = Object.assign({
		bForceSingleLineRows: GWOthers.getItem('HIDDEN_COLUMNS', 'FORCE_SINGLE_LINE_ROWS') > 0,
		view: Cookie.get(['views', id.aid, id.fid, 'view']) || 'wide',
		folder: null,
		// searchInAllFolders: false
	}, aOptions || {});

	var aFolder = aOptions.folder;
	if (!aFolder) {
		aFolder = dataSet.get('folders',[id.aid, id.fid]) || {};
		aFolder.aid = id.aid;
		aFolder.fid = id.fid;
	}

	var searchInAllFolders = (this.__aOptions.searchInAllFolders === void 0 ? ~(this._SQLsearch || '').indexOf('+folders:"') && (this._SQLsearch || '').replace(/\+folders:".*?"/, '').replace(/is:unread/, '').trim().replace('()', '') : this.__aOptions.searchInAllFolders) || aFolder.VIRTUAL;
	switch(sFolType){
		case 'C':
			aDefaultColumns = {
				AVATAR: {width: 40,css: 'avatar static refresh',"type":'static',text: '',display: 'all'},
				ITMCLASS: {width: 40,arg: {sort: 'asc'},css: 'ico contact',"type":'static',"text":'&nbsp;',encode:true},
				ITMCLASSIFYAS: {width: 40,mode:'%',arg: {sort: 'asc'},display: 'all'},
				ITMCOMPANY: {width: 30,mode:'%',arg: {sort: 'asc'},encode:true,display: 'all', hideColumnFor: ['small']},
				CONTACT_EMAIL: {width: 30,mode:'%',arg: {sort: 'asc'},encode:true,display: 'all'},
				ITMSURNAME: {arg: {sort: 'asc'},display: 'all', hideColumnFor: ['small', 'all']},
				PHONE: {width: 190,encode:true,display: 'all'},
				ITMCATEGORY: {width: 200,css:'tags',arg: {sort: 'asc'}},
				DELETE: {width: 30,css: 'ico delete',"type":'static',text:'&nbsp;',display: 'all'}
			};

			smallOptions = {};

			break;

		case 'G':
			aDefaultColumns = {
				REFRESH: {width: 40,css: 'static refresh',type:'static',text: '',display: 'all'},
				ITMCLASS: {width: 30,arg: {sort: 'asc'},css: 'ico gw',"type":'static',"text":'&nbsp;'},
				ITMTITLE: {width: 100,mode:'%',css:'title',arg: {sort: 'asc'},encode:true},
				ITMORIGINALFOLDER: {width: 300,arg: {sort: 'asc'}, css: '', encode:true, type: 'static'},
				ITM_DELETED: {width: 100,arg: {sort: 'desc'}}
			};

			smallOptions = {sorting: void 0, rows: void 0};
			break;

		case 'E':

			if (aFolder.aid == sPrimaryAccount && aFolder.fid == '__@@VIRTUAL@@__/__@@EVENTS@@__')
				aDefaultColumns = {
					EVNFOLDER: {width: 40,css: 'evnfolder static refresh',"type":'static',"text":'&nbsp;',encode:true,display: 'all'},
					EVNTITLE: {width: 75,mode:'%',css:'indent title',arg: {sort: 'asc'},display: 'all'},
					REMINDER: {width: 30,css: 'ico reminder',arg: {sort: 'desc'},"text":'&nbsp;', display: 'all'},
					EVNLOCATION: {width: 25,mode:'%',arg: {sort: 'asc'},encode:true,display: 'all'},
					EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
					RECCURENCE: {width: 30,css: 'ico recurrence',arg: {sort: 'desc'},"text":'&nbsp;'},
					CONFERENCE: {width: 30,css: 'ico conference',arg: {sort: 'desc'},"text":'&nbsp;'},
					EVENT_STARTDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
					EVENT_ENDDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
					DELETE: {width: 30,css: 'ico delete',"type":'static',text:'&nbsp;',display: 'all'}
				};
			else
				aDefaultColumns = {
					REFRESH: {width: 40,css: 'static refresh',type:'static',text: '',display: 'all'},
					EVNTITLE: {width: 75,mode:'%',css:'title',arg: {sort: 'asc'},display: 'all'},
					EVNLOCATION: {width: 25,mode:'%',arg: {sort: 'asc'},encode:true,display: 'all'},
					REMINDER: {width: 30,css: 'ico reminder',arg: {sort: 'desc'},"text":'&nbsp;'},
					RECCURENCE: {width: 30,css: 'ico recurrence',arg: {sort: 'desc'},"text":'&nbsp;'},
					EVENT_STARTDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
					EVENT_ENDDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
					EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
					DELETE: {width: 30,css: 'ico delete',"type":'static',text:'&nbsp;',display: 'all'}
				};

				smallOptions = {};

			break;

		case 'J':
			aDefaultColumns = {
				REFRESH: {width: 40,css: 'static refresh',type:'static',text: '',display: 'all'},
				EVNTITLE: {width: 100,mode:'%',css:'title',arg: {sort: 'asc'},display: 'all'},
				EVENT_STARTDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
				EVENT_ENDDATE: {width: 120,arg: {sort: 'desc'},display: 'all'},
				EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
				DELETE: {width: 30,css: 'ico delete',"type":'static',text:'&nbsp;',display: 'all'}
			};

			smallOptions = {};

			break;

		case 'F':
		case 'K':
		case 'I':
			aDefaultColumns = {
				ico: {width:40, type:'static refresh', title:'',css:'file_type static ico refresh',display: 'all'},
				EVNFILENAME: {width: 60,mode:'%',arg: {sort: 'asc'},display: 'all',bidi: false},
				EVNFOLDER: {width: 200, arg: {}, css: 'originalFolder', hideColumnFor: [searchInAllFolders ? '' : 'user'], display: 'all', type: 'static'},
				SMART: {width: 30, type: 'static', title: '', css: 'ico smart', display: 'all'},
				EVNNOTE: {width: 40,mode:'%',arg: {sort: 'asc'},encode:true},
				EVN_MODIFIED: {width: 120,arg: {sort: 'desc'},display: 'all'},
				EVNFILESIZE: {width: 70,arg: {sort: 'asc'},css: 'right',display: 'all'},
				EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
				DELETE: {width: 30,css: 'ico delete',"type":'static',text:'&nbsp;',display: 'all'}
			};

			smallOptions = {css:'task'};
			break;


		case 'M':
			var bSentArchive = (aFolder.aid+"/"+aFolder.fid).indexOf(dataSet.get('main',['archive_path'])+"/Sent/")===0;
			var bSentFolder = aFolder.DEFAULT === 'S' || aFolder.DEFAULT === 'D' || aFolder.DEFAULT === 'P' || bSentArchive || this.__isInSentFolder();
			if (aFolder.RSS)
				aDefaultColumns = {
					FLAGS: {width: 40,arg: {search: 'is:unread'},css: 'ico msg flags static refresh',"type":'static',display: 'all'},
					SUBJECT: {width: 75,mode:'%',arg: {sort: 'asc'},display: 'all', css:'subject'},
					FROM: {width: 25,mode:'%',arg: {sort: 'asc'},display: 'all', css:'from'},
					DATE: {width: 120,arg: {sort: 'desc'},css: 'right',display: 'all'},
					COLOR: {width: 30,arg: {sort: 'asc'},css: 'ico color',"type":'static',"text":'&nbsp;',title:'DATAGRID_ITEMS_VIEW::FLAGS',display: 'all'},
					DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'}};
			else
			if (aFolder.DEFAULT == 'H' || aFolder.SPAM === "true")
				aDefaultColumns = {
					FLAGS: {width: 40,css: 'priority ico static refresh flags',"type":'static',"text":'&nbsp;',display: 'all'},
					FROM: {width: 25,mode:'%',arg: {sort: 'asc'},display: 'all', css:'from'},
					SUBJECT: {width: 50,mode:'%',arg: {sort: 'asc'},display: 'all', css:'subject'},
					TO: {width: 25,mode:'%',arg: {sort: 'asc'}},
					ORIGINALFOLDER: {width: 200, arg: {}, css: 'originalFolder', hideColumnFor: [searchInAllFolders ? '' : 'user'], display: 'all', type: 'static'},
					DATE: {width: 100,arg: {sort: 'desc'},css: 'right',display: 'all'},
					ITEM_MOVED: {width: 100,arg: {sort: 'desc'},css: 'right'},
					SIZE: {width: 60,arg: {sort: 'desc'},css: 'right',display: 'all', hideColumnFor: ['small']},
					COLOR: {width: 30,arg: {sort: 'asc'},css: 'ico color',"type":'static',"text":'&nbsp;',title:'DATAGRID_ITEMS_VIEW::FLAGS',display: 'all'},
					HAS_ATTACHMENT: {width: 30,arg: {sort: 'desc'},css: 'ico attachment',"type":'static',"text":'&nbsp;',display: 'all'},
					DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'},
				};
			else
			if (bSentFolder) {
				sFolType = 'S'
				aDefaultColumns = {
					FLAGS: {width: 40,arg: {search: 'is:unread'},css: 'ico static refresh',"type":'static',"text":'&nbsp;',display: 'all'},
					PRIORITY: {width: 40,arg: {},css: 'priority ico msg flags static',"type":'static',"text":'&nbsp;',title: 'SETTINGS::PRIORITY',display: 'all', hideColumnFor: ['small']},
					TO: {width: 25,mode:'%',arg: {sort: 'asc'},display: 'all'},
					SUBJECT: {width: 50,mode:'%',arg: {sort: 'asc'},display: 'all', css:'subject'},
					FROM: {width: 25,mode:'%',arg: {sort: 'asc'}, css:'from'},
					ORIGINALFOLDER: {width: 200, arg: {}, css: 'originalFolder', hideColumnFor: [searchInAllFolders ? '' : 'user'], display: 'all', type: 'static'},
					DATE: {width: 100,arg: {sort: 'desc'},css: 'right',display: 'all'},
					SIZE: {width: 60,arg: {sort: 'desc'},css: 'right',display: 'all', hideColumnFor: ['small']},
					COLOR: {width: 30,arg: {sort: 'asc'},css: 'ico color',"type":'static',"text":'&nbsp;',title:'DATAGRID_ITEMS_VIEW::FLAGS',display: 'all'},
					HAS_ATTACHMENT: {width: 30,arg: {sort: 'desc'},css: 'ico attachment',"type":'static',"text":'&nbsp;',display: 'all'},
					DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'},
				};
			} else {
				aDefaultColumns = {
					FLAGS: {width: 40,css: 'priority ico flags static refresh',"type":'static',"text":'&nbsp;',display: 'all'},
					AVATAR: {width: 30,arg: {search: 'is:unread'},css: 'avatar ico msg static',"type":'static',text: '',display: 'all'},
					FROM: {width: 25,mode:'%',arg: {sort: 'asc'},display: 'all', css:'from'},
					SUBJECT: {width: 50,mode:'%',arg: {sort: 'asc'},display: 'all', css:'subject'},
					TO: {width: 25,mode:'%',arg: {sort: 'asc'}},
					ORIGINALFOLDER: {width: 200, arg: {}, css: 'originalFolder', hideColumnFor: [searchInAllFolders ? '' : 'user'], display: 'all', type: 'static'},
					DATE: {width: 100,arg: {sort: 'desc'},css: 'right', display: 'all'},
					SIZE: {width: 60,arg: {sort: 'desc'},css: 'right',display: 'all', hideColumnFor: ['small']},
					COLOR: {width: 30,arg: {sort: 'asc'},css: 'ico color',"type":'static',"text":'&nbsp;',title:'DATAGRID_ITEMS_VIEW::FLAGS',display: 'all'},
					HAS_ATTACHMENT: {width: 30,arg: {sort: 'desc'},css: 'ico attachment',"type":'static',"text":'&nbsp;',display: 'all'},
					DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'},
				};
			}
			smallOptions = {filters:[{search:'',text:'COMMON::ALL'},{search:'is:unread',text:'MESSAGE::UNREAD'}]};

			break;

		case 'T':
			aDefaultColumns = {
				EVNPRIORITY: {width: 40,"type":'static',"text":'&nbsp;',css: 'priority static refresh',display: 'all'},
				CHECK: {width: 26,"type":'static',"text":'&nbsp;',css: 'check',display: 'all'},
				EVNSTATUS: {width: 50,arg: {sort: 'asc'},"type":'static',"text":'&nbsp;',css: 'ico status',display: 'all'},
				EVNCOMPLETE: {width: 50,"type":'static',"text":'&nbsp;',display: 'small'},
				EVNTITLE: {width: 100,mode:'%',arg: {sort: 'asc'},css: 'title',display: 'all'},
				REMINDER: {width: 30,css: 'ico reminder',arg: {sort: 'desc'},"text":'&nbsp;'},
				RECCURENCE: {width: 30,css: 'ico recurrence',arg: {sort: 'desc'},"type":'static',"text":'&nbsp;'},
				TASK_ENDDATE: {width: 100,arg: {sort: 'desc'},display: 'all'},		// Date DUE
				TASK_STARTDATE: {width: 100,arg: {sort: 'desc'},display: 'all'},	// From date
				EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
				DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'}};

				smallOptions = {
					filters:[{ search: '', text: 'COMMON::ALL' }, { search: 'is:done', text: 'TASK::COMPLETED' }, { search: '-is:done', text: 'TASK::NOT_COMPLETED' }]
				};
			break;

		case 'N':
			aDefaultColumns = {
				REFRESH: {width: 40,"type":'static',"text":'&nbsp;',css: 'static refresh',display: 'all'},
				EVNTITLE: {width: 100,mode:'%',css:'indent title',arg: {sort: 'asc'},display: 'all'},
				EVN_MODIFIED: {width: 120,arg: {sort: 'desc'},display: 'all'},
				EVNTYPE: {width: 200,css: 'tags',html: true,arg: {sort: 'asc'}},
				DELETE: {width: 30,css: 'ico delete',"type":'static',"text":'&nbsp;',display: 'all'}};

				smallOptions = {};
			break;

		case 'Q':
			aDefaultColumns = {
				PRIORITY: {width: 40,arg: {},css: 'priority static',"type":'static',"text":'&nbsp;',title: 'SETTINGS::PRIORITY',display: 'all', hideColumnFor: ['small']},
				REFRESH: {width: 40,"type":'static',"text":'&nbsp;',css: 'static refresh',display: 'all'},
				SNDEMAIL: {width: 25,mode:'%',arg: {sort: 'asc'}, display: 'all', css:'from', encode:true},
				SNDSUBJECT: {width: 75,mode:'%',arg: {sort: 'asc'}, display: 'all', css:'subject', encode:true},
				QDATE: {width: 110,arg: {sort: 'desc'}, display: 'all', css:'right light'},
				SNDOWNER: {width: 100,arg: {sort: 'asc'}, encode:true},
				SNDDOMAIN: {width: 80,arg: {sort: 'asc'}, encode:true}
			};
            this.__dragtype = ''; // No Drag & Drop

			smallOptions = {};
			break;

		case 'QL':
			aDefaultColumns = {
				REFRESH: {width: 40,"type":'static',"text":'&nbsp;',css: 'static refresh',display: 'all'},
				SNDEMAIL: {width: 160,arg: {sort: 'asc'}, display: 'all', encode:true},
				SNDOWNER: {width: 160,arg: {sort: 'asc'}, encode:true},
				SNDDOMAIN: {width: 160,arg: {sort: 'asc'}, display: 'all', encode:true},
				QDATE: {width: 110,arg: {sort: 'desc'}, display: 'all', css:'right light'}
			};
			this.__dragtype = ''; // No Drag & Drop

			smallOptions = {};
			break;
	}

	if (this._small && smallOptions) {
		var rows = 2;
		if (+GWOthers.getItem('LAYOUT_SETTINGS','compact_view') != 0) {
			rows = 1;
		}

		smallOptions.sorting = Object.prototype.hasOwnProperty.call(smallOptions, 'sorting') ? smallOptions.sorting : true;
		smallOptions.rows = Object.prototype.hasOwnProperty.call(smallOptions, 'rows') ? smallOptions.rows : rows;
		smallOptions.size = !aOptions.bForceSingleLineRows ? Object.prototype.hasOwnProperty.call(smallOptions, 'size') ? smallOptions.size : ~aOptions.view.indexOf('wide') ? 2500 : 500 : '';

		await this._small(smallOptions);
	}

	if (!this._parent || !~this._parent._type.indexOf('frm_main_datagrid')) {
		delete aDefaultColumns.REFRESH;
	}

	for(var i  in aDefaultColumns) {
		aDefaultColumns[i].hideColumnFor = aDefaultColumns[i].hideColumnFor || [];
	}

	if (aOptions.bForceSingleLineRows || !~aOptions.view.indexOf('wide')) {
		aDefaultColumns = this.__userSpecifiedColumns(aDefaultColumns, sFolType);
	}

	for (i in aDefaultColumns) {
		if (aDefaultColumns[i].text === void 0 && aDefaultColumns[i].title === void 0) {
			aDefaultColumns[i].title = 'DATAGRID_ITEMS_VIEW::' + i;
		}
	}


	return aDefaultColumns;
};

_me.__userSpecifiedColumns = function(aDefaultColumns, sFolType) {
	var userColumns = sFolType ? (GWOthers.getItem('HIDDEN_COLUMNS', sFolType) || '').split(',').filter(Boolean) : [];
	if (!userColumns.length) {
		return aDefaultColumns;
	}
	var removedPercentages = 0;
	var hasPercentageColumn = false;
	for (var i in aDefaultColumns) {
		if (~userColumns.indexOf(i)) {
			aDefaultColumns[i].hideColumnFor.push('user');

			if (aDefaultColumns[i].mode === '%') {
				removedPercentages += aDefaultColumns[i].width;
			}
		} else {
			hasPercentageColumn = hasPercentageColumn || (aDefaultColumns[i].mode === '%');
		}
	}
	for (i in aDefaultColumns) {
		var hidden = ~aDefaultColumns[i].hideColumnFor.indexOf('user');
		if (hidden) {
			continue;
		}
		if (!hasPercentageColumn && aDefaultColumns[i].type !== 'static') {
			aDefaultColumns[i].mode = '%';
			aDefaultColumns[i].width = 100;
			hasPercentageColumn = true;
		} else if (removedPercentages < 100 && aDefaultColumns[i].mode === '%') {
			aDefaultColumns[i].width = aDefaultColumns[i].width * 100 / (100 - removedPercentages);
		}
	}
	return aDefaultColumns;
};

_me.__isInSentFolder = function(sFolder, sAccount){
	sFolder = (sFolder || (this._aFolder || {}).fid || '').split('/');
	sAccount = sAccount || (this._aFolder || {}).aid;
	var sentFolder = GWOthers.get('DEFAULT_FOLDERS', 'storage').VALUES.sent;
	for(var i = 1; i <= sFolder.length; i++) {
		var folderData = dataSet.get('folders',[sAccount, sFolder.slice(0, i).join('/')]);
		if(folderData && ((folderData.DEFAULT === 'S') || ((folderData.aid + '/' + folderData.fid) === sentFolder))) {
			return true;
		}
	}
};

_me._serverSort = async function(aFolder,sColumn,sSortType,aHandler,aFilter, bForceNewFolder, bKeepData){
	if (this.__lastSearchFolder) {
		this._aFolder.aid = (aFolder || {}).aid = this.__lastSearchAccount;
		this._aFolder.fid = (aFolder || {}).fid = this.__lastSearchFolder;
		this.__lastSearchAFolder = '';
		this.__lastSearchFolder = '';
	}

	aFolder = aFolder || this._aFolder;
	var bNewFolder = bForceNewFolder || !this._aFolder || this._aFolder.aid != aFolder.aid || this._aFolder.fid != aFolder.fid;
	if (bNewFolder) {
		this.__preloading = false;
		if (!bKeepData) {
			if (this.__eContainer2.scrollTop>0){
				this.__iScroll_top = 0;
				this.__eContainer2.scrollTop = 0;
			}

			this.__offset = 0;
			this.__total = -1;
			this.__limit = [0,0];

			this.__rowOffset = {};
			this.__totalRows = 0;
			// this._defaultfilter = '';
			dataSet.add('temp', ['includeIds'], []);
			this.__includeIds = [];

			this._value([]);
		}
	}

	this._aFolder = aFolder;

	if (!this.__limit[0] && !this.__limit[1]) {
		this.__limit = this.__getRange();
		this.__limit[1] += this.__preload * (aFilter && aFilter.groupbyemail ? 3 : 1);
	}
	
	if (!aFilter || !Is.Object(aFilter)) {
		aFilter = this.__filter || {};
	}
	aFilter.limit = this.__limit[1]-this.__limit[0];
	aFilter.offset = this.__limit[0];
	if (aFilter.defaultfilter) {
		this._defaultfilter = aFilter.defaultfilter;
	}

	var sFolType = WMFolders.getType(aFolder),
		aValues = this._default_values(sFolType),
		aDefaultColumns = await this._default_columns(sFolType);

	for(var i in aDefaultColumns) {
		aDefaultColumns[i].hideColumnFor = aDefaultColumns[i].hideColumnFor || [];
	}

	//SORT
	if (sSortType)
		sSortType = sSortType == 'desc'?1:0;

	//get sort from cookies
	if (this._cookiesEnabled){
		var bSave = true;

		if (!sColumn){
			var aSort = Cookie.get(['views',aFolder.aid,aFolder.fid,'sort']);
			if (aSort){
				sColumn = aSort.column;
				sSortType = aSort['type'] == 'desc'?1:0;
			}
			aSort = null;
		}

		//check
		if (sColumn && aDefaultColumns){
            if (!aDefaultColumns[sColumn] || (this.__small && (!aDefaultColumns[sColumn]['display'] || aDefaultColumns[sColumn]['text'] === ''))){
            	if (this.__small && this.__smallOptions.sort){
					sColumn = this.__smallOptions.sort;
					sSortType = this.__smallOptions.sorttype || 'desc';

					bSave = false;
            	}
            	else{
					var srt = (Cookie.__defaultViews[sFolType] || {}).sort || {};
					sColumn = srt.column;
					sSortType = srt.type;
				}
			}

			if (bSave)
				Cookie.set(['views',aFolder['aid'],aFolder['fid'],'sort'],{column:sColumn,type:sSortType?'desc':'asc'});
		}

		//Get filter from Cookie
		if (this.__small){
			var	f = Cookie.get(['views',aFolder['aid'],aFolder['fid'],'filter']) || '';
			if (this.__smallOptions && this.__smallOptions.filters)
				for (i = this.__smallOptions.filters.length-1;i>=0;i--)
					if (this.__smallOptions.filters[i].search == f){
						this._smallfilter = f;
						break;
					}
		}
	}
	//not used at this time
	else{
        sColumn = typeof sColumn == 'undefined'?this.__sortColumn:sColumn;
		sSortType = typeof sSortType == 'undefined'?this.__sortType:sSortType;
        //check
		if (aDefaultColumns && !aDefaultColumns[sColumn]){
			sColumn = '';
			sSortType = '';
		}
	}

	//ORDER
	var sOrder = this._serverOrder(sColumn,sSortType);
	if (sOrder)
		aFilter.sort = sOrder;

	//SQL FILTER
	if (this._SQLsearch_last != this._SQLsearch + (this._SQLtype || '')){
		this._value([]);
		this._SQLsearch_last = this._SQLsearch + (this._SQLtype || '');
	}

	if (this._defaultfilter || this._SQLsearch || this._SQLtype || this._smallfilter){

		aFilter['search'] = this._smallfilter || '';
		if (this._defaultfilter)
			aFilter['search'] += ' ' + this._defaultfilter;

		if (this._SQLsearch)
			aFilter['search'] += ' ' + this._SQLsearch;

		if (this._SQLtype)
			aFilter['type'] = this._SQLtype;
	}

	//FULLTEXT SEARCH
	if (this._SQLfulltext_last != this._SQLfulltext){
		this._value([]);

		this._SQLfulltext_last = this._SQLfulltext;
	}
	if (this._SQLfulltext)
		aFilter['fulltext'] = this._SQLfulltext;

	this.__filter = this.__filter || {};
	if (
		(this.__filter.search !== aFilter.search) ||
		(this.__filter.type !== aFilter.type) ||
		(this.__filter.sort !== aFilter.sort)
	) {
		// bNewFolder = true;
	}
	this.__filter = aFilter;

	var filter = clone(aFilter, true);
	var values = clone (aValues, true);
	this.__globalSearch = false;
	if (~(filter.search || '').indexOf('+folders:"all"')) {
		filter.search = filter.search.replace('+folders:"all"', '').trim();
		if (filter.search.replace(/is:unread/, '').trim().replace('()', '')) {
			this.__lastSearchFolder = aFolder.fid;
			this.__lastSearchAccount = aFolder.aid;
			aFolder.aid = sPrimaryAccount;

			// set correct virtual search folder
			var baseFolder = Path.slash(aFolder.fid).split('/')[0];
			var oBaseFolder = dataSet.get('folders', [aFolder.aid, baseFolder]);
			if ((baseFolder === '__@@ARCHIVE@@__') || (oBaseFolder && oBaseFolder.ARCHIVE === 'true')) {
				aFolder.fid = '__@@ARCHIVE@@__';
			} else if (oBaseFolder && oBaseFolder.PUBLIC === 'true') {
				aFolder.fid = '__@@VIRTUAL@@__/@@PUBLIC@@/' + baseFolder + '/#' + WMFolders.getType(aFolder);
			} else if (aFolder.fid[0] === '~') {
				aFolder.fid = '__@@VIRTUAL@@__/@@SHARED@@/' + baseFolder + '/#' + WMFolders.getType(aFolder);
			} else {
				aFolder.fid = '__@@VIRTUAL@@__/@@PERSONAL@@/#' + WMFolders.getType(aFolder);
			}

			dataSet.add('active_folder', '', aFolder.aid + '/' + aFolder.fid);
			gui.__exeEvent('folderSelected', aFolder);
			values && values.push('ORIGINALFOLDER');
			this.__globalSearch = true;
		}
	} else if (~(filter.search || '').indexOf('+folders:"subtree"')) {
		filter.search = filter.search.replace('+folders:"subtree"', '').trim();
		if (filter.search.replace(/is:unread/, '').trim().replace('()', '')) {
			this.__lastSearchFolder = aFolder.fid;
			this.__lastSearchAccount = aFolder.aid;
			aFolder.aid = sPrimaryAccount;

			aFolder.fid = '__@@VIRTUAL@@__/@@SUBTREE@@/' + Path.slash(aFolder.fid);

			dataSet.add('active_folder', '', aFolder.aid + '/' + aFolder.fid);
			gui.__exeEvent('folderSelected', aFolder);
			values && values.push('ORIGINALFOLDER');
			this.__globalSearch = true;
		}
	} else if (dataSet.get('folders', [aFolder.aid, aFolder.fid, 'VIRTUAL'])) {
			this.__globalSearch = true;
			values && values.push('ORIGINALFOLDER');
	}

	if (this.__preloading || (!bNewFolder && this.__lastLimit && this.__lastLimit[0] === this.__limit[0] && this.__lastLimit[1] >= this.__limit[1] && this.__sortColumn === sColumn && this.__sortType === sSortType)) {
		return this._selectPosition();
	}
	this.__lastLimit = clone(this.__limit, true);
	this.__sortColumn = sColumn;
	this.__sortType = sSortType;

	this.__totalRows = Math.max(this.__totalRows || 0, this.__limit[1]);
	
	//Hide No Items
	this._getAnchor('noitems').style.display = 'none';
	if (aFilter['search'] === 'is:unread') {
		this._placeholder(getLang('datagrid::nounread') + '<div class="all">' + getLang('datagrid::display_all') + '</div>', true);
		this._getAnchor('noitems').querySelector('.all').onclick = function() {
			Cookie.set(['views',aFolder['aid'],aFolder['fid'],'filter'], '');
			this._serverSort('',this.__sortColumn,this.__sortType?'desc':'asc', false, false, true);
			this.__fillFilter();
		}.bind(this);
	} else {
		this._placeholder('');
	}

	await this.__prefill(aFolder, aDefaultColumns, bNewFolder);

	if (this.__xhr/* && this.__xhr.readyState < 2*/) {
		this.__xhr.onabort = void 0;
		this.__xhr.abort();
	}

	if ((filter.search || '').replace(this._defaultfilter, '').replace(/\+folders:".*?"/, '').replace('+is:"genuine"', '').replace(/is:unread/, '').trim().replace('()', '')) {
		this._main.classList.add('search');
	} else {
		this._main.classList.remove('search');
	}

	if (this.__globalSearch) {
		// this._main.classList.add('global_search');
	} else {
		this._main.classList.remove('global_search');
	}

	this._onsize && this._onsize();

	if (bNewFolder) {
		aHandler = aHandler || [gui.frm_main, '__synchroDatasetHandler', [aFolder.aid, aFolder.fid]];
	}

	filter.search = (filter.search || '').trim();
	var excludedIds = dataSet.get('removedFromDataset', [aFolder.aid, aFolder.fid]) || [];
	if (excludedIds.length) {
		filter.exclude_ids = excludedIds.map(function(iid) { return WMItems.__serverID(iid.split('/').pop()); }).join(',');
	}
	if (this.__includeIds.length) {
		filter.include_ids = this.__includeIds.filter(function(id) {
			return !~excludedIds.indexOf(id);
		}).map(WMItems.__serverID).join(',');
	}

	clearTimeout(this.__xhrTimeout);
	this.__xhrTimeout = setTimeout(async function() {
		this.__xhr = await WMItems.list({
			aid: aFolder.aid,
			fid: aFolder.fid,
			spam: aFolder.spam,
			values: values,
			filter: filter
		}, this._listener_data, this._listenerPath_data, '', aHandler);
	}.bind(this), 300);
};

_me.__prefill = async function(aFolder, aDefaultColumns, bNewFolder) {
	var aItems = {};
	var limit = this.__total > -1 ? Math.min(this.__total, this.__limit[1]) : this.__limit[1];

	for (var i = this.__limit[0]; i < limit; i++) {
		if (!this.__rowOffset[i]) {
			this.__preloading = true;
		}
		var data = (this.__rowOffset[i] || {}).aData || {
			skeleton: true,
			css: 'skeleton'
		};
		aItems[data.iid || ('*skeleton' + i)] = data;
	}

	this._aCols = this._aCols || aDefaultColumns || {
		title: {hideColumnFor: ''}
	};

	if (bNewFolder) {
		await this.__fillHeader(aFolder);
	}
	await this._fill(this._prepareBody(aItems, WMFolders.getType(aFolder)), void 0, true);
	// if (bNewFolder) {
	// 	gui.frm_main.__synchroDatasetHandler(aFolder.aid, aFolder.fid);
	// }
};

_me._serverOrder = function(sColumn,iType){

	var sOrderBy = '',
		sSortType = iType?'desc':'asc';

	var f = this._getFolder();
	switch(sColumn)
	{
		//Contacts
		case 'ITMCLASSIFYAS':
			if (GWOthers.getItem('RESTRICTIONS','sortstring') == '1')
				sOrderBy = 'ITMSORTSTRING ' + sSortType + ','+ sColumn + ' ' + sSortType;
			else
				sOrderBy = sColumn + ' ' + sSortType;

		case 'CONTACT_EMAIL':
			var aContactEmailParts = ['LCTEMAIL1','LCTEMAIL2','LCTEMAIL3'];

			for (var n in aContactEmailParts){
				if (sOrderBy)
					sOrderBy += ',';

				sOrderBy += aContactEmailParts[n] + ' ' + sSortType;
			}
			break;

		case 'PHONE':
			sOrderBy = 'LCTPHONE ' + sSortType;
			break;

		//Events
		case 'EVENT_ENDDATE':
			sOrderBy = 'EVNENDDATE ' + sSortType + ',EVNENDTIME ' + sSortType;
			break;

		case 'EVENT_STARTDATE':
			sOrderBy = 'EVNSTARTDATE ' + sSortType + ',EVNSTARTTIME ' + sSortType;
			break;

		case 'EVNFILESIZE':
			sOrderBy = 'EVNCOMPLETE ' + sSortType;
			break;

		case 'EVNFILENAME':
			sOrderBy = 'EVNLOCATION ' + sSortType;
			break;

		//Mails
		case 'FROM':
			sOrderBy = 'HEADER_FROM ' + sSortType;
			break;

		case 'TO':
			sOrderBy = 'HEADER_TO ' + sSortType;
			break;
		//Tasks
		case 'TASK_STARTDATE':
			sOrderBy = 'EVNENDDATE ' + sSortType;
			break;

		case 'TASK_ENDDATE':
			sOrderBy = 'EVNSTARTDATE ' + sSortType;
			break;

		case 'RECCURENCE':
			sOrderBy = 'EVNRCR_ID ' + sSortType;
			break;

		case 'ITMCOMPANY':
			sOrderBy = 'ITMCOMPANY ' + sSortType +', ITMDEPARTMENT ' + sSortType;
			break;

		case 'REMINDER':
			sOrderBy = 'RMNTIME ' + sSortType;
			break;

		case 'COLOR':
			sOrderBy = sColumn + ' ' + sSortType;
			sSortType = 'desc';
			break;

		default:
			if (sColumn) {
				if (f.fid === '__@@SNOOZED@@__' && sColumn === 'DATE') {
					sSortType = iType ? 'asc' : 'desc';
				}
				sOrderBy = sColumn + ' ' + sSortType;
			}
	}

	//Order also by item_id, some DB doesn't do so automaticaly
	if (WMFolders.getType(f)=='M' && ~sOrderBy.indexOf('COLOR'))
		sOrderBy += (sOrderBy?', ':'') + 'item_id ' + sSortType;

	return sOrderBy;
};

//return actual visible range
_me.__getRange = function(){
	var a = Math.floor(this.__eContainer2.scrollTop/this._row_height) || 0,
		view = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);

	//Browsers sometime return 0 at first time
	var h;
	if (this.__eContainer2.clientHeight == 0)
		h = view;
	else
		h = Math.min(this.__eContainer2.offsetHeight, view);

	//Minimal height 300px
	h = Math.max(h, 300);

	return [a, Math.floor(h/this._row_height)];
};

_me._listen_data = function(sDataSet,aDataPath,bNoUpdate){
	this._listener_data = sDataSet;
	if (typeof aDataPath == 'object') this._listenerPath_data = aDataPath;

	dataSet.obey(this, null, 'temp');
	dataSet.obey(this,'_listener_data',sDataSet,bNoUpdate);

	gui._obeyEvent('changedId', [this, '__changedIdHandler'])
};

_me.__changedIdHandler = function(data) {
	if (this._destructed) {
		return;
	}

	var oldId = WMItems.__clientID(data.oldId);
	var newId = WMItems.__clientID(data.newId);

	if (this._aData[oldId]) {
		var value = this._value().map(function(value) {
			return value === oldId ? newId : value;
		});
		this._serverSort(void 0, void 0, void 0, void 0, void 0, true, true);
		this._value(value);
	}
};

_me.__update = async function(sName, aDPath){
	this.__preloading = false;
	if (((this.__filter || {}).search || '').replace(this._defaultfilter, '').replace(/\+folders:".*?"/, '').replace('+is:"genuine"', '').replace(/is:unread/, '').trim()) {
		this._main.classList.add('search');
	} else {
		this._main.classList.remove('search');
	}

	if (this.__globalSearch) {
		this._main.classList.add('global_search');
	} else {
		this._main.classList.remove('global_search');
	}

	if (sName === 'temp') {
		if (aDPath && aDPath[0] === 'includeIds') {
			this.__includeIds = (dataSet.get('temp', ['includeIds']) || []).filter((function(v, i ,a) {
				return a.indexOf(v) === i;
			}));
		}
		return;
	}

	// columns  - do budoucna pro vyreseni optional columns
	if (sName && sName == this._listener){
		await this._addColumns(dataSet.get(this._listener,this._listenerPath));
		return;
	}
	else
	// data
	if (sName != this._listener_data)
		return;

	var aItems = dataSet.get(this._listener_data,this._listenerPath_data);

	//clear DG if no data response
	if (!aItems || !this._aFolder){
		await this._addColumns({});      //pokud se tohle odkomentuje, tak se smaze obsah DG pri prazdym response (stava se na spatny connection + FF)
		this._fill({});
		return;
	}

	//check for proper folder response
	for(var sAccId in aItems){
		for(var sFolId in aItems[sAccId])
			break;
		break;
	}

	//check if data are from latest request
	if (sAccId != this._aFolder.aid || sFolId != this._aFolder.fid)
		return;

	//Check if folder is the same or new
	var bNewFolder = true;
	if (this._aFolderLast && this._aFolderLast.aid == this._aFolder.aid && this._aFolderLast.fid == this._aFolder.fid && !Is.Empty(this._aCols))
		bNewFolder = false;

	var sFolType = WMFolders.getType(this._aFolder);

/*	Edit just one row value (Part 1)
	if value in column with is same as sort	column is changed than whole list is refreshed
	if column name (aDPath[3]) is undefined then only row's CSS is changed */
	if (aDPath && aDPath[2] && aItems[aDPath[0]] && aItems[aDPath[0]][aDPath[1]] && aItems[aDPath[0]][aDPath[1]][aDPath[2]] && (!aDPath[3] || (aDPath[3] && this.__sortColumn!=aDPath[3]))){
		var rowOffset = -1,
			aData = aItems[aDPath[0]][aDPath[1]][aDPath[2]],
			tmp;

		var id = aData.ORIGINALACCOUNT ? aData.ORIGINALACCOUNT + '/' + aData.ORIGINALFOLDER + '/' + aDPath[2] : aDPath[2];
		for (var i in this.__rowOffset) {
			if (this.__rowOffset[i].id === id.split('/').pop()) {
				rowOffset = i;
				break;
			}
		}

		if (this.__small){
			if ((tmp = this.__getElement([aDPath[2], '*']) || this.__getElement([aData.ORIGINALACCOUNT + '/' + aData.ORIGINALFOLDER + '/' + aDPath[2], '*']))){
				tmp.parentNode.removeChild(tmp);
			}
		}
		else
			for(var sCol in this._aCols){
				if ((tmp = this.__getElement([aDPath[2], sCol]) || this.__getElement([aData.ORIGINALACCOUNT + '/' + aData.ORIGINALFOLDER + '/' + aDPath[2], '*']))){
					tmp.parentNode.removeChild(tmp);
				}
			}

		if (rowOffset<0)
			return;

		try{
			var aTmp = {};
				aTmp[aDPath[2]] = clone(aItems[aDPath[0]][aDPath[1]][aDPath[2]],true);

			aItems = aTmp;
		}
		catch {
			return;
		}
	}
	else{

		aItems = aItems[sAccId][sFolId];

		//ATTRIBUTES
		delete aItems['@'];

		//TOTAL
		if (typeof aItems['/'] != 'undefined' && aItems['/'] >= 0){
			if (!(this.__total = aItems['/']*1))
				this._value([]);
		}
		// else
		//     this.__total = count(aItems);

		delete aItems['/'];


		//SUBTOTAL
		if (typeof aItems['#'] != 'undefined' && aItems['#']>=0){
			this.__subtotal = aItems['#']*1;
			this.__limit[1] = Math.min(this.__limit[1],this.__total);
		}
		delete aItems['#'];

		//OFFSET
		if (typeof aItems['$'] != 'undefined' && aItems['$']>=0){
			if (this.__offset!= aItems['$']*1)
				return;
			else
				this.__offset = aItems['$']*1;
		}
		delete aItems['$'];


		//LOAD NEW DATA IF COUNT DOESNT CORESPOND WITH SUBTOTAL
		if (count(aItems) != this.__subtotal){
			this._serverSort(void 0, void 0, void 0, void 0, void 0, true, true);
			return;
		}

		if (bNewFolder){

			this.__dragtype = 'item';

			///////////////////////
			///// FILL HEADER /////
			///////////////////////
			await this.__fillHeader(this._aFolder);

			this._select_all = false;
		}
	}


	if (this.info){
		if (this.__value.length>this.__total)
			this._value([]);

		this.info._value(this.__value.length, this.__total);
	}

	/////////////////////
	///// FILL BODY /////
	/////////////////////

	// Refill whole body
	await this._fill(this._prepareBody(aItems, sFolType),rowOffset);

	this.__eContainer2.onscroll();

	this._aFolderLast = this._aFolder;
	this._aFilterLast = clone(this.__filter, true);
};

_me.__fillHeader = async function(aFolder) {
	var aDefaultColumns = await this._default_columns(WMFolders.getType(aFolder)),
		aColumns = {}, aColumnsOrder = [];

	for(var i in aDefaultColumns) {
		aDefaultColumns[i].hideColumnFor = aDefaultColumns[i].hideColumnFor || [];
	}

	//cookies
	if (this._cookiesEnabled)
	{
		var aCookieColumns = Cookie.get(['views',aFolder.aid,aFolder.fid,'columns',screen.width+'x'+screen.height]),
			aSort = Cookie.get(['views',aFolder.aid,aFolder.fid,'sort']),
			bRepair = false;

		aColumnsOrder = Cookie.get(['views',aFolder.aid,aFolder.fid,'columns_order']) || [];

		if (aCookieColumns)
		{
			//compare columns default vs cookie
			for(var sColumn in aDefaultColumns)
				if (!~aDefaultColumns[sColumn].hideColumnFor.indexOf('user') && typeof aCookieColumns[sColumn] == 'undefined'){
					bRepair = true;
					break;
				}

			if (!bRepair)
				for(sColumn in aCookieColumns)
					if (typeof aDefaultColumns[sColumn] == 'undefined'){
						bRepair = true;
						break;
					}

			//fix cookie
			if (bRepair){
				aColumns = clone(aDefaultColumns, true);
				Cookie.set(['views',aFolder.aid,aFolder.fid,'columns',screen.width+'x'+screen.height]);
			}
			//set column order & width from cookie
			else {
				for(sColumn in (~this.__aOptions.view.indexOf('wide') ? aDefaultColumns : aCookieColumns)) {
					aColumns[sColumn] = aDefaultColumns[sColumn];
					var hidden = ~aColumns[sColumn].hideColumnFor.indexOf('user');
					var fullWidth = aColumns[sColumn].mode === '%' && aColumns[sColumn].width === 100;
					if (aColumns[sColumn].type != 'static' && !hidden && !fullWidth)
						aColumns[sColumn]['width'] = aCookieColumns[sColumn];
				}
			}
		} else {
			aColumns = clone(aDefaultColumns, true);
		}

		if (aSort && aSort.column && aColumns[aSort.column]){
			this.__sortColumn = aSort.column;
			this.__sortType = aSort.type == 'desc'?1:0;
		}
	} else {
		aColumns = clone(aDefaultColumns, true);
	}

	var aCols = {};
	aColumnsOrder.forEach(function(column) {
		if (aColumns[column]) {
			aCols[column] = aColumns[column];
			delete aColumns[column];
		}
	});
	if (!Is.Empty(aColumns)) {
		var tmp = [];
		for (i in aCols) {
			aCols[i].id = i;
			tmp.push(aCols[i]);
		}

		for (i in aColumns) {
			var index = 0;
			for (var j in aDefaultColumns) {
				if (i === j) {
					break;
				}
				index++;
			}
			aColumns[i].id = i;
			tmp.splice(index, 0, aColumns[i]);
		};

		aCols = {};
		tmp.forEach(function(aCol) {
			aCols[aCol.id] = aCol;
		});
	}
	aColumns = aCols;

	var aHeaders = {};
	for(var sTitle in aColumns){
		if (~aColumns[sTitle].hideColumnFor.indexOf('user')) {
			continue;
		}
		aHeaders[sTitle] = {};

		for(var sProperty in aColumns[sTitle])
			aHeaders[sTitle][sProperty] = aColumns[sTitle][sProperty];
	}

	this._addColumns(aHeaders);
};

/**
 *	Naplnění pole pro datagrid
 **/
_me._prepareBody = function (aItems, sFolType) {
	var aResult = {},aRow,scss,
		aColors =  {'1':'red','2':'blue','3':'green','4':'gray','5':'orange','6':'cyan','7':'brown','8':'purple','9':'light_blue','A':'yellow','Y':'complete'},
		aCFolder = false,
		contactName,
		companyName,
		aTags = dataSet.get('tags') || {};

	var aAccess = WMFolders.getAccess(this._aFolder),
		sFolderType = WMFolders.getType(this._aFolder);

	if (aAccess.modify)
		addcss(this._main,'modify');
	else
		removecss(this._main,'modify');

	if (this._aFolder.aid == sPrimaryAccount && this._aFolder.fid == '__@@VIRTUAL@@__/__@@EVENTS@@__'){
		aCFolder = {};

		aColors = getCalendarColor();
		for (var c in aColors)
			if (aColors[c])
				aCFolder[Path.backslash(aColors[c])] = c;
	}

	function tags(sData){
		if (sData) {
			var NM = NightMode();
			var invertStyleProperty = NM.invertStyleProperty.bind(NM);
			var tags = sData.split(',').filter(function(tag) {
				return tag.trim();
			});
			return '<span class="tag' + (tags.length <= 2 ? ' expand' : '') + '">' + tags.map(function(tag) {
				tag = tag.trim();
				var style = aTags && aTags[tag];
				var tagColor = style ? style.TAGCOLOR : '';
				var textColor = style ? style.TEXTCOLOR : '#000000';
				var id = '';
				if (dataSet.get('main', ['night_mode_enabled'])) {
					var inverted = invertStyleProperty('color', textColor);
					id = inverted.id;
					textColor = inverted.color;
					inverted = tagColor ? invertStyleProperty('background-color', tagColor, id) : { id: id };
					id = inverted.id;
					tagColor = tagColor ? inverted.color : '';
				}
				return '<span' + ((style || {}).ID ? ' data-tag="' + style.ID + '"' : '') + (id ? ' id="' + id + '"' : '') + (style ? ' style="' + (tagColor ? 'background-color: ' + tagColor + '; ' : '') + 'color: ' + textColor + '"' : '') + ' title="' + tag.escapeHTML().replace(/"/g, '&quot;') + '">' + tag.escapeHTML() + '</span>';
			}).join('') + '</span>';
		}
		return '';
	};

	for(var sItId in aItems)
	{
		var aid = this._aFolder.aid;
		var fid = this._aFolder.fid;
		var iid = sItId;
		aRow = {};
		aItems[iid].iid = aItems[iid].iid || iid;

		scss = [aItems[sItId].css];
		scss.push('CLASS_' + (aItems[sItId]['ITMCLASS'] || aItems[sItId]['EVNCLASS'] || sFolderType));

		for(var sTitle in this._aCols)
		{
			var tags_html = '';
			var n, tmp, sSize;
			var sContactEmail = '';
			var aContactEmailParts = ['LCTEMAIL1','LCTEMAIL2','LCTEMAIL3'];

			switch(sTitle)
			{

				//Contacts
				case 'AVATAR':
					if (aItems[sItId]['ITMCLASS'] === 'C') {
						for (n in aContactEmailParts) {
							if (aItems[sItId][aContactEmailParts[n]]){
								sContactEmail = aItems[sItId][aContactEmailParts[n]];
								break;
							}
						}
						aRow[sTitle] = obj_avatar.getAvatarHTML({
							contactId: sItId,
							name: aItems[sItId].ITMCLASSIFYAS || sContactEmail,
							size: this.__small ? 40 : 32
						});
					} else if (sFolderType === 'M') {
						tmp = MailAddress.splitEmailsAndNames(aItems[sItId].FROM)[0] || {};
						aRow[sTitle] = obj_avatar.getAvatarHTML({
							email: tmp.email || '',
							name: tmp.name || '',
							size: this.__small ? 40 : 32
						});
						if(Is.Defined(aItems[sItId]['PRIORITY'])) {
							switch (aItems[sItId]['PRIORITY'].toString()) {
								case '1':
								case '2':
									scss.push('priority_high');
									break;
	
								case '4':
								case '5':
									scss.push('priority_low');
							}
						}
					}
					break;

				case 'CONTACT_EMAIL':
					//Nezobrazujeme maily pro distribuční seznam
					if (aItems[sItId]['ITMCLASS'] == 'C') {
						for (n in aContactEmailParts)
							if (aItems[sItId][aContactEmailParts[n]]){
								if (sContactEmail)
									sContactEmail += ', ';

								sContactEmail += aItems[sItId][aContactEmailParts[n]];
							}
					}
					aRow[sTitle] = sContactEmail;
					break;

				case 'ITMCOMPANY':
					tmp = aItems[sItId][sTitle] || '';
					if (aItems[sItId].ITMDEPARTMENT)
						tmp += (tmp?' - ':'') + aItems[sItId].ITMDEPARTMENT;

					aRow[sTitle] = [tmp,tmp];
					break;

				case 'PHONE':

					tmp = [];
					if (aItems[sItId]['LCTPHNMOBILE'])
						tmp.push(aItems[sItId]['LCTPHNMOBILE']);
					if (aItems[sItId]['LCTPHNWORK1'])
						tmp.push(aItems[sItId]['LCTPHNWORK1']);
					if (aItems[sItId]['LCTPHNFAXWORK'])
						tmp.push(aItems[sItId]['LCTPHNFAXWORK']);
					if (aItems[sItId]['LCTPHNHOME1'])
						tmp.push(aItems[sItId]['LCTPHNHOME1']);

					aRow[sTitle] = tmp.join(', ');

					break;

				case 'ITMCLASS':
					if (sFolType == 'G')
                        scss.push('ico_type_' + aItems[sItId].ITMCLASS);
					else
					if (aItems[sItId].ITMCLASS == 'L')
						scss.push('distrib');

					break;

				case 'ITMCLASSIFYAS':
					contactName = aItems[sItId][sTitle];

					companyName = '';
					if (this.__small && aItems[sItId].ITMCOMPANY) {
						companyName = '<span class="contactCompany">, ' + aItems[sItId].ITMCOMPANY.escapeHTML() + '</span>';
					}

					if (contactName){
						if (this.__small){
							tags_html = tags(aItems[sItId].ITMCATEGORY, true);
						}

						if (Is.String(contactName)){
							if (aItems[sItId].ITMCLASS == 'L')
								aRow[sTitle] = ['<span>' + '['+contactName.escapeHTML()+']' + '</span>' + tags_html, contactName];
							else
								aRow[sTitle] = ['<span>' + contactName.escapeHTML() + companyName + '</span>' + tags_html, contactName];
						}
						else {
							aRow[sTitle] = '<span>' + contactName.escapeHTML() + '</span>' + tags_html;
						}
					}

					break;
				// Events
				case 'EVNFOLDER':
					if (aCFolder){
						aRow[sTitle] = ['','',aItems[sItId].EVNFOLDER];
						scss.push(aCFolder[aItems[sItId].EVNFOLDER]);
					} else if (sFolType === 'F' && aItems[sItId].EVNFOLDER) {
						aRow[sTitle] = [WMFolders.getFolderPath({ fid: aItems[sItId].EVNFOLDER, aid: this._aFolder.aid })];
					}

					break;
				case 'ITMORIGINALFOLDER':
					aRow[sTitle] = [WMFolders.getFolderName({ fid: aItems[sItId].ITMORIGINALFOLDER, aid: sPrimaryAccount })];

					break;

				case 'ITMCATEGORY':
				case 'EVNTYPE':
					if (aItems[sItId][sTitle]){
						aRow[sTitle] = [tags(aItems[sItId][sTitle]),'',aItems[sItId][sTitle]];
					}
					break;

				case 'EVENT_ENDDATE':
					aRow[sTitle] = [(this.__small?tags(aItems[sItId]['EVNTYPE']):'') + this.__parseGwTime(aItems[sItId]['EVNENDDATE'],aItems[sItId]['EVNENDTIME'],true),parseInt(aItems[sItId]['EVNENDDATE'])*10000 + parseInt(aItems[sItId]['EVNENDTIME'])];
					break;

				case 'EVN_MODIFIED':
					var iSize = aItems[sItId]['EVNCOMPLETE'] || 0;
					sSize = (this.__small && iSize) ? '<span class="EVNCOMPLETE">' + parseFileSize(iSize) + '</span>': '';

					aRow[sTitle] = ['<span>' + CalendarFormatting.normalWithTime(new IcewarpDate(aItems[sItId]['EVN_MODIFIED'], {format: 'X'})) + '</span>' + sSize, '', '', new IcewarpDate(aItems[sItId]['EVN_MODIFIED'], {format: 'X'})];
					break;

				case 'EVENT_STARTDATE':
					aRow[sTitle] = [this.__parseGwTime(aItems[sItId]['EVNSTARTDATE'], aItems[sItId]['EVNSTARTTIME']), parseInt(aItems[sItId]['EVNSTARTDATE']) * 10000 + parseInt(aItems[sItId]['EVNSTARTTIME'])];
					break;

				case 'RECCURENCE':
					// Display recurrence icon, but not for tasks that are finished (EVNSTATUS only for tasks)
					if (aItems[sItId]['EVNRCR_ID'] && (aItems[sItId]['EVNSTATUS']!='M' || !aItems[sItId]['EVNSTATUS'])) {
						scss.push('recurrence');
						aRow[sTitle] = ['',1];
					} else
						aRow[sTitle] = ['',0];
					break;

				case 'CONFERENCE':
					if (aItems[sItId]['EVNMEETINGID']) {
						scss.push('conference');
						aRow[sTitle] = ['',1];
					} else
						aRow[sTitle] = ['',0];
					break;

				case 'REMINDER':
					if (aItems[sItId]['RMNEVN_ID']) {
						scss.push('reminder');
						aRow[sTitle] = ['',1];
					} else
						aRow[sTitle] = ['',0];
					break;

				case 'EVNFILENAME':
					if (this.__small){
						tags_html = tags(aItems[sItId].EVNTYPE);
					}
					var filename = aItems[sItId].EVNLOCATION || '';
					aRow[sTitle] = ['<span>' + (filename || '').escapeHTML() + '</span>' + tags_html, (filename || '').escapeHTML()];

					aRow['ico'] = ['','','',Item.getFileType(filename)];

					break;

				case 'EVNSTATUS':
					var txt = '';
					switch (aItems[sItId][sTitle]) {
						case 'B':
							scss.push('not_started');
							txt = getLang('TASK::NOT_STARTED');
							break;
						case 'I':
							scss.push('in_progress');
							txt = getLang('TASK::IN_PROGRESS');
							break;

						case 'M':
							scss.push('completed');
							txt = getLang('TASK::COMPLETED');
							break;
						case 'Q':
							scss.push('deferred');
							txt = getLang('TASK::DEFERRED');
							break;
						case 'N':
							scss.push('waiting');
							txt = getLang('TASK::WAITING');
							break;
					}
					aRow[sTitle] = ['', aItems[sItId][sTitle], txt];
					break;
				//Tasks
				case 'EVNCOMPLETE':
					if (aItems[sItId][sTitle]>0)
						switch(aItems[sItId].EVNSTATUS){
							case 'I':
							case 'Q':
							case 'N':
								if (this.__small)
									aRow[sTitle] = aItems[sItId][sTitle] + '%';
								else
									aRow.EVNSTATUS = aItems[sItId][sTitle] + '%';
						}

					break;

				case 'EVNPRIORITY':
					switch (aItems[sItId]['EVNPRIORITY']) {
						case '1':
							scss.push('priority_high');
							break;
						case '9':
							scss.push('priority_low');
							break;
					}
					break;

				case 'TASK_STARTDATE':
					aRow[sTitle] = parseInt(aItems[sItId]['EVNENDDATE']) ? [this.__parseGwTime(aItems[sItId]['EVNENDDATE']),parseInt(aItems[sItId]['EVNENDDATE'])] : [];
					break;

				case 'TASK_ENDDATE':
					if (this.__small && GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') == 0){
						tags_html = tags(aItems[sItId].EVNTYPE);
					}

					aRow[sTitle] = parseInt(aItems[sItId]['EVNSTARTDATE']) ? [tags_html + this.__parseGwTime(aItems[sItId]['EVNSTARTDATE']), parseInt(aItems[sItId]['EVNSTARTDATE'])] : [tags_html];
					break;

				case 'EVNTITLE':
					if (this.__small){
						tags_html = tags(aItems[sItId].EVNTYPE);
					}

					aRow[sTitle] = ['<span>' + (aItems[sItId][sTitle] || '').escapeHTML() + '</span>' + tags_html, '', aItems[sItId][sTitle]];
					break;

				//Mails
				case 'SUBJECT':

					tmp = '<span>' + (aItems[sItId][sTitle] || getLang('DATAGRID_ITEMS_VIEW::NOSUBJECT')).escapeHTML() + '</span>' + tags(aItems[sItId]['TAGS']);
					aRow[sTitle] = [tmp, '', aItems[sItId][sTitle] || getLang('DATAGRID_ITEMS_VIEW::NOSUBJECT')];
					break;

				case 'ITEM_MOVED':
				case 'ITM_DELETED':	//GW TRASH
				case 'DATE':	//EMAIL
				case 'QDATE':	//Quarantine
					aRow[sTitle] = this.__parseTime(aItems[sItId][sTitle], aItems[sItId].ORIGINAL_DATE);
					break;

				case 'PRIORITY':
					if(Is.Defined(aItems[sItId]['PRIORITY'])) {
						switch (aItems[sItId]['PRIORITY'].toString()) {
							case '1':
							case '2':
								scss.push('priority_high');
								aRow[sTitle] = ['',2];
								break;

							case '4':
							case '5':
								scss.push('priority_low');
								aRow[sTitle] = ['',0];
								break;

							default:
								aRow[sTitle] = ['',1];
						}
					}
					break;

				case 'COLOR':
					if (aItems[sItId].COLOR && Is.Defined(aColors[aItems[sItId].COLOR]))
						scss.push('bg_' + aColors[aItems[sItId].COLOR]);

					aRow[sTitle] = ['', aItems[sItId].COLOR];
					break;

				case 'SMART':
					if (aItems[sItId].EVNURL){
						scss.push('tracking');
						aRow[sTitle] = ['', '', ''];
					}
					break;

				case 'FLAGS':
					var nFlags = aItems[sItId]['FLAGS'],
						aFlag = [];

					if (!WMItems.hasFlag(nFlags, 'SEEN'))
						aFlag.push('unread');
					// else
					if (WMItems.hasFlag(nFlags, 'ANSWERED')) {
						if (WMItems.hasFlag(nFlags, 'FORWARDED'))
							aFlag.push('replied_and_forwarded');
						else
							aFlag.push('replied');
					}
					else
					if (WMItems.hasFlag(nFlags, 'FORWARDED'))
						aFlag.push('forwarded');

					aRow[sTitle] = ['',nFlags];

					switch(parseInt(aItems[sItId]['SMIME_STATUS'])){
						case 2: aFlag.push('serror'); break;
						case 3: aFlag.push('smime'); break;
						case 4: aFlag.push('sign'); break;
						case 5: aFlag.push('ssmime'); break;
					}

					if (aFlag.length)
						scss.push(aFlag.join(' '));

					break;

				case 'HAS_ATTACHMENT':
					if (aItems[sItId]['HAS_ATTACHMENT']=='true') {
						scss.push('attachment');
						aRow[sTitle] = ['',1];
					}
					else
						aRow[sTitle] = ['',0];
					break;

				case 'FROM':
				case 'TO':
					aRow[sTitle] = [MailAddress.splitNames(aItems[sItId][sTitle]).escapeHTML()];
					if (sTitle == 'TO' && aItems[sItId]['SMS'])
						aRow[sTitle][0] += [(aRow[sTitle]?', ':'') + MailAddress.splitNames(aItems[sItId]['SMS']).escapeHTML()];
					aRow[sTitle][2] = aRow[sTitle][0];

					break;

				case 'SMS':
					break;

				case 'SIZE':
					aRow[sTitle] = [parseFileSize(aItems[sItId][sTitle]),parseInt(aItems[sItId][sTitle])];
					break;

				case 'EVNFILESIZE':
					sSize = aItems[sItId]['EVNCOMPLETE'] || 0;

					aRow[sTitle] = [parseFileSize(sSize), parseInt(sSize)];
					break;

				case 'ORIGINALFOLDER':
					if (aItems[sItId][sTitle]) {
						aid = aItems[sItId].ORIGINALACCOUNT || aid;
						fid = aItems[sItId][sTitle];
						iid = aItems[sItId].ORIGINALACCOUNT + '/' + aItems[sItId][sTitle] + '/' + sItId;
						aRow[sTitle] = aItems[sItId][sTitle];
					}
					break;

				case 'EVNNOTE':
					if (aItems[sItId]['EVNDESCFORMAT'] == 'text/html' && aItems[sItId][sTitle]){
						aRow[sTitle] = [aItems[sItId][sTitle].removeTags(), aItems[sItId][sTitle]];
						break;
					}
				// Recovery items
				case 'ITMTITLE':
					// For teamchat posts replace title with description (message text is stored in description field) to avoid empty lines
					if ('G' === sFolType &&  'I' === aItems[sItId]['ITMCLASS']) {
						aItems[sItId][sTitle] = aItems[sItId]['ITMDESCRIPTION'];
					}

				default:
					if (Is.String(aItems[sItId][sTitle]))
						aRow[sTitle] = [aItems[sItId][sTitle],aItems[sItId][sTitle]];
					else
						aRow[sTitle] = aItems[sItId][sTitle];

					break;
			}
		}

		aResult[iid] = {id: sItId, css: scss.join(' '), data: aRow, arg: {aid: aid, fid: fid, iid: sItId}, aData: aItems[sItId]};
	}

	return aResult;
};

// FUNCTION(s) FOR PARSING DATA
_me.__parseTime = function(nUTime, nSnoozedTime)
{
	if (!nUTime){
		return '';
	}
	var oDate = new IcewarpDate(nUTime * 1000);
	var oOriginalDate;
	if (nSnoozedTime) {
		oOriginalDate = IcewarpDate.unix(nSnoozedTime);
	}
	return [GWOthers.getItem('LAYOUT_SETTINGS', 'datagrid_fulldate') > 0 ? oDate.format("L LT") : CalendarFormatting.simplified(oDate), '', (oOriginalDate || oDate).format("ddd L LT"), (nSnoozedTime && (this._aFolder.fid !== '__@@SNOOZED@@__')) ? 'snoozed' : '', oDate];
};

_me.__parseGwTime = function(sDate,sTime,bEnd){
	if (!Is.Number(+sDate))
		return '';

	var oDate = new IcewarpDate(sDate, {format: IcewarpDate.JULIAN});

	if (Is.Number(+sTime)){
		oDate.setTime(sTime > 0 ? sTime : 0, true);

		if (bEnd && sTime < 0)
			oDate.date(oDate.date() - 1);

		return CalendarFormatting.normalWithTime(oDate);
	}

	return CalendarFormatting.normal(oDate);
};

/**
 * store column cookies
 **/
_me._onresizeend = function(aColumns)
{
	if (this._cookiesEnabled && this._getFolder)
	{
		var oFolder = this._getFolder();
		if (!oFolder)
			return;

		var aNewColumns = {};
		var aColumnsOrder = [];
		for(var sColumn in aColumns) {
			aNewColumns[sColumn] = aColumns[sColumn]['width'];
			aColumnsOrder.push(sColumn);
		}

		Cookie.set(['views',oFolder['aid'],oFolder['fid'],'columns',screen.width+'x'+screen.height],aNewColumns,true);
		Cookie.set(['views',oFolder['aid'],oFolder['fid'],'columns_order'],aColumnsOrder,true);
	}
};

/**
 * historical reasons, it can be called from outside
 **/
_me._getFolder = function(){
	return {
		aid: (this._aFolder || {}).aid,
		fid: (this._aFolder || {}).fid
	}
};

_me._removeItems = function(aIds) {
	var id, j, cell;
	for(var i in this._aData) {
		id = this._aData[i].id;
		if (~aIds.indexOf(id)) {
			if (this._aData[i].row) {
				this._aData[i].row.parentNode.removeChild(this._aData[i].row);
			} else {
				for (j in this._aCols) {
					cell = this.__getElement([i, j]);
					cell && cell.parentNode.removeChild(cell);
				}
			}
			delete this._aData[i];
		}
	}

	if (this.__rowOffset) {
		var subtractHeight = 0;
		var subtractItems = 0;
		var subtractSeparators = 0;
		var movedSeparators = [];
		for (i in this.__rowOffset) {
			id = [this.__rowOffset[i].aData.ORIGINALACCOUNT, this.__rowOffset[i].aData.ORIGINALFOLDER, this.__rowOffset[i].aData.iid].filter(Boolean).join('/');
			if (~aIds.indexOf(this.__rowOffset[i].id)) {
				subtractItems++;
				for (j in this.__separators) {
					if (this.__separators[j].group[id]) {
						delete this.__separators[j].group[id];
						if (!Object.keys(this.__separators[j].group).length) {
							this.__separators[j].parentNode.removeChild(this.__separators[j]);
							delete this.__separators[j];
							subtractSeparators++;
						}
						break;
					}
				}
				delete this.__rowOffset[i];
				subtractHeight = subtractItems * this._row_height - subtractSeparators * this._separator_height;
				if (this.__total) {
					this.__total--;
					if (this.__limit && this.__limit[1] !== void 0) {
						this.__limit[1]--;
					}
				}
			} else if (subtractItems || subtractSeparators) {
				var top = 0;
				if (this.__rowOffset[i].row) {
					top = parseInt(this.__rowOffset[i].row.style.top) - subtractHeight;

					if (top < 0) {
						continue;
					}

					this.__rowOffset[i].row.style.top = top + 'px';
				} else {
					for (j in this._aCols) {
						cell = this.__getElement([id, j]);
						if (cell) {
							top = top || parseInt(cell.style.top) - subtractHeight;
							cell.style.top = top + 'px';
						}
					}
				}

				for (j in this.__separators) {
					if (this.__separators[j].group[id] && !~movedSeparators.indexOf(j) && parseInt(this.__separators[j].style.top) > top) {
						this.__separators[j].style.top = parseInt(this.__separators[j].style.top) - subtractHeight + 'px'; 
						movedSeparators.push(j);
						break;
					}
				}

				if (subtractItems) {
					this.__rowOffset[i - subtractItems] = this.__rowOffset[i];
					delete this.__rowOffset[i];
				}
			}
		}
	}

	this._getAnchor('body').style.height = parseInt(this._getAnchor('body').style.height) - subtractHeight + 'px';
	this.__lastHeight = this.__lastHeight - subtractHeight;
	this.__check_size();
	delete this.__lastLimit;
	this._serverSort(false, false, false, false, false, false, true);
}
