function obj_dashboard_frame() {};

obj_dashboard_frame.prototype.callbacks = [];
obj_dashboard_frame.prototype.__constructor = async function (oOptions, postMessageHandler) {
	this._sandbox([
		'allow-scripts',
		'allow-downloads',
		'allow-popups',
		'allow-same-origin',
		'allow-modals'
	]);

	this._setURL(oOptions.url, oOptions.navigate === void 0 ? true : oOptions.navigate);
	this.__eFrame.setAttribute('title', 'Dashboard');

	this.__messageHandler = function(event) {
		if (this._destructed || event.source !== this.__eFrame.contentWindow) {
			return;
		}

		if (postMessageHandler && (postMessageHandler(event.data.event, event.data.data) === false)) {
			return;
		}

		var handler = this['__onMessage_' + event.data.event];
			handler && handler.call(this, event.data.data);

		var uid = event.data.uid || (event.data.data || {}).uid;
		if (this.callbacks[uid]) {
			this.callbacks[uid](event.data.data);
			delete this.callbacks[uid];
		}
	}.bind(this);
	addEventListener('message', this.__messageHandler);

	this.___settingsChanged = this.__settingsChanged.bind(this);
	GWOthers.addListener(this.___settingsChanged);
	gui._obeyEvent('settings_changed', [this, '__postSettings']);

	gui._obeyEvent('uploadaborted', [this, '__uploadaborted']);
	gui._obeyEvent('changedId', [this, '__changedIdHandler']);

	gui._obeyEvent('click', [this, '__onmouseclick']);
	gui._obeyEvent('contextmenu', [this, '__onmouseclick']);

	gui._obeyEvent('itemShare', [this, '__handleItemShare']);
	
	gui.socket.api._obeyEvent('onnotify', [this, '__onnotify']);

	gui.frm_main.dnd.registr_drop(this, ['item', 'folder']);

	this._add_destructor('__destructor');

	this._listen('main');
};

obj_dashboard_frame.prototype.__update = function() {
	this.__quotaUpdate();
};

obj_dashboard_frame.prototype.__quotaUpdate = function() {
	var quota = dataSet.get('main',['MBOX_QUOTA']);
	var usage = dataSet.get('main',['MBOX_USAGE']);

	if (quota && ((this.__quota !== quota) || (this.__usage !== usage))) {
		this.__quota = quota;
		this.__usage = usage;

		this._postMessage({
			event: 'quota',
			data: {
				quota: +quota,
				usage: +usage
			}
		});
	}
};

obj_dashboard_frame.prototype.__onMessage_quota = function(data) {
	if (data.quota) {
		this.__quota = data.quota;
		dataSet.add('main',['MBOX_QUOTA'], '' + data.quota, true);
	}
	this.__usage = data.usage;
	dataSet.add('main',['MBOX_USAGE'], '' + data.usage);
};

obj_dashboard_frame.prototype.__destructor = function() {
	removeEventListener('message', this.__messageHandler);

	GWOthers.removeListener(this.___settingsChanged);
	gui._disobeyEvent('settings_changed', [this, '__postSettings']);

	gui._disobeyEvent('changedId', [this, '__changedIdHandler']);

	gui._disobeyEvent('click', [this, '__onmouseclick']);
	gui._disobeyEvent('contextmenu', [this, '__onmouseclick']);

	gui._disobeyEvent('itemShare', [this, '__handleItemShare']);

	gui.socket.api._disobeyEvent('onnotify', [this, '__onnotify']);
};

obj_dashboard_frame.prototype._setURL = function(sURL, bNavigate) {
	var base = dataSet.get('dashboard', ['config', 'dashboard_url']);
	if (sURL) {
		sURL = sURL.replace(base, '');
		this.__url = sURL;
	}

	if (bNavigate) {
		var route = encodeURIComponent(sURL);
		this._src('dashboard.html?route=' + route);
	}
};

obj_dashboard_frame.prototype._postMessage = function(data, transfer) {
	if (this._destructed) {
		return;
	}

	this.__eFrame.contentWindow.postMessage(data, '*', transfer);
};

obj_dashboard_frame.prototype._active_dropzone = function(data) {
	var me = this;
	var offset = this._getAnchor('main').getBoundingClientRect();
	if (data) {
		this._postMessage({
			event: 'dndstart',
			data: {
				items: data.value.map(function(item) {
					if (item.iid) {
						item.iid = WMItems.__serverID(item.iid);
					}
					return item;
				}),
				uid: data.uid
			}
		});

		this.__mask = mkElement('div', {
			className: 'dropzone',
			onmouseenter: function() {
				me._postMessage({
					event: 'mouseenter'
				});
			},
			onmouseleave: function() {
				me._postMessage({
					event: 'mouseleave'
				});
			},
			onmousemove: function(e) {
				me._postMessage({
					event: 'mousemove',
					data: {
						x: e.x - offset.x,
						y: e.y - offset.y
					}
				});
			},
			onmouseup: function(e) {
				if (gui.frm_main.dnd.dndInitiator === me) {
					return;
				}
				me._postMessage({
					event: 'mouseup',
					data: {
						x: e.x - offset.x,
						y: e.y - offset.y,
						ctrlKey: e.ctrlKey,
						shiftKey: e.shiftKey,
						altKey: e.altKey,
						metaKey: e.metaKey
					}
				});
			}
		});
		this._getAnchor('main').appendChild(this.__mask);
		return this.__mask;
	} else {
		this._postMessage({
			event: 'dndend'
		});
		return false;
	}
};

obj_dashboard_frame.prototype.__onmouseclick = function(event) {
	this._postMessage({
		event: 'click',
		data: {
			uid: (event || {}).uid,
			button: (event || {}).button
		}
	});
};

obj_dashboard_frame.prototype.__handleItemShare = function(data) {
	this._postMessage({
		event: 'share',
		data: data
	});
}

obj_dashboard_frame.prototype.__onMessage_click = function(data) {
	gui.__exeEvent('click', data);
};

obj_dashboard_frame.prototype.__onMessage_dndstart = function(data) {
	this.__offset = this._getAnchor('main').getBoundingClientRect();

	this.__dragGhost = gui.frm_main.dnd.create_drag({
		type: data.items.some(function(item) {
			return item.iid;
		}) ? 'item' : 'folder',
		value: data.items,
		x: data.x,
		y: data.y,
		ctrlKey: data.ctrlKey || data.metaKey,
		obj: this,
		uid: data.uid
	});
	this.__dragGhost.classList.add('hidden');

	this.__lastDndEl = null;
};

obj_dashboard_frame.prototype.__onMessage_dndmove = function(data) {
	if (!this.__offset) {
		return;
	}
	var x = data.x + this.__offset.x;
	var y = data.y + this.__offset.y;

	gui.__exeEvent('mousemove', {
		clientX: x,
		clientY: y,
		ctrlKey: data.ctrlKey || data.metaKey
	});

	var el = document.elementFromPoint(x, y);
	if (el) {
		if (this.__lastDndEl !== el) {
			this.__lastDndEl && this.__lastDndEl.onmouseleave && this.__lastDndEl.onmouseleave();
			el.onmouseenter && el.onmouseenter();
		}

		if (el !== this.__mask) {
			this.__dragGhost.classList.remove('hidden');
			el.onmousemove && el.onmousemove({ x: x, y: y, ctrlKey: data.ctrlKey || data.metaKey });
		} else {
			this.__dragGhost.classList.add('hidden');
		}
	}
	this.__lastDndEl = el;
};

obj_dashboard_frame.prototype.__onMessage_dndend = function(data) {
	var x = data.x + this.__offset.x;
	var y = data.y + this.__offset.y;

	var el = document.elementFromPoint(x, y);
	el && el.onmouseup && el.onmouseup({ x: x, y: y, ctrlKey: data.ctrlKey || data.metaKey });

	gui.__exeEvent('mouseup', {
		clientX: x,
		clientY: y,
		ctrlKey: data.ctrlKey || data.metaKey
	});

	this.__lastDndEl = null;
	this.__offset = null;
};

obj_dashboard_frame.prototype.__onMessage_identity = function() {
	this._postMessage({
		event: 'identity',
		data: {
			email: sPrimaryAccount,
			language: isoLanguageCode(GWOthers.getItem('LAYOUT_SETTINGS', 'language')),
			token: dataSet.get('dashboard', ['token'])
		}
	});
};

obj_dashboard_frame.prototype.__onMessage_authenticated = function() {
	this.__authenticated = true;
	this.__postSettings();
};

obj_dashboard_frame.prototype.__onMessage_notification = function (data) {
	gui.notifier._value({
		type: data.type,
		args: {
			header_plain: data.header || '',
			text_plain: data.text || ''
		}
	});
};

obj_dashboard_frame.prototype.__onMessage_changeView = function (view) {
	var filter = view && gui.frm_main.filter._main.querySelector('.' + view);
	filter && filter.click();
};

obj_dashboard_frame.prototype.__onMessage_shareItem = function(data) {
	Item.collaborate([
		data.aid,
		data.fid,
		WMItems.__clientID(data.iid)
	]);
};

obj_dashboard_frame.prototype.__onMessage_openItem = function(data) {
	Item.openwindow([
		data.aid,
		data.fid,
		WMItems.__clientID(data.iid)
	]);
};

obj_dashboard_frame.prototype.__onMessage_previewItem = function(data) {
	if (data.url) {
		return Item.previewURL(data.url, data.filename, false, data);
	}
	Item.previewItem([
		data.aid,
		data.fid,
		WMItems.__clientID(data.iid),
	], data.filename, false, false, data);
};

obj_dashboard_frame.prototype.__onMessage_previewImages = async function(data) {
	await gui._create('imgview', 'frm_imgview');
	await gui.imgview._fill(data.images);
	gui.imgview._value(data.index || 0);
};

obj_dashboard_frame.prototype.__onMessage_printItem = function(data) {
	Item.print([
		data.aid,
		data.fid,
		[WMItems.__clientID(data.iid)]
	], data.filename);
};

obj_dashboard_frame.prototype.__onMessage_previewAttachment = function(data) {
	Item.previewAttachment([
		data.aid,
		data.fid,
		WMItems.__clientID(data.iid),
	], data.attid, data.ticket);
};

obj_dashboard_frame.prototype.__onMessage_selectFolder = function(data) {
	gui._create('frm_select_folder', 'frm_select_folder', '', '', 'SELECT_FOLDER::SELECT_FOLDER', '', '', [function(aid, fid) {
		this._postMessage({
			event: 'selectFolder',
			data: {
				aid: aid,
				fid: fid,
				uid: data.uid
			}
		});
	}.bind(this)], data.skipAccount, true, data.folderType, 'w');
};

obj_dashboard_frame.prototype.__onMessage_selectItem = async function(data) {
	var allowed_folder_types = data.folderTypes || ['F', 'X', 'I'];
	if (Alfresco.enabled()) {
		allowed_folder_types.push('K');
	}

	var upload = await obj_upload._instance(this, data.uid, {});
	upload._onuploadstart = function(files) {
		// do not process uploaded files in webclient
		upload.file.__queue = [];

		files = files.map(function(file) {
			return {
				name: file.name,
				size: file.size,
				type: file.type,
				stream: file.stream()
			};
		});

		this._postMessage({
			event: 'upload',
			data: {
				files: files,
				uid: data.uid
			}
		}, files.map(function(file) {
			return file.stream;
		}));
	}.bind(this);
	upload._onuploadend = function() {
		upload._destruct();
	};

	var inserter = await gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [function(files) {
		files = files.map(function(file) {
			return {
				aid: file.aid,
				fid: file.fid,
				iid: WMItems.__serverID(file.iid || file.id),
				title: file.title,
				size: file.size ? +file.size || NaN : NaN
			}
		});

		this._postMessage({
			event: 'attach',
			data: {
				files: files,
				uid: data.uid
			}
		});

		upload._destruct();
	}.bind(this)], sPrimaryAccount, '', '', upload, false, allowed_folder_types);

	if ((/^((?!chrome|android).)*safari/i).test(navigator.userAgent)) {
		inserter.upload_button._onclick = function() {
			this._postMessage({
				event: 'upload',
				data: {
					uid: data.uid
				}
			});
		}.bind(this)
	}
};

/**
 * Open confirm from dashboard
 * @param {Object} data
 * @param {String} data.uid event id sent back with postmessage to message sender
 * @param {String} data.ico popup ico
 * @param {String} data.title popup title
 * @param {String} data.label popup label
 * @param {Object} data.ok
 * @param {String} data.ok.label
 * @param {Number} data.ok.color 1: style color; 2: red; 3: green; 4: light style
 * @param {String} data.cancel.label
 * @param {Number} data.cancel.color 1: style color; 2: red; 3: green; 4: light style
 * @param {MessageEvent} event
 */
obj_dashboard_frame.prototype.__onMessage_confirm = async function(data) {
	var modal = await gui._create('confirm', 'frm_confirm', '', '', [function() {
		this._postMessage({
			event: 'confirm',
			data: {
				uid: data.uid
			}
		});
	}.bind(this)]);

	data.ico && modal._main.classList.add('frm_' + data.ico);
	data.title && modal._title(data.title, true);
	data.label && modal.obj_label._value(data.label);

	['ok', 'cancel'].forEach(function(button) {
		if (data[button]) {
			data[button].label && modal['x_btn_' + button]._text(data[button].label);
			data[button].color && modal['x_btn_' + button]._main.classList.add('color' + data[button].color);
		};
	});
};

obj_dashboard_frame.prototype.__postSettings = function() {
	if (gui.frm_main.dashboard.__doNotPostSettingsBack) {
		return;
	}

	var settings = {};
	var storage = dataSet.get('storage');
	for (var i in storage) {
		var setting = {};
		var values = (storage[i].ITEMS[0] || {}).VALUES;
		for (var j in values) {
			setting[j.toLowerCase()] = values[j].VALUE;
		}
		settings[i.toLowerCase()] = setting;
		settings.account_attributes = aPrimaryAttributes;
	}

	settings.layout_settings = settings.layout_settings || {};
	settings.layout_settings.layout = Cookie.get(['layout']);
	settings.layout_settings.sidebar_width = Cookie.get(['vertical_slider', screen.width + 'x' + screen.height]) || 260;

	settings.documents = settings.documents || {};
	settings.documents.enabled = GWOthers.getItem('DOCUMENTS', 'disable_office') == 0 && GWOthers.getItem('RESTRICTIONS', 'disable_doc_integration') == 0 && dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true';
	this._postMessage({
		event: 'settings',
		data: settings
	});
};

obj_dashboard_frame.prototype.__settingsChanged = function(sResourceName, aResource) {
	var data = {};
	data[(sResourceName || '').toLowerCase()] = aResource;
	this._postMessage({
		event: 'settings',
		data: data
	});
};

obj_dashboard_frame.prototype.__onnotify = function(data) {
	if (data.DASHBOARD) {
		return;
	}

	this._postMessage({
		event: 'websocket',
		data: data
	});
};

obj_dashboard_frame.prototype.__changedIdHandler = function(data) {
	if (data.oldId === data.newId) {
		return;
	}
	this._postMessage({
		event: 'changedId',
		data: data
	});
};

obj_dashboard_frame.prototype.__files = {};
obj_dashboard_frame.prototype.__onMessage_onuploadstart = async function(data) {
	await storage.library('wm_upload');
	gui.__exeEvent('onuploadstart', {
		files: data.files.map(function(file) {
			this.__files[file.id] = this.__files[file.id] || Object.assign(new FakeFile(file.name), {
				id: file.id,
				size: file.size,
				type: file.type,
				// objectURL: file.objectURL
			});

			return this.__files[file.id];
		}, this)
	});
};

obj_dashboard_frame.prototype.__onMessage_onuploadprogress = function(data) {
	gui.__exeEvent('onuploadprogress', {
		file: this.__files[data.file.id],
		size: this.__files[data.file.id].size,
		completed: data.file.completed
	});
};

obj_dashboard_frame.prototype.__onMessage_onuploadaborted = function(data) {
	gui.__exeEvent('onuploadaborted', {
		file: this.__files[data.file.id]
	});
	delete this.__files[data.file.id];
};

obj_dashboard_frame.prototype.__onMessage_onuploadsuccess = function(data) {
	gui.__exeEvent('onuploadsuccess', {
		file: this.__files[data.file.id]
	});
};

obj_dashboard_frame.prototype.__onMessage_onuploadend = function(data) {
	gui.__exeEvent('onuploadend', {
		files: data.files.map(function(file) {
			var _file = this.__files[file.id];
			delete this.__files[file.id];
			return _file;
		}, this)
	});
};

obj_dashboard_frame.prototype.__onMessage_onuploadcommit = function(data) {
	gui.__exeEvent('onuploadcommit', {
		id: data.file.id,
		data: {
			folder: data.file.folder,
			id: WMItems.__clientID(data.file.server_id),
			name: data.file.name
		}
	});
};

obj_dashboard_frame.prototype.__uploadaborted = function(data) {
	this._postMessage({
		event: 'uploadaborted',
		data: {
			file: {
				id: data.file.id
			}
		}
	});
};

obj_dashboard_frame.prototype.__onMessage_openWindow = function(data) {
	gui._create.apply(gui, [
		data.window,
		data.window,
		'',
		''
	].concat(data.arguments || []));
};

obj_dashboard_frame.prototype.__onMessage_openWindowURL = async function(data) {
	return await gui._create('dashboard_window', 'frm_dashboard_window', '', '', data);
};

obj_dashboard_frame.prototype.__onMessage_setWindowURL = function(data) {
	this._setURL(data.url, data.navigate);
};

obj_dashboard_frame.prototype.__onMessage_setWindowTitle = function(data) {
	this._parent._title && this._parent._title(data.title, true);
};

obj_dashboard_frame.prototype.__onMessage_addFolderToFavorites = function(data) {
	WMFolders.addToFavorites(data);
};

obj_dashboard_frame.prototype.__onMessage_addFolder = function(data) {
	WMFolders.response({
		Array: {
			IQ: [{
				ATTRIBUTES: {
					TYPE: 'result'
				},
				QUERY: [{
					ACCOUNT: [{
						ATTRIBUTES: {
							UID: data.aid
						},
						FOLDER: [{
							ATTRIBUTES: {
								UID: data.fid
							},
							RELATIVE_PATH: [{
								VALUE: data.fid
							}],
							OWNER: [{
								VALUE: data.aid
							}],
							NAME: [{
								VALUE: data.name
							}],
							TYPE: [{
								VALUE: data.type
							}]
						}]
					}]
				}]
			}]
		}
	}, 'add', 'folders', '', {
		aid: data.aid,
		name: data.name,
		type: data.type,
		bSkipNotify: true
	});
};

obj_dashboard_frame.prototype.__onMessage_renameFolder = function(data) {
	WMFolders.response({
		Array: {
			IQ: [{
				ATTRIBUTES: {
					TYPE: 'result'
				},
				QUERY: [{
					ACCOUNT: [{
						ATTRIBUTES: {
							UID: data.aid
						},
						FOLDER: [{
							ATTRIBUTES: {
								UID: data.fid
							},
							RELATIVE_PATH: [{
								VALUE: data.fid
							}],
							OWNER: [{
								VALUE: data.aid
							}],
							NAME: [{
								VALUE: data.name
							}],
							TYPE: [{
								VALUE: data.type
							}]
						}]
					}]
				}]
			}]
		}
	}, 'add', 'folders', '', {
		aid: data.aid,
		fid: data.fid,
		name: data.name,
		bSkipNotify: true
	});
};

obj_dashboard_frame.prototype.__onMessage_deleteFolder = function(data) {
	WMFolders.response({
		Array: {
			IQ: [{
				ATTRIBUTES: {
					TYPE: 'result'
				}
			}]
		}
	}, 'delete', 'folders', '', {
		aid: data.aid,
		fid: data.fid,
		bSkipNotify: true
	});
};

obj_dashboard_frame.prototype.__onMessage_createFile = async function(data) {
	var type = {
		document: '.docx',
		spreadsheet: '.xlsx',
		presentation: '.pptx'
	}[data.type];

	(await Item.create('F', {
		docType: type
	})).__changeFolder(data.aid, data.fid);
};

obj_dashboard_frame.prototype.__onMessage_deleteItem = function(data) {
	Item.notify([data.aid, data.fid, data.iid], 'DELETE', {
		DASHBOARD: true
	});
};

obj_dashboard_frame.prototype.__onMessage_pinItem = function(data) {
	gui.frm_main.dashboard.__onMessage_pinItem(data);
};

obj_dashboard_frame.prototype.__onMessage_unpinItem = function(data) {
	gui.frm_main.dashboard.__onMessage_unpinItem(data);
};

obj_dashboard_frame.prototype.__onMessage_updateTag = function(data) {
	var tags = dataSet.get('tags') || {};

	tags[data.name] = {
		ID: data.id,
		TAGNAME: data.name,
		TAGCOUNT: data.usage_count || 0,
		TAGCOLOR: data.color
	}

	dataSet.add('tags', '', tags);
};

obj_dashboard_frame.prototype.__onMessage_tracking = function(data) {
	gui.frm_main.rslide.upload_detail._init({
		aid: data.aid,
		fid: data.fid,
		iid: data.iid
	});
	gui.frm_main.rslide._value('upload_detail');
};

obj_dashboard_frame.prototype.__onMessage_token = function(data) {
	icewarpapi.token.access = data.token.access;
	icewarpapi.token.refresh = data.token.refresh || icewarpapi.token.refresh;
};

obj_dashboard_frame.prototype.__onMessage_clearSearch = function() {
	gui.frm_main.search.search.clearQuery();
};

obj_dashboard_frame.prototype.__onMessage_requestSubscriptionModuleConfig = function() {
	icewarpapi.getLicenseManagementSecret(function(secret) {
		this._postMessage({
			event: 'subscriptionModuleConfig',
			data: {
				secret: secret.secret,
				timestamp: secret.timestamp,
				orderid: dataSet.get('main', ['license', 'ATTRIBUTES', 'PURCHASEID'])
			}
		});
	});
};

obj_dashboard_frame.prototype.__onMessage_sidebarResize = function(data) {
	gui.frm_main.__activeSlider = 'slider';
	gui.frm_main._resize(data.width);
};

obj_dashboard_frame.prototype.__onMessage_keydown = function(data) {
	document.body.dispatchEvent(new KeyboardEvent('keydown', {
		altKey: data.altKey,
		charCode: data.charCode,
		code: data.code,
		ctrlKey: data.ctrlKey,
		key: data.key,
		keyCode: data.keyCode,
		metaKey: data.metaKey,
		shiftKey: data.shiftKey,
		which: data.which
	}));
};

obj_dashboard_frame.prototype.__onMessage_copyToTeamchat = function(data) {
	var ids = ['', '', []];
	data = Array.isArray(data) ? data : [data];
	data.forEach(function(data) {
		ids[0] = data.aid;
		ids[1] = Path.slash(data.fid);
		ids[2].push(WMItems.__clientID(data.iid));
	});
	Item.copy_tch(ids);
};

obj_dashboard_frame.prototype.__onMessage_forwardByEmail = function(data) {
	var ids = ['', '', []];
	data = Array.isArray(data) ? data : [data];
	data.forEach(function(data) {
		ids[0] = data.aid;
		ids[1] = Path.slash(data.fid);
		ids[2].push(WMItems.__clientID(data.iid));
	});
	Item.sendAsEmail(ids);
};

obj_dashboard_frame.prototype.__onMessage_logout = function(data) {
	gui.frm_main.__logout(true);
};

obj_dashboard_frame.prototype.__onMessage_reauthenticate = function() {
	icewarpapi.getToken(function() {
		this._postMessage({
			event: 'token',
			data: {
				token: icewarpapi.token
			}
		});
	}.bind(this));
};

obj_dashboard_frame.prototype.__onMessage_setFolder = function(data) {
	this._parent._title(WMFolders.getFolderName(data), true);
};