function obj_dalle_addon(){};

obj_dalle_addon.prototype.__constructor = async function(aData, oOptions) {
	var me = this;
	this.__aData = aData;
	this.__oOptions = Object.assign({

	}, oOptions || {});

	await this._draw('obj_dalle_addon', 'main', aData);
	if (this._destructed) {
		return;
	}
	var image = this._getAnchor('image');

	image.addEventListener('click', async function() {
		await gui._create('imgview', 'frm_imgview');
		await gui.imgview._fill([{
			title: aData.message,
			url: aData.image
		}]);
		gui.imgview._value(0);
	});

	if (!aData.followed_thread_comment) {
		var fid = Mapping.getDefaultFolderForGWType('F');

		await this._create('open', 'obj_button', 'buttons', 'img transparent ico detach simple');
		this.open._onclick = async function() {
			await gui._create('imgview', 'frm_imgview');
			await gui.imgview._fill([{
				title: aData.message,
				url: aData.image
			}]);
			gui.imgview._value(0);
		};
		gui.tooltip._add(this.open._main, getLang('popup_items::open'));

		await this._create('save', 'obj_button', 'buttons', 'img transparent ico folders simple');
		this.save._onclick = function() {
			gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', sPrimaryAccount, fid, [me, '__saveImage'], true, false, 'F', 'i');
		};
		gui.tooltip._add(this.save._main, getLang('attachment::save_to_folder'));

		if ('ClipboardItem' in window) {
			await this._create('copy_to_clipboard', 'obj_button', 'buttons', 'img transparent ico clipboard simple');
			this.copy_to_clipboard._onclick = function() {
				toClipboard({
					'image/png': aData.image
				}, 'image');
			};
			gui.tooltip._add(this.copy_to_clipboard._main, getLang('chatgpt::copy_to_clipboard'));
		}

		await this._create('download', 'obj_button', 'buttons', 'img transparent ico download simple');
		this.download._onclick = function() {
			downloadItem(aData.image, true);
		};
		gui.tooltip._add(this.download._main, getLang('attachment::download'));

		await this._create('share', 'obj_button', 'buttons', 'simple img transparent ico share2 simple');
		this.share._onclick = async function() {
			me.__saveImage(sPrimaryAccount, fid, {
				success: function(result) {
					Item.collaborate([result.aid, result.fid, result.iid]);
				}
			});
		};
		gui.tooltip._add(this.share._main, getLang('upload_detail::share'));

		if (this.__oOptions.customAction) {
			await this._create('customAction', 'obj_button', 'buttons', 'img transparent ico simple right ' + (this.__oOptions.customAction.css || 'ok'));
			this.customAction._onclick = function() {
				me.__saveImage(sPrimaryAccount, fid, {
					success: function(result) {
						result.description = aData.message;
						this.__oOptions.customAction.callback(result);
					}.bind(me)
				});
			};
			gui.tooltip._add(this.customAction._main, getLang(this.__oOptions.customAction.label));
		}
	}
};

obj_dalle_addon.prototype.__saveImage = function(aid, fid, callback) {
	var name = (this.__aData.message || this.__aData.id).substr(0, 128) + '.png';

	function saveImageCallback(result) {
		if (callback) {
			callback.success && callback.success.call(callback.context || this, {
				aid: aid,
				fid: fid,
				iid: result.iid,
				name: name
			});
		} else if (gui.notifier) {
			// gui.notifier._value({type: 'item_saved', args: [aid, fid]});
		}
	}

	function saveImage() {
		var now = new IcewarpDate();

		WMItems.add([aid,fid], {
			values:{
				EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'file_sharing'),
				EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
				EVNSTARTTIME: now.format(IcewarpDate.JULIAN_TIME),
				EVNUID: this.__aData.id
			},
			duplicity: 'rename',
			ATTACHMENTS: [{
				values:{
					class: 'link',
					description: name,
					fullpath: this.__aData.image
				}
			}]
		},'','','',[
			function(bOK, result){
				//Notify user
				if (bOK && result && result.id){
					saveImageCallback({
						aid: aid,
						fid: fid,
						iid: result.id,
						name: name
					});

					//refresh Files folder if active
					var aItems = dataSet.get('items');
					for(var sAccId in aItems)
						for(var sFolId in aItems[sAccId])
							break;

					if (aid == sAccId && fid == sFolId)
						try{
							gui.frm_main.main.list._serverSort({aid:aid,fid:fid});
						}
						catch(r){ console.log(this._name||false,r);}
				}
			}
		]);
	}

	if (!this.__aData.id) {
		return saveImage.call(this);
	}

	WMItems.list({
		aid: aid,
		fid: fid,
		filter: {
			search: 'partid:"' + this.__aData.id + '"'
		}
	}, '', '', '', [function(aData) {
		if ((aData = aData[sPrimaryAccount]) && (aData = aData[fid]) && aData['@'].COUNT > '0') {
			for(var iid in aData) {
				if (iid.length > 1) {
					return saveImageCallback({ 
						aid: aid,
						fid: fid,
						iid: iid,
						name: name
					});
				}
			}
		}

		saveImage.call(this);
	}.bind(this)]);
};
