_me = obj_context_item.prototype;
function obj_context_item() {};

obj_context_item.createColorMailMenu = function(id) {
	return [
	{"title": 'COLOR_LABELS::RED_FLAG', "css": 'ico2 bg_red', 'arg': [OldMessage.setColor, [id, Item.COLORS.RED]], shortcut: { key: '0' }},
	{"title": 'COLOR_LABELS::BLUE_FLAG', "css": 'ico2 bg_blue', 'arg': [OldMessage.setColor, [id, Item.COLORS.BLUE]], shortcut: { key: '1' }},
	{"title": 'COLOR_LABELS::GREEN_FLAG', "css": 'ico2 bg_green', 'arg': [OldMessage.setColor, [id, Item.COLORS.GREEN]], shortcut: { key: '2' }},
	{"title": 'COLOR_LABELS::ORANGE_FLAG', "css": 'ico2 bg_orange', 'arg': [OldMessage.setColor, [id, Item.COLORS.ORANGE]], shortcut: { key: '3' }},
	{"title": 'COLOR_LABELS::PURPLE_FLAG', "css": 'ico2 bg_purple', 'arg': [OldMessage.setColor, [id, Item.COLORS.PURPLE]], shortcut: { key: '4' }},
	{"title": 'COLOR_LABELS::YELLOW_FLAG', "css": 'ico2 bg_yellow', 'arg': [OldMessage.setColor, [id, Item.COLORS.YELLOW]], shortcut: { key: '5' }},
	{"title": '-'},
	{"title": 'COLOR_LABELS::FLAG_COMPLETE', "css": 'ico2 bg_complete', 'arg': [OldMessage.setColor, [id, Item.COLORS.COMPLETE]]},
	{"title": 'COLOR_LABELS::CLEAR_FLAG', "css": 'ico2 bg_none', 'arg': [OldMessage.setColor, [id, '']], shortcut: { key: '-' }}
	];
};

_me.__createMailMenu = async function(id, ids, bMultiple, sFrom, aRights, bLimit) {
	// In Drafts or Sent folders some items should not be available:
	var folders = GWOthers.get('DEFAULT_FOLDERS', 'storage')['VALUES'];

	id[0] = (dataSet.get('items', [id[0], id[1], id[2]]) || {}).ORIGINALACCOUNT || id[0];
	id[1] = (dataSet.get('items', [id[0], id[1], id[2]]) || {}).ORIGINALFOLDER || id[1];
	var sFolderID = id[0] + '/' + id[1];

	// If SPAM_QUEUE/Blacklist folder doesn't exist, some items should not be available:
	var bDraft = (sFolderID == folders['drafts']),
		bTemplate = folders['templates'] && ~(sFolderID + '/').indexOf(folders['templates'] + '/'),
		bSent = (sFolderID == folders['sent']),
		bRSS = dataSet.get('folders',[id[0],id[1],'RSS'])?true:false,
		bTeamChat = WMFolders.getType(id) === 'I';

	if (dataSet.get('main',['archive_path']) && sFolderID.indexOf(dataSet.get('main',['archive_path'])+'/') === 0){
		if (sFolderID.indexOf(dataSet.get('main',['archive_path'])+'/Sent/') === 0)
			bSent = true;
	}

	if (ids[1] === '__@@SNOOZED@@__') {
		aRights.modify = true;
	}

	var aMenu = [];

	if (bDraft) {
		aMenu.push({"title": 'POPUP_ITEMS::EDIT', css:'ico2 edit', 'disabled': bMultiple, 'arg': [OldMessage.edit, [id]]});
	} else if (bTemplate && !bLimit) {
		var old = new OldMessage();
		await old.init(id);
		aMenu.push({"title": 'MAIN_MENU::NEW_FROM_TEMPLATE', css:'ico2 from_template', 'disabled': bMultiple, 'arg': [NewMessage.compose,[old]]});
		aMenu.push({"title": 'POPUP_ITEMS::EDIT', css:'ico2 edit', 'disabled': bMultiple, 'arg': [OldMessage.edit, [id,{template:true}]]});
	}

	if (!bLimit) {
		aMenu.push({"title": 'POPUP_ITEMS::OPEN_WINDOW', css:'ico2 open', 'disabled': bMultiple, 'arg': [OldMessage.openwindow, [id]]});
	}

	if (!bRSS && !bDraft && !bTemplate && !(aRights.STATIC_FLAGS & 16)) {
		aMenu.push({"title": bSent?'POPUP_ITEMS::REPLY_TO_ALL':'POPUP_ITEMS::REPLY_TO_SENDER', css:'ico2 ' + (bSent?'reply_all':'reply'), 'disabled': bMultiple, 'arg': [OldMessage.reply, [{id, bReplyToAll: bSent}]],
			nodes: [
				{"title": 'POPUP_ITEMS::REPLY_TO_SENDER', css:'ico2 reply', 'disabled': bMultiple || bSent, 'arg': [OldMessage.reply, [{id}]], shortcut: {key: 'R'}},
				{"title": 'POPUP_ITEMS::REPLY_TO_ALL', css:'ico2 reply_all', 'disabled': bMultiple, 'arg': [OldMessage.reply, [{id, bReplyToAll: true}]], shortcut: {key: 'R', shift: true}},
				{"title": 'MAIN_MENU::REPLY_TO_ALL_ATT', css:'ico2 reply_all_att', 'disabled': bMultiple, 'arg': [OldMessage.reply, [{id, bReplyToAll: true, bCopyAttachments: true}]]},
				{"title": 'MAIN_MENU::REPLY_TO_ALL_NEW', css:'ico2 reply_all_att', 'disabled': bMultiple, 'arg': [OldMessage.replyAllNew, [id]]},
				{"title": '-'},
				{"title": 'MAIN_MENU::REPLY_TO_SENDER_T', css:'ico2 reply_template', 'disabled': bMultiple || bSent, 'arg': [OldMessage.replyTemplate, [id, false]], shortcut: {key: 'W'}},
				{"title": 'MAIN_MENU::REPLY_TO_ALL_T', css:'ico2 reply_all_template', 'disabled': bMultiple, 'arg': [OldMessage.replyTemplate, [id, true]], shortcut: {key: 'W', shift: true}}
			]});
	}

	if (!(aRights.STATIC_FLAGS & 8)) {
		if (bTemplate)
			aMenu.push({"title": 'POPUP_ITEMS::FORWARD_AS_MESSAGE', css:'ico2 forward', 'arg': [OldMessage.forward, [{id: ids, bForwardAsMessage: true}]]});
		else {
			var tmp = [
				{"title": 'POPUP_ITEMS::FORWARD', css:'ico2 forward', 'disabled': bMultiple, 'arg': [OldMessage.forward, [{id}]], shortcut: {key: 'F'}},
				{"title": 'POPUP_ITEMS::FORWARD_RESEND', css:'ico2 forward', 'disabled': bMultiple, 'arg': [OldMessage.forward, [{id, bForwardResend: true}]]},
				{"title": 'POPUP_ITEMS::FORWARD_AS_MESSAGE', css:'ico2 forward', 'arg': [OldMessage.forward, [{id, bForwardAsMessage: true}]], shortcut: {key: 'F', shift: true}}
			];

			if ((GWOthers.getItem('RESTRICTIONS', 'disable_redirect') || 0)<1)
				tmp.push({"title": 'POPUP_ITEMS::REDIRECT', css:'ico2 redirect', 'disabled': bMultiple, 'arg': [OldMessage.redirect, [id]]});

			aMenu.push({"title": 'POPUP_ITEMS::FORWARD', css:'ico2 forward', 'arg': [OldMessage.forward, [{id}]],
				nodes:tmp
			});
		}
	}

	var day_starts = GWOthers.getItem('CALENDAR_SETTINGS', 'day_begins') || 9;
	var day_starts_hour = Math.floor(day_starts);
	var day_starts_minute = (day_starts % 1) * 4;

	var now = new IcewarpDate();
	var today = (now.hour() < 21) && now.clone().hour(now.hour() + 3).minute(0);
	var tomorrow = now.clone().add(1, 'day').hour(day_starts_hour).minute(day_starts_minute);
	var next_week = now.clone().add(7, 'days').hour(day_starts_hour).minute(day_starts_minute);

	var list = gui.frm_main.main.list;
	var next = !Mapping.isGlobalSearchFolder(ids[1]) && list && list.__getNext(ids[2]);
	aMenu.push(
		{ title: 'MAIN_MENU::SNOOZE', css:'ico2 snooze noarrow', nodes: [
			today && { title: 'CALENDAR::LATER_TODAY', shortcut: { key: today.format('ddd LT') }, css: '', arg: [OldMessage.snooze, [ids, today, list, next]] },
			{ title: 'CALENDAR::TOMORROW', shortcut: { key: tomorrow.format('ddd LT') }, css: '', arg: [OldMessage.snooze, [ids, tomorrow]] },
			{ title: 'CALENDAR::IN_A_WEEK', shortcut: { key: next_week.format('ddd LT') }, css: '', arg: [OldMessage.snooze, [ids, next_week]] },
			{ title: '-' },
			{ title: 'CALENDAR::PICK_DATETIME', css: 'ico2 time', arg: [OldMessage.snooze, [ids]] },
			ids[1] === '__@@SNOOZED@@__' && { title: 'MAIN_MENU::UNSNOOZE', css: 'ico2 unsnooze', arg: [OldMessage.snooze, [ids, false]] }
		].filter(Boolean)}
	);

	if (bSent && sPrimaryAccountDELIVERY && !bLimit)
		aMenu.push({"title": 'POPUP_ITEMS::DELIVERY_REPORT', css:'ico2 delivery', 'disabled': bMultiple, 'arg': [OldMessage.delivery_report, [id]]});

	if (bSent && !bMultiple && sPrimaryAccountRECALL) {
		aMenu.push({ title: 'RECALL_MESSAGE::TITLE', css:'ico2 recall', arg: [OldMessage.recall, [id]]});
	}

	if (!bTeamChat) {
		var tags = this.__tagSubmenu ? this.__tagSubmenu(ids) : [];
		aMenu.push(
			{"title": 'POPUP_ITEMS::MARK_AS_READ', css:'ico2 markread', 'arg': (list && list._select_all) ? [Folder.markRead, [{aid: id[0], fid: id[1]}]] : [OldMessage.markAsRead, [ids]],'disabled':!aRights.modify, shortcut: {key: 'E'}},
			{"title": 'POPUP_ITEMS::MARK_AS_UNREAD', css:'ico2 markunread', 'arg': (list && list._select_all) ? [Folder.markUnread, [{aid: id[0], fid: id[1]}]] : [OldMessage.markAsUnread, [ids]],'disabled':!aRights.modify, shortcut: {key: 'U'}},
			{title: 'DATAGRID_ITEMS_VIEW::ITMCATEGORY', css: 'ico2 tag', arg: [Item.tags, [ids]], disabled: !aRights.modify || (list && list._select_all), shortcut: tags.length > 1 ? false : {key: 'T'}, nodes: tags.length > 1 ? tags : false},
			{"title": '-'}
		);

		if (aRights.remove){
			aMenu.push(
				{"title": 'POPUP_ITEMS::MOVE_MAIL_TO', css:'ico2 move_folder', 'arg': [Item.move, [ids, list, next]],
					nodes:[
						{"title": 'POPUP_ITEMS::MOVE_MAIL_TO', css:'ico2 move_folder', 'arg': [Item.move, [ids, list, next]], shortcut: {key: 'M'}},
						{"title": 'POPUP_ITEMS::COPY_MAIL_TO', css:'ico2 copy_folder', 'arg': [Item.copy, [ids, list]], shortcut: {key: 'C'}},
						Alfresco.enabled() && {"title": 'POPUP_ITEMS::COPY_MAIL_TO_ALFRESCO', css:'ico2 alfresco', 'arg': [Item.copyToAlfresco, [ids]]}
					].filter(Boolean)
				}
			);
		}
		else{
			aMenu.push(
				{"title": 'POPUP_ITEMS::COPY_MAIL_TO', css:'ico2 move_folder', 'arg': [Item.copy, [ids, list]], shortcut: {key: 'C'}}
			);
		}

		// Add black/white list
		if (!bRSS && !bDraft && !bSent && (dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Blacklist']) || dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Whitelist']))){
			var blist = dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Blacklist']),
				wlist = dataSet.get('folders', [sPrimaryAccount, 'SPAM_QUEUE/Whitelist']);

			aMenu.push(
				{"title":'-'},
				{"title": 'POPUP_ITEMS::WHITELIST_SENDER', css:'ico2 whitelist', 'arg': [OldMessage.whitelistSender, [ids, list, next]],'disabled':!wlist, nodes:[
					{"title": 'POPUP_ITEMS::WHITELIST_SENDER', 'arg': [OldMessage.whitelistSender, [ids, list, next]]},
					{"title": 'POPUP_ITEMS::WHITELIST_DOMAIN', 'arg': [OldMessage.whitelistDomain, [ids, list, next]]}
				]},
				{"title": 'POPUP_ITEMS::BLACKLIST_SENDER', css:'ico2 blacklist','arg': [OldMessage.blacklistSender, [ids, list, next]],'disabled':!blist, nodes:[
					{"title": 'POPUP_ITEMS::BLACKLIST_SENDER', 'arg': [OldMessage.blacklistSender, [ids, list, next]]},
					{"title": 'POPUP_ITEMS::BLACKLIST_DOMAIN', 'arg': [OldMessage.blacklistDomain, [ids, list, next]]}
				]}
			);
		}

		//More options...
		var tmp_cert,
		tmp_amenu = [];
		if (!(aRights.STATIC_FLAGS & 4) && !(aRights.STATIC_FLAGS & 8) && !(aRights.STATIC_FLAGS & 16) && !(aRights.STATIC_FLAGS & 32)) {
			tmp_amenu = [
				{"title": 'POPUP_ITEMS::SAVE_AS', css:'ico2 save', 'arg': [Item.downloadSource, [id,'text']],
					"nodes":[
						{"title": 'POPUP_ITEMS::TEXT', css:'ico2 text', 'disabled': bMultiple, 'arg': [Item.downloadSource, [id,'text']]},
						{"title": 'POPUP_ITEMS::EML', css:'ico2 eml', 'arg': [bMultiple?Item.downloadMultiple:Item.downloadSource, [bMultiple?ids:id]]},
						{"title": 'POPUP_ITEMS::HTML', css:'ico2 html', 'disabled': bMultiple, 'arg': [Item.downloadSource, [id,'html']]}
					]
				},
				{"title": 'POPUP_ITEMS::SOURCE', css:'ico2 source', 'arg': [OldMessage.source, [id]]}
			];
		}

		var aFrom = MailAddress.splitEmailsAndNames(sFrom)[0];
		if (aFrom && !bDraft){

			if (sPrimaryAccountGW>0){
				//Parse email (the same in frm_addaddress)
				var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '';

				// Invite to appointment
				if (dgw.indexOf('e')<0 && aFrom.email !== sPrimaryAccount)
					tmp_amenu.push({
						"title": 'POPUP_ITEMS::INVITE_APPOINTMENT', css:'ico2 add_calendar', disabled: false, arg: [async function() {
							var aData = (await WMItems.list({aid: id[0], fid: id[1], iid: id[2], values: ['HTML', 'FROM', 'TO', 'CC', 'BCC']}))[id[0]][id[1]][WMItems.__clientID(id[2])];
							var note = mkElement('div', {
								innerHTML: aData.HTML
							});
							var contacts = [];
							MailAddress.splitEmailsAndNames([aData.FROM, aData.TO, aData.CC, aData.BCC].filter(Boolean).join(',')).forEach(function (recipient) {
								if (recipient.email && recipient.email !== sPrimaryAccount) {
									contacts.push({
										values: {
											CNTEMAIL: recipient.email,
											CNTCONTACTNAME: recipient.name,
											CNTROLE: 'Q',
											NEW: true
										}
									});
								}
							});
							var iwReplyBlock = note.querySelector('.iw-reply-block');
							iwReplyBlock && iwReplyBlock.parentNode && iwReplyBlock.parentNode.removeChild(iwReplyBlock);
							Item.createInFolder(id[0], "__@@VIRTUAL@@__/__@@EVENTS@@__", {
								EVNTITLE: (dataSet.get('items', [id[0], id[1], id[2]]) || {}).SUBJECT,
								EVNNOTE: note.innerHTML,
								CONTACTS: contacts
							});
						}]
					});

				// Add to Contact
				if (dgw.indexOf('c')<0){

					var aLCTval = {};
					if (aFrom && aFrom.name)
						aLCTval = parseNameToLocation(aFrom.name,aLCTval);

					if (aFrom.email)
						aLCTval.LOCATIONS = [{'values': {'LCTEMAIL1':aFrom.email,'LCTTYPE': 'H'}}];

					//Add Certificate
					if (dataSet.get('items',[id[0],id[1],id[2],'SMIME_STATUS'])>3)
						aLCTval.CERTIFICATES = [{values:{'class':'item','fullpath':id[0] +'/'+ id[1] +'/'+ WMItems.__serverID(id[2])}}];

					tmp_amenu.push({"title": 'POPUP_ITEMS::ADD_CONTACT', css:'ico2 add_contact', disabled: bMultiple,'arg': [gui, '_create', ['frm_contact', 'frm_contact', '', '', sPrimaryAccount, Mapping.getDefaultFolderForGWType('C'), '',aLCTval]]});
					tmp_cert = {"title": 'POPUP_ITEMS::CERT_TO_CONTACT', css:'ico2 add_cert', disabled: bMultiple || dataSet.get('items',[id[0],id[1],id[2],'SMIME_STATUS'])<4, 'arg': [Item.addCert,[id]]};
				}
			}

			//Add to IM Roster
			if (window.sPrimaryAccountIM && (GWOthers.getItem('RESTRICTIONS', 'disable_im') || 0)<1 && gui.frm_main && gui.frm_main.im)
				tmp_amenu.push({"title": 'POPUP_ITEMS::ADD_IM', css:'ico2 add_im', disabled: !gui.frm_main.im._is_active() || bMultiple,'arg': [gui.frm_main.im, '_add_item', ['', aFrom.email, aFrom.name]]});
		}

		// Add Certificate after IM and Appointment
		if (tmp_cert)
			tmp_amenu.push(tmp_cert);

		if (tmp_amenu.length) {
			aMenu.push({"title":'COMMON::MORE_OPTIONS', css:'ico2 more', nodes:tmp_amenu});
		}

		if (sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT && !(aRights.STATIC_FLAGS & 8) && !(aRights.STATIC_FLAGS & 16)) {
			aMenu.push({"title": 'POPUP_ITEMS::COPY_ITEM_TO_TEAMCHAT', css:'ico2 color1 share_folder teamchat', 'arg':[Item.copy_tch,[ids]]});
		}
		else{
			aMenu.push({"title":'-'});
		}
	}

	if (!bLimit) {
		// var aOptions = {alias:Item.getAliasFromPath(sFolderID)};
		// aOptions.template = bTemplate;

		// aMenu.push({"title": 'MAIN_MENU::NEW', 'arg': [NewMessage.compose,[aOptions]]});

		// if (!bTemplate) {
		// 	aMenu.push({"title": 'MAIN_MENU::NEW_FROM_TEMPLATE', 'arg': [NewMessage.composeTemplate, [aOptions]]});
		// }

		aMenu.push(
			{"title": 'POPUP_ITEMS::DELETE', 'arg': [this,'__deleteFromDG', [ids]], css:'color2 ico2 delete', 'disabled':!aRights.remove}
		);
	}

	return aMenu;
};

_me.__createGWMenu = function(id, ids, sFolType, bMultiple, oRepeating, aAccess, sColumn, oObj, bLimit, aData) {

	var me = this;
	var aMenu = [],
		iFlags = 0,
		sName, aContact;
	oObj = oObj || this._owner;

	if (sFolType == 'G'){
		aMenu.push(
			{"title":'POPUP_ITEMS::RECOVER', css:'ico2 recover', 'arg': [Item.recover, [ids]]}
		);
		if (!dataSet.get('main',['keep_deleted_items_force_expiration'])) {
			aMenu.push(
				{'title':"-"},
				{"title":'POPUP_ITEMS::DELETE', css:'ico2 color2 delete', 'arg': [this,'__deleteFromDG',[ids,oRepeating,oObj]],'disabled':!aAccess.remove}
			);
		}
		return aMenu;
	}

	// if (sFolType == 'L')
	// 	aMenu.push({"title": 'POPUP_ITEMS::OPEN_ITEM', 'disabled': bMultiple, 'arg': [Item.openwindow,[id,null,null,'L']]});
	// else
	if (sFolType == 'F'){

		if (!bMultiple && sPrimaryAccountWebDAV){
			sName = (aData || dataSet.get('items', [id[0], id[1], id[2]])).EVNTITLE;
			if (sName){
				switch(Path.extension(sName)){
				case 'pdf':
					aMenu.push({"title":'POPUP_ITEMS::OPEN', css:'ico2 open', 'arg': [Item.previewItem, [id]], nodes: (GWOthers.getItem('DOCUMENTS', 'disable_office') == 0 && GWOthers.getItem('RESTRICTIONS', 'disable_doc_integration') == 0) && (dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true') && [
						{title: 'DOCUMENT::OPENDOCUMENT', css:'ico2 open_edit', arg: [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName)]]}
					]});
					break;

				case 'mp3':
					if (gui.audio)
						aMenu.push({"title":'ATTACHMENT::PLAY_SOUND', css:'ico2 sound', 'arg': [Item.previewItem, [id]]});
					break;

				default:
					if (Item.editSupport(sName)) {
						aMenu.push({"title":'POPUP_ITEMS::OPEN', css:'ico2 open', 'arg': [Item.previewItem, [id]]});
					} else if (Item.officeSupport(sName)) {
						var aArgAuto = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName)]];
						var aArgWeb = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName), 'edit']];
						var aArgWebView = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName),'view']];
						var aArgExt = [Item.officeOpen, [{aid:id[0],fid:id[1],iid:id[2]},[Item.downloadFile,[id]], Path.extension(sName),'external']];
						var bIWD = dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true';

						aMenu.push({
							title:'POPUP_ITEMS::OPEN',
							css:'ico2 open',
							arg: aArgAuto,
							'nodes':[
								{"title":'DOCUMENT::OPENDOCUMENT', css:'ico2 open_edit', 'arg': aArgWeb, disabled: !bIWD},
								{"title":'DOCUMENT::OPENDOCUMENTVIEW', 'arg': aArgWebView, disabled: !bIWD},
								{"title":'OFFICELAUNCHER::OFFICESUITE', css:'ico2 open_suite', 'arg': aArgExt}
							]
						});

					}
				}
			}
		}

		if(!bLimit) {
			aMenu.push(	{"title":'POPUP_ITEMS::DOWNLOAD_FILE', css:'ico2 download', 'arg': [(bMultiple?Item.downloadMultiple:Item.downloadFile), [bMultiple?ids:id]]});
		}

		//Try to get Lock_id
		var sLockID;
		if (!(sLockID = dataSet.get('items',[id[0], id[1], Is.Array(id[2])?id[2][id[2].length-1]:id[2],'EVNLOCKOWN_ID'])))
			sLockID = dataSet.get('items', [id[0], id[1], Is.Array(id[2])?id[2][id[2].length-1]:id[2],'EVNLOCKOWN_ID']);

		var bLocked = sLockID && sLockID != sPrimaryAccountGWID,
			aRights = WMFolders.getRights({aid:id[0], fid:id[1]});

		//Rename File
		if (oObj){
			aMenu.push({"title":'FORM_BUTTONS::RENAME', css:'ico2 rename', 'arg': [
				function(){

					if (oObj._editColumn){
						oObj._editColumn(id[2],'EVNFILENAME',{restrictions: [[function(name) {
							return !!(name || '').trim() && name.match(/^[^/\\:?"<>|~*]+$/);
						}]]},[Item.edit_value,[id,'EVNFILENAME']]);

						if (oObj.edit){
							var v = (oObj || me._owner).edit._value(),
								p = v.lastIndexOf('.');
							oObj.edit._setRange(0,p>-1?p:v.length);
						}
					}

				}], disabled:bMultiple || !aAccess.modify || !id[2] || bLocked}
			);
			aData = dataSet.get('items', id);
			if (Item.officeSupport(aData.EVNTITLE) && GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 0) {
				aMenu.push({title: 'MAIN_MENU::PRINT', arg: [function() {
					Item.previewItem(id);
				}], css: 'ico2 print'});
			}
		}

		aMenu.push(
			{"title":'-'}
		);

	}
	else
	if(sFolType == 'E') {

		// For calender type, check if it is an open invitation and offer to accept it
		if (!bMultiple) { //ids[2].length==1
			iFlags = (aData && aData.EVNFLAGS?aData.EVNFLAGS:dataSet.get('items',id.concat('EVNFLAGS'))) || 0;

			// If it is an invitation offer to accept it directly in calandar
			if (iFlags&32 || iFlags&8)
				aMenu.push({title:'FILTERS::ACCEPT', css:'ico2 accept', arg: [WMItems,'imip', [{aid: id[0], fid: id[1], iid: id[2]},'accept']]});

			if(!(iFlags&8)) {
				aMenu.push({
					title: 'EVENT::TENTATIVE',
					css: 'ico2 tentative',
					arg: [WMItems, 'imip', [{aid: id[0], fid: id[1], iid: id[2]}, 'tentative']]
				});
			}

			// Delete or if preliminary reject invitation
			if (iFlags&2)
				aMenu.push({"title":'MAIL_VIEW::DECLINE', css:'color2 ico2 decline', 'arg': [this,'__deleteFromDG',[ids,oRepeating,oObj]], 'disabled':!aAccess.remove || bLocked});

			if (aMenu.length)
				aMenu.push({"title":'-'});

			if ((aData || dataSet.get('items', [id[0], id[1], id[2]]) || {}).EVNMEETINGID) {
				aMenu.push({title: 'EVENT::JOINCONFERENCE', css: 'ico2 conference', arg: [async function() {
					await storage.library('wm_conference');
					wm_conference.get((aData || dataSet.get('items', [id[0], id[1], id[2]])).EVNMEETINGID, aData || dataSet.get('items', [id[0], id[1], id[2]])).join();
				}]});
			}
		}

		aMenu.push(
			{
				title: 'POPUP_ITEMS::EDIT',
				css: 'ico2 edit',
				arg: [Item.openwindow, [[id[0], id[1], id[2].split('|')[0]], void 0, aData]],
				disabled: !aAccess.write
			},
			{
				title: 'POPUP_ITEMS::DUPLICATE',
				css: 'ico2 clone_room',
				arg: [Item.cloneEvent, [id]],
				disabled: !aAccess.write || dataSet.get('items',id.concat('EVNCLASS')) == 'O'
			}
		);
	}
	else
	if (sFolType == 'T')
		aMenu.push({"title": 'MAIN_MENU::PRINT', css:'ico2 print', 'arg':[Item.print,[ids]]});
	else
	if (sFolType == 'C'){
		aContact = aData || dataSet.get('items', [id[0], id[1], id[2]]);
		if (!aContact) return aMenu;

		if (aContact.LCTEMAIL1 || aContact.LCTEMAIL2 || aContact.LCTEMAIL3){
			sName = aContact.ITMCLASSIFYAS || ((aContact.ITMSURNAME || '') + (aContact.ITMFIRSTNAME?' '+aContact.ITMFIRSTNAME:'')) || '';

			aMenu.push(
				{"title":'POPUP_ITEMS::SEND_EMAIL_TO', "caption":true}
			);

			['LCTEMAIL1','LCTEMAIL2','LCTEMAIL3'].forEach(function(key){
				if (aContact[key])
					aMenu.push({"text":aContact[key].entityify(),'arg': [NewMessage.compose,[{to:MailAddress.createEmail(sName,aContact[key])}]]});
			});

			aMenu.push({title:'-'});
		}

		if (!bLimit){
			if (window.sPrimaryAccountSIP)
				aMenu.push({"title":'MAIN_MENU::DIAL', css:'ico2 dial', "arg":[obj_context_item.__call,[id]]});

			if (window.sPrimaryAccountCONFERENCE)
				aMenu.push({"title":'MAIN_MENU::CONFERENCE', css:'ico2 conference', "arg":[obj_context_item.__conference,[id]]});

			if (window.sPrimaryAccountSMS && ((GWOthers.getItem('RESTRICTIONS', 'disable_sms') || 0)<1))
				aMenu.push({"title":'MAIN_MENU::SMS', css:'ico2 sms', "arg":[obj_context_item.__sms,[ids]]});
		}

		if (gui.frm_main && gui.frm_main.im){
			var sJID = '';

			if (gui.frm_main.im._is_active()){
				['LCTIM','LCTEMAIL1','LCTEMAIL2','LCTEMAIL3'].some(function(key){
					if (aContact[key] && gui.frm_main.im._inRoster(aContact[key])){
						sJID = aContact[key].toLowerCase();
						return true;
					}
				});
			}

			aMenu.push({"title": 'IM::CHAT', css:'ico2 chat', disabled: !sJID, 'arg':[gui.frm_main.im,'_chat',[sJID]]});
		}

		aMenu.push(
			{"title":'-'},
			{"title": 'MAIN_MENU::PRINT', css:'ico2 print', 'arg':[Item.print,[ids]]}
		);

	}
	else
	if (sFolType == 'L'){
		aContact = aData || dataSet.get('items', [id[0], id[1], id[2]]);
		aMenu.push({"title":'POPUP_ITEMS::SEND_EMAIL_TO',css:'ico2 send', 'arg':[NewMessage.compose,[{to:'['+aContact.fid+'::'+(aContact.ITMCLASSIFYAS || aContact.ITMTITLE)+']'}]]});
	}

	if (sFolType == 'F' && gui.frm_main._dashboardLoaded()) {
		var isPinnedItem = gui.frm_main.dashboard._isPinnedItem({ aid: id[0], fid: id[1], iid: id[2], type: 'file' });
		if (isPinnedItem) {
			aMenu.push({
				title: 'POPUP_ITEMS::UNPIN_FROM_DASHBOARD', css: 'ico2 dashboard_pin', arg: [function() { gui.frm_main.dashboard._unpinItem({ aid: id[0], fid: id[1], iid: id[2] })}]
			});
		} else {
			aMenu.push({
				title: 'POPUP_ITEMS::PIN_TO_DASHBOARD', css: 'ico2 dashboard_pin', arg: [function() { gui.frm_main.dashboard._pinItem({ aid: id[0], fid: id[1], iid: id[2] }, me._main)}]
			});
		}
	}

	var tags = this.__tagSubmenu ? this.__tagSubmenu(ids) : [];
	aMenu.push({title: 'DATAGRID_ITEMS_VIEW::ITMCATEGORY', css: 'ico2 tag', arg: [Item.tags, [ids]], disabled: !aAccess.modify || (list && list._select_all), shortcut: tags.length > 1 ? false : {key: 'T'}, nodes: tags.length > 1 ? tags : false});

	if (aAccess.remove && !bLocked){
		var list = gui.frm_main.main.list;
		var next = list && list.__getNext(ids[2]);
		aMenu.push(
			{"title":'POPUP_ITEMS::MOVE_ITEM_TO', css:'ico2 move_folder', 'arg': [Item.move, [ids, list, next]], nodes:[
				{"title":'POPUP_ITEMS::MOVE_ITEM_TO', css:'ico2 move_folder', 'arg': [Item.move, [ids, list, next]],'disabled':!aAccess.remove || bLocked, shortcut: {key: 'M'}},
				{"title":'POPUP_ITEMS::COPY_ITEM_TO', css:'ico2 copy_folder', 'arg': [Item.copy, [ids, list]], shortcut: {key: 'C'}},
				Alfresco.enabled() && {"title": 'POPUP_ITEMS::COPY_ITEM_TO_ALFRESCO', css:'ico2 alfresco', 'arg': [Item.copyToAlfresco, [ids]]}
			].filter(Boolean)}
		);
		sFolType !== 'E' && aMenu.push({"title":'POPUP_ITEMS::DUPLICATE', css:'ico2 copy_folder', 'arg': [Item.clone, [ids]]});
	}
	else
		aMenu.push(
			{"title":'POPUP_ITEMS::COPY_ITEM_TO', css:'ico2 copy_folder', 'arg': [Item.copy, [ids, list]], shortcut: {key: 'C'}}
		);

	//OTHER
	var tmp_amenu = [];

	if (sFolType == 'F'){
		tmp_amenu.push(
			{"title":'ITEM::UPLOAD_NEW_VERSION', css:'ico2 upload', 'arg': [function(){

				WMItems.list({"aid": ids[0], "fid": ids[1], "iid": ids[2][0], "values": ['ATTACHMENTS']},'','','',[
					async function(aData){

						if (aData && (aData = aData[ids[0]][ids[1]][ids[2][0]])){
							var	tmp_upload = await gui.frm_main._create('TMP_UPLOAD','obj_upload'),
								uid;

							//get previous attachment UID
							for(var i in aData.ATTACHMENTS) {
								if (aData.ATTACHMENTS[i].values.ATTTYPE === 'attachment') {
									uid = aData.ATTACHMENTS[i].values.ATTNAME;
									break;
								}
							}

							//Save uploaded revision
							tmp_upload._onuploadend = function(){
								var addon;

								if (!Is.Empty(addon = this._getAddon())) {

									var aOut = {values: {}},
										now = new IcewarpDate();

									//set UID
									addon[0].uid = uid;

									aOut.values.EVNSTARTDATE = now.format(IcewarpDate.JULIAN);
									aOut.values.EVNSTARTTIME = now.format(IcewarpDate.JULIAN_TIME);
									aOut.values.EVNCOMPLETE = addon[0].values.size;
									aOut.values.EVNTITLE = aOut.values.EVNLOCATION = aOut.values.EVNRID = addon[0].values.description;
									aOut.values.EVNCLASS = 'F';
									aOut['ATTACHMENTS'] = addon;

									WMItems.add(ids, aOut, '', '','',[function(bOK) {
										if (bOK)
											Item.__refreshView(ids, true);
									}]);
								}

								this._destruct();
							};

							//Open dialog
							tmp_upload._setMultipleSelection(false);
							tmp_upload._click();
						}
					}
				]);

			}], 'disabled':!aAccess.modify || bMultiple},

			{"title":'ITEM::NEW_REVISION', css:'ico2 new_revision', 'arg': [function(){
				gui._create('revision', 'frm_revision','','',{aid:ids[0],fid:ids[1],iid:ids[2][0]});
			}], 'disabled':!aAccess.modify || bMultiple},

			{"title":'POPUP_ITEMS::SEND_NOTIFY', css:'ico2 notify', 'arg': [function(){
				gui._create('notify','frm_notify','','',ids);
			}], 'disabled':!aAccess.modify},

			{"title":(sLockID?'FILE::UNLOCK':'FILE::LOCK'), css:'ico2 ' + (sLockID?'unlock':'lock'), 'arg':[Item.set_lock, [ids,sLockID?false:true,true]], 'disabled':!aAccess.modify || (!aRights.owner && bLocked)}
		);
	}
	else{

		var sDownload,
			sDownloadIco = 'download';
		switch (sFolType) {
			case 'C':
			case 'L':
				sDownload = 'DOWNLOAD_VCARD';
				sDownloadIco = 'download_vcard';
				break;
			case 'E':
			case 'J':
			case 'T':
				if (!bMultiple) {
					tmp_amenu.push({
						title: 'EVENT::EMAIL_ATTENDEES',
						css:'ico2 eml',
						arg: [Item.emailAttendees, [id]]
					});
				}
				sDownload = 'DOWNLOAD_VCALENDAR';
				sDownloadIco = 'download_vcal';
				break;
			case 'N':
				sDownload = 'DOWNLOAD_VNOTE';
				sDownloadIco = 'download_vnote';
				break;
			default:
				sDownload = 'DOWNLOAD_SOURCE';
				break;
		}

		tmp_amenu.push(
			{"title":'POPUP_ITEMS::' + sDownload, css:'ico2 ' + sDownloadIco, 'arg': [bMultiple?Item.downloadMultiple:Item.downloadSource, [bMultiple?ids:id]]}
		);

		tmp_amenu.push({"title":'POPUP_ITEMS::ATTACH_TO_EMAIL', css:'ico2 forward', 'arg': [Item.sendAsEmail, [ids]]});

		if (sFolType == 'C'){
			if (sPrimaryAccountCHAT && !bMultiple)
				tmp_amenu.push({"title":'POPUP_ITEMS::COPY_ITEM_TO_TEAMCHAT', css:'ico2 teamchat', 'arg':[Item.copy_tch,[ids]]});

			if (gui.frm_main && gui.frm_main.im){
				sName = aContact.ITMCLASSIFYAS || ((aContact.ITMSURNAME || '') + (aContact.ITMFIRSTNAME?' '+aContact.ITMFIRSTNAME:'')) || '';
				tmp_amenu.push({"title": 'POPUP_ITEMS::ADD_TO_IM', css:'ico2 add_im', disabled: !aContact.LCTIM || !gui.frm_main.im._is_active() || gui.frm_main.im._inRoster(aContact.LCTIM),'arg': [gui.frm_main.im, '_add_item', ['', aContact.LCTIM, sName]]});
			}
		}
	}

	if (sFolType == 'F'){
		aMenu.push({"title":'POPUP_ITEMS::PROPERTIES', css:'ico2 doc_properties', 'disabled': bMultiple || !aAccess.modify, 'arg': [Item.openwindow, [id,null,oRepeating]]});
	}

	if (tmp_amenu.length)
		aMenu.push({"title":'COMMON::MORE_OPTIONS', css:'ico2 more', nodes:tmp_amenu});


	if (sFolType == 'C'){

		var sLct = '',
			bDisabled = !aContact || !['LCTEMAIL1','LCTEMAIL2','LCTEMAIL3'].some(function(key){
				if (aContact[key]){
					sLct = aContact[key];
					return true;
				}
			});

		if(sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT && !bLimit)
			aMenu.push({"title":'POPUP_ITEMS::INVITE_TEAMCHAT', css:'ico2 color1 share_folder teamchat', 'arg':[Item.invite_tch,[sLct]], disabled:bDisabled});
	}
	else
	if (sFolType == 'F'){
		var tmp_nodes = [
			((aData || dataSet.get('items', [id[0], id[1], id[2]])).EVNOWN_ID === sPrimaryAccountGWID || aAccess.modify) && {title:'COLLABORATION::REALTIME_COLLABORATION', css:'ico2 share_folder', 'arg':[Item.collaborate,[ids]]},
			sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT && {"title":'POPUP_ITEMS::COPY_ITEM_TO_TEAMCHAT', css:'ico2 teamchat', 'arg':[Item.copy_tch,[ids]]},
			{"title":'POPUP_ITEMS::ATTACH_TO_EMAIL', css:'ico2 forward', 'arg': [Item.sendAsEmail, [ids]]}
		].filter(Boolean);

		aMenu.push({"title":'POPUP_ITEMS::SHARE', css:'ico2 color1 share_folder', nodes:tmp_nodes, arg:tmp_nodes[0].arg});
	}
	else
	if (sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT && !bMultiple && sFolType !== 'E' && sFolType !== 'T'){
		if (oRepeating) {
			ids[2] = ids[2].map(function(id) {
				return id + '|' + oRepeating.EVNSTARTDATE;
			});
		}
		aMenu.push({"title":'POPUP_ITEMS::COPY_ITEM_TO_TEAMCHAT', css:'ico2 color1 share_folder teamchat', 'arg':[Item.copy_tch,[ids]]});
	}

	if (!bLimit && (!iFlags || !(iFlags&2)))
		aMenu.push({"title":'POPUP_ITEMS::DELETE', css:'color2 ico2 delete', 'arg': [this,'__deleteFromDG',[ids,oRepeating,oObj]], 'disabled':!aAccess.remove || bLocked});

	return aMenu;
};

obj_context_item.createQuarantineMenu = function(ids) {
	var list = gui.frm_main.main.list;
	var next = !Mapping.isGlobalSearchFolder(ids[1]) && list && list.__getNext(ids[2]);
	return [
	{"title": 'POPUP_ITEMS::DELIVER', css:'ico2 deliver', 'arg': [OldMessage.deliver, [ids]]},
	{"title":'-'},
	{"title": 'POPUP_ITEMS::WHITE_LIST', css:'ico2 whitelist', 'arg': [OldMessage.whitelist, [ids, list, next]]},
	{"title": 'POPUP_ITEMS::BLACK_LIST', css:'ico2 blacklist', 'arg': [OldMessage.blacklist, [ids, list, next]]},
	{"title":'-'},
	{"title": 'POPUP_ITEMS::DELETE', css:'color2 ico2 delete', 'arg': [Item.remove, [ids]]}
	];
};

obj_context_item.createBlacklistMenu = function(ids,arg) {
	var list = gui.frm_main.main.list;
	var next = !Mapping.isGlobalSearchFolder(ids[1]) && list && list.__getNext(ids[2]);
	return [
	{"title": 'POPUP_ITEMS::WHITE_LIST', css:'ico2 whitelist', 'arg': [OldMessage.whitelist, [ids, list, next]]},
	// {"title": 'MAIN_MENU::NEW', 'arg': [gui, '_create', ['frm_blackwhite', 'frm_blackwhite', '', '', ids[0], ids[1]]]},
	{"title": '-'},
	{"title": 'POPUP_ITEMS::SEND_EMAIL_TO', css:'ico2 send', 'arg': [NewMessage.compose, [{to:arg.data.SNDEMAIL}]]},
	{"title": '-'},
	{"title": 'POPUP_ITEMS::DELETE', 'css':'color2 ico2 delete', 'arg': [Item.remove, [ids]]}
	];
};

obj_context_item.createWhitelistMenu = function(ids,arg) {
	var list = gui.frm_main.main.list;
	var next = !Mapping.isGlobalSearchFolder(ids[1]) && list && list.__getNext(ids[2]);
	return [
	{"title": 'POPUP_ITEMS::BLACK_LIST', css:'ico2 blacklist', 'arg': [OldMessage.blacklist, [ids, list, next]]},
	// {"title": 'MAIN_MENU::NEW', 'arg': [gui, '_create', ['frm_blackwhite', 'frm_blackwhite', '', '', ids[0], ids[1]]]},
	{"title": '-'},
	{"title": 'POPUP_ITEMS::SEND_EMAIL_TO', css:'ico2 send', 'arg': [NewMessage.compose, [{to:arg.data.SNDEMAIL}]]},
	{"title": '-'},
	{"title": 'POPUP_ITEMS::DELETE', css:'ico2 color2 delete', 'arg': [Item.remove, [ids]]}
	];
};

_me._fillMenu = async function(sType, arg, iid_list, bDisableOpen, aInitMenu, sColumn, oObj)
{
	var id = [arg['aid'], arg['fid'], arg['iid']],
		ids = [arg['aid'], arg['fid'], iid_list],
		bMultiple = iid_list.length > 1,
		aRights = WMFolders.getAccess(arg),
		aMenu = [];

	if (!bMultiple && arg.data && arg.data.EVNOWN_ID == sPrimaryAccountGWID)
		aRights = {'read':true,'write':true,'modify':true,'remove':true,'owner':true};



	if (sColumn == 'COLOR' && aRights.modify) {
		addcss(this._main,"obj_context_itemflags");
		aMenu = obj_context_item.createColorMailMenu(ids);
	}
	else
	switch (sType) {
		case 'E':
		case 'J':
		case 'T':
		case 'N':
		case 'F':
		case 'C':
		case 'G':
		case 'L':
			aMenu = this.__createGWMenu(id, ids, sType, bMultiple,'',aRights,sColumn,oObj);
			break;
		case 'M':
			var sFrom = dataSet.get('items', id.concat(['FROM']));
			aRights.STATIC_FLAGS = dataSet.get('items', id.concat('STATIC_FLAGS'));
			aMenu = await this.__createMailMenu(id, ids, bMultiple, sFrom, aRights);
			break;
		case 'Q':
			aMenu = obj_context_item.createQuarantineMenu(ids);
			break;
		case 'QL':
			if (arg['fid'].indexOf('White') >= 0)
				aMenu = obj_context_item.createWhitelistMenu(ids,arg);
			else
				aMenu = obj_context_item.createBlacklistMenu(ids,arg);
			break;
	}

	if (aInitMenu) {
		aInitMenu = reverse(aInitMenu);
		for (var i in aInitMenu)
			aMenu.unshift(aInitMenu[i]);
	}

	await this._fill(aMenu);
};

obj_context_item.__call = function (id){
	if (id)
		gui.frm_main.__showDialDialog(id[0],id[1],id[2]);
};

obj_context_item.__sms = function (id){
	if (id)
		gui.frm_main.__showSMSDialog(id[0],id[1],id[2]);
};

obj_context_item.__conference = function (id){
	if (id)
		gui.frm_main.__showConferenceDialog(id[0],id[1],id[2]);
};

_me.__deleteFromDG = function (ids, oRepeating, oObj){
	if (ids){
		oObj = oObj || this._owner;

		if (oObj && oObj._type == 'obj_datagrid2_ext' && oObj.__deleteItems){
			var ov = oObj._value();
			if (ids[2].length>1 || ov[0]==ids[2][0]){
				oObj.__deleteItems({aid:ids[0],fid:ids[1]},ids[2],false,oRepeating);
				return;
			}
		}

       	Item.remove(ids,false,oRepeating);
	}
};


_me._fillGeneralMenu = async function(sType, oFolder) {
	var aMenu;

	if (oFolder){
		var aid = oFolder['aid'];
		var fid = oFolder['fid'];
		var aRights = WMFolders.getAccess(oFolder);
	}

	switch(sType) {
		case 'M':

			var aOpt = [];
			if (oFolder){
				aOpt = {alias:Item.getAliasFromPath(aid + '/' + fid)};

				if (GWOthers.getItem('DEFAULT_FOLDERS', 'templates') && ~(aid+'/'+fid + '/').indexOf(GWOthers.getItem('DEFAULT_FOLDERS', 'templates') + '/')) {
					aOpt.template = true;
					aOpt.oSave = {aid: aid, fid: fid};
				}
			}

			aMenu = [{"title": 'MAIN_MENU::NEW', css:'ico2 send', 'arg': [NewMessage.compose, [aOpt]], 'disabled':!aRights.write}];

			if (!aOpt.template)
				aMenu.push({"title": 'MAIN_MENU::NEW_FROM_TEMPLATE', css:'ico2 from_template', 'arg': [NewMessage.composeTemplate, [aOpt]], 'disabled':!aRights.write});

			break;

		case 'QL':
			aMenu = [{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [gui, '_create', ['frm_blackwhite', 'frm_blackwhite', '', '', aid, fid]]}];
			break;

		case 'E':
			var folder = fid;
			if (!aRights.write) {
				folder = Mapping.getDefaultFolderForGWType('E');
			}
			aMenu =[
				{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [Item.createInFolder, [aid, folder]]},
				{"title": '-'},
				{"title": 'MAIN_MENU::DAY_VIEW', 'arg': [gui.frm_main, '_selectView', [oFolder, 'day_view', true]]},
				{"title": 'MAIN_MENU::WEEK_VIEW', 'arg': [gui.frm_main, '_selectView', [oFolder, 'week_view', true]]},
				{"title": 'MAIN_MENU::MONTH_VIEW', 'arg': [gui.frm_main, '_selectView', [oFolder, 'month_view', true]]},
				{"title": 'MAIN_MENU::EVENTS_LIST', 'arg': [gui.frm_main, '_selectView', [oFolder, 'list_view', true]]}
			];
			break;

		case 'C':
			aMenu = [
				{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [Item.createInFolder, [aid, fid]],'disabled':!aRights.write},
				{"title": 'POPUP_ITEMS::NEW_DISTRIBLIST', css:'ico2 new_dl','arg': [Item.create, ['L', {}]],'disabled':!aRights.write}
			];
			break;

		case 'T':
			aMenu = [{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [Item.createInFolder, [aid, fid]],'disabled':!aRights.write}];
			break;

		case 'J':
			aMenu = [{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [Item.createInFolder, [aid, fid]],'disabled':!aRights.write}];
			break;

		case 'N':
			aMenu = [{"title": 'MAIN_MENU::NEW', css:'ico2 new', 'arg': [Item.createInFolder, [aid, fid]],'disabled':!aRights.write}];
			break;

		case 'F':
			aMenu = [
				{"title": 'MAIN_MENU::NEW_UPLOAD', css:'ico2 upload', 'arg': [Item.createInFolder, [aid, fid, false, false, this._oUpload]],'disabled':!aRights.write},
				{"title": '-'},
				{"title": 'MAIN_MENU::NEW_WORD', css:'ico2 word', 'arg': [Item.createInFolder, [aid, fid, {'ATTACHMENTS':[{'values':{'ATTTYPE':'document', 'ATTDESC': '.docx'}}]}]],'disabled':!aRights.write},
				{"title": 'MAIN_MENU::NEW_EXCEL', css:'ico2 xls', 'arg': [Item.createInFolder, [aid, fid, {'ATTACHMENTS':[{'values':{'ATTTYPE':'document', 'ATTDESC': '.xlsx'}}]}]],'disabled':!aRights.write},
				{"title": 'MAIN_MENU::NEW_PPOINT', css:'ico2 ppt', 'arg': [Item.createInFolder, [aid, fid, {'ATTACHMENTS':[{'values':{'ATTTYPE':'document', 'ATTDESC': '.pptx'}}]}]],'disabled':!aRights.write},
				{"title": 'MAIN_MENU::NEW_TEXT', css:'ico2 text', 'arg': [Item.createInFolder, [aid, fid, {'ATTACHMENTS':[{'values':{'ATTTYPE':'document', 'ATTDESC': '.txt'}}]}]],'disabled':!aRights.write},
				{"title": 'MAIN_MENU::NEW_HTML', css:'ico2 html', 'arg': [Item.createInFolder, [aid, fid, {'ATTACHMENTS':[{'values':{'ATTTYPE':'document', 'ATTDESC': '.html'}}]}]],'disabled':!aRights.write}
			];

			break;
	}

	await this._fill(aMenu);
};

_me.__tagSubmenu = function(aIds) {
	aIds[2] = Array.isArray(aIds[2]) ? aIds[2] : [aIds[2]];
	var tags = this.__tags(aIds);

	var allTags = Object.values(dataSet.get('tags') || {});
	allTags.sort(function(a, b) {
		return (b.TAGCOUNT || 1) - (a.TAGCOUNT || 1);
	});

	return allTags.slice(0, 10).map(function(tag) {
		var color = tag.TEXTCOLOR || (tag.TAGCOLOR ? colors.fast_contrast(tag.TAGCOLOR) : '#000');
		var bgcolor = tag.TAGCOLOR;
		if (window.IW_NM && IW_NM.init) {
			color = IW_NM.invertColor(color);
			bgcolor = IW_NM.invertColor(bgcolor || '#fff');
		}

		return {
			text: tag.TAGNAME.entityify(),
			css: 'ico2 tagitem' + (~tags.indexOf(tag.TAGNAME) ? ' check' : ''),
			arg: [this.__tagSubmenuCallback.bind(this), [aIds, tag.TAGNAME]],
			itemStyle: 'color: ' + color + (bgcolor ? '; background-color: ' + bgcolor + '; border-color: ' + bgcolor : '')
		}
	}, this).concat({ title: 'DATAGRID_ITEMS_VIEW::ITMCATEGORY', css: 'ico2 tag', arg: [Item.tags, [aIds]], shortcut: {key: 'T'} });
};

_me.__tagSubmenuCallback = function(aIds, sTag) {
	var tagColumn = this.__tagColumn(aIds);

	var count = aIds[2].length;
	var allContainTag = !aIds[2].some(function(iid) {
		var orig = ((dataSet.get('items', [aIds[0], aIds[1], iid]) || {})[tagColumn] || '').split(/\s?,\s?/).filter(Boolean);
		return !~orig.indexOf(sTag);
	});
	aIds[2].forEach(function(iid) {
		var orig = ((dataSet.get('items', [aIds[0], aIds[1], iid]) || {})[tagColumn] || '').split(/\s?,\s?/).filter(Boolean);
		if (allContainTag && ~orig.indexOf(sTag)) {
			orig = orig.filter(function(tag) {
				return tag !== sTag;
			});
		} else if (!~orig.indexOf(sTag)) {
			orig.push(sTag);
		}

		var data = { values: {} };
		data.values[tagColumn] = orig.join(',');

		WMItems.add([aIds[0], aIds[1], iid], data, 'items', '', '', [
			function (iid, bOK) {
				if (bOK) {
					dataSet.add('items', [aIds[0], aIds[1], iid, tagColumn], orig.join(','));
				}
				if (!--count) {
					gui.frm_main._loadTags();
				}
			}.bind(this, iid)
		]);
	}, this);
};

_me.__tags = function(aIds) {
	var tagColumn = this.__tagColumn(aIds);

	var tags = false;
	aIds[2].forEach(function(iid) {
		var aTags = (dataSet.get('items', [aIds[0], aIds[1], iid, tagColumn]) || '').split(/\s?,\s?/).filter(Boolean);
		if (tags === false) {
			tags = aTags;
		} else {
			tags = aTags.filter(value => tags.includes(value));
		}
	}, this);

	return tags;
};

_me.__tagColumn = function(aIds) {
	var folderType = WMFolders.getType([aIds[0], aIds[1], aIds[2][0]]);
	switch (folderType) {
		case 'C':
			return 'ITMCATEGORY';
		case 'M':
			return 'TAGS';
	}

	return 'EVNTYPE';
};