_me = obj_context_folder.prototype;
function obj_context_folder(){};

_me._onclick = async function(e,elm,id,arg){
	var me = this;

	if (!arg) return true;

	var ftype = WMFolders.getType(arg), frm;
	switch(arg['method'])
	{
		case 'upload':
			gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [gui.frm_main, '__copyItem', [[arg.aid, arg.fid]]], arg.aid, arg.fid, '', gui.frm_main.upload, false, ['F', 'I', 'X'], 'X');
			break;

        case 'view':
            //activate tree node
			await gui.frm_main.bar.folders._setActive(arg.aid+'/'+arg.fid,true);
            //change view
			gui.frm_main._selectView({'aid': arg.aid, 'fid': arg.fid},'',false,'',arg.search?true:false,arg.search);
			break;

		//DEFAULT Folder
		case 'default':
			WMFolders.add({'aid': arg.aid, 'fid': arg.fid, 'default': arg['default']}, 'folders','');
		    break;

		case 'filter':
			addcss(this._owner._main,'obj_tree_search');
			this._owner.inp_search._focus();
			break;

		//SHARING
		case 'share':
			gui._create('frm_sharing','frm_sharing','', ~['I', 'Y'].indexOf(ftype) ? 'teamchat_folder' : '',void 0, {aid:arg.aid,fid:arg.fid});
			break;

		case 'add_favorite':
			WMFolders.addToFavorites(arg);
			break;

		case 'remove_favorite':
			WMFolders.removeFromFavorites(arg);
			break;

		case 'new_template':
			NewMessage.compose({template:true});
			break;

		case 'manage_members':
			WMChat.manageMembers(arg, me._gui);
			break;

		//SYNC
		case 'subscribe':
		case 'unsubscribe':
			//Teamchat folder
			if (gui.frm_main.bar && gui.frm_main.bar.top && gui.frm_main.bar.top.switch){
				if (this._owner._getTreeId){
					elm = document.getElementById(this._owner._getElmId(this._owner._getTreeId(arg.aid + '/' + arg.fid)));
					gui.frm_main.bar.top.switch.__unsubscribeRoom(elm, arg, [function(){
						WMFolders.subscribe(arg, 'folders', '', arg['method'] == 'subscribe' ? 1 : 0);
					}]);
				}
				else{
					WMFolders.subscribe(arg, 'folders', '', arg['method'] == 'subscribe' ? 1 : 0, [function(){
						gui.frm_main.bar.top.switch.__unsubscribeRoom(null, arg);
					}]);
				}
			}
			//Mail folder
			else
				WMFolders.subscribe(arg, 'folders', '', arg['method'] == 'subscribe' ? 1 : 0);

			break;

		//ACCOUNTS
		case 'add_account':
			Folder.addAccount();
			break;

		//FOLDERS
		case 'unsubscribe_folder':
			var sSType = dataSet.get('folders', [arg.aid, arg.fid, 'SUBSCRIPTION_TYPE']);

			if (sSType == 'folder')
				WMAccounts.unsubscribe({aid:arg.aid,subscription:[arg.fid]}, [function(bOK){
					if (bOK){
						if (dataSet.get('active_folder') == arg.aid+'/'+arg.fid)
							gui.frm_main._selectView();
					}
				}]);

			break;

		case 'cal_color':
			if (arg.fid) {
				if (arg.color) {
					getCalendarColor(Path.slash(arg.fid), arg.color);
					me._owner.__update('folders');
					me.__refresh();
				} else {
					this._gui._create('color_picker', 'frm_color_picker', '', '', 'TAGS::CUSTOM_COLOR', arg.currentColor || ('#' + Math.floor(Math.random()*16777215).toString(16)), [function (sColor) {
						if (sColor !== void 0) {
							getCalendarColor(Path.slash(arg.fid), sColor);
							me._owner.__update('folders');
							me.__refresh();
						}
					}.bind(this)]);
				}
			}
			break;

		case 'selectAllCalendars':
			var aVirtual = dataSet.get('folders', [sPrimaryAccount, '__@@VIRTUAL@@__/__@@EVENTS@@__', 'VIRTUAL', 'FOLDERS'], true) || {};
			var aFolders = dataSet.get('folders', [arg.aid || sPrimaryAccount]);
			var resourcesFolder = dataSet.get('main', ['resources_path']);
			var fids = [];
			var i;

			if (arg.resources) {
				for (i in aFolders) {
					if (aFolders[i].TYPE === 'E' && !i.indexOf(resourcesFolder)) {
						fids.push(i);
					}
				}
			} else if (arg.fid) {
				for (i in aFolders) {
					if (aFolders[i].TYPE === 'E' && (arg.fid === i || !i.indexOf(arg.fid + '/'))) {
						fids.push(i);
					}
				}
			} else if (arg.aid) {
				for (i in aFolders) {
					if (aFolders[i].TYPE === 'E' && !aFolders[i].OWNER && !aFolders[i].VIRTUAL && !!i.indexOf(resourcesFolder)) {
						fids.push(i);
					}
				}
			}

			fids.forEach(function(fid) {
				if (arg.select) {
					aVirtual[fid] = false;
				} else {
					delete aVirtual[fid];
				}
			});

			if (!Object.keys(aVirtual).length) {
				aVirtual[Mapping.getDefaultFolderForGWType('E')] = false;
			}

			dataSet.add('folders', [sPrimaryAccount, '__@@VIRTUAL@@__/__@@EVENTS@@__', 'VIRTUAL', 'FOLDERS'], aVirtual);

			WMFolders.add({
				aid: sPrimaryAccount,
				fid: '__@@VIRTUAL@@__/__@@EVENTS@@__',
				name: '__@@VIRTUAL@@__/__@@EVENTS@@__',
				type: 'E',
				virtual: {
					folders: aVirtual
				}
			}, 'folders', '', [this, '__refresh', [arg]]);
			break;

		case 'add_virtual':
			gui._create('frm_virtual','frm_virtual','','',arg.fid,'',[obj_context_folder.__openFolder]);
			break;

		case 'add_folder':
			Folder.addFolder(arg, [obj_context_folder.__openFolder]);
			break;

		case 'add_room':
			gui._create('frm_addroom','frm_addroom','','',arg.aid,arg.fid, [obj_context_folder.__openFolder]);
			break;

		case 'clone':

			var org = dataSet.get('folders', [arg.aid, arg.fid]);
			if (org.TYPE == 'I' && (org.NAME || org.RELATIVE_PATH)){

				var sFolderName = [org.NAME || Path.basename(org.RELATIVE_PATH), getLang('CHAT::CLONE')].join(' '),
					aData = {
						'type':org.TYPE,
						'aid':sPrimaryAccount,
						'clone':arg.aid +'/'+ arg.fid
					};

				//PRIVATE
				if (org.OWNER && ~org.OWNER.indexOf('##internalservicedomain.icewarp.com##')){
					aData.name = org.OWNER + '/TeamChat/' + sFolderName;
					aData.private = true;
				}
				else
					aData.name = Path.basedir(arg.fid) + '/' + sFolderName;

				WMFolders.add(aData,'folders','', [function(aFolderInfo){
					if (aFolderInfo){
						var aData = {
							aid:aFolderInfo.aid,
							fid:aFolderInfo.name
						};

						gui.frm_main._selectView(aData);
						obj_context_folder.__openFolder(aData);
					}
				}]);
			}

			break;

		case 'delete_folder':
			Folder.delete(arg);
			break;

		case 'sendEmailToAllMembers':
			if (!arg.aid || !arg.fid){
				return;
			}
			var newMessage = new NewMessage();
			// newMessage.addSignature();
			var name = dataSet.get('folders', [arg.aid, arg.fid, 'NAME']) || dataSet.get('folders', [arg.aid, arg.fid, 'RELATIVE_PATH']);
			newMessage.sTo = '[' + arg.fid + '::' + name + ']';

			newMessage.sSubject = '';

			gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
				context: 'obj_context_folder',
				fun: ['prototype', '_onclick'],
				args: ['', '', '', arg]
			});
			break;

		case 'move_folder':
			if (ftype!='X' && WMFolders.getRights(arg,'modify')){
				frm = await gui._create('frm_select_folder','frm_select_folder','','','POPUP_FOLDERS::MOVE_FOLDER',arg['aid'],arg['fid'],[function (aid, fid, f){
						obj_context_folder.__moveFolder(aid, dataSet.get('folders', [arg.aid, f, 'RELATIVE_PATH']) || f, (fid?fid + '/':'') + (dataSet.get('folders', [aid, f, 'NAME']) || Path.basename(f)));
					},[arg['fid']]],false,true,WMFolders.getType(arg));

				//Make all node types selectable
				frm.tree_folder._isSelectable = function(idt){
					return idt.ftype != "X" || !!idt['public'];
				};
			}
			else
				gui.notifier._value({type: 'alert', args: {header: '', text: 'CONTEXT_FOLDER::CANTMOVE'}});
			break;

		case 'save_folder':
			Folder.save(arg);
			break;

		case 'empty_folder':
			var sFullPath = arg['aid'] + '/' + arg['fid'],
				sTrashFolder = GWOthers.getItem('DEFAULT_FOLDERS', 'trash'),
				sFolderType = WMFolders.getType(arg);

			if (sFullPath == sTrashFolder || sFolderType == 'R' || sFolderType == 'G' || parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'delete_emptyfolder'))>0)
				frm = await gui._create('frm_confirm', 'frm_confirm', '', '',[function() {
					WMFolders.__emptyFolder(arg['aid'], arg['fid'], false, (dataSet.get('current_folder') === (arg.aid + '/' + arg.fid)) && (gui.frm_main.main.list._SQLsearch || '').replace(/\+folders:".*?"/, '').trim());
				}],
					GWOthers.getItem('DEFAULT_FOLDERS','trash') === arg.aid + '/' + arg.fid ? 'CONFIRMATION::EMPTY_TRASH_CONFIRMATION' : 'CONFIRMATION::EMPTY_FOLDER_CONFIRMATION',
					GWOthers.getItem('DEFAULT_FOLDERS','trash') === arg.aid + '/' + arg.fid ? 'CONFIRMATION::EMPTY_TRASH' : 'CONFIRMATION::EMPTY_FOLDER'
				);
			else
				frm = await gui._create('frm_confirm', 'frm_confirm', '', '',[function() {
					WMFolders.__emptyFolder(arg['aid'], arg['fid'], true, (dataSet.get('current_folder') === (arg.aid + '/' + arg.fid)) && (gui.frm_main.main.list._SQLsearch || '').replace(/\+folders:".*?"/, '').trim());
				}],
					'CONFIRMATION::EMPTY_FOLDER_CONFIRMATION', 'CONFIRMATION::EMPTY_TO_TRASH'
				);

			addcss(frm.x_btn_ok._main,'color2');
			break;

		case 'mark_all_as_read':
		case 'mark_all_as_unread':
			var bRead = arg['method'] == 'mark_all_as_read' ? true : false;

			WMFolders.markItemsRead({'aid':arg.aid,'fid':arg.fid, filter: (dataSet.get('current_folder') === (arg.aid + '/' + arg.fid)) && gui.frm_main.main && gui.frm_main.main.list && (gui.frm_main.main.list._SQLsearch || '').replace(/\+folders:".*?"/, '').trim()},'folders','',bRead);
			break;

		case 'copyall':
		case 'moveall':
			gui._create('frm_select_folder', 'frm_select_folder', '', '', 'POPUP_ITEMS::' + (arg['method']=='copyall'?'COPY_MAIL_TO':'MOVE_MAIL_TO'), arg['aid'],arg['fid'],
				[Folder, '_copyOrMoveAll', [arg]], false, false, WMFolders.getType(arg),'w');
			break;

		case 'change_channel':
			gui._create('frm_change_channel','frm_change_channel','','',arg.aid,arg.fid);
			break;

		case 'rename_folder':
			if ((ftype!='X' && WMFolders.getRights(arg,'modify')) || (ftype == 'I' && WMFolders.getRights(arg,'write')) && this._owner._rename) {
				this._owner._rename(arg);
			} else {
				gui.notifier._value({type: 'alert', args: {header: '', text: 'CONTEXT_FOLDER::CANTRENAME'}});
			}
			break;

		case 'pin_folder':
			gui.frm_main.dashboard._pinItem({aid: arg.aid, fid: arg.fid, type: 'folder'}, me._main);
			break;
		case 'unpin_folder':
			gui.frm_main.dashboard._unpinItem({aid: arg.aid, fid: arg.fid, type: 'folder'});
			break;

		default:
			return true;
	}
};

_me.__refresh = function(){
	gui.frm_main._selectView({aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@EVENTS@@__'}, '', true);
};

//static method
obj_context_folder.__deleteFolder = function(sAccountID,sFolderID){

	var aFolders = dataSet.get('folders',[sAccountID]),
		bPerfm = false,
		bRefresh = false,
		sActive = dataSet.get('active_folder');

	for(var i in aFolders)
		if (i == sFolderID || i.indexOf(sFolderID+'/') === 0){
			bPerfm = true;
			if (sActive && !bRefresh && (sActive == sAccountID+'/'+i || sActive.indexOf(sAccountID+'/'+i+'/') == 0))
				bRefresh = true;

			delete aFolders[i];
		}

	//	bNoRefresh = true protoze pracujeme primo s datasetem, proto po add neni zmena dat (add je jen pro sychr)
    //	Notne vyvolat refresh manualne
	if (bPerfm){
		dataSet.add('folders',[sAccountID],aFolders,true);
		dataSet.update('folders',[sAccountID]);
	}

	if (bRefresh)
		gui.frm_main._selectView();

	WMFolders.remove({'aid':sAccountID,'fid':sFolderID},'folders');
};

obj_context_folder.__moveFolder = function(sAccount, sOldFolder, sNewFolder, bDeactivate){
	var aFolders = dataSet.get('folders', [sPrimaryAccount]);
	for(var f in aFolders) {
		if (f.toLowerCase() == sNewFolder.toLowerCase() || aFolders[f].RELATIVE_PATH && (aFolders[f].RELATIVE_PATH.split('/').slice(0, -1).concat(aFolders[f].NAME || f.split('/')[0]).join('/') === sNewFolder)) {
			var name = WMFolders.getFolderPath({aid: sPrimaryAccount, fid: aFolders[f].RELATIVE_PATH});
			gui.notifier._value({
				type: 'alert',
				args: {
					header: '',
					text_plain: getLang('ALERTS::FOLDER_EXIST', [name.escapeHTML()])
				}
			});
			return;
		}
	}

	//var sNewFolder = (sNewFolder?sNewFolder + '/':'') + Path.basename(sOldFolder),
	var	sActive = dataSet.get('active_folder');

	//Moving active folder or its parent?
	if (sActive == sAccount+'/'+sOldFolder || sActive.indexOf(sAccount+'/'+sOldFolder+'/') == 0){

		//Remove selection from main tree
		gui.frm_main.bar.folders._invalidateActive();

		//Force redraw for "Move to trash" add moving parent
		if (bDeactivate || sActive != sAccount+'/'+sOldFolder)
			gui.frm_main._selectView();
		else{

			WMFolders.add({'aid':sAccount,'fid':sOldFolder,'name':sNewFolder},'folders','',
				//Success
				[function(aData){
					if(gui.frm_main && gui.frm_main.bar && gui.frm_main.bar.tree && gui.frm_main.bar.folders && gui.frm_main.bar.folders.recent) {
						gui.frm_main.bar.folders.recent.recent = [];
						gui.frm_main.bar.folders.recent.__search('');
					}
					if (aData.aid && aData.name) {
						var fid = [aData.name.split('/').slice(0, -1).join('/'), aData.fid.split('/').pop()].filter(Boolean).join('/');
						aData = {
							aid: aData.aid,
							fid: dataSet.get('folders', [aData.aid, aData.name]) ? aData.name : dataSet.get('folders', [aData.aid, fid]) ? fid : aData.fid
						};

						if (WMFolders.getType(aData) === 'I') {
							gui.frm_main.main.__current = {};
						}
						dataSet.add('active_folder', '', '', true);
						dataSet.add('current_folder', '', '', true);
						gui.frm_main.bar.__sActiveFolder = '';

						gui.frm_main._selectView(aData);
						obj_context_folder.__openFolder(aData);
					}
					else
						gui.frm_main._selectView();
				}]
			);

			return;
		}
	}

	WMFolders.add({'aid':sAccount,'fid':sOldFolder,'name':sNewFolder},'folders','', [function() {
		if(gui.frm_main && gui.frm_main.bar && gui.frm_main.bar.tree && gui.frm_main.bar.folders && gui.frm_main.bar.folders.recent) {
			gui.frm_main.bar.folders.recent.recent = [];
			gui.frm_main.bar.folders.recent.__search('');
		}
	}]);
};

obj_context_folder.__openFolder = function (aFolderInfo){
	if (aFolderInfo.name)
		aFolderInfo.fid = aFolderInfo.name;

	try{
		var p;
		if ((p = aFolderInfo.fid.lastIndexOf('/'))>-1)
			gui.frm_main.bar.folders._open(aFolderInfo.aid +'/'+ aFolderInfo.fid.substr(0,p),'minus');
		else
			gui.frm_main.bar.folders._open(aFolderInfo.aid,'minus');
	}
	catch(r){ console.log(this._name||false,r);}
};
