/**
 * PopUp menu
 * Inherite: obj_hmenu
 **/
_me = obj_context.prototype;
function obj_context(){};

_me.__constructor = async function(owner){
	var me = this;

	this._owner = owner;
	this._zindex = new cMaxZIndex();

	//pass itself as event attribute
	AttachEvent (this._main, 'onclick', function(e){
		e.__source = {obj:me, skip:true, type:'obj_context'};
	});

	this._gui._obeyEvent('resize', [this, '__onGuiResize']);
	this._add_destructor('__destructResizeEvn');

	this._gui._obeyEvent('click',[this,'__destructCmenu']);
	this._add_destructor('__destructClickEvn');
};

_me.__destructCmenu = function(e){

	var elm;
	if (e &&Is.Child(e.target, this._main) && (elm = Is.Child(e.target, 'LI', this._main)) && (elm = elm.firstChild) && elm.tagName == 'DIV' && Is.Defined(elm.id)){
		var id = elm.id.substr(this._pathName.length+1);
		if (this.__idtable[id] && this.__idtable[id].keep){
			e.stopPropagation();
			e.preventDefault();
		}
	}

	if (!e || !this._onclose || this._onclose(true, e) !== false)
		this._destruct();
};

	_me.__destructClickEvn = function(){
		if (this.__modaldiv && this.__modaldiv.parentNode) {
			this.__modaldiv.parentNode.removeChild(this.__modaldiv);
		}

		this._gui._disobeyEvent('click',[this,'__destructCmenu']);

		if (this._onclose)
			this._onclose();

		if (this.__zindex)
			this._zindex.remove(this.__zindex);

	};

_me._onclick = function(e, elm, id, arg) {
	if (arg)
		executeCallbackFunction(arg);
};

/*
	Legacy menu placement

	x, y 		position
	width 		optional width
	vertical	1 from top
				2 from top if possible
				3 from bottom
*/
_me._place = function(x,y,width,vertical,bForce){

	var mode = 'right';

	switch(+vertical){
		case 1:
		case 2:
			mode = 'top';
			break;
		case 3:
			mode = 'bottom';
	}

	this._placeMenu({x:x,y:y},{width:width, mode:mode, force: bForce});
};


/**
 * New method for context-menu placement
 * Allows to place menu over element or x/y point
 *
 * @param {node}	elm		DOM node or {x:int, y:int} object
 * @param {obj}		opt		{width: [int], mode:[str:top|bottom|left|right]}
 */
_me._placeMenu = function(elm, opt){

	opt = Object.assign({mode:'right'}, opt);

	if (!this.__eArrow)
		this.__eArrow = this._main.appendChild(mkElement('div'));

	if (Is.Number(opt.width)){
		var ul = this._main.getElementsByTagName('UL');
		if (ul && (ul = ul[0])) ul.style.width = opt.width +'px';
	}

	if (this.__position && this.__position.scrollable)
		removecss(this._main,'scrollable');

	var mSize = getSize(this._main),
		eSize = Is.Element(elm)?getSize(elm):Object.assign({w:0, h:0}, elm),
		doc = this._main.ownerDocument.defaultView,
		dh = doc.innerHeight || doc.document.body.clientHeight,
		dw = doc.innerWidth || doc.document.body.offsetWidth,
		eArrow = this.__eArrow;

	//switch mode in RTL
	if (gui._rtl)
		opt.mode == ({right:'left', left:'right'})[opt.mode] || opt.mode;

	this.__position = {};

	function place(mode, bForce){
		var ex,ey, position = {};

		switch(mode){
			case 'left':
				ex = eSize.x;
				ey = eSize.y + eSize.h/2;

				position.x = dw - ex + 7;
				position.y = ey - 16;

				if (!bForce && ex - mSize.w - 7 < 9)
					return place('right', true);

				//fit screen-height
				if (position.y + mSize.h + 20 > dh){
					position.y = ey + (dh - position.y - mSize.h - 20);

					if (position.y < 9){
						position.y = 9;
						position.scrollable = true;
					}
				}

				eArrow.style.top = (ey - position.y - 8) + 'px';
				eArrow.style.left = 'auto';
				eArrow.style.right = '-14px';
				break;

			case 'right':
				ex = eSize.x + eSize.w;
				ey = eSize.y + eSize.h/2;

				position.x = ex + 7;
				position.y = ey - 16;

				//fit screen-width
				if (!bForce && position.x + mSize.w > dw - 9)
					return place('left', true);

				//fit screen-height
				if (position.y + mSize.h + 20 > dh){
					position.y = ey + (dh - position.y - mSize.h - 20);

					if (position.y < 9){
						position.y = 9;
						position.scrollable = true;
					}
				}

				eArrow.style.top = (ey - position.y - 8) + 'px';
				eArrow.style.right = 'auto';
				eArrow.style.left = '-14px';
				break;

			case 'top':
				ex = eSize.x + eSize.w/2;
				ey = eSize.y;

				position.x = ex - mSize.w/2;
				if (position.x + mSize.w + 9 > dw)
					position.x = Math.max(0, dw - mSize.w - 9);
				if (position.x < 0)
					position.x = Math.max(0, position.x);

				position.y = ey - mSize.h - 7;

				if (!bForce && position.y < 8)
					return place('bottom', true);

				eArrow.style.left = ex - position.x + 'px';
				eArrow.style.right = 'auto';
				break;

			case 'bottom':
				ex = eSize.x + eSize.w/2;
				ey = eSize.y + eSize.h;

				position.x = ex - mSize.w/2;
				if (position.x + mSize.w + 9 > dw)
					position.x = Math.max(0, dw - mSize.w - 9)
				if (position.x < 0)
					position.x = Math.max(0, position.x);

				position.y = ey;
				if (!bForce && position.y + mSize.h > dh - 9)
					return place('top', true);

				eArrow.style.left = ex - position.x + 'px';
				eArrow.style.right = 'auto';
				break;
		}

		position.mode = mode;

		return position;
	}

	this.__position = place(opt.mode, opt.force);
	this.__position.elm = elm;
	this.__position.defaultMode = opt.mode;

	switch(this.__position.mode){
		case 'left':
			this._main.style.top = this.__position.y +'px';
			this._main.style.right = this.__position.x +'px';
			this._main.style.left = 'auto';
			this._main.style.bottom = 'auto';
			break;

		case 'right':
			this._main.style.top = this.__position.y +'px';
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.bottom = 'auto';
			break;

		case 'top':
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.top = this.__position.y +'px';
			this._main.style.bottom = 'auto';
			break;

		case 'bottom':
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.top = this.__position.y +'px';
			this._main.style.bottom = 'auto';
			break;
	}

	this._main.setAttribute('iw-mode', this.__position.mode);

	if (this.__position.scrollable)
		addcss(this._main,'scrollable');

	//Z-index
	if (!opt.resize){
		this._focus();
	}
};

_me._focus = function() {
	if (this.__zindex)
		this._zindex.remove(this.__zindex);

	this._main.style.zIndex = this.__zindex = this._zindex.get();
};

_me.__onGuiResize = function(){
	if (this.__position && this.__position.defaultMode){
		this._placeMenu(this.__position.elm, {mode:this.__position.defaultMode, resize:true});
		return;
	}
};

	_me.__destructResizeEvn = function(){
		this._gui._disobeyEvent('resize', [this, '__onGuiResize']);
	};

_me._modal = function(b){

	if (b && !this.__modaldiv){
		// Remove previous z-index and assign new top value
		if (this._zindex) {
			this._zindex.remove(this.__zindex);
		}
		this._main.style.zIndex = this.__zindex = this._zindex.get();

		//modal window
		this.__modal = true;

		this.__modaldiv = mkElement("div",{className: 'obj_context_modaldiv'});
		this.__modaldiv.style.zIndex = parseInt(this.__zindex) - 1;
		this.__modaldiv.onclick = function(e){
			if (this._onclose) {
				this._onclose(e);
			}
		}.bind(this);

		this._main.parentNode.insertBefore(this.__modaldiv, this._main);
	} else if (!b && this.__modaldiv) {
		if (this.__modaldiv.parentNode) {
			this.__modaldiv.parentNode.removeChild(this.__modaldiv);
		}

		this.__modaldiv = null;
	}
};