_me = obj_connection.prototype;
function obj_connection() { };

/**
 *  The purpose of the connection object is to display
 *	error messages to the end user when there are problems
 *	with the network
 */
_me.__constructor = async function () {
	this.__requests = [];
	this.__count = null;

	this._add_destructor('__destructor');
};

_me._queue = function (iCode, iDelay, aHandler, aErrorHandler) {
	var arr = {
		id: unique_id(),
		code: iCode,
		delay: iDelay || 0,
		handler: aHandler,
		errorHandler: aErrorHandler
	},
		old = this._queueInRequests(arr);

	if (old)
		return old.id;

	this.__requests.push(arr);
	this.__exeEvent('_queue', false, { "owner": this, id: arr.id });

	// Prevent showing after computer sleep
	if (!cRequest || !(cRequest.lapse > 70 || cRequest.lapse < 1)) {
		this._show();
	}

	return arr.id;
};

/**
 * Return whether passed object exists among this.__requests
 * specified by `obj.code`, `obj.delay`, `obj.handler` and `obj.errorHandler`
 * @param {Object} obj
 * @param {Object} obj.code
 * @param {Number} obj.delay
 * @param {Array|Function} [obj.handler]
 * @param {Array|Function} [obj.errorHandler]
 * @returns {Boolean}
 */
_me._queueInRequests = function (obj) {
	return (this.__requests.filter(function (request) {
		return obj.code === request.code
			&& obj.delay === request.delay
			&& getCallbackFunction(obj.handler) === getCallbackFunction(request.handler)
			&& getCallbackFunction(obj.errorHandler) === getCallbackFunction(request.errorHandler);
	})).pop();
};

// Execute requests in buffer, if any
_me._flush = function () {
	if (this.__notification) {
		gui.notifier._closeNotification(this.__notification);
	}
	for (var iq, i = 0, j = this.__requests.length; i < j; i++) {
		if ((iq = this.__requests.shift()) && iq.handler) {
			executeCallbackFunction(iq.handler);
		}
	}

	this.__exeEvent('_flush', false, { "owner": this });
	this._show();
};

// Clear out whole buffer
// Display only information, never retry
_me._clear = function () {
	if (this.__notification) {
		gui.notifier._closeNotification(this.__notification);
	}
	for (var iq, i = 0, j = this.__requests.length; i < j; i++) {
		if ((iq = this.__requests.shift()) && iq.errorHandler) {
			executeCallbackFunction(iq.errorHandler, false);
		}
	}

	this.__exeEvent('_flush', false, { "owner": this });
	this._show();
};

// hide notification
_me._hide = function (id) {
	if (this.__notification) {
		gui.notifier._closeNotification(this.__notification);
	}
	if (Is.Defined(id)) {
		var bShow = false;

		this.__requests = this.__requests.filter(function (a) {
			if (id == a.id) {
				bShow = true;
				return false;
			}
			return true;
		});

		if (bShow) {
			this._show();
		}
	}
};

// Display error message to end user according to error code and type
_me._show = function () {
	var me = this;

	//reset title
	if (this.__titleID && gui.frm_main && gui.frm_main.title) {
		gui.frm_main.title._remove(this.__titleID, true);
	}

	var iq = this.__requests[0];
	if (iq) {
		if (this.__notification) {
			gui.notifier._closeNotification(this.__notification);
		}
	
		gui._main.classList.remove('server_overload');
	
		// Determine error type (and map it to messages in template)
		// Show countdown/retry button according to http code and retry possible
		var error;
		switch (iq.code) {
			// Display only information, never retry
			case 404:
				error = 'ERROR::FILENOTFOUND';
				iq.delay = 0;
				break;

			case 500:
				error = 'ERROR::SERVERERROR';
				iq.delay = 0;
				break;

			// Display only information, no earlier retry possible
			case 503:
				error = 'ERROR::OVERLOADED';
				gui._main.classList.add('server_overload');
				break;

			default:
				error = 'ERROR::CONNECTION';
		}

		// this.__notification = gui.notifier._value({
		// 	type: 'request_error',
		// 	args: {
		// 		interval: iq.delay,
		// 		callback: {
		// 			success: function() { // retry interval auto countdown
		// 				me._flush();
		// 			},
		// 			retry: iq.delay && iq.code !== 503 && function() {
		// 				me._flush();
		// 			},
		// 			cancel: iq.delay && function() {
		// 				me._clear();
		// 			}
		// 		},
		// 		code: iq.code,
		// 		text_plain: getLang(error) + (iq.code === 503 ? ' (' + iq.delay + ')' : '')
		// 	},
		// 	browserOnly: true
		// });
		if (!iq.delay) {
			me.__requests.shift();
			me._show();
		}

		// Show title notification
		// if (gui.frm_main && gui.frm_main.title) {
		// 	this.__titleID = gui.frm_main.title._add(getLang('TITLE::CERROR'), 5);
		// }
	}
}
