_me = obj_conference_schedule.prototype;

function obj_conference_schedule() {};

_me.__constructor = async function () {
	var me = this;

	this.__opt = {
		back_button: getLang('FORM_BUTTONS::BACK'),
		recording: ~['jitsi', 'jitsi-full'].indexOf(dataSet.get('accounts',[sPrimaryAccount, 'MEETING_PROVIDER'])),
		recording_missing: !sPrimaryAccountRECORDING
	};

	this.__aValues = {
		values:{
			_TZID: normalizeTimezone(GWOthers.getItem('CALENDAR_SETTINGS', 'timezone'))
		}
	};

	await this._draw('obj_conference_schedule','cell', {
		recording: this.__opt.recording,
		recording_missing: this.__opt.recording_missing,
	});

	//Set default date
	this.__init_date();

	this.title._onerror = function(b){
		this.btn_save._disabled(b);
	}.bind(this);
	this.title._restrict(".+");

	this.btn_save._onclick = function(){
		this.__save();
	}.bind(this);

	this.suggest._single = true;
	this.suggest._itemClass = 'C';

	this.suggest._disobeyEvent('change', [this.suggest, '_checksize']);
	this.suggest._checksize = function() {};
	this.suggest._placeholder(getLang('ATTENDEES::QUICK_ADD'));
	this.suggest._onsubmit = function(){
		if (!this._checkError.length) {
			var tmp = MailAddress.splitEmailsAndNames(this._value());
			this._value('');
			if (tmp && tmp[0] && tmp[0].email) {
				tmp[0].role = 'Q';
				me.user_list._addUser(tmp[0], true);
			}
		}
	};
	this.suggest.__minWidth = 400;
	this.suggest._onmouseselect = this.suggest._onsubmit;
	this.suggest._restrict([function(v) {
		if (v === '') return true;
		var tmp = MailAddress.splitEmailsAndNames(v);
		if (tmp && tmp[0] && tmp[0].email) {
			return Is.Email(tmp[0].email);
		}
		return false;
	}]);

	this.user_list = this._getAnchor('user_list');
	this.user_list.__users = [];

	this.user_list.onclick = function(e){
		var elm = e.target,
			bModerator = false,
			bRemove = false;

		if (elm.tagName == 'SPAN') {
			bRemove = true;
			elm = elm.parentNode;
		} else if (elm.classList.contains('make_moderator')) {
			bModerator = true;
			elm = elm.parentNode;
		}

		if(!elm.id) {
			elm = elm.parentNode;
		}

		var id = elm.id.substr((me._pathName+'.list/').length);

		if (this.__users[id]){
			if (bModerator)
				me.user_list._moderator(id);
			else if (bRemove)
				me.user_list._removeUser(id);
		}
	};

	//get all active rows
    this.user_list._getActive = function(){
		var active = [];
		for(var i in this.__users)
			if (this.__users[i] && this.__users[i].active && this.__users[i].action != 'remove')
                active.push(i);

		return active;
	};

	//fill list
	this.user_list._fill = function(){
		var css, out = mkElement('div');

		this.__users = this.__users.sort(function(a, b) {
			return (a.role === 'G') ? -1 : (b.role === 'G');
		});

		if (!this.__users.some(function(user) {
			return user.email === sPrimaryAccount;
		})) {
			this.__users.push({
				email: sPrimaryAccount,
				role: 'G',
				status: 'A',
				moderator: true
			})
		}

		for(var i = 0; i < this.__users.length; i++){
			var myself = this.__users[i].email === sPrimaryAccount;

			css = [];
			if (this.__users[i].status)
				css.push('status_' + this.__users[i].status);

			if (this.__users[i].role)
				css.push('role_' + this.__users[i].role);

			if(this.__users[i].moderator || myself)
				css.push('moderator');

			var name = myself ? getLang('COMMON::YOU') : (this.__users[i].name || this.__users[i].email).escapeHTML();
			out.appendChild(mkElement('div',{
				id: me._pathName + '.list/' + i,
				className: css.join(' '),
				unselectable: 'on',
				title: this.__users[i].email + ' - ' + getLang('ATTENDEES::ROLE_' + this.__users[i].role.toUpperCase()),
				innerHTML: obj_avatar.getAvatarHTML({ email: this.__users[i].email, name: name || this.__users[i].email, size: 28 }) + name + (this.__users[i].email !== sPrimaryAccount ? '<div class="make_moderator"></div><span></span>' : '')
			}));
		}

		this.innerHTML = out.innerHTML;
		out = null;
	};
	this.user_list._fill();

	//add user
	this.user_list._addUser = function(aInfo, bSkipNew){
		if (aInfo.email && aInfo.email.indexOf('[') === 0){
			(new wm_tools()).distrib({
				name: aInfo.email
			}, [this, '_addGroup', [aInfo.role,bSkipNew]]);
			return false;
		} else {
			aInfo.email = aInfo.email.toLowerCase();
			for(var i = this.__users.length - 1; i > -1; i--)
				if (this.__users[i].email == aInfo.email && this.__users[i].action != 'remove') //ignore
					return false;

			if(!bSkipNew) {
				aInfo.action = 'new';
			}
			this.__users.push(aInfo);
			this._fill();

			return true;
		}
	};

	//add group of users
	this.user_list._addGroup = function(aData, sRole, bSkipNew){

		for(var i in aData){
			aData[i].role = sRole;
			this._addUser(aData[i],true,bSkipNew);
		}
	};

	this.user_list._moderator = function(i){
		this.__users[i].moderator = !this.__users[i].moderator;
		this._fill();
	};

	this.user_list._removeUser = function(id){
		this.__users.splice(id, 1);
		return this._fill();
	};

	this.user_list._getAttendees = function() {
		return this.__users.map(function(user) {
			return {values: {
				CNTCONTACTNAME: user.name,
				CNTEMAIL: user.email,
				CNTROLE: user.role,
				CNTSTATUS: user.status,
				CNT_ID: user.id,
				CNTMODERATOR: +(user.moderator == '1')
			}};
		});
	};

	this._getAnchor('link_more').onclick = async function(){
		var val = this.__value(),
			aOut = val.values;

		Object.keys(val).forEach(function(k){
			if (k != 'values')
				aOut[k] = val[k];
		});
		// aOut.conference = true;

		//convert attachments
		if (Is.Array(aOut.ATTACHMENTS)){
			aOut.ATTACHMENTS = aOut.ATTACHMENTS.map(function(att){
				return {values:{
					ATTDESC:att.values.description,
					ATTTYPE:att.values.class,
					FULLPATH:att.values.fullpath,
					ATTSIZE:att.values.size
				}};
			});
		}

		var frm = await Item.openwindow([sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')], aOut, null, null, [function() {}]);

		frm._modal(true);

		frm.MEETING_ACTION._disabled(true);
		frm.X_PATH._disabled(true);

		if (aOut.EVNSHARETYPE == 'P')
			frm.X_ITMSHARETYPE.__privateValue = 'P';
		frm.X_ITMSHARETYPE._value(aOut.EVNSHARETYPE);

		frm.x_btn_ok._value('FORM_BUTTONS::OK');
		frm.x_btn_ok._onclick = async function(){
			this.__value(await frm.__readItems(true));
			frm._destruct();
		}.bind(this);

		frm._openConferenceSetup();

	}.bind(this);

	var password = this.password,
		enable_password = this.enable_password;

	password._restrict("\\S+");

	enable_password._onchange = async function() {
		if(this._checked()) {
			await storage.library('wordGen', 'wordGen');
			password._value(password._value() || (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10));
			removecss(password._main, 'hidden');
			password.__eIN.select();
		} else {
			password._value('');
			addcss(password._main, 'hidden');
		}
	};

	if (this.enable_recording && this.__opt.recording_missing) {
		this.enable_recording._disabled(true);
	}

	await this._create('scrollbar','obj_scrollbar');
	this.scrollbar._scrollbar(this._main.querySelector('div.scroll'), this._main);

	this.enable_lobby._onchange = function() {
		this.__updateLobbySettings();
	}.bind(this);
	this.__updateLobbySettings();

	this.__verifyBackgrounds();
	this.evnmeetinglobbybackground._onchange = async function() {
		if (this.evnmeetinglobbybackground._value() === '') {
			if (me.__popup) {
				await me.__popup._destruct();
			}
			me.__popup = await this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this ,'__addBackground'], sPrimaryAccount, '', '', gui.frm_main.upload, false, ['F', 'X']);
			gui._obeyEvent('onuploadcommit', [this, '__onbackgrounduploadcommit']);
		}
	}.bind(this);

	this.x_enable_lobby_background._onchange = function() {
		if (me.x_enable_lobby_background._checked()) {
			me.evnmeetinglobbybackground._main.removeAttribute('hidden');
		} else {
			me.evnmeetinglobbybackground._main.setAttribute('hidden', '');
		}
	};
	this.x_enable_lobby_background._onchange();

	this.note._value('');
	if (dataSet.get('main', ['night_mode_enabled']) == 1) {
		await storage.library('night_mode');
		NightMode(this.note.__eFrame.contentWindow).activate();
	}

	gui._obeyEvent('storage', [this, '__onStorageChange']);
	this._add_destructor('__destructor');
};

_me.__destructor = function() {
	gui._disobeyEvent('storage', [this, '__onStorageChange']);

};

_me.__onStorageChange = function(e, arg) {
	if (e && e.type == 'set' && Is.Array(arg) && ~arg.indexOf("LAYOUT_SETTINGS")) {
		var NM = NightMode(this.note.__eFrame.contentWindow);
		if (GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 1) {
			NM.activate();
		} else {
			NM.reset();
		}
	}
};

_me.__verifyBackgrounds = function() {
	frm_event2.prototype.__verifyBackgrounds.apply(this, arguments);
};
_me.__removeBackground = function() {
	frm_event2.prototype.__removeBackground.apply(this, arguments);
};
_me.__addBackground = function() {
	frm_event2.prototype.__addBackground.apply(this, arguments);
};
_me.__fillBackgrounds = function() {
	frm_event2.prototype.__fillBackgrounds.apply(this, arguments);
};
_me.__onbackgrounduploadcommit = function() {
	frm_event2.prototype.__onbackgrounduploadcommit.apply(this, arguments);
};

_me.__updateLobbySettings = function() {
	[].forEach.call(this._main.querySelectorAll('[data-depends-on="lobby"]'), function(el) {
		el.style.display = this.enable_lobby._checked() ? '' : 'none';
	}, this);
};

_me.__init_date = function(){
	var d = new IcewarpDate();

	this.__start(d.add((d.minute() < 30 ? 30 : 60) - d.minute(), 'minutes')); // round to nearest half an hour;
	this.__end(d.add(30, 'minutes'));

	this.starttime._onchange = this.startdate._ondateselect = function(){
		var ds = this.__start();

		if (!ds.isBefore(this.__end(), 'time')){
			this.__end(ds.add(15,'minutes'));
		}

	}.bind(this);

	this.endtime._onchange = this.enddate._ondateselect = function(){
		var de = this.__end();

		if (!de.isAfter(this.__start(), 'time')){
			this.__start(de.subtract(15,'minutes'));
		}

	}.bind(this);
};

_me.__start = function(d){
	var startDate;

	if (d){
		startDate = IcewarpDate.unix(Math.ceil(+d/1000));

		this.startdate._value(startDate, true);
		this.starttime._value(startDate.format(IcewarpDate.JULIAN_TIME)*60000, true);
	}
	else
	if (this.starttime._disabled())
		return IcewarpDate.julian(this.startdate._value());
	else
		return IcewarpDate.julian(this.startdate._value(), this.starttime._value()/60000);
};

_me.__end = function(d){
	if (d){
		var endDate = IcewarpDate.unix(Math.ceil(+d/1000));

		this.enddate._value(endDate, true);
		this.endtime._value(endDate.format(IcewarpDate.JULIAN_TIME)*60000, true);
	}
	else
	if (this.endtime._disabled())
		return IcewarpDate.julian(this.enddate._value());
	else
		return IcewarpDate.julian(this.enddate._value(), this.endtime._value()/60000);
};

_me.__value = function(aValue){
	if (aValue){

		//store all values
		this.__aValues = aValue;

		//fill form values
		this.title._value(aValue.values.EVNTITLE);
		this.password._value(aValue.values.MEETING_PASSWORD || '');
		this.enable_password._value(!!aValue.values.MEETING_PASSWORD);
		if (this.enable_recording) {
			this.enable_recording._value(aValue.values.EVNFLAGS & 256);
		}
		this.enable_lobby._value(aValue.values.EVNFLAGS & 512);
		this.evnmeetinglobbybackground._value(aValue.values.evnmeetinglobbybackground || '', true);
		this.x_enable_lobby_background._value(!!aValue.values.evnmeetinglobbybackground);

		this.startdate._value(aValue.values._TZEVNSTARTDATE, true);

		if (aValue.values.EVNSTARTTIME == -1){
			this.starttime._disabled(true);
			this.starttime._value(0, true);
		}
		else{
			this.starttime._disabled(false);
			this.starttime._value(aValue.values._TZEVNSTARTTIME*60000, true);
		}

		this.enddate._value(aValue.values._TZEVNENDDATE, true);

		if (aValue.values.EVNENDTIME == -1){
			this.endtime._disabled(true);
			this.endtime._value(0, true);
		}
		else{
			this.endtime._disabled(false);
			this.endtime._value(aValue.values._TZEVNENDTIME*60000, true);
		}

		this.note._value(aValue.values.EVNNOTE);

		if (aValue.CONTACTS){
			this.user_list.__users = aValue.CONTACTS.map(function(cnt){
				return {
					name: cnt.values.CNTCONTACTNAME,
					email: cnt.values.CNTEMAIL,
					role: cnt.values.CNTROLE,
					status: cnt.values.CNTSTATUS,
					id: cnt.values.CNT_ID,
					moderator: cnt.values.CNTMODERATOR == '1'
				};
			});
			this.user_list._fill();
		}
		else
			this.user_list.__users = [];
			this.user_list._fill();
	}
	else{
		var aDate;
		if (this.startdate._disabled()){
			aDate = {
				EVNSTARTDATE:this.startdate._value(),
				EVNSTARTTIME:-1,
				EVNENDDATE:this.enddate._value(),
				EVNENDTIME:-1
			};
		}
		else{
			aDate = {
				_TZEVNSTARTDATE:this.startdate._value(),
				_TZEVNSTARTTIME:this.starttime._value()/60000,
				_TZEVNENDDATE:this.enddate._value(),
				_TZEVNENDTIME:this.endtime._value()/60000,
			};
		}

		var aOut = this.__aValues;

		var flags = 1;
		if (this.enable_recording) {
			flags = flags | (this.enable_recording._checked() ? 256 : 0);
		}
		flags = flags | (this.enable_lobby._checked() ? 512 : 0);
		aOut.values = Object.assign(this.__aValues.values, {
			EVNTIMEFORMAT: 'Z',
			EVNFLAGS: flags,
			MEETING_ACTION: 1,
			MEETING_PASSWORD: this.enable_password._value() ? this.password._value() : '',
			EVNTITLE:this.title._value(),
			EVNNOTE:this.note._value(),
			EVNDESCFORMAT: 'text/html',
			EVNCLASS: 'E',
			EVNMEETINGLOBBYBACKGROUND: this.x_enable_lobby_background._checked() && this.evnmeetinglobbybackground._value(),
		}, aDate);
		aOut.values.EVNSHARETYPE = aOut.values.EVNSHARETYPE || 'U';
		aOut.values.MEETING_ACTION = 'create';

		var cnt = this.user_list._getAttendees();
		if (cnt.length) {
			aOut.CONTACTS = cnt.filter(function(c){ return c.values.CNTEMAIL && c.values.CNTEMAIL != sPrimaryAccount });
			if (!aOut.CONTACTS.length) {
				delete aOut.CONTACTS;
			}
		}
		//Strip TZ time
		if (this.starttime._disabled()){
			Object.keys(aOut.values).forEach(function(k){
				if (k.indexOf('_TZ') === 0)
					delete aOut.values[k];
			});
		}

		return aOut;
	}
};

_me.__save = async function(){
	this.btn_save._disabled(true);
	await this._create('loader', 'obj_loader', '');
	WMItems.add([sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')], this.__value(), '', '', '', [function(bOK, aData) {
		this.btn_save._disabled(false);
		this.loader._destruct();

		if (bOK) {
			gui.notifier._value({type: 'item_saved', args: [sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')]});
			this.__updateList(bOK, aData);
		} else {
			if(aData === 'item_create') {
				aData = 'ALERTS::FOLDER_INSUFFICIENT_RIGHTS';
			} else {
				aData = 'ERROR::' + aData;
			}
			gui.notifier._value({type: 'alert', args: {header: 'ALERTS::CONFERENCE_NOT_SAVED', text: aData}});
		}
	}.bind(this)]);
};

_me.__updateList = function(bOk, aData){
	if (bOk){

		//Notification
		if (gui.socket){
			var f = dataSet.get('folders',[sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')]);
			if (f){

				var aOut = {
					'ACTION': 'add',
					'TYPE':'item',
					'ITEM': aData.id,
					'FOLDER':f.RELATIVE_PATH,
					'FOLDER-TYPE':f.TYPE,
					'EMAIL':sPrimaryAccount,
					'ITEM-TYPE': 'E',
					'owner': this._pathName
				};

				gui.socket.api._notify(aOut);
			}
		}

		this._parent._view('home', null, true);
	}
};
