function obj_chatgpt_panel() { };
obj_chatgpt_panel.prototype = {
	__constructor: async function (options) {
		await storage.library('obj_highlight');

		this.__options = Object.assign({
			conversation: null,
			alias: '',
			chatgpt_action: false,
			editor: null,
			compose: false,
			reply: false,
			label: function() {},
			onConversationCreate: function() { }
		}, options || {});

		this.__conversation = this.__options.conversation;

		if (this.__options.editor) {
			this.__options.editor._obeyEvent('contentChanged', [this, '__handleContextChanged']);
			this.__options.editor._obeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
		}

		this._add_destructor('__destructor');

		this.menu = await this.slider._create('menu', 'obj_chatgpt_menu', '', 'menu panel', {
			panel: this
		});

		this.submenu = await this.slider._create('submenu', 'obj_chatgpt_menu', '', 'submenu panel', {
			panel: this,
			collapse: function() {
				if ((this.conversation || {}).thread) {
					this.slider._value('conversation');
				} else {
					this.slider._value('menu');
				}
				if (this.__options.editor) {
					this.__options.editor._unhighlight();
				}
			}.bind(this)
		});

		this.conversation = await this.slider._create('conversation', 'obj_rdock_chatgpt_conversation');
		this.slider.conversation._getAnchor('btn_close').onclick = function() {
			if (this.__options.editor) {
				this.__options.editor._unhighlight();
			}
			setTimeout(function() {
				this.slider._value('menu');
			}.bind(this), 5);
		}.bind(this);

		await this.menu._create('text', 'obj_chat_input', 'main', 'transparent', {
			smiles_enabled: false,
			gifs_enabled: false,
			chatgpt_enabled: false,
			formatting_enabled: false,
		});
		this.menu.text.input._placeholder(getLang('CHATGPT::CHAT_INPUT_PLACEHOLDER'));

		this.menu.text._onsubmit = function(sMessage) {
			this._startConversation({
				label: this.__options.label() || sMessage,
				message: sMessage + '\n\n' + getLang('chatgpt::context') + ':\n' + this.__getContext()
			});
		}.bind(this);

		this._updateOptions();

		if (this.__options.chatgpt_action) {
			for (var i in this.menu.__aOptions) {
				if (this.menu.__aOptions[i].id === this.__options.chatgpt_action) {
					this.actionInterval = setInterval(function() {
						if (this.__options.editor && this.__options.editor.__initialized) {
							clearInterval(this.actionInterval);
							this.menu.__aOptions[i].callback(true);
						}
					}.bind(this), 5);
					break;
				}
			}
		} else if (this.__options.conversation) {
			this.slider.conversation._init(this.__options.conversation, {
				defaultAction: this.__options.defaultAction,
				customAction: this.__options.customAction
			});
			this.slider._value('conversation', true);
		} else if (this.__options.alias) {
			ChatGPT.getConversationByAlias({
				alias: this.__options.alias
			}, function(bOK, conversation) {
				if (bOK) {
					this.slider.conversation._init(conversation, {
						defaultAction: options.defaultAction,
						customAction: options.customAction
					});
					this.slider._value('conversation', true);
				} else {
					this.slider._value('menu');
				}
			}.bind(this));
		} else {
			this.slider._value('menu');
		}
	},

	__destructor: function() {
		if (this.__options.editor) {
			this.__options.editor._disobeyEvent('contentChanged', [this, '__handleContextChanged']);
			this.__options.editor._disobeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
		}
	},

	__handleSelectionChanged: function(context, selection) {
		if (this._destructed || (context !== this.__options.editor)) {
			return;
		}
		this.__selection = selection;
		this._updateOptions();

		var thread = (this.conversation || {}).thread;
		if (thread) {
			thread.__context = this.__getContext.bind(this, {
				md: true,
				autoselect: false
			});
			var list = thread.list;
			if (list) {
				delete list.__oOptions.defaultAction;
				var messages = list.__aData || {};
				for (var i in messages) {
					delete (messages[i].obj.__oOptions || {}).defaultAction;
					messages[i].obj._init_controls(false);
				}
			}
		}

		var has_selection = (this.__selection || {}).rangeCount && this.__selection.getRangeAt(0) && !this.__selection.getRangeAt(0).collapsed;
		/*if (this.slider._value() !== 'menu' && has_selection) {
			this.slider._value('menu');
		} else */if (this.slider._value() === 'menu' && thread && !has_selection) {
			this.slider._value('conversation');
		} else if (this.slider._value() === 'submenu') {
			if (thread) {
				this.slider._value('conversation');
			} else {
				this.slider._value('menu');
			}
		}
	},

	__handleContextChanged: function(context) {
		if (this._destructed || (context !== this.__options.editor)) {
			return;
		}

		if (this.__contextChangedTimeout) {
			clearTimeout(this.__contextChangedTimeout);
		}
		this.__contextChangedTimeout = setTimeout(function() {
			this._updateOptions();
		}.bind(this), 100);
	},
	
	_updateOptions: function() {
		if (this._destructed) {
			return;
		}
		var me = this, range;

		var hasSelection = this.__selection && this.__selection.rangeCount && (range = this.__selection.getRangeAt(0)) && !range.collapsed;
		var submenu = this.slider.submenu;
		var contextPlain = me.__getContext({
			autoselect: false
		});

		switch ((this.__conversation || {}).type || ChatGPT.getModel(this.__options.openai_model).type || /*dataSet.get('chatgpt', ['openai_model']) ||*/ 'assistant') {
			case 'image':
				this.menu._updateOptions([
					{
						id: 'dalle',
						text: getLang('chatgpt::dalle_generate'),
						callback: function(skipAnimation) {
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::dalle_generate'),
								message: me.__getContext(),
								customAction: me.__options.customAction,
								skipAnimation: skipAnimation
							});
						}
					}
				]);
				break;
			
			default:
				this.menu._updateOptions([
					this.__options.compose && this.__options.reply && {
						id: 'suggest_reply',
						text: getLang('chatgpt::suggest_reply'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::suggest_reply'),
								message: getLang('chatgpt::suggest_reply') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								defaultAction: {
									label: 'CHATGPT::INSERT_MESSAGE',
									callback: function(message) {
										me.__options.editor._insertAdjacentHTML(me.__options.editor.__doc().body, 'afterBegin', obj_highlight._highlight(message.message, true));
									}
								},
								skipAnimation: skipAnimation
							});
						}
					},
					{
						id: 'make_overview',
						text: getLang('chatgpt::make_overview'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext();
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::make_overview'),
								message: getLang('chatgpt::make_overview') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								skipAnimation: skipAnimation
							});
						},
						disabled: false
					},
					{
						id: 'translate',
						text: getLang('chatgpt::translate'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							submenu._createLanguageMenu(function(lang) {
								me._startConversation({
									message: getLang('chatgpt::translate_query', [getLang('language::' + lang)]) + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
									defaultAction: {
										label: 'CHATGPT::REPLACE_SELECTION',
										callback: function(message) {
											me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
										}
									}
								});
							});
							me.slider._value('submenu', skipAnimation);
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'fix_grammar',
						text: getLang('chatgpt::fix_grammar'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::fix_grammar'),
								message: getLang('chatgpt::fix_grammar') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								defaultAction: {
									label: 'CHATGPT::REPLACE_SELECTION',
									callback: function(message) {
										me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
									}
								},
								skipAnimation: skipAnimation
							});
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'change_tone',
						text: getLang('chatgpt::change_tone'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							var options = ['professional', 'casual', 'straightforward', 'confident', 'friendly'].map(function(tone) {
								return {
									id: tone,
									text: getLang('chatgpt::tone_' + tone),
									callback: function() {
										me._startConversation({
											message: getLang('chatgpt::change_tone_to', [getLang('chatgpt::tone_' + tone)]) + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
											defaultAction: {
												label: 'CHATGPT::REPLACE_SELECTION',
												callback: function(message) {
													me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
												}
											}
										});
									}
								};
							});
		
							submenu._title('chatgpt::change_tone');
							submenu._updateOptions(options);
							me.slider._value('submenu', skipAnimation);
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'improve_styling',
						text: getLang('chatgpt::improve_styling'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::improve_styling'),
								message: getLang('chatgpt::improve_styling') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								defaultAction: {
									label: 'CHATGPT::REPLACE_SELECTION',
									callback: function(message) {
										me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
									}
								},
								skipAnimation: skipAnimation
							});
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'make_bullet_points',
						text: getLang('chatgpt::make_bullet_points'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext();
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::make_bullet_points'),
								message: getLang('chatgpt::make_bullet_points') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								skipAnimation: skipAnimation
							});
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'make_shorter',
						text: getLang('chatgpt::make_shorter'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::make_shorter'),
								message: getLang('chatgpt::make_shorter') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								defaultAction: {
									label: 'CHATGPT::REPLACE_SELECTION',
									callback: function(message) {
										me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
									}
								},
								skipAnimation: skipAnimation
							});
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					},
					{
						id: 'make_longer',
						text: getLang('chatgpt::make_longer'),
						callback: function(skipAnimation) {
							var context = '\n' + me.__getContext({
								md: true
							});
							me._startConversation({
								label: me.__options.label() || getLang('chatgpt::make_longer'),
								message: getLang('chatgpt::make_longer') + '.\n' + getLang('chatgpt::pure_result') + '.\n' + getLang('chatgpt::context') + ':\n\n' + context,
								defaultAction: {
									label: 'CHATGPT::REPLACE_SELECTION',
									callback: function(message) {
										me.__options.editor._replaceSelection(obj_highlight._highlight(message.message, true));
									}
								},
								skipAnimation: skipAnimation
							});
						},
						disabled: this.__options.reply ? !hasSelection : !contextPlain
					}
				].filter(Boolean));
		}
	},

	__getContext: function(options) {
		options = Object.assign({
			html: false,
			autoselect: true
		}, options || {});
		var context, range;
		var map = {};

		var content;
		if (this.__options.chatgpt_context) {
			content = this.__options.chatgpt_context;
			delete this.__options.chatgpt_context;
		} else {
			var editor = this.__options.editor;
			var hasSelection = this.__selection && this.__selection.rangeCount && (range = this.__selection.getRangeAt(0)) && !range.collapsed;
	
			if (!hasSelection && options.autoselect) {
				var selection = editor._selectElement(this.__options.reply ? '.iw-reply-block' : 'body');
				range = selection.rangeCount && selection.getRangeAt(0);
			}
	
			if (!range) {
				return;
			}
			content = mkElement('div', {}, false, range.cloneContents());
			options.autoselect && this.__options.editor._highlightSelection();
		}

		[].forEach.call(content.querySelectorAll('.iw_webmail_msg_header, .icewarp_smartattach', 'style'), function(header) {
			header.parentElement.removeChild(header);
		});

		if (options.html) {
			if (content.children === 0) { //only text node selected (a)

			} else if (content.childNodes === content.children) { // multiple nodes selected (<a>a</a><a>b</a>)

			} else { // single node with children (a <a>b</a> c)

			}

			var currentNode;
			var idCounter = 0;
			var ni = document.createNodeIterator(content, NodeFilter.SHOW_ELEMENT);
			while ((currentNode = ni.nextNode())) {
				var attributes = currentNode.attributes;
				if (attributes.length) {
					var id = idCounter.toString(36);
					map[id] = {};
					while (attributes.length) {
						map[id][attributes[0].nodeName] = attributes[0].nodeValue;
						attributes.removeNamedItem(attributes[0].nodeName);
					}
					currentNode.setAttribute('id', id);
					idCounter++;
				}
			}

			context = '```html\n' + content.innerHTML + '\n```';
		} else if (options.md) {
			var turndownService = new TurndownService();
			turndownService.use([turndownPluginGfm.tables]);
			context = turndownService.turndown(content);
			context = context.replace(/!\[.*?\]\(.*?\)/g, '').replace(/<\/?img.*?>/g, '');
		} else {
			context = createTextVersion(content.innerHTML, {
				linkProcess: function(href, linkText) {
					return linkText || href;
				},
				imgProcess: function() {
					return '';
				}
			}).trim();
		}

		return context;
	},

	_startConversation: function(options) {
		if (this.__conversation) {
			this.slider._value('conversation');
			this.slider.conversation._init(this.__conversation, {
				defaultAction: options.defaultAction,
				customAction: options.customAction
			});
			this.__conversation.messageCreate({
				message: options.message.trim()
			}, function (bOK) {
				if (bOK) {
					this.__conversation.process();
				}
			}.bind(this));
		} else {
			ChatGPT.conversationCreate({
				label: this.__options.label() || options.message.split(/\.\?!/)[0],
				alias: this.__options.alias,
				openai_model: this.__options.openai_model
			}, function (bOK, conversation) {
				if (bOK) {
					this.__options.onConversationCreate(conversation);
					this.__conversation = conversation;
					this.slider.conversation._init(conversation, {
						defaultAction: options.defaultAction,
						customAction: options.customAction
					});
					this.slider._value('conversation', options.skipAnimation);
					conversation.messageCreate({
						message: options.message.trim()
					}, function (bOK) {
						if (bOK) {
							conversation.process();
						}
					}.bind(this));
				}
			}.bind(this));
		}
	}
};