function obj_chatgpt_menu() { };
obj_chatgpt_menu.prototype = {
	__constructor: async function (options) {
		this.__oOptions = Object.assign({
			panel: this._parent,
			header: true
		}, options || {});

		await this._draw('obj_chatgpt_menu', '', this.__oOptions);

		this._getAnchor('collapse') && this._getAnchor('collapse').addEventListener('click', function (event) {
			event.stopPropagation();
			this.__oOptions.collapse && this.__oOptions.collapse();
		}.bind(this));

		var eOptions = this._getAnchor('options');
		this._scrollbar(eOptions, eOptions.parentElement, void 0, false);
	},

	_title: function (sTitle) {
		if (!this._getAnchor('title')) {
			return;
		}
		this._getAnchor('title').textContent = getLang(sTitle);
	},

	_updateOptions: function (aOptions) {
		var eOptions = this._getAnchor('options');
		eOptions.innerHTML = '';
		this.__aOptions = aOptions.map(function (option) {
			var eOption = mkElement('div', {
				className: 'option ' + (option.class || option.id || '') + (option.disabled ? ' disabled' : '') + (option.group ? ' group' : ''),
				textContent: option.text,
				onclick: option.group ? void 0 : function (event) {
					event.stopPropagation();
					if (option.disabled) {
						return;
					}
					option.callback();
				}.bind(this)
			});
			eOptions.appendChild(eOption);

			return option;
		}, this);
	},

	_createLanguageMenu: function (callback) {
		var myLang = isoLanguageCode(GWOthers.getItem('LAYOUT_SETTINGS', 'language'));
		var languages = ['af', 'sq', 'am', 'ar', 'hy', 'az', 'eu', 'be', 'bn', 'bs', 'bg', 'ca', 'ceb', 'ny', 'zh', 'co', 'hr', 'cs', 'da', 'nl', 'en', 'eo', 'et', 'tl', 'fi', 'fr', 'fy', 'gl', 'ka', 'de', 'el', 'gu', 'ha', 'haw', 'he', 'hi', 'hmn', 'hu', 'is', 'ig', 'id', 'ga', 'it', 'ja', 'jv', 'kn', 'kk', 'km', 'rw', 'ko', 'ku', 'ky', 'lo', 'la', 'lv', 'lt', 'lb', 'mk', 'mg', 'ms', 'ml', 'mt', 'mi', 'mr', 'mn', 'my', 'ne', 'no', 'or', 'ps', 'fa', 'pl', 'pt', 'pa', 'ro', 'ru', 'sm', 'sr', 'st', 'sn', 'sd', 'si', 'sk', 'sl', 'so', 'es', 'su', 'sw', 'sv', 'tg', 'ta', 'tt', 'te', 'th', 'tr', 'tk', 'uk', 'ur', 'ug', 'uz', 'vi', 'cy', 'xh', 'yi', 'yo', 'zu'];

		var recent_languages = Cookie.get(['chatgpt', 'recent_languages']) || [];
		var recent = recent_languages.map(function (lang) {
			return {
				id: lang,
				class: 'lang lang_' + lang,
				text: getLang('language::' + lang),
				callback: function () {
					recent_languages.unshift(lang);
					recent_languages = recent_languages.filter(function (v, i, a) {
						return a.indexOf(v) === i;
					}).slice(0, 3);
					Cookie.set(['chatgpt', 'recent_languages'], recent_languages);

					callback(lang);
				}
			};
		});
		languages = languages.map(function (lang) {
			return {
				id: lang,
				class: 'lang lang_' + lang,
				text: getLang('language::' + lang),
				callback: function () {
					recent_languages.unshift(lang);
					recent_languages = recent_languages.filter(function (v, i, a) {
						return a.indexOf(v) === i;
					}).slice(0, 3);
					Cookie.set(['chatgpt', 'recent_languages'], recent_languages);

					callback(lang);
				}
			};
		});

		languages.sort(function (a, b) {
			if (a.id === myLang) {
				return -1;
			} else if (b.id === myLang) {
				return 1;
			} else if (a.id === 'en') {
				return -1;
			} else if (b.id === 'en') {
				return 1;
			}

			return a.text.localeCompare(b.text);
		});

		this._title('chatgpt::translate');
		var options = [];
		if (recent.length) {
			options = [].concat([{
				group: true,
				text: getLang('IM::RECENT')
			}], recent, [{
				group: true,
				text: getLang('COMMON::ALL')
			}]);
		}
		this._updateOptions([].concat(options, languages));
	}
};