_me = obj_chatgpt_item.prototype;
function obj_chatgpt_item() { };

_me.__constructor = async function (aData, oOptions) {
	var me = this;
	this.__aData = aData;
	this.__oOptions = oOptions || {};
	this.__fileDrawn = {};

	if (aData.messages) {
		gui._obeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
		await this.__constructorConversation(aData);
	} else {
		gui._obeyEvent('ChatGPTConversationMessageUpdate', [this, '__ChatGPTConversationMessageUpdate']);
		await this.__constructorMessage(aData);
	}

	if (this.__oOptions.controls !== false) {
		var eMessage = this._getAnchor('message');
		eMessage.onmouseover = function () {

			if (this.__timeout) {
				clearTimeout(this.__timeout);
				delete this.__timeout;
			}

			if (hascss(me._main, 'edit'))
				return;

			if (!this.__timein)
				this.__timein = setTimeout(function () {

					if (me && !me._destructed) {
						me._init_controls(true);
						if (!aData.messages) {
							addcss(me._main.parentElement, 'active');
						}
					}

				}, 50);
		};

		eMessage.onmouseout = function (e) {
			if (!Is.Child(e.relatedTarget, this)) {

				if (this.__timein) {
					clearTimeout(this.__timein);
					delete this.__timein;
				}

				if (hascss(me._main, 'edit') || (me.__oOptions.defaultAction && aData.role !== 'user'))
					return;

				if (!this.__timeout)
					this.__timeout = setTimeout(function () {
						if (me && !me._destructed) {
							me._init_controls(false);
							if (!aData.messages) {
								removecss(me._main.parentElement, 'active');
							}
						}
					}.bind(this), 25);
			}
		};
	}

	this._add_destructor('__destructor');
};

_me.__destructor = function () {
	gui._disobeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
	gui._disobeyEvent('ChatGPTConversationMessageUpdate', [this, '__ChatGPTConversationMessageUpdate']);
}

_me.__constructorConversation = async function (aData) {
	await this.__constructorMessage(aData.messages[0], {
		room: aData.label,
		last_change: this.__getTime(new IcewarpDate(aData.updated_at)),
		comment: false
	});

	if (aData.messages[aData.messages.length - 1] && aData.messages[aData.messages.length - 1].id !== aData.messages[0].id) {
		await this._setLastComment(aData.messages[aData.messages.length - 1]);
	}

	var intensity = Math.max(aData.intensity - 1, 0);
	this._getAnchor('replies').textContent = getLang('CHAT::COMMENTS::' + intensity, [intensity]);
};

_me.__constructorMessage = async function (aData, additional) {
	var d = aData.created_at ? new IcewarpDate(aData.updated_at) : '';
	var owner = (aData.role === 'user') && !~['CANCEL', 'CANCELED', 'ERROR'].indexOf(aData.status);

	var body = this.__getBody(aData);
	var model = ChatGPT.getModel((aData.conversation || {}).openai_model);

	var aTmp = {
		id: aData.id,
		owner: owner ? getLang('COMMON::YOU') : (aData.conversation || {}).instance === 'assistant' ? getLang('CHATGPT::BUDDY') : ChatGPT.getModelName((aData.conversation || {}).openai_model) || getLang('CHATGPT::BUDDY'),
		me: owner,
		comment: true,
		time: this.__oOptions.time || (d ? CalendarFormatting.normalWithWeekDayAndTime(d) : ''),
		fulltime: this.__oOptions.fulltime || (d ? d.format('L LT') : ''),
		body: body || ' ',
		is_image: model.type === 'image' && aData.status === 'PROCESSING',
		avatar: {
			elm: owner ? obj_avatar.getAvatarHTML({
				email: sPrimaryAccount,
				name: dataSet.get('main', ['fullname']),
				size: 32
			}) : obj_avatar.getAvatarHTML({
				className: (model.type === 'image' ? 'dalle' : 'chatgpt') || 'chatgpt',
				name: 'chatgpt',
				size: 32
			})
		},
		followed_thread: true
	};

	await this._draw('obj_groupchat_item', 'main', Object.assign(aTmp, additional || {}));

	[].forEach.call(this._main.querySelectorAll('a'), function(a) {
		if (a.getAttribute('href').includes('#sandbox:/mnt/data/')) {
			a.addEventListener('click', function(e) {
				e.preventDefault();
				e.stopImmediatePropagation();

				var match = this.getAttribute('href').match(/(file-.*?)#/);
				ChatGPT.getFile(match[1]).download();
			});
		}
	});
	
	await this.__postProcess(aData);
};

_me.__getBody = function (message) {
	var body = '';

	if (~['CANCEL', 'CANCELED'].indexOf(message.status)) {
		body = '<div>' + [obj_highlight._highlight((message.message || ''), true), getLang('CHATGPT::CANCELED')].filter(Boolean).join('<br>') + '<div>';
	} else if (message.status === 'ERROR' || (!message.status && (message.message || '').indexOf('error:') === 0)) {
		if ((message.status === 'EMPTY') || ((message.error_code === 'ENTITY_NOT_FOUND') && ((message.retry || 0) < 5))) {
			body = '';
		} else {
			var mess = (message.message || '').split(', message:').filter(Boolean);
			mess = (mess[1] || mess[0] || getLang('CHATGPT::GENERIC_ERROR')).replace(/^error:\s?(error,\s?)?/, '').trim();
			body = '<div>' + obj_highlight._highlight(mess) + '</div>';
		}
	} else {
		if (!message.image) {
			body = obj_highlight._highlight((message.message || ''), true);
		}
	}

	// MD image
	body = body.replace(/(!\[[^\]]+\]\()(file-\w+)(\))/g, function(match, before, alias, after) {
		var file = message.files.filter(function(file) {
			return file.alias === alias;
		})[0];
		var link = file ? file.download_url : alias;

		return before + link + after;
	});

	// inline image
	body = body.replace(/<img src="(file-\w+)" alt="([^"]+)">/g, function(match, alias, alt) {
		var file = message.files.filter(function(file) {
			return file.alias === alias;
		})[0];

		if (file) {
			var link = file.download_url;
			alt = file.name;

			return '<img src="' + link + '" alt="' + alt + '">';
		}

		return '';
	});

	// link
	body = body.replace(/"(file-\w+)(#sandbox:[^"]+)"/g, function(match, alias, path) {
		var file = message.files.filter(function(file) {
			return file.alias === alias;
		})[0];
		var link = file ? file.download_url : alias;
		var name = path.replace(/^sandbox:.*?_/, '').split('/').pop();

		return '"' + link + '" download="' + name + '"';
	});

	return body;
}

_me._setLastComment = async function (aData) {
	this.last_comment && await this.last_comment._destruct();
	this._create('last_comment', 'obj_chatgpt_item', {
		position: 'afterend',
		element: this._getAnchor('addon')
	}, 'comment', aData, {
		time: '',
		fulltime: '',
		fulldate: true,
		followed_thread_comment: true,
		disable_controls: true,
		controls: false
	});
};

_me.__getTime = function (date) {
	var diff = Math.floor((new Date() - date) / 1000);
	if (diff < 10) {
		return getLang('NOTIFICATION::NOW');
	} else if (diff < 60) {
		return getLang(diff === 1 ? 'NOTIFICATION::SECOND_AGO' : 'NOTIFICATION::SECONDS_AGO', [diff]);
	} else if (diff < 60 * 60) {
		var minutes = Math.floor(diff / 60);
		return getLang(minutes === 1 ? 'NOTIFICATION::MINUTE_AGO' : 'NOTIFICATION::MINUTES_AGO', [minutes]);
	} else if (diff < 60 * 60 * 12) {
		var hours = Math.floor(diff / 60 / 60);
		return getLang(hours === 1 ? 'NOTIFICATION::HOUR_AGO' : 'NOTIFICATION::HOURS_AGO', [hours]);
	} else {
		return CalendarFormatting.normalWithTime(new IcewarpDate(date));
	}
};

_me.__ChatGPTConversationUpdate = async function (conversation) {
	if (conversation !== this.__aData) {
		return;
	}

	await this._clean();
	this._main.innerHTML = '';
	this.__constructorConversation(this.__aData);
};

_me.__ChatGPTConversationMessageUpdate = async function (message) {
	if (message !== this.__aData) {
		return;
	}

	var height = this._main.clientHeight;
	var list;
	var scrolledDown = (list = this._parent._getAnchor('main')) && (list.scrollTop + list.clientHeight + 80 >= list.scrollHeight);
	if (message.message || ~['CANCEL', 'CANCELED', 'ERROR'].indexOf(message.status)) {
		this._getAnchor('content').innerHTML = this.__getBody(message);
		if (this._parent._scrollBy && scrolledDown) {
			this._parent._scrollBy(this._main.clientHeight - height);
		}
	}

	await this.__postProcess(this.__aData);
};

_me.__postProcess = async function(aData) {
	var model = ChatGPT.getModel((aData.conversation || {}).openai_model);

	switch (aData.status) {
		case void 0:
		case 'PROCESSING':
			this._main.classList.add('processing');
			setTimeout(function() {
				aData.detail();
			}, aData.message ? 250 : 1000);
			if (model.type === 'image') {
				this._main.classList.add('dalle_image');
			}
			break;

		case 'EMPTY':
			setTimeout(function() {
				aData.detail();
			}, 1000);
			break;

		case 'ERROR':
			if (aData.error_code === 'ENTITY_NOT_FOUND') {
				aData.retry = aData.retry || 0;
				if (aData.retry++ < 5) {
					return setTimeout(function() {
						aData.detail();
					}, 1000);
				}
			}
			this._init_controls(false);
			this._init_controls(true);
		case 'CANCEL':
		case 'CANCELED':
			this._main.classList.add('undelivered');
			this._main.classList.remove('processing');
			this._main.classList.remove('dalle_image');
			break;

		default:
			this._main.classList.remove('processing');
			if (aData.image && !this.dalle_addon) {
				this._main.classList.add('dalle_image');
				this._create('dalle_addon', 'obj_dalle_addon', 'addon', '', Object.assign({
					comment: true
				}, aData), this.__oOptions);
			}

			for (var file of aData.files) {
				if (this.__fileDrawn[file.alias]) {
					return;
				}
				this._main.classList.add('obj_groupchat_item', 'obj_groupchat_file');
				await this._draw('obj_groupchat_file-file', 'addon', {
					doctype: Item.getFileType(file.name),
					filename: file.name.replace(/sandbox:\/.*\//, '')
				}, true);
				await this._draw('obj_groupchat_file-actionbar', 'actionbar', {
					download: true,
					save: true
				});
				this.download._onclick = function() {
					downloadItem(file.download_url, true);
				};
				this.save._onclick = function() {
					gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', sPrimaryAccount, Mapping.getDefaultFolderForGWType('F'), [this, '_saveFolder', [[{
						values: {
							description: file.name,
							size: file.size,
							class: 'link',
							fullpath: file.download_url
						}
					}]]], true, false, 'F', 'i', true);
				}
				this.__fileDrawn[file.alias] = true;
			};

			[].forEach.call(this._main.querySelectorAll('img'), function(img) {
				if (img.src.includes('file-')) {
					img.addEventListener('click', function(e) {
						e.preventDefault();
						e.stopImmediatePropagation();
						ChatGPT.getFile(img.src.split('/').pop()).download();
					})
				}
			});
	}
};

_me._edit = async function (b) {
	var sel = Is.Child(this._main, 'SECTION', this.__list._main);

	if (!b) {
		this.text && this.text._destruct();

		removecss(this._main, 'edit');
		removecss(sel, 'edit');

		this.__list._mask(false);
	} else {
		this._init_controls(false);
		this.__list._mask(true);

		addcss(this._main, 'edit');
		addcss(sel, 'edit');

		await this._create('text', 'obj_chat_input', 'body', 'small transparent', {
			smiles_enabled: false,
			gifs_enabled: false,
			chatgpt_enabled: false,
			formatting_enabled: false,
		});
		this.text.input.__maxHeight = 450;

		//Submit
		this.text._onsubmit = function (v) {
			if (!v) {
				return;
			}
			if (v === this.__aData.message) {
				return this._edit(false);
			}

			this.text.input._disabled(true);
			this.__aData.update({
				message: v
			}, function (bOK) {
				if (!bOK) {
					return this.text.input._disabled(false)
				}

				this._edit(false);
				this.__aData.conversation.process();
			}.bind(this));
		}.bind(this);

		//Cancel
		this.text.input._onclose = function () {
			if (!this.text.input.suggest)
				this._edit(false);
		}.bind(this);

		this.text._value(this.__aData.message);
		this.text.input._setRange(this.__aData.message.length);
		this.text._focus();

		this._getAnchor('esc_msg').onclick = function (e) {
			e.stopPropagation();

			this._edit(false);
		}.bind(this);
	}
};

_me._delete = function () {
	this._gui._create('frm_confirm', 'frm_confirm', '', 'noblur', [function () {
		this.__aData.delete();
	}.bind(this)], 'CHATGPT::DELETE_CONVERSATION', 'CHATGPT::DELETE_CONVERSATION_CONFIRMATION');
};

_me._pin = async function (bIsPinned) {
	gui.frm_main.dashboard[bIsPinned ? '_unpinItem' : '_pinItem']({
		iid: this.__aData.id,
		type: 'chatgpt'
	});

	if (this.controls) {
		await this.controls._destruct();
		this._init_controls(true);
	}
};

_me._copy = function () {
	var html = obj_groupchat_item.prototype.__encode_body(this.__aData.message);
	var text = createTextVersion(html, {
		linkProcess: function(href, linkText) {
			return linkText || href;
		},
		imgProcess: function() {
			return '';
		}
	});
	toClipboard({
		'text/html': html,
		'text/plain': text,
	}, 'message');
};

_me._retry = function () {
	this.__aData.delete(function (bOK) {
		bOK && this.__aData.conversation.process();
	}.bind(this));
};

_me._cancel = function() {
	this.__aData.conversation.cancel();
}

_me._init_controls = async function (bShow) {
	if (bShow && ChatGPT.getModel(this.__aData.openai_model || this.__aData.conversation.openai_model).type !== 'image') {

		if (!this.controls || this.controls._destructed) {
			var owner = this.__aData.role === 'user';

			var buttons = [];
			if (this.__aData.messages) {
				// var isPinnedItem = gui.frm_main.dashboard._isPinnedItem({
				// 	type: 'chatgpt',
				// 	iid: this.__aData.id
				// });
				buttons = [
					// {
					// 	id: 'dashboard_pin',
					// 	tooltip: isPinnedItem ? getLang('POPUP_ITEMS::UNPIN_FROM_DASHBOARD') : getLang('POPUP_ITEMS::PIN_TO_DASHBOARD'),
					// 	class: isPinnedItem ? 'active' : '',
					// 	callback: [this, '_pin', [bIsPinned]]
					// },
					{
						id: 'delete',
						tooltip: getLang('CHATGPT::DELETE_CONVERSATION'),
						callback: [this, '_delete']
					}
				];
			} else {
				switch (this.__aData.status) {
					case 'SUCCESS':
						if (owner) {
							if (this.__aData.conversation.instance === 'image') {
								return;
							}
							buttons = [
								{
									id: 'edit',
									tooltip: getLang('FORM_BUTTONS::EDIT'),
									callback: [this, '_edit', [true]]
								}
							];
						} else {
							if (this.__aData.image) {
								return;
							}

							buttons = [
								{
									id: 'copy',
									tooltip: getLang('CHATGPT::COPY_TO_CLIPBOARD'),
									callback: [this, '_copy']
								},
								{
									id: 'resend',
									tooltip: getLang('FORM_BUTTONS::RETRY'),
									callback: [this, '_retry']
								},
								this.__oOptions.defaultAction && {
									id: 'ok',
									tooltip: getLang(this.__oOptions.defaultAction.label),
									callback: [function () {
										this.__oOptions.defaultAction.callback(this.__aData);
										delete this.__oOptions.defaultAction;
										this._init_controls(false);
									}.bind(this)]
								}
							].filter(Boolean);
						}
						break;

					case 'CANCEL':
					case 'CANCELED':
					case 'ERROR':
						buttons = [
							{
								id: 'resend',
								tooltip: getLang('FORM_BUTTONS::RETRY'),
								callback: [this, '_retry']
							}
						];
				}
			}

			if (buttons.length) {
				await this._create('controls', 'obj_tch_control', 'message', '', buttons, this.__aData);
			}
		}

		if (this.controls) {
			this.controls._onhide = function () {
				removecss(this._main.parentElement, 'active');
			}.bind(this);

			this.controls._show();
		}

	} else if (this.controls) {
		this.controls._hide();
		await this.controls._destruct();
	}

	return true;
};