_me = obj_chatgpt_hmenu_toolbar.prototype;
function obj_chatgpt_hmenu_toolbar() {}

_me.__constructor = async function (oOptions) {
	this.__aliasChecked = {};
	this.__conversation = {};
	this.__oOptions = Object.assign({
		context: null,
		upMenu: true,
		alias: '',
		conversation: '',
		label: function() {}
	}, oOptions || {});
	
	this._upMenu = this.__oOptions.upMenu;

	this.__model = {
		mode: 'assistant',
		type: 'assistant'
	};//ChatGPT.getModel(dataSet.get('chatgpt', ['openai_model']));

	// this.__createModelPicker();
	this.__menu();

	if (this.__oOptions.context) {
		this.__oOptions.context._obeyEvent('selectionChanged', [this, '__selectionChangedHandler']);
		this.__oOptions.context._obeyEvent('contentChanged', [this, '__contentChangedHandler']);
	}

	this._add_destructor('__destructor');
};

_me.__createModelPicker = async function() {
	var me = this;
	await this._create('_modelPicker', 'obj_hmenu_plus', {
		first: true
	});
	
	this._modelPicker._setActive = function(oModel) {
		ChatGPT.modelsList(function(_, models) {
			me._modelPicker && me._modelPicker._fill(models.map(function(model) {
				return {
					text: model.label,
					arg: model,
					css: model === oModel ? 'active' : ''
				};
			}));
		});
	};

	this._modelPicker._onclick = function(e, elm, id, arg) {
		e.preventDefault();
		e.stopPropagation();

		if (me.__popup) {
			me.__popup._destruct();
		}

		me.__model = arg;
		me._modelPicker._setActive(me.__model);
		me.__menu();
	};

	this._modelPicker._setActive(this.__model);
}

_me.__menu = function () {
	if (!this.__conversation[this.__model.model] && this.__oOptions.alias && !this.__aliasChecked[this.__model.model]) {
		this.__aliasChecked[this.__model.model] = true;
		return ChatGPT.getConversationByAlias({
			alias: this.__oOptions.alias,
			openai_model: this.__model.model
		}, function(bOK, conversation) {
			if (bOK) {
				this.__conversation[this.__model.model] = conversation;
			}
			this.__menu();
		}.bind(this));
	}

	var context = this.__getContext();
	var aMenu = [
		{
			tooltip: 'CONFERENCE::HISTORY',
			css: 'ico2 history',
			arg: 'history',
			disabled: !this.__conversation[this.__model.model]
		}
	];
	switch (this.__model.type) {
		case 'chat':
		case 'assistant':
				aMenu.push({
				tooltip: 'CHATGPT::TRANSLATE',
				css: 'ico2 translate',
				arg: 'translate',
				disabled: !context
			}, {
				tooltip: 'CHATGPT::MAKE_OVERVIEW',
				css: 'ico2 make_overview',
				arg: 'make_overview',
				disabled: !context
			}, {
				tooltip: 'CHATGPT::FIX_GRAMMAR',
				css: 'ico2 fix_grammar',
				arg: 'fix_grammar',
				disabled: !context
			}, {
				tooltip: 'CHATGPT::MAKE_BULLET_POINTS',
				css: 'ico2 make_bullet_points',
				arg: 'make_bullet_points',
				disabled: !context
			}, {
				tooltip: 'CHATGPT::MAKE_SHORTER',
				css: 'ico2 make_shorter',
				arg: 'make_shorter',
				disabled: !context
			}, {
				tooltip: 'CHATGPT::MAKE_LONGER',
				css: 'ico2 make_longer',
				arg: 'make_longer',
				disabled: !context
			});
			break;

		case 'image':
			aMenu.push({
				tooltip: 'CHATGPT::DALLE_GENERATE',
				css: 'ico2 dalle',
				arg: 'dalle',
				disabled: !context
			});
	}

	this._fill(aMenu);
};

_me._onclick = function (e, elm, id, arg) {
	e.preventDefault();
	e.stopPropagation();

	switch (arg) {
		case 'history':
			if (!arg.disabled) {
				this.__openChatGPTConversation();
			}
		break;

		default:
			this.__openChatGPTConversation(arg);
	}
};

_me.__selectionChangedHandler = function() {
	this.__menu();
};

_me.__contentChangedHandler = function() {
	if (this.__popup) {
		var aPos = getSize(this._main);
		this.__popup._place(aPos.x - 6, aPos.y - 502, Math.max(aPos.w / 2, 280), 500);
	}
};

_me.__getContext = function() {
	return this.__oOptions.context && (this.__oOptions.context._getSelectedText() || this.__oOptions.context._value());
};

_me.__openChatGPTConversation = async function(command) {
	this.__popup = await this._gui._create('chatgpt_popup', 'obj_block_ext_uni');

	this.__contentChangedHandler();

	await this.__popup._create('obj_chatgpt_panel', 'obj_chatgpt_panel', 'main', '', Object.assign({
		editor: this.__oOptions.context,
		conversation: this.__conversation[this.__model.model],
		alias: this.__oOptions.alias,
		label: this.__oOptions.label,
		chatgpt_action: command,
		openai_model: this.__model.model,
		onConversationCreate: function(conversation) {
			this.__conversation[this.__model.model] = conversation;
			this.__menu();
		}.bind(this),
		customAction: ChatGPT.getModel(this.__model.model).type === 'image' ? {
			id: 'use_image',
			label: 'CHATGPT::USE_IMAGE',
			callback: function(aData) {
				this.__oOptions.context._insertText('\n' + aData.description);
				this.__oOptions.context._parent._upload._addFiles([{
					class: 'item',
					aid: aData.aid,
					fid: aData.fid,
					iid: aData.iid,
					name: aData.name,
					fullpath: aData.aid + '/' + Path.slash(aData.fid) + '/' + WMItems.__serverID(aData.iid)
				}]);
				this.__popup._destruct();
			}.bind(this)
		} : false
	}, {}));
	this.__popup._add_destructor('__destructor');
	this.__popup.__destructor = function() {
		delete this.__popup;
		this.__oOptions.context._unhighlight(true);
	}.bind(this);
	this.__popup.obj_chatgpt_panel.slider.conversation._getAnchor('btn_close').onclick = function() {
		this.__popup._destruct();
	}.bind(this);
};

_me.__destructor = function() {
	// this._modelPicker._destruct();
	if (this.__popup) {
		this.__popup._destruct();
	}
	if (this.__oOptions.context) {
		this.__oOptions.context._disobeyEvent('selectionChanged', [this, '__selectionChangedHandler']);
		this.__oOptions.context._disobeyEvent('contentChanged', [this, '__contentChangedHandler']);
	}
}