function obj_chatgpt_actions() {}

obj_chatgpt_actions.prototype.__constructor = async function (oOptions) {
	var me = this;
	this.__oOptions = Object.assign({
		callback: function () { }
	}, oOptions || {});

	if (this._getAnchor('upload')) {
		this._getAnchor('upload').onclick = function (e) {
			e.preventDefault();
			e.stopImmediatePropagation();

			me._upload(function(files) {
				executeCallbackFunction(me.__oOptions.callback, {
					message: getLang('CHATGPT::PROCESS_FILE'),
					files: files.map(function(file) {
						return { alias: file.alias };
					})
				});
			});
		};
	}

	this._getAnchor('image').onclick = function (e) {
		e.preventDefault();
		e.stopImmediatePropagation();

		ChatGPT.modelsList(function (_, models) {
			var model = 'dalle2';
			if (models.some(function (model) {
				return model.type === 'image' && model.model === 'dalle3';
			})) {
				model = 'dalle3';
			};

			executeCallbackFunction(me.__oOptions.callback, {
				model: model,
				messages: [getLang('CHATGPT::QUICK_ACTION_IMAGE_HELPER_MESSAGE')],
				label: getLang('CHATGPT::QUICK_ACTION_IMAGE'),
				instance: 'image'
			});
		});
	};

	this._getAnchor('ask').onclick = function (e) {
		e.preventDefault();
		e.stopImmediatePropagation();

		executeCallbackFunction(me.__oOptions.callback, {
			messages: [getLang('CHATGPT::QUICK_ACTION_ASK_HELPER_MESSAGE')],
			label: getLang('CHATGPT::QUICK_ACTION_ASK')
		});
	};
};
obj_chatgpt_actions.prototype._upload = async function(callback) {
	this.upload = await obj_upload._instance(this);

	this.upload._onuploadend = function(files) {
		var length = files.length;
		var responses = [];

		var now = new IcewarpDate(),
			aValues = {
				values: {
					EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS','file_sharing'),
					EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
					EVNSTARTTIME: now.hour() * 60 + now.minute()
				},
				ATTACHMENTS: files.map(function(file) {
					return {
						values:{
							class: 'file',
							description: file.name,
							fullpath: file.folder + '/' + file.id,
							size: file.size
						}
					};
				})
			};

		WMItems.add([sPrimaryAccount, '__@@UPLOAD@@__'], aValues, '', '','', [function(bOK, aData) {
			if (bOK !== true) {
				return;
			}
			(Array.isArray(aData) ? aData : [aData]).forEach(function (aData, index) {
				gui.__exeEvent('onuploadcommit', { id: files[index].id, data: aData });
				ChatGPT.createFile({
					alias: WMItems.__clientID(aData.id),
					name: files[index].name,
					url: aData.att_link
				}, function(bOK, response) {
					if (!bOK) {
						return;
					}
					responses.push(response);
					if (!--length) {
						callback(responses);
					}
				});
			});
		}]);
	};

	this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [function(files) {
		var length = files.length;
		var responses = [];

		files.forEach(function(file) {
			ChatGPT.createFile({
				alias: WMItems.__clientID(file.id),
				name: file.title,
				url: sPrimaryAccountClient + 'server/download.php?'+ buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'file_attachment', fullpath: file.fullpath ? (sPrimaryAccount + '/' + file.fullpath.replace(sPrimaryAccount + '/', '')) : (file.aid + '/' + file.fid + '/' + (file.iid || file.id))})
			}, function(bOK, response) {
				if (!bOK) {
					return;
				}
				responses.push(response);
				if (!--length) {
					callback(responses);
				}
			});
		});
	}], sPrimaryAccount, '', '', this.upload, false, ['F', 'X']);
};