_me = obj_chat_input.prototype;
function obj_chat_input() {};

/*
 _onsubmit
 */
_me.__constructor = async function (arg) {

	var me = this;

	await storage.library('purify.wrapper', 'purify');

	this.__options = arg || {};
	this.__options.gifs_enabled = this.__options.gifs_enabled === void 0 ? GWOthers.getItem('CHAT','gifs') == '1' : this.__options.gifs_enabled;
	this.__options.smiles_enabled = this.__options.smiles_enabled === void 0 ? GWOthers.getItem('CHAT','smiles') == '1' : this.__options.smiles_enabled;
	this.__options.chatgpt_enabled = this.__options.chatgpt_enabled === void 0 ? true : this.__options.chatgpt_enabled;
	this.__options.formatting_enabled = this.__options.formatting_enabled === void 0 ? true : this.__options.formatting_enabled;
	this.__options.dalle = (this.__options.dalle === void 0 ? false : this.__options.dalle) && ChatGPT.models.some(function(model) {
		return ~model.model.indexOf('dalle');
	});

	if (this.__options.handlers)
		addcss(this._main, 'add');

	await this._draw("obj_chat_input",'main',this.__options);
	this.input.__mentions_enabled = this.__options.mentions_enabled === void 0 ? true : this.__options.mentions_enabled;

	this.__initToolbar();
	gui._obeyEvent('settings_changed', [this, '__initToolbar']);
	gui._obeyEvent('chatgptChanged', [this, '__initToolbar']);

	this.input.__maxHeight = this.__options.height || 300;
	this.input.__centerSuggest = this._main;

	this.btn_send._onclick = function() {
		this.__submit && this.__submit(this._value().trim());
	}.bind(this);

	this.input._onpaste = function (e) {
		var items = (e.clipboardData || (e.originalEvent || {}).clipboardData || {}).items || (window.clipboardData || {}).files || [];

		for (var i = 0; i < items.length; i++) {
			if (items[i].getAsFile) {
				var file = items[i].getAsFile();
				if (!file) {
					continue;
				}
				if (me.__options.upload) {
					if (items[i].type.indexOf('image') === 0) {
						try {
							var type = items[i].type.split('/')[1];
							if (type === 'heif') {
								type = 'heic';
							}
							file = new File([file], 'clipboard-' + new IcewarpDate() + '.' + type, {
								type: items[i].type
							});
						} catch {
							//
						}
					}

					me._upload.file.__ondropfile([file]);

					me.__exeEvent('pasteimage',null,{"files":[file],"owner":this});
					if (me.input.__editor) {
						me.input.__editor.focus();
					}
				}
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
			}
		}
	};

	this.input._onkeydown = function (e) {
		//SEND KEY
		if (!this.suggest)
			if (e.keyCode == 13 && ((GWOthers.getItem('CHAT', 'enter_send') > 0 && !e.shiftKey) || e.ctrlKey || e.metaKey)) {
				var selection = this.__doc && this.__doc().defaultView.getSelection();
				if (selection && selection.rangeCount) {
					var range = selection.getRangeAt(0);
					var startContainer = range && range.startContainer;
					if (startContainer && (startContainer.parentElement.closest('li') || (startContainer.tagName === 'DIV' ? startContainer : startContainer.parentElement.closest('div')).querySelector('.toastui-editor-md-list-item')) && !e.ctrlKey) {
						return false;
					}
				}

				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();

				var v = this._value().trim();

				if (me.__submit)
					me.__submit(v);

				return;
			}
			else
			if (e.keyCode == 8 && me.__private && this._getCartPos() == 0) {
				me._private();
			}
			else
			if (e.keyCode == 27){

				if (me.preview)
					me.preview._destruct();
				else
				if (me._onclose)
					me._onclose(e);

				return;
			}

		if (me._onkeydown)
			me._onkeydown(e);
	};

	//get urls
	var etmp = mkElement('div');
	this.input._onkeyup = function(){

		if (me.__options.parseurl && me.__smartcheck)
			window.clearTimeout(me.__smartcheck);

		if (me._destructed)
			return;

		//save state
		if (me.__options.memory && me.__options.memory.set){
			executeCallbackFunction(me.__options.memory.set, this._value());
		}

		if (me.__options.parseurl){
			me.__smartcheck = window.setTimeout(function(){

				if (me && !me._destructed && me.input){
					var s = me.input._value(),
						elm;

					etmp.innerHTML = DOMPurify.sanitize(s.highlight_links());



					if ((elm = etmp.getElementsByTagName('A')) && (elm = elm[0]) && elm.href && !~elm.href.indexOf('mailto:')){

						//strip hash, doesn't work on server
						var sHref = elm.href.split('#').shift();
						if (me.__lastURL != sHref && (me.__lastURL = sHref)){
							gui.socket.api._linkpreview(sHref,[function(aData){
								if (aData.ATTRIBUTES.ID){
									me.__lastURLID = aData.ATTRIBUTES.ID;
									me.__lastURL = sHref;

									me.__urlloading(true);
								}
							}]);
						}
						else{
							me.__urlloading(false);
							return;
						}
					}
					else{
						me.__urlloading(false);
						return;
					}

					delete me.__lastURL;
					delete me.__lastURLID;

					me.__urlloading(false);
					if (me.preview)
						me.preview._destruct();
				}

			},1500);
		}
	};

	this.label._onclick = function () {
		me._private();
	};

	if (this.__options.handlers)
		this.add._onclick = async function (e) {
			if (!this.cmenu || this.cmenu._destructed) {

				e.stopPropagation();

				var aMenu = [];

				if (!me.__options.handlers) {
					return;
				}
				if (me.__options.handlers['word'] || me.__options.handlers['excel'] || me.__options.handlers['ppoint'] || me.__options.handlers['note']) {
					aMenu.push({'title': 'CHAT::CREATE_NEW_DOCUMENT', css: 'ico2 file', nodes: [
							me.__options.handlers['word'] ? {'title': 'main_menu::new_word', 'arg': {'method': 'word'}, css: 'ico2 word'} : false,
							me.__options.handlers['excel'] ? {'title': 'main_menu::new_excel', 'arg': {'method': 'excel'}, css: 'ico2 excel'} : false,
							me.__options.handlers['ppoint'] ? {'title': 'main_menu::new_ppoint', 'arg': {'method': 'ppoint'}, css: 'ico2 ppoint'} : false,
							me.__options.handlers['note'] ? {'title': 'main_menu::new_note', 'arg': {'method': 'note'}, css: 'ico2 note'} : false
					].filter(Boolean)});
				}

				if (me.__options.handlers['attach']) {
					aMenu.push({'title': 'CHAT::SHARE_FILE_OR_DOCUMENT', 'arg': {'method': 'attach'}, css: 'ico2 attach'});
				}

				if (me.__options.handlers['conference']) {
					aMenu.push({'title': 'CHAT::NEW_CONFERENCE', 'arg': {'method': 'conference'}, css: 'ico2 conference', disabled: !sPrimaryAccountCONFERENCE});
				}

				if (me.__options.handlers['event'])
					aMenu.push({'title': 'IM::NEW_EVENT', 'arg': {'method': 'event'}, css: 'ico2 event'});

				if (me.__options.handlers['email'])
					aMenu.push({'title': 'CHAT::NEW_EMAIL', 'arg': {'method': 'email'}, css: 'ico2 email'});

				if (me.__options.handlers['geo'])
					aMenu.push({'title': 'IM::GEO', 'arg': {'method': 'geo'}, css: 'ico2 geo', disabled: !("geolocation" in navigator) || !GWOthers.getItem('EXTERNAL_SETTINGS', 'google_maps_api_key')});

				if (me.__options.handlers['code']) {
					aMenu.push({'title': 'INSERT_CODE::TITLE', 'arg': {'method': 'code'}, css: 'ico2 code'});
				}

				if (me.__options.handlers.make_bullet_points) {
					aMenu.push({
						title: 'CHATGPT::make_bullet_points',
						arg: {
							method: 'make_bullet_points'
						},
						css: 'ico2 make_bullet_points'
					});
				}
				if (me.__options.handlers.fix_grammar) {
					aMenu.push({
						title: 'CHATGPT::FIX_GRAMMAR',
						arg: {
							method: 'fix_grammar'
						},
						css: 'ico2 fix_grammar'
					});
				}
				if (me.__options.handlers.improve_styling) {
					aMenu.push({
						title: 'CHATGPT::improve_styling',
						arg: {
							method: 'improve_styling'
						},
						css: 'ico2 improve_styling'
					});
				}
				if (me.__options.handlers.make_shorter) {
					aMenu.push({
						title: 'CHATGPT::make_shorter',
						arg: {
							method: 'make_shorter'
						},
						css: 'ico2 make_shorter'
					});
				}
				if (me.__options.handlers.make_longer) {
					aMenu.push({
						title: 'CHATGPT::make_longer',
						arg: {
							method: 'make_longer'
						},
						css: 'ico2 make_longer'
					});
				}
				if (me.__options.handlers.translate) {
					aMenu.push({
						title: 'CHATGPT::translate',
						css: 'ico2 translate',
						nodes: [{
							anchor: 'languages',
							css: 'languages'
						}],
						onmouseover: async function() {
							await this.cmenu._create('translate', 'obj_chatgpt_menu', 'languages', '', {
								header: false
							});
							this.cmenu.translate._createLanguageMenu(function(lang) {
								executeCallbackFunction(me.__options.handlers.translate, getLang('chatgpt::translate_query2', [getLang('language::' + lang)]));
								this.cmenu._destruct();
							}.bind(this));
						}.bind(this),
						onmouseout: function() {
							this.cmenu.translate && this.cmenu.translate._destruct();
						}.bind(this)
					});
				}

				this.cmenu = await this._gui._create("cmenu", "obj_context", '', 'obj_chat_input_add', this);
				await this.cmenu._fill(aMenu);
				//this.cmenu._place(pos.x + pos.w / 2, pos.y, null, 3);
				this.cmenu._placeMenu(this._main, {mode:'top'});

				//var me = this;
				this.cmenu._onclick = function (e, elm, id, arg) {
					if (arg.method && me.__options.handlers && me.__options.handlers[arg.method])
						executeCallbackFunction(me.__options.handlers[arg.method]);
					else
						executeCallbackFunction(arg);
				};
			}
		};

	if (this.__options.smiles_enabled) {
		this.smile._onclick = async function (e) {
			e.stopPropagation();
			e.preventDefault();

			if (me.Gifs && !me.Gifs._destructed) {
				me.Gifs._destruct();
			}
			if (me.Dalle && !me.Dalle._destructed) {
				me.Dalle._destruct();
			}
			if (me.Smile && !me.Smile._destructed) {
				return me.Smile._destruct();
			}

			var oText = this._parent.input,
				containerPos = getSize(me._getAnchor('input')),
				aPos = getSize(me._main);

			me.Smile = await me._gui._create('smile', 'frm_smilebox','','',[function(smile){
				oText._insertText(smile.emoji);

				if (me.__options.memory && me.__options.memory.set){
					executeCallbackFunction(me.__options.memory.set, oText._value());
				}

			}]);
			me.Smile._place(aPos.x, containerPos.y - 220, 402, 210);
		};
	}
	if (this.__options.gifs_enabled) {
		this.gifs._onclick = async function (e) {
			e.preventDefault();
			e.stopPropagation();

			if (me.Smile && !me.Smile._destructed) {
				me.Smile._destruct();
			}
			if (me.Dalle && !me.Dalle._destructed) {
				me.Dalle._destruct();
			}
			if (me.Gifs && !me.Gifs._destructed) {
				return me.Gifs._destruct();
			}

			var aPos = getSize(me._main),
				containerPos = getSize(me._getAnchor('input'));
			me.Gifs = await me._gui._create('gifs', 'obj_block_ext_uni', '', 'gif-picker');

			me.Gifs._place(aPos.x, containerPos.y - 460, 350, 450);

			gifPicker(me.Gifs._main, function(gif) {
				me.Gifs._destruct();
				var upload = me._parent.upload || me._parent._upload || ((me._parent.text || {})._upload);
				getRemoteFileContent(gif.url, function(blob) {
					upload.file.__ondropfile([new File([blob], gif.description.trim() + '.gif')]);
				}, 'blob');
			});
		};
	}

	if (this.__options.upload_enabled) {
		this._upload = await obj_upload._instance(this, this.__options.uploadInstanceId);
		this._upload._onuploadstart = function(files) {
			if (files.length) {
				this._main.classList.add('has-attachments');
			}
			[].forEach.call(files, function(file) {
				this._create('attachment', 'obj_attachment', 'attachments', '', file, { progress: { pie: true }});
			}, this);
		}.bind(this);

		this._clearAttachments();
		this._upload._restore();

		this._upload._dropzone(this._parent._main, async function() {
			return await (new cTemplate()).tmp('dropzone', {
				title: getLang('CHAT::DROP_TITLE', [this.__options.uploadInstanceId]),
				body: getLang('CHAT::DROP_BODY')
			});
		}.bind(this), 'item');

		this.btn_upload._onclick = function() {
			me._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [function(files) {
				me._upload._addFiles(files.map(function (file) {
					return {
						class: file.class || 'item',
						aid: file.aid,
						fid: file.fid,
						iid: file.iid || file.id,
						name: file.title,
						size: file.size,
						fullpath: file.fullpath || (file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid))
					};
				}));
			}], sPrimaryAccount, '', '', me._upload, false, ['F', 'X']);
		}
	}

	//subscribe url
	if (this.__options.parseurl)
		gui.socket.api._obeyEvent('onurlinfo', [function(aData){

			if (this._destructed)
				return false;

			if (this.__lastURL && Is.Object(aData) && aData.URL && this.__lastURL == aData.URL[0].VALUE)
				this.__urlpreview(aData);
			else
				this.__urlloading(false);

		}.bind(this)]);

	gui._obeyEvent('onuploadaborted', [this, '__onuploadaborted']);

	this._add_destructor('__disobeyEvents');

	
	if (this.__options.memory && this.__options.memory.get){
		this.input._value(await executeCallbackFunction(this.__options.memory.get));
	}

	this.input._obeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
};

_me.__initToolbar = async function() {
	var me = this;

	if (this.__options.formatting_enabled) {
		if (GWOthers.getItem('CHAT', 'editor_type') === 'textarea') {
			removecss(this._main, 'enable_formatting');
		} else {
			addcss(this._main, 'enable_formatting');
			this.btn_format._onclick = function() {
				me._main.classList.remove('chatgpt_enabled');
				me._main.classList.toggle('formatting_enabled');
				Cookie.set(['chat_input', 'toolbar_enabled'], me._main.classList.contains('formatting_enabled') ? 'formatting' : false)
			};
			if (Cookie.get(['chat_input', 'toolbar_enabled']) === 'formatting') {
				me._main.classList.add('formatting_enabled');
			}
		}
	} else {
		removecss(this._main, 'enable_formatting');
	}

	if (dataSet.get('chatgpt') && this.__options.chatgpt_enabled && GWOthers.getItem('CHAT', 'editor_type') !== 'textarea') {
		addcss(this._main, 'enable_chatgpt');
		
		this.btn_chatgpt._onclick = function() {
			me._main.classList.remove('formatting_enabled');
			me._main.classList.toggle('chatgpt_enabled');
			Cookie.set(['chat_input', 'toolbar_enabled'], me._main.classList.contains('chatgpt_enabled') ? 'chatgpt' : false);
		};

		if (Cookie.get(['chat_input', 'toolbar_enabled']) === 'chatgpt') {
			me._main.classList.add('chatgpt_enabled');
		}

		if (this.chatgpt_toolbar) {
			await this.chatgpt_toolbar._destruct();
		}
		await this._create('chatgpt_toolbar', 'obj_chatgpt_hmenu_toolbar', 'chatgpt_toolbar', '', {
			context: this.input,
			alias: this.__options.alias,
			label: this.__options.label
		});
	} else {
		removecss(this._main, 'enable_chatgpt');

		if (this.chatgpt_toolbar) {
			this.chatgpt_toolbar._destruct();
		}
	}

	if ((GWOthers.getItem('CHAT','enter_send') || 0) < 1) {
		removecss(this._main, 'enter_send');
	} else {
		addcss(this._main, 'enter_send');
	}

	['addImage', 'addLink', 'addTable', 'blockQuote', 'bold', 'bulletList', 'code', 'codeBlock', 'customBlock', 'deleteSelection', 'heading', 'hr', 'indent', 'italic', 'orderedList', 'outdent', 'redo', 'selectAll', 'strike', 'taskList', 'toggleLink', 'toggleScrollSync', 'undo', 'removeTable', 'addColumnToLeft', 'addColumnToRight', 'removeColumn', 'addRowToUp', 'addRowToDown', 'removeRow', 'alignColumn'].forEach(function(command) {
		var btn = this['format_' + command];
		if (!btn) {
			return;
		}

		btn._onclick = function() {
			if (command === 'toggleLink') {
				var url = me.__range && ((me.__range.startContainer || {}).data || '').trim();
				url && me.input._exec(command, {linkUrl: url});
			} else {
				me.input._exec(command);
			}
			me.input.__exeEvent('selectionChanged', me.input, me.input.__doc().getSelection());
		};

		gui.tooltip._add(btn._main, getLang('WYSIWYG::' + command));
	}, this);

	if (this.format_heading) {
		this.format_heading._onclick = async function(e) {
			e.stopPropagation();
			e.preventDefault();

			var pos = getSize(me.format_heading._main);
			gui.cmenu = await gui._gui._create('cmenu', 'obj_context', '', 'obj_rich_menu');
			await gui.cmenu._fill([
				{ text: getLang('RICH::PARAGRAPH'), 	 css: 'paragraph p',  tag: 'p', arg: [me.input, '_exec', ['heading', { level: 0 }]]},
				{ text: getLang('RICH::HEADING') + ' 1', css: 'paragraph h1', tag: 'h1', arg: [me.input, '_exec', ['heading', { level: 1 }]]},
				{ text: getLang('RICH::HEADING') + ' 2', css: 'paragraph h2', tag: 'h2', arg: [me.input, '_exec', ['heading', { level: 2 }]]},
				{ text: getLang('RICH::HEADING') + ' 3', css: 'paragraph h3', tag: 'h3', arg: [me.input, '_exec', ['heading', { level: 3 }]]},
				{ text: getLang('RICH::HEADING') + ' 4', css: 'paragraph h4', tag: 'h4', arg: [me.input, '_exec', ['heading', { level: 4 }]]},
				{ text: getLang('RICH::HEADING') + ' 5', css: 'paragraph h5', tag: 'h5', arg: [me.input, '_exec', ['heading', { level: 5 }]]},
				{ text: getLang('RICH::HEADING') + ' 6', css: 'paragraph h6', tag: 'h6', arg: [me.input, '_exec', ['heading', { level: 6 }]]}
			]);
			gui.cmenu._place(pos.x + pos.w / 2, pos.y, '', 2);
		};
	}
};

_me._readonly = function (b) {
	if (Is.Defined(b)) {

		b ? addcss(this._main, 'readonly') : removecss(this._main, 'readonly');

		this.input._readonly(b);
		this.smile && this.smile._disabled(b);
		this.add && this.add._disabled(b);
	}
	else
		return this.input._readonly();

};

_me._disabled = function (b) {
	if (Is.Defined(b)) {

		b ? addcss(this._main, 'disabled') : removecss(this._main, 'disabled');

		this.input._disabled(b);
		this.smile && this.smile._disabled(b);
		this.add && this.add._disabled(b);
	}
	else
		return this.input._disabled();

};

_me.__submit = function(v){

	if (this._onsubmit){

		var arg = {}, aM = this.input._mention();
		if (this.preview && !this.preview._destructed && !this._getAttachments().length)
			arg = this.preview._value();
			if (arg.meta && arg.meta.TYPE) {
				arg.meta.TYPE = WMChat.const.LINK[arg.meta.TYPE] || arg.meta.TYPE;
				var linkData;
				switch(arg.meta.TYPE) {
					case WMChat.const.LINK.RECORDING:
						linkData = {
							organizerName: arg.meta.ORGANIZER_NAME,
							startAt: arg.meta.RECORDINGS_0_CREATEDAT,
							expireAt: arg.meta.RECORDINGS_0_EXPIREAT,
							preview: arg.meta.RECORDINGS_0_RECORDINGS_0_THUMBNAILS_ORIGIN_0
						}
					break;
					case WMChat.const.LINK.NOTE:
						linkData = {
							body: arg.desc,
						};
						delete arg.desc;
					break;
				}
				linkData.type = arg.meta.TYPE;
				arg.linkData = JSON.stringify(linkData);
				delete arg.meta;
			}

		if (!Is.Empty(aM))
			arg.mentions = aM;

		this._onsubmit(v, arg, this.__private, function() {
			if (this.input) {
				setTimeout(function() {
					this.input._value('');
					this.input._mention('');
				}.bind(this), 5);
			}
	
			delete this.__lastURL;
			delete this.__lastURLID;
	
			this.__urlloading(false);
	
			if (this.preview)
				this.preview._destruct();

			if (this.__options.memory && this.__options.memory.set){
				executeCallbackFunction(this.__options.memory.set, '');
			}
		}.bind(this));
	}

};

_me._private = function (name, email) {
	var tmp_escape = this.label._escape;
	if (email && email != sPrimaryAccount) {
		this.__private = {name: name, email: email};
		this.label._escape = true;
		this.label._value(name || email);
		this.label._escape = tmp_escape;
		this.label._disabled(false);
	} else {
		delete this.__private;
		this.label._disabled(true);
		this.label._value('');
	}

	this._focus();
};

_me._folder = async function(aFolder) {
	if (aFolder && aFolder.aid) {
		this.input.__folder = aFolder;
		this.__lastURL = false;
		window.clearTimeout(this.__smartcheck);
		this.preview && this.preview._destruct();

		if (this.__options.memory && this.__options.memory.get){
			this.input._value(await executeCallbackFunction(this.__options.memory.get));
		}

		if (this.__options.upload) {
			var uploadInstance = await obj_upload._instance(this, aFolder.aid + '/' + aFolder.fid + '/' + aFolder.iid + (this.__options.uploadInstanceId || ''));

			if (this._upload) {
				this._upload.__remove_dropzone(this._parent._main);
				if (this._upload !== uploadInstance && !this._isUploading() && (!this._upload.file || !this._upload.file.__value.length)) {
					await this._upload._destruct();
				}
			}

			this._upload = uploadInstance;
			this._upload._onuploadstart = function(aFolder, files) {
				if (files.length) {
					this._main.classList.add('has-attachments');
				}
				[].forEach.call(files, function(file) {
					file.EVNFOLDER = aFolder.fid;
					this._create('attachment', 'obj_attachment', 'attachments', '', file, { progress: { pie: true }});
				}, this);
			}.bind(this, aFolder);

			this._clearAttachments();
			this._upload._restore();

			this._upload._dropzone(this._parent._main, async function(aFolder) {
				return await (new cTemplate()).tmp('dropzone',{title: getLang('CHAT::DROP_TITLE', [WMFolders.getFolderName(aFolder)]), body: getLang('CHAT::DROP_BODY')});
			}.bind(this, aFolder), 'item');
		}

		this.input._onkeyup();
	}
	else
		return this.input.__folder;
};

_me._getAttachments = function() {
	if (!this._upload) {
		return [];
	}
	return this._upload.file._value();
}

_me._isUploading = function() {
	return ((this._upload || {}).file || {})._isUploading;
}

_me._clearAttachments = function(bEmpty) {
	if (bEmpty) {
		this._upload.file._value([]);
	}

	this._getChildObjects('attachments').forEach(function(attachment) {
		attachment._destruct();
	});
	this._main.classList.remove('has-attachments');
};

_me._newUploadInstance = function () {
	var aFolder = this._folder();
	if (aFolder) {
		delete obj_upload.__instances[aFolder.aid + '/' + aFolder.fid + '/' + aFolder.iid];
		this._folder(aFolder);
	}

	this._getChildObjects('attachments').forEach(function(attachment) {
		attachment._destruct();
	});
	this._main.classList.remove('has-attachments');
};

_me._value = function (v) {
	return this.input._value(v);
};

_me._focus = function () {
	return this.input._focus();
};
_me._hasFocus = function(){
	return this.input._hasFocus();
};

/* Preview part */
_me.__onDestroyChild = function(sName){
	if (sName == 'preview')
		removecss(this._main, 'preview', 'loading');
};
_me.__urlloading = function(b){
	if (this.__options.loading !== false)
		b?addcss(this._main, 'loading'):removecss(this._main, 'loading');
};
_me.__urlpreview = async function(aData){
	await this._create('preview', 'obj_urlpreview','preview','', aData);
	this.preview._onclose = function(){
		this._focus();
	}.bind(this);

	removecss(this._main, 'loading');
	addcss(this._main, 'preview');
};

_me.__onuploadaborted = async function(data) {
	if (!this._upload) {
		return;
	}
	for (var attachment of this._getChildObjects('attachments')) {
		if (attachment.__file === data.file) {
			await attachment._destruct();
		}
	}

	if (!this._getChildObjects('attachments').length) {
		this._main.classList.remove('has-attachments');
	}
};

_me.__handleSelectionChanged = function(context, selection) {
	if (context !== this.input) {
		return;
	}

	var range = selection && selection.rangeCount && selection.getRangeAt(0);
	this.__range = range;
	if (range) {
		function nextNode(node) {
			if (node.hasChildNodes()) {
				return node.firstChild;
			} else {
				while (node && !node.nextSibling) {
					node = node.parentNode;
				}
				if (!node) {
					return null;
				}
				return node.nextSibling;
			}
		}

		var node = range.startContainer;
		var endNode = range.endContainer;
		var rangeNodes = [];
		
		// Special case for a range that is contained within a single node
		if (node == endNode) {
			rangeNodes = [node];
		} else {

			// Iterate nodes until we hit the end container
			while (node && node != endNode) {
				rangeNodes.push( node = nextNode(node) );
			}

			// Add partially selected nodes at the start of the range
			node = range.startContainer;
			while (node && node != range.commonAncestorContainer) {
				rangeNodes.unshift(node);
				node = node.parentNode;
			}
		}

		this.format_bold._main.classList[rangeNodes.some(function(node) {
			return node.tagName === 'B' || node.tagName === 'STRONG' || node.parentElement.closest('b') || node.parentElement.closest('strong') || node.parentElement.closest('.toastui-editor-md-strong');
		}) ? 'add' : 'remove']('active');
		this.format_italic._main.classList[rangeNodes.some(function(node) {
			return node.tagName === 'I' || node.tagName === 'EM' || node.parentElement.closest('i') || node.parentElement.closest('em') || node.parentElement.closest('.toastui-editor-md-emph');
		}) ? 'add' : 'remove']('active');
		this.format_strike._main.classList[rangeNodes.some(function(node) {
			return node.tagName === 'S' || node.tagName === 'DEL' || node.parentElement.closest('s') || node.parentElement.closest('del') || node.parentElement.closest('.toastui-editor-md-strike');
		}) ? 'add' : 'remove']('active');
	}
};

_me.__disobeyEvents = function() {
	this._upload && this._upload.__remove_dropzone();
	this._upload && !this._isUploading() && (!this._upload.file || !this._upload.file.__value.length) && this._upload._destruct();
	this._gui.smile && this._gui.smile._destruct();
	this._gui.Gifs && this._gui.Gifs._destruct();
	this.input._disobeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
	gui._disobeyEvent('onuploadaborted', [this, '__onuploadaborted']);
	gui._disobeyEvent('settings_changed', [this, '__initToolbar']);
	gui._disobeyEvent('chatgptChanged', [this, '__initToolbar']);
};