function obj_carousel(){};

obj_carousel.prototype = {
    __constructor: async function(){
		this.__value = 0;
		this.__current = -1;
		this.__aData = [];
		this.__skin = 'client/skins/'+GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

		this._getAnchor(gui._rtl?'next':'prev').onclick = function(){
			var v = this.__value;
			this._value(v-1);
			if (this.__aData[v].buttons && this.__aData[v].buttons.prev && this.__aData[v].buttons.prev.onclick)
				executeCallbackFunction(this.__aData[v].buttons.prev.onclick);

		}.bind(this);

		this._getAnchor(gui._rtl?'prev':'next').onclick = function(){
			var v = this.__value;
			this._value(v+1);

			if (this.__aData[v].buttons && this.__aData[v].buttons.next && this.__aData[v].buttons.next.onclick)
				executeCallbackFunction(this.__aData[v].buttons.next.onclick);

		}.bind(this);
	},

	_fill:function(aData){
		this.__aData = aData;

		if (Is.Array(aData)){
			this.__aData = aData;

			this.__value = 0;
			this.__current = -1;
			this.__slide(this.__value);
		}

		if (this._onchange)
			this._onchange(this.__value);
	},

	_value:function(v){
		if (this.__value != v){
			if (this.__slide(v)){
				this.__value = v;

				if (this._onchange)
					this._onchange(this.__value);
			}
		}
		else
			return this.__value;
	},

	__slide:function(v){
		var data = this.__aData[v];
		if (data){

			this._main.removeAttribute('iw-dir');

			var img = new Image();
			img.onload = function(){

				if (this._destructed)
					return;

				var width = img.naturalWidth;

				//Animation
				if (this.__current>-1 && this.__current != v){

					var dir = v<this.__current?'right':'left';

					this._main.setAttribute('iw-dir', dir);

					addcss(this._main, 'obj_carousel-exit');
					removecss(this._main, 'obj_carousel-enter');

					this.__timer = setTimeout(function(){
						addcss(this._main, 'obj_carousel-enter');
						removecss(this._main, 'obj_carousel-exit');
						this.__draw(v, img.currentSrc || img.src, width);
					}.bind(this),400);
				}
				else
					this.__draw(v, img.currentSrc || img.src, width);

			}.bind(this);

			this.__timer && clearTimeout(this.__timer);

			//img.srcset support
			if (Is.Array(data.src)){
				var a = data.src.map(function(s){
					return this.__skin + '/images/' + s;
				}.bind(this));

				if ('srcset' in img)
					img.srcset = a.join(', ');
				else
					img.src = a[0];
			}
			else
				img.src = this.__skin + '/images/' + data.src;

			return true;
		}
	},

	__draw:function(v, src, width){
		if (this._destructed) {
			return;
		}
		var data = this.__aData[v],
			ePrev, eNext;

		if (gui._rtl){
			ePrev = this._getAnchor('next'),
			eNext = this._getAnchor('prev');
		}
		else{
			ePrev = this._getAnchor('prev'),
			eNext = this._getAnchor('next');
		}
		this._getAnchor('img').width = width;
		this._getAnchor('img').src = src;
		this._getAnchor('head').innerHTML = data.label || '';

		if (data.buttons){
			if (data.buttons.prev){
				if (data.buttons.prev.label)
					eNext.firstElementChild.textContent = data.buttons.prev.label;

				if (data.buttons.prev.css)
					addcss(ePrev, data.buttons.prev.css);
			}

			if (data.buttons.next){
				if (data.buttons.next.label)
					eNext.firstElementChild.textContent = data.buttons.next.label;

				if (data.buttons.next.css)
					addcss(eNext, data.buttons.next.css);
			}
		}
		else{
			ePrev.firstElementChild.innerHTML = '';
			eNext.firstElementChild.innerHTML = '';

			if (gui._rtl){
				ePrev.className = 'obj_carousel_btn obj_carousel_btn-next';
				eNext.className = 'obj_carousel_btn obj_carousel_btn-prev';
			}
			else{
				ePrev.className = 'obj_carousel_btn obj_carousel_btn-prev';
				eNext.className = 'obj_carousel_btn obj_carousel_btn-next';
			}
		}

		this._setOverlay(data.overlay || '');

		this.__current = v;
	},

	_setOverlay:function(v){
		this._getAnchor('overlay').innerHTML = v;
	}
};