_me = obj_call.prototype;
function obj_call(){};

_me.__constructor = async function() {
	this._listen('sip');
	dataSet.obey(this, '_listener_data', 'xmpp', true);

	this._defaultSize(320, 'auto');

	this._resizable(false);
	this._closable(false);

	this._add_destructor('__destructor');
};

_me._place = function() {
	return obj_popup.prototype._place.apply(this, arguments);
};

_me.__update = async function(sDName){

	var ds = dataSet.get('sip'),
		im = false,
		sInfo = '';

	if (!ds) return;

	if (ds.p1){
		switch(dataSet.get('xmpp',['roster',ds.p1,'show'])){
			case 'online':
			case 'away':
			case 'xa':
			case 'dnd':
				im = true;
				break;
		}
	}

	if (sDName && this.__lastActivity && this.__lastActivity==ds.activity+'/'+ds.muted+'/'+(im?'im':''))
		return;

	var tmp;
	switch(ds.activity){
		case 'Calling':
			await this._fill([
				{anchor:'avatar', css:'avatar', keep:true},
				{title:'DIAL::HANG_UP', css:'big ico hangup color2', arg:'hangup'}
			]);

			sInfo = getLang('DIAL::CALLING');
			break;

		case 'Phoning':
			var time = this.clock && this.clock._value() || '0:00';
			tmp = [{anchor:'avatar', css:'avatar', keep:true}];

			if (this.__dtmf)
				tmp.push({anchor:'keypad', css:'keypad', keep:true});
			else
				tmp.push({title:'DIAL::KEYPAD', css:'big ico dial', arg:'dial', keep:true});

			if (im)
				tmp.push({title:'IM::IM',css:'big ico chat', arg:'im'});

			tmp.push({title:'DIAL::MUTE', css:'big ico mute'+(ds.muted?' active':''), arg: 'mute', keep: true});

			// if(!ds.video)
			// 	tmp.push({title: 'DIAL::ADD_VIDEO', css:'big ico video', arg: 'add_video', keep: true});

			if(!ds.video)
				tmp.push({title: this.__holding?'DIAL::UNHOLD':'DIAL::HOLD', css:'big ico hold'+(ds.onhold?' active':''), arg: 'hold', keep: true});

			tmp.push({title:'DIAL::HANG_UP', css:'big ico hangup color2', arg:'hangup'});

			await this._fill(tmp);

			if (this.__dtmf)
				await this._create('dtmf','obj_dtmf','keypad');

			await this._create('clock','obj_label','avatar','lbl_clock');
			if (this.clock) {
				this.clock._value(time);
				this._startTimer();
			}

			sInfo = getLang('DIAL::CALLESTABLISHED');
			break;

		case 'Ringing':
			tmp = [{anchor:'avatar', css:'avatar',keep:true}];

			tmp.push({title:'DIAL::DECLINE',css:'big ico decline color2',arg:'decline'});
			tmp.push({title:'DIAL::ANSWER', css:'big ico '+(dataSet.get('sip',['remote','video'])?'video':'answer')+' color3x', arg:'answer', keep:true});
			await this._fill(tmp);

			sInfo = getLang('DIAL::INCOMINGCALL');
			break;

		default:
			// No phone activity, remove calling dropdown
			this._destruct();

			if (gui.video)
				gui.video._destruct();

			return;
	}

	//refresh info
	var name = dataSet.get('sip',['remote','name']) || dataSet.get('sip',['remote','id']);
	if (name && sInfo && ds.type!='Info' && this._getAnchor('avatar')) {
		this._getAnchor('avatar').appendChild(obj_avatar.getAvatarElement({
			email: dataSet.get('sip',['remote','id']),
			name: name,
			size: 64
		}));
		await this._create('label','obj_label','avatar','lbl_action');
		this.label._value(sInfo);
		await this._create('user','obj_label','avatar','lbl_user');
		this.user._value(name.indexOf('@')>0?name.substr(0,name.indexOf('@')):name);
		this._title(name.indexOf('@')>0?name.substr(0,name.indexOf('@')):name, true);
	}

	this.__lastActivity = ds.activity+'/'+ds.muted+'/'+(im?'im':'');
};

_me._startTimer = function(){
	if (this.__interval)
		window.clearInterval(this.__interval);

	var me = this;
	this.__interval = window.setInterval(function(){

		var t = new IcewarpDate(dataSet.get('sip',['timer']));

		if (me.clock && t && (t = new IcewarpDate().unix() - t.unix())){

			var h = Math.floor(t/3600),
				m = Math.floor(t%3600/60),
				s = Math.floor(t%60),
				pad = function(v){
					return v<10?'0'+v:v;
				};

			me.clock._value((h?h +':' + pad(m):m) +':'+ pad(s));
		}
	},1000);
};

_me._onclose = function(){
	switch(dataSet.get('sip',['activity'])){
		case 'Calling':
		case 'Ringing':
		case 'Phoning':
			return false;
	}
};

_me._onclick = function(e, elm, id, arg){
	var sip = gui.frm_main.sip;
	if (sip)
		switch(arg){
			case 'im':
				var usr = dataSet.get('sip',['p1']);
				if (usr && gui.frm_main.im)
					gui.frm_main.im._chat(usr);

				break;
			case 'dial':
				this.__dtmf = true;
				this.__update();
				break;
			case 'mute':
				sip._mute(!sip._mute());
				break;
			case 'hold':
				var hold = !sip._hold();
				sip._hold(hold);
				this.__holding = hold;
				this.__update();
				break;
			case 'answer':
				sip._answerCall();
				break;
			case 'answer_video':
				sip._answerCall(true);
				break;
			// case 'add_video':
			// 	sip._addVideo();
			// 	break;
			case 'decline':
				sip._declineCall();

				//open decline dialog

				break;
			case 'hangup':
				sip._hangup();
				break;
		}

};

_me.__destructor = function(){
	if (this.__interval)
		window.clearInterval(this.__interval);
};