_me = obj_calendar.prototype;
function obj_calendar() {};

_me.__constructor = async function (opt) {
	var me = this;
	this.__timeout;

	this.__opt = opt || {};

	var aTemplateData = {
		month_names:IcewarpDate.months().map(function (month, i) {
			return {index: i, month: month};
		}, this)
	};

	if (this.__opt.week){
		addcss(this._main, 'week');
		aTemplateData.week = true;
	}

	aTemplateData.time = this.__opt.time;

	await this._draw('obj_calendar', '', aTemplateData);

	this.__eMain = this._getAnchor('main');

	this.__eMain.onclick = async function (e) {
		var elm = e.target,
			dDate;

		if (me.__opt.week && elm.tagName == 'SPAN' && hascss(elm,'week')){
			dDate = new IcewarpDate();
			dDate.week(parseInt(elm.textContent));
		}
		else
		if (elm.tagName !== 'A') {
			return;
		}
		else{
			var rel = hascss(elm, 'last') ? -1 : (hascss(elm, 'next') ? 1 : 0),
				id = me.__getId(elm.id);
			dDate = me.__getDate(id, rel);
		}

		await me._value(dDate); 	// pozor dela refresh
		if (me._onclick) {
			me._onclick(e, elm);
		}
		me.__exeEvent('onclick', e, {"owner": me, "elm": elm, "date": dDate});
	};
	function throttle(fn, wait) {
		var time = Date.now();

		return function(event) {
			// we dismiss every wheel event with deltaY less than 4
			if (Math.abs(event.deltaY) < 4) return

			if ((time + wait - Date.now()) < 0) {
				fn(event);
				time = Date.now();
			}
		}
	}

	this.__eMain.addEventListener("wheel", throttle(function (e) {
		e.preventDefault();
		if (e.deltaY < 0) {
			me.left1._onclick();
		} else {
			me.right1._onclick();
		}
	}, 250));

	if (this.week){
		this.week._fillWeek = async function(dDate){
			for(var aFill = {}, i = 0, j = dDate.weeksInYear(); i<=j; i++)
				aFill[i] = i;

			await this._fill(aFill);
		};
		this.week._onchange = async function () {
			me._dDate.week(await this._value());
			await me.__draw();
		};
	}

	this.month._onchange = async function () {
		await me._setDate('', await this._value());
		return true;
	};

	this.year._onchange = async function () {
		var date = new IcewarpDate();
		if(date.calendar_type === IcewarpDate.Calendars.HIJRI && (await this._value() < 1356 || await this._value() > 1500)){
			return true;
		}

		this._value() && (me._dDate.year() !== await this._value()) && await me._setDate(this._value());
		return true;
	};

	this.year._fillYear = async function(v){
		for(var aFill = {}, i = v-25, j = v + 25; i<=j; i++)
			aFill[i] = i;

		await this._fill(aFill);
	};

	if (this.time) {
		this.time._onchange = function() {
			var value = Math.floor(me.time._value() / 1000);
			var hour = Math.floor(value / 3600);
			var minute = Math.floor((value - hour * 3600) / 60);
			me._dDate.hour(hour).minute(minute).second(0);
		};
	}

	this.year._onkeydown = function (e) {
		if ((e.keyCode > 47 && e.keyCode < 58) || (e.keyCode > 95 && e.keyCode < 106)) {
			var v = me.year._value();
			if (!v && !(e.keyCode === 49 || e.keyCode === 50 || e.keyCode === 97 || e.keyCode === 98)) {
				return false;
			}

			if (e.keyCode !== 37 && e.keyCode !== 39) {
				if (me.__timeout) {
					window.clearTimeout(me.__timeout);
				}
				me.__timeout = window.setTimeout(function () {
					me.__setYear();
				}, 300);
			}

			if (v && v.length === 4 && (e.target.selectionStart === e.target.selectionEnd)) {
				return false;
			}

			return true;
		}
		// Allow erase and moving cursor
		else
			return e.keyCode === 8 || e.keyCode === 46 || e.keyCode === 37 || e.keyCode === 39;
	};

	this.left1._onclick = function () {
		if (me._dDate.year() > 1 || me._dDate.month() > 0) {
			me._dDate.subtract(1, 'month');
			me.__draw();
		}
	};
	this.right1._onclick = function () {
		me._dDate.add(1, 'month');
		me.__draw();
	};

	this.today._onclick = function () {
		me._value(new IcewarpDate());
	};

	await this._value(new IcewarpDate(), true);

	this._add_destructor('__destruct');
};

_me.__destruct = function(){
	if (this.__timeout)
		window.clearTimeout(this.__timeout);
};
/**
 * This method is called in timeslip by this.year selectbox
 **/
_me.__setYear = async function () {
	var date = new IcewarpDate();
	this.year.__restrictions = [].slice.call(this.year.__restrictions);
	if(date.calendar_type === IcewarpDate.Calendars.HIJRI && ~!this.year.__restrictions.indexOf('<1500i')){
		this.year.__restrictions.push('<1500i');
		this.year.__restrictions.push('2');
	}
	try {
		var year = parseInt(this.year._value());
		if (date.calendar_type !== IcewarpDate.Calendars.HIJRI || (year > 1355 && year < 1501)) {
			await this._setDate(year);
		}
	} catch (er) {
		 console.log(this._name || false, er);
	}
};

_me._setDate = async function (year, month) {
	this._dDate.year(+(year || this._dDate.year())).month(+(month || this._dDate.month()));
	await this.__draw();
};

_me._value = async function (date, no_update) {
	if (date) {
		if (date instanceof IcewarpDate) {
			this._dDate = date.clone();
		} else if (Is.Number(date) || (Is.String(date) && !isNaN(parseInt(date)))) {
			var now = new IcewarpDate();
			this._dDate = new IcewarpDate(date, {format: IcewarpDate.JULIAN}).hour(now.hour()).minute(now.minute()).second(now.second());
		} else {
			this._dDate = new IcewarpDate(date);
		}

		// selected date
		await this.__draw();

		if (!no_update) {

				if (this._onchange)
					await this._onchange(this._dDate);
				this.__exeEvent('onchange', null, {"owner": this, "date": this._dDate});

		}

	} else {
		return this._dDate;
	}
};

_me.__update = async function (sDataSet) {
	// update calendar data
	if (this._listener_data == sDataSet)
		await this.__draw();

	// update calendar view
	if (this._listener == sDataSet)
		this._value(dataSet.get(this._listener, this._listenerPath));
};

_me._listen_data = function (sDataSet, aDataPath) {
	this._listener_data = sDataSet;
	if (typeof aDataPath == 'object')
		this._listenerPath_data = aDataPath;
	dataSet.obey(this, '_listener_data', sDataSet);
};

/**
 * @brief: Dataset Parser function
 **/
_me._fill = function (aData) {
	/*
	 PARSER BODY
	 */
	return aData;
};

_me.__draw = async function () {
	var data = {
		"weeks": [],
		"days": [''].concat(IcewarpDate.weekdaysShort())
	};
	var today = new IcewarpDate();
	// Data from dataset
	if (this._listener_data)
		this._fill(dataSet.get(this._listener_data, this._listenerPath_data));

	//Week
	if (this.week){
		await this.week._fillWeek(this._dDate);
		this.week._value(this._dDate.week(), true);
	}

	// Month select
	this.month._value(this._dDate.month(), true);

	// Year select
	await this.year._fillYear(this._dDate.year());
	this.year._value(this._dDate.year(), true);

	//var month = this._dDate.month();
	var next_month = this._dDate.clone().add(1, 'month').month();
	var end_day = this._dDate.clone().endOf('month').endOf('week').add(1, 'day');
	if (end_day.month() !== next_month) {
		// fix for HIJRI calendar, in some cases endOf(month) returns wrong month
		// https://github.com/xsoh/moment-hijri/issues/22
		end_day = this._dDate.clone().month(next_month).startOf('month').subtract(1, 'day').endOf('week').add(1, 'day');
	}

	var start_day = this._dDate.clone().startOf('month').startOf('week');
	var week = [{week: start_day.isoWeekday() === 1 ? start_day.week() : start_day.clone().isoWeekday(8).week()}];
	while (start_day.format('YYYY-MM-DD') != end_day.format('YYYY-MM-DD')) {
		//var current_month = start_day.month();
		week.push({
			value: start_day.date(),
			label: (start_day.date()).toLocaleString(document.documentElement.lang || 'en'),
			class: (start_day.isAfter(this._dDate, 'month') ? 'next ' : (start_day.isBefore(this._dDate, 'month') ? 'last ' : '')) + (start_day.isSame(today, 'day') ? 'today ' : '') + (start_day.isSame(this._dDate, 'day') ? 'active' : '') + ((this.__opt.minDate && start_day.isBefore(this.__opt.minDate, 'day')) ? ' disabled' : '')
		});
		start_day.add(1, 'day');
		if (start_day.day() === IcewarpDate.firstDayOfWeek()) {
			data.weeks.push(week.slice(0));
			week = [{week: start_day.isoWeekday() === 1 ? start_day.week() : start_day.clone().isoWeekday(8).week()}];
		}
	}

	await this._draw('obj_calendar_main', 'main', data);

	if (this.__opt.week){
		[].forEach.call(this.__eMain.querySelectorAll('span.week'), function(eWeek){
			eWeek.onmouseover = function(){
				addcss(this.parentElement.parentElement,'week');
			};
			eWeek.onmouseout = function(){
				removecss(this.parentElement.parentElement,'week');
			};
		});
	}

	if (this.__opt.time) {
		this.time._value(this._dDate.unix() + this._dDate.utcOffset() * 60 + '000');
	}
};

_me.__getId = function (eid) {
	return eid.substr(this._pathName.length + 1);
};

_me.__getDate = function (id, rel) {
	rel = rel || 0;
	var month = this._dDate.month();
	return this._dDate.clone().month(rel > 0 ? (month + 1) : (rel < 0 ? month - 1 : month)).date(+id);
};
