function obj_button_tree() { }

obj_button_tree.recent = {
	public: 0,
	shared: 0
};
obj_button_tree.unread = {
	public: false,
	shared: false
};

obj_button_tree.prototype.__constructor = async function (oOptions) {
	this.__options = Object.assign({
		shared: true,
		public: true,
		favorites: false
	}, oOptions);

	this._update();
	this._obeyEvent('onchange', [this, '__onChange']);

	this._listen('folders');

	if ((gui.frm_main || {}).dnd) {
		gui.frm_main.dnd.registr_drop(this, ['item','folder', 'attachment']);
	}
};

obj_button_tree.prototype.__onChange = function (e, arg) {
	if (this._folderType === 'M') {
		this._main.querySelector('[iw-id="' + arg.value + '"]').classList.remove('unread');
		obj_button_tree.unread[arg.value == '2' ? 'shared' : 'public'] = false;
	}
	gui.frm_main.bar.slide._value(arg.value, e && e.bNoAnimation);
};

obj_button_tree.prototype._update = function() {
	if (this.__options.shared || this.__options.public) {
		this._main.classList.remove('hidden');

		this._fill([
			{
				label: 'COMMON_FOLDERS::YOURS',
				index: 1
			},
			this.__options.shared && {
				label: 'COMMON_FOLDERS::SHARED',
				index: 2,
				css: (this._folderType === 'M' && obj_button_tree.unread.shared) ? 'unread' : ''
			},
			this.__options.public && {
				label: 'COMMON_FOLDERS::PUBLIC',
				index: 3,
				css: (this._folderType === 'M' && obj_button_tree.unread.public) ? 'unread' : ''
			}
		].filter(Boolean));

		if ((this._value() === 2 && !this.__options.shared) || (this._value() === 3 && !this.__options.public)) {
			this._value(1);
		}
	} else {
		this._main.classList.add('hidden');
		this._value(1);
	}
};

obj_button_tree.prototype.__update = function () {
	var pub = 0;
	var shared = 0;
	var ds = dataSet.get('folders', [sPrimaryAccount]);
	for (var i in ds) {
		var folder = ds[i];
		if (folder.TYPE !== 'M') {
			continue;
		}
		if (i.indexOf(sPrimaryAccountSPREFIX) === 0) {
			shared += +folder.RECENT || 0;
		} else {
			var root = ds[i.split('/')[0]] || {};
			if (root.PUBLIC) {
				pub += +folder.RECENT || 0;
			}
		}
	}

	if (obj_button_tree.recent.shared < shared) {
		if (obj_button_tree.recent.shared !== void 0 && this._value() != '2') {
			if (this._folderType === 'M') {
				this._main.querySelector('[iw-id="2"]').classList.add('unread');
			}
			obj_button_tree.unread.shared = true;
		}
	}
	obj_button_tree.recent.shared = shared;

	if (obj_button_tree.recent.public < pub) {
		if (obj_button_tree.recent.public !== void 0 && this._value() != '3') {
			if (this._folderType === 'M') {
				this._main.querySelector('[iw-id="3"]').classList.add('unread');
			}
			obj_button_tree.unread.public = true;
		}
	}
	obj_button_tree.recent.public = pub;
};

obj_button_tree.prototype._onresize = function () {
	var buttons = this._main.querySelectorAll('.button').length;
	if (this._main.clientWidth < buttons * 75) {
		this._main.classList.add('narrow');
	} else {
		this._main.classList.remove('narrow');
	}
};

obj_button_tree.prototype._ondragover = function(v) {
	var eOver;
	[].some.call(this._main.querySelectorAll('.button'), function(button) {
		var aSize = getSize(button);
		if ((aSize.x < v.x) && ((aSize.x + aSize.w) > v.x)) {
			eOver = button;
			return true;
		}
	});
	if (eOver) {
		clearTimeout(this.__timeout);
		this.__timeout = setTimeout(function() {
			this._value(eOver.getAttribute('iw-id'));
		}.bind(this), 500);
	}
};

obj_button_tree.prototype._ondragout = function () {
	clearTimeout(this.__timeout);
};