_me = obj_button_switch.prototype;
function obj_button_switch() {}

_me.__constructor = async function () {
	this.__value = 0;
	this.__width = 100;

	this._main.onclick = function (e) {
		var elm = e.target;

		if (!hascss(elm, 'button')) {
			elm = elm.parentNode;
		}

		if (hascss(elm, 'button'))
			this._value(elm.getAttribute('iw-id'), false, e, e.ctrlKey || e.metaKey);

	}.bind(this);

	this._getAnchor('iframe').contentWindow.addEventListener('resize', function(e) {
		this._onresize && this._onresize(e);
	}.bind(this));
};

// v  0|1|2|*
_me._value = function (v, bNoUpdate, e, bForce) {
	if (Is.Defined(v)) {
		v = +v;

		if ((this.__value != v) || bForce) {

			this.__value = v || 0;

			this.__updSlider(e && e.bNoAnimation);


			// onchange event
			if (!bNoUpdate){
				this._onchange && this._onchange();
				this.__exeEvent('onchange', e, {"owner": this, value: this.__value});
			}
		}
	}
	else {
		return this.__value;
	}
};

_me._getValue = function () {
	return (this.__aButtons[this._value() - 1] || {}).value;
};

_me._setValue = function (v, bNoUpdate) {
	for (var i in this.__aButtons) {
		if (this.__aButtons[i].value === v) {
			this._value(+i + 1, bNoUpdate);
			break;
		}
	}
};

_me.__updSlider = function(bNoAnimation){
	var btns = [].slice.call(this._getAnchor('buttons').querySelectorAll('[iw-id]'));
	var index;
	for (var i in btns) {
		if (btns[i].getAttribute('iw-id') === this.__value.toString()) {
			index = i;
			addcss(btns[i], 'active');
		} else {
			removecss(btns[i], 'active');
		}
	}

	if (bNoAnimation) {
		this._main.classList.add('noAnimation');
	}
	var sli = this._getAnchor('slider');
	sli.style[gui._rtl?'right':'left'] = (this.__width*index) + '%';
	sli.style.width = this.__width + '%';
	setTimeout(function() {
		this._main.classList.remove('noAnimation');
	}.bind(this), 5);
};

// aButtons array of buttons
_me._fill = function (aButtons) {
	this.__aButtons = aButtons;
	if (Is.Array(aButtons)){
		var btns = this._getAnchor('buttons');

		btns.innerHTML = '';

		var len = aButtons.length;
		this.__width = Math.round(10000/len)/100;

		var rest = 100 - (this.__width*(len-1)),
			css, label, index, tooltip;

		for (var i = 0;i<len;i++) {
			if (Is.Object(aButtons[i])){
				css = aButtons[i].css || '';
				label = aButtons[i].label;
				tooltip = aButtons[i].tooltip === void 0 ? aButtons[i].label : aButtons[i].tooltip;
				index = aButtons[i].index || (i + 1);
			}
			else{
				css = '';
				tooltip = label = aButtons[i] || '';
				index = i + 1
			}

			var btn = mkElement('div', {
				className: 'button' + (this._value().toString() === index.toString() ? ' active' : '') + (css?' '+css:''),
				'iw-id': index,
				style: {
					width: (index === len ? rest : this.__width) + '%'
				}
			}, null, [mkElement('div', {
				text: getLang(label),
				className: 'label',
			})]);
			btns.appendChild(btn);
			tooltip && gui.tooltip._add(btn, getLang(tooltip));
		}

		this.__updSlider(true);
		this._onresize && this._onresize();
	}
};