_me = obj_bubble.prototype;
function obj_bubble(){};

_me.__constructor = async function(){
	this.__timer = null;
	this.__state = 'hidden';
	this.__aPos = {};

	this.__modal = false;

	this._add_destructor('_destructor');

	this._main.onmouseover = function(e){
		if (!this._onshow || this._onshow(e) !== false)
			this._show();
	}.bind(this);

	this._main.onmouseout = function(e){
		if (!this.__modal)
			if (!Is.Child(e.relatedTarget,this))
				if (!this._onhide || this._onhide(e) !== false)
					this._hide();
	}.bind(this);

	this._main.style.zIndex = this.__zindex = maxZIndex.get() + 1000;
};

_me._modal = function(b){

	if (b && !this.__modaldiv){

		// Remove previous z-index and assign new top value
		maxZIndex.remove(this.__zindex);
		this._main.style.zIndex = this.__zindex = maxZIndex.get() + 1000;

		//modal window
		this.__modal = true;

		this.__modaldiv = mkElement("div",{className:'obj_bubble_modaldiv'});
		this.__modaldiv.style.zIndex = parseInt(this.__zindex)-1;
		this.__modaldiv.onclick = function(e){
			if (this._onclose)
				this._onclose(e);
		}.bind(this);

		this._main.parentNode.insertBefore(this.__modaldiv,this._main);
	}
	else
	if (!b && this.__modaldiv){
		if (this.__modaldiv.parentNode)
			this.__modaldiv.parentNode.removeChild(this.__modaldiv);

		this.__modaldiv = null;
	}
};

_me._place = function(aPos){
	this.__aPos = aPos;

	if (this.__state == 'visible'){
		this._main.style.left = aPos.left || '';
		this._main.style.right = aPos.right || '';
		this._main.style.top = aPos.top || '';
		this._main.style.bottom = aPos.bottom || '';
	}
};

_me._placeElement = function(elm, opt){

	opt = Object.assign({mode:'right'}, opt);

	if (!this.__eArrow)
		this.__eArrow = this._main.appendChild(mkElement('div', {className:'bubble_arrow'}));

	if (Is.Number(opt.width))
		this._main.style.width = opt.width +'px';

	var mSize = getSize(this._main),
		eSize = Is.Element(elm)?getSize(elm):Object.assign({w:0, h:0}, elm),
		doc = this._main.ownerDocument.defaultView,
		dh = doc.innerHeight || doc.document.body.clientHeight,
		dw = doc.innerWidth || doc.document.body.offsetWidth,
		eArrow = this.__eArrow;

	//switch mode in RTL
	if (gui._rtl)
		opt.mode == ({right:'left', left:'right'})[opt.mode] || opt.mode;

	this.__position = {};

	function place(mode, bForce){
		var ex,ey, position = {};

		switch(mode){
			case 'left':
				ex = eSize.x;
				ey = eSize.y + eSize.h/2;

				position.x = dw - ex + 7;
				position.y = ey - 16;

				if (!bForce && ex - mSize.w - 7 < 9)
					return place('right', true);

				//fit screen-height
				if (position.y + mSize.h + 20 > dh){
					position.y = ey + (dh - position.y - mSize.h - 20);

					if (position.y < 9){
						position.y = 9;
						position.scrollable = true;
					}
				}

				eArrow.style.top = (ey - position.y - 8) + 'px';
				eArrow.style.left = 'auto';
				eArrow.style.right = '-14px';
				break;

			case 'right':
				ex = eSize.x + eSize.w;
				ey = eSize.y + eSize.h/2;

				position.x = ex + 7;
				position.y = ey - 16;

				//fit screen-width
				if (!bForce && position.x + mSize.w > dw - 9)
					return place('left', true);

				//fit screen-height
				if (position.y + mSize.h + 20 > dh){
					position.y = ey + (dh - position.y - mSize.h - 20);

					if (position.y < 9){
						position.y = 9;
						position.scrollable = true;
					}
				}

				eArrow.style.top = (ey - position.y - 8) + 'px';
				eArrow.style.right = 'auto';
				eArrow.style.left = '-14px';
				break;

			case 'top':
				ex = eSize.x + eSize.w/2;
				ey = eSize.y;

				position.x = ex - mSize.w/2;
				if (position.x + mSize.w + 9 > dw)
					position.x = Math.max(0, dw - mSize.w - 9)

				position.y = ey - mSize.h - 7;

				if (!bForce && position.y < 8)
					return place('bottom', true);

				eArrow.style.left = ex - position.x + 'px';
				eArrow.style.right = 'auto';
				break;

			case 'bottom':
				ex = eSize.x + eSize.w/2;
				ey = eSize.y + eSize.h;

				position.x = ex - mSize.w/2;
				if (position.x + mSize.w + 9 > dw)
					position.x = Math.max(0, dw - mSize.w - 9)

				position.y = ey;
				if (!bForce && position.y + mSize.h > dh - 9)
					return place('top', true);

				eArrow.style.left = ex - position.x + 'px';
				eArrow.style.right = 'auto';
				break;
		}

		position.mode = mode;

		return position;
	}

	this.__position = place(opt.mode);
	this.__position.elm = elm;
	this.__position.defaultMode = opt.mode;

	switch(this.__position.mode){
		case 'left':
			this._main.style.top = this.__position.y +'px';
			this._main.style.right = this.__position.x +'px';
			this._main.style.left = 'auto';
			this._main.style.bottom = 'auto';
			break;

		case 'right':
			this._main.style.top = this.__position.y +'px';
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.bottom = 'auto';
			break;

		case 'top':
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.top = this.__position.y +'px';
			this._main.style.bottom = 'auto';
			break;

		case 'bottom':
			this._main.style.left = this.__position.x +'px';
			this._main.style.right = 'auto';
			this._main.style.top = this.__position.y +'px';
			this._main.style.bottom = 'auto';
			break;
	}

	this._main.setAttribute('iw-mode', this.__position.mode);
};

_me._hide = function(bForce){

	if (this.__timer)
		clearTimeout(this.__timer);

	if (bForce){
		removecss(this._main, 'show');
		this.__state = 'hidden';

		this.__modal && this._modal(false);

		if (this._onstate)
			this._onstate(this.__state);
	}
	else
	this.__timer = setTimeout(function(){
		if (this && !this._destructed)
			this._hide(true);
	}.bind(this), 400);
};

_me._show = function(){
	if (this.__timer)
		clearTimeout(this.__timer);

	addcss(this._main, 'show');
	this.__state = 'visible';

	this.__modal && this._modal(true);

	if (this._onstate)
		this._onstate(this.__state);
};

_me._destructor = function(){
	if (this.__timer)
		clearTimeout(this.__timer);

	if (this.__modaldiv)
		this._modal(false);
};