_me = obj_barmenu.prototype;
function obj_barmenu(){};

_me.__constructor = async function(options) {
	this.__options = options;
	await this._create('slide','obj_slide', 'middle');

	var slide1 = await this.slide._create('1', 'obj_slide_panel', '', '', { scrollable: true });
	await this.slide._create('2', 'obj_slide_panel');
	await this.slide._create('3', 'obj_slide_panel');

	slide1._getAnchor('container').innerHTML = '<div class="system" id="' + slide1._pathName + '#system"></div><div class="tree" id="' + slide1._pathName + '#tree"></div>';
	
	this.folders = await slide1._create('folders','obj_tree_folder2_context', 'tree', '', void 0, void 0, void 0, void 0, {privateOnly: true, privateRootActive: false, rootFolderDroppable: true});
	this.folders._disable_scrolbar(this.folders.__eBody, true, true);

	await this._create('search', 'obj_input_search', 'bottom', 'obj_input_100 active');
	this.search._onkeyup = function(e) {
		if (e.keyCode === 27) {
			this.search._value('');
		}
		var value = this.search._value();
		[this.folders, this._recent, this._archive, this._public, this._shared].filter(Boolean).forEach(function(tree) {
			tree.inp_search._value(value);
			tree.inp_search._onkeyup(e, true);
		});
		this._system && this._system._filter(value);
	}.bind(this);
	this.search._onsubmit = this.search._onkeyup.bind(this.search, {});

	if (!sPrimaryAccountGUEST){
		var btn = await this._create('add_container', 'obj_block', 'middle', 'add_container');
			await btn._create('btn_add', 'obj_button', '', 'btn_add color1 simple big');
			btn.btn_add._onclick = function(callback){
				var sFolderID = Path.split(dataSet.get('active_folder'));

				//Pass sFolderID only for TeamChat
				if (sFolderID && sFolderID[0] == sPrimaryAccount && sFolderID[1] && ~['I','Y'].indexOf(WMFolders.getType({aid:sPrimaryAccount,fid:sFolderID[1]})))
					sFolderID = sFolderID[1];
				else
					sFolderID = '';

				//Add room focus fix
				try{this._getFocusElement().blur()}catch{
					//
				}

				Folder.addFolder({aid:sPrimaryAccount,fid:sFolderID}, [function() {
					Folder.openFolder.apply(null, arguments);
					executeCallbackFunction(callback, arguments[0]);
				}]);
			};

			btn._ondrop = function(v) {
				btn._onclick([function(folder) {
					gui.frm_main.dnd.remove_drag(true);
					var iids = [];
					for (var i in v.value){
						iids.push(v.value[i].iid)
					}
					var list = gui.frm_main.main.list;
					Item.__convertToFolder(folder.aid, folder.fid, v, list, list && list.__getNext(iids));
				}]);
			};
		gui.frm_main.dnd.registr_drop(btn, ['item']);
	}

	dataSet.on('active_folder', [], this._changeFolder, this);

	dataSet.obey(this, '', 'folders');
};

_me._changeFolder = async function(sActiveFolder) {
	var aPath = Path.split(sActiveFolder, true),
		sType = WMFolders.getType(aPath);

	this._setFolderName(sActiveFolder);

	if (this.__sActiveFolder === sActiveFolder) {
		return;
	}

	var slide1 = this.slide[1];
	var slide2 = this.slide[2];
	var slide3 = this.slide[3];

	if (sType !== WMFolders.getType(Path.split(this.__sActiveFolder, true))) {
		this.search._onkeyup({
			keyCode: 27
		});
	}
	this.__sActiveFolder = sActiveFolder;

	gui.__exeEvent('resize');

	if (sType === 'Y') {
		sType = 'I';
	}

	if (sType === 'I') {
		gui.frm_main._openFolderPicker(true);
	} else if (Cookie.get(['hide_tree', sType])) {
		gui.frm_main._closeFolderPicker(true);
	} else if (!+GWOthers.getItem('LAYOUT_SETTINGS', 'autohide_tree')) {
		gui.frm_main._openFolderPicker(true);
	}

	if (sType === "I") {

		this.folders._opt.privateOnly = false;

		this.add_container && this.add_container.btn_add._value('CHAT::CREATE_ROOM');

		gui.frm_main.main && gui.frm_main.main.text && gui.frm_main.main.text._private();

		//Remove system menu
		if (this._system) {
			await this._system._destruct();
			this._system = false;
		}

		this.search._placeholder(getLang('CHAT::FILTER_ROOMS'));

		if (this.switch) {
			await this.switch._destruct();
			delete this.switch;
		}
		if (this._public) {
			await this._public._destruct();
			this._public = false;
		}
		if (this._shared) {
			await this._shared._destruct();
			this._shared = false;
		}

		//Add recent rooms
		if (!this._recent) {
			this._recent = await slide2._create('recent', 'obj_tree_list', '', 'obj_tree recent');
		}

		//Add unsubscribed rooms
		if (!this._archive) {
			this._archive = await slide3._create('unsubscribed', 'obj_tree_folder2_archive', '', '', void 0, void 0, void 0, void 0, {listenCookie: 'archivedTree'});
		}

		//Add recent switch
		if (!this.switch2) {
			await this._create('switch2', 'obj_button_recent', 'top', 'switch obj_button_tree');
		}

		//Select last pane
		var active_groupchat_view = +dataSet.get('cookies', ['active_groupchat_view']) || 1;
		if (active_groupchat_view === 2 && !~(dataSet.get('cookies', ['recent']) || []).indexOf(dataSet.get('cookies', ['last', 'I'])))
			active_groupchat_view = 1;

		this.switch2._value(active_groupchat_view, false, {
			bNoAnimation: true
		});

	} else {
		
		this.folders._opt.privateOnly = true;

		this.add_container.btn_add._value('MAIN_MENU::CREATE_FOLDER');
		this.add_container.btn_add._disabled(false);

		this.search._placeholder(getLang('POPUP_FOLDERS::FILTER_FOLDERS'));

		if (!this._system) {
			this._system = await slide1._create('system', 'obj_system', 'system');
		}
		this._system._fill(sActiveFolder)

		if (this.switch2) {
			await this.switch2._destruct();
			delete this.switch2;
		}
		if (this._recent) {
			await this._recent._destruct();
			this._recent = false;
		}
		if (this._archive) {
			await this._archive._destruct();
			this._archive = false;
		}

		if (!this._shared) {
			this._shared = await slide2._create('shared','obj_tree_folder2_context', '', '', void 0, void 0, void 0, void 0, {sharedOnly: true, listenCookie: 'shared_tree', privateRootActive: false, rootFolderDroppable: true});
		}

		if (!this._public) {
			this._public = await slide3._create('public','obj_tree_folder2_context', '', '', void 0, void 0, void 0, void 0, {publicOnly: true, listenCookie: 'public_tree', privateRootActive: false, rootFolderDroppable: true});
		}

		if (!this.switch) {
			await this._create('switch', 'obj_button_tree', 'top', 'switch');
		}
	}

	this.search._onsubmit();

	if (this.__lastType !== sType && sType !== 'G') {
		var aTypes = [];
		for (var i in this.folders._sFilterFolderType) {
			if (this.folders._sFilterFolderType[i]) {
				aTypes.push(i);
			}
		}
		this.folders._filter_folder(aTypes);
		if (this._public) {
			this._public._filter_folder(aTypes);
			await this._public._fill();
		}
		if (this._shared) {
			this._shared._filter_folder(aTypes);
			await this._shared._fill();
		}

		await this.folders._fill();
		this.__lastType = sType;
	}

	if (aPath.aid && aPath.fid == '~') {
		await this.folders._setActive(aPath.aid, true);
	} else {
		for (var tree of [this.folders, this._public, this._shared].filter(Boolean)) {
			await tree._setActive(sActiveFolder, true);
		};
	}

	this.__updateSwitch();
};

_me._setFolderName = function(sActiveFolder) {
	var aPath = Path.split(sActiveFolder, true);
	var pathName = WMFolders.getFolderPath(aPath);
	var folderName;
	if (~aPath.fid.indexOf('__@@VIRTUAL@@__/@@SUBTREE@@/')) {
		folderName = pathName;
		this.__options.toggleButton._title('');
	} else if (aPath.fid === '__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__') {
		folderName = getLang('FOLDER_TYPES::GROUPCHAT');
		this.__options.toggleButton._title('');
	} else if (~aPath.fid.indexOf('__@@VIRTUAL@@__/@@PUBLIC@@/')) {
		folderName = getLang('COMMON_FOLDERS::ALL_FOLDERS', [aPath.fid.replace('__@@VIRTUAL@@__/@@PUBLIC@@/', '').replace(/\/#\w$/, '')]);
		this.__options.toggleButton._title('');
	} else if (~aPath.fid.indexOf('__@@VIRTUAL@@__/@@PERSONAL@@/#')) {
		folderName = getLang('COMMON_FOLDERS::ALL_PERSONAL');
		this.__options.toggleButton._title('');
	} else if (~aPath.fid === '__@@ARCHIVE@@__') {
		folderName = getLang('COMMON_FOLDERS::ALL_ARCHIVES');
		this.__options.toggleButton._title('');
	} else if (~aPath.fid.indexOf('__@@VIRTUAL@@__/@@SHARED@@/~')) {
		var uid = aPath.fid.replace('__@@VIRTUAL@@__/@@SHARED@@/~', '').replace(/\/#\w$/, '');
		folderName = getLang('COMMON_FOLDERS::ALL_FOLDERS', [dataSet.get('accounts', [uid, 'USERNAME']) || uid]);
		this.__options.toggleButton._title('');
	} else {
		folderName = WMFolders.getType(aPath) === 'I' ? WMFolders.getFolderName(aPath) : pathName;
	}
	this.__options.toggleButton._text(folderName);
	this.__options.toggleButton._main.className = this.__options.toggleButton._main.className.replace(/folderType_\w+/, '');
	addcss(this.__options.toggleButton._main, this.__folderIcon(sActiveFolder));
};

_me.__handlerTimeout = {};
_me.__update = function(sName) {
	clearTimeout(this.__handlerTimeout[sName]);
	if (sName === 'folders') {
		this.__handlerTimeout[sName] = setTimeout(function() {
			this.__options.toggleButton._main.classList.remove('unread');
			var f = dataSet.get('folders', [sPrimaryAccount]);
			for (var n in f) {
				if (f[n].TYPE == 'I' && f[n].SYNC && parseInt(f[n].RECENT)) {
					this.__options.toggleButton._main.classList.add('unread');
					break;
				}
			}
		}.bind(this), 5);
	}
};

_me.__updateSwitch = function() {
	if (this.switch) {
		var sActiveFolder = this.__sActiveFolder.replace(/__@@VIRTUAL@@__\/@@SUBTREE@@\//, '');
		var view = 1;
		if (this.folders.__idTableReal[sActiveFolder]) {
			view = 1;
		} else if (this._shared && (this._shared.__idTableReal[sActiveFolder] || ~sActiveFolder.indexOf('__@@VIRTUAL@@__/@@SHARED@@/'))) {
			view = 2;
		} else if (this._public && (this._public.__idTableReal[sActiveFolder] || ~sActiveFolder.indexOf('__@@VIRTUAL@@__/@@PUBLIC@@/'))) {
			view = 3;
		}
		// var active_tree_view = +dataSet.get('cookies', ['active_tree_view', this.__lastType]) || 1;
		var folderTypeChanged = this.switch._folderType !== this.__lastType;
		this.switch._folderType = this.__lastType;
		this.switch._value(view, false, {
			bNoAnimation: folderTypeChanged
		});

		this.switch.__options.shared = Object.keys(this._shared.__idtable).length > 1;
		this.switch.__options.public = Object.keys(this._public.__idtable).length > 1;
		this.switch._update();
	}
	if (this.switch2) {
		this.switch2._update();
	}
};

_me.__folderIcon = function(sFolder) {
	var aPath = Path.split(sFolder, true),
		sType = WMFolders.getType(aPath),
		aFolder = dataSet.get('folders', [aPath.aid, aPath.fid]),
		ico = sType;

	if (aPath.fid.match(/__@@VIRTUAL@@__\/.*#\w$/)) {
		ico = aPath.fid.slice(-1);
	} else if (aPath.fid === '__@@ARCHIVE@@__') {
		ico = 'archive';
	} else if (aPath.fid === '__@@SNOOZED@@__') {
		ico = 'snoozed';
	} else if (aPath.fid === '__@@VIRTUAL@@__/__@@EVENTS@@__') {
		ico = 'E'
	} else if (~aPath.fid.indexOf('__@@VIRTUAL@@__')) {
		ico = 'virtual';
	} else if (sFolder === GWOthers.getItem('DEFAULT_FOLDERS', 'smartattach')) {
		ico = 'upload';
	} else if (sFolder === GWOthers.getItem('DEFAULT_FOLDERS', 'dashboard')) {
		ico = 'dashboard';
	} else {
		switch (sType){
			case 'M':
				if (aPath.fid === 'INBOX' && aPath.aid === sPrimaryAccount){
					ico = 'inbox';
				} else if (aFolder.SPAM){
					ico = 'spam';
				} else if (aFolder.ARCHIVE){
					ico = 'archive';
				} else if (aFolder.DEFAULT){
					ico = ({H:'trash',S:'sent',D:'drafts'})[aFolder.DEFAULT] || 'm';
				}
				break;
			case 'Q':
				ico = 'quarantine';
				break;
			case 'QL':
				ico = aPath.fid === 'SPAM_QUEUE/Blacklist'?'black':'white';
				break;
			default:
				if (aPath.fid == 'SPAM_QUEUE') {
					ico = 'spamqueue';
				}
		}
	}
	return 'folderType_' + ico;
}