_me = obj_avatar.prototype;
function obj_avatar(){};
obj_avatar.__serviceCache = {};
obj_avatar.__localCache = {};

_me.__constructor = async function(v){

	this._imonly = false; //show only IM contextmenu
	this.__value = {};

	this._listen('xmpp');

	if (v)
		this._value(v);
};

_me._menu = async function(){
	if (this.__value.email || this.__value.distributionList){
		var name = this.__value.name;
		var email = this.__value.email;
		if(!this.__value.name && !~this.__value.email.indexOf('@')) {
			name = this.__value.email;
			email = '';
		}

		var pos = getSize(this.__elm),
			cmenu = await gui._create('cmenu','obj_context_link','','',name,email,'',{nomail:this._imonly, noadd:true, distibutionList: this.__value.distributionList}, false, this._specificIds);
			cmenu._place(pos.x+(pos.w/2),pos.y+pos.h,'',2);
	}
};

_me.__specifyIds = function(v){
	this._specificIds = v;
};

_me._value = function(v){
	if (this.__elm) {
		this.__elm.parentElement.removeChild(this.__elm);
	}

	var contactId = false;
	if(Array.isArray(v)) {
		contactId = v.pop();
		v = v[0];
	}
	if (Is.Defined(v)){
		this.__value = MailAddress.splitEmailsAndNames(v)[0] || {};
		var stat;

		if (contactId) {
			this.__elm = obj_avatar.getAvatarElement({
				contactId: contactId,
				name: this.__value.name || this.__value.email,
				size: this.__size || 48
			});
			this.__className = this.__elm.className;
			this._main.appendChild(this.__elm);
		
			this.__elm.onclick = function (e){
				e.preventDefault();
				e.stopPropagation();

				this._menu();
			}.bind(this);

			if (gui.frm_main && gui.frm_main.im && gui.frm_main.im._is_active()){
				stat = gui.frm_main.im._inRoster(this.__value.email) || '';
				if (stat)
					this.__elm.className = this.__className +' status im_' + stat.escapeXML(true);
			}
			return;
		}

		if(v.indexOf('@') === -1) {
			this.__value.email = v;
			this.__value.distributionList = true;
			this.__value.name = v;
		}

		if (this.__value.email){
			this.__elm = obj_avatar.getAvatarElement({
				email: this.__value.email,
				name: this.__value.name || this.__value.email,
				size: this.__size || 48
			});
			this.__className = this.__elm.className;
			this._main.appendChild(this.__elm);
		
			this.__elm.onclick = function (e){
				e.preventDefault();
				e.stopPropagation();

				this._menu();
			}.bind(this);

			//IM
			if (gui.frm_main && gui.frm_main.im && gui.frm_main.im._is_active()){
				stat = gui.frm_main.im._inRoster(this.__value.email) || '';
				if (stat)
					this.__elm.className = this.__className + ' status im_' + stat.escapeXML(true);
			}
		} else if (this.__elm) {
			this.__elm.querySelector('.component-avatar--image').style.backgroundImage = '';
			this.__elm.className = this.__className;
		}
	}
};

_me.__update = function(sName,aPath){
	//header links update
	if (sName == 'xmpp' && this.__value.email && gui.frm_main.im){

		// one user
		if (aPath && aPath[0] == 'roster' && aPath[1] && aPath[1] == this.__value.email && aPath[2] == 'show')
			this.__elm.className = this.__className + ' status im_' + gui.frm_main.im._inRoster(this.__value.email).escapeXML(true);
		// IM goes offline
		else
		if (!gui.frm_main.im._is_active())
			this.__elm.className = this.__className;
	}
};

obj_avatar.ownAvatarURL = false;
obj_avatar.getOwnPublicAvatarURL = async function() {
	return obj_avatar.ownAvatarURL = obj_avatar.ownAvatarURL || await new Promise(function(resolve) {
		TeamChatAPI.users.identity({
			success: function(identity) {
				resolve((identity.profile || {}).image_512);
			},
			error: function() {
				resolve('');
			}
		});
	});
};

obj_avatar.sAvatarNo = Date.now();

obj_avatar.getAvatarURL = function(email, contactId, error_when_empty) {
	var url = {
		token: sPrimaryAccountTeamchatToken,
		skin: GWOthers.getItem('LAYOUT_SETTINGS', 'skin') || 'default'
	};
	if (email) {
		if (email === sPrimaryAccount) {
			url.no = obj_avatar.sAvatarNo;
		}
		url.email = email;
	} else if (contactId) {
		url.contactid = contactId;
	} else {
		return '';
	}

	url.error_when_empty = error_when_empty === void 0 ? true : error_when_empty;

	return sPrimaryAccountGW ? location.origin + '/teamchatapi/files.avatar?' + buildURL(url) : '';
};

obj_avatar.getAvatarHTML = function(aData) {
	return obj_avatar.getAvatarElement(aData).outerHTML;
};

obj_avatar.getAvatarElement = function(aData) {
	var email = aData.email || '';
	var name = aData.name || email || '';
	name = ~name.indexOf('@') ? {} : parseNameToLocation(name);
	var parts = [name.ITMFIRSTNAME, name.ITMSURNAME].filter(Boolean);
	var initials = (parts.length ? parts : (aData.name || aData.email || '').split(' ')).map(function(s) {
		return !~s.indexOf('(') && ([...s][0] || '').toUpperCase();
	}).filter(Boolean);
	initials = [initials.splice(0, 1), initials.pop()].join('');
	var contactId = aData.contactId ? WMItems.__serverID(aData.contactId) : void 0;

	var domain = '';
	var avatar;
	if ((email || contactId) && !aData.bNoAvatar) {
		var local = true;
		if (~email.indexOf('@')) {
			domain = email.split('@').pop().split('.').splice(-2).join('.').replace(/##/g, '');
			local = dataSet.get('main', ['domain']) === domain;

			if (!local) {
				var aliases = dataSet.get('storage', ['ALIASES', 'ITEMS']);

				for(var i in aliases) {
					if (aliases[i].VALUES.EMAIL.VALUE.toLowerCase().split('@').pop() === domain) {
						local = true;
						break;
					}
				}
			}
		}

		if (obj_avatar.__localCache[email || contactId]) {
			avatar = obj_avatar.getAvatarURL(email, contactId);
		} else if (email && obj_avatar.__serviceCache[email]) {
			avatar = obj_avatar.__serviceCache[email];
		} else if ((email || contactId) && (obj_avatar.__localCache[email || contactId] === void 0)) {
			obj_avatar.__localCache[email || contactId] = false;

			mkElement('img', {
				onload: function() {
					obj_avatar.__localCache[email || contactId] = obj_avatar.getAvatarURL(email, contactId);
					[].forEach.call(document.querySelectorAll('.component-avatar--image[' + (email ? 'data-email="' + email + '"' : 'data-contactId="' + contactId + '"') + ']'), function(elm) {
						elm.setAttribute('style', 'background-image: url("' + obj_avatar.getAvatarURL(email, contactId, !!initials) + '")');
					});
				},
				onerror: function() {
					if (local || !dataSet.get('dashboard', ['middleware']) || (obj_avatar.__serviceCache[email] !== void 0)) {
						return;
					}
					obj_avatar.__serviceCache[email] = false;

					fetch(dataSet.get('dashboard', ['middleware']) + '/avatar/' + email, {
						method: 'GET',
						cache: 'no-cache',
						redirect: 'follow',
						headers: {
							accept: 'application/json',
							Authorization: 'Bearer ' + icewarpapi.token.access
						}
					}).then(async function(response) {
						if (!response.ok || (response.status === 404)) {
							return;
						}
			
						try {
							var data = await response.json();
	
							if (!data.link) {
								return;
							}

							mkElement('img', {
								onload: function() {
									obj_avatar.__serviceCache[email] = data.link;
									[].forEach.call(document.querySelectorAll('.component-avatar--image[data-email="' + email + '"]'), function(elm) {
										elm.classList.add('component-avatar--with_background');
										elm.style.backgroundImage = 'url("' + data.link + '")';
									});
								},
								onerror: function() {
									obj_avatar.__serviceCache[email] = false;
								},
								src: data.link
							});
						} catch {
							//
						}
					});
				},
				src: obj_avatar.getAvatarURL(email, contactId)
			});
		}
	}

	var style = avatar ? {
		backgroundImage: 'url(' + avatar + ')'
	} : void 0;
	return mkElement('div', {
		className: 'component-avatar' + (aData.size ? ' component-avatar--' + aData.size : '') + (aData.className ? ' ' + aData.className : '')
	}, false, [
		initials && mkElement('div', {
			className: 'component-avatar--initials' + (initials.length === 1 ? ' single' : ''),
			textContent: initials
		}),
		mkElement('div', {
			'data-email': email || void 0,
			'data-contactId': contactId,
			className: 'component-avatar--image' + (email && obj_avatar.__serviceCache[email] ? ' component-avatar--with_background' : ''),
			style: style
		})
	]);
};