function obj_attachment() {}

obj_attachment.prototype.__constructor = async function(file, options) {
	await storage.library('wm_upload');
	this.__xhrerror = false;
	this.__file = file;

	var filetype = (this.__file.type || '').split('/')[0] || 'file';
	this.__options = Object.assign({
		name: sanitizeFilename((file.name || ' ')).entityify(),
		size: (file.size || file.EVNCOMPLETE) ? parseFileSize(file.size || file.EVNCOMPLETE) : '',
		filetype: filetype,
		meta: (file.meta || '').entityify(),
		readonly: false,
		toolbar: false,
		shared: this.__file.EVNURL
	}, options || {});

	this.__options.filetype = Item.getFileType(this.__options.name) || this.__options.filetype;
	if ((this.__options.name.split('.').pop() === 'tiff')) {
		this.__options.filetype = 'image';
		this.__file.type = 'image/tiff';
	}

	if (this.__options.filetype === 'image' && !~['image/tiff'].indexOf(this.__file.type)) {
		var preview = file.ticket || '';
		if (!preview) {
			if (file.class === 'attachment' && file.fullpath) {
				preview = sPrimaryAccountClient + 'server/download.php?' + buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': 'attachment', 'fullpath': file.fullpath});
			} else if (file.folder && file.id) {
				preview = await Item.webdavURL([sPrimaryAccount, file.folder, file.id]);
			} else if (file.class === 'link') {
				preview = file.fullpath;
			} else if (~['I', 'K', 'F'].indexOf(WMFolders.getType(file))) {
				preview = await Item.webdavURL(file, file.name);
			} else {
				preview = file.fid && file.iid && await Item.webdavURL(file);
			}
		}
		this.__options.url = (Is.InstanceOf(file, 'File') ? URL.createObjectURL(file) : preview);
		this.__options.preview = file.preview || this.__options.url;
		// var img = new Image();
		// img.onload = function() {
		// 	file.width = img.width;
		// 	file.height = img.height;
		// };
		// img.src = this.__options.url;
	} else {
		this.__options.url = this.__options.url || (Is.InstanceOf(file, 'File') ? URL.createObjectURL(file) : void 0);
	}

	this.__options.progress = ((Is.InstanceOf(file, 'File') && (!file.xhr || file.xhr.readyState !== 4)) || (Is.InstanceOf(file, 'FakeFile') && !file.fullpath)) && this.__options.progress;

	await this._fill();

	if (Is.InstanceOf(file, 'File') && file.readyState === 4 && file.status === 0) {
		this.__onuploaderror({file: file});
	}

	gui._obeyEvent('onuploadaborted', [this, '__onuploadaborted']);
	gui._obeyEvent('onuploadsuccess', [this, '__onuploadsuccess']);
	gui._obeyEvent('onuploadprogress', [this, '__onuploadprogress']);
	gui._obeyEvent('onuploaderror', [this, '__onuploaderror']);
	gui._obeyEvent('onuploadcommit', [this, '__onuploadcommit']);

	this._add_destructor('__disobeyEvents');
};

obj_attachment.prototype._fill = async function() {
	var me = this;

	this.controls && await this.controls._destruct();

	this._main.innerHTML = '';
	await this._draw('obj_attachment', '', this.__options);
	this._main.classList.add(this.__options.filetype);
	if (this.__options.type) {
		this._main.classList.add(this.__options.type);
	}
	if (this.__options.progress) {
		this._main.classList.add('has-progress');
	}


	this._getAnchor('preview').onclick = async function(e) {
		e.stopPropagation();

		if (me.__file.onclick && me.__file.onclick(me) !== false) {
			return;
		}

		if (me.__options.filetype === 'image') {
			var images = me._parent._getChildObjects('', 'obj_attachment').filter(function(att) {
				return att.__options.filetype === 'image';
			}).map(function(att) {
				return {
					title: att.__options.name,
					url: att.__options.url,
					thumbnailUrl: att.__options.preview
				}
			});
			var index = 0;
			for (var i in images) {
				if (images[i].url === me.__options.url) {
					index = i;
					break;
				}
			}
			var img = await gui._create('imgview', 'frm_imgview');
			await img._fill(images);
			img._value(index);
		} else if (me.__options.url) {
			Item.previewURL(me.__options.url, me.__file.name);
		} else {
			if (me.__file.fullpath) {
				var path = Path.split(Path.basedir(me.__file.fullpath), true);

				if ((me.__file.class === 'item' && WMFolders.getType([path.aid, path.fid]) === 'F') || (me.__file.class === 'attachment')) {
					return Item.previewItem([
						path.aid,
						path.fid,
						WMItems.__clientID(Path.basename(me.__file.fullpath))
					], me.__file.name);
				}
			}

			if (me.__file.EVNFOLDER) {
				Item.previewItem([
					me.__file.aid,
					me.__file.EVNFOLDER,
					me.__file.EVN_ID || me.__file.id || me.__file.iid
				], me.__file.name, true);
			}
		}
	};

	if (this._getAnchor('abort')) {
		this._getAnchor('abort').onclick = function() {
			this.__abort();
		}.bind(this);
	}

	var time = this._getAnchor('time');
	if (this.__file.datetime && time) {
		time.setAttribute('datetime', +this.__file.datetime);
		this._updateTime();
		this._main.removeChild(this._getAnchor('abort'));
	}

	if (this._getAnchor('detail')) {
		this._getAnchor('detail').onclick = function(e) {
			e.stopPropagation();
			if (me.__file.EVNURL) {
				gui.frm_main.rslide.upload_detail._init({fid: me.__file.EVNFOLDER, iid: me.__file.EVN_ID});
				gui.frm_main.rslide._value('upload_detail');
			}
		};
	}

	if (this.__options.toolbar) {
		this._main.onmouseover = function(){

			if (this.__timeout){
				clearTimeout(this.__timeout);
				delete this.__timeout;
			}

			if (!this.__timein)
				this.__timein = setTimeout(function(){

					if (!me._destructed){
						if (me._init_controls(true))
							addcss(me._main.parentElement, 'active');
					}

				}, 50);
		};

		this._main.onmouseout = function(e){

			if (!Is.Child(e.relatedTarget, this)){

				if (this.__timein){
					clearTimeout(this.__timein);
					delete this.__timein;
				}

				if (!this.__timeout)
					this.__timeout = setTimeout(function(){
						if (!me._destructed){
							if (me._init_controls(false))
								removecss(me._main.parentElement, 'active');
						}
					}, 25);
			}
		};
	} else if (this.__options.filetype === 'image') {
		gui.tooltip._add(this._main, this.__options.name + ' - ' + this.__options.size);
	}
};

obj_attachment.prototype.__abort = function(e) {
	e && e.stopPropagation();

	if (this.__xhrerror) {
		this.__xhrerror = false;
		if (this._getAnchor('abort')) {
			this._getAnchor('abort').classList.remove('retry');
		}
		this.__file.retry();
		return;
	}

	if (this.__file.xhr && this.__file.xhr.readyState !== 4) {
		this.__file.xhr.abort();
	}
	this.__file._abort();
}

obj_attachment.prototype._init_controls = async function(bShow) {
	if (bShow){
		if (!this.controls) {
			var me = this;
			await this._create('controls', 'obj_tch_control', '', '', [
				!this.__file.aid && {
					id: 'abort',
					tooltip: getLang('UPLOAD::ABORT'),
					callback: [function() {
						me.__abort();
					}]
				},
				this.__file.fullpath && {
					id: 'download',
					tooltip: getLang('UPLOAD_DETAIL::DOWNLOAD'),
					callback: [function() {
						downloadItem(buildURL({
							dlsess: dataSet.get('main', ['dlsess']),
							class: 'attachment',
							fullpath: me.__file.fullpath || (me.__file.EVNFOLDER + '/' + me.__file.EVN_ID + '/' + me.__file.EVNLOCATION)
						}));
					}]
				},
				me.__file.EVNFOLDER && WMFolders.getType([sPrimaryAccount, me.__file.EVNFOLDER]) === 'F' && {
					id: 'folder',
					tooltip: getLang('UPLOAD_DETAIL::OPEN_CONTAINING_FOLDER'),
					callback: [function() {
						if (gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('files')) {
							gui.frm_main.dashboard._navigate({
								to: 'files',
								options: {
									aid: sPrimaryAccount,
									fid: Path.slash(me.__file.EVNFOLDER)
								}
							});
							setTimeout(function() {
								gui.frm_main._selectView({aid: sPrimaryAccount, fid: Path.slash(me.__file.EVNFOLDER)}, 'dashboard_view', {view: 'dashboard_view'});
							}, 50);
							Cookie.set(['filter_tree'], 'F');
						} else {
							dataSet.add('active_items', [sPrimaryAccount, Path.slash(me.__file.EVNFOLDER)], WMItems.__clientID(me.__file.EVN_ID));
							gui.frm_main.filter.__filter('F', false, true);
							gui.frm_main._selectView({
								aid: sPrimaryAccount,
								fid: Path.slash(me.__file.EVNFOLDER)
							});
						}
					}]
				},
				this.__file.EVNURL && (GWOthers.getItem('RESTRICTIONS', 'disable_shareable_link') != 1) && {
					id: 'smart_link',
					tooltip: getLang('UPLOAD_DETAIL::COPY_LINK'),
					callback: [function() {
						toClipboard({
							'text/plain': me.__file.EVNURL
						});
					}]
				},
				this.__file.EVNURL && {
					id: 'smart_tc',
					tooltip: getLang('UPLOAD_DETAIL::SEND_TO_TC'),
					callback: [function() {
						Item.copy_tch([sPrimaryAccount, Path.slash(me.__file.EVNFOLDER), [me.__file.EVN_ID]]);
					}]
				},
				this.__file.EVNURL && {
					id: 'smart_mail',
					tooltip: getLang('UPLOAD_DETAIL::SEND_AS_EMAIL_ATTACHMENT'),
					callback: [function() {
						Item.sendAsEmail([sPrimaryAccount, Path.slash(me.__file.EVNFOLDER), [WMItems.__clientID(me.__file.EVN_ID)]])._settings('smart_attach', '1');
					}]
				},
				this.__file.EVNURL && {
					id: 'smart_settings',
					tooltip: getLang('UPLOAD_DETAIL::SETTINGS'),
					callback: [function() {
						Item.collaborate([sPrimaryAccount, Path.slash(me.__file.EVNFOLDER), me.__file.EVN_ID]);
					}]
				},
				this.__file.aid && !this.__file.EVNURL && !this.__options.sharing && {
					id: 'smart_share',
					tooltip: getLang('UPLOAD_DETAIL::SHARE'),
					callback: [async function() {
						me.__options.sharing = true;
						await me.controls._destruct();
						me._init_controls(true);

						var password = '';
						if (GWOthers.getItem('RESTRICTIONS', 'force_sharing_password')) {
							await storage.library('wordGen', 'wordGen');
							password = (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10);
						}

						TeamChatAPI.filesInvite({ id: WMItems.__serverID(me.__file.EVN_ID), editable: false, password: password }, {
							success: async function (response) {
								me.__file.EVNURL = response.inviteticket;
								me.__options.sharing = false;
								me.__options.shared = true;
								var had_controls = me.controls;
								await me._fill();
								if (had_controls) {
									me._init_controls(true);
								}
							}
						});
					}]
				},
				this.__options.sharing && {
					loading: true
				}
			]);
		}

		if (this.controls) {
			this.controls._onhide = function(){
				removecss(this._main.parentElement, 'active');
			};

			this.controls._show();
		}

	} else if (this.controls) {
		this.controls._hide();
		this.controls._destruct();
		delete this.controls;
	}
};

obj_attachment.prototype._updateTime = function() {
	var time = this._getAnchor('time');
	if (time) {
		var datetime = time.getAttribute('datetime');
		if (datetime) {
			var unix = +datetime + new IcewarpDate().utcOffset() * 60000;
			time.textContent = parseFileSize(this.__file.size || this.__file.EVNCOMPLETE) + ' | ' + (!this.__file.xhr && !this.__file.aid ? getLang('ATTACHMENT::QUEUED') : this.__getTime(unix));
		}
	}
};

obj_attachment.prototype.__onuploadprogress = function(data) {
	if (data.file === this.__file) {
		if (this.__options.progress) {
			this.__options.startTime = this.__options.startTime || +new Date();
			var percent = Math.ceil(100 / data.size * data.completed);
			if (this.__options.progress.pie) {
				this._getAnchor('progress').style.setProperty('--p', percent);
			} else if (this.__options.progress.bar) {
				var bar = this._getAnchor('progress-bar');
				bar.style.width = percent + '%';

				if (this.__options.time) {
					var time = this._getAnchor('time');
					var etaEl = this._getAnchor('eta');
					if (data.completed >= data.size) {
						time.textContent = getLang('COMMON::PROCESSING');
						this._main.classList.remove('has-progress');
						etaEl.textContent = '';
					} else {
						var percent = Math.min(Math.ceil(100 / data.size * data.completed), 100);
						time.textContent = getLang('ATTACHMENT::PROGRESS', [parseFileSize(data.completed), parseFileSize(data.size), percent + '%']);
						var eta = Math.floor((+new Date() - this.__options.startTime) / percent / 1000 * (100 - percent));
						if (eta < 60) {
							eta = getLang('conference::seconds', [eta]);
						} else if (eta < 3600) {
							eta = getLang('conference::minutes', [Math.floor(eta / 60)]);
						} else {
							eta = getLang('conference::hours', [Math.floor(eta / 3600)]);
						}
						etaEl.textContent = getLang('upload::time_left', [eta]);
					}
				}
			}
		}
	}
};

obj_attachment.prototype.__onuploaderror = function(data) {
	if (data.file === this.__file) {
		this._main.classList.remove('has-progress');
		this.__xhrerror = true;
		this._getAnchor('abort') && this._getAnchor('abort').classList.add('retry');
	}
};

obj_attachment.prototype.__onuploadsuccess = function(data) {
	if (data.file === this.__file) {
		this._main.classList.remove('has-progress');

		if (this.__options.time) {
			var time = this._getAnchor('time');
			time.setAttribute('datetime', +new Date());
			this._updateTime();
		}
	}
};

obj_attachment.prototype.__onuploadaborted = function(data) {
	if (data.file === this.__file) {
		this._destruct();
	}
};

obj_attachment.prototype.__onuploadcommit = function(aData) {
	if (aData.id && this.__file.id === aData.id) {
		this.__options.shareable = true;
		this.__file.id = this.__file.EVN_ID = aData.server_id || aData.data.id;
		this.__file.folder = this.__file.EVNFOLDER = aData.folder || this.__file.EVNFOLDER || aData.data.folder || '__@@UPLOAD@@__';
		this.__options.meta = WMFolders.getFolderName({
			aid: sPrimaryAccount,
			fid: this.__file.folder
		});
		this._fill();
	}
};

obj_attachment.prototype.__disobeyEvents = function() {
	gui._disobeyEvent('onuploadprogress', [this, '__onuploadprogress']);
	gui._disobeyEvent('onuploadsuccess', [this, '__onuploadsuccess']);
	gui._disobeyEvent('onuploadaborted', [this, '__onuploadaborted']);
	gui._disobeyEvent('onuploaderror', [this, '__onuploaderror']);
	gui._disobeyEvent('onuploadcommit', [this, '__onuploadcommit']);
};

obj_attachment.prototype.__getTime = function (date) {
	var diff = Math.floor((new Date() - date) / 1000);
	if (diff < 10) {
		return getLang('NOTIFICATION::NOW');
	} else if (diff < 60) {
		return getLang(diff === 1 ? 'NOTIFICATION::SECOND_AGO' : 'NOTIFICATION::SECONDS_AGO', [diff]);
	} else if (diff < 60 * 60) {
		var minutes = Math.floor(diff / 60);
		return getLang(minutes === 1 ? 'NOTIFICATION::MINUTE_AGO' : 'NOTIFICATION::MINUTES_AGO', [minutes]);
	} else if (diff < 60 * 60 * 12) {
		var hours = Math.floor(diff / 60 / 60);
		return getLang(hours === 1 ? 'NOTIFICATION::HOUR_AGO' : 'NOTIFICATION::HOURS_AGO', [hours]);
	} else {
		return CalendarFormatting.normalWithTime(new IcewarpDate(date));
	}
};