_me = obj_attach_mailview.prototype;
function obj_attach_mailview(){};

_me.__constructor = async function(){
	await storage.library('short_url');
	this.__idtable = [];
	var me = this;

	this._main.onmousedown = function(e){
		if (me.__dndtimer){
			window.clearTimeout(me.__dndtimer);
			delete me.__dndtimer;
		} else {
			if (e.button > 1) {
				return true;
			}

			var elm = e.target;

			if ((elm.tagName == 'DIV' || (elm = elm.closest('div'))) && elm.id && me.__idtable[elm.id] && !me.__idtable[elm.id].shortURL && (me.__idtable[elm.id].type !== 'all') && !e.target.classList.contains('menu')) {
				me.__dndtimer = window.setTimeout(function() {
					gui.__dragging = true;
					gui._obeyEvent('mouseup', [me, '_ondragend']);
					!me._destructed && me.__initdrag(elm.id, e.clientX, e.clientY);
				}, 250);
			}
		}
	};
};

_me._value = function(v){
	if (v && Is.Array(v['attachments'])){
		var i;
		//All Attachments
		if (v['attachments'].length > 1) {
			var bAll = false;
			var bSmart = false;

			for (i in v.attachments) {
				if ((v.attachments[i].url || '').indexOf('http') === 0) {
					bSmart = true;
					break;
				};
			}

			if (!bSmart) {
				for (i in v['attachments']){
					if (v['attachments'][i].allurl){
						bAll = true;
						this._add({name: getLang('ATTACHMENT::ALL'), type: 'allsa', url: v['attachments'][i].allurl, css: 'archive', smart: bSmart});
						break;
					}
				}
			}

			if (!bAll) {
				for (i in v['attachments']) {
					this._add({name: getLang('ATTACHMENT::ALL'),type: 'all', css: 'archive', smart: bSmart});
					break;
				}
			}
		}

		//Attachments
		for (i in v['attachments'])
			this._add(v['attachments'][i]);
	}
};

_me._add = function(aArg) {
	this.__idtable.push(aArg);
	this._addGuiElement(aArg, this.__idtable.length-1);
};

_me._addGuiElement = async function(aArg, id) {
	if (!Is.String(aArg.name)) return;
	aArg.shortURL = ShortURL.matches(aArg.url || '');

	var tracking = (aArg.shortURL && ((aArg.fullpath || '').indexOf(sPrimaryAccount) === 0));
	var expired = mkElement('span', {
		className: 'expired',
		textContent: '(' + getLang('ATTACHMENT::EXPIRED') + ')'
	});
	var menu = mkElement('span', {
		className: 'menu',
	});

	var span;
	var att = mkElement('div', {
		className: (aArg.css || '') + ' ' + Item.getFileType(aArg.name),
		id: id
	}, false, [
		span = mkElement('span', {
			className: 'name',
			textContent: aArg.name
		}),
		aArg.size && mkElement('span', {
			className: 'size',
			textContent: '(' + parseFileSize(aArg.size) + ')'
		}),
		expired,
		tracking && mkElement('span', {
			className: 'tracking',
			onclick: function(e) {
				e.stopPropagation();
				if (aArg.fullpath) {
					var path = Path.split(aArg.fullpath, true, true);
					if (path.aid === sPrimaryAccount) {
						gui.frm_main.rslide.upload_detail._init({fid: path.fid, iid: path.iid});
						gui.frm_main.rslide._value('upload_detail');
					}
				}
			}
		}),
		aArg.type !== 'all' && !tracking && mkElement('span', {
			className: 'ico' + (aArg.shortURL ? ' smart' : '')
		}),
		!aArg.docref && menu
	]);

	gui.tooltip._add(span, aArg.name, {
		y: function() {
			return getSize(span).y - 28
		}
	});

	menu.onclick = att.onclick = att.oncontextmenu = this.__onclick.bind(this, id);
	aArg.att = att;

	this._main.appendChild(att);

	if (tracking) {
		await storage.library('short_url');

		aArg.processing = true;
		att.classList.add('processing');
		ShortURL.resolve({
			url: aArg.url,
			callback :function(oURL, sError) {
				aArg.processing = false;
				att.classList.remove('processing');
				if (oURL) {
					aArg.expiration = oURL.expiration;
					if (+oURL.expiration && oURL.expiration < Math.floor(+new Date() / 1000)) {
						aArg.expired = true;
						att.classList.add('expired');
					}
				} else {
					switch(sError) {
						case 'E_DOCUMENT_INVITE_PASSWORD':
							aArg.locked = true;
							att.classList.add('locked');
						break;
						default:
							aArg.unavailable = true;
							att.classList.add('expired');
							expired.textContent = '(' + getLang('ATTACHMENT::UNAVAILABLE') + ')'
					}
				}
				},
				filename: aArg.name,
				doNotTrack: true,
				skipPasswordPrompt: true
			}
		);
	}

	if (this._onchange)
		this._onchange();
};

_me.__onclick = function(id, e) {
	e.preventDefault();
	e.stopPropagation();
	e.stopImmediatePropagation();

	if (!gui.__dragging && e.detail === 1) {
		if (this.__clickTimeout) {
			return;
		}
		this.__clickTimeout = setTimeout(function() {
			delete this.__clickTimeout;
		}.bind(this), 250);
		var elm = e.target;
		this._onclick(e, elm, id, this.__idtable[id]);
		this.__exeEvent('onclick', e, {arg: this.__idtable[id], elm: elm, id: id, owner: this});
	}
	this.__folderPickerWasOpen = gui.frm_main._folderPickerIsOpen();
	this._ondragend();
};

/**
 * @date : 14.7.2006 10:26:591
 **/
_me._onclick = async function(e, elm, id, arg){
	if (arg.processing || arg.unavailable || arg.expired) {
		return;
	}

	var me = this;

	var path, aid, fid, iid, pos;
	if (arg.fullpath) {
		path = Path.split(arg.fullpath, true, true);
		aid = path.aid;
		if (aid === sPrimaryAccount) {
			iid = WMItems.__clientID(path.iid);
			fid = path.fid;
		}
	}

	var sURL = arg.url || (sPrimaryAccountClient + 'server/download.php?' + buildURL({ dlsess: dataSet.get('main', ['dlsess']), class: 'attachment', fullpath: iid ? arg.fullpath + '/' + arg.name : this._fullpath(arg.id) }));

	if (e.type == 'contextmenu' || elm.classList.contains('menu')) {
		if (arg.docref) {
			return;
		}
		var cmenu = await me._gui._create("cmenu","obj_context",'','',this),
			aMenu = [];

		var sID;
		var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
		if (arg.type == 'all') {
			aMenu.push({title: 'ATTACHMENT::DOWNLOAD', css: 'ico2 download', arg: [this, '_saveAll', [this._fullpath()]]});

			if (sPrimaryAccountGW>0 && !arg.shortURL){
				var att = [];
				for(var i in this.__idtable)
					if (this.__idtable[i].id)
						att.push({name: this.__idtable[i].name, size: this.__idtable[i].size, fullpath: this._fullpath(this.__idtable[i].id)});

				if (att.length>0) {
					if (!dgw || dgw.indexOf('f')<0){
						aMenu.push({title: 'ATTACHMENT::SAVE_TO_FOLDER', css: 'ico2 empty_folder', arg: [this, '_saveFolder', [att]]});
					}
					if (Alfresco.enabled()){
						aMenu.push({title: 'ATTACHMENT::SAVE_TO_ALFRESCO', css: 'ico2 empty_folder', arg: [this, '_saveFolderToAlfresco', [att]]});
					}
				}
			}
		}
		else
		if (arg.type == 'certificate'){
			aMenu.push(
				{title: 'ATTACHMENT::DOWNLOAD', css: 'ico2 download', arg: [this, '_save_cert', [this._fullpath()]]},
				{title: 'ATTACHMENT::SHOW_CERT', css: 'ico2 open_view', arg: [this, '_open_cert', [arg]]},
				{title: 'ATTACHMENT::APPEND_CERT', css: 'ico2 add_cert', arg: [Item.addCert, [[this._aid,this._fid,this._iid]]]});
		}
		else{

			if (arg.url) {
				var expiration;
				if (+arg.expiration) {
					expiration = Math.floor((arg.expiration - Math.floor(+new Date() / 1000)) / 24 / 60 / 60);
				}
				aMenu.push({
					title: 'ATTACHMENT::DOWNLOAD',
					css: 'ico2 download',
					arg: [function() {
						ShortURL.resolve({
							url: sURL,
							callback: function(oURL, error) {
								if (error) {
									return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
								}
								var url = oURL ? oURL.url : sURL;

								executeCallbackFunction([downloadItem, [url, true, ~url.indexOf('/webdav/ticket/')]]);
							},
							filename: arg.name
						});
					}]
				}, {
					title: 'ATTACHMENT::SAVE_TO_FOLDER',
					css: 'ico2 empty_folder',
					arg: [function() {
						ShortURL.resolve({
							url: sURL,
							callback: function(oURL, error) {
								if (error) {
									return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
								}
								var url = oURL ? oURL.url : sURL;

								executeCallbackFunction([me, '_saveFolder', [[{ name: arg.name, size: arg.size, fullpath: url, class: 'link', evnuid: WMItems.__serverID(me._iid) + '/' + arg.id }]]]);
							},
							filename: arg.name
						});
					}]
				});
				if (gui.frm_main._dashboardLoaded()) {
					aMenu.push({
						title: 'ATTACHMENT::SAVE_TO_DASHBOARD',
						css: 'ico2 dashboard',
						arg: [function() {
							ShortURL.resolve({
								url: sURL,
								callback: function(oURL, error) {
									if (error) {
										return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
									}
									var url = oURL ? oURL.url : sURL;
	
									executeCallbackFunction([me, '__saveFolder', [sPrimaryAccount, Mapping.getDefaultFolderForGWType('D'), [{ name: arg.name, size: arg.size, fullpath: url, class: 'link', evnuid: WMItems.__serverID(me._iid) + '/' + arg.id }]]]);
								},
								filename: arg.name
							});
						}]
					});
				}

				if (expiration !== void 0) {
					aMenu.push({
						title: '-'
					}, {
						text: ' ',
						subtitle: (expiration ? getLang('ATTACHMENT::LINK_WILL_EXPIRE_IN_DAYS', [expiration]) : getLang('ATTACHMENT::LINK_WILL_EXPIRE_TODAY')),
						css: 'disabled'
					});
				}
				if (arg.allurl)
					aMenu.push({title: 'ATTACHMENT::DOWNLOAD_ALL', css: 'ico2 download', arg: [downloadItem, [arg.allurl, true, ~arg.url.indexOf('/webdav/ticket/')]]});
			}
			else if (!arg.shortURL) {

				switch (Path.extension(arg.name)){
				case 'eml':
					arg.type = 'message/rfc822'; break;
				case 'vcf':
					arg.type = 'text/x-vcard'; break;
				case 'ics':
					arg.type = 'text/x-vcalendar'; break;
				}

				if (arg.type)
					switch(arg.type.toLowerCase()){
					case 'message/rfc822':

						//GW has up to two |, M only max one
						if ((pos = this._iid.lastIndexOf('|'))>-1 && (WMFolders.getType([this._aid, this._fid]) == 'M' || (this._iid.match(/\|/g) || []).length>1))
							sID = this._iid.substr(0,pos+1)+arg.id;
						else
							sID = this._iid+'|'+arg.id;

						aMenu.push({title: 'ATTACHMENT::OPEN_WINDOW', css: 'ico2 open_view', arg: [this, '_open', [this._aid, this._fid, sID]]});
					break;

					case 'text/x-vcalendar':
					case 'text/x-vcard':
						aMenu.push({title: 'ATTACHMENT::IMPORT', css: 'ico2 import', arg: [this, '_import', [this._aid, this._fid, this._iid + '|' + arg.id]]});
					}

				aMenu.push({title: 'ATTACHMENT::DOWNLOAD', css: 'ico2 download', arg: [this, '_save', [this._fullpath(arg.id)]]});
			}

			if (arg.type != 'allsa' && !arg.url){
				if (sPrimaryAccountGW>0){
		            if (!dgw || dgw.indexOf('f')<0)
						aMenu.push({title: 'ATTACHMENT::SAVE_TO_FOLDER', css: 'ico2 empty_folder', arg: [this, '_saveFolder', [[{name: arg.name, size: arg.size, fullpath: this._fullpath(arg.id)}]]]});

					if ((!dgw || dgw.indexOf('f')<0) && gui.frm_main._dashboardLoaded()) {
						aMenu.push({title: 'ATTACHMENT::SAVE_TO_DASHBOARD', css: 'ico2 dashboard', arg: [this, '__saveFolder', [sPrimaryAccount, Mapping.getDefaultFolderForGWType('D'), [{name: arg.name, size: arg.size, fullpath: this._fullpath(arg.id)}]]]});
					}

					if (Alfresco.enabled()){
						aMenu.push({title: 'ATTACHMENT::SAVE_TO_ALFRESCO', css: 'ico2 empty_folder', arg: [this, '_saveFolderToAlfresco', [[{name: arg.name, size: arg.size, fullpath: this._fullpath(arg.id)}]]]});
					}
				}
			}
			sPrimaryAccountCHAT && !arg.shortURL && aMenu.push({title: 'ATTACHMENT::SAVE_TO_TEAMCHAT', css: 'ico2 teamchat', arg:[function(arg) {

				function __uploadhandler(aTo, aBuffer, sName, sDesc) {
					if (aBuffer && aBuffer.length){
						var d = new IcewarpDate(),
							aItemInfo = {values: {}, ATTACHMENTS: []};

						aItemInfo.values.EVNSHARETYPE = 'U';
						aItemInfo.values.EVNCLASS = 'F';
						aItemInfo.values.EVNSTARTDATE = d.format(IcewarpDate.JULIAN);
						aItemInfo.values.EVNSTARTTIME = d.hour()*60 + d.minute();

						if (aBuffer.length == 1){
							aItemInfo.values.EVNRID = aItemInfo.values.EVNLOCATION = aItemInfo.values.EVNTITLE = sName || aBuffer[0].name;
							aItemInfo.values.EVNCOMPLETE = aBuffer[0].size;

							if (Is.String(sDesc) && sDesc.length){
								aItemInfo.values.EVNNOTE = sDesc;
								aItemInfo.values.EVNDESCFORMAT = 'text/plain';
							}
						}

						for (var i = 0, j = aBuffer.length; i < j; i++) {
							aItemInfo.ATTACHMENTS.push({values:aBuffer[i]});
						}

						//Sent to server
						WMItems.add(aTo, aItemInfo,'','','', [function(bOK, aData){
							if (bOK){
								gui.notifier._value({type: 'message_sent_tch', args: [WMFolders.getFolderName({
									aid: aTo[0],
									fid: aTo[1]
								})]});
							} else {
								if(aData === 'item_create') {
									aData = 'ALERTS::FOLDER_INSUFFICIENT_RIGHTS';
								} else {
									aData = 'ERROR::' + aData;
								}
								gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SAVED', text: aData}});
							}
						}]);
					}
				};

				var sFolder;
				var f = dataSet.get('folders', [sPrimaryAccount]);
				for(var id in f){
					if (f[id].TYPE === 'I'){
						sFolder = id;
						break;
					}
				}

				if (sFolder) {
					gui._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
						[function(aid, fid) {
							var __upload_buffer = [{
								'class': 'attachment',
								'description': (arg.name || '').replace(/[<>:/\\|?*""[\]]/g, ''),
								'size': arg.size,
								'fullpath': me._fullpath(arg['id'])
							}];

							gui._create('chat_upload', 'frm_chat_upload', '', '', __upload_buffer[0].description, '', {aid: aid, fid: fid}, [function (sName, sDesc, aArg) {
								__uploadhandler([aid, fid], __upload_buffer, sName, sDesc, aArg);
							}]);
						}], true, true, ['Y','I'], '', true
					);
				}

			}, [arg]]});
		}

		await cmenu._fill(aMenu);

		pos = getSize(elm);
		cmenu._place(pos.x+(pos.w/2),pos.y+pos.h,'',3);
		cmenu._add_destructor('__destructor');
		cmenu.__destructor = function() {
			arg.att.classList.remove('active');
		}
		arg.att.classList.add('active');
	}
	else if (arg.locked) {
		await storage.library('short_url');
		ShortURL.resolve({
			url: sURL,
			callback: function(oURL, error) {
				if (error) {
					return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
				}
				arg.locked = false;
				me._onclick(e, elm, id, arg);
			},
			filename: arg.name,
			doNotTrack: true
		});
	}
	else
	if (arg.type && arg.type.toLowerCase().indexOf('message/rfc822') === 0){

		//GW has up to two |, M only max one
		if ((pos = this._iid.lastIndexOf('|'))>-1 && (WMFolders.getType([this._aid,this._fid]) == 'M' || (this._iid.match(/\|/g) || []).length>1))
			sID = this._iid.substr(0,pos+1)+arg.id;
		else
			sID = this._iid+'|'+arg.id;

		this._open(this._aid,this._fid,sID);
	}
	else
	if (arg.type == 'all')
		this._saveAll(this._fullpath());
	else
	if (arg.type == 'certificate')
        this._open_cert(arg);
	else
	if (aid === sPrimaryAccount) {
		return Item.previewItem([aid, fid, iid], arg.name);
	} else
	if (dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) === "true" && (GWOthers.getItem('DOCUMENTS', 'disable_office') || 0) != 1 && Item.officeSupport(arg.name || arg.url) && (GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').indexOf('f') == -1) {
		this._openOffice(arg);
	}
	else
	if (Path.extension(arg.name) == 'pdf'){
		this._openPDF(arg);
	}
	else
	if (Item.imageSupport(arg.name)) {
		if (arg.url) {
			ShortURL.resolve({
				url: sURL,
				callback: async function(oURL, error) {
					if (error) {
						return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}

					var url = oURL ? oURL.url : sURL;

					await gui._create('imgview', 'frm_imgview');
					await gui.imgview._fill([{
						title: arg.name,
						url: url
					}]);
					gui.imgview._value(0);
				},
				filename: arg.name
			});
		} else {
			await gui._create('imgview', 'frm_imgview');
			await gui.imgview._fill([{
				title: arg.name,
				url: sURL
			}]);
			gui.imgview._value(0);
		}
	}
	else
	if (Item.audioSupport(arg.name) || Item.videoSupport(arg.name)) {
		if (arg.url) {
			ShortURL.resolve({
				url: sURL,
				callback: function(oURL, error) {
					if (error) {
						return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}

					var url = oURL ? oURL.url : sURL;

					Item.playFile([this._aid, this._fid, this._iid], arg.name, arg.id, url);
				}.bind(this),
				filename: arg.name
			});
		} else {
			Item.playFile([this._aid, this._fid, this._iid], arg.name, arg.id, sURL);
		}
	}
	else
	if (arg.url) {
		downloadItem(arg.url, true);
	} else {
		this._save(this._fullpath(arg['id']));
	}
};

_me._fullpath = function(attId) {
	return this._aid+'/'+this._fid+'/'+WMItems.__serverID(this._iid) + (Is.Defined(attId)?'/'+attId:'');
};

/** OPEN **/
_me._open_cert = function (arg){
    if (arg && arg.cert && arg.cert.INFO)
		gui._create('certificate','frm_certificate','','',arg.cert.INFO[0]);
};

_me._open = function(aid,fid,iid){
	OldMessage.openwindow([aid,fid,iid]);
};

/** IMPORT ITEM **/
_me._import = function(aid,fid,iid){
	WMItems.action({aid:aid,fid:fid,iid:iid},'importattachment',[this,'_openImport']);
};
_me._openImport = async function(bOK,xResponse){
	if (bOK){
		var aValues = WMItems.parse(xResponse);
		for(var aid in aValues)
			for (var fid in aValues[aid]){
				delete aValues[aid][fid]['/'];
				delete aValues[aid][fid]['#'];
				delete aValues[aid][fid]['$'];
				delete aValues[aid][fid]['@'];

				for (var iid in aValues[aid][fid]){
					aValues = aValues[aid][fid][iid];

					var frm = await Item.openwindow([aid,fid,iid],aValues);

					frm._userEdited = function() {
						return true; // force save
					};
					//Add destructor
					frm.__removeItem = function(){
						if (!frm.__stored)
							Item.remove([aid,fid,[iid]],true);
					};

					frm._add_destructor('__removeItem');
				}
	        }
	}
	//Import Error
	else{
		try{
			if (xResponse.IQ[0].ERROR[0].ATTRIBUTES.UID == 'item_invalid_type'){
				gui.notifier._value({type: 'alert', args: {header: 'ATTACHMENT::IMPORT', text: 'ATTACHMENT::IMPORT_ERROR'}});
				return;
			}
		}catch(r){ console.log(this._name||false,r);}

		gui.notifier._value({type: 'alert', args: {header: 'ATTACHMENT::IMPORT', text: 'ATTACHMENT::IMPORT_ERROR'}});
/*
[Error]
.. [IQ]
.... [0]
...... [ERROR]
........ [0]
.......... [ATTRIBUTES]
............ [UID](string) = folder_does_not_exist
...... [REQUEST]
........ [0]
...... [ATTRIBUTES]
........ [TYPE](string) = error
 */

	}
};

//download.php?dlsess={dlsess}&class=email_certificate&fullpath={account}/{folder}/{item}
_me._save_cert = function(sFullPath){
	var aUrl = {'dlsess':dataSet.get('main',['dlsess']),'class':'email_certificate','fullpath':sFullPath};
	downloadItem(buildURL(aUrl));
};

_me._save = function(sFullPath) {
	var aUrl = {'dlsess':dataSet.get('main',['dlsess']),'class':'attachment','fullpath':sFullPath};
	downloadItem(buildURL(aUrl));
};

_me._saveAll = function(sFullPath) {
	async function download(arg) {
		if (arg.locked) {
			await storage.library('short_url');
			ShortURL.resolve({
				url: arg.url,
				callback: function(oURL) {
					if (oURL.error) {
						return gui.notifier._value({type: 'alert', args: {header_plain: arg.name, text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}
					arg.locked = false;
					download.call(this, arg);
				}.bind(this),
				filename: arg.name,
				doNotTrack: true
			});
		}
		if (arg.type == 'certificate'){
			this._save_cert(this._fullpath());
		} else if (arg.url) {
			ShortURL.resolve({
				url: arg.url,
				callback: function(oURL) {
					if (oURL.error) {
						return gui.notifier._value({type: 'alert', args: {header_plain: arg.name, text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}
					executeCallbackFunction([downloadItem, [oURL.url, true, ~oURL.url.indexOf('/webdav/ticket/')]]);
				},
				filename: arg.name
			});
		} else if (!arg.shortURL) {
			this._save(this._fullpath(arg.id));
		}
	}

	if (this.__idtable.some(function(att) {
		return att.smart;
	})) {
		for (var i in this.__idtable) {
			if (this.__idtable[i].smart) {
				continue;
			}

			download.call(this, this.__idtable[i]);
		}
		return;
	}

	var aUrl = {'dlsess':dataSet.get('main',['dlsess']),'class':'allattachments','fullpath':sFullPath};
	downloadItem(buildURL(aUrl));
};

_me._openPDF = async function(arg) {
	if (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'STORE_PDF_ATTACHMENTS_IN_UPLOAD_FOLDER') != '1') {
		if (arg.url) {
			await storage.library('short_url');
			return ShortURL.resolve({
				url: arg.url,
				callback: async function(oURL, error) {
					if (error) {
						return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}

					var url = oURL ? oURL.url : arg.url;

					arg.locked = false;

					if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
						downloadItem(url, true);
					} else {
						var frm = await gui._create('pdf', 'frm_pdf');
						frm._load(url, arg.name, void 0, true);
					}
				}.bind(this),
				filename: arg.name
			});
		}

		var url = 'server/download.php?' + buildURL({
			sid: dataSet.get('main',['sid']),
			class: 'attachment',
			fullpath: this._fullpath(arg['id'])
		});
		if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
			downloadItem(url, true);
		} else {
			var frm = await gui._create('pdf', 'frm_pdf');
			frm._load(url, arg.name, void 0, true);
		}
		return;
	}

	var fid = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','smartattach'))[1];
	var partId = WMItems.__serverID(this._iid) + '/' + arg.id;
	WMItems.list({
		aid: sPrimaryAccount,
		fid: fid,
		filter: {
			search: 'partid:"' + partId + '"'
		}
	}, '', '', '', [async function(aData) {
		//Open existing file from Documents
		if ((aData = aData[sPrimaryAccount]) && (aData = aData[fid]) && aData['@'].COUNT > '0') {
			for(var iid in aData) {
				if (iid.length > 1) {
					return Item.previewItem({
						aid: sPrimaryAccount,
						fid: fid,
						iid: iid
					}, arg.name);
				}
			}
		}

		if (arg.url) {
			await storage.library('short_url');
			return ShortURL.resolve({
				url: arg.url,
				callback: function(oURL, error) {
					if (error) {
						return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}

					var url = oURL ? oURL.url : arg.url;

					arg.locked = false;
					
					this.__saveFolder(sPrimaryAccount, fid, [{
						name: arg.name,
						size: arg.size,
						fullpath: url,
						class: 'link',
						evnuid: partId
					}], {
						success: function(result) {
							if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
								downloadItem(url, true);
							} else {
								Item.previewItem({
									aid: sPrimaryAccount,
									fid: fid,
									iid: result.id
								}, arg.name);
							}
						},
						context: this
					});
				}.bind(this),
				filename: arg.name
			});
		}

		this.__saveFolder(sPrimaryAccount, fid, [{
			name: arg.name,
			size: arg.size,
			fullpath: this._fullpath(arg.id),
			evnuid: partId
		}], {
			success: function(result) {
				if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
					downloadItem(url, true);
				} else {
					Item.previewItem({
						aid: sPrimaryAccount,
						fid: fid,
						iid: result.id
					}, arg.name);
				}
			},
			context: this
		});

	}.bind(this)]);
};

_me._openOffice = function(arg){
	var partId = WMItems.__serverID(this._iid) + '/' + arg.id;
	var fid = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','smartattach'))[1];
	WMItems.list({aid: sPrimaryAccount, fid: fid, filter:{search:'partid:"'+ partId +'"'}},'','','',[async function(aData){

		//Open existing file from Documents
		if ((aData = aData[sPrimaryAccount]) && (aData = aData[fid]) && aData['@'].COUNT > '0'){
			for(var iid in aData){
				if (iid.length>1){
					return this.__openOffice(WMItems.__serverID(iid), arg);
				}
			}
		}

		if (arg.url) {
			await storage.library('short_url');
			return ShortURL.resolve({
				url: arg.url,
				callback: function(oURL, error) {
					if (error) {
						return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
					}

					var url = oURL ? oURL.url : arg.url;

					if (oURL && oURL.editable && oURL.collaborationURL) {
						return window.open(oURL.collaborationURL, '_blank');
					}

					arg.locked = false;
					
					this.__saveFolder(sPrimaryAccount, fid, [{
						name: arg.name,
						size: arg.size,
						fullpath: url,
						class: 'link',
						evnuid: partId
					}], {
						success: function(result) {
							this.__openOffice(result.id, objConcat(arg, {name:result.name}));
						},
						context: this
					});
				}.bind(this),
				filename: arg.name
			});
		}

		//save to Documents and Open
		this.__saveFolder(sPrimaryAccount, fid, [{
			name: arg.name,
			size: arg.size,
			fullpath: this._fullpath(arg.id),
			evnuid: partId
		}], {
			success: function(result) {
				this.__openOffice(result.id, objConcat(arg, {name:result.name}));
			},
			context: this
		});

	}.bind(this)]);
};

	_me.__openOffice = function(file_id, arg){
		var fid = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','smartattach'))[1];
		var iid = [
			sPrimaryAccount,
			fid,
			file_id
		];

		var sMode;
		if (~['I', 'Y'].indexOf(WMFolders.getType([this._aid, this._fid]))) {
			sMode = 'view';
		}

		Item.officeOpen({aid: iid[0], fid: iid[1], iid: iid[2], 'EVNTITLE':arg.name}, arg.url ? [downloadItem, [arg.url, true, ~arg.url.indexOf('/webdav/ticket/')]] : [this._save, [this._fullpath(arg.id)]], Path.extension(arg.name), sMode, {
			success: async function(final_cb) {

				var frm = await gui._create('send_back','frm_confirm', '', '', [async function() {

					var messages = await OldMessage.reply({
						id: [this._aid, this._fid, this._iid],
						bSkipCreateComposeWindow: true
						}),
						newMessage = messages._newMessage;

					newMessage.aAttachments = newMessage.aAttachments || {};
					newMessage.aAttachments.attachments = newMessage.aAttachments.attachments || [];

					newMessage.aAttachments.attachments.push({values: {
						'class': 'item',
						fullpath: iid[0] + '/' + iid[1] + '/' + iid[2],// + '/' + encodeURIComponent(arg.name),
						name: arg.name,
						size: arg.size
					}});

					await gui._create('frm_compose', 'frm_compose', '', '', newMessage, messages._oldMessage);

					frm._destruct();

				}.bind(this)], 'COMPOSE::MODIFIED_FILE_TITLE', 'COMPOSE::MODIFIED_FILE_HELPER');

				//Disable OK button untill edit-session is finished
				frm.x_btn_ok._disabled(true);
				removecss(frm.x_btn_ok._main,'ok');
				addcss(frm.x_btn_ok._main,'ico loading');
				frm.x_btn_ok._value('COMMON::YES');

				frm.x_btn_cancel._value('COMMON::NO');

				final_cb.success = function(){
					clearTimeout(timeout);

					if (frm && frm.x_btn_ok) {
						frm.x_btn_ok._disabled(false);
						removecss(frm.x_btn_ok._main,'ico');
					}
				};

				final_cb.error = function(){
					clearTimeout(timeout);

					if (frm && frm.x_btn_ok) {
						frm.x_btn_ok._disabled(true);
						addcss(frm.x_btn_ok._main,'ico');
					}
				};

				var timeout = setTimeout(function(){
					final_cb.success();
				}, 60000);

				//final_cb destructor
				frm._obeyEvent('ondestruct',[function(){
					clearTimeout(timeout);
					final_cb = null;
				}]);
			},
			context: this
		});
	};

_me._saveFolder = function(arg){
	gui._create('select_folder','frm_select_folder','','','POPUP_FOLDERS::SELECT_FOLDER',sPrimaryAccount,Mapping.getDefaultFolderForGWType('F'),[this,'__saveFolder',[arg]],true,false,'F','i');
};

_me._saveFolderToAlfresco = function(arg){
	gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', '@@alfresco@@', Alfresco.getLastFolder(), [this,'__saveFolder',[arg]], true, true, 'K', false, true);
};

_me.__saveFolder = function(aid,fid,arg,callback){
	//DIRECT
	var now = new IcewarpDate(),
		att = [];

	for (var i in arg)
		att.push({
			values:{
				'class': arg[i].class || 'attachment',
				'description':arg[i].name,
				'size':arg[i].size,
				'fullpath':arg[i].fullpath
			}
		});

	WMItems.add([aid,fid],{
		values:{
			'EVNSHARETYPE':GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS','file_sharing'),
			'EVNSTARTDATE':now.format(IcewarpDate.JULIAN),
			'EVNSTARTTIME':now.format(IcewarpDate.JULIAN_TIME),
			'EVNUID':arg[0].evnuid
		},
		duplicity:'rename',
		ATTACHMENTS:att
	},'','','',[
		function(bOK, result){
			//Notify user
			if (bOK && result && result.id){
				callback && callback.success && callback.success.call(callback.context || this, result);
				if (gui.notifier) {
					if (aid === '@@alfresco@@') {
						if (att.length > 1) {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ATTACHMENTS_SAVED_ALFRESCO', [att.length, fid])}});
						} else {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ATTACHMENT_SAVED_ALFRESCO', [att[0].values.description, fid])}});
						}
					} else {
						// gui.notifier._value({type: 'item_saved', args: [aid, fid]});
					}
				}

				//refresh Files folder if active
				var aItems = dataSet.get('items');
				for(var sAccId in aItems)
					for(var sFolId in aItems[sAccId])
						break;

				if (aid == sAccId && fid == sFolId)
					try{
						gui.frm_main.main.list._serverSort({aid:aid,fid:fid});
					}
					catch(r){ console.log(this._name||false,r);}
			}
		}
	]);

};

_me.__initdrag = function(id, x, y) {
	var data = this.__idtable[id];
	if (!data) {
		return;
	}

	gui.frm_main.bar.search._disabled(true);
	this.__activeFolder = dataSet.get('active_folder');
	this.__lastType = gui.frm_main.bar.__lastType;
	gui.frm_main.bar.slide[1].folders._filter_folder('F');
	gui.frm_main.bar._changeFolder(sPrimaryAccount + '/' + Mapping.getDefaultFolderForGWType('F'));
	this.__folderPickerWasOpen = gui.frm_main._folderPickerIsOpen();
	gui.frm_main._openFolderPicker();

	var fullpath = data.fullpath || this._fullpath(data.id);
	if (!fullpath) {
		return;
	}
	gui.frm_main.dnd.create_drag({
		type: 'attachment',
		value: [{
			aid: this._aid,
			fid: this._fid,
			iid: this._iid,
			partid: WMItems.__serverID(this._iid) + '/' + data.id,
			name: data.name,
			size: data.size,
			class: data.url ? 'link' : 'attachment',
			url: data.url,
			fullpath: fullpath,
			type: 'attachment',
			title: data.name
		}],
		x: x,
		y: y,
		obj: this
	});
};

_me._ondragend = function(e) {
	if (e && e.preventDefault) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	}
	if (this.__dndtimer){
		window.clearTimeout(this.__dndtimer);
		delete this.__dndtimer;
	}

	gui.frm_main.bar.search._disabled(false);
	this.__lastType && gui.frm_main.bar.slide[1].folders._filter_folder(this.__lastType);
	this.__activeFolder && gui.frm_main.bar._changeFolder(this.__activeFolder);
	if (!this.__folderPickerWasOpen) {
		gui.frm_main._closeFolderPicker();
	}

	setTimeout(function() {
		gui.__dragging = false;
	}, 5);

	return false;
};
