function NightMode(target_window) {
	var whitelist_rules = [
		'\\.night_mode',
		'#gui::before',

		// calendar 
		'div\\.obj_evnmonth > \\.container p',
		'div\\.obj_context li\\.ico2\\.color.* > a > span::after',
		'\\.obj_datagrid2 \\.obj_datagrid-body div\\.evnfolder \\.',
		'\\.obj_datagrid\\.small \\.obj_datagrid-body .* \\.col_EVNFOLDER',
		'div\\.obj_tree_folder li > div\\.color.* i',
		'div\\.obj_tree_folder2 li > div\\.color.* i',
		'\\.obj_evnview \\.obj_evnview_main div.* div, \\.obj_evnview \\.topAnchor p.* span, \\.obj_evnview \\.topAnchor p',
		'\\.obj_evnview \\.obj_evnview_main div\\.obj_evnviewevn > div',
		'\\.obj_evnview \\.topAnchor p.disabled span',
		'\\.obj_evnview \\.topAnchor p span span',
		'\\.obj_evnview \\.obj_evnview_main div\\.obj_evnviewevn\\.disabled > div',
		'\\.obj_evnview \\.topAnchor p > span',

		// left menu
		'div\\.obj_view_filter',
		'div\\.obj_progress\\.white',

		// right panel
		'.*?\\.frm_main > \\.box > \\.container > \\.right',
		'\\.right',
		'\\.obj_rdock',
		'\\.obj_im',
		'\\.obj_threads_item',
		
		// top menu
		'\\.frm_main.*div\\.obj_hmenu_status',
		// 'div\\.obj_hmenu li\\.ico2 span::before',
		'div\\.obj_hmenu_status',
		'\\.menu2 \\.obj_search \\.application-search-wizard',
		'div\\.obj_hmenu li\\.ico2 span::after',
		'\\.obj_search \\.application-search-wizard \\.submit::after',

		'\\.obj_colorpicker > \\.light::before',
		'\\.frm_imgview',

		// shadows
		'div\\.obj_popup > \\.container::before',
		'div\\.obj_vdock > div\\.active$',
		'div\\.obj_context ul$',
		'^\\.bubble2$',
		'^\\.bubble1$',
		'^div\\.obj_tooltip',
		'\\.application-popover',
		'.addon>.body:after',
		'#gui > \\.obj_notifier div\\.container',
		'div\\.gui_suggest_block::before',
		'\\.obj_groupchat_file \\.addon[iw\\-rounded] \\.ratio\\-wrapper img',

		'\\.obj_initial_loader',
		'\\.obj_dashboard_unavailable',
		'\\.obj_colorpicker',
	];

	var whitelist_frames = [
		'dashboard',
		'fr-iframe',
		'mailview'
	];

	function hexToRgbA(hex) {
		if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)) {
			var c = hex.substring(1).split('');
			if (c.length === 3) {
				c = [c[0], c[0], c[1], c[1], c[2], c[2]];
			}
			c = '0x' + c.join('');
			return 'rgb(' + [(c >> 16) & 255, (c >> 8) & 255, c & 255].join(', ') + ')';
		}
		throw new Error('Bad Hex');
	}

	function rgbToHsl(r, g, b, a) {
		r /= 255, g /= 255, b /= 255;
		var max = Math.max(r, g, b);
		var min = Math.min(r, g, b);
		var h, s, l = (max + min) / 2;

		if (max === min) {
			h = s = 0; // achromatic
		} else {
			var d = max - min;
			s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
			switch (max) {
				case r:
					h = (g - b) / d + (g < b ? 6 : 0);
					break;
				case g:
					h = (b - r) / d + 2;
					break;
				case b:
					h = (r - g) / d + 4;
					break;
			}
			h /= 6;
		}

		return a ? [h, s, l, a] : [h, s, l];
	}

	function hue2rgb(p, q, t) {
		if (t < 0) t += 1;
		if (t > 1) t -= 1;
		if (t < 1 / 6) return p + (q - p) * 6 * t;
		if (t < 1 / 2) return q;
		if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
		return p;
	}

	function hslToRgb(h, s, l) {
		var r, g, b;

		if (s == 0) {
			r = g = b = l; // achromatic
		} else {
			var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
			var p = 2 * l - q;
			r = hue2rgb(p, q, h + 1 / 3);
			g = hue2rgb(p, q, h);
			b = hue2rgb(p, q, h - 1 / 3);
		}

		return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
	}

	function rgbToHex(rgb) {
		if (!(rgb || '').indexOf('#')) {
			return rgb;
		}
		rgb = rgb.match(/(\d+),\s*(\d+),\s*(\d+)/);
		return "#" + ((1 << 24) + (+rgb[1] << 16) + (+rgb[2] << 8) + (+rgb[3])).toString(16).slice(1);
	}

	function normalizeColor(color) {
		if (color.match(rgba_regexp)) {
			return color;
		}
		if (color.match(hex_regexp)) {
			return color.replace(hex_regexp, hexToRgbA);
		}
		if (color.match(colors_regexp)) {
			return color.replace(colors_regexp, function (color) {
				return color_definitions[color.toLowerCase()];
			});
		}
	}

	function propColors(prop_value) {
		return [].concat(prop_value.match(rgba_regexp) || [], prop_value.match(hex_regexp) || [], prop_value.match(colors_regexp) || []);
	}

	function invertColor(color) {
		return normalizeColor(color).replace(rgba_regexp, function (match, schema, r, g, b, a) {
			var hsl = rgbToHsl(r, g, b, a);
			hsl[2] = 1 - (0.88 * hsl[2]);
			var rgb = hslToRgb(hsl[0], hsl[1], hsl[2]);
			return schema + '(' + rgb[0] + ', ' + rgb[1] + ', ' + rgb[2] + (hsl[3] ? ', ' + hsl[3] : '') + ')';
		});
	}

	function invertProperty(rule, prop) {
		if ((rule.selectorText || '').match(whitelist_rules_regex)) {
			return;
		}

		var prop_value = rule.style.getPropertyValue(prop);
		var prop_colors = propColors(prop_value);

		if (prop_colors.length) {
			var priority = rule.style.getPropertyPriority(prop);
			prop_colors.forEach(function(prop_color) {
				prop_value = prop_value.replace(prop_color, invertColor(prop_color));
			});
			return prop + ':' + prop_value + (priority ? '!' + priority : '');
		}
	}

	function walkThruRules(callback, inverted) {
		inverted = inverted || {};
		[].forEach.call(this.target_document.styleSheets, function (style) {
			try {
				[].forEach.call(style.cssRules || [], function (rule) {
					try {
						[].forEach.call(rule.style || [], function (prop) {
							var inv = callback.call(this, rule, prop);
							if (inv) {
								inverted[rule.selectorText] = inverted[rule.selectorText] || [];
								if (!~inverted[rule.selectorText].indexOf(inv)) {
									inverted[rule.selectorText].push(inv);
								}
							}
						}, this);
					} catch {
						//
					}
				}, this);
			} catch {
				//
			}
		}, this);
		return inverted;
	}

	var color_definitions = {
		aliceblue: "rgba(240, 248, 255, 1)",
		antiquewhite: "rgba(250, 235, 215, 1)",
		aqua: "rgba(0, 255, 255, 1)",
		aquamarine: "rgba(127, 255, 212, 1)",
		azure: "rgba(240, 255, 255, 1)",
		beige: "rgba(245, 245, 220, 1)",
		bisque: "rgba(255, 228, 196, 1)",
		black: "rgba(0, 0, 0, 1)",
		blanchedalmond: "rgba(255, 235, 205, 1)",
		blue: "rgba(0, 0, 255, 1)",
		blueviolet: "rgba(138, 43, 226, 1)",
		brown: "rgba(165, 42, 42, 1)",
		burlywood: "rgba(222, 184, 135, 1)",
		cadetblue: "rgba(95, 158, 160, 1)",
		chartreuse: "rgba(127, 255, 0, 1)",
		chocolate: "rgba(210, 105, 30, 1)",
		coral: "rgba(255, 127, 80, 1)",
		cornflowerblue: "rgba(100, 149, 237, 1)",
		cornsilk: "rgba(255, 248, 220, 1)",
		crimson: "rgba(220, 20, 60, 1)",
		cyan: "rgba(0, 255, 255, 1)",
		darkblue: "rgba(0, 0, 139, 1)",
		darkcyan: "rgba(0, 139, 139, 1)",
		darkgoldenrod: "rgba(184, 134, 11, 1)",
		darkgray: "rgba(169, 169, 169, 1)",
		darkgreen: "rgba(0, 100, 0, 1)",
		darkgrey: "rgba(169, 169, 169, 1)",
		darkkhaki: "rgba(189, 183, 107, 1)",
		darkmagenta: "rgba(139, 0, 139, 1)",
		darkolivegreen: "rgba(85, 107, 47, 1)",
		darkorange: "rgba(255, 140, 0, 1)",
		darkorchid: "rgba(153, 50, 204, 1)",
		darkred: "rgba(139, 0, 0, 1)",
		darksalmon: "rgba(233, 150, 122, 1)",
		darkseagreen: "rgba(143, 188, 143, 1)",
		darkslateblue: "rgba(72, 61, 139, 1)",
		darkslategray: "rgba(47, 79, 79, 1)",
		darkslategrey: "rgba(47, 79, 79, 1)",
		darkturquoise: "rgba(0, 206, 209, 1)",
		darkviolet: "rgba(148, 0, 211, 1)",
		deeppink: "rgba(255, 20, 147, 1)",
		deepskyblue: "rgba(0, 191, 255, 1)",
		dimgray: "rgba(105, 105, 105, 1)",
		dimgrey: "rgba(105, 105, 105, 1)",
		dodgerblue: "rgba(30, 144, 255, 1)",
		firebrick: "rgba(178, 34, 34, 1)",
		floralwhite: "rgba(255, 250, 240, 1)",
		forestgreen: "rgba(34, 139, 34, 1)",
		fuchsia: "rgba(255, 0, 255, 1)",
		gainsboro: "rgba(220, 220, 220, 1)",
		ghostwhite: "rgba(248, 248, 255, 1)",
		gold: "rgba(255, 215, 0, 1)",
		goldenrod: "rgba(218, 165, 32, 1)",
		gray: "rgba(128, 128, 128, 1)",
		green: "rgba(0, 128, 0, 1)",
		greenyellow: "rgba(173, 255, 47, 1)",
		grey: "rgba(128, 128, 128, 1)",
		honeydew: "rgba(240, 255, 240, 1)",
		hotpink: "rgba(255, 105, 180, 1)",
		indianred: "rgba(205, 92, 92, 1)",
		indigo: "rgba(75, 0, 130, 1)",
		ivory: "rgba(255, 255, 240, 1)",
		khaki: "rgba(240, 230, 140, 1)",
		lavender: "rgba(230, 230, 250, 1)",
		lavenderblush: "rgba(255, 240, 245, 1)",
		lawngreen: "rgba(124, 252, 0, 1)",
		lemonchiffon: "rgba(255, 250, 205, 1)",
		lightblue: "rgba(173, 216, 230, 1)",
		lightcoral: "rgba(240, 128, 128, 1)",
		lightcyan: "rgba(224, 255, 255, 1)",
		lightgoldenrodyellow: "rgba(250, 250, 210, 1)",
		lightgray: "rgba(211, 211, 211, 1)",
		lightgreen: "rgba(144, 238, 144, 1)",
		lightgrey: "rgba(211, 211, 211, 1)",
		lightpink: "rgba(255, 182, 193, 1)",
		lightsalmon: "rgba(255, 160, 122, 1)",
		lightseagreen: "rgba(32, 178, 170, 1)",
		lightskyblue: "rgba(135, 206, 250, 1)",
		lightslategray: "rgba(119, 136, 153, 1)",
		lightslategrey: "rgba(119, 136, 153, 1)",
		lightsteelblue: "rgba(176, 196, 222, 1)",
		lightyellow: "rgba(255, 255, 224, 1)",
		lime: "rgba(0, 255, 0, 1)",
		limegreen: "rgba(50, 205, 50, 1)",
		linen: "rgba(250, 240, 230, 1)",
		magenta: "rgba(255, 0, 255, 1)",
		maroon: "rgba(128, 0, 0, 1)",
		mediumaquamarine: "rgba(102, 205, 170, 1)",
		mediumblue: "rgba(0, 0, 205, 1)",
		mediumorchid: "rgba(186, 85, 211, 1)",
		mediumpurple: "rgba(147, 112, 219, 1)",
		mediumseagreen: "rgba(60, 179, 113, 1)",
		mediumslateblue: "rgba(123, 104, 238, 1)",
		mediumspringgreen: "rgba(0, 250, 154, 1)",
		mediumturquoise: "rgba(72, 209, 204, 1)",
		mediumvioletred: "rgba(199, 21, 133, 1)",
		midnightblue: "rgba(25, 25, 112, 1)",
		mintcream: "rgba(245, 255, 250, 1)",
		mistyrose: "rgba(255, 228, 225, 1)",
		moccasin: "rgba(255, 228, 181, 1)",
		navajowhite: "rgba(255, 222, 173, 1)",
		navy: "rgba(0, 0, 128, 1)",
		oldlace: "rgba(253, 245, 230, 1)",
		olive: "rgba(128, 128, 0, 1)",
		olivedrab: "rgba(107, 142, 35, 1)",
		orange: "rgba(255, 165, 0, 1)",
		orangered: "rgba(255, 69, 0, 1)",
		orchid: "rgba(218, 112, 214, 1)",
		palegoldenrod: "rgba(238, 232, 170, 1)",
		palegreen: "rgba(152, 251, 152, 1)",
		paleturquoise: "rgba(175, 238, 238, 1)",
		palevioletred: "rgba(219, 112, 147, 1)",
		papayawhip: "rgba(255, 239, 213, 1)",
		peachpuff: "rgba(255, 218, 185, 1)",
		peru: "rgba(205, 133, 63, 1)",
		pink: "rgba(255, 192, 203, 1)",
		plum: "rgba(221, 160, 221, 1)",
		powderblue: "rgba(176, 224, 230, 1)",
		purple: "rgba(128, 0, 128, 1)",
		rebeccapurple: "rgba(102, 51, 153, 1)",
		red: "rgba(255, 0, 0, 1)",
		rosybrown: "rgba(188, 143, 143, 1)",
		royalblue: "rgba(65, 105, 225, 1)",
		saddlebrown: "rgba(139, 69, 19, 1)",
		salmon: "rgba(250, 128, 114, 1)",
		sandybrown: "rgba(244, 164, 96, 1)",
		seagreen: "rgba(46, 139, 87, 1)",
		seashell: "rgba(255, 245, 238, 1)",
		sienna: "rgba(160, 82, 45, 1)",
		silver: "rgba(192, 192, 192, 1)",
		skyblue: "rgba(135, 206, 235, 1)",
		slateblue: "rgba(106, 90, 205, 1)",
		slategray: "rgba(112, 128, 144, 1)",
		slategrey: "rgba(112, 128, 144, 1)",
		snow: "rgba(255, 250, 250, 1)",
		springgreen: "rgba(0, 255, 127, 1)",
		steelblue: "rgba(70, 130, 180, 1)",
		tan: "rgba(210, 180, 140, 1)",
		teal: "rgba(0, 128, 128, 1)",
		thistle: "rgba(216, 191, 216, 1)",
		tomato: "rgba(255, 99, 71, 1)",
		turquoise: "rgba(64, 224, 208, 1)",
		violet: "rgba(238, 130, 238, 1)",
		wheat: "rgba(245, 222, 179, 1)",
		white: "rgba(255, 255, 255, 1)",
		whitesmoke: "rgba(245, 245, 245, 1)",
		yellow: "rgba(255, 255, 0, 1)",
		yellowgreen: "rgba(154, 205, 50, 1)",
	};

	whitelist_rules = whitelist_rules.concat(whitelist_rules.map(function (selector) {
		return '.rtl ' + selector;
	}));

	var whitelist_rules_regex = new RegExp('(^' + whitelist_rules.join(')|(^') + ')', 'gi');
	var hex_regexp = /#[A-Fa-f0-9]{3,6}/g;
	var rgba_regexp = /(rgba?)\((\d+),\s?(\d+),\s?(\d+),?\s?(\d+.?\d*)?\)/g;
	var colors_regexp = new RegExp('\\b' + Object.keys(color_definitions).join('\\b|\\b') + '\\b', 'gi');

	function _NightMode(target_document) {
		this.target_document = target_document || document;

		this.original_dom_rules = {};
		this.original_dom_attributes = {};
		this.dom_counter = 0;

		function inverseDOMStyleProperties(revert) {
			var currentNode;
			var ni = this.target_document.createNodeIterator(this.target_document.documentElement, NodeFilter.SHOW_ELEMENT);
			while ((currentNode = ni.nextNode())) {
				if (!revert && currentNode.id.match(/^night_mode_\d+/)) {
					currentNode.removeAttribute('id');
				}
				['fill', 'stroke', 'color', 'bgcolor'].forEach(function(attribute) {
					if (!currentNode.getAttribute(attribute)) {
						return;
					}
					if (revert) {
						if (this.original_dom_attributes[currentNode.id] && this.original_dom_attributes[currentNode.id][attribute]) {
							currentNode.setAttribute(attribute, this.original_dom_attributes[currentNode.id][attribute]);
						}
					} else {
						if (currentNode.id && this.original_dom_attributes[currentNode.id]) {
							return;
						}
						var value = normalizeColor(currentNode.getAttribute(attribute));
						if (value) {
							if (!currentNode.id) {
								currentNode.id = 'night_mode_' + this.dom_counter++;
							}
							this.original_dom_attributes[currentNode.id] = this.original_dom_rules[currentNode.id] || {};
							this.original_dom_attributes[currentNode.id][attribute] = currentNode.getAttribute(attribute);
							currentNode.setAttribute(attribute, rgbToHex(invertColor(value)));
						}
					}
				}, this);
				[].forEach.call(currentNode.style, function (prop) {
					if (revert) {
						if (this.original_dom_rules[currentNode.id] && this.original_dom_rules[currentNode.id][prop]) {
							currentNode.style[prop] = this.original_dom_rules[currentNode.id][prop];
						}
					} else {
						if (currentNode.id && (this.original_dom_rules[currentNode.id] || {})[prop]) {
							return;
						}
						var prop_value = normalizeColor(currentNode.style.getPropertyValue(prop));
						if (prop_value) {
							if (!currentNode.id) {
								currentNode.id = 'night_mode_' + this.dom_counter++;
							}
							this.original_dom_rules[currentNode.id] = this.original_dom_rules[currentNode.id] || {};
							this.original_dom_rules[currentNode.id][prop] = prop_value;
							currentNode.style[prop] = invertColor(prop_value);
						}
					}
				}.bind(this));
				if (revert && currentNode.id.match(/^night_mode_\d+/)) {
					currentNode.removeAttribute('id');
				}
			}
			if (revert) {
				this.dom_counter = 0;
			}
		};

		this.activate = function (callback, bForce) {
			var event = new CustomEvent('NightMode', {
				detail: {
					enabled: true
				}
			});
			target_window.dispatchEvent(event);

			if ((this.init || this.disabled) && !bForce) {
				callback && callback();
				return this;
			}

			var skipInlineStyles = false;
			if (bForce) {
				this.inverted = {};
				if (this.init) {
					skipInlineStyles = true;
					while(this.init.rules) {
						this.init.deleteRule(0);
					}
				}
			}

			this.init = this.init || this.target_document.createElement('style');
			this.init.classList.add('iw-night_mode');
			this.target_document.head.appendChild(this.init);
			this.target_document.body.classList.add('night_mode');

			this.inverted = walkThruRules.call(this, invertProperty, this.inverted);
			var sheet = this.init.sheet;

			var link = this.target_document.body.querySelector('a');
			var link_color = link && this.target_document.defaultView.getComputedStyle(link).color;
			sheet.insertRule('input, textarea { background-color: #000; color: #fff; }', sheet.cssRules.length);
			// link_color && sheet.insertRule('a, a:visited { color: ' + link_color + '; }', sheet.cssRules.length);

			for (var i in this.inverted) {
				var invertedCssRule = i + '{' + this.inverted[i].join(';') + '}';
				sheet.insertRule(invertedCssRule, sheet.cssRules.length);
			}

			if (!skipInlineStyles) {
				inverseDOMStyleProperties.call(this);
			}

			[].forEach.call(this.target_document.querySelectorAll('iframe'), function (iframe) {
				for (var i in whitelist_frames) {
					if (~iframe.name.indexOf(whitelist_frames[i]) || iframe.classList.contains(whitelist_frames[i])) {
						return;
					}
				}
				if (iframe.contentWindow && Object.keys(iframe.contentWindow).length) {
					NightMode(iframe.contentWindow).activate(false, true);
				}
			});

			this.target_document.documentElement.classList.add('dark');
			callback && callback();
			return this;
		};

		this.reset = function (callback) {
			var event = new CustomEvent('NightMode', {
				detail: {
					enabled: false
				}
			});
			target_window.dispatchEvent(event);

			if (!this.init) {
				callback && callback();
				return this;
			}

			this.init.parentNode && this.init.parentNode.removeChild(this.init);
			this.init = null;
			this.target_document.body.classList.remove('night_mode');
			this.target_document.documentElement.classList.remove('dark');

			inverseDOMStyleProperties.call(this, true);

			this.original_dom_rules = {};
			this.original_dom_attributes = {};
			this.inverted = {};

			[].forEach.call(this.target_document.querySelectorAll('iframe'), function (iframe) {
				for (var i in whitelist_frames) {
					if (~iframe.name.indexOf(whitelist_frames[i]) || iframe.classList.contains(whitelist_frames[i])) {
						return;
					}
				}
				if (iframe.contentWindow && Object.keys(iframe.contentWindow).length) {
					NightMode(iframe.contentWindow).reset();
				}
			});

			callback && callback();
			return this;
		};

		this.enable = function () {
			this.disabled = false;
			return this;
		};

		this.disable = function () {
			this.disabled = true;
			return this;
		};

		this.invertColor = invertColor;

		this.invertStyleProperty = function(prop, color, id) {
			var invertedColor = invertColor(color);
			id = id || ('night_mode_' + this.dom_counter++);
			this.original_dom_rules[id] = this.original_dom_rules[id] || {};
			var props = {
				'border-color': ['border-top-color', 'border-right-color', 'border-bottom-color', 'border-left-color']
			};
			(props[prop] || [prop]).forEach(function(prop) {
				this.original_dom_rules[id][prop] = color;
			}, this);
			return {
				id: id,
				color: invertedColor
			}
		};

		this.invertElementColor = function(currentNode) {
			var invertedAttributes = {};
			var invertedStyle = {};
			['fill', 'stroke', 'color', 'bgcolor'].forEach(function(attribute) {
				if (!currentNode.getAttribute(attribute)) {
					return;
				}
				if (currentNode.id && this.original_dom_attributes[currentNode.id]) {
					return;
				}
				var value = normalizeColor(currentNode.getAttribute(attribute));
				if (value) {
					if (!currentNode.id) {
						currentNode.id = 'night_mode_' + this.dom_counter++;
					}
					this.original_dom_attributes[currentNode.id] = this.original_dom_rules[currentNode.id] || {};
					this.original_dom_attributes[currentNode.id][attribute] = currentNode.getAttribute(attribute);
					var invertedColor = rgbToHex(invertColor(value));
					currentNode.setAttribute(attribute, invertedColor);
					invertedAttributes[attribute] = invertedColor;
				}
			}, this);
			[].forEach.call(currentNode.style, function (prop) {
				if (currentNode.id && (this.original_dom_rules[currentNode.id] || {})[prop]) {
					return;
				}
				var prop_value = normalizeColor(currentNode.style.getPropertyValue(prop));
				if (prop_value) {
					if (!currentNode.id) {
						currentNode.id = 'night_mode_' + this.dom_counter++;
					}
					this.original_dom_rules[currentNode.id] = this.original_dom_rules[currentNode.id] || {};
					this.original_dom_rules[currentNode.id][prop] = prop_value;
					var invertedColor = invertColor(prop_value);
					currentNode.style[prop] = invertedColor;
					invertedStyle[prop] = invertedColor;
				}
			}.bind(this));

			return {
				id: currentNode.id,
				attribute: invertedAttributes,
				style: invertedStyle
			};
		};

		return this;
	};

	target_window = target_window || window;
	try {
		target_window.IW_NM = target_window.IW_NM || new _NightMode(target_window.document);
		return target_window.IW_NM;
	} catch {
		return {
			activate: function() {},
			reset: function() {},
			enable: function() {},
			disable: function() {},
			invertColor: function() {},
			invertStyleProperty: function() {},
			invertElementColor: function() {},
		};
	}
};
