// INIT script

/**
 * @brief : Initial class for IceWarp WebMail
 * @date  : 6.3.2006 19:01:49
 * @status: draft
 * @require: storage
 *

 ? check opener (for valid webmail window)
 - parse input vars to GLOBAL cookie_vars and url_vars
 - choose page ($page <- "login" <- cookie_vars <- url_vars)
 - check ID (!isset than page = login)
 - load settings (if doesnt exist in [opener.]dataset)
 - get Lang (depeds on settings)
 */

function initPRO(aData) {
	this === void 0 && new initPRO().init(aData);
}

initPRO.prototype.init = async function(aLogin) {

	//remove HTML
	document.body.innerHTML = '';

	//remove CSS
	/*
	 var elinks = document.getElementsByTagName('link');
	 for(var i=elinks.length-1;i>=0;i--){
	 elinks[i].disabled = true;
	 elinks[i].parentNode.removeChild(elinks[i]);
	 }
	 */

	//append index.css
	document.head.appendChild(mkElement('link', {rel: 'stylesheet', type: 'text/css', href: 'client/skins/index.css'}));

	//Unique Session ID Number (to avoid avatar img cache)
	window.sSessionUID = unique_id();

	//Create httprequet
	window.request = new cRequest(location.origin + location.pathname + 'server/webmail.php');

	//create gui
	window.gui = new Gui('gui');

	//bind loader to request
	window.request.onstart = function (xhr) {
		gui._loading(xhr, true);
	};
	window.request.onfinish = function (xhr) {
		gui._loading(xhr);
	};


	//registr function to global variable, must be here because it will be used
	window.oWM_INIT = this;

	//allowed content
	var allowed_get = {
		"page": 'index',
		"debug": null,
		"frm": null,
		"sid": null,
		"ref": null,
		"xml": null,
		"username": null,
		"password": null,
		"mailto": null,
		"subject": null,
		"body": null,
		"video": null,
		"conference": null,
		"cc": null,
		"bcc": null,
		'open': null,
		'telemetry': null,
		'from': null,
		'tconly': null,
		"RoomID": null,
		"ThreadID": null,
		"PostID": null,
		tracing: null,
		replay: null,
	};

	function arrKeySlice(arr1,arr2){
		/* create Arrr or object along to arr1 type */
		var k,isa = false,out = [];
		if (arr2.constructor == Array) isa=true;

		if (!arr1 || !arr2) return out;

		for (var i in arr2){
			if (isa)
				k = arr2[i];
			else
				k = i;

			if(!isa && !arr1[k] && arr2[k])
				out[k] = arr2[k];  // TODO: what is it good for?
			else if (typeof arr1[k] != 'undefined')
				out[k] = arr1[k];
		}
		return out;
	};

	//parse cookies and get vars
	gui._REQUEST_VARS = arrConcat(arrKeySlice(aLogin.get, allowed_get), arrKeySlice(parseURL(), allowed_get));

	await gui._create('notifier', 'obj_notifier', '', '', true);

	await gui._create('connection', 'obj_connection');
	this.__setSession(aLogin, async function() {
		await GWOthers.load(['layout_settings']);
		await storage.language(GWOthers.getItem('LAYOUT_SETTINGS', 'language'));
		storage.css('font');
		storage.css('obj_initial_loader', false, async function() {
			await gui._create('preloader', 'obj_initial_loader');
			gui.preloader._value(getLang('PRELOADER::STYLES'));
			//create connection manager
			await this._continueLogin();

			window.Sentry = !1;
			if (window.SentryEnabled) {
				window.SentryFeatures = window.SentryFeatures || [];
				if (gui._REQUEST_VARS.tracing) {
					window.SentryFeatures.push('tracing');
				}
				if (gui._REQUEST_VARS.replay) {
					window.SentryFeatures.push('replay');
				}
				if (gui._REQUEST_VARS.debug) {
					window.SentryFeatures.push('debug');
				}

				await storage.library('js-sdk-loader.min', 'sentry');
				if (window.Sentry) {
					WMAccounts.__getLicense(function() {
						Sentry.init({
							debug: !!gui._REQUEST_VARS.debug,
							environment: window.SentryEnvironment || 'production',
							initialScope: {
								tags: {
									licenseType: dataSet.get('main', ['license_type'])
								},
								user: {
									email: sPrimaryAccount
								}
							},
							release: dataSet.get('main', ['version']),

							sampleRate: 1.0,
							maxBreadcrumbs: 100,
							autoSessionTracking: true,
							tracesSampleRate: 1,
							denyUrls: [
								/^https?:\/\/api.\.*icewarp\.com\/.*\/avatar\//i,
							]
						});
					});
					Sentry.setTag = Sentry.setTag || function() {};
					Sentry.captureException = Sentry.captureException || function() {};
					Sentry.withScope = Sentry.withScope || function() {};
				}
			}

			gui.preloader._value(getLang('PRELOADER::FRAMEWORK'));
			await gui._create('banner', 'obj_banner');

			dataSet.on('folders', [sPrimaryAccount], function(folders){
				for(var key in folders){
					if(folders[key].TYPE === "I" && (!folders[key].SYNC || folders[key].SYNC==='0')){
						folders[key].RECENT = 0;
					}
				}
			});
	
			if (sPrimaryAccountCHAT == '1'){
				function teamchat_listener (set, path){
					if (set === 'folders') {
						if (path && path.length === 1) {
							return;
						}
	
						var recent = Cookie.get(['recent']) || [],
							room_name, index;
	
						if (path && path[path.length - 1] === 'RECENT' && dataSet.get('folders', path.slice(0,2)).TYPE === "I" && dataSet.get('folders', path.slice(0,2)).RECENT !== "0") {
							room_name = path.slice(0, 2).join('/');
							index = recent.indexOf(room_name);
							!!~index && recent.splice(index, 1);
							recent.unshift(room_name);
						}
						Cookie.set(['recent'], recent);
						dataSet.update('cookies', ['recent']);
						return;
					}
				};
				dataSet.on('active_folder', [], teamchat_listener);
				dataSet.on('folders', [], teamchat_listener);
			}
		}.bind(this));
	}.bind(this));
};

initPRO.prototype.__setSession = async function(aLogin, callback) {
	var erString = '';

	var sid = await auth.login({"session": gui._REQUEST_VARS['sid'], "keep": gui._REQUEST_VARS['open'] ? true : false, "from": gui._REQUEST_VARS['from']});

	//Add SID into dataset
	if (sid) {
		dataSet.add('main', ['sid'], sid);
		return callback();
	} else {
		if (Is.Object(auth.error)) {
			switch (auth.error.id) {
				case 'login_account_valid':
					erString = 'ACCOUNT_DISABLED';
					break;
				case 'login_invalid':
				case 'session_no_user':
					document.cookie = 'permanentLogin=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT';
					erString = 'INVALID_LOGIN';
					break;
				case 'session_expired':
					erString = 'EXPIRED';
					break;
				case 'session_ip_mismatch':
					erString = 'IP_MISMATCH';
					break;
				default:
					console.error(auth.error);
					window.Sentry && Sentry.withScope(function(scope) {
						scope.setTag('module', 'session');
						Sentry.captureException(auth.error);
					});
			}
		} else
			erString = 'INVALID_LOGIN';
	}

	//refresh
	this._goBack(arrConcat(aLogin.back || {}, {reason: erString}));
}

initPRO.prototype._goBack = async function (aParam) {
	await storage.library('gw_others');

	var sURL = GWOthers.getItem('LAYOUT_SETTINGS', 'logout_url') || (document.location.protocol + '//' + document.location.hostname + (document.location.port ? ':' + document.location.port : '') + document.location.pathname);
	if (sURL && sURL[0] !== '.' && !sURL.match(/^https?:\/\//)) {
		sURL = document.location.protocol + '//' + sURL;
	}
	if (aParam) {
		var eForm = mkElement('form', {method: 'POST', action: sURL, target: '_self', style: 'position: absolute;top:0;left:0;'});
		for (var i in aParam)
			eForm.appendChild(mkElement('input', {type: 'hidden', name: i, value: aParam[i]}));

		gui._main.appendChild(eForm);

		eForm.submit();
		return;
	}
};

/**
 * Login sequence
 * @note: moved from frm_login (4.7.2007 10:58:11)
 **/
initPRO.prototype._continueLogin = async function () {
	var solid = dataSet.get('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'LOGIN_BACKGROUND_SOLID', 'VALUE']);
	if (solid && solid !== 'false') {
		gui._setTheme(dataSet.get('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'LOGIN_BACKGROUND_COLOR', 'VALUE']));
	} else {
		gui._setTheme(dataSet.get('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'LOGIN_BACKGROUND_COLOR', 'VALUE']), location.origin + location.pathname + 'server/download.php?' + buildURL({
			class: 'background',
			fullpath: location.hostname,
			uid: (dataSet.get('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'LOGIN_BACKGROUND_UID', 'VALUE']) || '').toString().substring(0, 32),
			resize: 1,
			width: Math.max(1280, window.screen.width * window.devicePixelRatio),
			height: Math.max(720, window.screen.height * window.devicePixelRatio)
		}));
	}

	gui._main.classList.add(dataSet.get('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'LOGIN_BACKGROUND_WALLPAPER_SIZE', 'VALUE']));

	gui.preloader._value(getLang('PRELOADER::SETTINGS'));

	var old_skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');
	if (old_skin === 'biggerrtl') {
		old_skin = 'bigger';
	} else if (old_skin === 'banner') {
		old_skin = 'default';
	}

	await GWOthers.load(['skins',
		'banner_options',
		'im',
		'sip',
		'chat',
		'mail_settings_default',
		'mail_settings_general',
		'layout_settings',
		'login_settings',
		'hidden_columns',
		'calendar_settings',
		'default_calendar_settings',
		'cookie_settings',
		'default_reminder_settings',
		'event_settings',
		'spellchecker_languages',
		'signature',
		'groups',
		'restrictions',
		'aliases',
		'read_confirmation',
		'global_settings',
		'paths',
		'streamhost',
		'password_policy',
		'fonts',
		'certificate',
		'timezones',
		'external_settings',
		'gw_mygroup',
		'default_folders',
		'documents',
		'autoresponder',
		'forwarder',
		'custom_backup_form',
		'sound',
		'reset_settings'
	]);

	gui.preloader._value(getLang('PRELOADER::LANGUAGE'));

	// [Sync] load of BIG JavaScript
	if (!gui._REQUEST_VARS.debug) {
		await storage.library('javascript');
	}

	//load font
	storage.css('font');

	//set font variant
	switch(GWOthers.getItem('LAYOUT_SETTINGS', 'font_weight')){
		case 'auto':
			if (!gui.__BROWSER.retina)
				break;
		case 'light':
			addcss(document.body,'light');
	}

	await this._setupCalendar();

	// Clear already downloaded templates
	var skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');
	if (skin === 'biggerrtl') {
		skin = 'bigger';
	} else if (skin === 'banner') {
		skin = 'default';
	}
	if (old_skin != skin)
		storage.aStorage.template = {};

	//preload teamchat api (frm=main)
	await storage.library('team_chat_api');

	// get accounts
	var aAccounts = await WMAccounts.list();
	dataSet.add('accounts', '', aAccounts);

	addEventListener('message', function (e) {
		switch(e.data.event){
			case 'getUser':
				e.source.postMessage({
					event: 'user',
					data: {
						email: sPrimaryAccount,
						name: dataSet.get('main', ['fullname']),
						language: GWOthers.getItem('LAYOUT_SETTINGS', 'language'),
						token: (e.origin === location.origin) && sPrimaryAccountTeamchatToken
					}
				}, '*');
				break;
		}
	});

	//preload icewarp xml api
	await storage.library('json-xml', 'icewarpapi/json-xml');
	await storage.library('processResponse', 'icewarpapi/old-communication');
	await storage.library('callback', 'icewarpapi/callback');
	await storage.library('json-xml', 'icewarpapi/json-xml');
	await storage.library('iq-protocol', 'icewarpapi/iq-protocol');
	await storage.library('request', 'icewarpapi/request');
	await storage.library('xhr-connection', 'icewarpapi/xhr-connection');
	await storage.library('old-communication', 'icewarpapi/old-communication');
	await storage.library('icewarpapi', 'icewarpapi');
	window.icewarpapi = IceWarpAPI();

	// refresh main account & continue preloading...
	this.__refreshed = false;
	WMFolders.list({'aid': sPrimaryAccount, force: true}, 'folders', [sPrimaryAccount], [this, '_updatePreloader']);

	// Convert language codes to iso 639-1 and set as language localisation attribute
	var lang = GWOthers.getItem('LAYOUT_SETTINGS', 'language');
	lang = document.documentElement.lang = isoLanguageCode(lang);
	// Detect text direction
	gui._rtl = !!~['ar', 'fa', 'he'].indexOf(lang);
	if(gui._rtl) {
		document.body.className += ' rtl';
	}

	// Add dropbox functionality if allowed
	var dbappkey = GWOthers.getItem('EXTERNAL_SETTINGS', 'dropbox_app_key') || '';
	if (GWOthers.getItem('RESTRICTIONS', 'disable_dropbox') != '1' && dbappkey.length) {
		var dropbox = document.createElement('script');
		dropbox.type = "text/javascript";
		dropbox.src = "https://www.dropbox.com/static/api/1/dropbox.js";
		dropbox.id = "dropboxjs";
		dropbox.setAttribute('data-app-key', dbappkey);
		document.head.appendChild(dropbox);
	}

	// Load JsSIP module for SIP calls with WebRTC
	if (sPrimaryAccountSIP) {
		await storage.library('sip_bridge');
		if (typeof IceSIP != "undefined" && IceSIP.supported()) {
			dataSet.add('sip', ['state'], 'offline');
			dataSet.add('sip', ['activity'], '');
			if(currentBrowser() === 'Safari')
			await storage.library('AdapterJS', 'sip');
			await storage.library('JsSIP', 'sip');
		} else
			window.JsSIP = null;
	} else
		window.JsSIP = null;

};

initPRO.prototype._setupCalendar = async function() {
	await storage.library('icewarpdate.min', 'calendar');
	IcewarpDate.Locale.setLocaleURL('client/inc/calendar/locale/');
	IcewarpDate.setCalendar(+GWOthers.getItem('LAYOUT_SETTINGS', 'alternative_calendar'), true);
	if (IcewarpDate.setHijriOffset) {
		IcewarpDate.setHijriOffset(+GWOthers.getItem('CALENDAR_SETTINGS', 'hijri_offset'), true);
	}
	IcewarpDate.Locale.changeLocalizedFormat('L', CalendarFormatting.getFormat(+GWOthers.getItem('LAYOUT_SETTINGS', 'date_format')));
	IcewarpDate.Locale.changeLocalizedFormat('LT', +GWOthers.getItem('LAYOUT_SETTINGS', 'time_format') ? 'hh:mm a' : 'HH:mm');

	var language = isoLanguageCode(GWOthers.getItem('LAYOUT_SETTINGS', 'language'));
	switch (language) {
		case 'zh':
			language = 'zh-hk'
			break;
	}
	IcewarpDate.Locale.chooseLocale(language);

	var dow, doy;
	if (GWOthers.getItem('CALENDAR_SETTINGS', 'begin_on_today') != '0') {
		dow = (new IcewarpDate()).day();
	} else {
		dow = {monday: 1, tuesday: 2, wednesday: 3, thursday: 4, friday: 5, saturday: 6, sunday: 0}[GWOthers.getItem('CALENDAR_SETTINGS', 'week_begins')];
	}

	// 7 + dow - janX (first day of January that must belong to the first week of the year)
	switch(+GWOthers.getItem('CALENDAR_SETTINGS', 'week_numbers')) {
		case 1:
			doy = 7 + dow - 1;
			break;
		case 2:
			doy = 7 + dow - 7;
			break;
		case 3:
			doy = 7 + dow - 4;
	}

	IcewarpDate.Locale.setCustomWeekOptions(dow, doy);

	if (GWOthers.getItem('LAYOUT_SETTINGS', 'time_format') > 0) {
		addcss(document.body, 'time_format_long');
	} else {
		removecss(document.body, 'time_format_long');
	}

	var date_format = CalendarFormatting.getFormats()[GWOthers.getItem('LAYOUT_SETTINGS', 'date_format')];
	if (~date_format.indexOf('MMM') || ~date_format.indexOf('YYYY')) {
		addcss(document.body, 'date_format_long');
	} else {
		removecss(document.body, 'date_format_long');
	}
};

initPRO.prototype._updatePreloader = async function (bSkip) {
	var folders = dataSet.get('folders', [sPrimaryAccount]);
	if (!folders) {
		if (bSkip !== true) {
			this.__refreshed = true;
			if (gui.preloader)
				gui.preloader._value(getLang('PRELOADER::INDEXING'));
			WMAccounts.refresh({'aid': sPrimaryAccount}, 'folders', [sPrimaryAccount], [this, '_updatePreloader', [true]]);
			return;
		} else if (window.TeamChatAPI && TeamChatAPI.teamChatOnly()) {
			// missing virtual root for private rooms
			dataSet.add('folders',[sPrimaryAccount, '__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__'], {
				TYPE: 'Y',
				NAME: getLang('FOLDER_TYPES::GROUPCHAT')
			});
			dataSet.add('folders',[sPrimaryAccount, '__@@VIRTUAL@@__/__@@DASHBOARD@@__'], {
				TYPE: 'D',
				// NAME: getLang('FOLDER_TYPES::GROUPCHAT')
			});
		}
	}

	//Create Cookie
	await storage.library('class_cookie');
	window.Cookie = new class_cookie();
	await window.Cookie.init();

	if (gui.preloader)
		gui.preloader._value(getLang('PRELOADER::STARTUP'));

	storage.css('style', true, async function() {
		await storage.library('night_mode');

		if (window.matchMedia && window.matchMedia('(prefers-color-scheme)').matches) {
			if (GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 2) {
				dataSet.add('main', ['night_mode_enabled'], window.matchMedia('(prefers-color-scheme: dark)').matches);
			} else {
				dataSet.add('main', ['night_mode_enabled'], GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 1);
			}

			window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', function(event) {
				if (GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 2) {
					dataSet.add('main', ['night_mode_enabled'], !!event.matches);
					if (event.matches) {
						NightMode().activate();
					} else {
						NightMode().reset();
					}
				}
			});
		} else {
			dataSet.add('main', ['night_mode_enabled'], GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 1);
		}

		if (dataSet.get('main', ['night_mode_enabled'])) {
			NightMode().activate();
		}

		if (!gui._REQUEST_VARS.debug) {
			await storage.template('templates');
			await storage.preloadObj();
		}
		this._updatePreloader2();
	}.bind(this));
};

initPRO.prototype._updatePreloader2 = async function () {
	// Create global custom tooltip
	await gui._create('tooltip','obj_tooltip');

	var folders = dataSet.get('folders', [sPrimaryAccount]);

	if(sPrimaryAccountGUEST && !Object.keys(folders || {}).some(function(folder) {
		return folders[folder].TYPE === 'I';
	})) {
		return await gui._create("confirm", "frm_alert", "", "", [function() {
			frm_main.prototype.__logout();
		}], 'MAIN_MENU::LOGOUT', 'ERROR::MISSING_TEAMCHAT');
	}

	async function detectTimezoneChange(callback) {
		var last_tz = Cookie.get(['tzoffset']),
			new_tz = new IcewarpDate().utcOffset() - (60 * new IcewarpDate().getMoment().isDST());

		Cookie.set(['tzoffset'], new_tz);
		if(last_tz === void 0) {
			callback();
		} else if (sPrimaryAccountGW > 0 && last_tz != new_tz) {
			await gui._create('timezone', 'frm_timezone', 'main', '', [function() {
				callback(true);
			}]);
		} else {
			callback();
		}
	}

	detectTimezoneChange(function() {
		icewarpapi.getToken(function() {
			gui._create('frm_main', 'frm_main', '', '', true);
		});

		TeamChatAPI.init();
	});

	setInterval(function() {
		detectTimezoneChange(function(bTimezoneChanged) {
			bTimezoneChanged && gui._create('frm_confirm', 'frm_confirm', '', '', [function() {
				Cookie.store([function() {
					document.location.reload();
				}], [function() {
					document.location.reload();
				}]);
			}], 'CONFIRMATION::TIMEZONE_CHANGE_TITLE', 'CONFIRMATION::TIMEZONE_CHANGE_RELOAD', void 0, [function() {
				Cookie.store();
			}]);
		});
	}, 5 * 60 * 1000);
};