(function (scope) {
	var index = 0;
	var default_host = '//' + location.host + '/icewarpapi/';
	var OldCommunication = scope.OldCommunication;
	var connection;
	var session_id;

	/**
	 * Create new IceWarpAPI connection
	 * @param {Object} options
	 * @param {String} options.session_id Session under which to authenticate IceWarpAPI connection
	 * @param {String} [option.host] default is `/icewarpapi`
	 */
	scope.IceWarpAPI = function (options) {
		var authenticateRetries = 0;
		var authenticated = false;

		options = options || {};
		options.host = options.host || default_host;

		connection = new OldCommunication(OldCommunication.XHR, 'icewarpapi_' + index++, {
			host: options.host,
			xmlns: 'admin:iq:rpc'
		});

		function authenticate(callback, force) {
			if (authenticated) {
				return scope.Callback(scope.Callback.SUCCESS, callback, connection);
			}
			if (!authenticated || force) {
				connection.iq.removeAttribute('sid');
			}
			connection.send({
				commandname: 'authenticatewebclient',
				commandparams: {
					webclientsessionid: dataSet.get('main', ['sid'])
				}
			}, {
				success: function (result, response) {
					authenticateRetries = 0;
					if (result == 0) {
						return scope.Callback(scope.Callback.ERROR, callback);
					}
					authenticated = true;
					connection.iq.addAttribute('sid', response._attributes.sid);
					session_id = response._attributes.sid;
					scope.Callback(scope.Callback.SUCCESS, callback, connection);
				},
				error: function (error) {
					if (error === 'unspecified' && authenticateRetries++ < 5) {
						return authenticate(callback);
					}
					scope.Callback(scope.Callback.ERROR, callback);
				},
				context: this
			});
		}

		function logout(callback) {
			if (!authenticated) {
				return scope.Callback(scope.Callback.SUCCESS, callback);
			}
			connection.send({
				commandname: 'logout'
			}, callback);
		}

		function getToken(callback, errorCallback) {
			if (!authenticated) {
				return authenticate({
					success: function() {
						getToken(callback, errorCallback);
					},
					error: errorCallback
				});
			}
			icewarpapi.send({
				commandname: 'MakeJWTTokenLogin',
				commandparams: [{
					clientident: 'WC to dashboard'
				}]
			}, {
				success: function (token) {
					icewarpapi.token = {
						access: token.accesstoken,
						refresh: token.refreshtoken
					};
					callback();
				},
				error: errorCallback,
				context: this
			});
		}

		function getLicenseManagementSecret(callback, errorCallback) {
			icewarpapi.send({
				commandname: 'getlicensemanagementsecret'
			}, {
				success: callback,
				error: errorCallback,
				context: this
			});
		}

		function isGuestDomain(domain, callback, errorCallback) {
			icewarpapi.send({
				commandname: 'isguestdomain',
				commandparams: {
					domainstr: domain
				}
			}, {
				success: callback,
				error: errorCallback,
				context: this
			});
		}

		function authenticateTeamChatApi(callback) {
			icewarpapi.send({
				commandname: 'authenticateteamchatapi'
			}, {
				success: function(result) {
					var invalidTCTokens = dataSet.get('temp', ['invalidTCTokens']) || [];
					if (sPrimaryAccountTeamchatToken) {
						invalidTCTokens.push(sPrimaryAccountTeamchatToken);
					}
					dataSet.add('temp', ['invalidTCTokens'], invalidTCTokens);

					sPrimaryAccountTeamchatToken = result;
					callback && callback();
				},
				error: callback,
				context: this
			});
		};

		return {
			authenticate: authenticate,
			logout: logout,
			isAuthenticated: function() {
				return authenticated;
			},
			getToken: getToken,
			getLicenseManagementSecret: getLicenseManagementSecret,
			getSession: function() {
				return session_id;
			},
			authenticateTeamChatApi: authenticateTeamChatApi,
			isGuestDomain: isGuestDomain,
			send: function (data, callback) {
				connection.send(data, {
					success: function (response) {
						scope.Callback(scope.Callback.SUCCESS, callback, response);
					},
					error: function (error) {
						if (error === 'session_invalid') {
							authenticated = false;
							return authenticate({
								success: function() {
									this.send(data, callback);
								},
								context: this
							}, true);
						}
						scope.Callback(scope.Callback.ERROR, callback, error);
					},
					context: this
				});
			}
		}
	};
})(window);
