/**
 * @brief : Graphic User Interface builder
 *          Abstract class for GUI Objects, instances of this class
 *          constructs object tree of whole application
 *
 * @date  : 25.3.2006 16:36:27
 * @status: in development
 *
 * - load page
 * - load css
 * - load js
 * - create container??
 * - load template
 * - exe template
 * - PRINT as invisible
 * - exe JS
 *
 * gui.__focus = boolean; window focus
 *
 */

/*

	!! NEVER ADD OBJECT SPECIFIC CODE IN TO MASTER OBJECT !!

*/

function Gui(sName,sType,oParent,aDocument){

	// PUBLIC
	this._name		= sName;
	this._type		= sType || 'document';
	this._parent	= oParent;
	this._pathName	= (this._parent && this._parent._pathName)?this._parent._pathName + '.' + sName:sName;
	this._destructed = false;

	// for main gui obj. only
	this._anchors  = {'main':''};
	this._template = '';

	// destructors
	this._destructors = {};		// array of destructor methods

	// events handlers
	this._events = {};

	// dataSet properties
	this._listener;				// dataset listener
	this._listenerPath;			// Array - dataset listener path (optional)

	// saving properties
	this._saver = null;			// dataset for storage obj value
	this._saverPath = null;		// Array - dataset path for storage obj value (optional)
	this._skipsaving = false;	// do not save obj. value at all
	this._noupdate = false;		// update dataset after _saveme()

	// update or refresh
	this._norefresh = false;	// in update, fill methods
	this._updateBuffer = false;	// True if there was any update during "norefresh" state

	//Call __root for main gui wrapper init
	if (!sType && !oParent)
		Gui.__root.call(this, aDocument);

	Object.defineProperty(this, '_gui', {
		get: function() {
			var that = this;
			while (!that._main && that._parent) {
				that = that._parent;
			}
			return (that._main && that._main.parentNode) ? (that._main.ownerDocument.defaultView || {}).gui || gui : gui;
		}
	});
};

/**
 * create object structure
 * !! if object is unique than existing instance is destroyed. May be Attr destroy=true for <unigue>...
 *
 *		@target: 	can be string or object	{target:<string>, first:<bool>}
 */
Gui.prototype._create = async function (sName,sType,target,sClass){
	sClass = sClass || '';

	//Do not create child objects in destructed or removed object
	if (this._destructed || (this._main && !this._main.parentNode))
		return false;

	// load object XML descriptor from storage cache
	var sTarget = 'main', i,
		aObj = await storage.object(sType),
		sObj;

	// check parent type for allowed type
	if (aObj.PARENTS){
		var er = true;
		for (i in aObj.PARENTS[0].OBJ)
			if (this._type == aObj.PARENTS[0].OBJ[i].VALUE){
				er = false;
				break;
			}

		if (er)
			throw new Error("await gui._create() -  OBJ "+ sType +"\n disallowed parent "+ this._type);
	}

	// create name for new Gui instnce
	if (aObj.UNIQUE){
		if (typeof this[sName]!='undefined'){
			if (aObj.UNIQUE[0].VALUE == 'keep')
				return this[sName];
			else
				await this[sName]._destruct();
		}
	}
	else{
		//generate name
		var sApx = '';
		for(i=0;;i++){
			if (this[sName+sApx] === undefined){
				sName += sApx;
				break;
			}
			sApx = "_"+i;
		}
		sApx = null;
	}

	// create _main htmlobj in parent's anchor
	if (Is.Defined(target)){
		if (Is.Object(target))
			sTarget = target.target || 'main';
		else
			sTarget = target.toString() || 'main';
	}

	// create instance of Gui
	var newObj = this[sName] = new Gui(sName,sType,this);

	// add anchors pointers (as text representations)
	if (aObj.ANCHORS && typeof(aObj.ANCHORS[0].ELM) != 'undefined'){
		var sAnchor = '', aAnchors = {};
		for (i in aObj.ANCHORS[0].ELM){
			if ((sAnchor = aObj.ANCHORS[0].ELM[i].VALUE))
				aAnchors[sAnchor] = this._pathName + "." + sName + "#" + sAnchor;
		}
		newObj._anchors = aAnchors;
	}

	newObj._anchor = sTarget;

	// create wrapper HTML element
	var chld = false;
	switch(aObj.TYPE?aObj.TYPE[0].VALUE:''){
	case 'none':
		break;
	case 'inline':
		chld = mkElement('span');
		break;
	case 'tr':
		chld = mkElement('tr');
		break;
	case 'td':
		chld = mkElement('td');
		break;
	case 'form'	:
		chld = mkElement('form');
		chld.onsubmit = function(){return false};
		chld.name = newObj._pathName;
		break;
	default:
		chld = mkElement('div');
	}

	if (chld){
		var main;
		if (!(main = this._getAnchor(sTarget))) {
			main = this._getAnchor('main');
			 console.info('Anchor "'+ sTarget +'" doesn\'t exists in "'+ this._type +'" object. Creating in component main.')
		}

		chld.setAttribute('id', newObj._pathName);

		// when target = {first:true}
		if (Is.Object(target)) {
			if (target.first) {
				main.insertAdjacentElement('afterbegin', chld);
			} else if (target.position && target.element) {
				target.element.insertAdjacentElement(target.position, chld);
			} else {
				throw 'Wrong target';
			}
		} else {
			main.appendChild(chld);
		}

		// Container's CSS can be set as name attr. of <object> tag "<type>" is always used as class descriptor
		newObj._css = sClass;
		newObj._allcss = chld.className = (aObj.ATTRIBUTES && aObj.ATTRIBUTES.CSS?aObj.ATTRIBUTES.CSS+' ':'') + sType + (sClass?' '+sClass:'');
		newObj._main = chld;

		main = null;
		chld = null;
	}

	// Prepare Arguments for __constructor
	var aArg = [].slice.call(arguments).splice(4);

	// inherit defined methods from extensions and execute their __constructor methods for BEFORE
	if (aObj.BEFORE){
		for (i in aObj.BEFORE){

			if (newObj && newObj._destructed) return;

			if (aObj.BEFORE[i].ATTRIBUTES && aObj.BEFORE[i].ATTRIBUTES.CLASS)
				sObj = aObj.BEFORE[i].ATTRIBUTES.CLASS;
			else
				sObj = aObj.BEFORE[i].VALUE;

			if (typeof window[sObj] == 'function'){
				inherits(newObj, window[sObj]);

				// do not create object if before.__constructor returns FALSE!
				if (window[sObj].prototype.__constructor && await newObj.__constructor.apply(newObj,aArg) === false){
					await newObj._destruct();
					return;
				}
			}
		}
	}

	// add template name (just template name from XML)
	if (aObj.TEMPLATE && typeof aObj.TEMPLATE[0].VALUE != 'undefined'){

		newObj._template = aObj.TEMPLATE[0].VALUE;

		// DRAW
		if (Is.Defined(this._parent) && Is.Defined(this._parent._aTemplateData))
			await newObj._draw(null,null,this._parent._aTemplateData);
		else
		if (Is.Defined(this._aTemplateData))
			await newObj._draw(null,null,this._aTemplateData);
		else
			await newObj._draw();
	}

	// add destructors
	// may be created before obj. inicialization...!?
	if (aObj.ONUNLOAD)
		for (i in aObj.ONUNLOAD)
			newObj._add_destructor(aObj.ONUNLOAD[i].VALUE,aObj.ONUNLOAD[i].ATTRIBUTES);

	 // inherit defined methods from extensions and execute their __constructor methods for LIRBARY
	if (aObj.LIBRARY) {
		var j;
		for (sObj = '', i = 0, j = aObj.LIBRARY.length; i<j; i++){

			if (newObj && newObj._destructed) return;

			sObj = aObj.LIBRARY[i].VALUE;

			if (aObj.LIBRARY[i].ATTRIBUTES){

				// DO NOT INHERIT obj properties
				if (aObj.LIBRARY[i].ATTRIBUTES.INCLUDE)
					continue;

				if (aObj.LIBRARY[i].ATTRIBUTES.CLASS)
					sObj = aObj.LIBRARY[i].ATTRIBUTES.CLASS;
			}

			if (typeof window[sObj] == 'function'){
				inherits(newObj,window[sObj]);

				if (window[sObj].prototype.__constructor)
					await newObj.__constructor.apply(newObj,aArg);
			}
		}
	}

	// Object was fully constructed
	if (newObj && newObj._finished)
		newObj._finished();

	//Call oncreate Event
	if (this.__onCreateChild)
		this.__onCreateChild(sName,sType,sTarget,sClass);

	newObj && newObj.__setAutoreopenArgs.call(newObj, {
		context: 'gui',
		fun: ['_create'],
		args: [].slice.call(arguments)
	});

	return newObj;
};

/**
 * @param: sTmpName  - optional, name of template
 * 	    Anchor    - optional, can by string or directly DOM element
 **/
Gui.prototype._draw = async function (sTmpName,sTarget,aData,append){

	function rand(n){
		n = n || 10000000000000000;
		return (Math.floor ( Math.random ( ) * n + 1 ));
	};

	if (aData && typeof aData === 'object')
		aData._ins = this._pathName;
	else
		aData = {_ins:this._pathName};

	if (GWOthers)
		aData._skin = 'client/skins/'+GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

	// retrieve template
	var sHtml = await (new cTemplate()).tmp((sTmpName?sTmpName:this._template),aData) || '';

	// parse <OBJ>
	// <obj> can be parsed from gui objects only because of _ins var requirement */
	var id, obj = [], tmpObj = [], sAnchor;

	var xTpl = mkElement('div', {innerHTML:sHtml});

	if (sHtml.indexOf('<obj ')>-1){

		//OBJECTS
		var aList = xTpl.getElementsByTagName("obj");
		if (aList.length){

			var ep,etmp,etmptag,sType,sName;

			/* PRIVATE, <ITEM> -> Array parser
					   @param: etmp - parent dom element */

			function parseitem(etmp){
				var key,n = etmp.getElementsByTagName("item"),
					out1 = [], out2 = {};

				if (!n.length){
					n = null;
					return etmp.textContent || (typeof etmp.text == 'string'?etmp.text.unescapeHTML():null);
				}

				for (var i = 0,l = n.length; i < l ;i++)
					if  ((key = n[i].getAttribute('key')))
						out2[key] = parseitem(n[i]);
					else
						out1.push(parseitem(n[i]));

				n = null;

				return Is.Empty(out2)?out1:out2;
			};

			var prevObj = [];
			for (var i = 0, l = aList.length; i < l; i++){

				ep = aList[i].parentNode;
				sType = aList[i].getAttribute('type');
				sName = aList[i].getAttribute('name');

				if (!sName || !sType) continue;

				// nasted <obj>
				if (ep.tagName === 'OBJ')
					sAnchor = aList[i].getAttribute('anchor') || 'main';
				else{
					// set id to parent HTML elm. & create anchor in parent gui object
					if ((id = ep.getAttribute('id'))){
						sAnchor = inArray(this._anchors,id);
						if (sAnchor == -1){
							do{
								sAnchor = rand();
							}
							while(this._anchors[sAnchor]);

							this._anchors[sAnchor] = id;
						}
					}
					else{
						do{
							sAnchor = rand();
						}
						while(this._anchors[sAnchor]);

						this._anchors[sAnchor] = (this._pathName || '') + "#" + sAnchor;
						ep.setAttribute('id',this._anchors[sAnchor]);
					}
				}

				// CREATE OBJ FOR ARRAY
				tmpObj = {"type":sType,"name":sName,"anchor":sAnchor};

				for(var attrs = aList[i].attributes, iAl = attrs.length; iAl--;) {
					if (tmpObj[attrs[iAl].name] === undefined)
						tmpObj[attrs[iAl].name] = attrs[iAl].value;
				}

				// PARSE OBJECT'S PROPERTIES
				for (var nlen = aList[i].childNodes.length; nlen--;){

					etmp = aList[i].childNodes[nlen];
					if ((etmptag = etmp.tagName?etmp.tagName.toLowerCase():false))
						switch (etmptag){
						case 'readonly':
						case 'disabled':
							var tval = etmp.textContent;
							if (tval && (tval!='false' || tval!='0'))
								tmpObj[etmptag] = true;
							break;

						case 'draw' :
							tmpObj.draw = [etmp.getAttribute('form'),etmp.getAttribute('anchor') || 'main',parseitem (etmp)];
							break;

						// case 'safari_title': //safari is removing <title> tag
						// 	etmptag = 'title';

						case 'restrictions':
						case 'init' :
						case 'fill' :
						case 'value':
						case 'src':
						case 'title':
						case 'text' :
						case 'placeholder' :
							tmpObj[etmptag] = parseitem (etmp);
							break;
						}
				}
				etmp = null;

				// APPEND OBJ INTO ARRAY
				if (ep.tagName.toLowerCase() == 'obj'){

					// child
					for (var iLPos = aList.length; iLPos--;)
						if (aList[iLPos] === ep) break;

					if (prevObj[iLPos].objects)
						prevObj[iLPos].objects.push(tmpObj);
					else
						prevObj[iLPos].objects = [tmpObj];
				}
				else
					obj.push(tmpObj);

				prevObj.push(tmpObj);
				tmpObj = null;
			}
			prevObj = null;

			// REMOVE <OBJ> ELEMENTS FROM TEMPLATE (faster way)
			for(var j = aList.length; j--;)
				aList[j].parentNode.removeChild(aList[j]);

			ep = null;
		}
	}
	else
		sAnchor = sTarget;

	[].forEach.call(xTpl.querySelectorAll('[title]'), function(el) {
		gui.tooltip._add(el, el.getAttribute('title'), {
			y: function() {
				return getSize(this).y - 28
			}.bind(el)
		});
		el.removeAttribute('title');
	});

	var eTarget = sTmpName && sAnchor?this._getAnchor(sTarget):this._main;
	var result = xTpl.firstElementChild;
	if (eTarget){
		//Prepend
		if (append === 2){
			var tmp = eTarget.firstChild || null;
			while(xTpl.firstChild) {
				eTarget.insertBefore(xTpl.firstChild, tmp);
			}
		}
		//Append & Replace
		else{
			//Replace
			if (!append) {
				var children = this._getChildObjects();
				for (var child of children) {
					if (eTarget.contains(child._main)) {
						await child._destruct();
					}
				};
				while(eTarget.firstChild)
					eTarget.removeChild(eTarget.firstChild);
			}

			while(xTpl.firstChild) {
				eTarget.appendChild(xTpl.firstChild);
			}
		}
	}

	eTarget = null;
	xTpl = null;

	// add GUI objects from template
	delete aData._ins;

	if (Is.Empty(aData))
		await this.__addObjects(obj);
	else
		await this.__addObjects(obj,null,aData);

	if (this.__onCreateChild)
		this.__onCreateChild('','',sTarget);

	return result;
};


Gui.prototype.__addObjects = async function(obj,oParent,aData){

	var newObj, aInit, j;
	oParent = oParent || this;

	if (aData)
		this._aTemplateData = aData;

	for (var i = 0, l = obj.length; i<l; i++){

		aInit = [obj[i].name, obj[i].type, obj[i].anchor, obj[i].css];

		// <init> tag
		if (obj[i].init){
			//pole
			if (typeof obj[i].init == 'object'){
				for (j in obj[i].init)
					aInit.push(obj[i].init[j]);
			}
			//string
			else
				aInit.push(obj[i].init);
		}

		if (this._aTemplateData && oParent)
			oParent._aTemplateData = aData;

		newObj = await oParent._create.apply(oParent,aInit);

		// _title
		if (obj[i].title && Is.Function(newObj._title))
			newObj._title(obj[i].title);

		// _text
		if (obj[i].text && Is.Function(newObj._text))
			newObj._text(obj[i].text);

		// _fill
		if (obj[i].fill && Is.Function(newObj._fill))
			await newObj._fill(obj[i].fill);

		// _value
		if (obj[i].value && Is.Function(newObj._value))
			newObj._value(obj[i].value);

		// _src
		if (obj[i].src && Is.Function(newObj._src))
			newObj._src(obj[i].src);

		// READONLY
		if (obj[i].readonly && Is.Function(newObj._readonly))
			newObj._readonly(obj[i].readonly);

		// DISABLED
		if (obj[i].disabled && Is.Function(newObj._disabled))
			newObj._disabled(obj[i].disabled);

		// PLACEHOLDER
		if (obj[i].placeholder && Is.Function(newObj._placeholder))
			newObj._placeholder(obj[i].placeholder);

		// TABINDEX
		if (obj[i].tabindex && Is.Function(newObj._tabIndex))
			newObj._tabIndex(obj[i].tabcontainer,obj[i].tabindex == 'true'?undefined:parseInt(obj[i].tabindex,10));

		// FOCUS
		if (obj[i].focus && Is.Function(newObj._focus))
			newObj._focus(obj[i].focus);

		// WIDTH & HEIGHT
		if ((obj[i].width || obj[i].height) && Is.Function(newObj._size))
			newObj._size(obj[i].width,obj[i].height);

		// RESTRICTIONS
		if ((obj[i].restrictions) && Is.Function(newObj._restrict)){

			var atmp = [];

			if (typeof obj[i].restrictions == 'object'){
				for(j in obj[i].restrictions)
					atmp.push(obj[i].restrictions[j],j);
			}
			else
			if (typeof obj[i].restrictions == 'string')
				atmp.push(obj[i].restrictions);

			try{
				if (atmp.length)
					newObj._restrict.apply(newObj,atmp);
			}
			catch {
				throw "invalid input array for restrictions in:\n"+oParent._pathName+'.'+obj[i].name;
			}
		}

		// _draw
		if (obj[i].draw && Is.Function(newObj._draw))
			if (typeof newObj.__drawTpl != 'undefined' && !newObj._isActive && obj[i].ondemand) {
				newObj.__drawTpl = obj[i].draw;
				newObj.__drawData = aData;
			}
			else{
				aData = arrConcat(aData,obj[i].draw[2]);
				await newObj._draw(obj[i].draw[0],obj[i].draw[1],aData);
				if (newObj._isActive && newObj._active) newObj._active(true);
			}


		// nasted objects
		if (obj[i].objects && obj[i].objects.length)
			if (typeof newObj.__drawObj != 'undefined' && !newObj._isActive && obj[i].ondemand) {
				newObj.__drawObj = obj[i].objects;
				newObj.__drawData = aData;
			}
			else{
				await this.__addObjects(obj[i].objects,newObj,aData);

				if (newObj._isActive && newObj._active)
					newObj._active(true);
			}
	}
};

/**
 *
 * @param:	sType	- event type
 * 			oEvn	- [object,"method",['arg1','arg2',...]]
 *
 *			info	- internal privat scope pourpose
 **/
Gui.prototype._obeyEvent = function(sType, oEvn, info){

	//check if already doesnt exist
	if (this._events[sType])
		this._disobeyEvent(sType, oEvn);
	else
		this._events[sType] = {};

	var id = unique_id();
	this._events[sType][id] = [oEvn, info];

	return id;
};

Gui.prototype._disobeyEvent = function(sType, oEvn){

	var obj = getCallbackFunction(oEvn, true);

	if (Is.Function(obj)){

		if (!this._events[sType])
			return true;

		for (var i in this._events[sType]){
			if (this._events[sType][i]){
				var oEvn_old = this._events[sType][i][0];

				if ((Is.Function(oEvn_old[0]) && Is.Function(oEvn[0]) && oEvn_old[0] === oEvn[0]) ||
					(Is.Function(oEvn_old[1]) && Is.Function(oEvn[1]) && oEvn_old[0] === oEvn[0] && oEvn_old[1] === oEvn[1]) ||
					(oEvn_old[0]._pathName == oEvn[0]._pathName && obj === getCallbackFunction(oEvn_old, true)))
				{
					delete this._events[sType][i];
					return true;
				}
			}
		}
	}

	return false;
};

Gui.prototype.__exeEvent = async function(sType,e,arg){

	if (this._events[sType])
		for (var j in this._events[sType])
			try{
				if (typeof this._events[sType][j] == 'undefined' || !Is.Object(this._events[sType][j][0]) || await executeCallbackFunction(this._events[sType][j][0], e, arg) === false)
					delete this._events[sType][j];
			}
			catch(r){
				//debug
				gui._REQUEST_VARS.frm && console.log('exeEvent', r);
				delete this._events[sType][j];
			}
};


/**
 * @brief : return Array of child objects
 * @param : sAnchor - optional, return childs from this anchor only
 *          sType   - optional, return objects with given type
 * @output: Array of child objects
 * @date  : 30.6.2006 13:39:41
 **/
Gui.prototype._getChildObjects = function(sAnchor,sType){
	var aOut = [];

	if (Is.Defined(sAnchor))
		sAnchor = sAnchor.toString();

	for (var i in this)
		if (i.indexOf('_') != 0 && this[i]/* && this[i]._parent == this*/)
			if ((!sAnchor || this[i]._anchor == sAnchor) && (!sType || this[i]._type == sType))
				aOut.push(this[i]);

	return aOut;
};


/**
 * @brief: destruct all child objects
 * @param: sAnchor
 **/
Gui.prototype._clean = async function(sAnchor,sType){
	var aObj = this._getChildObjects(sAnchor,sType);
	for (var i in aObj)
		await aObj[i]._destruct();

	return true;
};

Gui.prototype._getAnchor = function(sAnchor){
	var doc = (this._main || {}).ownerDocument || document;
	if (Is.Defined(sAnchor))
		sAnchor = sAnchor.toString();

	if (this._anchors[sAnchor])
		return doc.getElementById(this._anchors[sAnchor]);
	else
	if (sAnchor == 'main' || sAnchor == 'self')
		if (this._name === 'gui' && doc !== document) {
			return doc.getElementById('gui');
		} else {
			return this._main;
		}
	else
		return doc.getElementById(this._pathName + (sAnchor?'#' + sAnchor:''));
};

/**
 * obey on given dataset object
 */
Gui.prototype._listen = function(sDataSet,aDataPath,bNoUpdate){
	this._listener = sDataSet;
	if (typeof aDataPath == 'object') this._listenerPath = aDataPath;
	dataSet.obey(this,'_listener',sDataSet,bNoUpdate);
};


Gui.prototype._save = function(sDataSet,aDataPath){
	this._saver = sDataSet;
	if (typeof aDataPath == 'object') this._saverPath = aDataPath;
	dataSet.obey(this,'_saver',sDataSet);
};


Gui.prototype._saveme = function (noupd){
	if (this._skipsaving) return '';
	if (this._noupdate) noupd = this._noupdate;

	if (this._saver){
		dataSet.add(this._saver, this._saverPath, this._value(), noupd, this._pathName);
		return this._saver;
	}
	else
	if (this._listener){
		dataSet.add(this._listener, this._listenerPath, this._value(), noupd, this._pathName);
		return this._listener;
	}
};


Gui.prototype._add_destructor = function (sMethod,aProperties){
	if(!sMethod) return false;
	this._destructors[sMethod] = aProperties;
};


Gui.prototype._remove_destructor = function (sMethod){
	delete this._destructors[sMethod];
};


/**
 * @breif: destruct object
 * @date : 30.6.2006 13:58:51
 **/
Gui.prototype._destruct = async function(){

	if (this._destructed) return;
	this._destructed = true;

	// try to destruct already destructed object
	if (!this._parent[this._name]) return false;

	/*
	1. STEP
	execute all destructors
	useful for _saveall method etc.
	*/
	for (var val in this._destructors)
		if (Is.Function(this[val]))
			await this[val].apply(this, Is.Array(this._destructors[val])?this._destructors[val]:arguments);

	this.__exeEvent('ondestruct', null, {"owner":this});

	/*
	 2. STEP
	 excecute destructors of all childs
	*/
	for (var i in this){
		if (i.indexOf('_')==0 || typeof this[i] != 'object' || this[i]==null || typeof this[i]._destruct != 'function') continue;
		await this[i]._destruct();
		delete this[i];
	}

	// remove listeners
	if (this._listener)
		dataSet.disobey(this);
	if (this._listener_data)
		dataSet.disobey(this,'_listener_data');

	// remove HTML
	try{
		this._main && this._main.parentNode && this._main.parentNode.removeChild(this._main);
	}
	catch(er){ console.log(this._name||false,er)}

	// remove instance
	this._parent[this._name] = null;
	delete this._parent[this._name];

	if (this._parent.__onDestroyChild)
		this._parent.__onDestroyChild(this._name,this._type,this._anchor);

	// finalize object
	this.__exeEvent('destructed', null, this);
};

Gui.prototype.__setAutoreopenArgs = function(aAutoreopenArgs, bForce) {
	if (this.__autoreopen && (!this.__autoreopenArgs || bForce)) {
		this.__autoreopenArgs = aAutoreopenArgs;
		gui.__exeEvent('autoreopenArgs_updated');
	}
};

// root is not inherit into gui descendents
Gui.__root = function(aDocument) {
	var me = this;
	aDocument = aDocument || document;

	this._main = mkElement('div',{
		id: this._name,
		className: GWOthers.getItem('LAYOUT_SETTINGS', 'blurred_background') == 1 ? 'allow-blurred-background' : '',
		style: {
			width:"100%",
			height:"100%",
			overflow:"hidden",
			//Auto-Scroll to Focus hack
			position:"absolute",
			display: 'flex',
			'flex-direction': 'column',
			backgroundPosition: 'center'
		}});

	//Auto-Scroll to Focus hack
	this._main.onscroll = function(e){
		this.scrollTop = 0;
		this.scrollLeft = 0;
		e.preventDefault();
	};

	aDocument.body.appendChild(this._main);

	this.__X = 0;
	this.__Y = 0;

	this.__UNIQ = unique_id();
	this.__BROWSER = {
		touch:false,
		retina:function(){
			var mediaQuery = "(-webkit-min-device-pixel-ratio: 1.5),\
					(min--moz-device-pixel-ratio: 1.5),\
					(-o-min-device-pixel-ratio: 3/2),\
					(min-resolution: 1.5dppx)";
			if (window.devicePixelRatio > 1)
				return true;
			if (window.matchMedia && window.matchMedia(mediaQuery).matches)
				return true;
			return false;
		}()
	};

	// Touch prefix for touch enabled device
	if (('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0)) {
		addcss(this._main, 'touch');
		this.__BROWSER.touch = true;
	}


	//DOCUMENT EVENT Handlers
	function evn (e, sForcedType){
		me.__exeEvent(sForcedType || e.type, e);
	};

	window.onresize = function(e){
		setTimeout(function() {
			evn(e);
		}, 5);
	};

	//changed from document to window, for chrome
	this.__focus = true;
	window.onfocus = function(e){
		me.__focus = true;
		evn(e);
	};
	window.onblur = function(e){
		me.__focus = false;
		evn(e);
	};

	this._isVisible = function() {
		if (this.__visibilityState) {
			return true;
		}

		for(var i in Gui.__detachedWindows) {
			if (Gui.__detachedWindows[i].gui.__visibilityState) {
				return true;
			}
		}
	}
	this.__visibilityState = aDocument.visibilityState === 'visible';
	aDocument.addEventListener('visibilitychange', function(e) {
		// visible if browser tab is active, browser is not minimized and OS session is not locked
		me.__visibilityState = aDocument.visibilityState === 'visible';
		if (gui.__lastVisibleDocument !== e.target) {
			gui.__lastVisibleDocument = e.target;
			gui.__exeEvent('activeWindowChange', e.target.defaultView);
		}
		evn(e);
	}, false);
	window.addEventListener('pagehide', function(e) {
		// safari does not fire visibilitychange event when visibility changed to 'hidden'
		if (!e.persisted) {
			if (!~document.cookie.indexOf('permanentLogin=')) {
				auth.logout(true);
				if (navigator.sendBeacon) {
					var sURL = GWOthers.getItem('LAYOUT_SETTINGS', 'logout_url') || (location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : '') + location.pathname);

					if (window.TeamChatAPI && TeamChatAPI.teamChatOnly()) {
						sURL += '?' + buildURL({tconly:1, token:TeamChatAPI.getToken(), notifyuri:TeamChatAPI.getNotifyURI()});
					}

					navigator.sendBeacon(sURL);
				}
			}
			return;
		}
		me.__visibilityState = false;
		evn(e, 'visibilitychange');
	}, false);

	this.__online = true;
	var offlineNotification;
	var offlineNotificationTimeout;
	aDocument.body.ononline = function(e){
		clearTimeout(offlineNotificationTimeout);
		me.__online = true;
		if (offlineNotification) {
			gui.notifier._closeNotification(offlineNotification);
			offlineNotification = void 0;
		}
		evn(e);
	};
	aDocument.body.onoffline = function(e){
		me.__online = false;
		clearTimeout(offlineNotificationTimeout);
		offlineNotificationTimeout = setTimeout(function() {
			offlineNotification = offlineNotification || gui.notifier._value({
				type: 'offline',
				browserOnly: true
			});
		}, 10000);
		evn(e);
	};

	aDocument.onclick = function(e){
		//Chrome fix...
		if (!me.__focus)
			me.__focus = true;

		evn(e);
	};
	aDocument.oncontextmenu = function(e){
		//Chrome fix...
		if (!me.__focus)
			me.__focus = true;

		evn(e);
	};
	aDocument.onmousedown = evn;
	aDocument.onmouseup = function(e){
		//Chrome fix...
		if (!me.__focus)
			me.__focus = true;

		evn(e);
	};

	//WheelSpin
	AttachEvent(document, "onwheel", function(e){
		var delta;

		if (Is.Defined(e.deltaY))
			delta = e.deltaY;
		else{
			if (e.originalEvent)
				e = e.originalEvent;

			delta = Is.Defined(e.detail)? e.detail : e.wheelDelta/-120;
		}

		evn({type:'wheel', delta:delta});
	});

	aDocument.onmousemove = function(e){
		me.__X = e.clientX;
		me.__Y = e.clientY;

		evn(e);
	};
	aDocument.onkeydown = function (e){
		evn(e);

		//stops F5 (refresh) propagation to browser
		//it caused unwanted refresh(es) because of placement in NB keyboard
		//stops Esc because it cancel actual open http connection
		if (e.keyCode == 116 || e.keyCode == 27){
			e.preventDefault();
			e.stopPropagation();
		}
	};
	aDocument.onkeyup = function (e){
		evn(e);

		//stops Esc because it cancel actual open http connection
		if (e.keyCode == 116 || e.keyCode == 27){
			e.preventDefault();
			e.stopPropagation();
			e.keyCode == 116 && gui.frm_main._getNew && gui.frm_main._getNew();
		}
	};
	aDocument.onpaste = function (e){
		evn(e);
	};

	this.__loading_stack = [];
	this._loading = function(xhr, b){
		var index;
		if (this.__loading_obj){
			if (b) {
				this.__loading_stack.push(xhr);
				setTimeout(this._loading.bind(this, xhr), 5000);
			} else if (~(index = this.__loading_stack.indexOf(xhr))) {
				this.__loading_stack.splice(index, 1);
			}

			try{
				this.__loading_obj._loading(this.__loading_stack.length);
			}
			catch(r){ console.log(this._name||false,r)}
		}
		else
			this.__loading_stack = [];
	};

	window.addEventListener('beforeunload', function() {
		for(var i in Gui.__detachedWindows) {
			var win = Gui.__detachedWindows[i];
			win && !win.closed && win.close();
		}
	});
};

Gui.__detachedWindows = {};

Gui.prototype._detach = function(wWindow) {
	if (this._onbeforedetach) {
		this._onbeforedetach(this.__detach.bind(this, wWindow));
	} else {
		this.__detach(wWindow);
	}
};

Gui.prototype.__detach = function(wWindow) {
	this.__detachedId = unique_id();

	// create new window
	this.__detached = wWindow || window.open(this.__url || '', this.__detachedId);
	if (!this.__detached) {
		return;
	}

	var doc = this.__detached.document;
	focus();
	Gui.__detachedWindows[this.__detachedId] = this.__detached;

	// copy head
	var toLoad = 0;
	[].forEach.call(document.head.children, function(child) {
		var clone = child.cloneNode(true);
		if (clone.tagName === 'LINK' && clone.getAttribute('rel') === 'stylesheet') {
			toLoad++;
			clone.addEventListener('load', function() {
				if (!--toLoad) {
					var NM = NightMode(doc.defaultView);
					if (window.IW_NM && IW_NM.init) {
						NM.activate();
					}
				}
			});
		} else if (clone.tagName === 'STYLE') {
			doc.head.appendChild(clone);
		}
		doc.head.appendChild(clone);
	}, this);

	// move popup to new window
	var new_gui = new Gui('gui', void 0, void 0, doc);
	this.__detached.component = this;
	this.__detached.gui = new_gui;
	this.__detached.opener = this._gui;
	new_gui._main.appendChild(this._main);
	doc.body.appendChild(new_gui._main);
	doc.title = this._title();
	addcss(this._main, 'detached');

	//Drop File, registr Events
	if (window.FormData){
		var frm_main = gui.frm_main;
		doc.addEventListener("dragover", function(e){
			if (frm_main.__filedrag){
				e.preventDefault();

				if (frm_main.__dragtimer == null)
					frm_main.__file_dragover(e);
		        else
		            clearTimeout(frm_main.__dragtimer);

				frm_main.__dragtimer = setTimeout(function(){
					frm_main.__dragtimer = null;
					frm_main.__file_dragover(false);
				},500);
			}
		}, false);

		doc.addEventListener("drop", function(e){ if (frm_main.__filedrag) e.preventDefault(); }, false);

		doc.addEventListener("dragstart", function(){
			frm_main.__filedrag = false;
		}, true);
		doc.addEventListener("dragend", function(){
			frm_main.__filedrag = true;
		}, true);
	}

	this.__detached.onbeforeunload = function(e) {
		switch(GWOthers.getItem('LAYOUT_SETTINGS','confirm_exit').toString()){
			case '1':
				if (this._type !== 'frm_compose')
					break;

			case '2':
				e.preventDefault();
				e.returnValue = getLang('CONFIRMATION::UNLOAD');
				return getLang('CONFIRMATION::UNLOAD');
		}
	}.bind(this);

	this.__detached.onunload = function() {
		this.__detached.onbeforeunload = false;
		this.__detached.opener._disobeyEvent('resize',[this,'__checkPosition']);
		new_gui._disobeyEvent('resize',[this,'__checkPosition']);
		this._destruct();
		for (var i in Gui.__detachedWindows) {
			if (Gui.__detachedWindows[i].component === this) {
				delete Gui.__detachedWindows[i];
			}
		}
	}.bind(this);

	this.__detached.focus();
	gui.__exeEvent('ondetach', new_gui);
	gui.__exeEvent('activeWindowChange', doc.defaultView);
	this._add_destructor('__closeWindowOnDestruct');
	new_gui._obeyEvent('resize',[this,'__checkPosition']);

	addEventListener('NightMode', function(event) {
		if (!this.__detached || this.__detached.closed) {
			return;
		}
		var NM = NightMode(doc.defaultView);
		if (event.detail.enabled) {
			NM.activate();
		} else {
			NM.reset();
		}
	}.bind(this));
};

Gui.prototype.__closeWindowOnDestruct = function() {
	this.__detached && !this.__detached.closed && this.__detached.close();
};

Gui.prototype._setTheme = async function(sColor, sImagePath, bCrossOrigin) {
	await storage.library('extract-colors', 'extract-colors');

	if (GWOthers.getItem('LAYOUT_SETTINGS', 'daily_wallpaper') == '1') {
		var response = await fetch(atob('aHR0cHM6Ly9yYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tL25pdW1vby9iaW5nLXdhbGxwYXBlci9tYWluL2Jpbmctd2FsbHBhcGVyLm1k')).then((response) => {
			if (response.ok) {
				return response.text();
			}
		});
		sImagePath = ((response || '').match(new RegExp((new Date()).toISOString().split('T')[0] + ' \\| \\[.*?\\]\\((.*?)\\)')) || [])[1] || sImagePath;

		this.__dailyBackgroundCheck = setTimeout(function() {
			gui._setTheme();
		}, 3600000);
	} else {
		clearTimeout(this.__dailyBackgroundCheck);
	}

	var eThemeStyle = document.getElementById('iw-theme-background') || mkElement('style', { id: 'iw-theme-background' });

	var sTheme = ':root {';
	if (sColor) {
		sTheme += '--backgroundColor: ' + sColor + ';';
	}
	if (sImagePath) {
		sTheme += '--backgroundImageURL: url(' + sImagePath + ');';
	}
	sTheme += '}';
	
	eThemeStyle.textContent = sTheme;
	document.head.appendChild(eThemeStyle);

	var login_interface_color = GWOthers.getItem('LAYOUT_SETTINGS', 'login_interface_color');
	if (sImagePath) {
		extractColors.extractColorsFromSrc(sImagePath, {
			crossOrigin: bCrossOrigin ? 'anonymous' : false
		}).then(function(swatches) {
			var mostPopulous = swatches[0];
			for (var i in swatches) {
				if (swatches[i].area * swatches[i].intensity * swatches[i].saturation * swatches[i].lightness > mostPopulous.area * mostPopulous.intensity * mostPopulous.saturation * mostPopulous.lightness) {
					mostPopulous = swatches[i];
				}
			}

			var rgb = [mostPopulous.red, mostPopulous.green, mostPopulous.blue];
			var hsl = colors.rgb2hsl.apply(colors, rgb);
			this.__backgroundColor = colors.rgb2hex.apply(colors, colors.hsl2rgb(hsl[0], hsl[1], 0.45));

			if (login_interface_color === 'background') {
				this._setInterfaceColors(this.__backgroundColor);
			} else {
				this._setInterfaceColors(login_interface_color);
			}

		}.bind(this)).catch(function() {
			this.__backgroundColor = sColor || '#702EB7';
			if (login_interface_color === 'background') {
				this._setInterfaceColors(this.__backgroundColor);
			} else {
				this._setInterfaceColors(login_interface_color);
			}
		}.bind(this));

		if (login_interface_color !== 'background') {
			this._setInterfaceColors(login_interface_color, !Gui.__skin_colors.bg_custom);
		}
	} else {
		var hsl = colors.rgb2hsl.apply(colors, colors.hex2rgb(sColor));
		this.__backgroundColor = colors.rgb2hex.apply(colors, colors.hsl2rgb(hsl[0], hsl[1], 0.45));

		if (login_interface_color === 'background') {
			this._setInterfaceColors(this.__backgroundColor);
		} else {
			this._setInterfaceColors(login_interface_color);
		}
	}
};

Gui.__skin_colors = {
	bg_green: "#4FC980",
	bg_important: '#d51414',
	bg_important_darker: '#A44A3E'
};

Gui.prototype._setInterfaceColors = function(hex, bCustom) {
	var rgb = colors.hex2rgb(hex);
	var hsl = colors.rgb2hsl.apply(colors, rgb);

	rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.45);
	hex = colors.rgb2hex(rgb[0], rgb[1], rgb[2]);

	rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.3);
	var hex_dark = colors.rgb2hex(rgb[0], rgb[1], rgb[2]);

	rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.95);
	var hex_light = colors.rgb2hex(rgb[0], rgb[1], rgb[2]);

	Object.assign(Gui.__skin_colors, {
		bg_main: hex,
		bg_main_darker: hex_dark,
		bg_main_lighter: hex_light,
		bg_ok_button: hex,
		bg_ok_button_darker: hex_dark
	});

	if (bCustom) {
		Gui.__skin_colors.bg_custom = hex;
	}

	dataSet.add('main', ['skin_colors'], Gui.__skin_colors);
	dataSet.add('storage', ['LAYOUT_SETTINGS', 'ITEMS', 0, 'VALUES', 'CUSTOM_SKIN_COLORS'], {
		ATTRIBUTES: {
			DONT_SEND: true
		}
	});
	GWOthers.setItem('LAYOUT_SETTINGS', 'custom_skin_colors', JSON.stringify(Gui.__skin_colors));

	var style = ':root{';
	for (var i in Gui.__skin_colors) {
		style += '--' + i + ':' + Gui.__skin_colors[i] + ';';
	}
	if (this.__backgroundColor) {
		style += '--bg_color:' + this.__backgroundColor + ';';
	}
	style += '}';

	if(!document.getElementById('iw-skin-colors')) {
		document.head.appendChild(mkElement('style', { id: 'iw-skin-colors' }));
	}
	document.getElementById('iw-skin-colors').textContent = style;

	if (dataSet.get('main', ['night_mode_enabled'])) {
		NightMode().activate(false, true);
	}
};